﻿local L = EquipEval.L

---------------------------------------------------------------------------------------
-- Fires on main frame events
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_OnEvent()
end

---------------------------------------------------------------------------------------
-- Fires every time the config window is launched
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_Load()
	PlaySound("igMainMenuOpen")
	EquipEvalRatingOptions_SetupForm()
end

---------------------------------------------------------------------------------------
-- Used to populate edit boxes and total box.  Called during load and a default reset
---------------------------------------------------------------------------------------
function EquipEvalRatingOptions_SetupForm()

	--Set up sliders
	EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightDPSSlider:SetValue(EquipEval.db.profile["ItemRatingWeightDPS"])
	EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightMitSlider:SetValue(EquipEval.db.profile["ItemRatingWeightMit"])
	EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightHealSlider:SetValue(EquipEval.db.profile["ItemRatingWeightHeal"])
	
	--Set up check boxes
	EquipEvalRatingOptionsFrameGeneral_RatingsDisplayEnabled:SetChecked(EquipEval.db.profile["DisplayTotalItemRating"])
	
	

end

---------------------------------------------------------------------------------------
-- Fires when addon is first initialized
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_Init()
	--Allows frame to be closed with the Escape key
	tinsert(UISpecialFrames, "EquipEvalRatingOptionsFrame")

	--Dragging involves some special registration
	EquipEvalRatingOptionsFrame:RegisterForDrag("LeftButton");

	-- setup header text to be localized and correct width
	EquipEvalRatingOptionsFrameHeaderFS:SetText("EquipEval Rating Options")
	EquipEvalRatingOptionsFrameHeader:SetWidth(EquipEvalRatingOptionsFrameHeaderFS:GetStringWidth() + 215)

end

---------------------------------------------------------------------------------------
-- Fires when the user clicks save.  Just save all the options down to the profile and/or
-- modify the running addon.
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_Save()
	
	--Save sliders
	EquipEval.db.profile["ItemRatingWeightDPS"] = EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightDPSSlider:GetValue()
	EquipEval.db.profile["ItemRatingWeightMit"] = EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightMitSlider:GetValue()
	EquipEval.db.profile["ItemRatingWeightHeal"] = EquipEvalRatingOptionsFrameGeneral_ItemRatingWeightHealSlider:GetValue()
	
	--Save check boxes
	EquipEval.db.profile["DisplayTotalItemRating"] = EquipEvalRatingOptionsFrameGeneral_RatingsDisplayEnabled:GetChecked()

end

---------------------------------------------------------------------------------------
-- Fires when the user clicks defaults.  This will reset all the edit boxes back to their
-- default values, user still has to click ok
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_SetDefaults()
	
	EquipEval.db.profile["DisplayTotalItemRating"] = EquipEval:GetDefaultValue("DisplayTotalItemRating")
	EquipEval.db.profile["ItemRatingWeightDPS"] = EquipEval:GetDefaultValue("ItemRatingWeightDPS")
	EquipEval.db.profile["ItemRatingWeightMit"] = EquipEval:GetDefaultValue("ItemRatingWeightMit")
	EquipEval.db.profile["ItemRatingWeightHeal"] = EquipEval:GetDefaultValue("ItemRatingWeightHeal")
	
	EquipEvalRatingOptions_SetupForm()
end

---------------------------------------------------------------------------------------
-- Fires when the window closes
---------------------------------------------------------------------------------------
function EquipEvalRatingOptionsFrame_Cancel()
end

