﻿local L = EquipEval.L

---------------------------------------------------------------------------------------
-- Fires on main frame events
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_OnEvent(event, ...)
	local CurTime = GetTime()
	
	if EquipEval.db and EquipEval.db.profile and EquipEval.db.profile["AutoSetHealingVars"] then
		if event == "PLAYER_REGEN_DISABLED" then
			EquipEval.db.profile["PlayerIsInCombat"] = CurTime
			EquipEval.db.profile["PlayerCurrentFightDeltaMana"] = nil
			
		elseif event == "PLAYER_REGEN_ENABLED" then
			local InCombatTime = CurTime - (EquipEval.db.profile["PlayerIsInCombat"] or CurTime)
			local TimeSpentHealing = EquipEval.db.profile["PlayerHealingTime"] or 0
			
			if TimeSpentHealing > EquipEval.db.profile["AutoSetHealingTimeThreshold"] and InCombatTime > 0 then
				local IdleTimeFraction = min(1, max(0, (1 - TimeSpentHealing / InCombatTime)))
				EquipEval.db.profile["PercentIdleTimeWhileHealing"] = ((EquipEval.db.profile["AutoSetIdleTrackingFights"] - 1) * EquipEval.db.profile["PercentIdleTimeWhileHealing"] + IdleTimeFraction * 100) / EquipEval.db.profile["AutoSetIdleTrackingFights"]
				
				if EquipEval.db.profile["PlayerCurrentFightDeltaMana"] then
					local AverageMPS = EquipEval.db.profile["PlayerCurrentFightDeltaMana"] / InCombatTime
					EquipEval.db.profile["AutoSetHealingFightTotalMPS"] = EquipEval.db.profile["AutoSetHealingFightTotalMPS"] or AverageMPS
					EquipEval.db.profile["AutoSetHealingFightTotalMPS"] = ((EquipEval.db.profile["AutoSetIdleTrackingFights"] - 1) * EquipEval.db.profile["AutoSetHealingFightTotalMPS"] + AverageMPS) / EquipEval.db.profile["AutoSetIdleTrackingFights"]
					EquipEval.db.profile["PlayerCurrentFightDeltaMana"] = nil
				end
			end
			
			
			EquipEval.db.profile["PlayerIsInCombat"] = nil
			EquipEval.db.profile["PlayerHealingTime"] = nil
			
		elseif event == "UNIT_MANA" and arg1 == "player" and UnitPowerType("player") == 0 then
			if not EquipEval.db.profile["PlayerLastManaGainTime"] then
				EquipEval.db.profile["PlayerLastManaGainTime"] = CurTime
			end
			
			local TotalTrackedTime = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) + (EquipEval.db.profile["PlayerFullManaRegenTime"] or 0)
			if TotalTrackedTime == 0 then
				EquipEval.db.profile["PlayerCastingManaRegenTime"] = EquipEval.db.profile["AutoSet5SRTrackingSeconds"] * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100
				EquipEval.db.profile["PlayerFullManaRegenTime"] = EquipEval.db.profile["AutoSet5SRTrackingSeconds"] * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100)
			end
					
			local DeltaMana = UnitMana("player") - (EquipEval.db.profile["PlayerLastMana"] or UnitMana("player"))
			local DeltaManaGainTime = CurTime - EquipEval.db.profile["PlayerLastManaGainTime"]
			EquipEval.db.profile["PlayerLastMana"] = UnitMana("player")
			EquipEval.db.profile["PlayerCurrentFightDeltaMana"] = (EquipEval.db.profile["PlayerCurrentFightDeltaMana"] or 0) + DeltaMana
			
			if DeltaMana > 0  then
				EquipEval.db.profile["PlayerLastManaGainTime"] = CurTime
				local TimeSinceCast = CurTime - (EquipEval.db.profile["PlayerLastCastTime"] or 0)
				local TimeSinceFullRegen = max(0, (TimeSinceCast - 5))
				
				if (EquipEval.db.profile["PlayerHealingTime"] or 0) > EquipEval.db.profile["AutoSetHealingTimeThreshold"] then
					if TimeSinceCast >= 5 then
						EquipEval.db.profile["PlayerCastingManaRegenTime"] = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) + (DeltaManaGainTime - min(DeltaManaGainTime, TimeSinceFullRegen))
						EquipEval.db.profile["PlayerFullManaRegenTime"] = (EquipEval.db.profile["PlayerFullManaRegenTime"] or 0) + min(DeltaManaGainTime, TimeSinceFullRegen)
					else
						EquipEval.db.profile["PlayerCastingManaRegenTime"] = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) + DeltaManaGainTime
					end
				end
				
				--Only track limited mana regen in order to keep new values meaningful
				if TotalTrackedTime > EquipEval.db.profile["AutoSet5SRTrackingSeconds"] then
					EquipEval.db.profile["PlayerCastingManaRegenTime"] = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) * (EquipEval.db.profile["AutoSet5SRTrackingSeconds"] / TotalTrackedTime)
					EquipEval.db.profile["PlayerFullManaRegenTime"] = (EquipEval.db.profile["PlayerFullManaRegenTime"] or 0) * (EquipEval.db.profile["AutoSet5SRTrackingSeconds"] / TotalTrackedTime)
				end			
				
				--Set variable
				local TimeFractionIn5SR = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) / ((EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) + (EquipEval.db.profile["PlayerFullManaRegenTime"] or 0))
				TimeFractionIn5SR = max(0, min(1, TimeFractionIn5SR))
				EquipEval.db.profile["PercentTimeIn5SecRule"] = TimeFractionIn5SR * 100
			end
			
			if UnitMana("player") == UnitManaMax("player") then
				EquipEval.db.profile["PlayerLastManaGainTime"] = nil
			end
			
		elseif event == "UNIT_SPELLCAST_SENT" and arg1 == "player" and EquipEval.db.profile["PlayerIsInCombat"] and UnitPowerType("player") == 0 then
			if arg2 ~= "Water Shield" and UnitIsFriend(arg4, "player") then
				EquipEval.db.profile["PlayerStartedCasting"] = CurTime
			end
			
		elseif event == "UNIT_SPELLCAST_STOP" and arg1 == "player" and EquipEval.db.profile["PlayerIsInCombat"] and UnitPowerType("player") == 0 then
			local IdleSeconds = CurTime - (EquipEval.db.profile["PlayerStartedCasting"] or CurTime)
			EquipEval.db.profile["PlayerStartedCasting"] = nil
			
			if IdleSeconds > 0 then
				EquipEval.db.profile["PlayerHealingTime"] = max(0, (EquipEval.db.profile["PlayerHealingTime"] or 0) - IdleSeconds)
			end
			
			
		elseif event == "UNIT_SPELLCAST_SUCCEEDED" and arg1 == "player" and UnitPowerType("player") == 0 then
			local CastingSeconds = CurTime - (EquipEval.db.profile["PlayerStartedCasting"] or CurTime)
			EquipEval.db.profile["PlayerStartedCasting"] = nil
			EquipEval.db.profile["PlayerLastCastTime"] = CurTime
			
			if CastingSeconds > 0 and EquipEval.db.profile["PlayerIsInCombat"] then
				CastingSeconds = max(CastingSeconds, (EquipEval:GetSpellGCD() + EquipEval.db.profile["CastTimePadding"]))
				EquipEval.db.profile["PlayerHealingTime"] = max(0, (EquipEval.db.profile["PlayerHealingTime"] or 0) + CastingSeconds)
			end
		end
	end
end

---------------------------------------------------------------------------------------
-- Fires every time the config window is launched
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_Load()
	PlaySound("igMainMenuOpen")

	EquipEvalOptionsFrameGeneralEnabled:SetChecked(EquipEval:IsActive())
	EquipEvalOptions_SetupEditBoxes()
end

---------------------------------------------------------------------------------------
-- Used to populate edit boxes and total box.  Called during load and a default reset
---------------------------------------------------------------------------------------
function EquipEvalOptions_SetupEditBoxes()
	EquipEvalOptionsFrameGeneralTotal:SetChecked(EquipEval.db.profile["TotalDisplayed"])
	EquipEvalOptionsFrameGeneralCompareGear:SetChecked(EquipEval.db.profile["CompareToCurrentItems"])


	--Set Display Radio Buttons for DPS/Healing
	if not EquipEval.db.profile["DPSDisplayed"] then
		EquipEvalOptionsFrameGeneral_DPSDisplayOption0:SetChecked(1)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayDPSTotal"] <= -2) then
		EquipEvalOptionsFrameGeneral_DPSDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption1:SetChecked(1)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayDPSTotal"] < 0) then
		EquipEvalOptionsFrameGeneral_DPSDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption2:SetChecked(1)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayDPSTotal"] == 0) then
		EquipEvalOptionsFrameGeneral_DPSDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption3:SetChecked(1)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayDPSTotal"] > 0) then
		EquipEvalOptionsFrameGeneral_DPSDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_DPSDisplayOption4:SetChecked(1)
	end
	
	--Set Display Radio Buttons for Healing/Healing
	if not EquipEval.db.profile["HealingDisplayed"] then
		EquipEvalOptionsFrameGeneral_HealingDisplayOption0:SetChecked(1)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayHealingTotal"] <= -2) then
		EquipEvalOptionsFrameGeneral_HealingDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption1:SetChecked(1)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayHealingTotal"] < 0) then
		EquipEvalOptionsFrameGeneral_HealingDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption2:SetChecked(1)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayHealingTotal"] == 0) then
		EquipEvalOptionsFrameGeneral_HealingDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption3:SetChecked(1)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayHealingTotal"] > 0) then
		EquipEvalOptionsFrameGeneral_HealingDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_HealingDisplayOption4:SetChecked(1)
	end

	--Set Display Radio Buttons for TTL/Mitigation
	if not EquipEval.db.profile["MitigationDisplayed"] then
		EquipEvalOptionsFrameGeneral_MitDisplayOption0:SetChecked(1)
		EquipEvalOptionsFrameGeneral_MitDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayMitTotal"] <= -2) then
		EquipEvalOptionsFrameGeneral_MitDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption1:SetChecked(1)
		EquipEvalOptionsFrameGeneral_MitDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayMitTotal"] < 0) then
		EquipEvalOptionsFrameGeneral_MitDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption2:SetChecked(1)
		EquipEvalOptionsFrameGeneral_MitDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayMitTotal"] == 0) then
		EquipEvalOptionsFrameGeneral_MitDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption3:SetChecked(1)
		EquipEvalOptionsFrameGeneral_MitDisplayOption4:SetChecked(nil)
	elseif (EquipEval.db.profile["DisplayMitTotal"] > 0) then
		EquipEvalOptionsFrameGeneral_MitDisplayOption0:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption1:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption2:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption3:SetChecked(nil)
		EquipEvalOptionsFrameGeneral_MitDisplayOption4:SetChecked(1)
	end


	--Set Check Box Values
	EquipEvalOptionsFrameGeneral_ShowDPSSpells:SetChecked(EquipEval.db.profile["ChosenAttacksDisplayed"])
	EquipEvalOptionsFrameGeneral_ShowHealingSpells:SetChecked(EquipEval.db.profile["ChosenHealsDisplayed"])
	EquipEvalOptionsFrameGeneral_ShowHealingDuration:SetChecked(EquipEval.db.profile["HealingDurationDisplayed"])
	if (EquipEval.db.profile["EnemyIsBleedImmune"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_EnemyIsBleedImmuneCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_EnemyIsBleedImmuneCheck:SetChecked(1)
	end
	if (EquipEval.db.profile["EnemyIsPoisonImmune"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_EnemyIsPoisonImmuneCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_EnemyIsPoisonImmuneCheck:SetChecked(1)
	end
	if (EquipEval.db.profile["EnemyIsRootImmune"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_EnemyIsRootImmuneCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_EnemyIsRootImmuneCheck:SetChecked(1)
	end
	if (EquipEval.db.profile["PermanentMangleOnTarget"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_EnemyIsMangledCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_EnemyIsMangledCheck:SetChecked(1)
	end
	if (EquipEval.db.profile["IncludeStrikes"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_IncludeStrikesCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_IncludeStrikesCheck:SetChecked(1)
	end
	if (EquipEval.db.profile["WindfuryTotemUptime"] == 0) then
		EquipEvalOptionsFrameAttributeWeights_SelfHasWindfuryTotemCheck:SetChecked(nil)
	else
		EquipEvalOptionsFrameAttributeWeights_SelfHasWindfuryTotemCheck:SetChecked(1)
	end


	--Set Slider Values
	EquipEvalOptionsFrameAttributeWeights_EnemyLevelDifferenceSlider:SetValue(EquipEval.db.profile["EnemyLevelDifference"])
	EquipEvalOptionsFrameAttributeWeights_BurstFactorSlider:SetValue(EquipEval.db.profile["BurstFactor"])
	EquipEvalOptionsFrameAttributeWeights_FiveSecPercentSlider:SetValue(EquipEval.db.profile["PercentTimeIn5SecRule"])
	EquipEvalOptionsFrameAttributeWeights_HealingIdlePercentSlider:SetValue(EquipEval.db.profile["PercentIdleTimeWhileHealing"])
	EquipEvalOptionsFrameAttributeWeights_ManaVolatilityDampingSlider:SetValue(EquipEval.db.profile["ManaVolatilityDampingFactor"])
	EquipEvalOptionsFrameAttributeWeights_ManaPotionUseSlider:SetValue(EquipEval.db.profile["ManaPotionUse"])
	EquipEvalOptionsFrameAttributeWeights_SpellSelectionCriteriaSlider:SetValue(EquipEval.db.profile["DPMtoDPSBalanceFactor"])
	EquipEvalOptionsFrameAttributeWeights_AdditionalTargetsSlider:SetValue(EquipEval.db.profile["NumberOfAdditionalTargets"])


	--Set Edit Box Values
	EquipEvalOptionsFrameAttributeWeights_EnemyParryPercentEdit:SetNumber(EquipEval.db.profile["EnemyParryPercentage"])
	EquipEvalOptionsFrameAttributeWeights_EnemyDodgePercentEdit:SetNumber(EquipEval.db.profile["EnemyDodgePercentage"])
	EquipEvalOptionsFrameAttributeWeights_EnemyArmorPercentEdit:SetNumber(EquipEval.db.profile["EnemyArmorPercentage"])
	EquipEvalOptionsFrameAttributeWeights_EnemyCritPercentEdit:SetNumber(EquipEval.db.profile["EnemyBaseCritPercentage"])
	EquipEvalOptionsFrameAttributeWeights_EnemyResilienceEdit:SetNumber(EquipEval.db.profile["EnemyResilience"])
	EquipEvalOptionsFrameAttributeWeights_EnemyResistanceEdit:SetNumber(EquipEval.db.profile["EnemyResistance"])
	EquipEvalOptionsFrameAttributeWeights_EnemyArmorPenetrationEdit:SetNumber(EquipEval.db.profile["EnemyArmorPenetration"])

	EquipEvalOptionsFrameAttributeWeights_BonusHitEdit:SetNumber(EquipEval.db.profile["BonusHitPercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusStatEdit:SetNumber(EquipEval.db.profile["BonusStatPercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusSpellCritEdit:SetNumber(EquipEval.db.profile["BonusSpellCritChancePercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusCritEdit:SetNumber(EquipEval.db.profile["BonusCritChancePercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusAPEdit:SetNumber(EquipEval.db.profile["BonusAP"])
	EquipEvalOptionsFrameAttributeWeights_BonusAPPercentEdit:SetNumber(EquipEval.db.profile["BonusAPPercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusHPEdit:SetNumber(EquipEval.db.profile["BonusHP"])
	EquipEvalOptionsFrameAttributeWeights_BonusSpellHitEdit:SetNumber(EquipEval.db.profile["BonusSpellHitPercent"])
	EquipEvalOptionsFrameAttributeWeights_BonusManaEdit:SetNumber(EquipEval.db.profile["BonusMana"])
	EquipEvalOptionsFrameAttributeWeights_BonusMP5Edit:SetNumber(EquipEval.db.profile["BonusMP5"])
	EquipEvalOptionsFrameAttributeWeights_BonusSpellDamageEdit:SetNumber(EquipEval.db.profile["BonusSpellDamage"])



end

---------------------------------------------------------------------------------------
-- Fires when addon is first initialized
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_Init()
	--Allows frame to be closed with the Escape key
	tinsert(UISpecialFrames, "EquipEvalOptionsFrame")

	--Dragging involves some special registration
	EquipEvalOptionsFrame:RegisterForDrag("LeftButton");

	-- setup header text to be localized and correct width
	EquipEvalOptionsFrameHeaderFS:SetText(L["EquipEval Options"])
	EquipEvalOptionsFrameHeader:SetWidth(EquipEvalOptionsFrameHeaderFS:GetStringWidth() + 215)

	--Register events to do automatic variable setting
	this:RegisterEvent("PLAYER_REGEN_ENABLED")
	this:RegisterEvent("PLAYER_REGEN_DISABLED")
	this:RegisterEvent("UNIT_MANA")
	this:RegisterEvent("UNIT_SPELLCAST_SENT")
	this:RegisterEvent("UNIT_SPELLCAST_STOP")
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
end

---------------------------------------------------------------------------------------
-- Fires when the user clicks save.  Just save all the options down to the profile and/or
-- modify the running addon.
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_Save()
	-- enable or disable the addon
	EquipEval:ToggleActive(EquipEvalOptions_CheckToBool(EquipEvalOptionsFrameGeneralEnabled))

	-- enable or disable the total
	EquipEval.db.profile["TotalDisplayed"]=EquipEvalOptions_CheckToBool(EquipEvalOptionsFrameGeneralTotal)
	
	EquipEval.db.profile["CompareToCurrentItems"]=EquipEvalOptions_CheckToBool(EquipEvalOptionsFrameGeneralCompareGear)

	-- set values from edit boxes
	EquipEval.db.profile["EnemyParryPercentage"] = EquipEvalOptionsFrameAttributeWeights_EnemyParryPercentEdit:GetNumber()
	EquipEval.db.profile["EnemyDodgePercentage"] = EquipEvalOptionsFrameAttributeWeights_EnemyDodgePercentEdit:GetNumber()
	EquipEval.db.profile["EnemyArmorPercentage"] = EquipEvalOptionsFrameAttributeWeights_EnemyArmorPercentEdit:GetNumber()
	EquipEval.db.profile["EnemyBaseCritPercentage"] = EquipEvalOptionsFrameAttributeWeights_EnemyCritPercentEdit:GetNumber()
	EquipEval.db.profile["EnemyResilience"] = EquipEvalOptionsFrameAttributeWeights_EnemyResilienceEdit:GetNumber()
	EquipEval.db.profile["EnemyResistance"] = EquipEvalOptionsFrameAttributeWeights_EnemyResistanceEdit:GetNumber()
	EquipEval.db.profile["EnemyArmorPenetration"] = EquipEvalOptionsFrameAttributeWeights_EnemyArmorPenetrationEdit:GetNumber()

	EquipEval.db.profile["BonusHitPercent"] = EquipEvalOptionsFrameAttributeWeights_BonusHitEdit:GetNumber()
	EquipEval.db.profile["BonusStatPercent"] = EquipEvalOptionsFrameAttributeWeights_BonusStatEdit:GetNumber()
	EquipEval.db.profile["BonusSpellCritChancePercent"] = EquipEvalOptionsFrameAttributeWeights_BonusSpellCritEdit:GetNumber()
	EquipEval.db.profile["BonusCritChancePercent"] = EquipEvalOptionsFrameAttributeWeights_BonusCritEdit:GetNumber()
	EquipEval.db.profile["BonusAP"] = EquipEvalOptionsFrameAttributeWeights_BonusAPEdit:GetNumber()
	EquipEval.db.profile["BonusAPPercent"] = EquipEvalOptionsFrameAttributeWeights_BonusAPPercentEdit:GetNumber()
	EquipEval.db.profile["BonusHP"] = EquipEvalOptionsFrameAttributeWeights_BonusHPEdit:GetNumber()
	EquipEval.db.profile["BonusSpellHitPercent"] = EquipEvalOptionsFrameAttributeWeights_BonusSpellHitEdit:GetNumber()
	EquipEval.db.profile["BonusMana"] = EquipEvalOptionsFrameAttributeWeights_BonusManaEdit:GetNumber()
	EquipEval.db.profile["BonusMP5"] = EquipEvalOptionsFrameAttributeWeights_BonusMP5Edit:GetNumber()
	EquipEval.db.profile["BonusSpellDamage"] = EquipEvalOptionsFrameAttributeWeights_BonusSpellDamageEdit:GetNumber()



	-- set values from check boxes
	EquipEval.db.profile["ChosenAttacksDisplayed"] = EquipEvalOptionsFrameGeneral_ShowDPSSpells:GetChecked()
	EquipEval.db.profile["ChosenHealsDisplayed"] = EquipEvalOptionsFrameGeneral_ShowHealingSpells:GetChecked()
	EquipEval.db.profile["HealingDurationDisplayed"] = EquipEvalOptionsFrameGeneral_ShowHealingDuration:GetChecked()
	if EquipEvalOptionsFrameAttributeWeights_EnemyIsBleedImmuneCheck:GetChecked() then
		EquipEval.db.profile["EnemyIsBleedImmune"] = 1
	else
		EquipEval.db.profile["EnemyIsBleedImmune"] = 0
	end
	if EquipEvalOptionsFrameAttributeWeights_EnemyIsPoisonImmuneCheck:GetChecked() then
		EquipEval.db.profile["EnemyIsPoisonImmune"] = 1
	else
		EquipEval.db.profile["EnemyIsPoisonImmune"] = 0
	end
	if EquipEvalOptionsFrameAttributeWeights_EnemyIsRootImmuneCheck:GetChecked() then
		EquipEval.db.profile["EnemyIsRootImmune"] = 1
	else
		EquipEval.db.profile["EnemyIsRootImmune"] = 0
	end
	if EquipEvalOptionsFrameAttributeWeights_EnemyIsMangledCheck:GetChecked() then
		EquipEval.db.profile["PermanentMangleOnTarget"] = 1
	else
		EquipEval.db.profile["PermanentMangleOnTarget"] = 0
	end
	if EquipEvalOptionsFrameAttributeWeights_IncludeStrikesCheck:GetChecked() then
		EquipEval.db.profile["IncludeStrikes"] = 1
	else
		EquipEval.db.profile["IncludeStrikes"] = 0
	end
	if EquipEvalOptionsFrameAttributeWeights_SelfHasWindfuryTotemCheck:GetChecked() then
		EquipEval.db.profile["WindfuryTotemUptime"] = 1
	else
		EquipEval.db.profile["WindfuryTotemUptime"] = 0
	end

	-- set values from sliders
	EquipEval.db.profile["EnemyLevelDifference"] = EquipEvalOptionsFrameAttributeWeights_EnemyLevelDifferenceSlider:GetValue()
	EquipEval.db.profile["BurstFactor"] = EquipEvalOptionsFrameAttributeWeights_BurstFactorSlider:GetValue()
	EquipEval.db.profile["PercentTimeIn5SecRule"] = EquipEvalOptionsFrameAttributeWeights_FiveSecPercentSlider:GetValue()
	EquipEval.db.profile["PercentIdleTimeWhileHealing"] = EquipEvalOptionsFrameAttributeWeights_HealingIdlePercentSlider:GetValue()
	EquipEval.db.profile["ManaVolatilityDampingFactor"] = EquipEvalOptionsFrameAttributeWeights_ManaVolatilityDampingSlider:GetValue()
	EquipEval.db.profile["ManaPotionUse"] = EquipEvalOptionsFrameAttributeWeights_ManaPotionUseSlider:GetValue()
	EquipEval.db.profile["DPMtoDPSBalanceFactor"] = EquipEvalOptionsFrameAttributeWeights_SpellSelectionCriteriaSlider:GetValue()
	EquipEval.db.profile["NumberOfAdditionalTargets"] = EquipEvalOptionsFrameAttributeWeights_AdditionalTargetsSlider:GetValue()
	
	--Adjust history values based on new settings
	local TotalTime = (EquipEval.db.profile["PlayerCastingManaRegenTime"] or 0) + (EquipEval.db.profile["PlayerFullManaRegenTime"] or 0)
	EquipEval.db.profile["PlayerCastingManaRegenTime"] = EquipEval.db.profile["PercentTimeIn5SecRule"] / 100 * TotalTime
	EquipEval.db.profile["PlayerFullManaRegenTime"] = (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) * TotalTime
	
						


	-- set values from radio buttons
	EquipEval.db.profile["DPSDisplayed"] = not EquipEvalOptionsFrameGeneral_DPSDisplayOption0:GetChecked()
	if EquipEvalOptionsFrameGeneral_DPSDisplayOption1:GetChecked() then
		EquipEval.db.profile["DisplayDPSTotal"] = -2
	elseif EquipEvalOptionsFrameGeneral_DPSDisplayOption2:GetChecked() then
		EquipEval.db.profile["DisplayDPSTotal"] = -1
	elseif EquipEvalOptionsFrameGeneral_DPSDisplayOption3:GetChecked() then
		EquipEval.db.profile["DisplayDPSTotal"] = 0
	elseif EquipEvalOptionsFrameGeneral_DPSDisplayOption4:GetChecked() then
		EquipEval.db.profile["DisplayDPSTotal"] = 1
	end
	
	EquipEval.db.profile["HealingDisplayed"] = not EquipEvalOptionsFrameGeneral_HealingDisplayOption0:GetChecked()
	if EquipEvalOptionsFrameGeneral_HealingDisplayOption1:GetChecked() then
		EquipEval.db.profile["DisplayHealingTotal"] = -2
	elseif EquipEvalOptionsFrameGeneral_HealingDisplayOption2:GetChecked() then
		EquipEval.db.profile["DisplayHealingTotal"] = -1
	elseif EquipEvalOptionsFrameGeneral_HealingDisplayOption3:GetChecked() then
		EquipEval.db.profile["DisplayHealingTotal"] = 0
	elseif EquipEvalOptionsFrameGeneral_HealingDisplayOption4:GetChecked() then
		EquipEval.db.profile["DisplayHealingTotal"] = 1
	end

	EquipEval.db.profile["MitigationDisplayed"] = not EquipEvalOptionsFrameGeneral_MitDisplayOption0:GetChecked()
	if EquipEvalOptionsFrameGeneral_MitDisplayOption1:GetChecked() then
		EquipEval.db.profile["DisplayMitTotal"] = -2
	elseif EquipEvalOptionsFrameGeneral_MitDisplayOption2:GetChecked() then
		EquipEval.db.profile["DisplayMitTotal"] = -1
	elseif EquipEvalOptionsFrameGeneral_MitDisplayOption3:GetChecked() then
		EquipEval.db.profile["DisplayMitTotal"] = 0
	elseif EquipEvalOptionsFrameGeneral_MitDisplayOption4:GetChecked() then
		EquipEval.db.profile["DisplayMitTotal"] = 1
	end
end

---------------------------------------------------------------------------------------
-- Fires when the user clicks defaults.  This will reset all the edit boxes back to their
-- default values, user still has to click ok
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_SetDefaults()	
	EquipEvalOptionsFrameGeneralEnabled:SetChecked(true)
	
	--Do not reset gem or rating options
	
	-- save gem options
	local MakeGemAssumptions = EquipEval.db.profile["MakeGemAssumptions"]
	local AssumedRedGemLink = EquipEval.db.profile["AssumedRedGemLink"]
	local AssumedYellowGemLink = EquipEval.db.profile["AssumedYellowGemLink"] 
	local AssumedBlueGemLink = EquipEval.db.profile["AssumedBlueGemLink"]
	local AssumedMetaGemLink = EquipEval.db.profile["AssumedMetaGemLink"]
	
	-- save rating options
	local DisplayTotalItemRating = EquipEval.db.profile["DisplayTotalItemRating"]
	local ItemRatingWeightDPS = EquipEval.db.profile["ItemRatingWeightDPS"]
	local ItemRatingWeightMit = EquipEval.db.profile["ItemRatingWeightMit"] 
	local ItemRatingWeightHeal = EquipEval.db.profile["ItemRatingWeightHeal"]
	
	EquipEval:ResetDB("profile")
	
	-- restore gem options
	EquipEval.db.profile["MakeGemAssumptions"] = MakeGemAssumptions
	EquipEval.db.profile["AssumedRedGemLink"] = AssumedRedGemLink
	EquipEval.db.profile["AssumedYellowGemLink"] = AssumedYellowGemLink
	EquipEval.db.profile["AssumedBlueGemLink"] = AssumedBlueGemLink
	EquipEval.db.profile["AssumedMetaGemLink"] = AssumedMetaGemLink
	
	-- restore rating options
	EquipEval.db.profile["DisplayTotalItemRating"] = DisplayTotalItemRating
	EquipEval.db.profile["ItemRatingWeightDPS"] = ItemRatingWeightDPS
	EquipEval.db.profile["ItemRatingWeightMit"] = ItemRatingWeightMit
	EquipEval.db.profile["ItemRatingWeightHeal"] = ItemRatingWeightHeal
	
	EquipEvalOptions_SetupEditBoxes()
	EquipEvalGemOptions_SetupForm()
end

---------------------------------------------------------------------------------------
-- Fires when the window closes
---------------------------------------------------------------------------------------
function EquipEvalOptionsFrame_Cancel()
end

---------------------------------------------------------------------------------------
-- Coverts the given checkbox into a bool value depending on check state
---------------------------------------------------------------------------------------
function EquipEvalOptions_CheckToBool(checkbox)
	return checkbox:GetChecked() and true or false
end


---------------------------------------------------------------------------------------
-- Creates the EqiupEval options frame
---------------------------------------------------------------------------------------
function EquipEval:MakeOptionsFrame()
	return
end

