﻿local L = EquipEval.L
local EditBoxHasFocus = nil

---------------------------------------------------------------------------------------
-- Fires on main frame events
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_OnEvent()
end

---------------------------------------------------------------------------------------
-- Fires every time the config window is launched
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_Load()
	PlaySound("igMainMenuOpen")
	EquipEval:Hook("ChatEdit_InsertLink", EquipEvalGemOptions_InsertLink, true)
	EquipEvalGemOptions_SetupForm()
end

---------------------------------------------------------------------------------------
-- Used to populate edit boxes and total box.  Called during load and a default reset
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_SetupForm()
	EquipEvalGemOptions_DisableAcquisition()

	--Set up edit boxes
	EquipEvalGemOptionsFrameGeneral_RedGemEdit:SetText(EquipEval.db.profile["AssumedRedGemLink"])
	EquipEvalGemOptionsFrameGeneral_YellowGemEdit:SetText(EquipEval.db.profile["AssumedYellowGemLink"])
	EquipEvalGemOptionsFrameGeneral_BlueGemEdit:SetText(EquipEval.db.profile["AssumedBlueGemLink"])
	EquipEvalGemOptionsFrameGeneral_MetaGemEdit:SetText(EquipEval.db.profile["AssumedMetaGemLink"])
	
	--Set up check boxes
	EquipEvalGemOptionsFrameGeneral_GemAssumptionsEnabled:SetChecked(EquipEval.db.profile["MakeGemAssumptions"])
	
	

end

---------------------------------------------------------------------------------------
-- Fires when addon is first initialized
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_Init()
	--Allows frame to be closed with the Escape key
	tinsert(UISpecialFrames, "EquipEvalGemOptionsFrame")

	--Dragging involves some special registration
	EquipEvalGemOptionsFrame:RegisterForDrag("LeftButton");

	-- setup header text to be localized and correct width
	EquipEvalGemOptionsFrameHeaderFS:SetText("EquipEval Gem Options")
	EquipEvalGemOptionsFrameHeader:SetWidth(EquipEvalGemOptionsFrameHeaderFS:GetStringWidth() + 215)

end

---------------------------------------------------------------------------------------
-- Fires when the user clicks save.  Just save all the options down to the profile and/or
-- modify the running addon.
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_Save()
	EquipEvalGemOptions_DisableAcquisition()
	
	--Save edit boxes
	EquipEval.db.profile["AssumedRedGemLink"] = EquipEvalGemOptionsFrameGeneral_RedGemEdit:GetText()
	EquipEval.db.profile["AssumedYellowGemLink"] = EquipEvalGemOptionsFrameGeneral_YellowGemEdit:GetText()
	EquipEval.db.profile["AssumedBlueGemLink"] = EquipEvalGemOptionsFrameGeneral_BlueGemEdit:GetText()
	EquipEval.db.profile["AssumedMetaGemLink"] = EquipEvalGemOptionsFrameGeneral_MetaGemEdit:GetText()
	
	--Save check boxes
	EquipEval.db.profile["MakeGemAssumptions"] = EquipEvalGemOptionsFrameGeneral_GemAssumptionsEnabled:GetChecked()

end

---------------------------------------------------------------------------------------
-- Fires when the user clicks defaults.  This will reset all the edit boxes back to their
-- default values, user still has to click ok
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_SetDefaults()
	EquipEvalGemOptions_DisableAcquisition()
	
	EquipEval.db.profile["MakeGemAssumptions"] = EquipEval:GetDefaultValue("MakeGemAssumptions")
	EquipEval.db.profile["AssumedRedGemLink"] = EquipEval:GetDefaultValue("AssumedRedGemLink")
	EquipEval.db.profile["AssumedYellowGemLink"] = EquipEval:GetDefaultValue("AssumedYellowGemLink")
	EquipEval.db.profile["AssumedBlueGemLink"] = EquipEval:GetDefaultValue("AssumedBlueGemLink")
	EquipEval.db.profile["AssumedMetaGemLink"] = EquipEval:GetDefaultValue("AssumedMetaGemLink")
	
	EquipEvalGemOptions_SetupForm()
end

---------------------------------------------------------------------------------------
-- Fires when the window closes
---------------------------------------------------------------------------------------
function EquipEvalGemOptionsFrame_Cancel()
	EquipEvalGemOptions_DisableAcquisition()
	EquipEval:Unhook("ChatEdit_InsertLink")
end

---------------------------------------------------------------------------------------
-- Coverts the given checkbox into a bool value depending on check state
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_CheckToBool(checkbox)
	return checkbox:GetChecked() and true or false
end


---------------------------------------------------------------------------------------
-- Sets a gem edit box to acquire mode
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_EnableAcquisition(Button, EditBox)
	Button:SetText("Set")
	EquipEval.db.profile["GemAcquisitionActive"] = EditBox
	
	EquipEvalGemOptions_DisableAllAcquisitionButtonsExcept(Button)
end

---------------------------------------------------------------------------------------
-- Sets a gem edit box out of acquire mode
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_DisableAcquisition(Button)
	if Button then Button:SetText("Acquire") end
	EquipEval.db.profile["GemAcquisitionActive"] = nil
	
	EquipEvalGemOptions_EnableAllAcquisitionButtons()
end

---------------------------------------------------------------------------------------
-- Disable All Acquisition
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_DisableAllAcquisition()
	EquipEvalGemOptions_DisableAcquisition(getglobal("EquipEvalGemOptionsFrameGeneral_RedGemButton"))
	EquipEvalGemOptions_DisableAcquisition(getglobal("EquipEvalGemOptionsFrameGeneral_YellowGemButton"))
	EquipEvalGemOptions_DisableAcquisition(getglobal("EquipEvalGemOptionsFrameGeneral_BlueGemButton"))
	EquipEvalGemOptions_DisableAcquisition(getglobal("EquipEvalGemOptionsFrameGeneral_MetaGemButton"))
end

---------------------------------------------------------------------------------------
-- Disables all acquisition buttons except for the currently pressed one
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_DisableAllAcquisitionButtonsExcept(Button)
	EquipEvalGemOptions_DisableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_RedGemButton"))
	EquipEvalGemOptions_DisableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_YellowGemButton"))
	EquipEvalGemOptions_DisableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_BlueGemButton"))
	EquipEvalGemOptions_DisableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_MetaGemButton"))

	EquipEvalGemOptions_EnableAcquisitionButton(Button)
end

---------------------------------------------------------------------------------------
-- Enables all acquisition buttons
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_EnableAllAcquisitionButtons()
	EquipEvalGemOptions_EnableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_RedGemButton"))
	EquipEvalGemOptions_EnableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_YellowGemButton"))
	EquipEvalGemOptions_EnableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_BlueGemButton"))
	EquipEvalGemOptions_EnableAcquisitionButton(getglobal("EquipEvalGemOptionsFrameGeneral_MetaGemButton"))
end

---------------------------------------------------------------------------------------
-- Enables an acquisition button
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_EnableAcquisitionButton(Button)
	if Button then Button:Enable() end
end

---------------------------------------------------------------------------------------
-- Disables an acquisition button
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_DisableAcquisitionButton(Button)
	if Button then Button:Disable() end
end


---------------------------------------------------------------------------------------
-- Handles when a gem edit box has an item dragged onto it
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_GemEditBoxReceiveDrag(EditBox)
	if not EditBox then return end
	
	if CursorHasItem then
		local type, index, link = GetCursorInfo()
		
		if type == "merchant" and index then
			link = GetMerchantItemLink(index)
		end
		
		if link then
			this:SetText(link)
		end
	end
	
	
end


---------------------------------------------------------------------------------------
-- Displays the tooltip for the Acquire buttons
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_ShowAcquireButtonTooltip()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetText("To choose a gem: Click Acquire, then view the gem that you want to select, then click Set or press Enter.", nil, nil, nil, nil, 1);
end


---------------------------------------------------------------------------------------
-- Tells EquipEval that an edit box now has focus
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_SetEditBoxHasFocus(EditBox)
	EditBoxHasFocus = EditBox
end

---------------------------------------------------------------------------------------
-- Handles when items are shift clicked and puts the link in the appropriate box
---------------------------------------------------------------------------------------
function EquipEvalGemOptions_InsertLink(text)
	if not text then return false end
	
	if EditBoxHasFocus then
		EditBoxHasFocus:SetText(text)
		return true
	end
	
	return EquipEval.hooks["ChatEdit_InsertLink"](text)
	
end