

local Bonus = AceLibrary("LibItemBonus-2.0")

local eqevAgilityTableWarrior = {
4, 4.2, 4.2, 4.4, 4.6, 4.8, 4.8, 5, 5.2, 5.2, 
5.4, 5.6, 6, 6.2, 6.4, 6.6, 6.8, 7.2, 7.4, 7.8, 
7.8, 8, 8.4, 8.6, 9, 9.2, 9.4, 9.8, 10, 10.4, 
10.6, 10.8, 11.2, 11.4, 11.81, 12, 12.2, 12.59, 12.8, 13.19,
13.61, 13.79, 14.2, 14.41, 14.79, 14.99, 15.41, 15.8, 16, 16.39,
16.81, 17.01, 17.39, 17.79, 18.21, 18.42, 18.8, 19.19, 19.61, 20,
21.32, 22.62, 23.92, 25.19, 26.53, 27.78, 29.07, 30.4, 31.75, 33 }




---------------------------------------------------------------------------------------
-- Used to calculate Warrior DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarriorDPS(infoObj, CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponType)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, spelldmg, holydmg, int, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local MongoosePresent, _, AdditionalMongoose = EquipEval:GetSpecialBonus("MONGOOSE_TOKEN", infoObj)
	local ExecutionerPresent, _, AdditionalExecutioner = EquipEval:GetSpecialBonus("EXECUTIONER_TOKEN", infoObj)

	local _, WeaponSpeed, WeaponAvgDmg = EquipEval:GetWeaponStats(infoObj)
	if WeaponHands > 0 then
		meleedmg = 0
	end
	
	
	if (TotalValue + WeaponAvgDmg + abs(AdditionalMongoose) + abs(AdditionalExecutioner)) == 0 then
		return 0, 0
	end




	local AgilityRating = eqevAgilityTableWarrior[CurrentLevel]

	local AgiModifier = 1
	local StrModifier = 1 + .02 * EquipEval:TalentRank(3,21)

	local ItemAgility = AgiModifier * agi
	local BonusAgility = AgiModifier * MongoosePresent * 120

	local APModifier = 1 
	if GetShapeshiftForm(true) == 3 then
		APModifier = APModifier * (1 + .02 * EquipEval:TalentRank(2,20))
	end

	local ItemAP = APModifier * (ap + 2 * StrModifier * str)
	BonusAttackPower = APModifier * BonusAttackPower

	local ItemHit = (hit / 10.0  * LevelRating / 100)

	local ItemCrit = (crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating)
	local BonusCrit = (BonusAgility/AgilityRating)

	local ItemHaste = (haste / 10.0 * LevelRating) / 100
	local BonusHaste = MongoosePresent * 0.02

	weapSkill = (weapSkill / 2.5  * LevelRating)
	expertise = (expertise / 2.5  * LevelRating) * 0.0025
	
	local BonusArmorPen = ExecutionerPresent * 840

	local baseDPS = EquipEval:CalculateWarriorDPSFromStats(CurrentLevel, LevelRating, "None", 0, 0, 0, "None", BonusAttackPower, BonusCrit, 0, 0, BonusHaste, 0, 0, BonusArmorPen, 0)
	local newDPS, InfoLine = EquipEval:CalculateWarriorDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, (ItemAP + BonusAttackPower), (ItemCrit + BonusCrit), ItemHit, meleedmg, (ItemHaste + BonusHaste), critbonus, weapSkill, (ignorearmor + BonusArmorPen), expertise)

	return (newDPS - baseDPS), newDPS, InfoLine
end


---------------------------------------------------------------------------------------
-- Used to calculate Warrior DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarriorDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, ap, crit, hit, meleedmg, haste, critbonus, weapSkill, ignoreArmor, expertise)

	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = 1
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	local CritModifierYellow = (CritModifier + 1) * (1 + .10 * EquipEval:TalentRank(1,11)) - 1
	self:Debug("Crit Modifier: "..CritModifier)
	self:Debug("Crit Modifier Yellow: "..CritModifierYellow)



	local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentmod = UnitDamage("player");
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	offSpeed = offSpeed or 0
	
	--Calc base weapon stats
	local baseMainSpeed = mainSpeed
	local baseOffSpeed = offSpeed
	local baseMainAvgDmg = 0 --(lowDmg + hiDmg) / 2 / mainSpeed
	local baseOffAvgDmg = 0
	
	local CurrentWeaponTypeMain = "None"
	local CurrentWeaponTypeOff = "None"
	local mainEquipLoc = "None"

	--Recalc base weapon stats from items if possible
	local mainHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot"))
	if mainHandLink then
		local mainHandInfo = Bonus:ScanItemLink(mainHandLink)
		if mainHandInfo then
			_, baseMainSpeed, baseMainAvgDmg, lowDmg, hiDmg = EquipEval:GetWeaponStats(mainHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeMain, _, mainEquipLoc = GetItemInfo(mainHandLink)
		end
	end
	local offHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("SecondaryHandSlot"))
	if offHandLink then
		local offHandInfo = Bonus:ScanItemLink(offHandLink)
		if offHandInfo then
			_, baseOffSpeed, baseOffAvgDmg, offlowDmg, offhiDmg = EquipEval:GetWeaponStats(offHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeOff = GetItemInfo(offHandLink)
		end
	end
	
	
	--Adjust current crit rates to remove crit from weapon specializations
	local SpecializationCrit = 0
	if CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "One-Handed Axes" or CurrentWeaponTypeMain == "Two-Handed Axes" then
		SpecializationCrit = EquipEval:TalentRank(1,12)
	end
	
	
	--Replace Weapons if necessary
	if EquipEval.db.profile["CompareToCurrentItems"] then
		if WeaponSlotName == "MainHand" then
			baseMainSpeed = WeaponSpeed
			baseMainAvgDmg = WeaponAvgDmg
			CurrentWeaponTypeMain = WeaponType
			if WeaponHands == 2 then
				baseOffSpeed = 0
				offSpeed = 0
				baseOffAvgDmg = 0
				CurrentWeaponTypeOff = "None"
			end
		elseif WeaponSlotName == "SecondaryHand" then
			if WeaponHands ~= 1 then
				offSpeed = 0
				baseOffSpeed = 0
				baseOffAvgDmg = 0
			else
				offSpeed = WeaponSpeed
				baseOffSpeed = WeaponSpeed
				baseOffAvgDmg = WeaponAvgDmg
			end
			CurrentWeaponTypeOff = WeaponType

			if mainEquipLoc == "INVTYPE_2HWEAPON" then
				baseMainSpeed = 2
				baseMainAvgDmg = 0
				CurrentWeaponTypeMain = "None"
			end
		end
	end
		
	local offHandModifier = 0
	local APDamageModifier = 1 * percentmod
	
	if string.find(CurrentWeaponTypeMain, "Two-Handed") ~= nil or CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "Staves" then
		APDamageModifier = APDamageModifier * (1 + .01 * EquipEval:TalentRank(1,10))
	else
		APDamageModifier = APDamageModifier * (1 + .02 * EquipEval:TalentRank(3,17))
	end


	baseMainAvgDmg = (baseMainAvgDmg + meleedmg) * APDamageModifier
	if baseOffSpeed > 0 then
		offHandModifier = 0.5 * (1 + .05 * EquipEval:TalentRank(2,9))
		baseOffAvgDmg = (baseOffAvgDmg + meleedmg) * APDamageModifier * offHandModifier
	end



	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_MAINHAND) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)

	local totalCrit = GetCritChance() - SpecializationCrit - 0.04 * weapSkillDif
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = (totalCrit + crit) / 100 - resilienceEffect
	totalCrit = totalCrit * EquipEval.db.profile["BurstFactor"]
	self:Debug("Total Crit: "..totalCrit)

	local CurrentHit = GetCombatRating(CR_HIT_MELEE) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]


	local maxHitChance, parryChance, dodgeChance = EquipEval:GetHitStats(expertise, weapSkillDif)
	if EquipEval:TalentRank(2,14) > 0 then
		local WeaponMasteryEffect = min(dodgeChance, EquipEval:TalentRank(2,14) * 0.01)
		maxHitChance = maxHitChance + WeaponMasteryEffect
		dodgeChance = dodgeChance - WeaponMasteryEffect
	end
	local currentChanceToHit = (maxHitChance - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = currentChanceToHit + .01 * EquipEval:TalentRank(2,17)
	local totalHitYellow = currentChanceToHit
	if baseOffSpeed ~= 0 then
		currentChanceToHit = currentChanceToHit - 0.19
	end
	currentChanceToHit = min(currentChanceToHit, maxHitChance)
	totalHitYellow = min(totalHitYellow, maxHitChance)
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	totalHitYellow = max(0.01, (1 - (1 - totalHitYellow) / EquipEval.db.profile["BurstFactor"]))
	parryChance = max(0, min(1, (parryChance / EquipEval.db.profile["BurstFactor"])))
	dodgeChance = max(0, min(1, (dodgeChance / EquipEval.db.profile["BurstFactor"])))
	self:Debug("Total Hit: "..totalHit)
	self:Debug("Total Hit Yellow: "..totalHitYellow)
	

	local GlanceChance, GlanceModifier = EquipEval:GetGlancingBlowInfo()

	
	local totalHaste = haste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100
	self:Debug("Total Haste: "..totalHaste)
	

	local ItemAP = ap + EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	ItemAP = ItemAP + (baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	local effectiveAP = baseAP + ItemAP
	self:Debug("Item AP: "..ItemAP)
	
	--Handle effects of Sunder Armor
	local SunderArmorEffect = 0
	if CurrentLevel >= 67 then
		SunderArmorEffect = 520 * 5
	elseif CurrentLevel >= 56 then
		SunderArmorEffect = 450 * 5
	elseif CurrentLevel >= 46 then
		SunderArmorEffect = 360 * 5
	elseif CurrentLevel >= 34 then
		SunderArmorEffect = 270 * 5
	elseif CurrentLevel >= 22 then
		SunderArmorEffect = 180 * 5
	elseif CurrentLevel >= 10 then
		SunderArmorEffect = 90 * 5
	end
	SunderArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor + SunderArmorEffect)

	local NormalDPS, NormalFlurryUptime, InfoLine = EquipEval:CalculateWarriorStrikeDPS(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, APDamageModifier, offHandModifier, ArmorEffect, resilienceEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, (1 + totalHaste), totalHit, totalHitYellow, parryChance, dodgeChance, totalCrit, CritModifier, CritModifierYellow, GlanceChance, GlanceModifier)
	
	local ForceSunder = false
	if SunderArmorEffect ~= ArmorEffect then
		local SunderDPS, SunderFlurryUptime, SunderInfoLine = EquipEval:CalculateWarriorStrikeDPS(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, APDamageModifier, offHandModifier, SunderArmorEffect, resilienceEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, (1 + totalHaste), totalHit, totalHitYellow, parryChance, dodgeChance, totalCrit, CritModifier, CritModifierYellow, GlanceChance, GlanceModifier, true)
		
		if SunderDPS > NormalDPS then
			NormalDPS = SunderDPS
			NormalFlurryUptime = SunderFlurryUptime
			InfoLine = SunderInfoLine
			ForceSunder = true
		end
	end
	
	local TotalDPS = NormalDPS
	local FlurriedDPS = 0
	local FlurriedFlurryUptime = 0

	if EquipEval:TalentRank(2,16) > 0 then
		FlurriedDPS, FlurriedFlurryUptime, InfoLine = EquipEval:CalculateWarriorStrikeDPS(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, APDamageModifier, offHandModifier, ArmorEffect, resilienceEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, ((1 + totalHaste) * (1 + EquipEval:TalentRank(2,16) * 0.05)), totalHit, totalHitYellow, parryChance, dodgeChance, totalCrit, CritModifier, CritModifierYellow, GlanceChance, GlanceModifier, ForceSunder)
		
		local FlurryUptime = (NormalFlurryUptime + FlurriedFlurryUptime) / 2
		TotalDPS = (1 - FlurryUptime) * NormalDPS + FlurryUptime * FlurriedDPS
	end	
	
	return TotalDPS, InfoLine
end



---------------------------------------------------------------------------------------
-- This function calculates warrior damage from strikes
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarriorStrikeDPS(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, APDamageModifier, offHandModifier, ArmorEffect, resilienceEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, HasteEffect, totalHit, totalHitYellow, parryChance, dodgeChance, totalCrit, CritModifier, CritModifierYellow, GlanceChance, GlanceModifier, ForceSunder)

	local InfoLine = "Attacks: "

	baseOffSpeed = baseOffSpeed or 0

	local mainSpeed = baseMainSpeed / HasteEffect
	local offSpeed = baseOffSpeed / HasteEffect
	local totalMiss = max((1 - (totalHit + parryChance + dodgeChance)), 0)
	local totalMissYellow = max((1 - (totalHitYellow + parryChance + dodgeChance)), 0)
	--totalHit, totalHitYellow, parryChance, dodgeChance
	
	local NumTargets = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
	local GlobalCoolDown = 1.5 + EquipEval.db.profile["CastTimePadding"]
	local RageConversionFactor = 0.0091107836 * CurrentLevel^2 + 3.225598133 * CurrentLevel + 4.2652911
	local RageHitFactor = 3.5 * ((1 - totalMiss) + min(totalCrit, max(0, totalHit - GlanceChance)))
	local RageHitFactorSwordSpec = 3.5 * (1 - totalMissYellow) * (1 + totalCrit)
	local UnbridledWrathEffect = EquipEval:TalentRank(2,4) * 0.08
	local RageCostModifier = EquipEval:TalentRank(3,20)
	local RageGenerationMultiplier = (1 + EquipEval:TalentRank(1,23) * 0.25) * (1 + EquipEval:TalentRank(1,13) * 0.2 * 30 / 180)
	
	local SwordSpecProcChance = min(1, (EquipEval:TalentRank(1,15) * 0.01 * EquipEval.db.profile["BurstFactor"]))
	local MaceSpecMHEffect = EquipEval:TalentRank(1,14) / 5 * 7 * 0.098 * mainSpeed / 3.8 * EquipEval.db.profile["BurstFactor"]
	local MaceSpecOHEffect = EquipEval:TalentRank(1,14) / 5 * 7 * 0.098 * offSpeed / 3.8 * EquipEval.db.profile["BurstFactor"]
	
	local WindfuryProcChance, WindfuryBonusAP = EquipEval:GetWindfuryTotemStats(CurrentLevel)
	if GetShapeshiftForm(true) == 3 then
		WindfuryBonusAP = WindfuryBonusAP * (1 + .02 * EquipEval:TalentRank(2,20))
	end
	
	local StrikeDmg = 0
	local StrikeRageCost = 0
	local StrikeCritChance = 0
	local StrikeCoolDown = 0



	local NormalizedSpeed = 2.4
	local NormalizedSpeedOH = 2.4
	local MainHandSword = 0
	local OffHandSword = 0
	local MainHandMace = 0
	local OffHandMace = 0
	local MainHandPlusCrit = 0
	local OffHandPlusCrit = 0

	if string.find(CurrentWeaponTypeMain, "Two-Handed") ~= nil or CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "Staves" then
		NormalizedSpeed = 3.3
	end
	
	if string.find(CurrentWeaponTypeMain, "Swords") ~= nil then
		MainHandSword = 1
	elseif string.find(CurrentWeaponTypeMain, "Maces") ~= nil then
		MainHandMace = 1
	elseif CurrentWeaponTypeMain == "Daggers" then
		NormalizedSpeed = 1.7
	elseif CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "One-Handed Axes" or CurrentWeaponTypeMain == "Two-Handed Axes" then
		MainHandPlusCrit = EquipEval:TalentRank(1,12) * 0.01
	end
	
	if string.find(CurrentWeaponTypeOff, "Swords") ~= nil then
		OffHandSword = 1
	elseif string.find(CurrentWeaponTypeOff, "Maces") ~= nil then
		OffHandMace = 1
	elseif CurrentWeaponTypeOff == "Daggers" then
		NormalizedSpeedOH = 1.7
	elseif CurrentWeaponTypeOff == "Polearms" or CurrentWeaponTypeOff == "One-Handed Axes" or CurrentWeaponTypeOff == "Two-Handed Axes" then
		OffHandPlusCrit = EquipEval:TalentRank(1,12) * 0.01
	end
	
	--Adjust crit rates based on specializations
	local totalCritOffHand = totalCrit + OffHandPlusCrit * EquipEval.db.profile["BurstFactor"]
	totalCrit = totalCrit + MainHandPlusCrit * EquipEval.db.profile["BurstFactor"]
	totalCrit = max(0, min(1, totalCrit))
	totalCritOffHand = max(0, min(1, totalCritOffHand))
	

	MaceSpecMHEffect = MainHandMace * MaceSpecMHEffect
	MaceSpecOHEffect = OffHandMace * MaceSpecOHEffect


	--Rampage
	StrikeDmg = 0
	StrikeRageCost = (20 - RageCostModifier)
	StrikeCritChance = 0
	StrikeCoolDown = 20
	
	if CurrentLevel >= 70 then
		StrikeDmg = 50
	elseif CurrentLevel >= 60 then
		StrikeDmg = 40
	elseif CurrentLevel >= 40 then
		StrikeDmg = 30
	end
	
	StrikeDmg = StrikeDmg * 5
	
	if GetShapeshiftForm(true) == 3 then
		StrikeDmg = StrikeDmg * (1 + .02 * EquipEval:TalentRank(2,20))
	end
	
	local RampageRageCost = StrikeRageCost
	local RampageMainHandCrits = 0
	local RampageRating = 999999/0.000001
	local RampageMaxStrikesPerSecond = 0
	if EquipEval:TalentRank(2,21) > 0 and EquipEval.db.profile["IncludeStrikes"] == 1 then
		RampageMaxStrikesPerSecond = 1 / StrikeCoolDown
		effectiveAP = effectiveAP + StrikeDmg * (1 + EquipEval.db.profile["BonusAPPercent"] / 100)
	end
	
	
	--Battle Shout
	StrikeDmg = 0
	StrikeRageCost = (10 - RageCostModifier)
	StrikeCritChance = 0
	StrikeCoolDown = (2* 60) * (1 + EquipEval:TalentRank(2,1) * 0.1)
	
	if CurrentLevel >= 69 then
		StrikeDmg = 305 + CurrentLevel - 69
	elseif CurrentLevel >= 60 then
		StrikeDmg = 232 + CurrentLevel - 60
	elseif CurrentLevel >= 52 then
		StrikeDmg = 185 + CurrentLevel - 52
	elseif CurrentLevel >= 42 then
		StrikeDmg = 130 + CurrentLevel - 42
	elseif CurrentLevel >= 32 then
		StrikeDmg = 65 + CurrentLevel - 32
	elseif CurrentLevel >= 22 then
		StrikeDmg = 55 + CurrentLevel - 22
	elseif CurrentLevel >= 12 then
		StrikeDmg = 35 + CurrentLevel - 12
	elseif CurrentLevel >= 1 then
		StrikeDmg = 15 + CurrentLevel - 1
	end
	
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(2,8) * 0.05)
	
	if GetShapeshiftForm(true) == 3 then
		StrikeDmg = StrikeDmg * (1 + .02 * EquipEval:TalentRank(2,20))
	end
	
	local BattleShoutRageCost = StrikeRageCost
	local BattleShoutMainHandCrits = 0
	local BattleShoutRating = RampageRating + 1
	local BattleShoutMaxStrikesPerSecond = 0
	if CurrentLevel >= 1 and EquipEval.db.profile["IncludeStrikes"] == 1 then
		BattleShoutMaxStrikesPerSecond = 1 / StrikeCoolDown
		
		--Find Battle Shout
		local BattleShoutApplied = 0
		for buffIndex = 1, 16 do
			local buffTexture = GetPlayerBuffTexture(buffIndex)
			if buffTexture then
				if string.find(buffTexture, "BattleShout") ~= nil then
					self:Debug("Battle Shout Found")
					BattleShoutApplied = 1
					break
				end
			else
				break	
			end
		end
	
		if BattleShoutApplied == 0 then	
			effectiveAP = effectiveAP + StrikeDmg * (1 + EquipEval.db.profile["BonusAPPercent"] / 100)
		end
	end
		


	--Sword Specialization Proc
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (0 - UnbridledWrathEffect - MaceSpecMHEffect)
	StrikeCritChance = totalCrit
	StrikeCoolDown = 0

	StrikeDmg = (APDamageModifier * effectiveAP / 14.0 * baseMainSpeed + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeRageCost = StrikeRageCost - RageGenerationMultiplier * (7.5 * StrikeDmg / RageConversionFactor + RageHitFactorSwordSpec * baseMainSpeed) / 2

	local SwordSpecProcDmg = StrikeDmg
	local SwordSpecProcRageCost = StrikeRageCost
	local SwordSpecProcMainHandCrits = totalHitYellow * StrikeCritChance
	local SwordSpecProcSwings = 1
	
	
	--Windfury Proc
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (0 - UnbridledWrathEffect - MaceSpecMHEffect)
	StrikeCritChance = totalCrit
	StrikeCoolDown = 0

	StrikeDmg = (APDamageModifier * (effectiveAP + WindfuryBonusAP) / 14.0 * baseMainSpeed + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeRageCost = StrikeRageCost - RageGenerationMultiplier * (7.5 * StrikeDmg / RageConversionFactor + RageHitFactorSwordSpec * baseMainSpeed) / 2

	local WindfuryProcDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local WindfuryProcRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local WindfuryProcMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local WindfuryProcSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings



	--Main Hand Attack
	StrikeDmg = 0
	StrikeRageCost = totalHit * (0 - UnbridledWrathEffect - MaceSpecMHEffect)
	StrikeCritChance = min(totalCrit, max(0, totalHit - GlanceChance))
	StrikeCoolDown = mainSpeed

	StrikeDmg = (APDamageModifier * effectiveAP / 14.0 * baseMainSpeed + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg * (totalHit + StrikeCritChance * CritModifier - (1 - GlanceModifier) * GlanceChance)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeRageCost = StrikeRageCost - RageGenerationMultiplier * (7.5 * StrikeDmg / RageConversionFactor + RageHitFactor * baseMainSpeed) / 2

	local MainHandStrikeDmg = StrikeDmg + totalHit * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg + totalHit * WindfuryProcChance * WindfuryProcDmg
	local MainHandStrikeRageCost = StrikeRageCost + totalHit * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost + totalHit * WindfuryProcChance * WindfuryProcRageCost
	local MainHandStrikeMainHandCrits = StrikeCritChance + totalHit * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits + totalHit * WindfuryProcChance * WindfuryProcMainHandCrits
	local MainHandStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	local MainHandStrikeSwings = 1 + totalHit * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings + totalHit * WindfuryProcChance * WindfuryProcSwings


	--Off Hand Attack
	StrikeDmg = 0
	StrikeRageCost = totalHit * (0 - UnbridledWrathEffect - MaceSpecOHEffect)
	StrikeCritChance = min(totalCritOffHand, max(0, totalHit - GlanceChance))
	StrikeCoolDown = offSpeed

	if StrikeCoolDown > 0 then
		StrikeDmg = (offHandModifier * APDamageModifier * effectiveAP / 14.0 * baseOffSpeed + offBaseAvgDmg)
		StrikeDmg = StrikeDmg * (totalHit + StrikeCritChance * CritModifier - (1 - GlanceModifier) * GlanceChance)
		StrikeDmg = StrikeDmg * (1 - ArmorEffect)
		
		StrikeRageCost = StrikeRageCost - RageGenerationMultiplier * (7.5 * StrikeDmg / RageConversionFactor + RageHitFactor/2 * baseOffSpeed) / 2
	end

	local OffHandStrikeDmg = StrikeDmg + totalHit * OffHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local OffHandStrikeRageCost = StrikeRageCost + totalHit * OffHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local OffHandStrikeMainHandCrits = 0 + totalHit * OffHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local OffHandStrikeOffHandCrits = StrikeCritChance
	local OffHandStrikeMaxStrikesPerSecond = 0
	if StrikeCoolDown > 0 then
		OffHandStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local OffHandStrikeSwings = 1 + totalHit * OffHandSword * SwordSpecProcChance * SwordSpecProcSwings



	--Slam
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (15 - RageCostModifier - MaceSpecMHEffect)
	StrikeCritChance = totalCrit
	StrikeCoolDown = GlobalCoolDown
	local SlamCastTime = 1.5 - EquipEval:TalentRank(2,12) * 0.5 + EquipEval.db.profile["CastTimePadding"]

	if CurrentLevel >= 69 then
		StrikeDmg = 140
	elseif CurrentLevel >= 61 then
		StrikeDmg = 105
	elseif CurrentLevel >= 54 then
		StrikeDmg = 87
	elseif CurrentLevel >= 46 then
		StrikeDmg = 68
	elseif CurrentLevel >= 38 then
		StrikeDmg = 43
	elseif CurrentLevel >= 30 then
		StrikeDmg = 32
	end

	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * baseMainSpeed + StrikeDmg) + mainBaseAvgDmg) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local SlamDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg - MainHandStrikeDmg * (SlamCastTime * MainHandStrikeMaxStrikesPerSecond) - OffHandStrikeDmg * (SlamCastTime * OffHandStrikeMaxStrikesPerSecond)
	local SlamRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost - MainHandStrikeRageCost * (SlamCastTime * MainHandStrikeMaxStrikesPerSecond) - OffHandStrikeRageCost * (SlamCastTime * OffHandStrikeMaxStrikesPerSecond)
	local SlamMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits - MainHandStrikeMainHandCrits * (SlamCastTime * MainHandStrikeMaxStrikesPerSecond)
	local SlamOffHandCrits = 0 - OffHandStrikeOffHandCrits * (SlamCastTime * OffHandStrikeMaxStrikesPerSecond)
	local SlamMaxStrikesPerSecond = 0
	local SlamRating = EquipEval:GetSpellRating(SlamDmg, SlamRageCost, SlamCastTime)
	if CurrentLevel >= 30 then
		SlamMaxStrikesPerSecond = 1 / max(StrikeCoolDown, (1 / MainHandStrikeMaxStrikesPerSecond + SlamCastTime))
	end
	local SlamSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings - MainHandStrikeSwings * (SlamCastTime * MainHandStrikeMaxStrikesPerSecond) - OffHandStrikeSwings * (SlamCastTime * OffHandStrikeMaxStrikesPerSecond)
	
	
	--Heroic Strike
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (15 - RageCostModifier - EquipEval:TalentRank(1,1) - UnbridledWrathEffect - MaceSpecMHEffect)
	StrikeCritChance = totalCrit
	StrikeCoolDown = mainSpeed

	if CurrentLevel >= 66 then
		StrikeDmg = 176
	elseif CurrentLevel >= 60 then
		StrikeDmg = 157
	elseif CurrentLevel >= 56 then
		StrikeDmg = 138
	elseif CurrentLevel >= 48 then
		StrikeDmg = 111
	elseif CurrentLevel >= 40 then
		StrikeDmg = 80
	elseif CurrentLevel >= 32 then
		StrikeDmg = 58
	elseif CurrentLevel >= 24 then
		StrikeDmg = 44
	elseif CurrentLevel >= 16 then
		StrikeDmg = 32
	elseif CurrentLevel >= 8 then
		StrikeDmg = 21
	elseif CurrentLevel >= 1 then
		StrikeDmg = 10
	end

	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * baseMainSpeed + StrikeDmg) + mainBaseAvgDmg) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local HeroicStrikeDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg - MainHandStrikeDmg + totalHitYellow * WindfuryProcChance * WindfuryProcDmg
	local HeroicStrikeRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost - MainHandStrikeRageCost + totalHitYellow * WindfuryProcChance * WindfuryProcRageCost
	local HeroicStrikeMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits - MainHandStrikeMainHandCrits + totalHitYellow * WindfuryProcChance * WindfuryProcMainHandCrits
	local HeroicStrikeRating = EquipEval:GetSpellRating(HeroicStrikeDmg, HeroicStrikeRageCost, GlobalCoolDown)
	local HeroicStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	local HeroicStrikeSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings - MainHandStrikeSwings + totalHitYellow * WindfuryProcChance * WindfuryProcSwings



	--Mortal Strike
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (30 - RageCostModifier - MaceSpecMHEffect)
	StrikeCritChance = totalCrit
	StrikeCoolDown = 6 - EquipEval:TalentRank(1,22) * 0.1
	
	if CurrentLevel >= 70 then
		StrikeDmg = 210
	elseif CurrentLevel >= 66 then
		StrikeDmg = 185
	elseif CurrentLevel >= 60 then
		StrikeDmg = 165
	elseif CurrentLevel >= 54 then
		StrikeDmg = 135
	elseif CurrentLevel >= 48 then
		StrikeDmg = 110
	elseif CurrentLevel >= 40 then
		StrikeDmg = 85
	end

	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * NormalizedSpeed + StrikeDmg) + mainBaseAvgDmg) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(1,22) * 0.01)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local MortalStrikeDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local MortalStrikeRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local MortalStrikeMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local MortalStrikeRating = EquipEval:GetSpellRating(MortalStrikeDmg, MortalStrikeRageCost, GlobalCoolDown)
	local MortalStrikeMaxStrikesPerSecond = 0
	if EquipEval:TalentRank(1,20) > 0 then
		MortalStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local MortalStrikeSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings


	--Cleave
	local CleaveTargets = min(2, NumTargets)
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (20 - RageCostModifier - UnbridledWrathEffect * CleaveTargets - MaceSpecMHEffect * CleaveTargets)
	StrikeCritChance = totalCrit
	StrikeCoolDown = mainSpeed

	if CurrentLevel >= 68 then
		StrikeDmg = 70
	elseif CurrentLevel >= 60 then
		StrikeDmg = 50
	elseif CurrentLevel >= 50 then
		StrikeDmg = 32
	elseif CurrentLevel >= 40 then
		StrikeDmg = 18
	elseif CurrentLevel >= 30 then
		StrikeDmg = 10
	elseif CurrentLevel >= 20 then
		StrikeDmg = 5
	end
	
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(2,5) * 0.4)

	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * baseMainSpeed + StrikeDmg) + mainBaseAvgDmg) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local CleaveDmg = CleaveTargets * StrikeDmg + totalHitYellow * MainHandSword * (1 - (1 - SwordSpecProcChance)^CleaveTargets) * SwordSpecProcDmg - MainHandStrikeDmg + totalHitYellow * (1 - (1 - WindfuryProcChance)^CleaveTargets) * WindfuryProcDmg
	local CleaveRageCost = StrikeRageCost + totalHitYellow * MainHandSword * (1 - (1 - SwordSpecProcChance)^CleaveTargets) * SwordSpecProcRageCost - MainHandStrikeRageCost + totalHitYellow * (1 - (1 - WindfuryProcChance)^CleaveTargets) * WindfuryProcRageCost
	local CleaveMainHandCrits = CleaveTargets * totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * (1 - (1 - SwordSpecProcChance)^CleaveTargets) * SwordSpecProcMainHandCrits - MainHandStrikeMainHandCrits + totalHitYellow * (1 - (1 - WindfuryProcChance)^CleaveTargets) * WindfuryProcMainHandCrits
	local CleaveRating = EquipEval:GetSpellRating(CleaveDmg, CleaveRageCost, GlobalCoolDown)
	local CleaveMaxStrikesPerSecond = 0
	if CurrentLevel >= 30 then
		CleaveMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local CleaveSwings = CleaveTargets + totalHitYellow * MainHandSword * (1 - (1 - SwordSpecProcChance)^CleaveTargets) * SwordSpecProcSwings - MainHandStrikeSwings + totalHitYellow * (1 - (1 - WindfuryProcChance)^CleaveTargets) * WindfuryProcSwings	


	--Whirlwind
	local WhirlwindTargets = min(4, NumTargets)
	StrikeDmg = 0
	StrikeRageCost = (25 - RageCostModifier - totalHitYellow * (MaceSpecMHEffect + MaceSpecOHEffect) * WhirlwindTargets)
	StrikeCritChance = totalCrit
	StrikeCoolDown = 10 - EquipEval:TalentRank(2,19) * 1
	
	
	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * NormalizedSpeed) + mainBaseAvgDmg) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg + (offHandModifier * APDamageModifier * (effectiveAP / 14.0 * NormalizedSpeedOH) + offBaseAvgDmg) * totalHitYellow * (1 + totalCritOffHand * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local WhirlwindDmg = WhirlwindTargets * StrikeDmg + (1 - (1 - MainHandSword * totalHitYellow * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcDmg + (1 - (1 - OffHandSword * totalHitYellow * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcDmg
	local WhirlwindRageCost = StrikeRageCost + (1 - (1 - totalHitYellow * MainHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcRageCost + (1 - (1 - totalHitYellow * OffHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcRageCost
	local WhirlwindMainHandCrits = WhirlwindTargets * totalHitYellow * StrikeCritChance + (1 - (1 - totalHitYellow * MainHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcMainHandCrits + (1 - (1 - totalHitYellow * OffHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcMainHandCrits
	local WhirlwindOffHandCrits = WhirlwindTargets * totalHitYellow * totalCritOffHand
	local WhirlwindRating = EquipEval:GetSpellRating(WhirlwindDmg, WhirlwindRageCost, GlobalCoolDown)
	local WhirlwindMaxStrikesPerSecond = 0
	if CurrentLevel >= 36 and GetShapeshiftForm(true) == 3 then
		WhirlwindMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local WhirlwindSwings = WhirlwindTargets + (1 - (1 - totalHitYellow * MainHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcSwings + (1 - (1 - totalHitYellow * OffHandSword * SwordSpecProcChance)^WhirlwindTargets) * SwordSpecProcSwings


	--Bloodthirst
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (30 - RageCostModifier)
	StrikeCritChance = totalCrit
	StrikeCoolDown = 6
	
	StrikeDmg = (APDamageModifier * effectiveAP * 0.45) * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local BloodthirstDmg = StrikeDmg
	local BloodthirstRageCost = StrikeRageCost
	local BloodthirstMainHandCrits = totalHitYellow * StrikeCritChance
	local BloodthirstRating = EquipEval:GetSpellRating(BloodthirstDmg, BloodthirstRageCost, GlobalCoolDown)
	local BloodthirstMaxStrikesPerSecond = 0
	if EquipEval:TalentRank(2,18) > 0 then
		BloodthirstMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	
	
	--Rend
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (10 - RageCostModifier)
	StrikeCritChance = 0
	StrikeCoolDown = 21
	
	if CurrentLevel >= 68 then
		StrikeDmg = 182
	elseif CurrentLevel >= 60 then
		StrikeDmg = 147
	elseif CurrentLevel >= 50 then
		StrikeDmg = 126
	elseif CurrentLevel >= 40 then
		StrikeDmg = 98
	elseif CurrentLevel >= 30 then
		StrikeDmg = 66
		StrikeCoolDown = 18
	elseif CurrentLevel >= 20 then
		StrikeDmg = 45
		StrikeCoolDown = 15
	elseif CurrentLevel >= 10 then
		StrikeDmg = 28
		StrikeCoolDown = 12
	elseif CurrentLevel >= 4 then
		StrikeDmg = 15
		StrikeCoolDown = 9
	end
	
	StrikeDmg = StrikeDmg + (APDamageModifier * (effectiveAP / 14.0 * baseMainSpeed) + mainBaseAvgDmg) * StrikeCoolDown * (743 / 300000)
	
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(1,3) * 0.25)
	StrikeDmg = StrikeDmg * (1 - resilienceEffect) * (1 - EquipEval.db.profile["EnemyIsBleedImmune"]) * (1 + 0.3 * EquipEval.db.profile['PermanentMangleOnTarget'])

	local RendDmg = StrikeDmg
	local RendRageCost = StrikeRageCost
	local RendMainHandCrits = totalHitYellow * StrikeCritChance
	local RendRating = EquipEval:GetSpellRating(RendDmg, RendRageCost, GlobalCoolDown)
	local RendMaxStrikesPerSecond = 0
	if CurrentLevel >= 4 then
		RendMaxStrikesPerSecond = NumTargets / StrikeCoolDown
	end
	local RendUptime = 0
	
	
	
	--Overpower
	local OverpowerChanceToHit = min(1, totalHitYellow + parryChance + dodgeChance)
	StrikeDmg = 0
	StrikeRageCost = OverpowerChanceToHit * (5 - RageCostModifier - MaceSpecMHEffect)
	StrikeCritChance = min(1, totalCrit + EquipEval:TalentRank(1,7) * 0.25 * EquipEval.db.profile["BurstFactor"])
	StrikeCoolDown = 5
	
	if CurrentLevel >= 60 then
		StrikeDmg = 35
	elseif CurrentLevel >= 44 then
		StrikeDmg = 25
	elseif CurrentLevel >= 28 then
		StrikeDmg = 15
	elseif CurrentLevel >= 12 then
		StrikeDmg = 5
	end

	StrikeDmg = (APDamageModifier * (effectiveAP / 14.0 * NormalizedSpeed + StrikeDmg) + mainBaseAvgDmg) * OverpowerChanceToHit * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local OverpowerDmg = StrikeDmg + OverpowerChanceToHit * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local OverpowerRageCost = StrikeRageCost + OverpowerChanceToHit * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local OverpowerMainHandCrits = OverpowerChanceToHit * StrikeCritChance + OverpowerChanceToHit * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local OverpowerRating = EquipEval:GetSpellRating(OverpowerDmg, OverpowerRageCost, GlobalCoolDown)
	if OverpowerRating < 0 then
		OverpowerRating = RampageRating - 1
	end
	local OverpowerMaxStrikesPerSecond = 0
	if CurrentLevel >= 12 and GetShapeshiftForm(true) == 1 then
		OverpowerMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local OverpowerSwings = 0 + 0 * OverpowerChanceToHit * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings
	
	
	--Execute
	StrikeDmg = 0
	StrikeRageCost = totalHitYellow * (15 - RageCostModifier - MaceSpecMHEffect - EquipEval:TalentRank(2,10) * 2)
	StrikeCritChance = totalCrit
	StrikeCoolDown = GlobalCoolDown

	if EquipEval:TalentRank(2,10) >= 2 then
		StrikeRageCost = StrikeRageCost - totalHitYellow * 1
	end
	
	if CurrentLevel >= 70 then
		StrikeDmg = 920
	elseif CurrentLevel >= 65 then
		StrikeDmg = 750
	elseif CurrentLevel >= 56 then
		StrikeDmg = 600
	elseif CurrentLevel >= 48 then
		StrikeDmg = 450
	elseif CurrentLevel >= 40 then
		StrikeDmg = 325
	elseif CurrentLevel >= 32 then
		StrikeDmg = 200
	elseif CurrentLevel >= 24 then
		StrikeDmg = 125
	end

	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifierYellow)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local ExecuteDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local ExecuteRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local ExecuteMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local ExecuteRating = EquipEval:GetSpellRating(ExecuteDmg, ExecuteRageCost, GlobalCoolDown)
	local ExecuteMaxStrikesPerSecond = 0
	if CurrentLevel >= 24 and GetShapeshiftForm(true) ~= 2 then
		ExecuteMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local ExecuteSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings
	
	
	--Sweeping Strikes
	local SweepingStrikesTargets = min(1, max(0, (NumTargets - 1)))
	StrikeDmg = 0
	StrikeRageCost = 30 - RageCostModifier
	StrikeCritChance = totalCrit
	StrikeCoolDown = 30
	
	local SSMHHits = SweepingStrikesTargets * MainHandStrikeMaxStrikesPerSecond * 10
	SSMHHits = min(10, SSMHHits)
	local SSOHHits = SweepingStrikesTargets * OffHandStrikeMaxStrikesPerSecond * 10
	SSOHHits = min(SSOHHits, (10 - SSMHHits))
	
	StrikeDmg = StrikeDmg + SSMHHits * MainHandStrikeDmg + SSOHHits * OffHandStrikeDmg
	--StrikeRageCost = StrikeRageCost + SSMHHits * MainHandStrikeRageCost + SSOHHits * OffHandStrikeRageCost
	StrikeRageCost = StrikeRageCost - SSMHHits * MaceSpecMHEffect - SSOHHits * MaceSpecOHEffect
	StrikeRageCost = StrikeRageCost + SSMHHits * totalHit * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	StrikeRageCost = StrikeRageCost + SSOHHits * totalHit * OffHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	

	local SweepingStrikesDmg = StrikeDmg
	local SweepingStrikesRageCost = StrikeRageCost
	if SweepingStrikesRageCost == 0 then
		SweepingStrikesRageCost = 0.00001
	end
	local SweepingStrikesMainHandCrits = SSMHHits * MainHandStrikeMainHandCrits
	local SweepingStrikesOffHandCrits = SSOHHits * OffHandStrikeOffHandCrits
	local SweepingStrikesRating = EquipEval:GetSpellRating(SweepingStrikesDmg, SweepingStrikesRageCost, GlobalCoolDown)
	if SweepingStrikesRating < 0 then
		SweepingStrikesRating = RampageRating - 2
	end
	local SweepingStrikesMaxStrikesPerSecond = 0
	if EquipEval:TalentRank(2,13) > 0 then
		SweepingStrikesMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local SweepingStrikesSwings = SSMHHits * MainHandStrikeSwings + SSOHHits * OffHandStrikeSwings
	
	
	--Shield Slam
	
	
	--Sunder Armor/Devastate
	StrikeDmg = 0
	StrikeRageCost = (15 - RageCostModifier - EquipEval:TalentRank(3,10))
	StrikeCritChance = totalCrit
	StrikeCoolDown = 25
	
	local UseDevastate = false
	if EquipEval:TalentRank(3,22) > 0 and not (string.find(CurrentWeaponTypeMain, "Two-Handed") ~= nil or CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "Staves") then
		UseDevastate = true
		StrikeRageCost = StrikeRageCost - MaceSpecMHEffect
	end
	
	if CurrentLevel >= 70 then
		StrikeDmg = 35 * 5
	elseif CurrentLevel >= 60 then
		StrikeDmg = 25 * 5
	elseif CurrentLevel >= 50 then
		StrikeDmg = 15 * 5
	end
	
	StrikeDmg = .5 * (APDamageModifier * effectiveAP / 14.0 * baseMainSpeed + mainBaseAvgDmg) + StrikeDmg
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	
	local DevastateDmg = StrikeDmg + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcDmg
	local DevastateRageCost = StrikeRageCost + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcRageCost
	local DevastateMainHandCrits = totalHitYellow * StrikeCritChance + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcMainHandCrits
	local DevastateRating = 0
	local DevastateMaxStrikesPerSecond = 0
	local DevastateSwings = 1 + totalHitYellow * MainHandSword * SwordSpecProcChance * SwordSpecProcSwings
	
	local SunderArmorRageCost = StrikeRageCost
	local SunderArmorMainHandCrits = 0
	local SunderArmorRating = 0
	local SunderArmorMaxStrikesPerSecond = 0
	if CurrentLevel >= 1 and EquipEval.db.profile["IncludeStrikes"] == 1 then
		SunderArmorMaxStrikesPerSecond = 1 / StrikeCoolDown
		if UseDevastate then
			DevastateMaxStrikesPerSecond = 1 / GlobalCoolDown - SunderArmorMaxStrikesPerSecond
		end
	end
	if ForceSunder then
		SunderArmorRating = RampageRating - 1
		DevastateRating = EquipEval:GetSpellRating(DevastateDmg, DevastateRageCost, GlobalCoolDown)
	end
	

	local TimeFraction = 1 / GlobalCoolDown
	local TotalDPS = 0
	local RagePerSecond = EquipEval:TalentRank(1,8) / 3
	local SwingsPerSecond = 0
	local MHCritsPerSecond = 0
	local OHCritsPerSecond = 0
	
	
	
	--Add White Damage
	--Main Hand
	TotalDPS = TotalDPS + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeDmg
	RagePerSecond = RagePerSecond - MainHandStrikeMaxStrikesPerSecond * MainHandStrikeRageCost
	MHCritsPerSecond = MHCritsPerSecond + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeMainHandCrits
	SwingsPerSecond = SwingsPerSecond + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeSwings
	
	--Off Hand
	TotalDPS = TotalDPS + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeDmg
	RagePerSecond = RagePerSecond - OffHandStrikeMaxStrikesPerSecond * OffHandStrikeRageCost
	OHCritsPerSecond = OHCritsPerSecond + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeOffHandCrits
	SwingsPerSecond = SwingsPerSecond + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeSwings
	

	--Deathwish
	if EquipEval:TalentRank(1,13) > 0 then
		RagePerSecond = RagePerSecond - 10 / 180
		TimeFraction = TimeFraction - 1 / 180
	end


	--Add Yellow Damage
	local OverPowerTimeFraction = 0
	while RagePerSecond > 0 and TimeFraction > 0 and EquipEval.db.profile["IncludeStrikes"] == 1 do
		local MaxRating = max(SlamRating, HeroicStrikeRating, MortalStrikeRating, BloodthirstRating, ExecuteRating, RampageRating, SweepingStrikesRating, BattleShoutRating, RendRating, WhirlwindRating, CleaveRating, SunderArmorRating, DevastateRating)
		local StrikeTimeFraction = 0
		local StrikeRageCost = 0

		if SwingsPerSecond > 0 then
			MaxRating = max(MaxRating, OverpowerRating)
		end
		
		if MaxRating <= 0 then
			break
		end
		
		if SlamRating == MaxRating then
			StrikeRageCost = SlamRageCost
			StrikeTimeFraction = SlamMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + SlamDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + SlamMainHandCrits * StrikeTimeFraction
			OHCritsPerSecond = OHCritsPerSecond + SlamOffHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + SlamSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			SlamRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Slam "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."Slam, "
			end
		elseif HeroicStrikeRating == MaxRating then
			StrikeRageCost = HeroicStrikeRageCost
			StrikeTimeFraction = HeroicStrikeMaxStrikesPerSecond
			
			StrikeTimeFraction = min(StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + HeroicStrikeDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + HeroicStrikeMainHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + HeroicStrikeSwings * StrikeTimeFraction
			
			HeroicStrikeRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Heroic Strike "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."HS, "
			end
		elseif MortalStrikeRating == MaxRating then
			StrikeRageCost = MortalStrikeRageCost
			StrikeTimeFraction = MortalStrikeMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + MortalStrikeDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + MortalStrikeMainHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + MortalStrikeSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			MortalStrikeRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Mortal Strike "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."MS, "
			end
		elseif OverpowerRating == MaxRating then
			StrikeRageCost = OverpowerRageCost
			StrikeTimeFraction = min(OverpowerMaxStrikesPerSecond, (1 - (1 - dodgeChance)^SwingsPerSecond))
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			OverPowerTimeFraction = OverPowerTimeFraction + StrikeTimeFraction
			OverpowerMaxStrikesPerSecond = OverpowerMaxStrikesPerSecond - StrikeTimeFraction
			SwingsPerSecond = OverpowerSwings
		elseif BloodthirstRating == MaxRating then
			StrikeRageCost = BloodthirstRageCost
			StrikeTimeFraction = BloodthirstMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + BloodthirstDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + BloodthirstMainHandCrits * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			BloodthirstRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Bloodthirst "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."BT, "
			end
		elseif ExecuteRating == MaxRating then
			StrikeRageCost = ExecuteRageCost
			StrikeTimeFraction = ExecuteMaxStrikesPerSecond
			
			StrikeTimeFraction = 0.2 * min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + ExecuteDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + ExecuteMainHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + ExecuteSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			ExecuteRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Execute "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."Exec, "
			end
		elseif RampageRating == MaxRating then
			StrikeRageCost = RampageRageCost
			StrikeTimeFraction = RampageMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost

			
			TimeFraction = TimeFraction - StrikeTimeFraction
			RampageRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Rampage "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."Ramp, "
			end
		elseif SweepingStrikesRating == MaxRating then
			StrikeRageCost = SweepingStrikesRageCost
			StrikeTimeFraction = SweepingStrikesMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + SweepingStrikesDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + SweepingStrikesMainHandCrits * StrikeTimeFraction
			OHCritsPerSecond = OHCritsPerSecond + SweepingStrikesOffHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + SweepingStrikesSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			SweepingStrikesRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Sweeping Strikes "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."SS, "
			end
		elseif BattleShoutRating == MaxRating then
			StrikeRageCost = BattleShoutRageCost
			StrikeTimeFraction = BattleShoutMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			BattleShoutRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Battle Shout "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."BS, "
			end
		elseif RendRating == MaxRating then
			StrikeRageCost = RendRageCost
			StrikeTimeFraction = RendMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + RendDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + RendMainHandCrits * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			RendRating = 0
			RendUptime = max(0, (StrikeTimeFraction / RendMaxStrikesPerSecond))
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Rend "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."Rend, "
			end
		elseif WhirlwindRating == MaxRating then
			StrikeRageCost = WhirlwindRageCost
			StrikeTimeFraction = WhirlwindMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + WhirlwindDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + WhirlwindMainHandCrits * StrikeTimeFraction
			OHCritsPerSecond = OHCritsPerSecond + WhirlwindOffHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + WhirlwindSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			WhirlwindRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Whirlwind "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."WW, "
			end
		elseif CleaveRating == MaxRating then
			StrikeRageCost = CleaveRageCost
			StrikeTimeFraction = CleaveMaxStrikesPerSecond
			
			StrikeTimeFraction = min(StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + CleaveDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + CleaveMainHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + CleaveSwings * StrikeTimeFraction
			
			CleaveRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Cleave "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."Cleave, "
			end
		elseif SunderArmorRating == MaxRating and not UseDevastate then
			StrikeRageCost = SunderArmorRageCost
			StrikeTimeFraction = SunderArmorMaxStrikesPerSecond
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			SunderArmorRating = 0
			if StrikeTimeFraction > 0 then
				self:Debug("Add Strike: Sunder Armor "..(StrikeTimeFraction * 100).."%")
				InfoLine = InfoLine.."SA, "
			end
		elseif (SunderArmorRating == MaxRating and UseDevastate) or (DevastateRating == MaxRating) then
			StrikeRageCost = DevastateRageCost
			StrikeTimeFraction = DevastateMaxStrikesPerSecond
			if SunderArmorRating == MaxRating then
				StrikeTimeFraction = SunderArmorMaxStrikesPerSecond
			end
			
			StrikeTimeFraction = min(TimeFraction, StrikeTimeFraction, (RagePerSecond / StrikeRageCost))
			RagePerSecond = RagePerSecond - StrikeTimeFraction * StrikeRageCost
			TotalDPS = TotalDPS + DevastateDmg * StrikeTimeFraction
			MHCritsPerSecond = MHCritsPerSecond + DevastateMainHandCrits * StrikeTimeFraction
			SwingsPerSecond = SwingsPerSecond + DevastateSwings * StrikeTimeFraction
			
			TimeFraction = TimeFraction - StrikeTimeFraction
			if SunderArmorRating == MaxRating then
				SunderArmorRating = 0
				if StrikeTimeFraction > 0 then
					self:Debug("Add Strike: Devastate "..(StrikeTimeFraction * 100).."%")
					InfoLine = InfoLine.."Dev, "
				end
			else
				DevastateRating = 0
				if StrikeTimeFraction > 0 then
					self:Debug("Add Strike: Devastate "..(StrikeTimeFraction * 100).."%")
				end
			end
		else
			break
		end
	end
	
	
	
	--Overpower
	if OverPowerTimeFraction > 0 then
		TotalDPS = TotalDPS + OverpowerDmg * OverPowerTimeFraction
		MHCritsPerSecond = MHCritsPerSecond + OverpowerMainHandCrits * OverPowerTimeFraction

		self:Debug("Add Strike: Overpower "..(OverPowerTimeFraction * 100).."%")
		InfoLine = InfoLine.."OP, "
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = nil
	end

	--Deep Wounds
	local DeepWoundsUptime = 0
	if EquipEval:TalentRank(1,9) > 0 then
		local DPSFromDeepWounds = 0
		
		--chance modelled at steady state
		local deepWoundsMainChance = (1 - (1 - MHCritsPerSecond)^12)
		deepWoundsMainChance = min(deepWoundsMainChance, 1)
		DPSFromDeepWounds = EquipEval:TalentRank(1,9) * 0.2 * (APDamageModifier * effectiveAP / 14.0 * baseMainSpeed + mainBaseAvgDmg) / 12 * deepWoundsMainChance

		local deepWoundsOffChance = (1 - (1 - OHCritsPerSecond)^12)
		deepWoundsOffChance = min(1, deepWoundsOffChance)
		deepWoundsOffChance = (1 - deepWoundsMainChance) * deepWoundsOffChance
		DPSFromDeepWounds = DPSFromDeepWounds + EquipEval:TalentRank(1,9) * 0.2 * (offHandModifier * APDamageModifier * effectiveAP / 14.0 * baseOffSpeed + offBaseAvgDmg) / 12 * deepWoundsOffChance


		DeepWoundsUptime = (1 - (1 - deepWoundsMainChance) * (1 - deepWoundsOffChance))
		DeepWoundsUptime = DeepWoundsUptime * (1 - EquipEval.db.profile["EnemyIsBleedImmune"])


		if EquipEval.db.profile['PermanentMangleOnTarget'] > 0 then
			DPSFromDeepWounds = DPSFromDeepWounds * 1.3
		end
		DPSFromDeepWounds = DPSFromDeepWounds * (1 - resilienceEffect) * (1 - EquipEval.db.profile["EnemyIsBleedImmune"])
		self:Debug("DPS From Deep Wounds: "..DPSFromDeepWounds)
	end
	
	
	--Flurry
	local FlurryUptime = 0
	if EquipEval:TalentRank(2,16) > 0 then
		local FlurryChance = (1 - (1 - MHCritsPerSecond) * (1 - OHCritsPerSecond))
		local FlurryDuration = 3 / (MainHandStrikeMaxStrikesPerSecond + OffHandStrikeMaxStrikesPerSecond)
		
		FlurryUptime = min(1, (1 - (1 - FlurryChance)^(FlurryDuration)))
	end
	
	
	--Blood Frenzy
	local BloodFrenzyUptime = (1 - (1 - RendUptime) * (1 - DeepWoundsUptime))
	TotalDPS = TotalDPS * (1 + EquipEval:TalentRank(1,19) * 0.02 * BloodFrenzyUptime)
	
	--Deathwish
	TotalDPS = TotalDPS * (1 + EquipEval:TalentRank(1,13) * 0.2 * 30 / 180)

	return TotalDPS, FlurryUptime, InfoLine
end




---------------------------------------------------------------------------------------
-- Used to calculate Warrior Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarriorMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (0.05 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = ((self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference()))
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..blockChance)

	local stanceModifier = 1
	local stanceIndex = GetShapeshiftForm(true);
	if stanceIndex == 2 then
		stanceModifier = 0.9
	elseif stanceIndex == 3 then
		stanceModifier = 1.1
	end


	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")


	--Factor in stats
	armor = armor * (1 + EquipEval:TalentRank(3,5) * .02)

	stamMultiplier = stamMultiplier * (1 + EquipEval:TalentRank(3,21) * .01)

	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 currently
	dodgeChance = dodgeChance + (agi / 30.0) / 100
	self:Debug("Dodge %: "..dodgeChance)

	parryChance = parryChance + defensePercent
	parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)


	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end
