

local Bonus = AceLibrary("LibItemBonus-2.0")



local eqevIntTableWarlock = {
6.67, 6.97, 7.27, 7.58, 7.88, 8.18, 8.48, 8.79, 9.09, 9.39, 
10.3, 11.21, 12.12, 13.04, 13.95, 14.53, 15.75, 16.67, 17.57, 18.48, 
19.38, 20.28, 21.23, 22.42, 23.31, 23.92, 25.13, 26.04, 27.25, 28.17, 
28.82, 30.03, 30.86, 32.15, 33, 33.9, 35.21, 36.1, 37.31, 38.17, 
39.06, 40.32, 41.15, 42.37, 43.67, 44.64, 45.45, 46.73, 47.85, 49.02, 
50, 51.28, 52.36, 53.76, 54.95, 55.87, 56.82, 58.14, 59.52, 60.61, 
62.89, 64.94, 67.57, 69.93, 72.46, 74.07, 76.92, 78.74, 80, 81.97 }









---------------------------------------------------------------------------------------
-- Used to calculate Warlock DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarlockDPS(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str, stam, arcanedmg, spellpen, _, _, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTableWarlock[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,20) * 0.01) * (1 + TotalModInt / 100)
	local SpiModifier = 1 - EquipEval:TalentRank(2,3) * 0.01
	local ManaModifier = 1 + EquipEval:TalentRank(2,6) * 0.01

	local StamModifier = 1 + EquipEval:TalentRank(2,3) * 0.03
	local PetIntModifier = 0.3 * (1 + EquipEval:TalentRank(2,6) * 0.05)
	local PetStamModifier = 0.3 * (1 + EquipEval:TalentRank(2,9) * 0.05)

	local CastingRegen = 0

	
	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local itemStam = stam * StamModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemDmg = spelldmg + EquipEval:TalentRank(2,20) * 0.04 * (PetIntModifier * itemInt + PetStamModifier * itemStam)
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemHit = (hit / 8.0 * LevelRating) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + CastingRegen * SpiritEffect


	local baseDPS = EquipEval:CalculateWarlockDPSFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0)
	local newDPS, InfoLine = EquipEval:CalculateWarlockDPSFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), SpiritEffect, itemCrit, (itemDmg + BonusSpellDmg), (itemHaste + BonusSpellHaste), itemHit, shadowdmg, firedmg, spellpen, spellcritbonus)

	return (newDPS - baseDPS), newDPS, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Warlock DPS From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarlockDPSFromStats(CurrentLevel, LevelRating, mana, mp5, spiMP5, crit, spelldmg, haste, hit, shadowdmg, firedmg, spellpen, spellcritbonus)
	local InfoLine = "Spells: "

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100

	local CritModifier = 0.5 * (1 + EquipEval:TalentRank(3,14))
	CritModifier = (CritModifier + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local ManaCostModifier = 1
	self:Debug("Mana Cost Modifier: "..ManaCostModifier)

	local _, _, _, _, _, _, percentmod = UnitDamage("player");
	local DamageModifier = (1 + EquipEval:TalentRank(2,19) * 0.05) * percentmod
	self:Debug("Damage Modifier: "..DamageModifier)

	local totalCritS = GetSpellCritChance(6)
	totalCritS = totalCritS + EquipEval:TalentRank(3,7)
	totalCritS = totalCritS + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritS = max(0, (totalCritS / 100 + crit - resilienceEffect))
	totalCritS = min(1, totalCritS * EquipEval.db.profile["BurstFactor"])
	self:Debug("Shadow Crit: "..totalCritS)

	local totalCritF = GetSpellCritChance(3)
	totalCritF = totalCritF + EquipEval:TalentRank(3,7)
	totalCritF = totalCritF + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritF = max(0, (totalCritF / 100 + crit - resilienceEffect))
	totalCritF = min(1, totalCritF * EquipEval.db.profile["BurstFactor"])
	self:Debug("Fire Crit: "..totalCritF)

	local totalHit = EquipEval:GetSpellHitChance() + hit
	totalHit = totalHit
	totalHit = totalHit + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	local totalHitAffliction = max(0.01, (1 - (1 - (totalHit + EquipEval:TalentRank(1,1) * 0.02)) / EquipEval.db.profile["BurstFactor"]))
	totalHit = max(0.01, (1 - (1 - totalHit) / EquipEval.db.profile["BurstFactor"]))
	totalHitAffliction = min(0.99, totalHitAffliction)
	totalHit = min(0.99, totalHit)
	self:Debug("Total Hit: "..totalHit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenCasting
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]

	self:Debug("Total MP5: "..totalMP5)

	local totalDmgS = GetSpellBonusDamage(6) + spelldmg + shadowdmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total Shadow Dmg: "..totalDmgS)

	local totalDmgF = GetSpellBonusDamage(3) + spelldmg + firedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total Fire Dmg: "..totalDmgF)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	--Check for sacrificed demons
	local FireMultiplier = 1
	local ShadowMultiplier = 1
	if GetPlayerBuffName("Burning Wish") then
		FireMultiplier = 1.15
	elseif GetPlayerBuffName("Touch of Shadow") then
		ShadowMultiplier = 1.15
	elseif GetPlayerBuffName("Fel Energy") then
		totalMP5 = totalMP5 + totalMana * 0.03 * 5 / 4
	end


	local ResistanceModifier = EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	local ResistanceModifierCoS = ResistanceModifier
	local ResistanceModifierCoE = ResistanceModifier
	local DamageModifierCoS = DamageModifier
	local DamageModifierCoE = DamageModifier
	
	local SpellListNormal = { }
	local SpellListCoS = { }
	local SpellListCoE = { }

	for CurseSelection = 1, 2 do
		local TimeFraction = 1
		local SpellDPS = 0
		local SpellMPS = 0
		local CastTime = 0
		local SpellDuration = 0
		local SpellCritChance = 0
		local SpellHitChance = 0
		local SpellList = { }
		
		local ResistanceModifierFire = ResistanceModifier
		local ResistanceModifierShadow = ResistanceModifier
		local DamageModifierFire = DamageModifier
		local DamageModifierShadow = DamageModifier

		if CurseSelection == 1 then
		elseif CurseSelection == 2 then
			DamageModifierFire = DamageModifierCoE
			ResistanceModifierFire = ResistanceModifierCoE
			DamageModifierShadow = DamageModifierCoE
			ResistanceModifierShadow = ResistanceModifierCoE
		end


		--Curse of the Elements
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 0
		SpellDuration = 5 * 60
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction * ResistanceModifierShadow
		if CurrentLevel >= 32 and TimeFraction > 0 then
			local ResistanceEffect = 0
			local DamageEffect = 1

			if CurrentLevel >= 69 then
				ResistanceEffect = 88
				DamageEffect = 1.10
				SpellMPS = 260
			elseif CurrentLevel >= 60 then
				ResistanceEffect = 75
				DamageEffect = 1.10
				SpellMPS = 200
			elseif CurrentLevel >= 46 then
				ResistanceEffect = 60
				DamageEffect = 1.08
				SpellMPS = 150
			elseif CurrentLevel >= 32 then
				ResistanceEffect = 45
				DamageEffect = 1.06
				SpellMPS = 100
			end
			
			DamageEffect = DamageEffect + 0.01 * EquipEval:TalentRank(1,20)
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance

			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS
			
			ResistanceModifierCoE = EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen + ResistanceEffect)
			DamageModifierCoE = DamageModifier * DamageEffect

			SpellList["Curse of the Elements"] = { }
			SpellList["Curse of the Elements"].Abbreviation = "CoE"
			SpellList["Curse of the Elements"].Type = "Curse"
			SpellList["Curse of the Elements"].School = "Shadow"
			SpellList["Curse of the Elements"].CastTime = CastTime
			SpellList["Curse of the Elements"].DPS = 0
			SpellList["Curse of the Elements"].MPS = SpellMPS / CastTime
			SpellList["Curse of the Elements"].MaxTimeFraction = CastTime / SpellDuration
		end
		

		--Life Tap
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 0
		SpellDuration = 0
		SpellCritChance = 0
		SpellHitChance = 1
		if CurrentLevel >= 6 then

			if CurrentLevel >= 68 then
				SpellDPS = 580
			elseif CurrentLevel >= 56 then
				SpellDPS = 420
			elseif CurrentLevel >= 46 then
				SpellDPS = 300
			elseif CurrentLevel >= 36 then
				SpellDPS = 210
			elseif CurrentLevel >= 26 then
				SpellDPS = 130
			elseif CurrentLevel >= 16 then
				SpellDPS = 65
			elseif CurrentLevel >= 6 then
				SpellDPS = 20
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

			SpellDPS = (1 + EquipEval:TalentRank(1,5) * 0.1) * (SpellDPS + totalDmgS * 0.80)
			SpellMPS = (1 + EquipEval:TalentRank(1,5) * 0.1) * -SpellDPS
			
			SpellList["Life Tap"] = { }
			SpellList["Life Tap"].Abbreviation = "LT"
			SpellList["Life Tap"].Type = "Self"
			SpellList["Life Tap"].School = "None"
			SpellList["Life Tap"].CastTime = CastTime
			SpellList["Life Tap"].DPS = 0
			SpellList["Life Tap"].MPS = SpellMPS / CastTime
			SpellList["Life Tap"].MaxTimeFraction = 1
		end


		--Unstable Affliction
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 1.5
		SpellDuration = 18
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction
		if EquipEval:TalentRank(1,21) > 0 and TimeFraction > 0 then	
			if CurrentLevel >= 70 then
				SpellDPS = 1050
				SpellMPS = 400
			elseif CurrentLevel >= 60 then
				SpellDPS = 840
				SpellMPS = 330
			elseif CurrentLevel >= 50 then
				SpellDPS = 660
				SpellMPS = 270
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance
			
			SpellDPS = ShadowMultiplier * DamageModifierShadow * ResistanceModifierShadow * (1 - resilienceEffect) * (1 + EquipEval:TalentRank(1,16) * 0.02) * (SpellDPS + totalDmgS * 1.2)
			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS
					
			SpellList["Unstable Affliction"] = { }
			SpellList["Unstable Affliction"].Abbreviation = "UA"
			SpellList["Unstable Affliction"].Type = "DoT"
			SpellList["Unstable Affliction"].School = "Shadow"
			SpellList["Unstable Affliction"].CastTime = CastTime
			SpellList["Unstable Affliction"].DPS = SpellDPS / CastTime
			SpellList["Unstable Affliction"].MPS = SpellMPS / CastTime
			SpellList["Unstable Affliction"].MaxTimeFraction = CastTime / SpellDuration
		end



		--Siphon Life
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 0
		SpellDuration = 30
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction
		if EquipEval:TalentRank(1,14) > 0 and TimeFraction > 0 then
		
			if CurrentLevel >= 70 then
				SpellDPS = 630
				SpellMPS = 410
			elseif CurrentLevel >= 63 then
				SpellDPS = 520
				SpellMPS = 350
			elseif CurrentLevel >= 58 then
				SpellDPS = 450
				SpellMPS = 310
			elseif CurrentLevel >= 48 then
				SpellDPS = 330
				SpellMPS = 250
			elseif CurrentLevel >= 38 then
				SpellDPS = 220
				SpellMPS = 190
			elseif CurrentLevel >= 30 then
				SpellDPS = 150
				SpellMPS = 140
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance
		
			SpellDPS = ShadowMultiplier * DamageModifierShadow * ResistanceModifierShadow * (1 - resilienceEffect) * (1 + EquipEval:TalentRank(1,16) * 0.02) * (SpellDPS + totalDmgS)
			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS
			
			SpellList["Siphon Life"] = { }
			SpellList["Siphon Life"].Abbreviation = "SL"
			SpellList["Siphon Life"].Type = "DoT"
			SpellList["Siphon Life"].School = "Shadow"
			SpellList["Siphon Life"].CastTime = CastTime
			SpellList["Siphon Life"].DPS = SpellDPS / CastTime
			SpellList["Siphon Life"].MPS = SpellMPS / CastTime
			SpellList["Siphon Life"].MaxTimeFraction = CastTime / SpellDuration
		end


		--Corruption
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 2 - EquipEval:TalentRank(1,2) * 0.4
		SpellDuration = 18
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction
		if CurrentLevel >= 4 and TimeFraction > 0 then

			if CurrentLevel >= 65 then
				SpellDPS = 900
				SpellMPS = 370
			elseif CurrentLevel >= 60 then
				SpellDPS = 822
				SpellMPS = 340
			elseif CurrentLevel >= 54 then
				SpellDPS = 666
				SpellMPS = 290
			elseif CurrentLevel >= 44 then
				SpellDPS = 486
				SpellMPS = 225
			elseif CurrentLevel >= 34 then
				SpellDPS = 324
				SpellMPS = 160
			elseif CurrentLevel >= 24 then
				SpellDPS = 222
				SpellMPS = 100
			elseif CurrentLevel >= 14 then
				SpellDPS = 90
				SpellMPS = 55
			elseif CurrentLevel >= 4 then
				SpellDPS = 40
				SpellMPS = 35
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance

			SpellDPS = ShadowMultiplier * DamageModifierShadow * ResistanceModifierShadow * (1 - resilienceEffect) * (1 + EquipEval:TalentRank(1,16) * 0.02) * (1 + EquipEval:TalentRank(1,17) * 0.01) * (SpellDPS + totalDmgS * (0.93 + 0.12 * EquipEval:TalentRank(1,12)))
			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS
			
			SpellList["Corruption"] = { }
			SpellList["Corruption"].Abbreviation = "Cor"
			SpellList["Corruption"].Type = "DoT"
			SpellList["Corruption"].School = "Shadow"
			SpellList["Corruption"].CastTime = CastTime
			SpellList["Corruption"].DPS = SpellDPS / CastTime
			SpellList["Corruption"].MPS = SpellMPS / CastTime
			SpellList["Corruption"].MaxTimeFraction = CastTime / SpellDuration
		end
		

		--Seed of Corruption Not Yet Modeled


		--Curse of Agony
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 0
		SpellDuration = 24
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction
		if CurrentLevel >= 8 and TimeFraction > 0 then

			if CurrentLevel >= 67 then
				SpellDPS = 1356
				SpellMPS = 275
			elseif CurrentLevel >= 58 then
				SpellDPS = 1044
				SpellMPS = 215
			elseif CurrentLevel >= 48 then
				SpellDPS = 780
				SpellMPS = 170
			elseif CurrentLevel >= 38 then
				SpellDPS = 504
				SpellMPS = 130
			elseif CurrentLevel >= 28 then
				SpellDPS = 324
				SpellMPS = 90
			elseif CurrentLevel >= 18 then
				SpellDPS = 180
				SpellMPS = 50
			elseif CurrentLevel >= 8 then
				SpellDPS = 84
				SpellMPS = 25
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance

			SpellDPS = ShadowMultiplier * DamageModifierShadow * ResistanceModifierShadow * (1 - resilienceEffect) * (1 + EquipEval:TalentRank(1,16) * 0.02) * (1 + EquipEval:TalentRank(1,17) * 0.01) * (1 + EquipEval:TalentRank(1,7) * 0.05) * (SpellDPS + totalDmgS * 1.2)
			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS

			SpellList["Curse of Agony"] = { }
			SpellList["Curse of Agony"].Abbreviation = "CoA"
			SpellList["Curse of Agony"].Type = "Curse"
			SpellList["Curse of Agony"].School = "Shadow"
			SpellList["Curse of Agony"].CastTime = CastTime
			SpellList["Curse of Agony"].DPS = SpellDPS / CastTime
			SpellList["Curse of Agony"].MPS = SpellMPS / CastTime
			SpellList["Curse of Agony"].MaxTimeFraction = CastTime / SpellDuration
		end



		--Immolate
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 2 - EquipEval:TalentRank(3,3) * 0.1
		SpellDuration = 15
		SpellCritChance = totalCritF
		SpellHitChance = totalHit
		if TimeFraction > 0 then

			if CurrentLevel >= 69 then
				SpellDPS = (327)
				SpellMPS = 445
			elseif CurrentLevel >= 60 then
				SpellDPS = (279)
				SpellMPS = 380
			elseif CurrentLevel >= 50 then
				SpellDPS = (192)
				SpellMPS = 295
			elseif CurrentLevel >= 40 then
				SpellDPS = (134)
				SpellMPS = 220
			elseif CurrentLevel >= 30 then
				SpellDPS = (90)
				SpellMPS = 155
			elseif CurrentLevel >= 20 then
				SpellDPS = (45)
				SpellMPS = 90
			elseif CurrentLevel >= 10 then
				SpellDPS = (19)
				SpellMPS = 45
			elseif CurrentLevel >= 1 then
				SpellDPS = (8)
				SpellMPS = 25
			end

			SpellDPS = (1 + EquipEval:TalentRank(3,13) * 0.05) * (SpellDPS + totalDmgF * 0.20) * (1 + SpellCritChance * CritModifier)

			if CurrentLevel >= 69 then
				SpellDPS = SpellDPS + (615 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 60 then
				SpellDPS = SpellDPS + (510 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 50 then
				SpellDPS = SpellDPS + (365 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 40 then
				SpellDPS = SpellDPS + (255 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 30 then
				SpellDPS = SpellDPS + (165 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 20 then
				SpellDPS = SpellDPS + (90 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 10 then
				SpellDPS = SpellDPS + (40 + totalDmgF * 0.65) * (1 - resilienceEffect)
			elseif CurrentLevel >= 1 then
				SpellDPS = SpellDPS + (20 + totalDmgF * 0.65) * (1 - resilienceEffect)
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / SpellHitChance

			SpellDPS = FireMultiplier * DamageModifierFire * ResistanceModifierFire * (1 + EquipEval:TalentRank(3,16)) * SpellDPS
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS / SpellHitChance
			
			SpellList["Immolate"] = { }
			SpellList["Immolate"].Abbreviation = "Immo"
			SpellList["Immolate"].Type = "Hybrid"
			SpellList["Immolate"].School = "Fire"
			SpellList["Immolate"].CastTime = CastTime
			SpellList["Immolate"].DPS = SpellDPS / CastTime
			SpellList["Immolate"].MPS = SpellMPS / CastTime
			SpellList["Immolate"].MaxTimeFraction = CastTime / SpellDuration
		end

		
		--Incinerate
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 2.5 * (1 - 0.02 * EquipEval:TalentRank(3,16))
		SpellDuration = 0
		SpellCritChance = totalCritF
		SpellHitChance = totalHit
		if TimeFraction > 0 and CurrentLevel >= 64 then

			if CurrentLevel >= 70 then
				SpellDPS = (444 + 514) / 2
				SpellMPS = 355
			elseif CurrentLevel >= 64 then
				SpellDPS = (357 + 413) / 2
				SpellMPS = 325
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"])

			SpellDPS = FireMultiplier * DamageModifierFire * ResistanceModifierFire * SpellHitChance * (1 + EquipEval:TalentRank(3,16)) * (SpellDPS + totalDmgF * (2.5 / 3.5 + EquipEval:TalentRank(3,20) * 0.04)) * (1 + SpellCritChance * CritModifier)
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS
			
			SpellList["Incinerate"] = { }
			SpellList["Incinerate"].Abbreviation = "Incin"
			SpellList["Incinerate"].Type = "DD"
			SpellList["Incinerate"].School = "Fire"
			SpellList["Incinerate"].CastTime = CastTime
			SpellList["Incinerate"].DPS = SpellDPS / CastTime
			SpellList["Incinerate"].MPS = SpellMPS / CastTime
			SpellList["Incinerate"].MaxTimeFraction = 1
		end
		
		
		--Incinerate w/ Immolate Bonus
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 2.5
		SpellDuration = 0
		SpellCritChance = totalCritF
		SpellHitChance = totalHit
		if TimeFraction > 0 and CurrentLevel >= 64 then

			if CurrentLevel >= 70 then
				SpellDPS = (444 + 514) / 2 + (89 + 104) / 2
				SpellMPS = 355
			elseif CurrentLevel >= 64 then
				SpellDPS = (357 + 413) / 2 + (111 + 129) / 2
				SpellMPS = 325
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"])

			SpellDPS = FireMultiplier * DamageModifierFire * ResistanceModifierFire * SpellHitChance * (1 + EquipEval:TalentRank(3,16)) * (SpellDPS + totalDmgF * (2.5 / 3.5 + EquipEval:TalentRank(3,20) * 0.04)) * (1 + SpellCritChance * CritModifier)
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS
			
			SpellList["Incinerate w/ Immolate Bonus"] = { }
			SpellList["Incinerate w/ Immolate Bonus"].Abbreviation = "Incin"
			SpellList["Incinerate w/ Immolate Bonus"].Type = "DD"
			SpellList["Incinerate w/ Immolate Bonus"].School = "Fire"
			SpellList["Incinerate w/ Immolate Bonus"].CastTime = CastTime
			SpellList["Incinerate w/ Immolate Bonus"].DPS = SpellDPS / CastTime
			SpellList["Incinerate w/ Immolate Bonus"].MPS = SpellMPS / CastTime
			SpellList["Incinerate w/ Immolate Bonus"].MaxTimeFraction = 1
			SpellList["Incinerate w/ Immolate Bonus"].RequiresSpell = "Immolate"
			SpellList["Incinerate w/ Immolate Bonus"].OverridesSpell = "Incinerate"
		end
		
		
		--Conflagrate
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 0
		SpellDuration = 15
		SpellCritChance = totalCritF
		SpellHitChance = totalHit
		if TimeFraction > 0 and EquipEval:TalentRank(3,18) > 0 then

			if CurrentLevel >= 70 then
				SpellDPS = (632 + 788) / 2
				SpellMPS = 405
			elseif CurrentLevel >= 65 then
				SpellDPS = (512 + 638) / 2
				SpellMPS = 360
			elseif CurrentLevel >= 60 then
				SpellDPS = (447 + 557) / 2
				SpellMPS = 255
			elseif CurrentLevel >= 54 then
				SpellDPS = (383 + 479) / 2
				SpellMPS = 230
			elseif CurrentLevel >= 48 then
				SpellDPS = (316 + 396) / 2
				SpellMPS = 200
			elseif CurrentLevel >= 40 then
				SpellDPS = (240 + 306) / 2
				SpellMPS = 165
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"])

			SpellDPS = FireMultiplier * DamageModifierFire * ResistanceModifierFire * SpellHitChance * (1 + EquipEval:TalentRank(3,16)) * (SpellDPS + totalDmgF * 1.5 / 3.5) * (1 + SpellCritChance * CritModifier)
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS
			
			SpellList["Conflagrate"] = { }
			SpellList["Conflagrate"].Abbreviation = "Conflag"
			SpellList["Conflagrate"].Type = "DD"
			SpellList["Conflagrate"].School = "Fire"
			SpellList["Conflagrate"].CastTime = CastTime
			SpellList["Conflagrate"].DPS = SpellDPS / CastTime
			SpellList["Conflagrate"].MPS = SpellMPS / CastTime
			SpellList["Conflagrate"].MaxTimeFraction = CastTime / SpellDuration
			SpellList["Conflagrate"].RequiresSpell = "Immolate"
		end
		
		
		--Searing Pain
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 1.5
		SpellDuration = 0
		SpellCritChance = totalCritF
		if EquipEval:TalentRank(3,11) > 0 then
			SpellCritChance = SpellCritChance + (EquipEval:TalentRank(3,11) * 0.03 + 0.01) * EquipEval.db.profile["BurstFactor"]
		end
		SpellCritChance = min(1, SpellCritChance)
		SpellHitChance = totalHit
		if TimeFraction > 0 and CurrentLevel >= 18 then

			if CurrentLevel >= 70 then
				SpellDPS = (270 + 320) / 2
				SpellMPS = 205
			elseif CurrentLevel >= 65 then
				SpellDPS = (243 + 287) / 2
				SpellMPS = 191
			elseif CurrentLevel >= 58 then
				SpellDPS = (204 + 240) / 2
				SpellMPS = 168
			elseif CurrentLevel >= 50 then
				SpellDPS = (158 + 188) / 2
				SpellMPS = 141
			elseif CurrentLevel >= 42 then
				SpellDPS = (122 + 146) / 2
				SpellMPS = 118
			elseif CurrentLevel >= 34 then
				SpellDPS = (86 + 104) / 2
				SpellMPS = 91
			elseif CurrentLevel >= 26 then
				SpellDPS = (59 + 71) / 2
				SpellMPS = 68
			elseif CurrentLevel >= 18 then
				SpellDPS = (34 + 42) / 2
				SpellMPS = 45
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"])

			SpellDPS = FireMultiplier * DamageModifierFire * ResistanceModifierFire * SpellHitChance * (1 + EquipEval:TalentRank(3,16)) * (SpellDPS + totalDmgF * 1.5 / 3.5) * (1 + SpellCritChance * CritModifier)
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS
			
			SpellList["Searing Pain"] = { }
			SpellList["Searing Pain"].Abbreviation = "SP"
			SpellList["Searing Pain"].Type = "DD"
			SpellList["Searing Pain"].School = "Fire"
			SpellList["Searing Pain"].CastTime = CastTime
			SpellList["Searing Pain"].DPS = SpellDPS / CastTime
			SpellList["Searing Pain"].MPS = SpellMPS / CastTime
			SpellList["Searing Pain"].MaxTimeFraction = CastTime / SpellDuration
			if not EquipEval.db.profile["AllowSearingPain"] then
				SpellList["Searing Pain"].MaxTimeFraction = 0
			end
		end


		--Shadow Bolt
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 3 - EquipEval:TalentRank(3,3) * 0.1
		SpellDuration = 0
		SpellCritChance = totalCritS
		SpellHitChance = totalHit * ResistanceModifierShadow
		if TimeFraction > 0 then
			if CurrentLevel >= 69 then
				SpellDPS = (541 + 603) / 2
				SpellMPS = 420
			elseif CurrentLevel >= 62 then
				SpellDPS = (482 + 538) / 2
				SpellMPS = 380
			elseif CurrentLevel >= 60 then
				SpellDPS = (392 + 506) / 2
				SpellMPS = 370
			elseif CurrentLevel >= 52 then
				SpellDPS = (360 + 402) / 2
				SpellMPS = 315
			elseif CurrentLevel >= 44 then
				SpellDPS = (281 + 315) / 2
				SpellMPS = 265
			elseif CurrentLevel >= 36 then
				SpellDPS = (204 + 230) / 2
				SpellMPS = 210
			elseif CurrentLevel >= 28 then
				SpellDPS = (142 + 162) / 2
				SpellMPS = 160
			elseif CurrentLevel >= 20 then
				SpellDPS = (86 + 98) / 2
				SpellMPS = 110
			elseif CurrentLevel >= 12 then
				SpellDPS = (48 + 56) / 2
				SpellMPS = 70
			elseif CurrentLevel >= 6 then
				SpellDPS = (23 + 29) / 2
				SpellMPS = 40
			elseif CurrentLevel >= 1 then
				SpellDPS = (12 + 16) / 2
				SpellMPS = 25
			end
			
			CastTime = CastTime / (1 + totalHaste)
			CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

			SpellDPS = ShadowMultiplier * DamageModifierShadow * (1 + EquipEval:TalentRank(1,16) * 0.02) * SpellHitChance * (1 + SpellCritChance * CritModifier) * (SpellDPS + totalDmgS * (3.0 / 3.5 + EquipEval:TalentRank(3,20) * 0.04))
			SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,2) * 0.01) * SpellMPS

			SpellList["Shadow Bolt"] = { }
			SpellList["Shadow Bolt"].Abbreviation = "SB"
			SpellList["Shadow Bolt"].Type = "DD"
			SpellList["Shadow Bolt"].School = "Shadow"
			SpellList["Shadow Bolt"].CastTime = CastTime
			SpellList["Shadow Bolt"].DPS = SpellDPS / CastTime
			SpellList["Shadow Bolt"].MPS = SpellMPS / CastTime
			SpellList["Shadow Bolt"].MaxTimeFraction = 1
			SpellList["Shadow Bolt"].CritChance = SpellCritChance * SpellHitChance
		end


		--Drain Life
		SpellDPS = 0
		SpellMPS = 0
		CastTime = 5
		CastTime = CastTime / (1 + totalHaste)
		SpellDuration = 0
		SpellCritChance = 0
		SpellHitChance = totalHitAffliction * ResistanceModifierShadow
		if CurrentLevel >= 14 and TimeFraction > 0 then
			if CurrentLevel >= 69 then
				SpellDPS = 108 * 5
				SpellMPS = 425
			elseif CurrentLevel >= 62 then
				SpellDPS = 87 * 5
				SpellMPS = 355
			elseif CurrentLevel >= 54 then
				SpellDPS = 71 * 5
				SpellMPS = 300
			elseif CurrentLevel >= 46 then
				SpellDPS = 55 * 5
				SpellMPS = 240
			elseif CurrentLevel >= 38 then
				SpellDPS = 41 * 5
				SpellMPS = 185
			elseif CurrentLevel >= 30 then
				SpellDPS = 29 * 5
				SpellMPS = 135
			elseif CurrentLevel >= 22 then
				SpellDPS = 17 * 5
				SpellMPS = 85
			elseif CurrentLevel >= 14 then
				SpellDPS = 10 * 5
				SpellMPS = 55
			end
			
			CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
			CastTime = CastTime + (1 / SpellHitChance - 1) * (EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"])
			
			SpellDPS = ShadowMultiplier * DamageModifierShadow * (1 - resilienceEffect) * (1 + EquipEval:TalentRank(1,16) * 0.02) * (SpellDPS + totalDmgS * 0.7143)
			SpellMPS = ManaCostModifier / SpellHitChance * SpellMPS

			SpellList["Drain Life"] = { }
			SpellList["Drain Life"].Abbreviation = "DL"
			SpellList["Drain Life"].Type = "Channel"
			SpellList["Drain Life"].School = "Shadow"
			SpellList["Drain Life"].CastTime = CastTime
			SpellList["Drain Life"].DPS = SpellDPS / CastTime
			SpellList["Drain Life"].MPS = SpellMPS / CastTime
			SpellList["Drain Life"].MaxTimeFraction = 1
		end
		
		if CurseSelection == 1 then
			SpellListNormal = EquipEval:CopySpellList(SpellList)
		elseif CurseSelection == 2 then
			SpellListCoE = EquipEval:CopySpellList(SpellList)
		end
	end




	--Choose Spells
	local TotalDPS = 0
	local TotalMPS = 0
	local ChosenCycle = { }
	
	for CurseSelection = 1, 2 do
		local SpellList = { }
		local SpellCycle = { }
		local TimeFraction = 1
		local CycleMPS = -totalMP5 / 5
		local CurseUsed = 0
		
		if CurseSelection == 1 then
			SpellList = EquipEval:CopySpellList(SpellListNormal)
		elseif CurseSelection == 2 and SpellListCoE["Curse of the Elements"] then
			SpellList = EquipEval:CopySpellList(SpellListCoE)
			local CurseTimeFraction = min(1, (SpellList["Curse of the Elements"].MaxTimeFraction * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])))
			SpellCycle["Curse of the Elements"] = CurseTimeFraction
			TimeFraction = TimeFraction - CurseTimeFraction
			CycleMPS = CycleMPS + SpellList["Curse of the Elements"].MPS * CurseTimeFraction
			CurseUsed = 1
		end
		
		if CycleMPS > 0 and SpellList["Life Tap"] then
			local LifeTapTF = min(TimeFraction, (CycleMPS / -SpellList["Life Tap"].MPS))
			SpellCycle["Life Tap"] = LifeTapTF
			TimeFraction = TimeFraction - LifeTapTF
		end
		
		while TimeFraction > 0 do
			local MaxRating = 0
			local MaxRatedSpellCycle = { }
			local MaxRatedMPS = 0
			local MaxRatedTF = 0
			
			for SpellName,SpellTable in pairs(SpellList) do
				if (SpellTable.Type ~= "Self") and (SpellTable.Type ~= "Curse" or CurseUsed == 0) and SpellTable.MaxTimeFraction > 0 then
					local TempSpellCycle = EquipEval:CopySpellCycle(SpellCycle)
					local TempRating = 0
					local TempMPS = CycleMPS
					local TempTF = TimeFraction
					
					if SpellTable.RequiresSpell and not TempSpellCycle[SpellTable.RequiresSpell]then
						TempSpellCycle = EquipEval:WarlockAddSpellToSpellCycle(SpellList, TempSpellCycle, SpellTable.RequiresSpell, SpellList[SpellTable.RequiresSpell], TempTF, TempMPS)
						TempRating, TempMPS, TempTF = EquipEval:CalculateWarlockDPSFromSpellCycle(SpellList, TempSpellCycle)
						TempTF = (1 - TempTF)
					end
				
					TempSpellCycle = EquipEval:WarlockAddSpellToSpellCycle(SpellList, TempSpellCycle, SpellName, SpellTable, TempTF, TempMPS)
					
					TempRating, TempMPS, TempTF = EquipEval:CalculateWarlockDPSFromSpellCycle(SpellList, TempSpellCycle)
					TempRating = TempRating / TempTF
					
					if TempRating > MaxRating then
						MaxRating = TempRating
						MaxRatedSpellCycle = TempSpellCycle
						MaxRatedMPS = -totalMP5 / 5 + TempMPS
						MaxRatedTF = TempTF
					end
				end
			end
			
			if MaxRating <= 0 then
				break
			else
				SpellCycle = MaxRatedSpellCycle
				CycleMPS = MaxRatedMPS
				TimeFraction = (1 - MaxRatedTF)
				
				for SpellName,SpellTimeFraction in pairs(SpellCycle) do
					if SpellList[SpellName].MaxTimeFraction > 0 then
						SpellList[SpellName].MaxTimeFraction = 0
						
						if SpellList[SpellName].OverridesSpell and SpellList[SpellList[SpellName].OverridesSpell] then
							SpellList[SpellList[SpellName].OverridesSpell].MaxTimeFraction = 0
						end
						
						if SpellList[SpellName].Type == "Curse" then
							CurseUsed = 1
						end
					end
				end
			end
		end
		
		local CycleDPS, CycleMPS = EquipEval:CalculateWarlockDPSFromSpellCycle(SpellList, SpellCycle)
		
		if CycleDPS > TotalDPS then
			TotalDPS = CycleDPS
			TotalMPS = CycleMPS
			ChosenCycle = SpellCycle
		end
	end
	
	for SpellName,SpellTimeFraction in pairs(ChosenCycle) do
		self:Debug("Spell Added: "..SpellName.." "..(SpellTimeFraction * 100).."%")
		InfoLine = InfoLine..SpellListNormal[SpellName].Abbreviation..", "
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = nil
	end
	
	
	if EquipEval.db.profile["DisplayDPSTotal"] <= -2 then

		if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
			totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
			self:Debug("Damped Total Mana: "..totalMana)
		end

		local FightLength = min((20 * 60), (totalMana / (TotalMPS - totalMP5 / 5)))
		if FightLength < 0 then
			FightLength = 20 * 60
		end
		self:Debug("Fight Length: "..FightLength)

		TotalDPS = TotalDPS * FightLength
	end


	return TotalDPS, InfoLine

end

---------------------------------------------------------------------------------------
-- Adds a spell to a spell cycle
---------------------------------------------------------------------------------------
function EquipEval:WarlockAddSpellToSpellCycle(SpellList, TempSpellCycle, SpellName, SpellTable, TimeFraction, CycleMPS)
	
	local SpellTimeFraction = SpellTable.MaxTimeFraction * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
	SpellTimeFraction = min(TimeFraction, SpellTimeFraction)

	--Balance spell MPS with Life Tap MPS
	local TempLifeTapTF = 0
	local TempCycleMPS = CycleMPS + SpellTable.MPS * SpellTimeFraction
	if TempCycleMPS > 0 and SpellList["Life Tap"] then
		TempLifeTapTF = TempCycleMPS / -SpellList["Life Tap"].MPS
								
		if (TimeFraction - SpellTimeFraction - TempLifeTapTF) < 0 then
			--TempLifeTapTF = (CycleMPS + SpellTable.MPS * TimeFraction) / (SpellTable.MPS - SpellList["Life Tap"].MPS)
			SpellTimeFraction = (CycleMPS + SpellList["Life Tap"].MPS * TimeFraction) / (SpellList["Life Tap"].MPS - SpellTable.MPS)
			TempLifeTapTF = TimeFraction - SpellTimeFraction
		end
	end
						
	--Add Spell and add Life Tap
	TempSpellCycle[SpellName] = SpellTimeFraction
	if TempLifeTapTF > 0 then
		TempSpellCycle["Life Tap"] = (TempSpellCycle["Life Tap"] or 0) + TempLifeTapTF
	end

	return TempSpellCycle, SpellTimeFraction, TempLifeTapTF
end



---------------------------------------------------------------------------------------
-- Used to calculate Warlock DPS for a given spell cycle.
-- Takes a Spell List and a Spell Cycle
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarlockDPSFromSpellCycle(SpellList, SpellCycle)
	
	local FireDPS = 0
	local ShadowDPS = 0
	local DrainLifeDPS = 0
	local TotalDPS = 0
	local TotalMPS = 0
	local ISBFactor = 0
	local SoulSiphonBonus = 0
	local ShadowEmbraceApplied = 0
	local TimeFraction = 0
	local DDHitsPerSec = 0
	local SBCastsPerSec = 0
	local SBCritChance = 0
	local AfflictionCount = 0
	
	for SpellName,SpellTimeFraction in pairs(SpellCycle) do
		TimeFraction = TimeFraction + SpellTimeFraction
		TotalMPS = TotalMPS - SpellTimeFraction * SpellList[SpellName].MPS
		
		if SpellName == "Drain Life" then
			DrainLifeDPS = DrainLifeDPS + SpellTimeFraction * SpellList[SpellName].DPS
		elseif SpellList[SpellName].School == "Shadow" then
			ShadowDPS = ShadowDPS + SpellTimeFraction * SpellList[SpellName].DPS
		elseif SpellList[SpellName].School == "Fire" then
			FireDPS = FireDPS + SpellTimeFraction * SpellList[SpellName].DPS
		end
		
		if SpellName == "Curse of Agony" or SpellName == "Siphon Life" or SpellName == "Seed of Corruption" then
			ShadowEmbraceApplied = 1
		elseif SpellName == "Shadow Bolt" then
			SBCastsPerSec = SBCastsPerSec + 1 / SpellList[SpellName].CastTime * SpellTimeFraction
			SBCritChance = SpellList[SpellName].CritChance
		end
		
		if SpellList[SpellName].Type == "DD" or SpellList[SpellName].Type == "Hybrid" then
			DDHitsPerSec = DDHitsPerSec + 1 / SpellList[SpellName].CastTime * SpellTimeFraction
		elseif SpellList[SpellName].Type == "DoT" or SpellList[SpellName].Type == "Curse" then
			AfflictionCount = AfflictionCount + min(1, (SpellTimeFraction / SpellList[SpellName].MaxTimeFraction))
		end
	end
	
	if TimeFraction > 1 then
		DrainLifeDPS = DrainLifeDPS * 1 / TimeFraction
		ShadowDPS = ShadowDPS * 1 / TimeFraction
		FireDPS = FireDPS * 1 / TimeFraction
		TotalMPS = TotalMPS * 1 / TimeFraction
		self:Debug("Warning: Time Fraction Overrun by "..((TimeFraction - 1) * 100).."%, Normalizing")
	end
	
	--Handle Improved Shadow Bolt
	ISBFactor = EquipEval:TalentRank(3,1) * 0.04 * (1 - (1 - SBCritChance)^(min(12, 4 / DDHitsPerSec) * (SBCastsPerSec * SBCritChance)))
	
	--Handle Soul Siphon
	SoulSiphonBonus = EquipEval:TalentRank(1,6) * 0.02 * (AfflictionCount + ShadowEmbraceApplied)
	SoulSiphonBonus = max(0, min(SoulSiphonBonus, (-0.12 + 0.36 * EquipEval:TalentRank(1,6))))
		
	--Adjust DPS
	DrainLifeDPS = DrainLifeDPS * (1 + SoulSiphonBonus) * (1 + ISBFactor)
	ShadowDPS = ShadowDPS * (1 + ISBFactor)

	TotalDPS = ShadowDPS + DrainLifeDPS + FireDPS

	return TotalDPS, TotalMPS, TimeFraction, ISBFactor, SoulSiphonBonus
end




---------------------------------------------------------------------------------------
-- Used to calculate Warlock Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateWarlockMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (self.db.profile["EnemyBaseCritPercentage"] / 100 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = (self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference())
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	local healthMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = critChance - EquipEval:TalentRank(2,18) * 0.01
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..parryChance)

	local stanceModifier = 1
	stanceModifier = stanceModifier * (1 - EquipEval:TalentRank(1,13) * 0.01)
	
	
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")



	--Factor in stats
	stamMultiplier = stamMultiplier * (1 + EquipEval:TalentRank(2,3) * 0.03)
	healthMultiplier = healthMultiplier * (1 + EquipEval:TalentRank(2,9) * 0.01)

	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + (stamMultiplier * stam * 10 + health) * healthMultiplier

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 and level 39 currently
	if CurrentLevel >= 40 then 
		dodgeChance = dodgeChance + (agi / 25.0) / 100
	else
		dodgeChance = dodgeChance + (agi / 12.89) / 100
	end
	self:Debug("Dodge %: "..dodgeChance)

	parryChance = parryChance + defensePercent
	parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end
