

local Bonus = AceLibrary("LibItemBonus-2.0")


local eqevAgilityTableShaman = {
6.01, 6.01, 6.32, 6.32, 6.62, 6.62, 6.62, 6.92, 6.92, 7.22,
7.22, 7.52, 7.52, 7.82, 8.12, 8.42, 8.42, 8.72, 8.72, 9.32,
9.32, 9.62, 9.62, 9.92, 10.22, 10.53, 10.53, 10.82, 10.82, 11.43,
11.43, 11.72, 12.03, 12.03, 12.63, 12.94, 12.94, 13.23, 13.23, 13.83,
14.14, 14.14, 14.43, 14.73, 15.04, 15.34, 15.65, 15.95, 15.95, 16.53,
16.84, 17.15, 17.15, 17.45, 18.05, 18.35, 18.66, 18.66, 18.94, 19.53,
20.16, 20.58, 21.28, 21.93, 22.27, 22.88, 23.42, 23.98, 24.51, 25.00 }


local eqevIntTableShaman = {
7.5, 7.86, 8.22, 8.22, 8.58, 8.93, 9.29, 9.64, 10, 10,
10.72, 11.43, 12.5, 13.23, 14.29, 15.02, 15.72, 16.78, 17.51, 18.59,
19.31, 20, 21.1, 21.79, 22.88, 23.58, 24.27, 25.38, 26.11, 27.17,
28.25, 28.9, 30.03, 30.77, 31.85, 32.89, 33.56, 34.6, 35.34, 36.76,
37.45, 38.17, 39.37, 40.32, 41.49, 42.55, 43.29, 44.25, 45.45, 46.51,
47.62, 48.31, 49.75, 50.25, 51.81, 52.63, 53.48, 54.95, 55.87, 57.14,
60.98, 62.89, 65.79, 68.03, 70.42, 72.46, 74.63, 76.34, 78.13, 80 }



--Shaman Spells


local EquipEval_SpellTableEarthShield = {
	All = {
		Level = 0,
		Coefficient = 0.3 * 6,
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 30,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 50,
		DirectHealAmount = 150 * 6,
		ManaCost = 300
	},

	{
		Level = 60,
		DirectHealAmount = 205 * 6,
		ManaCost = 375
	},

	{
		Level = 70,
		DirectHealAmount = 270 * 6,
		ManaCost = 450
	},

}



local EquipEval_SpellTableHealingStream = {
	All = {
		Level = 0,
		Coefficient = 0.06 * 60,
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 120,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 5,
		AdditionalTargetFactor = 1
	},

	{
		Level = 20,
		DirectHealAmount = 6 * 60,
		ManaCost = 40
	},

	{
		Level = 30,
		DirectHealAmount = 8 * 60,
		ManaCost = 50
	},

	{
		Level = 40,
		DirectHealAmount = 10 * 60,
		ManaCost = 60
	},

	{
		Level = 50,
		DirectHealAmount = 12 * 60,
		ManaCost = 70
	},

	{
		Level = 60,
		DirectHealAmount = 14 * 60,
		ManaCost = 80
	},

	{
		Level = 69,
		DirectHealAmount = 18 * 60,
		ManaCost = 95
	},

}



local EquipEval_SpellTableChainHeal = {
	All = {
		Level = 0,
		Coefficient = (2.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 2.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 3,
		AdditionalTargetFactor = 0.5
	},

	{
		Level = 40,
		DirectHealAmount = (320 + 368) / 2,
		ManaCost = 260
	},

	{
		Level = 46,
		DirectHealAmount = (405 + 465) / 2,
		ManaCost = 315
	},

	{
		Level = 54,
		DirectHealAmount = (551 + 629) / 2,
		ManaCost = 405
	},

	{
		Level = 61,
		DirectHealAmount = (605 + 691) / 2,
		ManaCost = 435
	},

	{
		Level = 68,
		DirectHealAmount = (826 + 942) / 2,
		ManaCost = 540
	},
	
}



local EquipEval_SpellTableLesserHealingWave = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 1.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 20,
		DirectHealAmount = (162 + 186) / 2,
		ManaCost = 105
	},

	{
		Level = 28,
		DirectHealAmount = (247 + 281) / 2,
		ManaCost = 145
	},

	{
		Level = 36,
		DirectHealAmount = (337 + 381) / 2,
		ManaCost = 185
	},

	{
		Level = 44,
		DirectHealAmount = (458 + 514) / 2,
		ManaCost = 235
	},

	{
		Level = 52,
		DirectHealAmount = (631 + 705) / 2,
		ManaCost = 305
	},

	{
		Level = 60,
		DirectHealAmount = (832 + 928) / 2,
		ManaCost = 380
	},

	{
		Level = 66,
		DirectHealAmount = (1039 + 1185) / 2,
		ManaCost = 440
	},
}




local EquipEval_SpellTableHealingWave = {
	All = {
		Level = 0,
		Coefficient = (3.0 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 3.0,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 1,
		Coefficient = (1.5 / 3.5),
		CastTime = 3.0,
		DirectHealAmount = (39 + 49) / 2,
		ManaCost = 35
	},

	{
		Level = 6,
		Coefficient = (2.0 / 3.5),
		CastTime = 2.0,
		DirectHealAmount = (64 + 78) / 2,
		ManaCost = 50
	},

	{
		Level = 12,
		Coefficient = (2.5 / 3.5),
		CastTime = 2.5,
		DirectHealAmount = (129 + 155) / 2,
		ManaCost = 90
	},

	{
		Level = 18,
		DirectHealAmount = (268 + 316) / 2,
		ManaCost = 170
	},

	{
		Level = 24,
		DirectHealAmount = (376 + 440) / 2,
		ManaCost = 220
	},

	{
		Level = 32,
		DirectHealAmount = (536 + 622) / 2,
		ManaCost = 290
	},

	{
		Level = 40,
		DirectHealAmount = (740 + 854) / 2,
		ManaCost = 375
	},

	{
		Level = 48,
		DirectHealAmount = (1017 + 1167) / 2,
		ManaCost = 485
	},

	{
		Level = 56,
		DirectHealAmount = (1367 + 1561) / 2,
		ManaCost = 615
	},

	{
		Level = 60,
		DirectHealAmount = (1620 + 1850) / 2,
		ManaCost = 620
	},

	{
		Level = 63,
		DirectHealAmount = (1725 + 1969) / 2,
		ManaCost = 655
	},

	{
		Level = 70,
		DirectHealAmount = (2134 + 2436) / 2,
		ManaCost = 720
	},	
	
}






---------------------------------------------------------------------------------------
-- Used to calculate Shaman DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanDPS(infoObj, CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponType)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, _, holydmg, _, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	local TotalValueCaster, int, spi, mana, mp5, spellcrit, holycrit, naturecrit, heal, spelldmg, spellhaste, spellhit, frostdmg, shadowdmg, firedmg, _, stam, arcanedmg, spellpen, naturedmg, _, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local MongoosePresent, _, AdditionalMongoose = EquipEval:GetSpecialBonus("MONGOOSE_TOKEN", infoObj)
	local ExecutionerPresent, _, AdditionalExecutioner = EquipEval:GetSpecialBonus("EXECUTIONER_TOKEN", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	local _, WeaponSpeed, WeaponAvgDmg = EquipEval:GetWeaponStats(infoObj)
	if WeaponHands > 0 then
		meleedmg = 0
	end

	if (TotalValue + TotalValueCaster + WeaponAvgDmg + abs(AdditionalModInt) + abs(AdditionalMongoose) + abs(AdditionalExecutioner)) == 0 then
		return 0, 0
	end

	local AgilityRating = eqevAgilityTableShaman[CurrentLevel]
	self:Debug("Agility Rating: "..AgilityRating)


	local AgiModifier = 1
	local ItemAgility = AgiModifier * agi
	local BonusAgility = AgiModifier * MongoosePresent * 120
	
	local APModifier = 1
	local ItemAP = APModifier * (ap + 2 *str)
	BonusAttackPower = APModifier * BonusAttackPower
	
	local ItemHit = (hit / 10.0  * LevelRating / 100)
	
	local ItemCrit = (crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating)
	local BonusCrit = (BonusAgility/AgilityRating)
	
	local ItemHaste = (haste / 10.0 * LevelRating) / 100
	local BonusHaste = MongoosePresent * 0.02
	
	weapSkill = (weapSkill / 2.5  * LevelRating)
	expertise = (expertise / 2.5  * LevelRating) * 0.0025
	
	local BonusArmorPen = ExecutionerPresent * 840
	
	local IntRating = eqevIntTableShaman[CurrentLevel]

	local IntModifier = 1 * (1 + TotalModInt / 100)
	local SpiModifier = 1
	local ManaModifier = 1 + 0.01 * EquipEval:TalentRank(2,1)

	local CastingRegen = 0

	
	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemDmg = spelldmg + 0.1 * EquipEval:TalentRank(3,18) * itemInt + ItemAP * EquipEval:TalentRank(2,15) * 0.1
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemSpellCrit = ((spellcrit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemSpellHit = (spellhit / 8.0 * LevelRating) / 100
	local itemSpellHaste = (spellhaste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5 + EquipEval:TalentRank(1,14) * 0.02 * itemInt
	itemMP5 = itemMP5 + CastingRegen * SpiritEffect
	
	
	local BonusAP = EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	BonusAP = BonusAP + (BonusAP + baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	BonusSpellDmg = BonusSpellDmg + BonusAP * EquipEval:TalentRank(2,15) * 0.1


	local baseSpellDPS, baseShockDPS, baseTime, baseShockCritsPerSecond = EquipEval:CalculateShamanDPSFromStatsSpell(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, 0)
	baseSpellDPS = baseSpellDPS / baseTime
	local newSpellDPS, newShockDPS, newTime, newShockCritsPerSecond, SpellInfo = EquipEval:CalculateShamanDPSFromStatsSpell(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemSpellCrit, (BonusSpellDmg + itemDmg), (itemSpellHaste + BonusSpellHaste), itemSpellHit, naturecrit, naturedmg, firedmg, spellpen, spellcritbonus)
	newSpellDPS = newSpellDPS / newTime
	
	if newSpellDPS == baseSpellDPS or not EquipEval.db.profile['ChosenAttacksDisplayed']then
		SpellInfo = nil
	end


	local baseDPS = EquipEval:CalculateShamanDPSFromStats(CurrentLevel, LevelRating, "None", 0, 0, 0, "None", (BonusAP + BonusAttackPower), BonusCrit, 0, 0, BonusHaste, 0, 0, BonusArmorPen, 0, 0, BonusSpellDmg, 0, 0, 0, baseShockCritsPerSecond, 0)
	local newDPS, EnchantInfo = EquipEval:CalculateShamanDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, (BonusAP + ItemAP + BonusAttackPower), (ItemCrit + BonusCrit), ItemHit, meleedmg, (ItemHaste + BonusHaste), critbonus, weapSkill, (ignorearmor + BonusArmorPen), expertise, itemSpellCrit, (itemDmg + BonusSpellDmg), itemSpellHit, firedmg, spellpen, newShockCritsPerSecond, spellcritbonus)

	if newDPS == baseDPS or not EquipEval.db.profile['ChosenAttacksDisplayed']then
		EnchantInfo = nil
	end

	baseDPS = baseDPS + baseShockDPS
	newDPS = newDPS + newShockDPS


	self:Debug("Spell DPS: "..newSpellDPS)
	self:Debug("Melee and Shock DPS: "..newDPS)

	if baseSpellDPS > baseDPS then
		baseDPS = baseSpellDPS * baseTime
	end
	if newSpellDPS > newDPS then
		newDPS = newSpellDPS * newTime
		EnchantInfo = SpellInfo
	end


	return (newDPS - baseDPS), newDPS, EnchantInfo


end


---------------------------------------------------------------------------------------
-- Used to calculate Shaman DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, ap, crit, hit, meleedmg, haste, critbonus, weapSkill, ignoreArmor, expertise, spellcrit, spelldmg, spellhit, firedmg, spellpen, ShockCritsPerSecond, spellcritbonus)

	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = 1
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentmod = UnitDamage("player");
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	offSpeed = offSpeed or 0
	
	--Calc base weapon stats
	local baseMainSpeed = mainSpeed
	local baseOffSpeed = offSpeed
	local baseMainAvgDmg = 0 --(lowDmg + hiDmg) / 2 / mainSpeed
	local baseOffAvgDmg = 0

	local CurrentWeaponTypeMain = "None"
	local CurrentWeaponTypeOff = "None"
	local mainEquipLoc = "None"

	--Recalc base weapon stats from items if possible
	local mainHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot"))
	if mainHandLink then
		local mainHandInfo = Bonus:ScanItemLink(mainHandLink)
		if mainHandInfo then
			_, baseMainSpeed, baseMainAvgDmg, lowDmg, hiDmg = EquipEval:GetWeaponStats(mainHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeMain, _, mainEquipLoc = GetItemInfo(mainHandLink)
		end
	end
	local offHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("SecondaryHandSlot"))
	if offHandLink then
		local offHandInfo = Bonus:ScanItemLink(offHandLink)
		if offHandInfo then
			_, baseOffSpeed, baseOffAvgDmg, offlowDmg, offhiDmg = EquipEval:GetWeaponStats(offHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeOff = GetItemInfo(offHandLink)
		end
	end
	
	
	--Replace Weapons if necessary
	if EquipEval.db.profile["CompareToCurrentItems"] then
		if WeaponSlotName == "MainHand" then
			baseMainSpeed = WeaponSpeed
			baseMainAvgDmg = WeaponAvgDmg
			CurrentWeaponTypeMain = WeaponType
			if WeaponHands == 2 then
				baseOffSpeed = 0
				offSpeed = 0
				baseOffAvgDmg = 0
				CurrentWeaponTypeOff = "None"
			end
		elseif WeaponSlotName == "SecondaryHand" then
			if WeaponHands ~= 1 then
				offSpeed = 0
				baseOffSpeed = 0
				baseOffAvgDmg = 0
			else
				offSpeed = WeaponSpeed
				baseOffSpeed = WeaponSpeed
				baseOffAvgDmg = WeaponAvgDmg
			end
			CurrentWeaponTypeOff = WeaponType

			if mainEquipLoc == "INVTYPE_2HWEAPON" then
				baseMainSpeed = 2
				baseMainAvgDmg = 0
				CurrentWeaponTypeMain = "None"
			end
		end
	end
	
	local offHandModifier = 0
	local APDamageModifier = (1 + 0.02 * EquipEval:TalentRank(2,16)) * percentmod

	baseMainAvgDmg = (baseMainAvgDmg + meleedmg) * APDamageModifier
	if baseOffSpeed > 0 then
		offHandModifier = 0.5
		baseOffAvgDmg = (baseOffAvgDmg + meleedmg) * APDamageModifier * offHandModifier
	end

	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_MAINHAND) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)


	local totalCrit = GetCritChance() - 0.04 * weapSkillDif
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = max(0, ((totalCrit + crit) / 100 - resilienceEffect))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local CurrentHit = GetCombatRating(CR_HIT_MELEE) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]

	local currentChanceToHit = (EquipEval:MaxHitChance(expertise, weapSkillDif) - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = currentChanceToHit + .01 * EquipEval:TalentRank(3,6)
	local windfuryChanceToHit = currentChanceToHit

	if baseOffSpeed > 0 then
		currentChanceToHit = currentChanceToHit - 0.19 + .02 * EquipEval:TalentRank(2,17)
		windfuryChanceToHit = windfuryChanceToHit + .02 * EquipEval:TalentRank(2,17)
	end
	windfuryChanceToHit = min(windfuryChanceToHit, EquipEval:MaxHitChance(expertise, weapSkillDif))
	currentChanceToHit = min(currentChanceToHit, EquipEval:MaxHitChance(expertise, weapSkillDif))
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	local totalHitWindfury = max(0.01, (1 - (1 - windfuryChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	self:Debug("Total Hit: "..totalHit)

	local GlanceChance, GlanceModifier = EquipEval:GetGlancingBlowInfo()


	local totalHaste = haste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100
	self:Debug("Total Haste: "..totalHaste)
	
	
	local ItemAP = ap
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	local effectiveAP = baseAP + ItemAP
	self:Debug("Item AP: "..ItemAP)

	
	
	
	local totalCritFire = GetSpellCritChance(3)
	totalCritFire = totalCritFire + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritFire = max(0, (totalCritFire / 100 + spellcrit - resilienceEffect))
	totalCritFire = min(1, totalCritFire * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Fire: "..totalCritFire)

	local totalHitFire = EquipEval:GetSpellHitChance() + spellhit + EquipEval:TalentRank(1,15) * 0.02
	totalHitFire = totalHitFire + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitFire = max(0.01, (1 - (1 - totalHitFire) / EquipEval.db.profile["BurstFactor"]))
	totalHitFire = min(0.99, totalHitFire) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit Fire: "..totalHitFire)

	--Investigate further to see if flametongue crits are affected by Elemental Fury
	local CritModifierFire = 0.5 * (1 + EquipEval:TalentRank(1,13))
	CritModifierFire = (CritModifierFire + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifierFire = (CritModifierFire + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifierFire = (CritModifierFire + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifierFire)

	local totalDmgFire = GetSpellBonusDamage(3) + spelldmg + firedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Fire: "..totalDmgFire)


	--Choose weapon enchant
	local WeaponEnchantTable = { {Name = "WF", MinLevel = 30}, {Name = "FT", MinLevel = 10}, {Name = "RB", MinLevel = 1} }
	local EnchantName = nil
	local TotalDPS = 0
	local MHWFChance = 0
	local OHWFChance = 0
	
	for MHWeaponEnchant = 1, #WeaponEnchantTable do
		local MHEnchantName = nil
		local CurrentDPS = 0
		local CurrentMHWFChance = 0
		local CurrentOHWFChance = 0
		
		local hasMainHandEnchant, _, _, hasOffHandEnchant = GetWeaponEnchantInfo()
		
		if CurrentLevel >= WeaponEnchantTable[MHWeaponEnchant].MinLevel then
			MHEnchantName = WeaponEnchantTable[MHWeaponEnchant].Name
			if ((not hasMainHandEnchant) and mainHandLink) or (not mainHandLink and WeaponHands == 0) then
				MHEnchantName = nil
			end
		
			if baseOffSpeed > 0 then
				for OHWeaponEnchant = 1, #WeaponEnchantTable do
					local OHEnchantName = nil
					
					if CurrentLevel >= WeaponEnchantTable[OHWeaponEnchant].MinLevel then
						OHEnchantName = WeaponEnchantTable[OHWeaponEnchant].Name
						if (not hasOffHandEnchant) and offHandLink then
							OHEnchantName = nil
						end
						
						CurrentDPS, CurrentMHWFChance, CurrentOHWFChance = EquipEval:ShamanCalculateAndMergeMeleeDPS(CurrentLevel, MHEnchantName, OHEnchantName, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, totalDmgFire, (1 + totalHaste), totalHit, totalHitWindfury, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
						if CurrentDPS > TotalDPS then
							TotalDPS = CurrentDPS
							MHWFChance = CurrentMHWFChance
							OHWFChance = CurrentOHWFChance
							if MHEnchantName or OHEnchantName then
								EnchantName = "Enchants: "..(MHEnchantName or "None").." / "..(OHEnchantName or "None")
							end
						end
					end
				end
			else
				CurrentDPS, CurrentMHWFChance, CurrentOHWFChance = EquipEval:ShamanCalculateAndMergeMeleeDPS(CurrentLevel, MHEnchantName, "None", APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, totalDmgFire, (1 + totalHaste), totalHit, totalHitWindfury, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
				if CurrentDPS > TotalDPS then
					TotalDPS = CurrentDPS
					MHWFChance = CurrentMHWFChance
					OHWFChance = CurrentOHWFChance
					if MHEnchantName then
						EnchantName = "Enchant: "..MHEnchantName
					end
				end
			end
		elseif TotalDPS == 0 then
			TotalDPS, MHWFChance, OHWFChance = EquipEval:ShamanCalculateAndMergeMeleeDPS(CurrentLevel, "None", "None", APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, effectiveAP, totalDmgFire, (1 + totalHaste), totalHit, totalHitWindfury, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
		end
	end

	self:Debug("Windfury Chance: MH:"..(MHWFChance * 100).."% OH: "..(OHWFChance * 100).."%")

	return TotalDPS, EnchantName


end


---------------------------------------------------------------------------------------
-- This function calculates shaman damage from melee attacks under different conditions and merges them
---------------------------------------------------------------------------------------
function EquipEval:ShamanCalculateAndMergeMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, totalSpellDmgFire, HasteEffect, totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
	MainHandEnchant = MainHandEnchant or "None"
	OffHandEnchant = OffHandEnchant or "None"
	
	local TotalDPS = 0
	local UREffect = 1 + EquipEval:TalentRank(2,20) * 0.02
	local FlurryEffect = 1
	if EquipEval:TalentRank(2,10) > 0 then
		FlurryEffect = FlurryEffect + EquipEval:TalentRank(2,10) * 0.05 + 0.05
	end
	
	local FlurryUptime = 0
	local FlurryUptimeFlurry = 0
	local URUptime = 0
	local URUptimeFlurry = 0
	local DPS = 0
	local DPSFlurry = 0
	local DPSUR = 0
	local DPSBoth = 0
	local MHWFChance = 0
	local OHWFChance = 0
	local MHWFChanceFlurry = 0
	local OHWFChanceFlurry = 0


	DPS, FlurryUptime, URUptime, MHWFChance, OHWFChance = EquipEval:CalculateShamanMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, 1, totalSpellDmgFire, HasteEffect, totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
	if UREffect > 1 then
		DPSUR, FlurryUptime, URUptime = EquipEval:CalculateShamanMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, UREffect, totalSpellDmgFire, HasteEffect, totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
	end
	if FlurryEffect > 1 then
		DPSFlurry, FlurryUptimeFlurry, URUptimeFlurry, MHWFChanceFlurry, OHWFChanceFlurry = EquipEval:CalculateShamanMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, 1, totalSpellDmgFire, (HasteEffect * FlurryEffect), totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
	end
	if UREffect > 1 and FlurryEffect > 1 then
		DPSBoth, FlurryUptimeFlurry, URUptimeFlurry = EquipEval:CalculateShamanMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, UREffect, totalSpellDmgFire, (HasteEffect * FlurryEffect), totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, ShockCritsPerSecond)
	end

	FlurryUptime = (FlurryUptime + FlurryUptimeFlurry) / 2
	URUptime = (URUptime + URUptimeFlurry) / 2
	local BothUptime = min(URUptime, FlurryUptime)
	local NeitherUptime = 1 - max(FlurryUptime, URUptime)
	FlurryUptime = FlurryUptime - BothUptime
	URUptime = URUptime - BothUptime
	
	TotalDPS = NeitherUptime * DPS + BothUptime * DPSBoth + FlurryUptime * DPSFlurry + URUptime * DPSUR
	MHWFChance = NeitherUptime * MHWFChance + BothUptime * MHWFChanceFlurry + FlurryUptime * MHWFChanceFlurry + URUptime * MHWFChance
	OHWFChance = NeitherUptime * OHWFChance + BothUptime * OHWFChanceFlurry + FlurryUptime * OHWFChanceFlurry + URUptime * OHWFChance
		
	return TotalDPS, MHWFChance, OHWFChance

end

---------------------------------------------------------------------------------------
-- This function calculates shaman damage from melee attacks
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanMeleeDPS(CurrentLevel, MainHandEnchant, OffHandEnchant, APDamageModifier, offHandModifier, ArmorEffect, baseMainSpeed, baseOffSpeed, mainBaseAvgDmg, offBaseAvgDmg, effectiveAP, APMultiplier, totalSpellDmgFire, HasteEffect, totalHit, totalHitYellow, totalHitFire, totalCrit, totalCritFire, CritModifier, CritModifierFire, GlanceChance, GlanceModifier, SpellCritsPerSecond)

	baseOffSpeed = baseOffSpeed or 0
	effectiveAP = effectiveAP * APMultiplier
	totalSpellDmgFire = totalSpellDmgFire + effectiveAP * (APMultiplier - 1) * EquipEval:TalentRank(2,15) * 0.1

	local mainSpeed = baseMainSpeed / HasteEffect
	local offSpeed = baseOffSpeed / HasteEffect
	
	local NumTargets = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
	local GlobalCoolDown = 1.5 + EquipEval.db.profile["CastTimePadding"]
	local ManaCostModifier = 1
	local ManaGenerationMultiplier = 0
	
	
	
	
	
	local WindfuryAP = 0
	if CurrentLevel >= 68 then
		WindfuryAP = 445 + (CurrentLevel - 68) * 15
	elseif CurrentLevel >= 60 then
		WindfuryAP = 333.33 + (CurrentLevel - 60) * (445 - 333.33) / 9
	elseif CurrentLevel >= 50 then
		WindfuryAP = 249 + (CurrentLevel - 50) * (333.33 - 249) / 11
	elseif CurrentLevel >= 40 then
		WindfuryAP = 119 + (CurrentLevel - 40) * (249 - 119) / 11
	elseif CurrentLevel >= 30 then
		WindfuryAP = 46 + (CurrentLevel - 30) * (119 - 46) / 11
	end
	WindfuryAP = WindfuryAP * APMultiplier * (1 + EquipEval.db.profile["BonusAPPercent"] / 100)
	
	
	--Formulas for flametongue weapon base damage seem off, need further investigation
	local FlametongueDPS = 0
	if CurrentLevel >= 64 then
		FlametongueDPS = 31.076 + (CurrentLevel - 64) * 0.654
	elseif CurrentLevel >= 56 then
		FlametongueDPS = 24.8365 + (CurrentLevel - 56) * 0.785583
	elseif CurrentLevel >= 46 then
		FlametongueDPS = 18.7596 + (CurrentLevel - 46) * 0.60769
	elseif CurrentLevel >= 36 then
		FlametongueDPS = 11.4558 + (CurrentLevel - 36) * 0.73038
	elseif CurrentLevel >= 26 then
		FlametongueDPS = 7.15192 + (CurrentLevel - 26) * 0.430388
	elseif CurrentLevel >= 18 then
		FlametongueDPS = 4.78462 + (CurrentLevel - 18) * 0.295913
	elseif CurrentLevel >= 10 then
		FlametongueDPS = 3.24038 + (CurrentLevel - 10) * 0.19303
	end
	
	
	local RockbiterAP = 0
	if CurrentLevel >= 70 then
		RockbiterAP = 62 * 14
	elseif CurrentLevel >= 62 then
		RockbiterAP = 49 * 14
	elseif CurrentLevel >= 54 then
		RockbiterAP = 40 * 14
	elseif CurrentLevel >= 44 then
		RockbiterAP = 28 * 14
	elseif CurrentLevel >= 34 then
		RockbiterAP = 15 * 14
	elseif CurrentLevel >= 24 then
		RockbiterAP = 9 * 14
	elseif CurrentLevel >= 16 then
		RockbiterAP = 6 * 14
	elseif CurrentLevel >= 8 then
		RockbiterAP = 4 * 14
	elseif CurrentLevel >= 1 then
		RockbiterAP = 2 * 14
	end
	RockbiterAP = RockbiterAP * (1 + EquipEval:TalentRank(2,14) * 0.2 / 3)
	
	
	local WindfuryProcChance = min(1, (0.2 * EquipEval.db.profile["BurstFactor"]))
	local WindfuryHitsPerProc = 2
	local MHWindfuryChance = 0
	local OHWindfuryChance = 0
	local MHFlametongueDamage = 0
	local OHFlametongueDamage = 0
	local MHRockbiterAP = 0
	local OHRockbiterAP = 0
		
	if MainHandEnchant == "WF" and OffHandEnchant == "WF" then
		WindfuryProcChance = min(1, (0.36 * EquipEval.db.profile["BurstFactor"]))
	end
		

	if MainHandEnchant == "WF" then
		MHWindfuryChance = WindfuryProcChance
	elseif MainHandEnchant == "FT" then
		MHFlametongueDamage = (FlametongueDPS * baseMainSpeed + 0.1 * totalSpellDmgFire) * (1 + EquipEval:TalentRank(2,14) * 0.05)
		MHFlametongueDamage = MHFlametongueDamage * totalHitFire * (1 + totalCritFire * CritModifierFire)
		SpellCritsPerSecond = SpellCritsPerSecond + totalHit * (totalHitFire * totalCritFire) / mainSpeed
	elseif MainHandEnchant == "RB" then
		MHRockbiterAP = RockbiterAP
	end
	
	if OffHandEnchant == "WF" then
		OHWindfuryChance = WindfuryProcChance
	elseif OffHandEnchant == "FT" then
		OHFlametongueDamage = (FlametongueDPS * baseMainSpeed + 0.1 * totalSpellDmgFire) * (1 + EquipEval:TalentRank(2,14) * 0.05)
		OHFlametongueDamage = OHFlametongueDamage * totalHitFire * (1 + totalCritFire * CritModifierFire)
		SpellCritsPerSecond = SpellCritsPerSecond + totalHit * (totalHitFire * totalCritFire) / offSpeed
	elseif OffHandEnchant == "RB" then
		OHRockbiterAP = RockbiterAP
	end	
	
	
	--Handle melee crit gain from Elemental Devastation
	totalCrit = totalCrit + min(1, max(0, (1 - (1 - SpellCritsPerSecond)^(10)))) * (0.03 * EquipEval:TalentRank(1,11)) * EquipEval.db.profile["BurstFactor"]
	totalCrit = min(1, totalCrit)

	
	local StrikeDmg = 0
	local StrikeManaCost = 0
	local StrikeCritChance = 0
	local StrikeCoolDown = 0



	--Main Hand Windfury Attack
	StrikeDmg = 0
	StrikeManaCost = 0
	StrikeCritChance = totalCrit
	StrikeCoolDown = 0

	StrikeDmg = (APDamageModifier * (effectiveAP + WindfuryAP) / 14.0 * baseMainSpeed + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(2,14) * .4 / 3)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeManaCost = StrikeManaCost - ManaGenerationMultiplier * 1

	local MHWindfuryAttackDmg = StrikeDmg
	local MHWindfuryAttackManaCost = StrikeManaCost
	local MHWindfuryAttackCrits = totalHitYellow * StrikeCritChance
	
	
	--Off Hand Windfury Attack
	StrikeDmg = 0
	StrikeManaCost = 0
	StrikeCritChance = totalCrit
	StrikeCoolDown = 0

	StrikeDmg = APDamageModifier * ((offHandModifier * effectiveAP / 14.0 * baseOffSpeed + offBaseAvgDmg) + WindfuryAP / 14.0 * baseOffSpeed)
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 + EquipEval:TalentRank(2,14) * .4 / 3)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeManaCost = StrikeManaCost - ManaGenerationMultiplier * 1

	local OHWindfuryAttackDmg = StrikeDmg
	local OHWindfuryAttackManaCost = StrikeManaCost
	local OHWindfuryAttackCrits = totalHitYellow * StrikeCritChance



	--Main Hand Attack
	StrikeDmg = 0
	StrikeManaCost = 0
	StrikeCritChance = min(totalCrit, max(0, totalHit - GlanceChance))
	StrikeCoolDown = mainSpeed

	StrikeDmg = (APDamageModifier * (effectiveAP + MHRockbiterAP) / 14.0 * baseMainSpeed + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg * (totalHit + StrikeCritChance * CritModifier - (1 - GlanceModifier) * GlanceChance)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)
	
	StrikeManaCost = StrikeManaCost - ManaGenerationMultiplier * 1

	local MainHandStrikeDmg = StrikeDmg + totalHit * MHFlametongueDamage
	local MainHandStrikeManaCost = StrikeManaCost
	local MainHandStrikeCrits = StrikeCritChance
	local MainHandStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	local MainHandStrikeMHHits = totalHit


	--Off Hand Attack
	StrikeDmg = 0
	StrikeManaCost = 0
	StrikeCritChance = min(totalCrit, max(0, totalHit - GlanceChance))
	StrikeCoolDown = offSpeed

	if StrikeCoolDown > 0 then
		StrikeDmg = (offHandModifier * APDamageModifier * (effectiveAP + OHRockbiterAP) / 14.0 * baseOffSpeed + offBaseAvgDmg)
		StrikeDmg = StrikeDmg * (totalHit + StrikeCritChance * CritModifier - (1 - GlanceModifier) * GlanceChance)
		StrikeDmg = StrikeDmg * (1 - ArmorEffect)
		
		StrikeManaCost = StrikeManaCost - ManaGenerationMultiplier * 1
	end

	local OffHandStrikeDmg = StrikeDmg + totalHit * OHFlametongueDamage
	local OffHandStrikeManaCost = StrikeManaCost
	local OffHandStrikeCrits = StrikeCritChance
	local OffHandStrikeMaxStrikesPerSecond = 0
	if StrikeCoolDown > 0 then
		OffHandStrikeMaxStrikesPerSecond = 1 / StrikeCoolDown
	end
	local OffHandStrikeOHHits = totalHit


	--Storm Strike
	StrikeDmg = 0
	StrikeManaCost = 0
	StrikeCritChance = totalCrit
	StrikeCoolDown = 10
	

	StrikeDmg = (APDamageModifier * ((effectiveAP + MHRockbiterAP) / 14.0 * baseMainSpeed) + mainBaseAvgDmg)
	StrikeDmg = StrikeDmg + (offHandModifier * APDamageModifier * ((effectiveAP + OHRockbiterAP) / 14.0 * baseOffSpeed) + offBaseAvgDmg)
	StrikeDmg = StrikeDmg * totalHitYellow * (1 + StrikeCritChance * CritModifier)
	StrikeDmg = StrikeDmg * (1 - ArmorEffect)

	local StormStrikeDmg = StrikeDmg + totalHitYellow * MHFlametongueDamage + totalHitYellow * OHFlametongueDamage
	local StormStrikeManaCost = StrikeManaCost
	local StormStrikeCrits = totalHitYellow * StrikeCritChance
	local StormStrikeMaxStrikesPerSecond = EquipEval.db.profile['IncludeStrikes'] * EquipEval:TalentRank(2,19) / StrikeCoolDown

	local StormStrikeMHHits = totalHitYellow
	local StormStrikeOHHits = 0
	if offSpeed > 0 then
		StormStrikeCrits = StormStrikeCrits + totalHitYellow * StrikeCritChance
		StormStrikeOHHits = StormStrikeOHHits + totalHitYellow
	end

	

	local TotalDPS = 0
	local ManaPerSecond = 0
	local MHHitsPerSecond = 0
	local OHHitsPerSecond = 0
	local CritsPerSecond = 0
	
	
	
	--Add White Damage
	--Main Hand
	TotalDPS = TotalDPS + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeDmg
	ManaPerSecond = ManaPerSecond - MainHandStrikeMaxStrikesPerSecond * MainHandStrikeManaCost
	MHHitsPerSecond = MHHitsPerSecond + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeMHHits
	CritsPerSecond = CritsPerSecond + MainHandStrikeMaxStrikesPerSecond * MainHandStrikeCrits
	
	--Off Hand
	TotalDPS = TotalDPS + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeDmg
	ManaPerSecond = ManaPerSecond - OffHandStrikeMaxStrikesPerSecond * OffHandStrikeManaCost
	OHHitsPerSecond = OHHitsPerSecond + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeOHHits
	CritsPerSecond = CritsPerSecond + OffHandStrikeMaxStrikesPerSecond * OffHandStrikeCrits


	--Stormstrike
	TotalDPS = TotalDPS + StormStrikeMaxStrikesPerSecond * StormStrikeDmg
	ManaPerSecond = ManaPerSecond - StormStrikeMaxStrikesPerSecond * StormStrikeManaCost
	MHHitsPerSecond = MHHitsPerSecond + StormStrikeMaxStrikesPerSecond * StormStrikeMHHits
	OHHitsPerSecond = OHHitsPerSecond + StormStrikeMaxStrikesPerSecond * StormStrikeOHHits
	CritsPerSecond = CritsPerSecond + StormStrikeMaxStrikesPerSecond * StormStrikeCrits

	
	--Windfury
	local MHHitsPerSecondWindfury = ceil(MHWindfuryChance) * MHHitsPerSecond
	local OHHitsPerSecondWindfury = ceil(OHWindfuryChance) * OHHitsPerSecond
	local HitsPerSecondWindfury = MHHitsPerSecondWindfury + OHHitsPerSecondWindfury
	local MHRatio = (1 - 0.089581 * ceil(OHWindfuryChance)) * MHHitsPerSecondWindfury / HitsPerSecondWindfury
	local OHRatio = (1 + 0.065463 * ceil(MHWindfuryChance)) * OHHitsPerSecondWindfury / HitsPerSecondWindfury
	local TimeBetweenWindfury = 3 + (1 / HitsPerSecondWindfury) * (1 / WindfuryProcChance - 0.75)

	local MHWindfuryHPS = WindfuryHitsPerProc * (1 / TimeBetweenWindfury) * MHRatio
	MHWindfuryHPS = max(0, MHWindfuryHPS)
	local OHWindfuryHPS = WindfuryHitsPerProc * (1 / TimeBetweenWindfury) * OHRatio
	OHWindfuryHPS = max(0, OHWindfuryHPS)
	
	TotalDPS = TotalDPS + MHWindfuryHPS * MHWindfuryAttackDmg
	ManaPerSecond = ManaPerSecond - MHWindfuryHPS * MHWindfuryAttackManaCost
	CritsPerSecond = CritsPerSecond + MHWindfuryHPS * MHWindfuryAttackCrits
	
	TotalDPS = TotalDPS + OHWindfuryHPS * OHWindfuryAttackDmg
	ManaPerSecond = ManaPerSecond - OHWindfuryHPS * OHWindfuryAttackManaCost
	CritsPerSecond = CritsPerSecond + OHWindfuryHPS * OHWindfuryAttackCrits
	
	
	--Flurry
	local FlurryUptime = 0
	if EquipEval:TalentRank(2,10) > 0 then
		local FlurryDuration = 3 / (MainHandStrikeMaxStrikesPerSecond + OffHandStrikeMaxStrikesPerSecond)
		FlurryUptime = min(1, (1 - (1 - CritsPerSecond)^(FlurryDuration)))
	end
	
	
	--Unleashed Rage
	local URUptime = 0
	if EquipEval:TalentRank(2,20) > 0 then
		URUptime = min(1, (1 - (1 - CritsPerSecond)^(10)))
	end
	

	return TotalDPS, FlurryUptime, URUptime, (MHWindfuryHPS / WindfuryHitsPerProc / max(0.001, MHHitsPerSecond)), (OHWindfuryHPS / WindfuryHitsPerProc / max(0.001, OHHitsPerSecond))
end


---------------------------------------------------------------------------------------
-- Used to calculate Shaman Spell DPS From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanDPSFromStatsSpell(CurrentLevel, LevelRating, mana, mp5, crit, spelldmg, haste, hit, naturecrit, naturedmg, firedmg, spellpen, spellcritbonus)
	local InfoLine = "Spells: "
	local ShockInfoLine = "Spells: "
	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100

	local CritModifier = 0.5 * (1 + EquipEval:TalentRank(1,13))
	CritModifier = (CritModifier + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local ManaCostModifier = 1
	self:Debug("Mana Cost Modifier: "..ManaCostModifier)

	local DamageModifier = 1
	self:Debug("Damage Modifier: "..DamageModifier)

	local totalCritNature = GetSpellCritChance(4)
	totalCritNature = totalCritNature + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritNature = max(0, (totalCritNature / 100 + crit + naturecrit / 100 - resilienceEffect))
	totalCritNature = min(1, totalCritNature * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Nature: "..totalCritNature)

	local totalCritFire = GetSpellCritChance(3)
	totalCritFire = totalCritFire + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritFire = max(0, (totalCritFire / 100 + crit - resilienceEffect))
	totalCritFire = min(1, totalCritFire * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Fire: "..totalCritFire)

	local totalHit = EquipEval:GetSpellHitChance() + hit + EquipEval:TalentRank(1,15) * 0.02
	totalHit = totalHit + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHit = max(0.01, (1 - (1 - totalHit) / EquipEval.db.profile["BurstFactor"]))
	totalHit = min(0.99, totalHit) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit: "..totalHit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenCasting
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	totalMP5 = totalMP5 + EquipEval:TalentRank(3,16) * (totalMana * 0.24 * 5 / 300)
	self:Debug("Total MP5: "..totalMP5)

	local totalDmgNature = GetSpellBonusDamage(4) + spelldmg + naturedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Nature: "..totalDmgNature)

	local totalDmgFire = GetSpellBonusDamage(3) + spelldmg + firedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Fire: "..totalDmgFire)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local SpellDPS = 0
	local SpellMPS = 0
	local TotalDPS = 0
	local TotalShockDPS = 0
	local TotalMPS = 0
	local CastTime = 0
	local SpellDuration = 0
	local SpellCritChance = 0

	local StormStrikeEffect = (1 + EquipEval.db.profile['IncludeStrikes'] * EquipEval:TalentRank(2,19) * 0.2)
	local ElementalFocusEffect = (1 - 0.4 * EquipEval:TalentRank(1,6) * (1 - (1 - totalCritNature)^2))
	local ElementalFocusEffectCL = (1 - 0.4 * EquipEval:TalentRank(1,6) * (1 - (1 - totalCritNature)^(2 * min(3, 1 + EquipEval.db.profile["NumberOfAdditionalTargets"]))))
	local LightningOverloadEffect = (1 + min(1, EquipEval:TalentRank(1,19) * 0.04 * EquipEval.db.profile["BurstFactor"]) * 0.5)
	local ShockCoolDown = 6 - EquipEval:TalentRank(1,7) * 0.2


	--Water Shield
	--MP5 gain from Water Shield is now included in the character sheet
	if CurrentLevel >= 62 and TimeFraction > 0 then
		CastTime = EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"]
		SpellHPS = 0
		SpellMPS = 0
		SpellDuration = 10 * 60

		TimeFraction = TimeFraction - min(TimeFraction, (CastTime / SpellDuration))
	end


	--Add More Fire Totems
	--Including Totem of Wrath
	
	--Searing Totem
	SpellDPS = 0
	SpellMPS = 0
	CastTime = EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"]
	SpellDuration = 30
	SpellCritChance = totalCritFire
	if CurrentLevel >= 10 and TimeFraction > 0 then

		if CurrentLevel >= 69 then
			SpellDPS = (50 + 66) / 2
			SpellMPS = 205
			SpellDuration = 60
		elseif CurrentLevel >= 60 then
			SpellDPS = (40 + 54) / 2
			SpellMPS = 170
			SpellDuration = 55
		elseif CurrentLevel >= 50 then
			SpellDPS = (33 + 45) / 2
			SpellMPS = 145
			SpellDuration = 50
		elseif CurrentLevel >= 40 then
			SpellDPS = (26 + 34) / 2
			SpellMPS = 110
			SpellDuration = 45
		elseif CurrentLevel >= 30 then
			SpellDPS = (19 + 25) / 2
			SpellMPS = 75
			SpellDuration = 40
		elseif CurrentLevel >= 20 then
			SpellDPS = (13 + 17) / 2
			SpellMPS = 45
			SpellDuration = 35
		elseif CurrentLevel >= 10 then
			SpellDPS = (9 + 11) / 2
			SpellMPS = 25
			SpellDuration = 30
		end
		
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,5) * 0.05) * totalHit * ((1 + SpellCritChance * CritModifier) * (SpellDPS + 0.08 * totalDmgFire))
		SpellDPS = SpellDPS * (SpellDuration / 2)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,5) * 0.05) * (1 - EquipEval:TalentRank(2,15) * 0.02) * SpellMPS
	end
	local SearingTotemDmg = SpellDPS
	local SearingTotemMana = SpellMPS
	local SearingTotemCastTime = CastTime
	local SearingTotemCooldown = SpellDuration
	

	--Earth Shock
	SpellDPS = 0
	SpellMPS = 0
	CastTime = EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"]
	SpellDuration = ShockCoolDown
	SpellCritChance = totalCritNature
	if CurrentLevel >= 4 and TimeFraction > 0 then


		if CurrentLevel >= 69 then
			SpellDPS = (658 + 692) / 2
			SpellMPS = 535
		elseif CurrentLevel >= 60 then
			SpellDPS = (533 + 561) / 2
			SpellMPS = 450
		elseif CurrentLevel >= 48 then
			SpellDPS = (370 + 392) / 2
			SpellMPS = 345
		elseif CurrentLevel >= 36 then
			SpellDPS = (232 + 246) / 2
			SpellMPS = 240
		elseif CurrentLevel >= 24 then
			SpellDPS = (119 + 127) / 2
			SpellMPS = 145
		elseif CurrentLevel >= 14 then
			SpellDPS = (60 + 64) / 2
			SpellMPS = 85
		elseif CurrentLevel >= 8 then
			SpellDPS = (32 + 34) / 2
			SpellMPS = 50
		elseif CurrentLevel >= 4 then
			SpellDPS = (17 + 19) / 2
			SpellMPS = 30
		end

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,2) * 0.01) * totalHit * (1 + SpellCritChance * CritModifier) * (SpellDPS + (1.5 / 3.5) * totalDmgNature)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,1) * 0.02) * (1 - EquipEval:TalentRank(2,15) * 0.02) * SpellMPS
	end
	local EarthShockDmg = SpellDPS
	local EarthShockMana = SpellMPS * ElementalFocusEffect
	local EarthShockCastTime = CastTime
	local EarthShockCritChance = totalHit * SpellCritChance


	--Flame Shock
	SpellDPS = 0
	SpellMPS = 0
	CastTime = EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"]
	SpellDuration = 12
	SpellCritChance = totalCritFire
	if CurrentLevel >= 10 and TimeFraction > 0 then
		local DoTDamage = 0

		if CurrentLevel >= 70 then
			SpellDPS = 377
			DoTDamage = 420
			SpellMPS = 500
		elseif CurrentLevel >= 60 then
			SpellDPS = 309
			DoTDamage = 344
			SpellMPS = 450
		elseif CurrentLevel >= 52 then
			SpellDPS = 230
			DoTDamage = 256
			SpellMPS = 345
		elseif CurrentLevel >= 40 then
			SpellDPS = 152
			DoTDamage = 168
			SpellMPS = 250
		elseif CurrentLevel >= 28 then
			SpellDPS = 86
			DoTDamage = 96
			SpellMPS = 160
		elseif CurrentLevel >= 18 then
			SpellDPS = 45
			DoTDamage = 48
			SpellMPS = 95
		elseif CurrentLevel >= 10 then
			SpellDPS = 21
			DoTDamage = 28
			SpellMPS = 55
		end

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = SpellDPS + 0.15 * totalDmgFire
		DoTDamage = DoTDamage + 0.52 * totalDmgFire

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,2) * 0.01) * totalHit * ((1 + SpellCritChance * CritModifier) * SpellDPS + DoTDamage)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,1) * 0.02) * (1 - EquipEval:TalentRank(2,15) * 0.02) * SpellMPS
	end
	local FlameShockDmg = SpellDPS
	local FlameShockMana = SpellMPS * ElementalFocusEffect
	local FlameShockCastTime = CastTime
	local FlameShockCooldown = SpellDuration
	local FlameShockCritChance = totalHit * SpellCritChance


	--Lightning Bolt
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 2.5 - EquipEval:TalentRank(1,16) * 0.1
	SpellDuration = 0
	SpellCritChance = min(1, totalCritNature + EquipEval:TalentRank(1,8) * 0.01 * EquipEval.db.profile["BurstFactor"])
	if TimeFraction > 0 then


		if CurrentLevel >= 67 then
			SpellDPS = (563 + 643) / 2
			SpellMPS = 300
		elseif CurrentLevel >= 62 then
			SpellDPS = (495 + 565) / 2
			SpellMPS = 275
		elseif CurrentLevel >= 56 then
			SpellDPS = (419 + 467) / 2
			SpellMPS = 240
		elseif CurrentLevel >= 50 then
			SpellDPS = (347 + 389) / 2
			SpellMPS = 210
		elseif CurrentLevel >= 44 then
			SpellDPS = (282 + 316) / 2
			SpellMPS = 175
		elseif CurrentLevel >= 38 then
			SpellDPS = (227 + 255) / 2
			SpellMPS = 150
		elseif CurrentLevel >= 32 then
			SpellDPS = (172 + 194) / 2
			SpellMPS = 125
		elseif CurrentLevel >= 26 then
			SpellDPS = (125 + 143) / 2
			SpellMPS = 95
		elseif CurrentLevel >= 20 then
			SpellDPS = (83 + 95) / 2
			SpellMPS = 70
		elseif CurrentLevel >= 14 then
			SpellDPS = (45 + 53) / 2
			SpellMPS = 40
		elseif CurrentLevel >= 8 then
			SpellDPS = (26 + 30) / 2
			SpellMPS = 25
		elseif CurrentLevel >= 1 then
			SpellDPS = (13 + 15) / 2
			SpellMPS = 15
		end

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,2) * 0.01) * totalHit * (1 + SpellCritChance * CritModifier) * (SpellDPS + (2.5 / 3.5) * totalDmgNature)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,1) * 0.02) * SpellMPS
	end
	local LightningBoltDmg = SpellDPS * LightningOverloadEffect
	local LightningBoltMana = SpellMPS * ElementalFocusEffect
	local LightningBoltCastTime = CastTime


	--Chain Lightning
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 2.0 - EquipEval:TalentRank(1,16) * 0.1
	SpellDuration = 8
	SpellCritChance = min(1, totalCritNature + EquipEval:TalentRank(1,8) * 0.01 * EquipEval.db.profile["BurstFactor"])
	if CurrentLevel >= 32 and TimeFraction > 0 then


		if CurrentLevel >= 70 then
			SpellDPS = (734 + 838) / 2
			SpellMPS = 760
		elseif CurrentLevel >= 63 then
			SpellDPS = (603 + 687) / 2
			SpellMPS = 650
		elseif CurrentLevel >= 56 then
			SpellDPS = (493 + 551) / 2
			SpellMPS = 550
		elseif CurrentLevel >= 48 then
			SpellDPS = (378 + 424) / 2
			SpellMPS = 445
		elseif CurrentLevel >= 40 then
			SpellDPS = (277 + 311) / 2
			SpellMPS = 345
		elseif CurrentLevel >= 32 then
			SpellDPS = (191 + 217) / 2
			SpellMPS = 255
		end

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,2) * 0.01) * totalHit * (1 + SpellCritChance * CritModifier) * (SpellDPS + (2.0 / 3.5) * totalDmgNature)
		SpellDPS = SpellDPS * (1 + min(2, EquipEval.db.profile["NumberOfAdditionalTargets"]) * 0.25 + min(1, EquipEval.db.profile["NumberOfAdditionalTargets"]) * 0.25)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,1) * 0.02) * SpellMPS
	end
	local ChainLightningDmg = SpellDPS * LightningOverloadEffect
	local ChainLightningMana = SpellMPS * ElementalFocusEffectCL
	local ChainLightningCastTime = CastTime
	local ChainLightningMaxTimeFraction = CastTime / SpellDuration
	

	local ShockCritsPerSecond = 0
	if EquipEval.db.profile['IncludeStrikes'] == 1 then
		if EquipEval:GetSpellRating(FlameShockDmg, FlameShockMana, FlameShockCastTime) > EquipEval:GetSpellRating((EarthShockDmg * StormStrikeEffect), EarthShockMana, EarthShockCastTime) then
			if ShockCoolDown == 6 then
				TotalShockDPS = TotalShockDPS + (EarthShockDmg * StormStrikeEffect * 2 + FlameShockDmg) / (3 * ShockCoolDown)
				ShockCritsPerSecond = ShockCritsPerSecond + (FlameShockCritChance + 2 * EarthShockCritChance) / (3 * ShockCoolDown)
			else
				TotalShockDPS = TotalShockDPS + (EarthShockDmg * StormStrikeEffect + FlameShockDmg) / (2 * ShockCoolDown)
				ShockCritsPerSecond = ShockCritsPerSecond + (FlameShockCritChance + EarthShockCritChance) / (2 * ShockCoolDown)
			end
			ShockInfoLine = ShockInfoLine.."ES, FS, "
		else
			TotalShockDPS = TotalShockDPS + (EarthShockDmg * StormStrikeEffect) / ShockCoolDown
			ShockCritsPerSecond = ShockCritsPerSecond + EarthShockCritChance / ShockCoolDown
		end
		
		if SearingTotemDmg > 0 then
			TotalShockDPS = TotalShockDPS + SearingTotemDmg / SearingTotemCooldown
			TotalDPS = TotalDPS + SearingTotemDmg / SearingTotemCooldown
			TotalMPS = TotalMPS + SearingTotemMana / SearingTotemCooldown
			TimeFraction = TimeFraction - (SearingTotemCastTime / SearingTotemCooldown)
			ShockInfoLine = ShockInfoLine.."ST, "
		end		
	end

	--Add lightning spells
	if EquipEval:GetSpellRating(ChainLightningDmg, ChainLightningMana, ChainLightningCastTime) > EquipEval:GetSpellRating(LightningBoltDmg, LightningBoltMana, LightningBoltCastTime) then
		TotalDPS = TotalDPS + ChainLightningDmg / ChainLightningCastTime * min(ChainLightningMaxTimeFraction, TimeFraction)
		TotalMPS = TotalMPS + ChainLightningMana / ChainLightningCastTime * min(ChainLightningMaxTimeFraction, TimeFraction)
		TimeFraction = TimeFraction - min(ChainLightningMaxTimeFraction, TimeFraction)
		self:Debug("Chain Lightning Included.")
		InfoLine = InfoLine.."CL, "
	end
	if TimeFraction > 0 then
		TotalDPS = TotalDPS + LightningBoltDmg / LightningBoltCastTime * TimeFraction
		TotalMPS = TotalMPS + LightningBoltMana / LightningBoltCastTime * TimeFraction
		self:Debug("Lightning Bolt Included.")
		InfoLine = InfoLine.."LB, "
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	ShockInfoLine = string.sub(ShockInfoLine, 1, #ShockInfoLine - 2)

	local FightLength = 1
	if EquipEval.db.profile["DisplayDPSTotal"] <= -2 then

		if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
			totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
			self:Debug("Damped Total Mana: "..totalMana)
		end

		FightLength = min((20 * 60), (totalMana / (TotalMPS - totalMP5 / 5)))
		if FightLength < 0 then
			FightLength = 20 * 60
		end
		self:Debug("Fight Length: "..FightLength)

		TotalDPS = TotalDPS * FightLength
	end

	return TotalDPS, TotalShockDPS, FightLength, ShockCritsPerSecond, InfoLine, ShockInfoLine

end





---------------------------------------------------------------------------------------
-- Used to calculate Shaman Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)

	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (0.05 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = ((self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference()))
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)



	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = critChance - EquipEval:TalentRank(1,18) * 0.02
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..blockChance)

	local stanceModifier = 1


	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")


	--Factor in stats
	armor = armor * (1 + EquipEval:TalentRank(2,11) * .02)

	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 currently
	dodgeChance = dodgeChance + (agi / 30.0) / 100
	self:Debug("Dodge %: "..dodgeChance)

	if parryChance > 0 then
		parryChance = parryChance + defensePercent
		parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	end
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)


	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end








---------------------------------------------------------------------------------------
-- Used to calculate Shaman Healing given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanHealing(infoObj, CurrentLevel, LevelRating)

	local TotalValue, str, _, ap = EquipEval:CalculateStats(infoObj)
	local TotalValueCaster, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, _, stam, arcanedmg, spellpen, naturedmg = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusHealing = EquipEval:GetSpecialBonus("BONUS_HEAL", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + TotalValueCaster + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTableShaman[CurrentLevel]

	local IntModifier = 1 * (1 + TotalModInt / 100)
	local SpiModifier = 1
	local ManaModifier = 1

	local CastingRegen = 0

	ManaModifier = ManaModifier + 0.01 * EquipEval:TalentRank(2,1)

	local ItemAP = (ap + 2 * str)
	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(spi * SpiModifier, itemInt)
	local itemHeal = heal + 0.1 * EquipEval:TalentRank(3,18) * itemInt + ItemAP * EquipEval:TalentRank(2,15) * 0.1
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating) + naturecrit) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5 + EquipEval:TalentRank(1,14) * 0.02 * itemInt
	itemMP5 = itemMP5 + SpiritEffect * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + CastingRegen * SpiritEffect * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100

	local BonusAP = EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	BonusAP = BonusAP + (BonusAP + baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	BonusHealing = BonusHealing + (BonusAP + BonusAttackPower) * EquipEval:TalentRank(2,15) * 0.1


	local baseHeal = EquipEval:CalculateShamanHealingFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, BonusHealing, BonusSpellHaste)
	local newHeal, InfoLine = EquipEval:CalculateShamanHealingFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemCrit, (itemHeal + BonusHealing), (itemHaste + BonusSpellHaste))

	return (newHeal - baseHeal), newHeal, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Shaman Healing From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateShamanHealingFromStats(CurrentLevel, LevelRating, mana, mp5, crit, heal, haste)
	local InfoLine = "Heals: "
	local CritModifier = 0.5
	local ManaCostModifier = 1 - EquipEval:TalentRank(3,2) * 0.01
	local HealingModifier = 1 + EquipEval:TalentRank(3,15) * 0.02

	local totalCrit = GetSpellCritChance(4)
	totalCrit = totalCrit + EquipEval:TalentRank(3,11) + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCrit = max(0, (totalCrit / 100 + crit))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenBase * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + RegenCasting * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	totalMP5 = totalMP5 + EquipEval:TalentRank(3,16) * (totalMana * 0.24 * 5 / 300)
	self:Debug("Total MP5: "..totalMP5)

	local totalHeal = GetSpellBonusHealing() + heal + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Healing: "..totalHeal)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local CastTime = 0
	local SpellHPS = 0
	local SpellMPS = 0
	local TotalHPS = 0
	local TotalMPS = 0
	local SpellDuration = 0
	local SpellTimeFraction = 0

	--Time Spent Not Casting
	TimeFraction = TimeFraction - (EquipEval.db.profile["PercentIdleTimeWhileHealing"] / 100)
	if TimeFraction == 0 then
		return 0
	end

	--Water Shield
	if CurrentLevel >= 62 and TimeFraction > 0 then
		CastTime = EquipEval:GetSpellGCD(totalHaste)
		SpellHPS = 0
		SpellMPS = 0
		SpellDuration = 60

		if CurrentLevel >= 69 then
			SpellHPS = 170 * 3
		elseif CurrentLevel >= 62 then
			SpellHPS = 200 * 3
		end

		SpellHPS = SpellHPS / CastTime

		SpellTimeFraction = min(TimeFraction, (CastTime / SpellDuration))
		totalMP5 = totalMP5 + 5 * SpellHPS * SpellTimeFraction
		TimeFraction = TimeFraction - SpellTimeFraction
	end


	--Earth Shield	
	local EarthShieldRankName = ""
	local EarthShieldHealing = 0
	local EarthShieldMana = 0
	local EarthShieldCastTime = 0
	local EarthShieldDuration = 0
	local EarthShieldRating = 0
	local EarthShieldMaxTimeFraction = 0
	if EquipEval:TalentRank(3,20) > 0 and TimeFraction > 0 then
		local EarthShieldCritChance = totalCrit
		local EarthShieldManaCostModifier = ManaCostModifier
		local EarthShieldHealingModifier = HealingModifier
		local EarthShieldCastTimeModifier = 0
		local EarthShieldCoefficientModifier = 0
		local EarthShieldOverTimeCoefficientModifier = 0
		
		EarthShieldRankName, EarthShieldHealing, EarthShieldMana, EarthShieldCastTime, EarthShieldDuration, _, _, EarthShieldRating = EquipEval:ChooseHeal(EquipEval_SpellTableEarthShield, CurrentLevel, EarthShieldManaCostModifier, EarthShieldHealingModifier, EarthShieldCastTimeModifier, EarthShieldCoefficientModifier, EarthShieldOverTimeCoefficientModifier, totalHeal, EarthShieldCritChance, CritModifier, totalHaste, 0, 0)
		EarthShieldMaxTimeFraction = EarthShieldCastTime / EarthShieldDuration
		EarthShieldRankName = "Earth Shield "..EarthShieldRankName
	end


	--Healing Stream Totem
	local HealingStreamRankName = ""
	local HealingStreamHealing = 0
	local HealingStreamMana = 0
	local HealingStreamCastTime = 0
	local HealingStreamDuration = 0
	local HealingStreamRating = 0
	local HealingStreamMaxTimeFraction = 0
	if CurrentLevel >= 20 and TimeFraction > 0 then
		local HealingStreamCritChance = 0
		local HealingStreamManaCostModifier = (1 - EquipEval:TalentRank(3,5) * 0.05)
		local HealingStreamHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(3,10) * 0.05)
		local HealingStreamCastTimeModifier = 0
		local HealingStreamCoefficientModifier = 0
		local HealingStreamOverTimeCoefficientModifier = 0
		
		HealingStreamRankName, HealingStreamHealing, HealingStreamMana, HealingStreamCastTime, HealingStreamDuration, _, _, HealingStreamRating = EquipEval:ChooseHeal(EquipEval_SpellTableHealingStream, CurrentLevel, HealingStreamManaCostModifier, HealingStreamHealingModifier, HealingStreamCastTimeModifier, HealingStreamCoefficientModifier, HealingStreamOverTimeCoefficientModifier, totalHeal, HealingStreamCritChance, CritModifier, totalHaste, 0, 0)
		HealingStreamMaxTimeFraction = HealingStreamCastTime / HealingStreamDuration
		HealingStreamRankName = "Healing Stream Totem "..HealingStreamRankName
	end



	--Chain Heal
	local ChainHealRankName = ""
	local ChainHealHealing = 0
	local ChainHealMana = 0
	local ChainHealCastTime = 0
	local ChainHealDuration = 0
	local ChainHealRating = 0
	local ChainHealMaxTimeFraction = 0
	if CurrentLevel >= 40 and TimeFraction > 0 then
		local ChainHealCritChance = totalCrit
		local ChainHealManaCostModifier = ManaCostModifier
		local ChainHealHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(3,19) * 0.1)
		local ChainHealCastTimeModifier = 0
		local ChainHealCoefficientModifier = 0
		local ChainHealOverTimeCoefficientModifier = 0
		
		ChainHealRankName, ChainHealHealing, ChainHealMana, ChainHealCastTime, ChainHealDuration, _, _, ChainHealRating = EquipEval:ChooseHeal(EquipEval_SpellTableChainHeal, CurrentLevel, ChainHealManaCostModifier, ChainHealHealingModifier, ChainHealCastTimeModifier, ChainHealCoefficientModifier, ChainHealOverTimeCoefficientModifier, totalHeal, ChainHealCritChance, CritModifier, totalHaste, 0, 0)
		ChainHealMaxTimeFraction = TimeFraction * 0.7
		ChainHealRankName = "Chain Heal "..ChainHealRankName
	end


	--Lesser Healing Wave
	local LesserHealingWaveRankName = ""
	local LesserHealingWaveHealing = 0
	local LesserHealingWaveMana = 0
	local LesserHealingWaveCastTime = 0
	local LesserHealingWaveDuration = 0
	local LesserHealingWaveRating = 0
	local LesserHealingWaveMaxTimeFraction = 0
	if CurrentLevel >= 20 and TimeFraction > 0 then
		local LesserHealingWaveCritChance = totalCrit
		local LesserHealingWaveManaCostModifier = ManaCostModifier
		local LesserHealingWaveHealingModifier = HealingModifier
		local LesserHealingWaveCastTimeModifier = 0
		local LesserHealingWaveCoefficientModifier = 0
		local LesserHealingWaveOverTimeCoefficientModifier = 0
		
		LesserHealingWaveRankName, LesserHealingWaveHealing, LesserHealingWaveMana, LesserHealingWaveCastTime, LesserHealingWaveDuration, _, _, LesserHealingWaveRating = EquipEval:ChooseHeal(EquipEval_SpellTableLesserHealingWave, CurrentLevel, LesserHealingWaveManaCostModifier, LesserHealingWaveHealingModifier, LesserHealingWaveCastTimeModifier, LesserHealingWaveCoefficientModifier, LesserHealingWaveOverTimeCoefficientModifier, totalHeal, LesserHealingWaveCritChance, CritModifier, totalHaste, 0, 0)
		LesserHealingWaveMaxTimeFraction = 1
		LesserHealingWaveRankName = "Lesser Healing Wave "..LesserHealingWaveRankName
	end



	--Healing Wave
	local HealingWaveRankName = ""
	local HealingWaveHealing = 0
	local HealingWaveMana = 0
	local HealingWaveCastTime = 0
	local HealingWaveDuration = 0
	local HealingWaveRating = 0
	local HealingWaveMaxTimeFraction = 0
	if CurrentLevel >= 1 and TimeFraction > 0 then
		local HealingWaveCritChance = totalCrit
		local HealingWaveManaCostModifier = ManaCostModifier
		local HealingWaveHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(3,12) * 0.06 * 3/3)
		local HealingWaveCastTimeModifier = EquipEval:TalentRank(3,1) * 0.01
		local HealingWaveCoefficientModifier = 0
		local HealingWaveOverTimeCoefficientModifier = 0
		
		HealingWaveRankName, HealingWaveHealing, HealingWaveMana, HealingWaveCastTime, HealingWaveDuration, _, _, HealingWaveRating = EquipEval:ChooseHeal(EquipEval_SpellTableHealingWave, CurrentLevel, HealingWaveManaCostModifier, HealingWaveHealingModifier, HealingWaveCastTimeModifier, HealingWaveCoefficientModifier, HealingWaveOverTimeCoefficientModifier, totalHeal, HealingWaveCritChance, CritModifier, totalHaste, 0, 0)
		HealingWaveMaxTimeFraction = 1
		HealingWaveRankName = "Healing Wave "..HealingWaveRankName
	end




	while TimeFraction > 0 do
		local MaxRating = max(EarthShieldRating, HealingStreamRating, ChainHealRating, LesserHealingWaveRating, HealingWaveRating)
		local RatingTotal = EarthShieldRating + HealingStreamRating + ChainHealRating + LesserHealingWaveRating + HealingWaveRating
		RatingTotal = max(MaxRating, (RatingTotal - MaxRating))
		local MaxTimeFraction = 0
		

		if MaxRating == 0 then
			TimeFraction  = 0
			break
		end
		
		if MaxRating == EarthShieldRating then
			EarthShieldRating = 0
			MaxTimeFraction = EarthShieldMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + EarthShieldHealing / EarthShieldCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + EarthShieldMana / EarthShieldCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..EarthShieldRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."ES, "
		elseif MaxRating == HealingStreamRating then
			HealingStreamRating = 0
			MaxTimeFraction = HealingStreamMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + HealingStreamHealing / HealingStreamCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + HealingStreamMana / HealingStreamCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..HealingStreamRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."HS, "
		elseif MaxRating == ChainHealRating then
			ChainHealRating = 0
			MaxTimeFraction = ChainHealMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + ChainHealHealing / ChainHealCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + ChainHealMana / ChainHealCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..ChainHealRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."CH, "
		elseif MaxRating == LesserHealingWaveRating then
			LesserHealingWaveRating = 0
			MaxTimeFraction = LesserHealingWaveMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + LesserHealingWaveHealing / LesserHealingWaveCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + LesserHealingWaveMana / LesserHealingWaveCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..LesserHealingWaveRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."LHW, "
		elseif MaxRating == HealingWaveRating then
			HealingWaveRating = 0
			MaxTimeFraction = HealingWaveMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + HealingWaveHealing / HealingWaveCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + HealingWaveMana / HealingWaveCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..HealingWaveRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."HW, "
		else
			TimeFraction = 0
		end
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenHealsDisplayed"] then
		InfoLine = nil
	end


	if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
		totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
		self:Debug("Damped Total Mana: "..totalMana)
	end

	local FightLength = (totalMana / (TotalMPS - totalMP5 / 5))
	if EquipEval.db.profile["AutoSetHealingFightTotalMPS"] and EquipEval.db.profile["AutoSetHealingVars"] then
		FightLength = (FightLength + totalMana / -EquipEval.db.profile["AutoSetHealingFightTotalMPS"]) / 2
	end

	FightLength = min((20 * 60), FightLength)
	if FightLength < 0 then
		FightLength = 20 * 60
	end
	self:Debug("Fight Length: "..FightLength)

	self:Debug("Total HPS: "..TotalHPS)
	self:Debug("Total MPS: "..TotalMPS)
	

	if EquipEval.db.profile["HealingDurationDisplayed"] then
		InfoLine = EquipEval:AddStringToTable("Healing Duration: "..format("%.2f", (FightLength / 60)).." min.", InfoLine)
	end
	
	if EquipEval.db.profile["DisplayHealingTotal"] < -1 then
		TotalHPS = TotalHPS * FightLength
	end

	return TotalHPS, InfoLine
end
