

local Bonus = AceLibrary("LibItemBonus-2.0")

local eqevAgilityTableRogue = {
2.23, 2.33, 2.43, 2.62, 2.72, 2.82, 3.01, 3.11, 3.21, 3.4, 
3.79, 4.18, 4.66, 5.05, 5.63, 6.02, 6.41, 6.9, 7.38, 7.87, 
8.35, 8.74, 9.23, 9.62, 10.2, 10.68, 11.07, 11.56, 12.05, 12.63, 
13.02, 13.5, 13.99, 14.47, 15.06, 15.55, 15.92, 16.42, 16.89, 17.48, 
17.99, 18.45, 18.94, 19.53, 20.12, 20.58, 21.1, 21.55, 22.03, 22.73, 
23.2, 23.7, 24.27, 24.75, 25.38, 25.91, 26.46, 27.03, 27.47, 28.17, 
29.94, 31.06, 32.57, 33.78, 34.97, 36.23, 37.31, 38.17, 39.06, 40 }



---------------------------------------------------------------------------------------
-- Used to calculate the stats of Slice and Dice for a Rogue
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueSliceAndDice(CurrentLevel, ComboPoints, mainSpeed, offSpeed, StrikeList)
	offSpeed = offSpeed or 0
	local Haste = 0
	local EnergyCost = 25 - 25 * EquipEval:TalentRank(1,7) * 0.2 * ComboPoints
	local Duration = (6 + 3 * ComboPoints) * (1 + 0.15 * EquipEval:TalentRank(2,4))
			

	if CurrentLevel >= 42 then
		Haste = 0.3
	elseif CurrentLevel >= 10 then
		Haste = 0.2
	end

	local AdditionalMainHandSwings = Duration * Haste / mainSpeed
	EnergyCost = EnergyCost + AdditionalMainHandSwings * StrikeList["MainHandStrike"].Mana
	
	local AdditionalOffHandSwings = 0
	if offSpeed ~= 0 then
		AdditionalOffHandSwings = Duration * Haste / offSpeed
		EnergyCost = EnergyCost + AdditionalOffHandSwings * StrikeList["OffHandStrike"].Mana
	end
	
	--Output format changed to a returned table
	local SNDStats = {}
	SNDStats.Damage = (AdditionalMainHandSwings * StrikeList["MainHandStrike"].Damage + AdditionalOffHandSwings * StrikeList["OffHandStrike"].Damage)
	SNDStats.Mana = EnergyCost
	SNDStats.CritChance = 0
	SNDStats.CoolDown = Duration
	SNDStats.Duration = Duration
	SNDStats.AddMHSwings = AdditionalMainHandSwings
	SNDStats.AddOHSwings = AdditionalOffHandSwings
	SNDStats.ComboPoints = ComboPoints
	SNDStats.Abbreviation = "SND"
	
	return SNDStats
end




---------------------------------------------------------------------------------------
-- Used to calculate Rogue DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueDPS(infoObj, CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponType)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, spelldmg, holydmg, int, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local MongoosePresent, _, AdditionalMongoose = EquipEval:GetSpecialBonus("MONGOOSE_TOKEN", infoObj)
	local ExecutionerPresent, _, AdditionalExecutioner = EquipEval:GetSpecialBonus("EXECUTIONER_TOKEN", infoObj)

	local _, WeaponSpeed, WeaponAvgDmg = EquipEval:GetWeaponStats(infoObj)
	if WeaponHands > 0 then
		meleedmg = 0
	end
	
	if (TotalValue + WeaponAvgDmg + abs(AdditionalMongoose) + abs(AdditionalExecutioner)) == 0 then
		return 0, 0
	end


	local AgilityRating = eqevAgilityTableRogue[CurrentLevel]
	local AgiModifier = (1 + .01 * EquipEval:TalentRank(2,20)) * (1 + .03 * EquipEval:TalentRank(3,21))
	local ItemAgility = AgiModifier * agi
	local BonusAgility = AgiModifier * MongoosePresent * 120
	
	local APModifier = 1 + .02 * EquipEval:TalentRank(3,17)
	local ItemAP = APModifier * (ap + ItemAgility + str)
	BonusAttackPower = APModifier * (BonusAttackPower + BonusAgility)
	
	local ItemHit = (hit / 10.0  * LevelRating / 100)
	
	local ItemCrit = (crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating)
	local BonusCrit = (BonusAgility/AgilityRating)
	
	local ItemHaste = (haste / 10.0 * LevelRating) / 100
	local BonusHaste = MongoosePresent * 0.02

	weapSkill = (weapSkill / 2.5 * LevelRating)
	expertise = (expertise / 2.5 * LevelRating) * 0.0025
	
	local BonusArmorPen = ExecutionerPresent * 840

	local baseDPS = EquipEval:CalculateRogueDPSFromStats(CurrentLevel, LevelRating, "None", 0, 0, 0, "None", BonusAttackPower, BonusCrit, 0, 0, BonusHaste, 0, 0, BonusArmorPen, 0)
	local newDPS, InfoLine = EquipEval:CalculateRogueDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, (ItemAP + BonusAttackPower), (ItemCrit + BonusCrit), ItemHit, meleedmg, (ItemHaste + BonusHaste), critbonus, weapSkill, (ignorearmor + BonusArmorPen), expertise)

	return (newDPS - baseDPS), newDPS, InfoLine
end


---------------------------------------------------------------------------------------
-- Used to calculate Rogue DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, ap, crit, hit, meleedmg, haste, critbonus, weapSkill, ignoreArmor, expertise)

	local GlobalCoolDown = 1

	if EquipEval:TalentRank(3,11) == 3 then
		ignoreArmor = ignoreArmor + 5 * CurrentLevel
	else
		ignoreArmor = ignoreArmor + EquipEval:TalentRank(3,11) * 1.67 * CurrentLevel
	end
	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = 1
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	local CritModifierOffHand = CritModifier
	self:Debug("Crit Modifier: "..CritModifier)



	local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentmod = UnitDamage("player");
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	offSpeed = offSpeed or 0
	
	--Calc base weapon stats
	local baseMainSpeed = mainSpeed
	local baseOffSpeed = offSpeed
	local baseMainAvgDmg = 0 --(lowDmg + hiDmg) / 2 / mainSpeed
	local baseOffAvgDmg = 0
	
	local CurrentWeaponTypeMain = "None"
	local CurrentWeaponTypeOff = "None"

	--Recalc base weapon stats from items if possible
	local mainHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot"))
	if mainHandLink then
		local mainHandInfo = Bonus:ScanItemLink(mainHandLink)
		if mainHandInfo then
			_, baseMainSpeed, baseMainAvgDmg, lowDmg, hiDmg = EquipEval:GetWeaponStats(mainHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeMain = GetItemInfo(mainHandLink)
		end
	end
	local offHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("SecondaryHandSlot"))
	if offHandLink then
		local offHandInfo = Bonus:ScanItemLink(offHandLink)
		if offHandInfo then
			_, baseOffSpeed, baseOffAvgDmg, offlowDmg, offhiDmg = EquipEval:GetWeaponStats(offHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeOff = GetItemInfo(offHandLink)
		end
	end
	
	
	--Adjust current crit rates to remove crit from weapon specializations
	local SpecializationCrit = 0
	if CurrentWeaponTypeMain == "Daggers" then
		SpecializationCrit = EquipEval:TalentRank(2,11)
	elseif CurrentWeaponTypeMain == "Fist Weapons" then
		SpecializationCrit = EquipEval:TalentRank(2,16)
	end
	
	
	--Replace Weapons if necessary
	if EquipEval.db.profile["CompareToCurrentItems"] then
		if WeaponSlotName == "MainHand" then
			baseMainSpeed = WeaponSpeed
			baseMainAvgDmg = WeaponAvgDmg
			CurrentWeaponTypeMain = WeaponType
			if WeaponHands == 2 then
				baseOffSpeed = 0
				offSpeed = 0
				baseOffAvgDmg = 0
				CurrentWeaponTypeOff = "None"
			end
		elseif WeaponSlotName == "SecondaryHand" then
			if WeaponHands ~= 1 then
				offSpeed = 0
				baseOffSpeed = 0
				baseOffAvgDmg = 0
			else
				offSpeed = WeaponSpeed
				baseOffSpeed = WeaponSpeed
				baseOffAvgDmg = WeaponAvgDmg
			end
			CurrentWeaponTypeOff = WeaponType
		end
	end
	
	
	local offHandModifier = 0
	local APDamageModifier = 1 * percentmod

	baseMainAvgDmg = (baseMainAvgDmg + meleedmg) * APDamageModifier
	if baseOffSpeed > 0 then
		offHandModifier = 0.5 * (1 + .1 * EquipEval:TalentRank(2,12))
		baseOffAvgDmg = (baseOffAvgDmg + meleedmg) * APDamageModifier * offHandModifier
	end


	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_MAINHAND) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)

	local totalCrit = GetCritChance() - SpecializationCrit - 0.04 * weapSkillDif
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = (totalCrit + crit) / 100 - resilienceEffect
	totalCrit = totalCrit * EquipEval.db.profile["BurstFactor"]
	local totalCritOffHand = totalCrit
	self:Debug("Total Crit: "..totalCrit)

	local CurrentHit = GetCombatRating(CR_HIT_MELEE) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]


	local maxHitChance, parryChance, dodgeChance = EquipEval:GetHitStats(expertise, weapSkillDif)
	local currentChanceToHit = (maxHitChance - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = currentChanceToHit + .01 * EquipEval:TalentRank(2,6)
	local totalHitYellow = currentChanceToHit
	if baseOffSpeed ~= 0 then
		currentChanceToHit = currentChanceToHit - 0.19
	end
	currentChanceToHit = min(currentChanceToHit, maxHitChance)
	totalHitYellow = min(totalHitYellow, maxHitChance)
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	totalHitYellow = max(0.01, (1 - (1 - totalHitYellow) / EquipEval.db.profile["BurstFactor"]))
	parryChance = max(0, min(1, (parryChance / EquipEval.db.profile["BurstFactor"])))
	dodgeChance = max(0, min(1, (dodgeChance / EquipEval.db.profile["BurstFactor"])))
	self:Debug("Total Hit: "..totalHit)
	self:Debug("Total Hit Yellow: "..totalHitYellow)
	
	local totalHitYellowBack = min(1, (totalHitYellow + parryChance))
	local totalHitStunned = min(1, (totalHit + parryChance + dodgeChance))
	local totalHitYellowStunned = min(1, (totalHitYellow + parryChance + dodgeChance))
	
	

	local GlanceChance, GlanceModifier = EquipEval:GetGlancingBlowInfo()

	local totalHaste = haste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100
	offSpeed = baseOffSpeed / (1 + totalHaste)
	mainSpeed = baseMainSpeed / (1 + totalHaste)
	self:Debug("Total Haste: "..totalHaste)

	local ItemAP = ap + EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	ItemAP = ItemAP + (baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	local effectiveAP = baseAP + ItemAP
	self:Debug("Item AP: "..ItemAP)


	local TotalDPS = 0
	
	--Expose Armor Effect
	local EAPenetration = 0
	if CurrentLevel >= 66 then
		EAPenetration = 2050
	elseif CurrentLevel >= 56 then
		EAPenetration = 1700
	elseif CurrentLevel >= 46 then
		EAPenetration = 1375
	elseif CurrentLevel >= 36 then
		EAPenetration = 1050
	elseif CurrentLevel >= 26 then
		EAPenetration = 725
	elseif CurrentLevel >= 14 then
		EAPenetration = 400
	end
	EAPenetration = EAPenetration * (1 + EquipEval:TalentRank(1,8) * 0.25)
	local ExposedArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor + EAPenetration)
		
	local StrikeLists = {}
	StrikeLists.Normal = EquipEval:GenerateRogueStrikeList(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, totalCritOffHand, effectiveAP, APDamageModifier, totalCrit, mainSpeed, offSpeed, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, totalHit, totalHitYellow, totalHitYellowBack, CritModifier, CritModifierOffHand, GlanceModifier, GlanceChance, ArmorEffect, offHandModifier)
	StrikeLists.Exposed = EquipEval:GenerateRogueStrikeList(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, totalCritOffHand, effectiveAP, APDamageModifier, totalCrit, mainSpeed, offSpeed, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, totalHit, totalHitYellow, totalHitYellowBack, CritModifier, CritModifierOffHand, GlanceModifier, GlanceChance, ExposedArmorEffect, offHandModifier)
	StrikeLists.Stunned = EquipEval:GenerateRogueStrikeList(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, totalCritOffHand, effectiveAP, APDamageModifier, totalCrit, mainSpeed, offSpeed, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, totalHitStunned, totalHitYellowStunned, totalHitYellowStunned, CritModifier, CritModifierOffHand, GlanceModifier, GlanceChance, ArmorEffect, offHandModifier)
	StrikeLists.ExposedAndStunned = EquipEval:GenerateRogueStrikeList(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, totalCritOffHand, effectiveAP, APDamageModifier, totalCrit, mainSpeed, offSpeed, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, totalHitStunned, totalHitYellowStunned, totalHitYellowStunned, CritModifier, CritModifierOffHand, GlanceModifier, GlanceChance, ExposedArmorEffect, offHandModifier)
	
	local StrikeNames = { "Hemorrhage", "Mutilate", "Backstab", "Sinister Strike" }
	local CurrentDPS, CurrentInfoLine
	
	for StrikeNumber = 1, #StrikeNames do
		CurrentDPS, CurrentInfoLine = EquipEval:CalculateRogueCycle(CurrentLevel, StrikeLists, StrikeNames[StrikeNumber], GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)
		if CurrentDPS > TotalDPS then
			TotalDPS = CurrentDPS
			InfoLine = CurrentInfoLine
		end
	end
	
	return TotalDPS, InfoLine
end


---------------------------------------------------------------------------------------
-- Used to generate Rogue Strike List
---------------------------------------------------------------------------------------
function EquipEval:GenerateRogueStrikeList(CurrentLevel, CurrentWeaponTypeMain, CurrentWeaponTypeOff, totalCritOffHand, effectiveAP, APDamageModifier, totalCrit, mainSpeed, offSpeed, baseMainSpeed, baseOffSpeed, baseMainAvgDmg, baseOffAvgDmg, totalHit, totalHitYellow, totalHitYellowBack, CritModifier, CritModifierOffHand, GlanceModifier, GlanceChance, ArmorEffect, offHandModifier)
	local StrikeList = { }

	local SpellDPS = 0
	local SpellMPS = 0
	local SpellCritChance = 0
	local SpellDuration = 0

	local GlobalCoolDown = 1
	local NormalizedSpeed = 2.6
	local MainHandDagger = 0
	local OffHandDagger = 0
	local MainHandSword = 0
	local OffHandSword = 0
	local MainHandPlusCrit = 0
	local OffHandPlusCrit = 0
	local DirtyDeedsEffect = 1 + EquipEval:TalentRank(3,14) * 0.1 * 0.35
	
	local SwordSpecProcChance = min(1, EquipEval:TalentRank(2,15) * 0.01 * EquipEval.db.profile["BurstFactor"])
	local WindfuryProcChance, WindfuryBonusAP = EquipEval:GetWindfuryTotemStats(CurrentLevel)
	WindfuryBonusAP = WindfuryBonusAP * (1 + .02 * EquipEval:TalentRank(3,17))


	if CurrentWeaponTypeMain == "Daggers" then
		MainHandDagger = 1
		NormalizedSpeed = 1.7
		MainHandPlusCrit = EquipEval:TalentRank(2,11) * 0.01
	elseif CurrentWeaponTypeMain == "One-Handed Swords" then
		MainHandSword = 1
	elseif CurrentWeaponTypeMain == "One-Handed Maces" then
		CritModifier = (CritModifier + 1) * (1 + EquipEval:TalentRank(2,13) * 0.01) - 1
	elseif CurrentWeaponTypeMain == "Fist Weapons" then
		MainHandPlusCrit = EquipEval:TalentRank(2,16) * 0.01
	end
	
	if CurrentWeaponTypeOff == "One-Handed Swords" then
		OffHandSword = 1
	elseif CurrentWeaponTypeOff == "Daggers" then
		OffHandDagger = 1
		OffHandPlusCrit = EquipEval:TalentRank(2,11) * 0.01
	elseif CurrentWeaponTypeOff == "One-Handed Maces" then
		CritModifierOffHand = (CritModifierOffHand + 1) * (1 + EquipEval:TalentRank(2,13) * 0.01) - 1
	elseif CurrentWeaponTypeOff == "Fist Weapons" then
		OffHandPlusCrit = EquipEval:TalentRank(2,16) * 0.01
	end	
	
	--Adjust crit rates based on specializations
	totalCrit = totalCrit + MainHandPlusCrit * EquipEval.db.profile["BurstFactor"]
	totalCritOffHand = totalCritOffHand + OffHandPlusCrit * EquipEval.db.profile["BurstFactor"]
	totalCrit = max(0, min(1, totalCrit))
	totalCritOffHand = max(0, min(1, totalCritOffHand))
	
	
	local StrikeDamageFromAP = (effectiveAP / 14 * NormalizedSpeed) * APDamageModifier
	

	--Poison Modeling
	local totalHitPoison = EquipEval:GetSpellHitChance()
	totalHitPoison = totalHitPoison + EquipEval:TalentRank(1,17) * 0.05
	totalHitPoison = max(0.01, (1 - (1 - totalHitPoison) / EquipEval.db.profile["BurstFactor"]))
	totalHitPoison = min(0.99, totalHitPoison)


	--Instant Poison
	SpellDPS = 0
	SpellMPS = 0
	SpellCritChance = min(1, (0.2 + EquipEval:TalentRank(1,11) * 0.02) * totalHitPoison * EquipEval.db.profile["BurstFactor"])
	SpellDuration = 0

	if CurrentLevel >= 68 then
		SpellDPS = (146 + 194) / 2
	elseif CurrentLevel >= 60 then
		SpellDPS = (112 + 148) / 2
	elseif CurrentLevel >= 52 then
		SpellDPS = (92 + 118) / 2
	elseif CurrentLevel >= 44 then
		SpellDPS = (67 + 85) / 2
	elseif CurrentLevel >= 36 then
		SpellDPS = (44 + 56) / 2
	elseif CurrentLevel >= 28 then
		SpellDPS = (30 + 38) / 2
	elseif CurrentLevel >= 20 then
		SpellDPS = (19 + 25) / 2
	end

	SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(1,10) * 0.04)
	SpellDPS = SpellCritChance * SpellDPS
	SpellDPS = SpellDPS * (1 - EquipEval.db.profile["EnemyIsPoisonImmune"])

	StrikeList["InstantPoison"] = {}
	StrikeList["InstantPoison"].Damage = SpellDPS


	--Deadly Poison
	SpellDPS = 0
	SpellMPS = 0
	SpellCritChance = min(1, (0.3 + EquipEval:TalentRank(1,11) * 0.02) * totalHitPoison * EquipEval.db.profile["BurstFactor"])
	SpellDuration = 12

	if CurrentLevel >= 70 then
		SpellDPS = 180
	elseif CurrentLevel >= 62 then
		SpellDPS = 144
	elseif CurrentLevel >= 60 then
		SpellDPS = 136
	elseif CurrentLevel >= 54 then
		SpellDPS = 108
	elseif CurrentLevel >= 46 then
		SpellDPS = 80
	elseif CurrentLevel >= 38 then
		SpellDPS = 52
	elseif CurrentLevel >= 30 then
		SpellDPS = 36
	end

	SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(1,10) * 0.04)
	SpellDPS = SpellDPS * (1 - EquipEval.db.profile["EnemyIsPoisonImmune"])
	SpellDPS = SpellDPS / SpellDuration

	StrikeList["DeadlyPoison"] = {}
	StrikeList["DeadlyPoison"].Damage = SpellDPS
	StrikeList["DeadlyPoison"].Chance = SpellCritChance

	local MainHandPoisonDamage = 0
	local OffHandPoisonDamage = 0
	local MainHandDeadlyPoison = 0
	local OffHandDeadlyPoison = 0

	--Assume Deadly Main Hand and Instant Off Hand if Possible
	if CurrentLevel >= 30 then
		if WindfuryProcChance == 0 then
			MainHandDeadlyPoison = 1
			OffHandPoisonDamage = StrikeList["InstantPoison"].Damage
		else
			OffHandDeadlyPoison = 1
		end
	else
		if WindfuryProcChance == 0 then
			MainHandPoisonDamage = StrikeList["InstantPoison"].Damage
		end
		OffHandPoisonDamage = StrikeList["InstantPoison"].Damage
		MainHandDeadlyPoison = 0
	end
	

	--Sword Spec Proc Strike
	SpellDPS = 0
	SpellMPS = 0
	SpellCritChance = totalCrit
	SpellDuration = 0

	SpellDPS = (APDamageModifier * effectiveAP / 14 * baseMainSpeed + baseMainAvgDmg) * (totalHitYellow * (1 + SpellCritChance * CritModifier))
	SpellDPS = SpellDPS * (1 - ArmorEffect)
	SpellDPS = SpellDPS + totalHitYellow * MainHandPoisonDamage

	StrikeList["SwordSpecStrike"] = {}
	StrikeList["SwordSpecStrike"].Damage = SpellDPS
	StrikeList["SwordSpecStrike"].Mana = SpellMPS
	StrikeList["SwordSpecStrike"].CritChance = totalHitYellow * SpellCritChance
	StrikeList["SwordSpecStrike"].CoolDown = SpellDuration
	StrikeList["SwordSpecStrike"].MHHits = totalHitYellow
	

	--Sinister Strike
	SpellDPS = 0
	SpellMPS = (45 - EquipEval:TalentRank(2,2) * 3 + (max(1, EquipEval:TalentRank(2,2)) - 1))
	SpellMPS = SpellMPS + (1 / totalHitYellow - 1) * SpellMPS * 0.2
	SpellCritChance = totalCrit
	SpellDuration = GlobalCoolDown
			

	if CurrentLevel >= 70 then
		SpellDPS = 98
	elseif CurrentLevel >= 62 then
		SpellDPS = 80
	elseif CurrentLevel >= 54 then
		SpellDPS = 68
	elseif CurrentLevel >= 46 then
		SpellDPS = 52
	elseif CurrentLevel >= 38 then
		SpellDPS = 38
	elseif CurrentLevel >= 30 then
		SpellDPS = 22
	elseif CurrentLevel >= 22 then
		SpellDPS = 15
	elseif CurrentLevel >= 14 then
		SpellDPS = 10
	elseif CurrentLevel >= 6 then
		SpellDPS = 6
	elseif CurrentLevel >= 1 then
		SpellDPS = 3
	end

	SpellDPS = (APDamageModifier * SpellDPS + baseMainAvgDmg + StrikeDamageFromAP) * (1 + SpellCritChance * (CritModifier * (1 + EquipEval:TalentRank(2,9) * 0.06)))
	SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(2,19) * 0.02) * (1 + EquipEval:TalentRank(2,24) * 0.1)
	SpellDPS = SpellDPS * (1 - ArmorEffect)
	SpellDPS = SpellDPS * DirtyDeedsEffect
	SpellDPS = SpellDPS + MainHandPoisonDamage

	StrikeList["Sinister Strike"] = {}
	StrikeList["Sinister Strike"].Damage = SpellDPS + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Damage
	StrikeList["Sinister Strike"].Mana = SpellMPS + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Mana
	StrikeList["Sinister Strike"].CritChance = SpellCritChance
	StrikeList["Sinister Strike"].CoolDown = SpellDuration
	StrikeList["Sinister Strike"].MHHits = 1 + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].MHHits


	--Backstab
	SpellDPS = 0
	SpellMPS = 60
	SpellMPS = SpellMPS + (1 / totalHitYellowBack - 1) * SpellMPS * 0.2
	SpellCritChance = min(1, (totalCrit + EquipEval:TalentRank(1,6) * 0.1 * EquipEval.db.profile["BurstFactor"]))
	SpellDuration = GlobalCoolDown
			
	if MainHandDagger == 1 then
		if CurrentLevel >= 68 then
			SpellDPS = 255
		elseif CurrentLevel >= 62 then
			SpellDPS = 225
		elseif CurrentLevel >= 60 then
			SpellDPS = 210
		elseif CurrentLevel >= 52 then
			SpellDPS = 165
		elseif CurrentLevel >= 44 then
			SpellDPS = 135
		elseif CurrentLevel >= 36 then
			SpellDPS = 90
		elseif CurrentLevel >= 28 then
			SpellDPS = 69
		elseif CurrentLevel >= 20 then
			SpellDPS = 48
		elseif CurrentLevel >= 12 then
			SpellDPS = 30
		elseif CurrentLevel >= 4 then
			SpellDPS = 15
		end

		SpellDPS = ((1.5 + 0.01 * EquipEval:TalentRank(3,21)) * (StrikeDamageFromAP + baseMainAvgDmg) + APDamageModifier * SpellDPS) * (1 + SpellCritChance * (CritModifier * (1 + EquipEval:TalentRank(2,9) * 0.06)))
		SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(2,19) * 0.02) * (1 + EquipEval:TalentRank(3,2) * 0.04) * (1 + EquipEval:TalentRank(2,24) * 0.1)
		SpellDPS = SpellDPS * (1 - ArmorEffect)
		SpellDPS = SpellDPS * DirtyDeedsEffect
		SpellDPS = SpellDPS + MainHandPoisonDamage
	end

	StrikeList["Backstab"] = {}
	StrikeList["Backstab"].Damage = SpellDPS
	StrikeList["Backstab"].Mana = SpellMPS
	StrikeList["Backstab"].CritChance = SpellCritChance
	StrikeList["Backstab"].CoolDown = SpellDuration
	StrikeList["Backstab"].MHHits = 1


	--Mutilate
	SpellDPS = 0
	SpellMPS = 60
	SpellMPS = SpellMPS + (1 / totalHitYellowBack - 1) * SpellMPS * 0.2
	SpellCritChance = min(1, (totalCrit + EquipEval:TalentRank(1,6) * 0.05 * EquipEval.db.profile["BurstFactor"]))
	SpellDuration = GlobalCoolDown
			
	if EquipEval:TalentRank(1,21) > 0 and MainHandDagger == 1 and OffHandDagger == 1 then
		local BonusDamage = 0
		if CurrentLevel >= 70 then
			BonusDamage = 101
		elseif CurrentLevel >= 60 then
			BonusDamage = 88
		elseif CurrentLevel >= 50 then
			BonusDamage = 63
		elseif CurrentLevel >= 50 then
			BonusDamage = 44
		end

		--SpellDPS = (StrikeDamageFromAP + APDamageModifier * SpellDPS + offHandModifier * StrikeDamageFromAP + APDamageModifier * SpellDPS * (1 + .1 * EquipEval:TalentRank(2,12)) + baseMainAvgDmg + baseOffAvgDmg) * (1 + SpellCritChance * (CritModifier * (1 + EquipEval:TalentRank(2,9) * 0.06)))
		SpellDPS = (StrikeDamageFromAP + APDamageModifier * BonusDamage + baseMainAvgDmg) * (1 + SpellCritChance * (CritModifier * (1 + EquipEval:TalentRank(2,9) * 0.06)))
		SpellDPS = SpellDPS + (offHandModifier * StrikeDamageFromAP + APDamageModifier * BonusDamage * (1 + .1 * EquipEval:TalentRank(2,12)) + baseOffAvgDmg) * (1 + totalCritOffHand * (CritModifierOffHand * (1 + EquipEval:TalentRank(2,9) * 0.06)))
		SpellDPS = SpellDPS * (1 - ArmorEffect)
		SpellDPS = SpellDPS * (1 + 0.5 * (1 - EquipEval.db.profile["EnemyIsPoisonImmune"]))
		SpellDPS = SpellDPS * DirtyDeedsEffect
		SpellDPS = SpellDPS + MainHandPoisonDamage + OffHandPoisonDamage
	end

	StrikeList["Mutilate"] = {}
	StrikeList["Mutilate"].Damage = SpellDPS
	StrikeList["Mutilate"].Mana = SpellMPS
	StrikeList["Mutilate"].CritChance = (1 - (1 - SpellCritChance) * (1 - totalCritOffHand))
	StrikeList["Mutilate"].CoolDown = SpellDuration
	StrikeList["Mutilate"].MHHits = 1
		

	--Ghostly Strike
	--Not modeled


	--Hemorrhage
	SpellDPS = 0
	SpellMPS = 35
	SpellMPS = SpellMPS + (1 / totalHitYellow - 1) * SpellMPS * 0.2
	SpellCritChance = totalCrit
	SpellDuration = GlobalCoolDown
			
	if EquipEval:TalentRank(3,15) > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = 42
		elseif CurrentLevel >= 58 then
			SpellDPS = 29
		elseif CurrentLevel >= 46 then
			SpellDPS = 21
		elseif CurrentLevel >= 30 then
			SpellDPS = 13
		end
	
		SpellDPS = (APDamageModifier * 10 * SpellDPS) + (1.1 + 0.01 * EquipEval:TalentRank(3,21)) * (baseMainAvgDmg + StrikeDamageFromAP) * (1 + SpellCritChance * (CritModifier * (1 + EquipEval:TalentRank(2,9) * 0.06)))
		SpellDPS = SpellDPS * (1 - ArmorEffect)
		SpellDPS = SpellDPS * DirtyDeedsEffect
		SpellDPS = SpellDPS + MainHandPoisonDamage
	end

	StrikeList["Hemorrhage"] = {}
	StrikeList["Hemorrhage"].Damage = SpellDPS + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Damage
	StrikeList["Hemorrhage"].Mana = SpellMPS + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Mana
	StrikeList["Hemorrhage"].CritChance = SpellCritChance
	StrikeList["Hemorrhage"].CoolDown = SpellDuration
	StrikeList["Hemorrhage"].MHHits = 1 + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].MHHits

	
	--Windfury Proc Strike
	SpellDPS = 0
	SpellMPS = 0
	SpellCritChance = totalCrit
	SpellDuration = 0

	SpellDPS = (APDamageModifier * (effectiveAP + WindfuryBonusAP) / 14 * baseMainSpeed + baseMainAvgDmg) * (totalHitYellow * (1 + SpellCritChance * CritModifier))
	SpellDPS = SpellDPS * (1 - ArmorEffect)
	SpellDPS = SpellDPS + totalHitYellow * MainHandPoisonDamage

	StrikeList["WindfuryStrike"] = {}
	StrikeList["WindfuryStrike"].Damage = SpellDPS + MainHandSword * totalHitYellow * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Damage
	StrikeList["WindfuryStrike"].Mana = SpellMPS + MainHandSword * totalHitYellow * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Mana
	StrikeList["WindfuryStrike"].CritChance = totalHitYellow * SpellCritChance
	StrikeList["WindfuryStrike"].CoolDown = SpellDuration
	StrikeList["WindfuryStrike"].MHHits = totalHitYellow * (1 + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].MHHits)
	

	--Main Hand Attack
	SpellDPS = 0
	SpellMPS = 0
	SpellCritChance = min(totalCrit, max(0, totalHit - GlanceChance))
	SpellDuration = mainSpeed

	SpellDPS = (APDamageModifier * effectiveAP / 14 * baseMainSpeed + baseMainAvgDmg) * (totalHit + SpellCritChance * CritModifier - (1 - GlanceModifier) * GlanceChance)
	SpellDPS = SpellDPS * (1 - ArmorEffect)
	SpellDPS = SpellDPS + totalHit * MainHandPoisonDamage

	StrikeList["MainHandStrike"] = {}
	StrikeList["MainHandStrike"].Damage = SpellDPS + MainHandSword * totalHit * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Damage + totalHit * WindfuryProcChance * StrikeList["WindfuryStrike"].Damage
	StrikeList["MainHandStrike"].Mana = SpellMPS + MainHandSword * totalHit * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Mana + totalHit * WindfuryProcChance * StrikeList["WindfuryStrike"].Mana
	StrikeList["MainHandStrike"].CritChance = SpellCritChance
	StrikeList["MainHandStrike"].CoolDown = SpellDuration
	StrikeList["MainHandStrike"].MHHits = totalHit * (1 + MainHandSword * SwordSpecProcChance * StrikeList["SwordSpecStrike"].MHHits + WindfuryProcChance * StrikeList["WindfuryStrike"].MHHits)



	--Off Hand Attack
	SpellDPS = 0
	SpellMPS = totalHit * min(1, 0.2 * EquipEval.db.profile["BurstFactor"]) * EquipEval:TalentRank(2,23) * -3
	SpellCritChance = min(totalCritOffHand, max(0, totalHit - GlanceChance))
	SpellDuration = offSpeed

	if offSpeed == 0 then
		SpellDuration = 1
	else
		SpellDPS = (offHandModifier * APDamageModifier * effectiveAP / 14 * baseOffSpeed + baseOffAvgDmg) * (totalHit + SpellCritChance * CritModifierOffHand - (1 - GlanceModifier) * GlanceChance)
		SpellDPS = SpellDPS * (1 - ArmorEffect)
		SpellDPS = SpellDPS + totalHit * OffHandPoisonDamage
	end
	
	StrikeList["OffHandStrike"] = {}
	StrikeList["OffHandStrike"].Damage = SpellDPS + OffHandSword * totalHit * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Damage
	StrikeList["OffHandStrike"].Mana = SpellMPS + OffHandSword * totalHit * SwordSpecProcChance * StrikeList["SwordSpecStrike"].Mana
	StrikeList["OffHandStrike"].CritChance = SpellCritChance
	StrikeList["OffHandStrike"].CoolDown = SpellDuration
	StrikeList["OffHandStrike"].MHHits = OffHandSword * totalHit * SwordSpecProcChance * StrikeList["SwordSpecStrike"].MHHits
	StrikeList["OffHandStrike"].OHHits = totalHit



	--Blade Flurry
	SpellDPS = 0
	SpellMPS = 25
	SpellCritChance = 0
	SpellDuration = 15
			
	local BladeFlurryAddMHSwings = SpellDuration * (min(2, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * 1.2 - 1) / StrikeList["MainHandStrike"].CoolDown
	local BladeFlurryAddOHSwings = 0
	if StrikeList["OffHandStrike"].CoolDown ~= nil then
		BladeFlurryAddOHSwings = SpellDuration * (min(2, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * 1.2 - 1) / StrikeList["OffHandStrike"].CoolDown
	end


	SpellDPS = BladeFlurryAddMHSwings * StrikeList["MainHandStrike"].Damage + BladeFlurryAddOHSwings * StrikeList["OffHandStrike"].Damage
	SpellMPS = SpellMPS - totalHit * BladeFlurryAddOHSwings * min(1, 0.2 * EquipEval.db.profile["BurstFactor"]) * EquipEval:TalentRank(2,23) * 3

	
	StrikeList["BladeFlurry"] = {}
	StrikeList["BladeFlurry"].Damage = SpellDPS
	StrikeList["BladeFlurry"].Mana = SpellMPS + BladeFlurryAddMHSwings * StrikeList["MainHandStrike"].Mana + BladeFlurryAddOHSwings * StrikeList["OffHandStrike"].Mana
	StrikeList["BladeFlurry"].Duration = SpellDuration
	StrikeList["BladeFlurry"].CoolDown = 2 * 60
	StrikeList["BladeFlurry"].MHHits = StrikeList["MainHandStrike"].MHHits * BladeFlurryAddMHSwings + StrikeList["OffHandStrike"].MHHits * BladeFlurryAddOHSwings
	StrikeList["BladeFlurry"].OHHits = StrikeList["OffHandStrike"].OHHits * BladeFlurryAddOHSwings

	

	--Kidney Shot (5 point)
	SpellDPS = 0
	SpellMPS = 25
	SpellMPS = totalHitYellow * SpellMPS + (1 - totalHitYellow) * SpellMPS * (1 - EquipEval:TalentRank(1,15) * 0.4)
	SpellMPS = SpellMPS - totalHitYellow * 25 * EquipEval:TalentRank(1,7)
	SpellMPS = max(0.00001, SpellMPS)
	SpellCritChance = 0
	SpellDuration = 0
			

	if CurrentLevel >= 50 then
		SpellDuration = 6
	elseif CurrentLevel >= 30 then
		SpellDuration = 5
	end
	
	SpellDuration = SpellDuration * totalHitYellow

	StrikeList["Kidney Shot"] = {}
	StrikeList["Kidney Shot"].Damage = 0
	StrikeList["Kidney Shot"].Mana = SpellMPS
	StrikeList["Kidney Shot"].CritChance = SpellCritChance
	StrikeList["Kidney Shot"].Duration = SpellDuration
	StrikeList["Kidney Shot"].CoolDown = 20
	StrikeList["Kidney Shot"].Abbreviation = "KS"


	--Eviscerate (5 point)
	SpellDPS = 0
	SpellMPS = 35
	SpellMPS = SpellMPS + (1 / totalHitYellow - 1) * SpellMPS * (1 - EquipEval:TalentRank(1,15) * 0.4)
	SpellMPS = SpellMPS - 25 * EquipEval:TalentRank(1,7)
	SpellCritChance = totalCrit
	SpellDuration = GlobalCoolDown
			

	if CurrentLevel >= 64 then
		SpellDPS = (985 + 1105) / 2
	elseif CurrentLevel >= 60 then
		SpellDPS = (904 + 1012) / 2
	elseif CurrentLevel >= 56 then
		SpellDPS = (803 + 899) / 2
	elseif CurrentLevel >= 48 then
		SpellDPS = (584 + 652) / 2
	elseif CurrentLevel >= 40 then
		SpellDPS = (377 + 421) / 2
	elseif CurrentLevel >= 32 then
		SpellDPS = (240 + 270) / 2
	elseif CurrentLevel >= 24 then
		SpellDPS = (165 + 185) / 2
	elseif CurrentLevel >= 16 then
		SpellDPS = (101 + 115) / 2
	elseif CurrentLevel >= 8 then
		SpellDPS = (58 + 66) / 2
	elseif CurrentLevel >= 1 then
		SpellDPS = (26 + 30) / 2
	end

	SpellDPS = APDamageModifier * (effectiveAP * 0.15 + SpellDPS) * (1 + SpellCritChance * CritModifier)
	SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(2,19) * 0.02) * (1 + EquipEval:TalentRank(1,1) * 0.05)
	SpellDPS = SpellDPS * (1 - ArmorEffect)
	SpellDPS = SpellDPS * DirtyDeedsEffect

	
	StrikeList["Eviscerate"] = {}
	StrikeList["Eviscerate"].Damage = SpellDPS
	StrikeList["Eviscerate"].Mana = SpellMPS
	StrikeList["Eviscerate"].CritChance = SpellCritChance
	StrikeList["Eviscerate"].CoolDown = SpellDuration
	StrikeList["Eviscerate"].Abbreviation = "E"


	--Rupture (5 point)
	SpellDPS = 0
	SpellMPS = 25
	SpellMPS = SpellMPS + (1 / totalHitYellow - 1) * SpellMPS * (1 - EquipEval:TalentRank(1,15) * 0.4)
	SpellMPS = SpellMPS - 25 * EquipEval:TalentRank(1,7)
	SpellMPS = max(0.00001, SpellMPS)
	SpellCritChance = 0
	SpellDuration = 16
			

	if CurrentLevel >= 68 then
		SpellDPS = 1000
	elseif CurrentLevel >= 60 then
		SpellDPS = 800
	elseif CurrentLevel >= 52 then
		SpellDPS = 576
	elseif CurrentLevel >= 44 then
		SpellDPS = 416
	elseif CurrentLevel >= 36 then
		SpellDPS = 304
	elseif CurrentLevel >= 28 then
		SpellDPS = 216
	elseif CurrentLevel >= 20 then
		SpellDPS = 144
	end

	SpellDPS = APDamageModifier * (effectiveAP * 0.24 + SpellDPS)
	SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(3,11) * 0.1)
	SpellDPS = SpellDPS * (1 + EquipEval.db.profile['PermanentMangleOnTarget'] * 0.3)
	SpellDPS = SpellDPS * (1 - EquipEval.db.profile['EnemyIsBleedImmune'])

	--As it stands, I don't believe that the talent Dirty Deeds will have an effect on Rupture
	StrikeList["Rupture"] = {}
	StrikeList["Rupture"].Damage = SpellDPS
	StrikeList["Rupture"].Mana = SpellMPS
	StrikeList["Rupture"].CritChance = SpellCritChance
	StrikeList["Rupture"].CoolDown = SpellDuration
	StrikeList["Rupture"].Abbreviation = "R"
	
	
	--Expose Armor (5 point)
	SpellDPS = 0
	SpellMPS = 25
	SpellMPS = SpellMPS + (1 / totalHitYellow - 1) * SpellMPS * (1 - EquipEval:TalentRank(1,15) * 0.4)
	SpellMPS = SpellMPS - 25 * EquipEval:TalentRank(1,7)
	SpellMPS = max(0.00001, SpellMPS)
	SpellCritChance = 0
	SpellDuration = 0
	
	if CurrentLevel >= 14 then
		SpellDuration = 30
	end

	StrikeList["Expose Armor"] = {}
	StrikeList["Expose Armor"].Damage = 0
	StrikeList["Expose Armor"].Mana = SpellMPS
	StrikeList["Expose Armor"].CritChance = SpellCritChance
	StrikeList["Expose Armor"].Duration = SpellDuration
	StrikeList["Expose Armor"].Abbreviation = "EA"


	--Slice and Dice
	StrikeList["SND1"] = EquipEval:CalculateRogueSliceAndDice(CurrentLevel, 1, mainSpeed, offSpeed, StrikeList)
	StrikeList["SND2"] = EquipEval:CalculateRogueSliceAndDice(CurrentLevel, 2, mainSpeed, offSpeed, StrikeList)
	StrikeList["SND3"] = EquipEval:CalculateRogueSliceAndDice(CurrentLevel, 3, mainSpeed, offSpeed, StrikeList)
	StrikeList["SND5"] = EquipEval:CalculateRogueSliceAndDice(CurrentLevel, 5, mainSpeed, offSpeed, StrikeList)
	
	return StrikeList
end


---------------------------------------------------------------------------------------
-- Used to calculate Rogue Combos given a strike list and an attack name
---------------------------------------------------------------------------------------
function EquipEval:AssembleRogueCombo(CurrentLevel, StrikeLists, MainStrike, Finisher)
	local Combo = {}
	
	Combo.MainStrike = MainStrike
	Combo.Finisher = Finisher
	Combo.ComboPoints = StrikeLists["Normal"][Finisher].ComboPoints or 5
	Combo.Name = Combo.ComboPoints..Finisher
	
	return Combo
end

---------------------------------------------------------------------------------------
-- Used to calculate Rogue Combos given a strike list and an attack name
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueCombo(CurrentLevel, Combo, StrikeLists, GlobalCoolDown, StunnedUptime, ExposedUptime)

	local ComboPointsPerHit = 1
	if Combo.MainStrike == "Mutilate" then
		ComboPointsPerHit = 2
	end
	
	ComboPointsPerHit = ComboPointsPerHit + EquipEval:TalentRank(1,16) * 0.2 * EquipEval:BlendRogueStrikeList(StrikeLists, Combo.MainStrike, "CritChance", StunnedUptime, ExposedUptime)
	local ComboPointsPerFinisher = EquipEval:TalentRank(1,4) * 0.2
	local NumStrikes = (Combo.ComboPoints - ComboPointsPerFinisher) / ComboPointsPerHit
	local MainHandHits = NumStrikes * EquipEval:BlendRogueStrikeList(StrikeLists, Combo.MainStrike, "MHHits", StunnedUptime, ExposedUptime)
	local OffHandHits = NumStrikes * EquipEval:BlendRogueStrikeList(StrikeLists, Combo.MainStrike, "OHHits", StunnedUptime, ExposedUptime)

	Combo.Damage = NumStrikes * EquipEval:BlendRogueStrikeList(StrikeLists, Combo.MainStrike, "Damage", StunnedUptime, ExposedUptime) + EquipEval:BlendRogueStrikeList(StrikeLists, Combo.Finisher, "Damage", StunnedUptime, ExposedUptime)
	Combo.Energy = NumStrikes * EquipEval:BlendRogueStrikeList(StrikeLists, Combo.MainStrike, "Mana", StunnedUptime, ExposedUptime) + EquipEval:BlendRogueStrikeList(StrikeLists, Combo.Finisher, "Mana", StunnedUptime, ExposedUptime)
	Combo.MHHits = MainHandHits + EquipEval:BlendRogueStrikeList(StrikeLists, Combo.Finisher, "AddMHSwings", StunnedUptime, ExposedUptime) * EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "MHHits", StunnedUptime, ExposedUptime) + EquipEval:BlendRogueStrikeList(StrikeLists, Combo.Finisher, "AddOHSwings", StunnedUptime, ExposedUptime) * EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "MHHits", StunnedUptime, ExposedUptime)
	Combo.OHHits = OffHandHits + EquipEval:BlendRogueStrikeList(StrikeLists, Combo.Finisher, "AddOHSwings", StunnedUptime, ExposedUptime) * EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "OHHits", StunnedUptime, ExposedUptime)
	
	local ComboDuration = GlobalCoolDown * (NumStrikes + 1)
	local ComboCooldown = max(ComboDuration, (StrikeLists["Normal"][Combo.Finisher].CoolDown or GlobalCoolDown), (StrikeLists["Normal"][Combo.Finisher].Duration or GlobalCoolDown))
	Combo.MaxTimeFraction = ComboDuration / ComboCooldown
	Combo.FinisherUptime = (StrikeLists["Normal"][Combo.Finisher].Duration or GlobalCoolDown) / max(ComboDuration, ComboCooldown)
	

	Combo.MaxEnergyPerSecond = Combo.Energy / ComboCooldown
	Combo.DamagePerEnergy = Combo.Damage / Combo.Energy
	Combo.MHHitsPerEnergy = Combo.MHHits / Combo.Energy
	Combo.OHHitsPerEnergy = Combo.OHHits / Combo.Energy
	Combo.FinisherUptimePerEnergy = Combo.FinisherUptime / Combo.Energy
	
	if Combo.TimeFraction and Combo.TimeFraction > 0 then
		Combo.EnergyPerSecond = (Combo.Energy / ComboCooldown) * Combo.TimeFraction
		Combo.FinisherUptime = Combo.FinisherUptime * (Combo.TimeFraction / Combo.MaxTimeFraction)
	end
	
	return Combo
end


---------------------------------------------------------------------------------------
-- Creates a weighted average of a strike property from several strike lists
---------------------------------------------------------------------------------------
function EquipEval:BlendRogueStrikeList(StrikeLists, StrikeName, ValueSought, StunnedUptime, ExposedUptime)
	local BothUptime = min(StunnedUptime, ExposedUptime)
	StunnedUptime = StunnedUptime - BothUptime
	ExposedUptime = ExposedUptime - BothUptime
	local NeitherUptime = 1 - (BothUptime + StunnedUptime + ExposedUptime)

	local Value = NeitherUptime * (StrikeLists["Normal"][StrikeName][ValueSought] or 0)
	Value = Value + ExposedUptime * (StrikeLists["Exposed"][StrikeName][ValueSought] or 0)
	Value = Value + StunnedUptime * (StrikeLists["Stunned"][StrikeName][ValueSought] or 0)
	Value = Value + BothUptime * (StrikeLists["ExposedAndStunned"][StrikeName][ValueSought] or 0)

	return Value
end


---------------------------------------------------------------------------------------
-- Used to calculate Rogue Attack Cycle 
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueCycle(CurrentLevel, StrikeLists, MainStrike, GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)

	local Cycle = {}
	local CycleRating = 0
	local LastCycleRating = -1
	
	local ComboList = {}
	local FinisherNames = { "Eviscerate", "Rupture", "Kidney Shot", "Expose Armor", "SND1", "SND2", "SND3", "SND5" }
	for FinisherNumber = 1, #FinisherNames do
		if not Cycle[FinisherNames[FinisherNumber]] then
			ComboList[FinisherNames[FinisherNumber]] = EquipEval:AssembleRogueCombo(CurrentLevel, StrikeLists, MainStrike, FinisherNames[FinisherNumber])
			EquipEval:CalculateRogueCombo(CurrentLevel, ComboList[FinisherNames[FinisherNumber]], StrikeLists, GlobalCoolDown, 0, 0)
		end
	end
	
	local EmptyCycleDPS, EmptyCycleTF, _, EmptyCycleSpareEnergy = EquipEval:CalculateRogueCycleDPS(CurrentLevel, StrikeLists, Cycle, MainStrike, GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)
	local CycleSpareEnergy = EmptyCycleSpareEnergy
	
	local CycleTimeFraction = 0
	local SNDUptime = 0
	while CycleRating ~= LastCycleRating and CycleSpareEnergy > 0 do
		LastCycleRating = CycleRating
		
		local AddedCombo = nil
		local AddedComboName = ""
		local AddedComboTF = 0
		local AddedComboSpareEnergy = 0
		CycleRating = 0
		for ComboName,Combo in pairs(ComboList) do
			local TempCycle = EquipEval:CopyTable(Cycle)
			Combo.TimeFraction = max(0, min((Combo.MaxTimeFraction or 1), (1 - CycleTimeFraction)))
			if string.sub(ComboName, 1, 3) == "SND" then
				Combo.TimeFraction = max(0, min(Combo.TimeFraction, ((1 - SNDUptime) / Combo.FinisherUptime)))
			end
			Combo.TimeFraction = max(0, min(Combo.TimeFraction, (CycleSpareEnergy / Combo.MaxEnergyPerSecond)))
			TempCycle[ComboName] = Combo
			local TempCycleDPS, TempCycleTF, _, TempCycleSpareEnergy = EquipEval:CalculateRogueCycleDPS(CurrentLevel, StrikeLists, TempCycle, MainStrike, GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)

			
			local TempCycleRating = EquipEval:GetSpellRating((TempCycleDPS - EmptyCycleDPS), (EmptyCycleSpareEnergy - TempCycleSpareEnergy), TempCycleTF)
			if TempCycleRating > CycleRating then
				CycleRating = TempCycleRating
				AddedCombo = Combo
				AddedComboName = ComboName
				AddedComboTF = Combo.TimeFraction
				AddedComboSpareEnergy = TempCycleSpareEnergy
			end
		end
		
		if AddedComboTF > 0 then
			CycleSpareEnergy = AddedComboSpareEnergy
			Cycle[AddedComboName] = AddedCombo
			CycleTimeFraction = CycleTimeFraction + AddedComboTF
			if string.sub(AddedComboName, 1, 3) == "SND" then
				SNDUptime = SNDUptime + ComboList[AddedComboName].FinisherUptime
			end
			ComboList[AddedComboName] = nil
		end
		
	end
	local TotalDPS, _, InfoLine, FinalSpareEnergy = EquipEval:CalculateRogueCycleDPS(CurrentLevel, StrikeLists, Cycle, MainStrike, GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)

	return TotalDPS, InfoLine
end


---------------------------------------------------------------------------------------
-- Used to calculate Rogue Cycle DPS given a strike list and an attack name
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueCycleDPS(CurrentLevel, StrikeLists, Cycle, MainStrike, GlobalCoolDown, MainHandDeadlyPoison, OffHandDeadlyPoison)

	local TotalDPS = 0
	local InfoLine = "Attacks: "

	local EnergyPerSecond = EquipEval.db.profile["EnergyGenerationPerTick"] / 2
	
	local MainHandHitsPerSecond = 0
	local OffHandHitsPerSecond = 0
	
	local StunnedUptime = 0
	local ExposedUptime = 0
	local KidneyShotUptime = 0
	local CycleTimeFraction = 0

	local FinishersPerSecond = 0
	if EquipEval.db.profile["IncludeStrikes"] ~= 0 then
		--Adrenaline Rush
		if EquipEval:TalentRank(2,21) == 1 then
			local RushedTimeFraction = 15 / (5 * 60)
			
			--Interaction of Adrenaline Rush and Preparation removed
			--[[if EquipEval:TalentRank(3,13) == 1 then
				RushedTimeFraction = (15 + 15 + 15) / (2 * 5 * 60 + 15)
			end]]

			EnergyPerSecond = EnergyPerSecond * (1 + RushedTimeFraction)
		end
		

		local CycleName = ""
		local CycleDamage = 0
		local CycleEnergy = 0
		
		if Cycle["Kidney Shot"] then
			EquipEval:CalculateRogueCombo(CurrentLevel, Cycle["Kidney Shot"], StrikeLists, GlobalCoolDown, 0, 0)
			KidneyShotUptime = Cycle["Kidney Shot"].FinisherUptime
			StunnedUptime = StunnedUptime + KidneyShotUptime
		end
		
		if Cycle["Expose Armor"] then
			EquipEval:CalculateRogueCombo(CurrentLevel, Cycle["Expose Armor"], StrikeLists, GlobalCoolDown, 0, 0)
			ExposedUptime = ExposedUptime + Cycle["Expose Armor"].FinisherUptime
		end
		
		--Combat Potency
		EnergyPerSecond = EnergyPerSecond  - 1 / EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "CoolDown", StunnedUptime, ExposedUptime) * EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "Mana", StunnedUptime, ExposedUptime)
		if offSpeed ~= 0 then
			EnergyPerSecond = EnergyPerSecond - 1 / EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "CoolDown", StunnedUptime, ExposedUptime) * EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "Mana", StunnedUptime, ExposedUptime)
		end

		local FinishersPerEnergy = 0
		local MainHandHitsPerEnergy = 0
		local OffHandHitsPerEnergy = 0
		for ComboName,Combo in pairs(Cycle) do
			if Combo.TimeFraction > 0 and EnergyPerSecond > 0 then
				EquipEval:CalculateRogueCombo(CurrentLevel, Combo, StrikeLists, GlobalCoolDown, StunnedUptime, ExposedUptime)
				
				local AlottedEPS = min(EnergyPerSecond, Combo.EnergyPerSecond)
		
				CycleName = CycleName..Combo.ComboPoints..StrikeLists.Normal[ComboName].Abbreviation.."/"
				CycleTimeFraction = CycleTimeFraction + Combo.TimeFraction
						
				if AlottedEPS < EnergyPerSecond then
					EnergyPerSecond = EnergyPerSecond - AlottedEPS
					TotalDPS = TotalDPS + Combo.DamagePerEnergy * AlottedEPS
					MainHandHitsPerSecond = MainHandHitsPerSecond + Combo.MHHitsPerEnergy * AlottedEPS
					OffHandHitsPerSecond = OffHandHitsPerSecond + Combo.OHHitsPerEnergy * AlottedEPS
					FinishersPerSecond = FinishersPerSecond + (1 / Combo.Energy) * AlottedEPS
				else
					CycleDamage = CycleDamage + Combo.Damage
					CycleEnergy = CycleEnergy + Combo.Energy
					
					FinishersPerEnergy = FinishersPerEnergy + 1 / CycleEnergy
					MainHandHitsPerEnergy = MainHandHitsPerEnergy + Combo.MHHits / CycleEnergy
					OffHandHitsPerEnergy = OffHandHitsPerEnergy + Combo.OHHits / CycleEnergy
				end
				
			end
		end
		CycleName = string.sub(CycleName, 1, #CycleName - 1)

		FinishersPerSecond = FinishersPerSecond + FinishersPerEnergy * EnergyPerSecond
		MainHandHitsPerSecond = MainHandHitsPerSecond + MainHandHitsPerEnergy * EnergyPerSecond
		OffHandHitsPerSecond = OffHandHitsPerSecond + OffHandHitsPerEnergy * EnergyPerSecond


		--Calculate yellow dps
		local CycleDPE = CycleDamage / CycleEnergy
		CycleDPE = max(0, CycleDPE)

		--Blade Flurry
		if EquipEval:TalentRank(2,14) == 1 then
			EnergyPerSecond = EnergyPerSecond - EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "Mana", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "CoolDown", StunnedUptime, ExposedUptime)

			local BFEffect = (1 + min(1, EquipEval.db.profile["NumberOfAdditionalTargets"]) * EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "Duration", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "CoolDown", StunnedUptime, ExposedUptime))
			--The next line is not quite right since it assumes blade flurry can do double damage on rupture as well
			CycleDPE = CycleDPE * BFEffect
			MainHandHitsPerSecond = MainHandHitsPerSecond * BFEffect + EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "MHHits", StunnedUptime, ExposedUptime)
			OffHandHitsPerSecond = OffHandHitsPerSecond * BFEffect + EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "OHHits", StunnedUptime, ExposedUptime)

			TotalDPS = TotalDPS + EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "Damage", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "BladeFlurry", "CoolDown", StunnedUptime, ExposedUptime)
		end

		--Add yellow dps
		TotalDPS = TotalDPS + EnergyPerSecond * CycleDPE
		if CycleDPE > 0 then EnergyPerSecond = 0 end
		
		InfoLine = InfoLine..CycleName.." using "..MainStrike
	else
		InfoLine = nil
	end

	--Add white dps
	TotalDPS = TotalDPS + EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "Damage", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "CoolDown", StunnedUptime, ExposedUptime)
	TotalDPS = TotalDPS + EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "Damage", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "CoolDown", StunnedUptime, ExposedUptime)
	MainHandHitsPerSecond = MainHandHitsPerSecond + (EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "MHHits", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "MainHandStrike", "CoolDown", StunnedUptime, ExposedUptime))
	MainHandHitsPerSecond = MainHandHitsPerSecond + (EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "MHHits", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "CoolDown", StunnedUptime, ExposedUptime))
	OffHandHitsPerSecond = OffHandHitsPerSecond + (EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "OHHits", StunnedUptime, ExposedUptime) / EquipEval:BlendRogueStrikeList(StrikeLists, "OffHandStrike", "CoolDown", StunnedUptime, ExposedUptime))


	--Add Deadly Poison Damage
	if MainHandDeadlyPoison == 1 or OffHandDeadlyPoison == 1 then
		local DeadlyPoisonUpTime = (1 - (1 - EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Chance", StunnedUptime, ExposedUptime))^(12 * (MainHandDeadlyPoison * MainHandHitsPerSecond + OffHandDeadlyPoison * OffHandHitsPerSecond)))
		local DeadlyPoisonDPS = EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Damage", StunnedUptime, ExposedUptime) * DeadlyPoisonUpTime + EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Damage", StunnedUptime, ExposedUptime) * DeadlyPoisonUpTime ^ 2 + EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Damage", StunnedUptime, ExposedUptime) * DeadlyPoisonUpTime ^ 3 + EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Damage", StunnedUptime, ExposedUptime) * DeadlyPoisonUpTime ^ 4 + EquipEval:BlendRogueStrikeList(StrikeLists, "DeadlyPoison", "Damage", StunnedUptime, ExposedUptime) * DeadlyPoisonUpTime ^ 5

		TotalDPS = TotalDPS + DeadlyPoisonDPS
	end

	--Account for Find Weakness
	TotalDPS = TotalDPS * (1 + min(1, 10 * FinishersPerSecond) * EquipEval:TalentRank(1,20) * 0.02)
	
	--Account for Improved Kidney Shot
	TotalDPS = TotalDPS * (1 + KidneyShotUptime * EquipEval:TalentRank(1,14) * 0.03)
	
	
	if not EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = nil
	end

	return TotalDPS, CycleTimeFraction, InfoLine, EnergyPerSecond

end


---------------------------------------------------------------------------------------
-- Used to calculate Rogue Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateRogueMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (self.db.profile["EnemyBaseCritPercentage"] / 100 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = (self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference())
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	local agiMultiplier = (1 + .01 * EquipEval:TalentRank(2,20)) * (1 + .03 * EquipEval:TalentRank(3,21))
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))
	
	critBase = critBase - EquipEval:TalentRank(3,3) * .01

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..parryChance)

	local stanceModifier = 1
	stanceModifier = stanceModifier * (1 - 0.01 * EquipEval:TalentRank(1,19))


	
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")



	--Factor in stats
	armor = armor

	stamMultiplier = stamMultiplier * (1 + EquipEval:TalentRank(2,20) * .02)

	armor = armor + 2 * agiMultiplier * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 42 currently
	if CurrentLevel >= 43 then 
		dodgeChance = dodgeChance + (agiMultiplier * agi / 20.0) / 100
	else
		dodgeChance = dodgeChance + (agiMultiplier * agi / 9.23077) / 100
	end
	self:Debug("Dodge %: "..dodgeChance)

	parryChance = parryChance + defensePercent
	parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end

