

local Bonus = AceLibrary("LibItemBonus-2.0")


local eqevIntTablePriest = {
5.85, 6.11, 6.38, 6.64, 7.17, 7.44, 7.71, 7.97, 8.24, 8.77, 
9.57, 10.63, 11.43, 12.76, 13.81, 14.62, 15.95, 16.75, 17.79, 19.12, 
19.92, 21.28, 22.08, 23.36, 24.45, 25.51, 26.6, 27.62, 28.74, 30.03, 
31.06, 32.15, 33.22, 34.6, 35.59, 36.63, 38.02, 39.06, 40.16, 41.49, 
42.55, 43.86, 44.84, 46.3, 47.62, 48.54, 50, 51.02, 52.36, 53.76, 
54.64, 56.18, 57.14, 58.48, 60.24, 60.98, 62.5, 63.69, 64.94, 66.23, 
67.57, 68.97, 69.93, 71.94, 72.99, 74.63, 75.76, 76.92, 78.74, 80 }





--Priest Spells



local EquipEval_SpellTableRenew = {
	All = {
		Level = 0,
		Coefficient = 0,
		OverTimeCoefficient = 1,
		CastTime = 0,
		Duration = 15,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 8,
		HealOverTimeAmount = 45,
		ManaCost = 30
	},

	{
		Level = 14,
		HealOverTimeAmount = 100,
		ManaCost = 65
	},

	{
		Level = 20,
		HealOverTimeAmount = 175,
		ManaCost = 105
	},

	{
		Level = 26,
		HealOverTimeAmount = 245,
		ManaCost = 140
	},

	{
		Level = 32,
		HealOverTimeAmount = 315,
		ManaCost = 170
	},

	{
		Level = 38,
		HealOverTimeAmount = 400,
		ManaCost = 205
	},

	{
		Level = 44,
		HealOverTimeAmount = 510,
		ManaCost = 250
	},

	{
		Level = 50,
		HealOverTimeAmount = 650,
		ManaCost = 305
	},

	{
		Level = 56,
		HealOverTimeAmount = 810,
		ManaCost = 365
	},

	{
		Level = 60,
		HealOverTimeAmount = 970,
		ManaCost = 410
	},

	{
		Level = 65,
		HealOverTimeAmount = 1010,
		ManaCost = 430
	},

	{
		Level = 70,
		HealOverTimeAmount = 1110,
		ManaCost = 450
	},
}


local EquipEval_SpellTableLightwell = {
	All = {
		Level = 0,
		Coefficient = 0,
		OverTimeCoefficient = 1 * 5,
		CastTime = 1.5,
		Duration = 6,
		CoolDown = 360,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 40,
		HealOverTimeAmount = 800 * 5,
		ManaCost = 225
	},

	{
		Level = 50,
		HealOverTimeAmount = 1165 * 5,
		ManaCost = 295
	},

	{
		Level = 60,
		HealOverTimeAmount = 1600 * 5,
		ManaCost = 365
	},

	{
		Level = 70,
		HealOverTimeAmount = 2361 * 5,
		ManaCost = 445
	},
}


local EquipEval_SpellTablePrayerOfMending = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 30,
		CoolDown = 10,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 2,
		AdditionalTargetFactor = 5
	},

	{
		Level = 68,
		DirectHealAmount = 800,
		ManaCost = 390
	},	
}



local EquipEval_SpellTableCircleOfHealing = {
	All = {
		Level = 0,
		Coefficient = 0.213859,
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 5,
		AdditionalTargetFactor = 1
	},

	{
		Level = 50,
		DirectHealAmount = (246 + 270) / 2,
		ManaCost = 300
	},	

	{
		Level = 56,
		DirectHealAmount = (288 + 318) / 2,
		ManaCost = 337
	},	

	{
		Level = 60,
		DirectHealAmount = (327 + 361) / 2,
		ManaCost = 375
	},	

	{
		Level = 65,
		DirectHealAmount = (370 + 408) / 2,
		ManaCost = 412
	},	

	{
		Level = 70,
		DirectHealAmount = (499 + 551) / 2,
		ManaCost = 450
	},	
	
	
}






local EquipEval_SpellTablePrayerOfHealing = {
	All = {
		Level = 0,
		Coefficient = (3 / 3.5 / 3),
		OverTimeCoefficient = 0,
		CastTime = 3,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 5,
		AdditionalTargetFactor = 1
	},

	{
		Level = 30,
		DirectHealAmount = (312 + 333) / 2,
		ManaCost = 410
	},	

	{
		Level = 40,
		DirectHealAmount = (458 + 487) / 2,
		ManaCost = 560
	},	

	{
		Level = 50,
		DirectHealAmount = (675 + 713) / 2,
		ManaCost = 770
	},	

	{
		Level = 60,
		DirectHealAmount = (960 + 1013) / 2,
		ManaCost = 1030
	},	

	{
		Level = 62,
		DirectHealAmount = (1019 + 1076) / 2,
		ManaCost = 1070
	},	

	{
		Level = 68,
		DirectHealAmount = (1251 + 1322) / 2,
		ManaCost = 1225
	},	
}


local EquipEval_SpellTableHolyNova = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5 / 3),
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 5,
		AdditionalTargetFactor = 1
	},

	{
		Level = 20,
		DirectHealAmount = (52 + 60) / 2,
		ManaCost = 185
	},

	{
		Level = 28,
		DirectHealAmount = (86 + 98) / 2,
		ManaCost = 290
	},

	{
		Level = 36,
		DirectHealAmount = (121 + 139) / 2,
		ManaCost = 400
	},

	{
		Level = 44,
		DirectHealAmount = (161 + 188) / 2,
		ManaCost = 520
	},

	{
		Level = 52,
		DirectHealAmount = (235 + 272) / 2,
		ManaCost = 635
	},

	{
		Level = 60,
		DirectHealAmount = (302 + 350) / 2,
		ManaCost = 750
	},

	{
		Level = 68,
		DirectHealAmount = (384 + 446) / 2,
		ManaCost = 875
	},
}


local EquipEval_SpellTableBindingHeal = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 1.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 2,
		AdditionalTargetFactor = 1
	},

	{
		Level = 64,
		DirectHealAmount = (1042 + 1338) / 2,
		ManaCost = 705
	},

}



local EquipEval_SpellTableFlashHeal = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 1.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 20,
		DirectHealAmount = (202 + 247) / 2,
		ManaCost = 125
	},

	{
		Level = 26,
		DirectHealAmount = (269 + 325) / 2,
		ManaCost = 155
	},

	{
		Level = 32,
		DirectHealAmount = (339 + 406) / 2,
		ManaCost = 185
	},

	{
		Level = 38,
		DirectHealAmount = (414 + 492) / 2,
		ManaCost = 215
	},

	{
		Level = 44,
		DirectHealAmount = (534 + 633) / 2,
		ManaCost = 265
	},

	{
		Level = 52,
		DirectHealAmount = (662 + 783) / 2,
		ManaCost = 315
	},

	{
		Level = 58,
		DirectHealAmount = (833 + 979) / 2,
		ManaCost = 380
	},

	{
		Level = 61,
		DirectHealAmount = (931 + 1078) / 2,
		ManaCost = 400
	},

	{
		Level = 67,
		DirectHealAmount = (1116 + 1295) / 2,
		ManaCost = 470
	},

}



local EquipEval_SpellTablePowerWordShield = {
	All = {
		Level = 0,
		Coefficient = 0.3,
		OverTimeCoefficient = 0,
		CastTime = 0,
		Duration = 15,
		CoolDown = 4,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 6,
		DirectHealAmount = 44,
		ManaCost = 45
	},

	{
		Level = 12,
		DirectHealAmount = 88,
		ManaCost = 80
	},

	{
		Level = 18,
		DirectHealAmount = 158,
		ManaCost = 130
	},

	{
		Level = 24,
		DirectHealAmount = 234,
		ManaCost = 175
	},

	{
		Level = 30,
		DirectHealAmount = 301,
		ManaCost = 210
	},

	{
		Level = 36,
		DirectHealAmount = 381,
		ManaCost = 250
	},

	{
		Level = 42,
		DirectHealAmount = 484,
		ManaCost = 300
	},

	{
		Level = 48,
		DirectHealAmount = 605,
		ManaCost = 355
	},

	{
		Level = 54,
		DirectHealAmount = 763,
		ManaCost = 425
	},

	{
		Level = 60,
		DirectHealAmount = 942,
		ManaCost = 500
	},

	{
		Level = 65,
		DirectHealAmount = 1147,
		ManaCost = 540
	},

	{
		Level = 70,
		DirectHealAmount = 1315,
		ManaCost = 600
	},

}



local EquipEval_SpellTableGreaterHeal = {
	All = {
		Level = 0,
		Coefficient = (3 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 3,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 40,
		DirectHealAmount = (924 + 1039) / 2,
		ManaCost = 370
	},

	{
		Level = 46,
		DirectHealAmount = (1178 + 1318) / 2,
		ManaCost = 455
	},

	{
		Level = 52,
		DirectHealAmount = (1470 + 1642) / 2,
		ManaCost = 545
	},

	{
		Level = 58,
		DirectHealAmount = (1835 + 2044) / 2,
		ManaCost = 655
	},

	{
		Level = 60,
		DirectHealAmount = (2006 + 2235) / 2,
		ManaCost = 710
	},

	{
		Level = 63,
		DirectHealAmount = (2107 + 2444) / 2,
		ManaCost = 750
	},

	{
		Level = 68,
		DirectHealAmount = (2414 + 2803) / 2,
		ManaCost = 825
	},

}




local EquipEval_SpellTableHeal = {
	All = {
		Level = 0,
		Coefficient = (3 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 3,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},


	{
		Level = 16,
		DirectHealAmount = (307 + 353) / 2,
		ManaCost = 155
	},
	
	{
		Level = 22,
		DirectHealAmount = (445 + 507) / 2,
		ManaCost = 205
	},
	
	{
		Level = 28,
		DirectHealAmount = (586 + 662) / 2,
		ManaCost = 255
	},
	
	{
		Level = 34,
		DirectHealAmount = (734 + 827) / 2,
		ManaCost = 305
	},

}



local EquipEval_SpellTableLesserHeal = {
	All = {
		Level = 0,
		Coefficient = (2.5 / 3.5),
		OverTimeCoefficient = 0,
		CastTime = 2.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1,
		AdditionalTargetFactor = 1
	},

	{
		Level = 1,
		Coefficient = (1.5 / 3.5),
		CastTime = 1.5,
		DirectHealAmount = (47 + 58) / 2,
		ManaCost = 35
	},

	{
		Level = 4,
		Coefficient = (2.0 / 3.5),
		CastTime = 2.0,
		DirectHealAmount = (76 + 91) / 2,
		ManaCost = 50
	},

	{
		Level = 10,
		DirectHealAmount = (143 + 165) / 2,
		ManaCost = 85
	},

}







---------------------------------------------------------------------------------------
-- Used to calculate Priest DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePriestDPS(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str, stam, arcanedmg, spellpen, naturedmg, holydmg, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)
	
	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTablePriest[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,20) * 0.01) * (1 + TotalModInt / 100)
	local SpiModifier = 1 + EquipEval:TalentRank(1,20) * 0.01
	SpiModifier = SpiModifier * (1 + EquipEval:TalentRank(2,13) * 0.05)
	local ManaModifier = 1 + EquipEval:TalentRank(1,13) * 0.02
	
	
	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemDmg = spelldmg + itemSpi * EquipEval:TalentRank(2,14) * 0.05 + itemSpi * EquipEval:TalentRank(1,15) * 0.05
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemHit = (hit / 8.0 * LevelRating) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5

	local BaseSpiritTapUptime = 0
	local NewSpiritTapUptime = 0
	if EquipEval.db.profile["CalculateSpiritTapEffect"] and EquipEval:TalentRank(3,1) > 0 then
		_, BaseSpiritTapUptime = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, 0, 0)
		_, BaseSpiritTapUptime = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, BaseSpiritTapUptime, 0)
		_, NewSpiritTapUptime = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemInt, itemSpi, itemCrit, (itemDmg + BonusSpellDmg), (itemHaste + BonusSpellHaste), itemHit, shadowdmg, spellpen, holycrit, holydmg, BaseSpiritTapUptime, spellcritbonus)
		_, NewSpiritTapUptime = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemInt, itemSpi, itemCrit, (itemDmg + BonusSpellDmg), (itemHaste + BonusSpellHaste), itemHit, shadowdmg, spellpen, holycrit, holydmg, NewSpiritTapUptime, spellcritbonus)
		
		if abs(NewSpiritTapUptime - BaseSpiritTapUptime) < 0.05 then
			BaseSpiritTapUptime = NewSpiritTapUptime
		end
	end

	local baseDPS = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, BaseSpiritTapUptime, 0)
	local newDPS, _, InfoLine = EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemInt, itemSpi, itemCrit, (itemDmg + BonusSpellDmg), (itemHaste + BonusSpellHaste), itemHit, shadowdmg, spellpen, holycrit, holydmg, NewSpiritTapUptime, spellcritbonus)
	self:Debug("Spirit Tap Uptime: "..NewSpiritTapUptime)

	return (newDPS - baseDPS), newDPS, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Priest DPS From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculatePriestDPSFromStats(CurrentLevel, LevelRating, mana, mp5, itemInt, itemSpi, crit, spelldmg, haste, hit, shadowdmg, spellpen, holycrit, holydmg, SpiritTapUptime, spellcritbonus)
	local InfoLine = "Spells: "

	--Special handling for the effects of Spirit Tap
	local _, curSpi = UnitStat("player", 5);
	local BonusSpiritFromTap = SpiritTapUptime * (curSpi + itemSpi)
	local BonusDmgFromTap = BonusSpiritFromTap * EquipEval:TalentRank(2,14) * 0.05 + BonusSpiritFromTap * EquipEval:TalentRank(1,15) * 0.05
	itemSpi = itemSpi + BonusSpiritFromTap
	spelldmg = spelldmg + BonusDmgFromTap

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100

	local CritModifier = 0.5
	CritModifier = (CritModifier + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local ManaCostModifier = 1
	self:Debug("Mana Cost Modifier: "..ManaCostModifier)
	
	local DamageModifierShadow = (1 + EquipEval:TalentRank(1,17) * 0.01) * (1 + EquipEval:TalentRank(3,11) * 0.02) * (1 + EquipEval:TalentRank(3,17) * 0.02)
	self:Debug("Damage Modifier Shadow: "..DamageModifierShadow)

	local DamageModifierHoly = (1 + EquipEval:TalentRank(1,17) * 0.01)
	self:Debug("Damage Modifier Holy: "..DamageModifierHoly)

	local totalCritShadow = GetSpellCritChance(6)
	totalCritShadow = totalCritShadow + EquipEval:TalentRank(1,17) + EquipEval:TalentRank(3,19)
	totalCritShadow = totalCritShadow + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritShadow = max(0, (totalCritShadow / 100 + crit - resilienceEffect))
	totalCritShadow = min(1, totalCritShadow * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Shadow: "..totalCritShadow)
	
	local totalCritHoly = GetSpellCritChance(2) + holycrit / 100
	totalCritHoly = totalCritHoly + EquipEval:TalentRank(1,17)
	totalCritHoly = totalCritHoly + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritHoly = max(0, (totalCritHoly / 100 + crit - resilienceEffect))
	totalCritHoly = min(1, totalCritHoly * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Holy: "..totalCritHoly)

	local totalHitShadow = EquipEval:GetSpellHitChance() + hit
	totalHitShadow = totalHitShadow + EquipEval:TalentRank(3,5) * 2 / 100
	totalHitShadow = totalHitShadow + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitShadow = max(0.01, (1 - (1 - totalHitShadow) / EquipEval.db.profile["BurstFactor"]))
	totalHitShadow = min(0.99, totalHitShadow) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit Shadow: "..totalHitShadow)

	local totalHitHoly = EquipEval:GetSpellHitChance() + hit
	totalHitHoly = totalHitHoly + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitHoly = max(0.01, (1 - (1 - totalHitHoly) / EquipEval.db.profile["BurstFactor"]))
	totalHitHoly = min(0.99, totalHitHoly) * EquipEval:GetResistanceModifier(10000)
	self:Debug("Total Hit Holy: "..totalHitHoly)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenCasting
	local CastingRegen = EquipEval:TalentRank(1,9) * 0.1 + SpiritTapUptime * 0.5
	local spiMP5 = CastingRegen * EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	totalMP5 = totalMP5 + mp5 + spiMP5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]

	self:Debug("Total MP5: "..totalMP5)

	local totalDmgShadow = GetSpellBonusDamage(6) + spelldmg + shadowdmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total Shadow Dmg: "..totalDmgShadow)
	
	local totalDmgHoly = GetSpellBonusDamage(2) + spelldmg + holydmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total Holy Dmg: "..totalDmgHoly)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)
	
	local ShadowFormActive = GetShapeshiftForm(true)
	ShadowFormActive = (ShadowFormActive or 0) * EquipEval:TalentRank(3,18)
	if ShadowFormActive == 1 then
		DamageModifierShadow = DamageModifierShadow * (1.15)
		DamageModifierHoly = 0
		self:Debug("Shadow Form Is Active")
	end
		


	local TimeFraction = 1
	local SpellDPS = 0
	local SpellMPS = 0
	local TotalDPS = 0
	local TotalMPS = 0
	local CastTime = 0
	local SpellDuration = 0
	local SpellCritChance = 0

	local SurgeOfLightChance = max(0, min(1, (EquipEval:TalentRank(2,15) * 0.25 * EquipEval.db.profile["BurstFactor"])))


	--Smite
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 2.5
	SpellDuration = 0
	SpellCritChance = totalCritHoly
	if CurrentLevel >= 1 and TimeFraction > 0 then

		if CurrentLevel >= 69 then
			SpellDPS = (549 + 616) / 2
			SpellMPS = 385
		elseif CurrentLevel >= 61 then
			SpellDPS = (422 + 470) / 2
			SpellMPS = 300
		elseif CurrentLevel >= 54 then
			SpellDPS = (384 + 429) / 2
			SpellMPS = 295
		elseif CurrentLevel >= 46 then
			SpellDPS = (298 + 335) / 2
			SpellMPS = 245
		elseif CurrentLevel >= 38 then
			SpellDPS = (222 + 250) / 2
			SpellMPS = 195
		elseif CurrentLevel >= 30 then
			SpellDPS = (158 + 178) / 2
			SpellMPS = 150
		elseif CurrentLevel >= 22 then
			SpellDPS = (97 + 112) / 2
			SpellMPS = 100
		elseif CurrentLevel >= 14 then
			SpellDPS = (58 + 67) / 2
			SpellMPS = 65
		elseif CurrentLevel >= 6 then
			SpellDPS = (28 + 34) / 2
			SpellMPS = 35
			CastTime = 2.0
		elseif CurrentLevel >= 1 then
			SpellDPS = (15 + 20) / 2
			SpellMPS = 20
			CastTime = 1.5
		end

		SpellDPS = DamageModifierHoly * (1 + EquipEval:TalentRank(2,11) * 0.05) * min((totalHitHoly + EquipEval:TalentRank(1,16) * 0.02), 0.99) * (1 + SpellCritChance * CritModifier) * (SpellDPS + (CastTime / 3.5) * totalDmgHoly)
		SpellMPS = ManaCostModifier * SpellMPS

		CastTime = CastTime - EquipEval:TalentRank(2,5) * 0.1
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
	end
	local FreeSmiteCastTime = (EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"])
	local FreeSmiteDamage = (SpellDPS / (1 + SpellCritChance * CritModifier))
	local FreeSmiteRating = EquipEval:GetSpellRating(FreeSmiteDamage, 0.000000001, FreeSmiteCastTime) * (1 - ShadowFormActive)
	local SmiteRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	if FreeSmiteRating > 0 then
		SpellDPS = SpellDPS + SpellCritChance * SurgeOfLightChance * FreeSmiteDamage
		CastTime = CastTime + SpellCritChance * SurgeOfLightChance * FreeSmiteCastTime
		SmiteRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	end
	local SmiteDPS = SpellDPS / CastTime
	local SmiteMPS = SpellMPS / CastTime
	local SmiteMaxTimeFraction = CastTime / (CastTime + SpellDuration)
	
	
	--Holy Fire
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 3.5 - EquipEval:TalentRank(2,5) * 0.1
	SpellDuration = 10
	SpellCritChance = totalCritHoly
	if CurrentLevel >= 20 and TimeFraction > 0 then
		local DoTDamage = 0

		if CurrentLevel >= 66 then
			SpellDPS = (412 + 522) / 2
			DoTDamage = 165
			SpellMPS = 290
		elseif CurrentLevel >= 60 then
			SpellDPS = (355 + 449) / 2
			DoTDamage = 145
			SpellMPS = 255
		elseif CurrentLevel >= 54 then
			SpellDPS = (304 + 386) / 2
			DoTDamage = 125
			SpellMPS = 230
		elseif CurrentLevel >= 48 then
			SpellDPS = (254 + 322) / 2
			DoTDamage = 100
			SpellMPS = 200
		elseif CurrentLevel >= 42 then
			SpellDPS = (204 + 258) / 2
			DoTDamage = 85
			SpellMPS = 170
		elseif CurrentLevel >= 36 then
			SpellDPS = (165 + 209) / 2
			DoTDamage = 65
			SpellMPS = 145
		elseif CurrentLevel >= 30 then
			SpellDPS = (132 + 166) / 2
			DoTDamage = 55
			SpellMPS = 125
		elseif CurrentLevel >= 24 then
			SpellDPS = (96 + 120) / 2
			DoTDamage = 40
			SpellMPS = 95
		elseif CurrentLevel >= 20 then
			SpellDPS = (78 + 98) / 2
			DoTDamage = 30
			SpellMPS = 85
		end

		SpellDPS = DamageModifierHoly * (1 + EquipEval:TalentRank(2,11) * 0.05) * ((1 + SpellCritChance * CritModifier) * (SpellDPS + 0.8571 * totalDmgHoly) + (DoTDamage + 0.165 * totalDmgHoly))
		SpellMPS = ManaCostModifier * SpellMPS / totalHitHoly

		CastTime = CastTime / (1 + totalHaste)
		CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / totalHitHoly
	end
	local HolyFireRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	if (FreeSmiteRating > HolyFireRating) and FreeSmiteRating > 0 then
		SpellDPS = SpellDPS + SpellCritChance * SurgeOfLightChance * FreeSmiteDamage
		CastTime = CastTime + SpellCritChance * SurgeOfLightChance * FreeSmiteCastTime
		HolyFireRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	end
	local HolyFireDPS = SpellDPS / CastTime
	local HolyFireMPS = SpellMPS / CastTime
	local HolyFireMaxTimeFraction = CastTime / SpellDuration


	--Vampiric Touch
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 1.5
	SpellDuration = 15
	SpellCritChance = 0
	if EquipEval:TalentRank(3,21) > 0 and TimeFraction > 0 then
	
		if CurrentLevel >= 70 then
			SpellDPS = 650
			SpellMPS = 425
		elseif CurrentLevel >= 60 then
			SpellDPS = 600
			SpellMPS = 400
		elseif CurrentLevel >= 50 then
			SpellDPS = 450
			SpellMPS = 325
		end
	
		CastTime = CastTime / (1 + totalHaste)
		CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / totalHitShadow
	
		SpellDPS = DamageModifierShadow * (1 - resilienceEffect) * (SpellDPS + totalDmgShadow)
		SpellMPS = ManaCostModifier / totalHitShadow * SpellMPS

	end
	local VampiricTouchRating = 2 * EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local VampiricTouchDPS = SpellDPS / CastTime
	local VampiricTouchMPS = SpellMPS / CastTime
	local VampiricTouchCastTime = CastTime
	local VampiricTouchMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * CastTime / SpellDuration


	--Shadow Word Pain
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	SpellDuration = 18
	SpellCritChance = 0
	if CurrentLevel >= 4 and TimeFraction > 0 then
	
		if CurrentLevel >= 70 then
			SpellDPS = 1236
			SpellMPS = 575
		elseif CurrentLevel >= 65 then
			SpellDPS = 1002
			SpellMPS = 510
		elseif CurrentLevel >= 58 then
			SpellDPS = 852
			SpellMPS = 470
		elseif CurrentLevel >= 50 then
			SpellDPS = 672
			SpellMPS = 385
		elseif CurrentLevel >= 42 then
			SpellDPS = 510
			SpellMPS = 305
		elseif CurrentLevel >= 34 then
			SpellDPS = 366
			SpellMPS = 230
		elseif CurrentLevel >= 26 then
			SpellDPS = 234
			SpellMPS = 155
		elseif CurrentLevel >= 18 then
			SpellDPS = 132
			SpellMPS = 95
		elseif CurrentLevel >= 10 then
			SpellDPS = 66
			SpellMPS = 50
		elseif CurrentLevel >= 4 then
			SpellDPS = 30
			SpellMPS = 25
		end
		

		CastTime = CastTime / (1 + totalHaste)
		CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / totalHitShadow

		SpellDPS = DamageModifierShadow * (1 - resilienceEffect) * (SpellDPS + totalDmgShadow * 1.1) / SpellDuration
		SpellDuration = SpellDuration + EquipEval:TalentRank(3,4)
		SpellDPS = SpellDPS * SpellDuration

		SpellMPS = ManaCostModifier / totalHitShadow * (1 - EquipEval:TalentRank(1,11) * 0.02) * SpellMPS
	end
	local SWPRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local SWPDPS = SpellDPS / CastTime
	local SWPMPS = SpellMPS / CastTime
	local SWPMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * CastTime / SpellDuration
	

	local ShadowFiendDPS = 0
	--Shadow Fiend
	if CurrentLevel >= 66 and TimeFraction > 0 then
		SpellDPS = 1100
		SpellMPS = 134
		CastTime = 0
		SpellDuration = 300
	
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
	
		--Damage modeling does not include melee attack rules currently
		SpellDPS = DamageModifierShadow * (SpellDPS + totalDmgShadow * 0.65) / SpellDuration
		SpellMPS = ManaCostModifier * SpellMPS / SpellDuration
	
		ShadowFiendDPS = SpellDPS
		TotalMPS = TotalMPS + SpellMPS
		TimeFraction = TimeFraction - (CastTime / SpellDuration)

		totalMP5 = totalMP5 + 5 * (ShadowFiendDPS * 2.5)
	end


	--Mind Blast
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 1.5
	SpellDuration = 8 - EquipEval:TalentRank(3,7) * 0.5
	SpellCritChance = totalCritShadow
	if CurrentLevel >= 10 and TimeFraction > 0 then

		if CurrentLevel >= 69 then
			SpellDPS = (711 + 752) / 2
			SpellMPS = 450
		elseif CurrentLevel >= 63 then
			SpellDPS = (571 + 602) / 2
			SpellMPS = 380
		elseif CurrentLevel >= 58 then
			SpellDPS = (516 + 544) / 2
			SpellMPS = 350
		elseif CurrentLevel >= 52 then
			SpellDPS = (437 + 461) / 2
			SpellMPS = 310
		elseif CurrentLevel >= 46 then
			SpellDPS = (356 + 377) / 2
			SpellMPS = 265
		elseif CurrentLevel >= 40 then
			SpellDPS = (268 + 307) / 2
			SpellMPS = 225
		elseif CurrentLevel >= 34 then
			SpellDPS = (225 + 239) / 2
			SpellMPS = 185
		elseif CurrentLevel >= 28 then
			SpellDPS = (174 + 184) / 2
			SpellMPS = 150
		elseif CurrentLevel >= 22 then
			SpellDPS = (117 + 126) / 2
			SpellMPS = 110
		elseif CurrentLevel >= 16 then
			SpellDPS = (76 + 83) / 2
			SpellMPS = 80
		elseif CurrentLevel >= 10 then
			SpellDPS = (42 + 46) / 2
			SpellMPS = 50
		end

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]

		SpellDPS = DamageModifierShadow * min((totalHitShadow + EquipEval:TalentRank(1,16) * 0.02), 0.99) * (1 + SpellCritChance * CritModifier) * (SpellDPS + (1.5 / 3.5) * totalDmgShadow)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(3,15) * 0.05) * SpellMPS
	end
	local MindBlastRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local MindBlastCastTime = CastTime
	if (FreeSmiteRating > MindBlastRating) and FreeSmiteRating > 0 then
		SpellDPS = SpellDPS + SpellCritChance * SurgeOfLightChance * FreeSmiteDamage
		CastTime = CastTime + SpellCritChance * SurgeOfLightChance * FreeSmiteCastTime
		MindBlastRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	end
	local MindBlastDPS = SpellDPS / CastTime
	local MindBlastMPS = SpellMPS / CastTime
	local MindBlastMaxTimeFraction = CastTime / (MindBlastCastTime + SpellDuration)
	

	--Shadow Word Death
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	SpellDuration = 12
	SpellCritChance = totalCritShadow
	if CurrentLevel >= 62 and TimeFraction > 0 then
	
		if CurrentLevel >= 70 then
			SpellDPS = (572 + 664) / 2
			SpellMPS = 309
		elseif CurrentLevel >= 62 then
			SpellDPS = (450 + 664) / 2
			SpellMPS = 243
		end
	
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
	
		SpellDPS = DamageModifierShadow * totalHitShadow * (1 + SpellCritChance * CritModifier) * (SpellDPS + (1.5 / 3.5) * totalDmgShadow)
		SpellMPS = ManaCostModifier * SpellMPS
	end
	local SWDRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local SWDCastTime = CastTime
	if (FreeSmiteRating > SWDRating) and FreeSmiteRating > 0 then
		SpellDPS = SpellDPS + SpellCritChance * SurgeOfLightChance * FreeSmiteDamage
		CastTime = CastTime + SpellCritChance * SurgeOfLightChance * FreeSmiteCastTime
		SWDRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	end
	local SWDDPS = SpellDPS / CastTime
	local SWDMPS = SpellMPS / CastTime
	local SWDMaxTimeFraction = CastTime / (SWDCastTime + SpellDuration)


	--Mind Flay
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 3
	SpellDuration = 0
	SpellCritChance = 0
	if EquipEval:TalentRank(3,8) > 0 and TimeFraction > 0 then
	
		if CurrentLevel >= 68 then
			SpellDPS = 528
			SpellMPS = 230
		elseif CurrentLevel >= 60 then
			SpellDPS = 426
			SpellMPS = 205
		elseif CurrentLevel >= 52 then
			SpellDPS = 330
			SpellMPS = 165
		elseif CurrentLevel >= 44 then
			SpellDPS = 261
			SpellMPS = 135
		elseif CurrentLevel >= 36 then
			SpellDPS = 186
			SpellMPS = 100
		elseif CurrentLevel >= 28 then
			SpellDPS = 126
			SpellMPS = 70
		elseif CurrentLevel >= 20 then
			SpellDPS = 75
			SpellMPS = 45
		end
	
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
		CastTime = CastTime + (1 / totalHitShadow - 1) * (EquipEval:GetSpellGCD(totalHaste) + EquipEval.db.profile["CastTimePadding"])
	
		SpellDPS = DamageModifierShadow * (1 - resilienceEffect) * (SpellDPS + 0.572 * totalDmgShadow)
		SpellMPS = ManaCostModifier / totalHitShadow * (1 - EquipEval:TalentRank(3,15) * 0.05) * SpellMPS
	end
	local MindFlayRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local MindFlayDPS = SpellDPS / CastTime
	local MindFlayMPS = SpellMPS / CastTime
	local MindFlayMaxTimeFraction = CastTime / (CastTime + SpellDuration)





	--Adjust ratings due to misery
	if EquipEval:TalentRank(3,20) > 0 then
		VampiricTouchRating = VampiricTouchRating * (1 + EquipEval:TalentRank(3,20) * 0.1)
		SWPRating = SWPRating * (1 + EquipEval:TalentRank(3,20) * 0.1)
	end

	--Choose Spells
	local MiseryActive = 0
	local VampiricTouchActive = 0
	local ShadowDPS = 0
	while TimeFraction > 0 do
		local MaxRating = max(VampiricTouchRating, SWPRating, MindBlastRating, SWDRating, MindFlayRating, SmiteRating, HolyFireRating)
		local SpellTimeFraction = 0
		
		if MaxRating <= 0 then
			break
		end

		if VampiricTouchRating == MaxRating then
			SpellTimeFraction = VampiricTouchMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * VampiricTouchMPS
			TotalDPS = TotalDPS + VampiricTouchDPS * SpellTimeFraction
			ShadowDPS = ShadowDPS + VampiricTouchDPS * SpellTimeFraction
			VampiricTouchActive = SpellTimeFraction / VampiricTouchMaxTimeFraction
			MiseryActive = max(MiseryActive, (SpellTimeFraction / VampiricTouchMaxTimeFraction))
			
			TimeFraction = TimeFraction - SpellTimeFraction
			VampiricTouchRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Vampiric Touch "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."VT, "
			end
		elseif SWPRating == MaxRating then
			SpellTimeFraction = SWPMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * SWPMPS
			TotalDPS = TotalDPS + SWPDPS * SpellTimeFraction
			ShadowDPS = ShadowDPS + SWPDPS * SpellTimeFraction
			MiseryActive = max(MiseryActive, (SpellTimeFraction / SWPMaxTimeFraction))
			
			TimeFraction = TimeFraction - SpellTimeFraction
			SWPRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Shadow Word Pain "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."SWP, "
			end
		elseif MindBlastRating == MaxRating then
			SpellTimeFraction = MindBlastMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * MindBlastMPS
			TotalDPS = TotalDPS + MindBlastDPS * SpellTimeFraction
			ShadowDPS = ShadowDPS + MindBlastDPS * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			MindBlastRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Mind Blast "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."MB, "
			end
		elseif SWDRating == MaxRating then
			SpellTimeFraction = SWDMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * SWDMPS
			TotalDPS = TotalDPS + SWDDPS * SpellTimeFraction
			ShadowDPS = ShadowDPS + SWDDPS * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			SWDRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Shadow Word Death "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."SWD, "
			end
		elseif MindFlayRating == MaxRating then
			SpellTimeFraction = MindFlayMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * MindFlayMPS
			TotalDPS = TotalDPS + MindFlayDPS * SpellTimeFraction
			ShadowDPS = ShadowDPS + MindFlayDPS * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			MindFlayRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Mind Flay "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."MF, "
			end
		elseif SmiteRating == MaxRating then
			SpellTimeFraction = SmiteMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * SmiteMPS
			TotalDPS = TotalDPS + SmiteDPS * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			SmiteRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Smite "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."Smite, "
			end
		elseif HolyFireRating == MaxRating then
			SpellTimeFraction = HolyFireMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * HolyFireMPS
			TotalDPS = TotalDPS + HolyFireDPS * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			HolyFireRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Holy Fire "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."HF, "
			end
		else
			break
		end
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = nil
	end

	--Damage Gained From Misery
	if MiseryActive > 0 then
		TotalDPS = TotalDPS * (1 + MiseryActive * EquipEval:TalentRank(3,20) * 0.01)
		ShadowDPS = ShadowDPS * (1 + MiseryActive * EquipEval:TalentRank(3,20) * 0.01)
	end

	--Mana return from Vampiric Touch
	if VampiricTouchActive > 0 then
		totalMP5 = totalMP5 + VampiricTouchActive * 5 * (ShadowDPS * 0.05)
	end

	TotalDPS = TotalDPS + ShadowFiendDPS


	local SpiritTapUptime = 0
	local MobLevel = max(1, (CurrentLevel + EquipEval.db.profile["EnemyLevelDifference"]))
	local MobHealth = 60 * MobLevel + 420 * max(0, (MobLevel - 60))
	SpiritTapUptime = EquipEval:TalentRank(3,1) * 0.2 * (15 - 8) / (MobHealth / (TotalDPS * 0.75))
	SpiritTapUptime = min(1, SpiritTapUptime)
	

	if EquipEval.db.profile["DisplayDPSTotal"] <= -2 then

		if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
			totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
			self:Debug("Damped Total Mana: "..totalMana)
		end

		local FightLength = min((20 * 60), (totalMana / (TotalMPS - totalMP5 / 5)))
		if FightLength < 0 then
			FightLength = 20 * 60
		end
		self:Debug("Fight Length: "..FightLength)

		TotalDPS = TotalDPS * FightLength
	end

	return TotalDPS, SpiritTapUptime, InfoLine

end





---------------------------------------------------------------------------------------
-- Used to calculate Priest Healing given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePriestHealing(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusHealing = EquipEval:GetSpecialBonus("BONUS_HEAL", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTablePriest[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,20) * 0.01) * (1 + TotalModInt / 100)
	local SpiModifier = 1 + EquipEval:TalentRank(1,20) * 0.01
	SpiModifier = SpiModifier * (1 + EquipEval:TalentRank(2,13) * 0.05)
	local ManaModifier = 1 + EquipEval:TalentRank(1,13) * 0.02

	local CastingRegen = EquipEval:TalentRank(1,9) * 0.1

	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemHeal = heal + itemSpi * EquipEval:TalentRank(2,14) * 0.05 + itemSpi * EquipEval:TalentRank(1,15) * 0.05
	local itemDmg = spelldmg + itemSpi * EquipEval:TalentRank(2,14) * 0.05 + itemSpi * EquipEval:TalentRank(1,15) * 0.05
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + SpiritEffect * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + CastingRegen * SpiritEffect * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100

	local baseHeal = EquipEval:CalculatePriestHealingFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, BonusHealing, BonusSpellHaste, 0, 0)
	local newHeal, InfoLine = EquipEval:CalculatePriestHealingFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), SpiritEffect, itemCrit, (itemHeal + BonusHealing), (itemHaste + BonusSpellHaste), itemDmg, shadowdmg)

	return (newHeal - baseHeal), newHeal, InfoLine


end



---------------------------------------------------------------------------------------
-- Used to calculate Priest Healing From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculatePriestHealingFromStats(CurrentLevel, LevelRating, mana, mp5, spiMP5, crit, heal, haste, spelldmg, shadowdmg)
	local InfoLine = "Heals: "

	local CritModifier = 0.5
	local ManaCostModifier = 1
	local HealingModifier = 1 + EquipEval:TalentRank(2,16) * 0.02

	local totalCrit = GetSpellCritChance(2)
	totalCrit = totalCrit + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCrit = max(0, (totalCrit / 100 + crit))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenBase * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + RegenCasting * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	self:Debug("Total MP5: "..totalMP5)

	local totalHeal = GetSpellBonusHealing() + heal + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Healing: "..totalHeal)

	local totalDmg = GetSpellBonusDamage(6) + spelldmg + shadowdmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg: "..totalDmg)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local CastTime = 0
	local SpellHPS = 0
	local SpellMPS = 0
	local TotalHPS = 0
	local TotalMPS = 0
	local SpellDuration = 0
	local SpellTimeFraction = 0


	--Time Spent Not Casting
	TimeFraction = TimeFraction - (EquipEval.db.profile["PercentIdleTimeWhileHealing"] / 100)

	--Shadow Fiend
	if CurrentLevel >= 66 and TimeFraction > 0 then
		SpellHPS = 1100
		SpellMPS = 134
		CastTime = 0
		SpellDuration = 300
	
		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime)
	
		--Damage modeling does not include melee attack rules currently
		SpellHPS = (SpellHPS + totalDmg * 0.65) / CastTime
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02) * SpellMPS / CastTime
	

		SpellTimeFraction = min((CastTime / SpellDuration), TimeFraction)

		totalMP5 = totalMP5 + 5 * (SpellHPS * 2.5 * SpellTimeFraction)
		TotalMPS = TotalMPS + SpellMPS * SpellTimeFraction
		TimeFraction = TimeFraction - SpellTimeFraction
	end

	if TimeFraction == 0 then
		return 0
	end

	--Renew
	local RenewRankName = ""
	local RenewHealing = 0
	local RenewMana = 0
	local RenewCastTime = 0
	local RenewDuration = 0
	local RenewRating = 0
	local RenewMaxTimeFraction = 0
	if CurrentLevel >= 8 and TimeFraction > 0 then
		local RenewCritChance = 0
		local RenewManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02)
		local RenewHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(2,2) * 0.05)
		local RenewCastTimeModifier = 0
		local RenewCoefficientModifier = 0
		local RenewOverTimeCoefficientModifier = 0
		
		RenewRankName, RenewHealing, RenewMana, RenewCastTime, RenewDuration, _, _, RenewRating = EquipEval:ChooseHeal(EquipEval_SpellTableRenew, CurrentLevel, RenewManaCostModifier, RenewHealingModifier, RenewCastTimeModifier, RenewCoefficientModifier, RenewOverTimeCoefficientModifier, totalHeal, RenewCritChance, CritModifier, totalHaste, 0, 0)
		RenewMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * RenewCastTime / RenewDuration
		RenewRankName = "Renew "..RenewRankName
	end


	--Lightwell
	local LightwellRankName = ""
	local LightwellHealing = 0
	local LightwellMana = 0
	local LightwellCastTime = 0
	local LightwellDuration = 0
	local LightwellCoolDown = 0
	local LightwellRating = 0
	local LightwellMaxTimeFraction = 0
	if EquipEval:TalentRank(2,18) == 1 and TimeFraction > 0 then
		local LightwellCritChance = 0
		local LightwellManaCostModifier = ManaCostModifier
		local LightwellHealingModifier = 1
		local LightwellCastTimeModifier = 0
		local LightwellCoefficientModifier = 0
		local LightwellOverTimeCoefficientModifier = 0
		
		LightwellRankName, LightwellHealing, LightwellMana, LightwellCastTime, LightwellDuration, LightwellCoolDown, _, LightwellRating = EquipEval:ChooseHeal(EquipEval_SpellTableLightwell, CurrentLevel, LightwellManaCostModifier, LightwellHealingModifier, LightwellCastTimeModifier, LightwellCoefficientModifier, LightwellOverTimeCoefficientModifier, totalHeal, LightwellCritChance, CritModifier, totalHaste, 0, 0)
		LightwellMaxTimeFraction = LightwellCastTime / LightwellCoolDown
		LightwellRankName = "Lightwell "..LightwellRankName
	end


	--Prayer of Mending
	local PrayerOfMendingRankName = ""
	local PrayerOfMendingHealing = 0
	local PrayerOfMendingMana = 0
	local PrayerOfMendingCastTime = 0
	local PrayerOfMendingDuration = 0
	local PrayerOfMendingCoolDown = 0
	local PrayerOfMendingRating = 0
	local PrayerOfMendingMaxTimeFraction = 0
	if CurrentLevel >= 68 and TimeFraction > 0 then
		local PrayerOfMendingCritChance = 0
		local PrayerOfMendingManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02) * (1 - EquipEval:TalentRank(2,12) * 0.1)
		local PrayerOfMendingHealingModifier = HealingModifier
		local PrayerOfMendingCastTimeModifier = 0
		local PrayerOfMendingCoefficientModifier = 0
		local PrayerOfMendingOverTimeCoefficientModifier = 0
		
		PrayerOfMendingRankName, PrayerOfMendingHealing, PrayerOfMendingMana, PrayerOfMendingCastTime, PrayerOfMendingDuration, PrayerOfMendingCoolDown, _, PrayerOfMendingRating = EquipEval:ChooseHeal(EquipEval_SpellTablePrayerOfMending, CurrentLevel, PrayerOfMendingManaCostModifier, PrayerOfMendingHealingModifier, PrayerOfMendingCastTimeModifier, PrayerOfMendingCoefficientModifier, PrayerOfMendingOverTimeCoefficientModifier, totalHeal, PrayerOfMendingCritChance, CritModifier, totalHaste, 0, 0)
		PrayerOfMendingMaxTimeFraction = PrayerOfMendingCastTime / (PrayerOfMendingCoolDown * min(3, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])))
		PrayerOfMendingRankName = "Prayer of Mending "..PrayerOfMendingRankName
	end


	--Circle of Healing
	local CircleOfHealingRankName = ""
	local CircleOfHealingHealing = 0
	local CircleOfHealingMana = 0
	local CircleOfHealingCastTime = 0
	local CircleOfHealingDuration = 0
	local CircleOfHealingRating = 0
	local CircleOfHealingMaxTimeFraction = 0
	if EquipEval:TalentRank(2,21) == 1 and TimeFraction > 0 then
		local CircleOfHealingCritChance = totalCrit
		local CircleOfHealingManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02)
		local CircleOfHealingHealingModifier = HealingModifier
		local CircleOfHealingCastTimeModifier = 0
		local CircleOfHealingCoefficientModifier = 0
		local CircleOfHealingOverTimeCoefficientModifier = 0
		
		CircleOfHealingRankName, CircleOfHealingHealing, CircleOfHealingMana, CircleOfHealingCastTime, CircleOfHealingDuration, _, _, CircleOfHealingRating = EquipEval:ChooseHeal(EquipEval_SpellTableCircleOfHealing, CurrentLevel, CircleOfHealingManaCostModifier, CircleOfHealingHealingModifier, CircleOfHealingCastTimeModifier, CircleOfHealingCoefficientModifier, CircleOfHealingOverTimeCoefficientModifier, totalHeal, CircleOfHealingCritChance, CritModifier, totalHaste, 0, 0)
		CircleOfHealingMaxTimeFraction = TimeFraction * 0.9
		CircleOfHealingRankName = "Circle of Healing "..CircleOfHealingRankName
	end


	--Prayer of Healing
	local PrayerOfHealingRankName = ""
	local PrayerOfHealingHealing = 0
	local PrayerOfHealingMana = 0
	local PrayerOfHealingCastTime = 0
	local PrayerOfHealingDuration = 0
	local PrayerOfHealingRating = 0
	local PrayerOfHealingMaxTimeFraction = 0
	if CurrentLevel >= 30 and TimeFraction > 0 then
		local PrayerOfHealingCritChance = totalCrit
		local PrayerOfHealingManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,12) * 0.1)
		local PrayerOfHealingHealingModifier = HealingModifier
		local PrayerOfHealingCastTimeModifier = 0
		local PrayerOfHealingCoefficientModifier = 0
		local PrayerOfHealingOverTimeCoefficientModifier = 0
		
		PrayerOfHealingRankName, PrayerOfHealingHealing, PrayerOfHealingMana, PrayerOfHealingCastTime, PrayerOfHealingDuration, _, _, PrayerOfHealingRating = EquipEval:ChooseHeal(EquipEval_SpellTablePrayerOfHealing, CurrentLevel, PrayerOfHealingManaCostModifier, PrayerOfHealingHealingModifier, PrayerOfHealingCastTimeModifier, PrayerOfHealingCoefficientModifier, PrayerOfHealingOverTimeCoefficientModifier, totalHeal, PrayerOfHealingCritChance, CritModifier, totalHaste, 0, 0)
		PrayerOfHealingMaxTimeFraction = TimeFraction * 0.8
		PrayerOfHealingRankName = "Prayer of Healing "..PrayerOfHealingRankName
	end



	--Holy Nova
	local HolyNovaRankName = ""
	local HolyNovaHealing = 0
	local HolyNovaMana = 0
	local HolyNovaCastTime = 0
	local HolyNovaDuration = 0
	local HolyNovaRating = 0
	local HolyNovaMaxTimeFraction = 0
	if EquipEval:TalentRank(2,6) == 1 and TimeFraction > 0 then
		local HolyNovaCritChance = totalCrit
		local HolyNovaManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02)
		local HolyNovaHealingModifier = HealingModifier
		local HolyNovaCastTimeModifier = 0
		local HolyNovaCoefficientModifier = 0
		local HolyNovaOverTimeCoefficientModifier = 0
		
		HolyNovaRankName, HolyNovaHealing, HolyNovaMana, HolyNovaCastTime, HolyNovaDuration, _, _, HolyNovaRating = EquipEval:ChooseHeal(EquipEval_SpellTableHolyNova, CurrentLevel, HolyNovaManaCostModifier, HolyNovaHealingModifier, HolyNovaCastTimeModifier, HolyNovaCoefficientModifier, HolyNovaOverTimeCoefficientModifier, totalHeal, HolyNovaCritChance, CritModifier, totalHaste, 0, 0)
		HolyNovaMaxTimeFraction = TimeFraction * 0.3
		HolyNovaRankName = "Holy Nova "..HolyNovaRankName
	end


	--Binding Heal
	local BindingHealRankName = ""
	local BindingHealHealing = 0
	local BindingHealMana = 0
	local BindingHealCastTime = 0
	local BindingHealDuration = 0
	local BindingHealRating = 0
	local BindingHealMaxTimeFraction = 0
	if CurrentLevel >= 64 and TimeFraction > 0 then
		local BindingHealCritChance = totalCrit
		local BindingHealManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,17) * 0.02)
		local BindingHealHealingModifier = HealingModifier
		local BindingHealCastTimeModifier = 0
		local BindingHealCoefficientModifier = EquipEval:TalentRank(2,20) * 0.02
		local BindingHealOverTimeCoefficientModifier = 0
		
		BindingHealRankName, BindingHealHealing, BindingHealMana, BindingHealCastTime, BindingHealDuration, _, _, BindingHealRating = EquipEval:ChooseHeal(EquipEval_SpellTableBindingHeal, CurrentLevel, BindingHealManaCostModifier, BindingHealHealingModifier, BindingHealCastTimeModifier, BindingHealCoefficientModifier, BindingHealOverTimeCoefficientModifier, totalHeal, BindingHealCritChance, CritModifier, totalHaste, 0, 0)
		BindingHealMaxTimeFraction = TimeFraction * 0.5
		BindingHealRankName = "Binding Heal "..BindingHealRankName
	end



	--Flash Heal
	local FlashHealRankName = ""
	local FlashHealHealing = 0
	local FlashHealMana = 0
	local FlashHealCastTime = 0
	local FlashHealDuration = 0
	local FlashHealRating = 0
	local FlashHealMaxTimeFraction = 0
	if CurrentLevel >= 20 and TimeFraction > 0 then
		local FlashHealCritChance = totalCrit
		local FlashHealManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,17) * 0.02)
		local FlashHealHealingModifier = HealingModifier
		local FlashHealCastTimeModifier = 0
		local FlashHealCoefficientModifier = EquipEval:TalentRank(2,20) * 0.02
		local FlashHealOverTimeCoefficientModifier = 0
		
		FlashHealRankName, FlashHealHealing, FlashHealMana, FlashHealCastTime, FlashHealDuration, _, _, FlashHealRating = EquipEval:ChooseHeal(EquipEval_SpellTableFlashHeal, CurrentLevel, FlashHealManaCostModifier, FlashHealHealingModifier, FlashHealCastTimeModifier, FlashHealCoefficientModifier, FlashHealOverTimeCoefficientModifier, totalHeal, FlashHealCritChance, CritModifier, totalHaste, 0, 0)
		FlashHealMaxTimeFraction = 1
		FlashHealRankName = "Flash Heal "..FlashHealRankName
	end


	--Power Word Shield
	local PowerWordShieldRankName = ""
	local PowerWordShieldHealing = 0
	local PowerWordShieldMana = 0
	local PowerWordShieldCastTime = 0
	local PowerWordShieldDuration = 0
	local PowerWordShieldCoolDown = 0
	local PowerWordShieldRating = 0
	local PowerWordShieldMaxTimeFraction = 0
	if CurrentLevel >= 6 and TimeFraction > 0 then
		local PowerWordShieldCritChance = 0
		local PowerWordShieldManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,11) * 0.02)
		local PowerWordShieldHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(1,5) * 0.05)
		local PowerWordShieldCastTimeModifier = 0
		local PowerWordShieldCoefficientModifier = 0
		local PowerWordShieldOverTimeCoefficientModifier = 0
		
		PowerWordShieldRankName, PowerWordShieldHealing, PowerWordShieldMana, PowerWordShieldCastTime, PowerWordShieldDuration, PowerWordShieldCoolDown, _, PowerWordShieldRating = EquipEval:ChooseHeal(EquipEval_SpellTablePowerWordShield, CurrentLevel, PowerWordShieldManaCostModifier, PowerWordShieldHealingModifier, PowerWordShieldCastTimeModifier, PowerWordShieldCoefficientModifier, PowerWordShieldOverTimeCoefficientModifier, totalHeal, PowerWordShieldCritChance, CritModifier, totalHaste, 0, 0)
		PowerWordShieldMaxTimeFraction = min((PowerWordShieldCastTime / PowerWordShieldCoolDown), ((1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * PowerWordShieldCastTime / PowerWordShieldDuration))
		PowerWordShieldRankName = "Power Word Shield "..PowerWordShieldRankName
	end

	
	--Greater Heal
	local GreaterHealRankName = ""
	local GreaterHealHealing = 0
	local GreaterHealMana = 0
	local GreaterHealCastTime = 0
	local GreaterHealDuration = 0
	local GreaterHealRating = 0
	local GreaterHealMaxTimeFraction = 0
	if CurrentLevel >= 40 and TimeFraction > 0 then
		local GreaterHealCritChance = totalCrit
		local GreaterHealManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,10) * 0.05) * (1 - EquipEval:TalentRank(2,17) * 0.02)
		local GreaterHealHealingModifier = HealingModifier
		local GreaterHealCastTimeModifier = EquipEval:TalentRank(2,5) * 0.1
		local GreaterHealCoefficientModifier = EquipEval:TalentRank(2,20) * 0.04
		local GreaterHealOverTimeCoefficientModifier = 0
		
		GreaterHealRankName, GreaterHealHealing, GreaterHealMana, GreaterHealCastTime, GreaterHealDuration, _, _, GreaterHealRating = EquipEval:ChooseHeal(EquipEval_SpellTableGreaterHeal, CurrentLevel, GreaterHealManaCostModifier, GreaterHealHealingModifier, GreaterHealCastTimeModifier, GreaterHealCoefficientModifier, GreaterHealOverTimeCoefficientModifier, totalHeal, GreaterHealCritChance, CritModifier, totalHaste, 0, 0)
		GreaterHealMaxTimeFraction = 1
		GreaterHealRankName = "Greater Heal "..GreaterHealRankName
	end
	
	
	--Heal
	local HealRankName = ""
	local HealHealing = 0
	local HealMana = 0
	local HealCastTime = 0
	local HealDuration = 0
	local HealRating = 0
	local HealMaxTimeFraction = 0
	if CurrentLevel >= 16 and TimeFraction > 0 then
		local HealCritChance = totalCrit
		local HealManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,10) * 0.05)
		local HealHealingModifier = HealingModifier
		local HealCastTimeModifier = EquipEval:TalentRank(2,5) * 0.1
		local HealCoefficientModifier = 0
		local HealOverTimeCoefficientModifier = 0
		
		HealRankName, HealHealing, HealMana, HealCastTime, HealDuration, _, _, HealRating = EquipEval:ChooseHeal(EquipEval_SpellTableHeal, CurrentLevel, HealManaCostModifier, HealHealingModifier, HealCastTimeModifier, HealCoefficientModifier, HealOverTimeCoefficientModifier, totalHeal, HealCritChance, CritModifier, totalHaste, 0, 0)
		HealMaxTimeFraction = 1
		HealRankName = "Heal "..HealRankName
	end
	

	--Lesser Heal
	local LesserHealRankName = ""
	local LesserHealHealing = 0
	local LesserHealMana = 0
	local LesserHealCastTime = 0
	local LesserHealDuration = 0
	local LesserHealRating = 0
	local LesserHealMaxTimeFraction = 0
	if CurrentLevel >= 1 and TimeFraction > 0 then
		local LesserHealCritChance = totalCrit
		local LesserHealManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(2,10) * 0.05)
		local LesserHealHealingModifier = HealingModifier
		local LesserHealCastTimeModifier = 0
		local LesserHealCoefficientModifier = 0
		local LesserHealOverTimeCoefficientModifier = 0
		
		LesserHealRankName, LesserHealHealing, LesserHealMana, LesserHealCastTime, LesserHealDuration, _, _, LesserHealRating = EquipEval:ChooseHeal(EquipEval_SpellTableLesserHeal, CurrentLevel, LesserHealManaCostModifier, LesserHealHealingModifier, LesserHealCastTimeModifier, LesserHealCoefficientModifier, LesserHealOverTimeCoefficientModifier, totalHeal, LesserHealCritChance, CritModifier, totalHaste, 0, 0)
		LesserHealMaxTimeFraction = 1
		LesserHealRankName = "Lesser Heal "..LesserHealRankName
	end
	
	--Choose Spell From the * Heal Line
	if max(GreaterHealRating, HealRating, LesserHealRating) == GreaterHealRating then
		HealRankName = GreaterHealRankName
		HealHealing = GreaterHealHealing
		HealMana = GreaterHealMana
		HealCastTime = GreaterHealCastTime
		HealRating = GreaterHealRating
		HealMaxTimeFraction = GreaterHealMaxTimeFraction
	elseif max(GreaterHealRating, HealRating, LesserHealRating) == LesserHealRating then
		HealRankName = LesserHealRankName
		HealHealing = LesserHealHealing
		HealMana = LesserHealMana
		HealCastTime = LesserHealCastTime
		HealRating = LesserHealRating
		HealMaxTimeFraction = LesserHealMaxTimeFraction
	end
	
	
		
	while TimeFraction > 0 do
		local MaxRating = max(RenewRating, LightwellRating, PrayerOfMendingRating, CircleOfHealingRating, PrayerOfHealingRating, HolyNovaRating, BindingHealRating, FlashHealRating, PowerWordShieldRating, HealRating)
		local RatingTotal = RenewRating + LightwellRating + PrayerOfMendingRating + CircleOfHealingRating + PrayerOfHealingRating + HolyNovaRating + BindingHealRating + FlashHealRating + PowerWordShieldRating + HealRating
		RatingTotal = max(MaxRating, (RatingTotal - MaxRating))
		local MaxTimeFraction = 0

		if MaxRating <= 0 then
			break
		end
		
		if MaxRating == LightwellRating then
			MaxTimeFraction = LightwellMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			LightwellRating = 0
			
			TotalHPS = TotalHPS + LightwellHealing / LightwellCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + LightwellMana / LightwellCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..LightwellRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."LW, "
		elseif MaxRating == PrayerOfMendingRating then
			MaxTimeFraction = PrayerOfMendingMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			PrayerOfMendingRating = 0
			
			TotalHPS = TotalHPS + PrayerOfMendingHealing / PrayerOfMendingCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + PrayerOfMendingMana / PrayerOfMendingCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..PrayerOfMendingRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."PoM, "
		elseif MaxRating == BindingHealRating then
			MaxTimeFraction = BindingHealMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			BindingHealRating = 0
			
			TotalHPS = TotalHPS + BindingHealHealing / BindingHealCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + BindingHealMana / BindingHealCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..BindingHealRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."BH, "
		elseif MaxRating == RenewRating then
			MaxTimeFraction = RenewMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			RenewRating = 0
			
			TotalHPS = TotalHPS + RenewHealing / RenewCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + RenewMana / RenewCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..RenewRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."Renew, "
		elseif MaxRating == PowerWordShieldRating then
			MaxTimeFraction = PowerWordShieldMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			PowerWordShieldRating = 0
			
			TotalHPS = TotalHPS + PowerWordShieldHealing / PowerWordShieldCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + PowerWordShieldMana / PowerWordShieldCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..PowerWordShieldRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."PWS, "
		elseif MaxRating == CircleOfHealingRating then
			CircleOfHealingRating = 0
			MaxTimeFraction = CircleOfHealingMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + CircleOfHealingHealing / CircleOfHealingCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + CircleOfHealingMana / CircleOfHealingCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..CircleOfHealingRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."CoH, "
		elseif MaxRating == PrayerOfHealingRating then
			PrayerOfHealingRating = 0
			MaxTimeFraction = PrayerOfHealingMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + PrayerOfHealingHealing / PrayerOfHealingCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + PrayerOfHealingMana / PrayerOfHealingCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..PrayerOfHealingRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."PoH, "
		elseif MaxRating == HolyNovaRating then
			HolyNovaRating = 0
			MaxTimeFraction = HolyNovaMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + HolyNovaHealing / HolyNovaCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + HolyNovaMana / HolyNovaCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..HolyNovaRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."HN, "
		elseif MaxRating == FlashHealRating then
			FlashHealRating = 0
			MaxTimeFraction = FlashHealMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + FlashHealHealing / FlashHealCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + FlashHealMana / FlashHealCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..FlashHealRankName.." "..(MaxTimeFraction * 100).."%")
			InfoLine = InfoLine.."FH, "
		elseif MaxRating == HealRating then
			HealRating = 0
			MaxTimeFraction = HealMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + HealHealing / HealCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + HealMana / HealCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..HealRankName.." "..(MaxTimeFraction * 100).."%")
			if string.sub(HealRankName, 1, 2) == "Gr" then
				InfoLine = InfoLine.."GH, "
			elseif string.sub(HealRankName, 1, 2) == "Le" then
				InfoLine = InfoLine.."LH, " 
			else
				InfoLine = InfoLine.."Heal, " 
			end
		else
			break
		end
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenHealsDisplayed"] then
		InfoLine = nil
	end
	
	if TimeFraction > 0 then
		self:Debug("Warning: Remaining Time Fraction = "..(TimeFraction * 100).."%")
	end
	

	if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
		totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
		self:Debug("Damped Total Mana: "..totalMana)
	end

	local FightLength =  (totalMana / (TotalMPS - totalMP5 / 5))
	if EquipEval.db.profile["AutoSetHealingFightTotalMPS"] and EquipEval.db.profile["AutoSetHealingVars"] then
		FightLength = (FightLength + totalMana / -EquipEval.db.profile["AutoSetHealingFightTotalMPS"]) / 2
	end

	FightLength = min((20 * 60), FightLength)
	if FightLength < 0 then
		FightLength = 20 * 60
	end
	self:Debug("Fight Length: "..FightLength)

	self:Debug("Total HPS: "..TotalHPS)
	self:Debug("Total MPS: "..TotalMPS)
	
	if EquipEval.db.profile["HealingDurationDisplayed"] then
		InfoLine = EquipEval:AddStringToTable("Healing Duration: "..format("%.2f", (FightLength / 60)).." min.", InfoLine)
	end
	
	if EquipEval.db.profile["DisplayHealingTotal"] < -1 then
		TotalHPS = TotalHPS * FightLength
	end

	return TotalHPS, InfoLine
end




---------------------------------------------------------------------------------------
-- Used to calculate Priest Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePriestMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)

	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local CritReactiveTalents = min(1, EquipEval:TalentRank(1,6)) + min(1, EquipEval:TalentRank(1,18)) + min(1, EquipEval:TalentRank(2,19)) + min(1, EquipEval:TalentRank(2,7))
	local CritReactivePPS = 0
	local HitsPerSecond = self.db.profile["EnemyHitsPerSecond"] * (1 + self.db.profile["NumberOfAdditionalTargets"])
	local BlessedRecoveryEffect = 1
	local BlessedResilienceEffect = 0
	local FocusedWillEffect = 1
	local TotalResiliencePercent = 0
	
	local mitTotal = 0
	local hitBase = (1 - (0.05 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = ((self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference()))
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1 + EquipEval:TalentRank(1,21) * 0.01
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	
	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	TotalResiliencePercent = TotalResiliencePercent + resiliencePercent
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..blockChance)

	local ShadowFormActive = GetShapeshiftForm(true)
	ShadowFormActive = (ShadowFormActive or 0) * EquipEval:TalentRank(3,18)
	local stanceModifier = 1 - ShadowFormActive * 0.15
	
	
	--Handle crit reactive effects
	CritReactivePPS = (critChance * HitsPerSecond + hitChance * HitsPerSecond * max(0, (TotalResiliencePercent / CritReactiveTalents)))
	BlessedResilienceEffect = critChance
	if EquipEval:TalentRank(2,19) > 0 then
		BlessedResilienceEffect = 1 / (CritReactivePPS * EquipEval:TalentRank(2,19) * 0.2)
		BlessedResilienceEffect = (critChance * BlessedResilienceEffect) / (BlessedResilienceEffect + 6)
	end
	CritReactivePPS = (BlessedResilienceEffect * HitsPerSecond + hitChance * HitsPerSecond * max(0, (TotalResiliencePercent / CritReactiveTalents)))
	FocusedWillEffect = stanceModifier
	if EquipEval:TalentRank(1,18) > 0 then
		local FocusedWillChance = (1 - (1 - min(1, CritReactivePPS))^8)
		local FocusedWillBonus = 0.01 + EquipEval:TalentRank(1,18) * 0.01
		FocusedWillEffect = stanceModifier * (1 - FocusedWillBonus * FocusedWillChance - FocusedWillBonus * FocusedWillChance ^ 2 - FocusedWillBonus * FocusedWillChance ^ 3)
	end
	BlessedRecoveryEffect = 1 - EquipEval:TalentRank(2,7) * (25 / 300) * max(0, (TotalResiliencePercent / CritReactiveTalents))
	FocusedWillEffect = FocusedWillEffect * BlessedRecoveryEffect
	BlessedRecoveryEffect = (1 + critBonus) / BlessedRecoveryEffect * (1 - EquipEval:TalentRank(2,7) * (25 / 300)) - 1
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, BlessedResilienceEffect, BlessedRecoveryEffect, crushChance, armorPercent, FocusedWillEffect, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)	
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")


	--Factor in stats	
	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	TotalResiliencePercent = TotalResiliencePercent + resiliencePercent
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 currently
	dodgeChance = dodgeChance + (agi / 25.0) / 100
	self:Debug("Dodge %: "..dodgeChance)

	if parryChance > 0 then
		parryChance = parryChance + defensePercent
		parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	end
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)


	--Handle crit reactive effects
	CritReactivePPS = (critChance * HitsPerSecond + hitChance * HitsPerSecond * max(0, (TotalResiliencePercent / CritReactiveTalents)))
	BlessedResilienceEffect = critChance
	if EquipEval:TalentRank(2,19) > 0 then
		BlessedResilienceEffect = 1 / (CritReactivePPS * EquipEval:TalentRank(2,19) * 0.2)
		BlessedResilienceEffect = (critChance * BlessedResilienceEffect) / (BlessedResilienceEffect + 6)
	end
	CritReactivePPS = (BlessedResilienceEffect * HitsPerSecond + hitChance * HitsPerSecond * max(0, (TotalResiliencePercent / CritReactiveTalents)))
	FocusedWillEffect = stanceModifier
	if EquipEval:TalentRank(1,18) > 0 then
		local FocusedWillChance = (1 - (1 - min(1, CritReactivePPS))^8)
		local FocusedWillBonus = 0.01 + EquipEval:TalentRank(1,18) * 0.01
		FocusedWillEffect = stanceModifier * (1 - FocusedWillBonus * FocusedWillChance - FocusedWillBonus * FocusedWillChance ^ 2 - FocusedWillBonus * FocusedWillChance ^ 3)
	end
	BlessedRecoveryEffect = 1 - EquipEval:TalentRank(2,7) * (25 / 300) * max(0, (TotalResiliencePercent / CritReactiveTalents))
	FocusedWillEffect = FocusedWillEffect * BlessedRecoveryEffect
	BlessedRecoveryEffect = (1 + critBonus) / BlessedRecoveryEffect * (1 - EquipEval:TalentRank(2,7) * (25 / 300)) - 1

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, BlessedResilienceEffect, BlessedRecoveryEffect, crushChance, armorPercent, FocusedWillEffect, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end