

local Bonus = AceLibrary("LibItemBonus-2.0")


local eqevAgilityTablePaladin = {
4.6, 4.83, 4.83, 5.06, 5.06, 5.29, 5.29, 5.52, 5.52, 5.75, 
5.75, 5.98, 6.44, 6.44, 6.9, 6.9, 7.13, 7.59, 7.59, 8.05, 
8.28, 8.28, 8.74, 8.97, 9.2, 9.43, 9.66, 9.89, 10.12, 10.58, 
10.81, 10.81, 11.27, 11.49, 11.96, 12.2, 12.2, 12.64, 12.89, 13.33, 
13.57, 13.57, 14.03, 14.27, 14.73, 14.95, 15.17, 15.65, 15.87, 16.34, 
16.56, 16.78, 17.24, 17.48, 17.95, 18.18, 18.38, 18.87, 19.08, 19.53, 
20.37, 20.7, 21.19, 21.93, 22.42, 22.88, 23.53, 24.04, 24.51, 25 }


local eqevIntTablePaladin = {
12.02, 12.61, 12.61, 13.21, 13.21, 13.81, 14.41, 14.41, 15.02, 15.02, 
15.63, 16.23, 16.84, 17.42, 18.62, 18.62, 19.23, 20.41, 20.41, 21.65, 
22.22, 22.83, 23.42, 24.04, 25.25, 25.84, 25.84, 27.03, 27.62, 28.82, 
29.41, 30.03, 30.67, 31.25, 32.47, 33.00, 33.67, 34.84, 35.46, 36.63, 
37.31, 37.88, 39.06, 39.06, 40.32, 40.82, 42.02, 43.29, 43.86, 45.05, 
45.66, 46.30, 47.39, 48.08, 49.26, 49.75, 50.51, 52.36, 52.91, 54.05, 
63.69, 65.36, 67.57, 69.93, 71.43, 73.53, 75.19, 76.34, 78.13, 80 }






--Paladin Spells


local EquipEval_SpellTableFlashofLight = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5),
		CastTime = 1.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 20,
		DirectHealAmount = (62 + 72) / 2,
		ManaCost = 35
	},

	{
		Level = 26,
		DirectHealAmount = (96 + 110) / 2,
		ManaCost = 50
	},

	{
		Level = 34,
		DirectHealAmount = (145 + 163) / 2,
		ManaCost = 70
	},

	{
		Level = 42,
		DirectHealAmount = (197 + 221) / 2,
		ManaCost = 90
	},

	{
		Level = 50,
		DirectHealAmount = (267 + 299) / 2,
		ManaCost = 115
	},

	{
		Level = 58,
		DirectHealAmount = (343 + 383) / 2,
		ManaCost = 140
	},

	{
		Level = 66,
		DirectHealAmount = (458 + 513) / 2,
		ManaCost = 180
	}
}

local EquipEval_SpellTableHolyLight = {
	All = {
		Level = 0,
		Coefficient = (2.5 / 3.5),
		CastTime = 2.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 1,
		DirectHealAmount = (42 + 51) / 2,
		ManaCost = 35
	},

	{
		Level = 6,
		DirectHealAmount = (81 + 96) / 2,
		ManaCost = 60
	},

	{
		Level = 14,
		DirectHealAmount = (167 + 196) / 2,
		ManaCost = 110
	},

	{
		Level = 22,
		DirectHealAmount = (322 + 368) / 2,
		ManaCost = 190
	},

	{
		Level = 30,
		DirectHealAmount = (506 + 569) / 2,
		ManaCost = 275
	},

	{
		Level = 38,
		DirectHealAmount = (717 + 799) / 2,
		ManaCost = 365
	},

	{
		Level = 46,
		DirectHealAmount = (968 + 1076) / 2,
		ManaCost = 465
	},

	{
		Level = 54,
		DirectHealAmount = (1272 + 1414) / 2,
		ManaCost = 580
	},

	{
		Level = 60,
		DirectHealAmount = (1619 + 1799) / 2,
		ManaCost = 660
	},

	{
		Level = 62,
		DirectHealAmount = (1773 + 1971) / 2,
		ManaCost = 710
	},

	{
		Level = 70,
		DirectHealAmount = (2196 + 2446) / 2,
		ManaCost = 840
	},
}








---------------------------------------------------------------------------------------
-- Used to calculate Paladin DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePaladinDPS(infoObj, CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponType)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, spelldmg, holydmg, int, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	local TotalValueCaster, _, spi, mana, mp5, spellcrit, holycrit, _, heal, _, spellhaste, spellhit, _, _, _, _, stam, _, _, _, _, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)
	
	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local MongoosePresent, _, AdditionalMongoose = EquipEval:GetSpecialBonus("MONGOOSE_TOKEN", infoObj)
	local ExecutionerPresent, _, AdditionalExecutioner = EquipEval:GetSpecialBonus("EXECUTIONER_TOKEN", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	local _, WeaponSpeed, WeaponAvgDmg = EquipEval:GetWeaponStats(infoObj)
	if WeaponHands > 0 then
		meleedmg = 0
	end
	
	if (abs(TotalValue) + WeaponAvgDmg + abs(TotalValueCaster) + abs(AdditionalModInt) + abs(AdditionalMongoose) + abs(AdditionalExecutioner)) == 0 then
		return 0, 0
	end


	local AgilityRating = eqevAgilityTablePaladin[CurrentLevel]

	local AgiModifier = 1
	local StrModifier = 1 + .02 * EquipEval:TalentRank(1,1)
	local APModifier = 1

	local ItemAgility = AgiModifier * agi
	local BonusAgility = AgiModifier * MongoosePresent * 120
	
	local ItemAP = APModifier * (ap + 2 * StrModifier * str)
	BonusAttackPower = APModifier * BonusAttackPower
	
	local ItemHit = (hit / 10.0  * LevelRating / 100)
	
	local ItemCrit = ((crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating))
	local BonusCrit = (BonusAgility/AgilityRating)
	
	local ItemHaste = (haste / 10.0 * LevelRating) / 100
	local BonusHaste = MongoosePresent * 0.02

	weapSkill = (weapSkill / 2.5  * LevelRating)
	expertise = (expertise / 2.5  * LevelRating) * 0.0025

	local BonusArmorPen = ExecutionerPresent * 840


	local IntRating = eqevIntTablePaladin[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,2) * 0.02) * (1 + TotalModInt / 100)
	local SpiModifier = 1
	local ManaModifier = 1

	local CastingRegen = 0

	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(spi * SpiModifier, itemInt)
	local itemSpellDmg = spelldmg + itemInt * EquipEval:TalentRank(1,19) * 0.07
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemSpellCrit = ((spellcrit / 14.0 * LevelRating) + (itemInt / IntRating) + holycrit) / 100
	local itemSpellHit = (spellhit / 8.0 * LevelRating) / 100
	local itemSpellHaste = (spellhaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + SpiritEffect * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + CastingRegen * SpiritEffect * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100

	
	local baseDPS = EquipEval:CalculatePaladinDPSFromStats(CurrentLevel, LevelRating, "None", 0, 0, 0, "None", BonusAttackPower, BonusCrit, 0, 0, BonusHaste, 0, 0, 0, BonusSpellDmg, 0, 0, 0, BonusArmorPen, 0, 0)
	local newDPS = EquipEval:CalculatePaladinDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, (ItemAP + BonusAttackPower), (ItemCrit + BonusCrit), ItemHit, meleedmg, (ItemHaste + BonusHaste), critbonus, weapSkill, (itemSpellDmg + BonusSpellDmg), holydmg, itemSpellCrit, itemSpellHit, (ignorearmor + BonusArmorPen), expertise, spellcritbonus)

	return (newDPS - baseDPS), newDPS
end


---------------------------------------------------------------------------------------
-- Used to calculate Paladin DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculatePaladinDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, WeaponType, ap, crit, hit, meleedmg, haste, critbonus, weapSkill, spelldmg, holydmg, spellCrit, spellHit, ignoreArmor, expertise, spellcritbonus)

	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = 1
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local SpellCritModifier = 0.5
	SpellCritModifier = (SpellCritModifier + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	SpellCritModifier = (SpellCritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	SpellCritModifier = (SpellCritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Spell Crit Modifier: "..SpellCritModifier)

	local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentmod = UnitDamage("player");
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	offSpeed = offSpeed or 0
	
	--Calc base weapon stats
	local baseMainSpeed = mainSpeed
	local baseMainAvgDmg = 0 --(lowDmg + hiDmg) / 2 / mainSpeed

	local CurrentWeaponTypeMain = "None"
	local mainEquipLoc = "None"

	--Recalc base weapon stats from items if possible
	local mainHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot"))
	if mainHandLink then
		local mainHandInfo = Bonus:ScanItemLink(mainHandLink)
		if mainHandInfo then
			_, baseMainSpeed, baseMainAvgDmg, lowDmg, hiDmg = EquipEval:GetWeaponStats(mainHandInfo)
			_, _, _, _, _, _, CurrentWeaponTypeMain, _, mainEquipLoc = GetItemInfo(mainHandLink)
		end
	end
	
	--Replace Weapons if necessary
	if EquipEval.db.profile["CompareToCurrentItems"] then
		if WeaponSlotName == "MainHand" then
			baseMainSpeed = WeaponSpeed
			baseMainAvgDmg = WeaponAvgDmg
			CurrentWeaponTypeMain = WeaponType
			if WeaponHands == 2 then
				baseOffSpeed = 0
				offSpeed = 0
				baseOffAvgDmg = 0
			end
		elseif WeaponSlotName == "SecondaryHand" and mainEquipLoc == "INVTYPE_2HWEAPON" then
			baseMainSpeed = 2
			baseMainAvgDmg = 0
			CurrentWeaponTypeMain = "None"
		end
	end
	
	
	local offHandModifier = 0
	local APDamageModifier = 1 * percentmod
	local sealDamageModifier = 1 * percentmod
	local weaponHands = 1

	if string.find(CurrentWeaponTypeMain, "Two-Handed") ~= nil or CurrentWeaponTypeMain == "Polearms" or CurrentWeaponTypeMain == "Staves" then
		weaponHands = 2
	end
		
	if weaponHands == 1 then
		APDamageModifier = APDamageModifier * (1 + .01 * EquipEval:TalentRank(2,17))
		sealDamageModifier = sealDamageModifier * (1 + .01 * EquipEval:TalentRank(2,17))
	elseif weaponHands == 2 then
		APDamageModifier = APDamageModifier * (1 + .02 * EquipEval:TalentRank(3,13))
	end

	baseMainAvgDmg = (baseMainAvgDmg + meleedmg) * APDamageModifier


	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_MAINHAND) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)

	local totalCrit = GetCritChance() - 0.04 * weapSkillDif
	if EquipEval.db.profile['IncludeStrikes'] >= 1 then
		totalCrit = totalCrit + EquipEval:TalentRank(3,18)
	end	
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = max(0, ((totalCrit + crit) / 100 - resilienceEffect))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local totalSpellCrit = GetSpellCritChance(2)
	if EquipEval.db.profile['IncludeStrikes'] >= 1 then
		totalSpellCrit = totalSpellCrit + EquipEval:TalentRank(3,18)
	end	
	totalSpellCrit = totalSpellCrit + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalSpellCrit = max(0, (totalSpellCrit / 100 + spellCrit - resilienceEffect))
	totalSpellCrit = min(1, totalSpellCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Spell Crit: "..totalSpellCrit)

	local CurrentHit = GetCombatRating(CR_HIT_MELEE) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]

	local currentChanceToHit = (EquipEval:MaxHitChance(expertise, weapSkillDif) - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = currentChanceToHit + .01 * EquipEval:TalentRank(2,3)
	currentChanceToHit = min(currentChanceToHit, EquipEval:MaxHitChance(expertise, weapSkillDif))
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	self:Debug("Total Hit: "..totalHit)

	local GlanceChance, GlanceModifier = EquipEval:GetGlancingBlowInfo()

	local totalSpellHit = EquipEval:GetSpellHitChance() + spellHit
	totalSpellHit = totalSpellHit + 0.01 * EquipEval:TalentRank(2,3)
	totalSpellHit = totalSpellHit + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalSpellHit = max(0.01, (1 - (1 - totalSpellHit) / EquipEval.db.profile["BurstFactor"]))
	totalSpellHit = min(0.99, totalSpellHit)
	self:Debug("Total Spell Hit: "..totalSpellHit)

	local totalHaste = haste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100
	mainSpeed = baseMainSpeed / (1 + totalHaste)
	self:Debug("Total Haste: "..totalHaste)

	local CurrentHolyDamage = GetSpellBonusDamage(2)
	self:Debug("Current Holy Damage: "..CurrentHolyDamage)


	local ItemAP = ap + EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	ItemAP = ItemAP + (baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	local effectiveAP = baseAP + ItemAP
	self:Debug("Item AP: "..ItemAP)
	
	local MainAvgDmg = baseMainAvgDmg + APDamageModifier * (effectiveAP / 14) * baseMainSpeed
	local MainDPS = MainAvgDmg / mainSpeed

	if EquipEval.db.profile['IncludeStrikes'] >= 1 then
		if CurrentLevel >= 61 then
			holydmg = holydmg + 190 * 1.15
		elseif CurrentLevel >= 52 then
			holydmg = holydmg + 140 * 1.15
		elseif CurrentLevel >= 42 then
			holydmg = holydmg + 110 * 1.15
		elseif CurrentLevel >= 32 then
			holydmg = holydmg + 80 * 1.15
		elseif CurrentLevel >= 22 then
			holydmg = holydmg + 50 * 1.15
		elseif CurrentLevel >= 12 then
			holydmg = holydmg + 30 * 1.15
		elseif CurrentLevel >= 6 then
			holydmg = holydmg + 15 * 1.15
		end
	end


	local judgesPerSecond = 0
	local crusaderStrikesPerSecond = 0
	local holyShocksPerSecond = 0
	if EquipEval.db.profile['IncludeStrikes'] == 1 then
		crusaderStrikesPerSecond = EquipEval:TalentRank(3,22) / 6
		judgesPerSecond = 1 / (10 - EquipEval:TalentRank(3,3))
		holyShocksPerSecond = EquipEval:TalentRank(1,17) / 15
	end


	--Find Seal
	local sealType = 0
	local sealProcChance = 0
	local SanctityAura = 0
	for buffIndex = 1, 16 do
		local buffTexture = GetPlayerBuffTexture(buffIndex)
		if buffTexture then
			if string.find(buffTexture, "InnerRage") ~= nil then
				sealType = 2
				sealProcChance = totalHit * min(1, (mainSpeed * 7 / 60) * EquipEval.db.profile["BurstFactor"])
				self:Debug("Seal of Command Found")
			elseif string.find(buffTexture, "ThunderBolt") ~= nil then
				sealType = 1
				sealProcChance = totalHit
				self:Debug("Seal of Righteousness Found")
			elseif string.find(buffTexture, "SealOfBlood") ~= nil then
				sealType = 3
				sealProcChance = totalHit
				self:Debug("Seal of Blood Found")
			elseif string.find(buffTexture, "MindVision") ~= nil then
				SanctityAura = 1
				sealDamageModifier = sealDamageModifier * 1.1
				self:Debug("Sanctity Aura Found")
			end
		else
			break	
		end
	end

	local WindfuryProcChance, WindfuryBonusAP = EquipEval:GetWindfuryTotemStats(CurrentLevel)
	WindfuryProcChance = WindfuryProcChance * totalHit
	local WindfuryDPS = WindfuryProcChance * (1 - ArmorEffect) * (MainDPS + WindfuryBonusAP / 14 * totalHit * (1 + totalCrit * CritModifier))


	--Vengeance is modeled here
	local vengeanceModifier = 1
	local vengeanceChance = 0
	local vengeanceBonus = .01 * EquipEval:TalentRank(3,16)
	local hitsPerThirty = floor(30/mainSpeed) * (1 + WindfuryProcChance)


	if sealType == 2 or sealType == 3 then
		hitsPerThirty = hitsPerThirty * (1 + totalHit * sealProcChance)
	end
	if EquipEval.db.profile['IncludeStrikes'] == 1 then
		if sealType == 1 then
			vengeanceChance = (1 - (1 - totalSpellHit * totalSpellCrit) ^ floor(30*judgesPerSecond))
		elseif sealType == 2 or sealType == 3 then
			hitsPerThirty = hitsPerThirty + totalHit * floor(30*judgesPerSecond)
		end
		hitsPerThirty = hitsPerThirty + totalHit * floor(30*crusaderStrikesPerSecond)
		vengeanceChance = (1 - (1 - vengeanceChance) * (1 - totalSpellHit * totalSpellCrit )^(floor(30*holyShocksPerSecond)))
	end

	vengeanceChance =  (1 - (1 - vengeanceChance) * (1 - totalCrit)^(hitsPerThirty))
	vengeanceChance = min(vengeanceChance, 1)
	vengeanceModifier = 1 + vengeanceBonus * vengeanceChance + vengeanceBonus * vengeanceChance ^ 2 + vengeanceBonus * vengeanceChance ^ 3

	APDamageModifier = APDamageModifier * vengeanceModifier
	sealDamageModifier = sealDamageModifier * vengeanceModifier
	MainAvgDmg = MainAvgDmg * vengeanceModifier
	MainDPS = MainDPS * vengeanceModifier

	self:Debug("Vengeance Effect: "..(100 * (vengeanceModifier - 1)).."%")

	
	local MeleeDPSFromSeal = 0
	if sealType == 2 then
		MeleeDPSFromSeal = sealDamageModifier * MainDPS * 0.70 * sealProcChance * totalHit * (1 + totalCrit * CritModifier)
	elseif sealType == 3 then
		MeleeDPSFromSeal = sealDamageModifier * MainDPS * 0.35 * sealProcChance * totalHit * (1 + totalCrit * CritModifier)
	end
	MeleeDPSFromSeal = MeleeDPSFromSeal * (1 + WindfuryProcChance)
	self:Debug("Melee DPS From Seal: "..MeleeDPSFromSeal)

	local DPSFromAP = (1 - ArmorEffect) * (MainDPS * (totalHit + min(totalCrit, max(0, totalHit - GlanceChance)) * CritModifier - (1 - GlanceModifier) * GlanceChance))
	self:Debug("DPS From AP: "..DPSFromAP)

	local sealDPSCoefficient = 0
	local sealHolyDPSCoefficient = 0
	if sealType == 1 then

		sealDamageModifier = sealDamageModifier * (1 + .03 * EquipEval:TalentRank(1,4))

		if weaponHands == 2 then
			sealDPSCoefficient = 0.108
		else
			sealDPSCoefficient = 0.092
		end
		sealDPSCoefficient =  sealDamageModifier * (1 + totalHaste) * totalSpellHit * sealProcChance * sealDPSCoefficient
		sealHolyDPSCoefficient = sealDPSCoefficient
	elseif sealType == 2 then
		sealDPSCoefficient = 0.20 * sealDamageModifier * sealProcChance / mainSpeed * (totalHit * (1 + totalCrit * CritModifier))
		sealHolyDPSCoefficient = sealDPSCoefficient * 0.29 / 0.20
	end
	
	local DPSFromSpellDamage = (sealDPSCoefficient * (spelldmg + CurrentHolyDamage) + sealHolyDPSCoefficient * holydmg)
	DPSFromSpellDamage = DPSFromSpellDamage * (1 + WindfuryProcChance)
	self:Debug("DPS From Spell Damage: "..DPSFromSpellDamage)

	local JudgementDPS = 0
	local judgementDamage = 0
	local judgementCrit = 0.03 * EquipEval:TalentRank(3,21)
	if sealType == 2 then
		judgementCrit = judgementCrit + totalCrit

		if CurrentLevel >= 70 then
			judgementDamage = (228 + 252) / 2
		elseif CurrentLevel >= 60 then
			judgementDamage = (169 + 187) / 2
		elseif CurrentLevel >= 50 then
			judgementDamage = (154 + 168) / 2
		elseif CurrentLevel >= 40 then
			judgementDamage = (124 + 135) / 2
		elseif CurrentLevel >= 30 then
			judgementDamage = (97 + 105) / 2
		elseif CurrentLevel >= 20 then
			judgementDamage = (68 + 73) / 2
		end
		judgementDamage = judgementDamage + 0.43 * (spelldmg + holydmg + CurrentHolyDamage)

		JudgementDPS = sealDamageModifier * judgesPerSecond * judgementDamage * (totalHit * (1 + totalCrit * CritModifier))
	elseif sealType == 3 then
		judgementCrit = judgementCrit + totalCrit

		if CurrentLevel >= 64 then
			judgementDamage = (295 + 325) / 2
		end
		judgementDamage = judgementDamage + 0.43 * (spelldmg + holydmg + CurrentHolyDamage)

		JudgementDPS = sealDamageModifier * judgesPerSecond * judgementDamage * (totalHit * (1 + totalCrit * CritModifier))
	elseif sealType == 1 then
		judgementCrit = judgementCrit + totalSpellCrit

		if CurrentLevel >= 66 then
			judgementDamage = (208 + 228) / 2
		elseif CurrentLevel >= 58 then
			judgementDamage = (162 + 178) / 2
		elseif CurrentLevel >= 50 then
			judgementDamage = (131 + 143) / 2
		elseif CurrentLevel >= 42 then
			judgementDamage = (102 + 112) / 2
		elseif CurrentLevel >= 34 then
			judgementDamage = (78 + 86) / 2
		elseif CurrentLevel >= 26 then
			judgementDamage = (57 + 63) / 2
		elseif CurrentLevel >= 18 then
			judgementDamage = (39 + 43) / 2
		elseif CurrentLevel >= 10 then
			judgementDamage = (25 + 27) / 2
		elseif CurrentLevel >= 1 then
			judgementDamage = (21 + 22) / 2
		end

		judgementDamage = judgementDamage + 0.43 * (spelldmg + holydmg + CurrentHolyDamage)

		JudgementDPS = sealDamageModifier * judgesPerSecond * judgementDamage * (totalSpellHit * (1 + totalSpellCrit * SpellCritModifier))
	end

	local holyShockDPS = 0
	if EquipEval:TalentRank(1,17) == 1 then
		local HolyShockDamage = 0
		if CurrentLevel >= 70 then
			HolyShockDamage = (721 + 779) / 2
		elseif CurrentLevel >= 64 then
			HolyShockDamage = (614 + 664) / 2
		elseif CurrentLevel >= 56 then
			HolyShockDamage = (496 + 536) / 2
		elseif CurrentLevel >= 48 then
			HolyShockDamage = (379 + 409) / 2
		elseif CurrentLevel >= 40 then
			HolyShockDamage = (277 + 299) / 2
		end

		HolyShockDamage = HolyShockDamage + 0.43 * (spelldmg + holydmg + CurrentHolyDamage)
		HolyShockDamage = HolyShockDamage * vengeanceModifier * (1 + (0.1 + EquipEval:TalentRank(3,15) * 0.01) * SanctityAura)
		HolyShockDamage = HolyShockDamage * (totalSpellHit * (1 + totalSpellCrit * SpellCritModifier))

		holyShockDPS = holyShocksPerSecond * HolyShockDamage 
	end

	local crusaderStrikeDPS = (1 - ArmorEffect) * crusaderStrikesPerSecond * (MainAvgDmg * 1.1) * (totalHit * (1 + totalCrit * CritModifier))


	return (WindfuryDPS + MeleeDPSFromSeal + DPSFromAP + DPSFromSpellDamage + JudgementDPS + crusaderStrikeDPS + holyShockDPS)
end






---------------------------------------------------------------------------------------
-- Used to calculate Paladin Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePaladinMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (self.db.profile["EnemyBaseCritPercentage"] / 100 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = (self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference())
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	if EquipEval:TalentRank(3,20) > 0 then
		critBonus = critBonus - (.06 * EquipEval:TalentRank(3,20) + .02)
	end
	critBonus = max(critBonus, 0)


	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..parryChance)

	local stanceModifier = 1
	if EquipEval:TalentRank(1,18) > 0 then
		stanceModifier = stanceModifier * (1 - (EquipEval:TalentRank(1,18) * 0.015 + 0.005))
	end

	stanceModifier = stanceModifier * (1 - 0.02 * EquipEval:TalentRank(2,7))


	
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")



	--Factor in stats
	armor = armor * (1 + EquipEval:TalentRank(2,5) * .02)

	stamMultiplier = stamMultiplier * (1 + EquipEval:TalentRank(2,16) * .03) * (1 + EquipEval:TalentRank(2,21) * .02)

	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 and level 39 currently
	if CurrentLevel >= 40 then 
		dodgeChance = dodgeChance + (agi / 25.0) / 100
	else
		dodgeChance = dodgeChance + (agi / 12.89) / 100
	end
	self:Debug("Dodge %: "..dodgeChance)

	parryChance = parryChance + defensePercent
	parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end




---------------------------------------------------------------------------------------
-- Used to calculate Paladin Healing given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculatePaladinHealing(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str = EquipEval:CalculateCasterStats(infoObj)
	
	--Handle Special Bonuses
	local _, BonusHealing = EquipEval:GetSpecialBonus("BONUS_HEAL", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTablePaladin[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,2) * 0.02) * (1 + TotalModInt / 100)
	local SpiModifier = 1
	local ManaModifier = 1

	local CastingRegen = 0

	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemHeal = heal
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating) + holycrit) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + SpiritEffect * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + CastingRegen * SpiritEffect * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100


	local baseHeal = EquipEval:CalculatePaladinHealingFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, BonusHealing, BonusSpellHaste)
	local newHeal, InfoLine = EquipEval:CalculatePaladinHealingFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemCrit, (itemHeal + BonusHealing), (itemHaste + BonusSpellHaste))

	return (newHeal - baseHeal), newHeal, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Paladin Healing From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculatePaladinHealingFromStats(CurrentLevel, LevelRating, mana, mp5, crit, heal, haste)
	local InfoLine = "Heals: "

	local CritModifier = 0.5
	local ManaCostModifier = 1 - EquipEval:TalentRank(1,20) * 0.5 * 15 / 180
	local HealingModifier = 1 + EquipEval:TalentRank(1,5) * 0.04

	local totalCrit = GetSpellCritChance(2)
	totalCrit = totalCrit + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCrit = max(0, (totalCrit / 100 + crit))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenBase * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + RegenCasting * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	self:Debug("Total MP5: "..totalMP5)

	local totalHeal = GetSpellBonusHealing() + heal + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Healing: "..totalHeal)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local CastTime = 0
	local SpellHPS = 0
	local SpellMPS = 0
	local TotalHPS = 0
	local TotalMPS = 0
	local SpellTimeFraction = 0


	--Time Spent Not Casting
	TimeFraction = TimeFraction - (EquipEval.db.profile["PercentIdleTimeWhileHealing"] / 100)
	if TimeFraction == 0 then
		return 0
	end


	--Flash of Light
	local FoLRankName = ""
	local FoLHealing = 0
	local FoLMana = 0
	local FoLCastTime = 1
	local FoLRating = 0
	if CurrentLevel >= 20 then
		
		local BoLEffect = 0
		if CurrentLevel >= 69 then
			BoLEffect = 185
		elseif CurrentLevel >= 60 then
			BoLEffect = 115
		elseif CurrentLevel >= 50 then
			BoLEffect = 85
		elseif CurrentLevel >= 40 then
			BoLEffect = 60
		end

		FoLRankName, FoLHealing, FoLMana, FoLCastTime, _, _, _, FoLRating = EquipEval:ChooseHeal(EquipEval_SpellTableFlashofLight, CurrentLevel, (ManaCostModifier - 0.60 * EquipEval:TalentRank(1,9) * 0.2 * totalCrit), HealingModifier, 0, 0, 0, totalHeal, totalCrit, CritModifier, totalHaste, BoLEffect, 0)
	end
	


	--Holy Light
	local BoLEffect = 0
	if CurrentLevel >= 69 then
		BoLEffect = 580
	elseif CurrentLevel >= 60 then
		BoLEffect = 400
	elseif CurrentLevel >= 50 then
		BoLEffect = 300
	elseif CurrentLevel >= 40 then
		BoLEffect = 210
	end

	totalCrit = totalCrit + EquipEval:TalentRank(1,3) * 0.02
	totalCrit = totalCrit + (1 - totalCrit) * EquipEval:TalentRank(1,12) / (120 / (CastTime / TimeFraction))
	totalCrit = min(1, totalCrit)

	local HLRankName, HLHealing, HLMana, HLCastTime, _, _, _, HLRating = EquipEval:ChooseHeal(EquipEval_SpellTableHolyLight, CurrentLevel, (ManaCostModifier - 0.60 * EquipEval:TalentRank(1,9) * 0.2 * totalCrit), HealingModifier, (0.5 * EquipEval:TalentRank(1,16) * 0.33), 0, 0, totalHeal, totalCrit, CritModifier, totalHaste, BoLEffect, 0)


	
	local FoLTimeFraction = FoLRating / (FoLRating + HLRating)
	TotalHPS = TotalHPS + FoLHealing / FoLCastTime * FoLTimeFraction * TimeFraction
	TotalMPS = TotalMPS + FoLMana / FoLCastTime * FoLTimeFraction * TimeFraction
	if FoLTimeFraction > 0 then
		self:Debug("Flash of Light "..FoLRankName.." chosen.  HPS: "..(FoLHealing / FoLCastTime).." HPM: "..(FoLHealing / FoLMana).." Time Fraction: "..(FoLTimeFraction * TimeFraction))
		InfoLine = InfoLine.."FoL, "
	end
	
	TimeFraction = TimeFraction - FoLTimeFraction * TimeFraction
	
	TotalHPS = TotalHPS + HLHealing / HLCastTime * TimeFraction
	TotalMPS = TotalMPS + HLMana / HLCastTime * TimeFraction
	if TimeFraction > 0 then
		self:Debug("Holy Light "..HLRankName.." chosen.  HPS: "..(HLHealing / HLCastTime).." HPM: "..(HLHealing / HLMana).." Time Fraction: "..(TimeFraction))
		InfoLine = InfoLine.."HL, "
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenHealsDisplayed"] then
		InfoLine = nil
	end


	if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
		totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
		self:Debug("Damped Total Mana: "..totalMana)
	end

	local FightLength =  (totalMana / (TotalMPS - totalMP5 / 5))
	if EquipEval.db.profile["AutoSetHealingFightTotalMPS"] and EquipEval.db.profile["AutoSetHealingVars"] then
		FightLength = (FightLength + totalMana / -EquipEval.db.profile["AutoSetHealingFightTotalMPS"]) / 2
	end

	FightLength = min((20 * 60), FightLength)
	if FightLength < 0 then
		FightLength = 20 * 60
	end
	self:Debug("Fight Length: "..FightLength)

	self:Debug("Total HPS: "..TotalHPS)
	self:Debug("Total MPS: "..TotalMPS)
	
	if EquipEval.db.profile["HealingDurationDisplayed"] then
		InfoLine = EquipEval:AddStringToTable("Healing Duration: "..format("%.2f", (FightLength / 60)).." min.", InfoLine)
	end
	
	if EquipEval.db.profile["DisplayHealingTotal"] < -1 then
		TotalHPS = TotalHPS * FightLength
	end

	return TotalHPS, InfoLine
end







