

local Bonus = AceLibrary("LibItemBonus-2.0")

local eqevIntTableMage = {
6.11, 6.35, 6.6, 7.09, 7.33, 7.58, 7.82, 8.06, 8.55, 8.8,
9.53, 10.75, 11.48, 13.68, 14.9, 15.65, 16.61, 17.61, 18.59, 19.8,
20.53, 21.74, 22.47, 23.7, 24.69, 25.64, 26.88, 29.59, 30.77, 32.05,
32.79, 34.01, 34.97, 35.97, 37.17, 38.17, 39.37, 40.32, 41.49, 42.55,
43.48, 46.51, 47.39, 48.54, 49.75, 50.76, 52.08, 53.19, 54.35, 55.87,
56.82, 57.8, 58.82, 60.24, 61.73, 64.94, 66.23, 67.11, 68.49, 69.93,
69.93, 69.93, 69.93, 70.42, 70.42, 72.46, 75.19, 76.34, 78.13, 80 }




---------------------------------------------------------------------------------------
-- Used to calculate Mage DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateMageDPS(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str, stam, arcanedmg, spellpen, _, _, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTableMage[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(1,15) * 0.03) * (1 + TotalModInt / 100)
	local SpiModifier = 1
	local ManaModifier = 1

	local CastingRegen = EquipEval:TalentRank(1,12) * 0.1

	--Find Mage Armor
	for buffIndex = 1, 16 do
		local buffTexture = GetPlayerBuffTexture(buffIndex)
		if buffTexture then
			if string.find(buffTexture, "MageArmor") ~= nil then
				self:Debug("Mage Armor Found")
				CastingRegen = CastingRegen + 0.3
				break
			end
		else
			break	
		end
	end

	
	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(spi * SpiModifier, itemInt)
	local itemDmg = spelldmg + itemInt * EquipEval:TalentRank(1,22) * 0.05
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemHit = (hit / 8.0 * LevelRating) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + CastingRegen * SpiritEffect


	local baseDPS = EquipEval:CalculateMageDPSFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, 0)
	local newDPS, InfoLine = EquipEval:CalculateMageDPSFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), SpiritEffect, itemCrit, (BonusSpellDmg + itemDmg), (itemHaste + BonusSpellHaste), itemHit, frostdmg, firedmg, arcanedmg, spellpen, spellcritbonus)

	return (newDPS - baseDPS), newDPS, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Mage DPS From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateMageDPSFromStats(CurrentLevel, LevelRating, mana, mp5, spiMP5, crit, spelldmg, haste, hit, frostdmg, firedmg, arcanedmg, spellpen, spellcritbonus)
	local InfoLine = nil
	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100

	local CritModifierFrost = 0.5 * (1 + EquipEval:TalentRank(1,21) * 0.25) * (1 + EquipEval:TalentRank(3,4) * 0.20)
	CritModifierFrost = (CritModifierFrost + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifierFrost = (CritModifierFrost + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifierFrost = (CritModifierFrost + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier Frost: "..CritModifierFrost)

	local CritModifierFire = 0.5 * (1 + EquipEval:TalentRank(1,21) * 0.25)
	CritModifierFire = (CritModifierFire + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifierFire = (CritModifierFire + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifierFire = (CritModifierFire + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	CritModifierFire = (CritModifierFire + 1) * (1 + EquipEval:TalentRank(2,3) * 0.08 * (1 - resilienceEffect)) - 1
	self:Debug("Crit Modifier Fire: "..CritModifierFire)

	local CritModifierArcane = 0.5 * (1 + EquipEval:TalentRank(1,21) * 0.25)
	CritModifierArcane = (CritModifierArcane + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifierArcane = (CritModifierArcane + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifierArcane = (CritModifierArcane + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier Arcane: "..CritModifierArcane)

	local ManaCostModifierFrost = (1 - EquipEval:TalentRank(1,6) * 0.02) * (1 - EquipEval:TalentRank(3,3) * 0.01) * (1 - EquipEval:TalentRank(3,12) * 0.05)
	self:Debug("Mana Cost Modifier Frost: "..ManaCostModifierFrost)

	local ManaCostModifierFire = (1 - EquipEval:TalentRank(1,6) * 0.02) * (1 - EquipEval:TalentRank(3,3) * 0.01) * (1 - EquipEval:TalentRank(2,18) * 0.01)
	self:Debug("Mana Cost Modifier Fire: "..ManaCostModifierFire)

	local ManaCostModifierArcane = (1 - EquipEval:TalentRank(1,6) * 0.02)
	self:Debug("Mana Cost Modifier Arcane: "..ManaCostModifierArcane)

	local DamageModifierFrost = (1 + EquipEval:TalentRank(3,8) * 0.02) * (1 + EquipEval:TalentRank(3,20) * 0.01) * (1 + EquipEval:TalentRank(1,17) * 0.01) * (1 + EquipEval:TalentRank(2,13) * 0.01) * (1 + EquipEval:TalentRank(2,20) * 0.1 * 0.2)
	self:Debug("Damage Modifier Frost: "..DamageModifierFrost)

	local DamageModifierFire = (1 + EquipEval:TalentRank(1,17) * 0.01) * (1 + EquipEval:TalentRank(2,13) * 0.01) * (1 + EquipEval:TalentRank(2,20) * 0.1 * 0.2) * (1 + EquipEval:TalentRank(2,17) * 0.02)
	self:Debug("Damage Modifier Fire: "..DamageModifierFire)

	local DamageModifierArcane = (1 + EquipEval:TalentRank(1,17) * 0.01) * (1 + EquipEval:TalentRank(2,13) * 0.01) * (1 + EquipEval:TalentRank(2,20) * 0.1 * 0.2)
	self:Debug("Damage Modifier Arcane: "..DamageModifierArcane)

	local totalCritFrost = GetSpellCritChance(5)
	totalCritFrost = totalCritFrost + EquipEval:TalentRank(3,18) * 2 + EquipEval:TalentRank(1,6) * 2 * EquipEval:TalentRank(1,18) * 0.1
	totalCritFrost = totalCritFrost + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritFrost = max(0, (totalCritFrost / 100 + crit - resilienceEffect))
	totalCritFrost = min(1, totalCritFrost * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Frost: "..totalCritFrost)

	local totalCritFrostFrozen = min(1, totalCritFrost + EquipEval:TalentRank(3,13) * 0.1 * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Frost Frozen: "..totalCritFrostFrozen)

	local totalCritFire = GetSpellCritChance(3)
	totalCritFire = totalCritFire + EquipEval:TalentRank(1,6) * 2 * EquipEval:TalentRank(1,18) * 0.1
	totalCritFire = totalCritFire + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritFire = max(0, (totalCritFire / 100 + crit - resilienceEffect))
	totalCritFire = min(1, totalCritFire * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Fire: "..totalCritFire)

	local totalCritFireFrozen = min(1, totalCritFire + EquipEval:TalentRank(3,13) * 0.1 * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Fire Frozen: "..totalCritFireFrozen)

	local totalCritArcane = GetSpellCritChance(7)
	totalCritArcane = totalCritArcane + EquipEval:TalentRank(1,6) * 2 * EquipEval:TalentRank(1,18) * 0.1
	totalCritArcane = totalCritArcane + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritArcane = max(0, (totalCritArcane / 100 + crit - resilienceEffect))
	totalCritArcane = min(1, totalCritArcane * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Arcane: "..totalCritArcane)

	local totalCritArcaneFrozen = min(1, totalCritArcane + EquipEval:TalentRank(3,13) * 0.1 * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Arcane Frozen: "..totalCritArcaneFrozen)

	local totalHitFrost = EquipEval:GetSpellHitChance() + hit
	totalHitFrost = totalHitFrost + EquipEval:TalentRank(3,3) / 100
	totalHitFrost = totalHitFrost + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitFrost = max(0.01, (1 - (1 - totalHitFrost) / EquipEval.db.profile["BurstFactor"]))
	totalHitFrost = min(0.99, totalHitFrost) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit Frost: "..totalHitFrost)

	local totalHitFire = EquipEval:GetSpellHitChance() + hit
	totalHitFire = totalHitFire + EquipEval:TalentRank(3,3) / 100
	totalHitFire = totalHitFire + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitFire = max(0.01, (1 - (1 - totalHitFire) / EquipEval.db.profile["BurstFactor"]))
	totalHitFire = min(0.99, totalHitFire) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit Fire: "..totalHitFire)

	local totalHitArcane = EquipEval:GetSpellHitChance() + hit
	totalHitArcane = totalHitArcane + EquipEval:TalentRank(1,2) * 2 / 100
	totalHitArcane = totalHitArcane + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHitArcane = max(0.01, (1 - (1 - totalHitArcane) / EquipEval.db.profile["BurstFactor"]))
	totalHitArcane = min(0.99, totalHitArcane) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit Arcane: "..totalHitArcane)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenCasting
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	if CurrentLevel >= 20 then
		totalMP5 = totalMP5 + (0.60 * totalMana) / 480
	end
	self:Debug("Total MP5: "..totalMP5)

	local totalDmgFrost = GetSpellBonusDamage(5) + spelldmg + frostdmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Frost: "..totalDmgFrost)

	local totalDmgFire = GetSpellBonusDamage(3) + spelldmg + firedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Fire: "..totalDmgFire)

	local totalDmgArcane = GetSpellBonusDamage(7) + spelldmg + arcanedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Arcane: "..totalDmgArcane)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local SpellDPS = 0
	local SpellMPS = 0
	local TotalDPS = 0
	local TotalMPS = 0
	local CastTime = 0
	local SpellDuration = 0
	local SpellCritChance = 0
	local SpellCritChanceFrozen = 0
	
	local ColdSnapFrequency = EquipEval:TalentRank(3,15) / (8 * 60 * (1 - EquipEval:TalentRank(3,17) * 0.1))

	--Remove Time Fraction For Evocation
	if CurrentLevel >= 20 then
		TimeFraction = TimeFraction - 8 / 480
	end

	--Add Effects of Mana Gems
	SpellMPS = 0
	if CurrentLevel >= 68 then
		SpellMPS = (2340 + 2460) / 2
	elseif CurrentLevel >= 58 then
		SpellMPS = (1000 + 1200) / 2
	elseif CurrentLevel >= 48 then
		SpellMPS = (775 + 925) / 2
	elseif CurrentLevel >= 38 then
		SpellMPS = (550 + 650) / 2
	elseif CurrentLevel >= 28 then
		SpellMPS = (375 + 425) / 2
	end
	totalMP5 = totalMP5 + 5 * SpellMPS / (2 * 60)
	
	--Icy Veins Effect
	local IVUptime = EquipEval:TalentRank(3,9) * 20 / (3 * 60)
	if ColdSnapFrequency > 0 then
		IVUptime = IVUptime + EquipEval:TalentRank(3,9) * 20 * ColdSnapFrequency
	end
	totalHaste = (1 + totalHaste) * (1 + 0.2 * IVUptime) - 1

	local FreezeChance = min(1, (totalHitFrost * (EquipEval:TalentRank(3,5) * 0.05) * EquipEval.db.profile["BurstFactor"])) * (1 - EquipEval.db.profile["EnemyIsRootImmune"])
	local CritManaCostReduction = EquipEval:TalentRank(2,12) * 0.1
	
	
	--Frostbolt
	CastTime = 3 - EquipEval:TalentRank(3,2) * 0.1
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, (totalCritFrost + EquipEval:TalentRank(3,21) * 0.01 * EquipEval.db.profile["BurstFactor"]))
	SpellCritChanceFrozen = min(1, (totalCritFrostFrozen + EquipEval:TalentRank(3,21) * 0.01 * EquipEval.db.profile["BurstFactor"]))
	if CurrentLevel >= 4 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (630 + 680) / 2
			SpellMPS = 345
		elseif CurrentLevel >= 68 then
			SpellDPS = (597 + 643) / 2
			SpellMPS = 330
		elseif CurrentLevel >= 63 then
			SpellDPS = (536 + 578) / 2
			SpellMPS = 300
		elseif CurrentLevel >= 60 then
			SpellDPS = (515 + 555) / 2
			SpellMPS = 290
		elseif CurrentLevel >= 56 then
			SpellDPS = (429 + 463) / 2
			SpellMPS = 260
		elseif CurrentLevel >= 50 then
			SpellDPS = (353 + 383) / 2
			SpellMPS = 225
		elseif CurrentLevel >= 44 then
			SpellDPS = (292 + 316) / 2
			SpellMPS = 195
		elseif CurrentLevel >= 38 then
			SpellDPS = (227 + 247) / 2
			SpellMPS = 160
		elseif CurrentLevel >= 32 then
			SpellDPS = (174 + 190) / 2
			SpellMPS = 130
		elseif CurrentLevel >= 26 then
			SpellDPS = (126 + 138) / 2
			SpellMPS = 100
		elseif CurrentLevel >= 20 then
			SpellDPS = (74 + 82) / 2
			SpellMPS = 65
		elseif CurrentLevel >= 14 then
			SpellDPS = (51 + 57) / 2
			SpellMPS = 50
		elseif CurrentLevel >= 8 then
			SpellDPS = (31 + 35) / 2
			SpellMPS = 35
		elseif CurrentLevel >= 4 then
			SpellDPS = (18 + 20) / 2
			SpellMPS = 25
		end

		SpellDPS = DamageModifierFrost * totalHitFrost * (SpellDPS + ((0.95 * 3/3.5) + 0.02 * EquipEval:TalentRank(3,21)) * totalDmgFrost)
		SpellMPS = ManaCostModifierFrost * SpellMPS

	end
	local FrostboltDmg = SpellDPS * (1 + SpellCritChance * CritModifierFrost)
	local FrostboltDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFrost)
	local FrostboltMana = SpellMPS * (1 - totalHitFrost * SpellCritChance * CritManaCostReduction)
	local FrostboltManaFrozen = SpellMPS * (1 - totalHitFrost * SpellCritChanceFrozen * CritManaCostReduction)
	local FrostboltCastTime = CastTime
	local FrostboltChanceToFreeze = totalHitFrost * FreezeChance



	--Frost Nova
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 25 - EquipEval:TalentRank(3,6) * 2
	if CurrentLevel >= 10 and TimeFraction > 0 then

		if CurrentLevel >= 67 then
			SpellDPS = (99 + 111) / 2
			SpellMPS = 185
		elseif CurrentLevel >= 54 then
			SpellDPS = (71 + 79) / 2
			SpellMPS = 145
		elseif CurrentLevel >= 40 then
			SpellDPS = (52 + 58) / 2
			SpellMPS = 115
		elseif CurrentLevel >= 26 then
			SpellDPS = (33 + 37) / 2
			SpellMPS = 85
		elseif CurrentLevel >= 10 then
			SpellDPS = (19 + 21) / 2
			SpellMPS = 55
		end

		SpellDPS = DamageModifierFrost * totalHitFrost * (SpellDPS + (0.95 * 1.5/3.5/3) * totalDmgFrost)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		SpellMPS = ManaCostModifierFrost * SpellMPS

	end
	local FrostNovaDmg = SpellDPS * (1 + totalCritFrost * CritModifierFrost)
	local FrostNovaMana = SpellMPS * (1 - totalHitFrost * totalCritFrost * CritManaCostReduction)
	local FrostNovaCastTime = CastTime
	local FrostNovaCoolDown = SpellDuration
	local FrostNovaChanceToFreeze = totalHitFrost * (1 - EquipEval.db.profile["EnemyIsRootImmune"])


	--Cone of Cold
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 10 * (1 - EquipEval:TalentRank(3,17) * 0.1)
	SpellCritChance = totalCritFrost
	SpellCritChanceFrozen = totalCritFrostFrozen
	if CurrentLevel >= 26 and TimeFraction > 0 then

		if CurrentLevel >= 65 then
			SpellDPS = (410 + 448) / 2
			SpellMPS = 645
		elseif CurrentLevel >= 58 then
			SpellDPS = (335 + 365) / 2
			SpellMPS = 555
		elseif CurrentLevel >= 50 then
			SpellDPS = (264 + 290) / 2
			SpellMPS = 465
		elseif CurrentLevel >= 42 then
			SpellDPS = (203 + 223) / 2
			SpellMPS = 380
		elseif CurrentLevel >= 34 then
			SpellDPS = (146 + 160) / 2
			SpellMPS = 290
		elseif CurrentLevel >= 26 then
			SpellDPS = (98 + 108) / 2
			SpellMPS = 210
		end

		SpellDPS = DamageModifierFrost * totalHitFrost * (SpellDPS + (0.95 * 1.5/3.5/3) * totalDmgFrost)
		if EquipEval:TalentRank(3,16) > 0 then
			SpellDPS = SpellDPS * (1 + EquipEval:TalentRank(3,16) * 0.1 + 0.05)
		end
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])

		SpellMPS = ManaCostModifierFrost * SpellMPS

	end
	local CoCDmg = SpellDPS * (1 + SpellCritChance * CritModifierFrost)
	local CoCDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFrost)
	local CoCMana = SpellMPS * (1 - totalHitFrost * (1 - (1 - SpellCritChance)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local CoCManaFrozen = SpellMPS * (1 - totalHitFrost * (1 - (1 - SpellCritChanceFrozen)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local CoCCastTime = CastTime
	local CoCCoolDown = SpellDuration
	local CoCChanceToFreeze = (totalHitFrost * FreezeChance) ^ (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])



	--Blizzard
	CastTime = 8
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	if CurrentLevel >= 20 and TimeFraction > 0 then

		if CurrentLevel >= 68 then
			SpellDPS = 1472
			SpellMPS = 1645
		elseif CurrentLevel >= 60 then
			SpellDPS = 1192
			SpellMPS = 1400
		elseif CurrentLevel >= 52 then
			SpellDPS = 936
			SpellMPS = 1160
		elseif CurrentLevel >= 44 then
			SpellDPS = 720
			SpellMPS = 935
		elseif CurrentLevel >= 36 then
			SpellDPS = 520
			SpellMPS = 720
		elseif CurrentLevel >= 28 then
			SpellDPS = 352
			SpellMPS = 520
		elseif CurrentLevel >= 20 then
			SpellDPS = 200
			SpellMPS = 320
		end

		SpellDPS = DamageModifierFrost * totalHitFrost * (SpellDPS + 0.7619 * totalDmgFrost)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])

		SpellMPS = ManaCostModifierFrost * SpellMPS

	end
	local BlizzardDmg = SpellDPS
	local BlizzardMana = SpellMPS * (1 - totalHitFrost * totalCritFrost * CritManaCostReduction)
	local BlizzardCastTime = CastTime
	local BlizzardChanceToFreeze = (totalHitFrost * 2 * FreezeChance * min(1 , EquipEval:TalentRank(3,10))) ^ (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])


	--Ice Lance
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = totalCritFrost
	SpellCritChanceFrozen = totalCritFrostFrozen
	if CurrentLevel >= 66 and TimeFraction > 0 then

		SpellDPS = (161 + 187) / 2
		SpellMPS = 150

		SpellDPS = DamageModifierFrost * totalHitFrost * (SpellDPS + (1.5/3.5/3) * totalDmgFrost)
		SpellMPS = ManaCostModifierFrost * SpellMPS

	end
	local IceLanceDmgFrozen = 3 * SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFrost) * min(2, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]))
	local IceLanceManaFrozen = SpellMPS * (1 - totalHitFrost * SpellCritChanceFrozen * CritManaCostReduction) * min(2, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]))
	local IceLanceCastTime = CastTime * min(2, (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]))


	--Arcane Blast
	CastTime = 2.5
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, (totalCritArcane + EquipEval:TalentRank(1,8) * 0.02 * EquipEval.db.profile["BurstFactor"]))
	SpellCritChanceFrozen = min(1, (totalCritArcaneFrozen + EquipEval:TalentRank(1,8) * 0.02 * EquipEval.db.profile["BurstFactor"]))
	if CurrentLevel >= 64 and TimeFraction > 0 then

		SpellDPS = (648 + 752) / 2
		SpellMPS = 195

		SpellDPS = DamageModifierArcane * totalHitArcane * (SpellDPS + (2.5/3.5) * totalDmgArcane)
		SpellMPS = ManaCostModifierArcane * SpellMPS

	end
	local ArcaneBlastDmg = SpellDPS * (1 + SpellCritChance * CritModifierArcane)
	local ArcaneBlastDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierArcane)
	local ArcaneBlast0Mana = SpellMPS
	local ArcaneBlast0CastTime = CastTime
	local ArcaneBlast1Mana = SpellMPS * 1.75
	local ArcaneBlast1CastTime = max(EquipEval:GetSpellGCD(totalHaste), ((2.5 - 0.333333) / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	local ArcaneBlast2Mana = SpellMPS * 2.5
	local ArcaneBlast2CastTime = max(EquipEval:GetSpellGCD(totalHaste), ((2.5 - 0.333333 * 2) / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	local ArcaneBlast3Mana = SpellMPS * 3.25
	local ArcaneBlast3CastTime = max(EquipEval:GetSpellGCD(totalHaste), ((2.5 - 0.333333 * 3) / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]


	--Arcane Missiles
	CastTime = 5
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = totalCritArcane
	SpellCritChanceFrozen = totalCritArcaneFrozen
	if CurrentLevel >= 8 and TimeFraction > 0 then

		if CurrentLevel >= 69 then
			SpellDPS = 1320
			SpellMPS = 740
		elseif CurrentLevel >= 63 then
			SpellDPS = 1200
			SpellMPS = 685
		elseif CurrentLevel >= 60 then
			SpellDPS = 1150
			SpellMPS = 655
		elseif CurrentLevel >= 56 then
			SpellDPS = 960
			SpellMPS = 595
		elseif CurrentLevel >= 48 then
			SpellDPS = 755
			SpellMPS = 500
		elseif CurrentLevel >= 40 then
			SpellDPS = 575
			SpellMPS = 410
		elseif CurrentLevel >= 32 then
			SpellDPS = 415
			SpellMPS = 320
		elseif CurrentLevel >= 24 then
			SpellDPS = 280
			SpellMPS = 235
		elseif CurrentLevel >= 16 then
			SpellDPS = 144
			SpellMPS = 140
		elseif CurrentLevel >= 8 then
			SpellDPS = 72
			SpellMPS = 85
		end

		SpellDPS = DamageModifierArcane * totalHitArcane * (SpellDPS + (5/3.5 + EquipEval:TalentRank(1,19) * 0.15) * totalDmgArcane)
		SpellMPS = ManaCostModifierArcane * (1 + EquipEval:TalentRank(1,19) * 0.02) * SpellMPS

	end
	local ArcaneMissilesDmg = SpellDPS * (1 + SpellCritChance * CritModifierArcane)
	local ArcaneMissilesDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierArcane)
	local ArcaneMissilesMana = SpellMPS
	local ArcaneMissilesCastTime = CastTime


	--Arcane Explosion
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, (totalCritArcane + EquipEval:TalentRank(1,8) * 0.02 * EquipEval.db.profile["BurstFactor"]))
	SpellCritChanceFrozen = min(1, (totalCritArcaneFrozen + EquipEval:TalentRank(1,8) * 0.02 * EquipEval.db.profile["BurstFactor"]))
	if CurrentLevel >= 14 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (377 + 407) / 2
			SpellMPS = 545
		elseif CurrentLevel >= 62 then
			SpellDPS = (306 + 330) / 2
			SpellMPS = 465
		elseif CurrentLevel >= 54 then
			SpellDPS = (243 + 263) / 2
			SpellMPS = 390
		elseif CurrentLevel >= 46 then
			SpellDPS = (186 + 202) / 2
			SpellMPS = 315
		elseif CurrentLevel >= 38 then
			SpellDPS = (139 + 151) / 2
			SpellMPS = 250
		elseif CurrentLevel >= 30 then
			SpellDPS = (97 + 105) / 2
			SpellMPS = 185
		elseif CurrentLevel >= 22 then
			SpellDPS = (57 + 63) / 2
			SpellMPS = 120
		elseif CurrentLevel >= 14 then
			SpellDPS = (32 + 36) / 2
			SpellMPS = 75
		end

		SpellDPS = DamageModifierArcane * totalHitArcane * (SpellDPS + (1.5/3.5/3) * totalDmgArcane)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		SpellMPS = ManaCostModifierArcane * SpellMPS

	end
	local ArcaneExplosionDmg = SpellDPS * (1 + SpellCritChance * CritModifierArcane)
	local ArcaneExplosionDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierArcane)
	local ArcaneExplosionMana = SpellMPS
	local ArcaneExplosionCastTime = CastTime


	--Fireball
	CastTime = 3.5 - EquipEval:TalentRank(2,1) * 0.1
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = totalCritFire
	SpellCritChanceFrozen = totalCritFireFrozen
	if TimeFraction > 0 then

		if CurrentLevel >= 66 then
			SpellDPS = (633 + 805) / 2
			SpellMPS = 425
		elseif CurrentLevel >= 60 then
			SpellDPS = (596 + 760) / 2
			SpellMPS = 410
		elseif CurrentLevel >= 60 then
			SpellDPS = (561 + 715) / 2
			SpellMPS = 395
		elseif CurrentLevel >= 54 then
			SpellDPS = (475 + 609) / 2
			SpellMPS = 350
		elseif CurrentLevel >= 48 then
			SpellDPS = (392 + 506) / 2
			SpellMPS = 305
		elseif CurrentLevel >= 42 then
			SpellDPS = (318 + 414) / 2
			SpellMPS = 260
		elseif CurrentLevel >= 36 then
			SpellDPS = (255 + 335) / 2
			SpellMPS = 220
		elseif CurrentLevel >= 30 then
			SpellDPS = (199 + 265) / 2
			SpellMPS = 185
		elseif CurrentLevel >= 24 then
			SpellDPS = (139 + 187) / 2
			SpellMPS = 140
		elseif CurrentLevel >= 18 then
			SpellDPS = (84 + 116) / 2
			SpellMPS = 95
		elseif CurrentLevel >= 12 then
			SpellDPS = (53 + 73) / 2
			SpellMPS = 65
		elseif CurrentLevel >= 6 then
			SpellDPS = (31 + 45) / 2
			SpellMPS = 45
		elseif CurrentLevel >= 1 then
			SpellDPS = (14 + 22) / 2
			SpellMPS = 30
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + (1 + 0.03 * EquipEval:TalentRank(2,21)) * totalDmgFire)
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local FireballDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire)
	local FireballDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire)
	local FireballMana = SpellMPS * (1 - totalHitFire * SpellCritChance * CritManaCostReduction)
	local FireballManaFrozen = SpellMPS * (1 - totalHitFire * SpellCritChanceFrozen * CritManaCostReduction)
	local FireballCastTime = CastTime


	--Fireblast
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 8 - EquipEval:TalentRank(2,5) * 0.5
	SpellCritChance = min(1, totalCritFire + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	SpellCritChanceFrozen = min(1, totalCritFireFrozen + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	if CurrentLevel >= 6 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (664 + 786) / 2
			SpellMPS = 465
		elseif CurrentLevel >= 61 then
			SpellDPS = (539 + 637) / 2
			SpellMPS = 400
		elseif CurrentLevel >= 54 then
			SpellDPS = (431 + 509) / 2
			SpellMPS = 340
		elseif CurrentLevel >= 46 then
			SpellDPS = (332 + 394) / 2
			SpellMPS = 280
		elseif CurrentLevel >= 38 then
			SpellDPS = (242 + 290) / 2
			SpellMPS = 220
		elseif CurrentLevel >= 30 then
			SpellDPS = (168 + 202) / 2
			SpellMPS = 165
		elseif CurrentLevel >= 22 then
			SpellDPS = (103 + 127) / 2
			SpellMPS = 115
		elseif CurrentLevel >= 14 then
			SpellDPS = (57 + 71) / 2
			SpellMPS = 75
		elseif CurrentLevel >= 6 then
			SpellDPS = (24 + 32) / 2
			SpellMPS = 40
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + (1.5/3.5) * totalDmgFire)
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local FireblastDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire)
	local FireblastDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire)
	local FireblastMana = SpellMPS * (1 - totalHitFire * SpellCritChance * CritManaCostReduction)
	local FireblastManaFrozen = SpellMPS * (1 - totalHitFire * SpellCritChanceFrozen * CritManaCostReduction)
	local FireblastCastTime = CastTime
	local FireblastCoolDown = SpellDuration


	--Scorch
	CastTime = 1.5
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, totalCritFire + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	SpellCritChanceFrozen = min(1, totalCritFireFrozen + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	if CurrentLevel >= 22 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (305 + 361) / 2
			SpellMPS = 180
		elseif CurrentLevel >= 65 then
			SpellDPS = (269 + 317) / 2
			SpellMPS = 165
		elseif CurrentLevel >= 58 then
			SpellDPS = (233 + 275) / 2
			SpellMPS = 150
		elseif CurrentLevel >= 52 then
			SpellDPS = (200 + 239) / 2
			SpellMPS = 135
		elseif CurrentLevel >= 46 then
			SpellDPS = (162 + 192) / 2
			SpellMPS = 115
		elseif CurrentLevel >= 40 then
			SpellDPS = (133 + 159) / 2
			SpellMPS = 100
		elseif CurrentLevel >= 34 then
			SpellDPS = (100 + 120) / 2
			SpellMPS = 80
		elseif CurrentLevel >= 28 then
			SpellDPS = (77 + 93) / 2
			SpellMPS = 65
		elseif CurrentLevel >= 22 then
			SpellDPS = (53 + 65) / 2
			SpellMPS = 50
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + (1.5/3.5) * totalDmgFire)
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local ScorchDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire)
	local ScorchDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire)
	local ScorchMana = SpellMPS * (1 - totalHitFire * SpellCritChance * CritManaCostReduction)
	local ScorchManaFrozen = SpellMPS * (1 - totalHitFire * SpellCritChanceFrozen * CritManaCostReduction)
	local ScorchCastTime = CastTime
	local ImprovedScorchEffect = (1 + min(1, EquipEval:TalentRank(2,10)) * 0.15)


	--Blast Wave
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 30
	SpellCritChance = totalCritFire
	SpellCritChanceFrozen = totalCritFireFrozen
	if EquipEval:TalentRank(2,15) > 0 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (616 + 724) / 2
			SpellMPS = 620
		elseif CurrentLevel >= 65 then
			SpellDPS = (533 + 627) / 2
			SpellMPS = 555
		elseif CurrentLevel >= 60 then
			SpellDPS = (462 + 544) / 2
			SpellMPS = 545
		elseif CurrentLevel >= 52 then
			SpellDPS = (365 + 433) / 2
			SpellMPS = 450
		elseif CurrentLevel >= 44 then
			SpellDPS = (277 + 329) / 2
			SpellMPS = 355
		elseif CurrentLevel >= 36 then
			SpellDPS = (201 + 241) / 2
			SpellMPS = 270
		elseif CurrentLevel >= 30 then
			SpellDPS = (160 + 192) / 2
			SpellMPS = 215
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + (1.5/3.5/3 * 0.95) * totalDmgFire)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local BlastWaveDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire)
	local BlastWaveDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire)
	local BlastWaveMana = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChance)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local BlastWaveManaFrozen = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChanceFrozen)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local BlastWaveCastTime = CastTime


	--Dragon's Breath
	CastTime = 0
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 20
	SpellCritChance = totalCritFire
	SpellCritChanceFrozen = totalCritFireFrozen
	if EquipEval:TalentRank(2,22) > 0 and TimeFraction > 0 then

		if CurrentLevel >= 70 then
			SpellDPS = (680 + 790) / 2
			SpellMPS = 700
		elseif CurrentLevel >= 64 then
			SpellDPS = (574 + 666) / 2
			SpellMPS = 660
		elseif CurrentLevel >= 56 then
			SpellDPS = (454 + 526) / 2
			SpellMPS = 575
		elseif CurrentLevel >= 50 then
			SpellDPS = (370 + 430) / 2
			SpellMPS = 475
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + (1.5/3.5/3 * 0.95) * totalDmgFire)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local DragonsBreathDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire)
	local DragonsBreathDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire)
	local DragonsBreathMana = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChance)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local DragonsBreathManaFrozen = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChanceFrozen)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local DragonsBreathCastTime = CastTime


	--Flamestrike
	CastTime = 3
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), (CastTime / (1 + totalHaste))) + EquipEval.db.profile["CastTimePadding"]
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, totalCritFire + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	SpellCritChanceFrozen = min(1, totalCritFireFrozen + EquipEval:TalentRank(2,6) * 0.02 * EquipEval.db.profile["BurstFactor"])
	local FSDoTDamage = 0
	if CurrentLevel >= 16 and TimeFraction > 0 then

		if CurrentLevel >= 64 then
			SpellDPS = (895 + 999) / 2
			FSDoTDamage = 424
			SpellMPS = 1175
		elseif CurrentLevel >= 56 then
			SpellDPS = (715 + 799) / 2
			FSDoTDamage = 340
			SpellMPS = 990
		elseif CurrentLevel >= 48 then
			SpellDPS = (555 + 623) / 2
			FSDoTDamage = 264
			SpellMPS = 815
		elseif CurrentLevel >= 40 then
			SpellDPS = (416 + 468) / 2
			FSDoTDamage = 196
			SpellMPS = 650
		elseif CurrentLevel >= 32 then
			SpellDPS = (294 + 332) / 2
			FSDoTDamage = 140
			SpellMPS = 490
		elseif CurrentLevel >= 24 then
			SpellDPS = (184 + 210) / 2
			FSDoTDamage = 88
			SpellMPS = 330
		elseif CurrentLevel >= 16 then
			SpellDPS = (100 + 116) / 2
			FSDoTDamage = 48
			SpellMPS = 195
		end

		SpellDPS = DamageModifierFire * totalHitFire * (SpellDPS + 0.1761 * totalDmgFire)
		SpellDPS = SpellDPS * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		FSDoTDamage = (FSDoTDamage + 0.1096 * totalDmgFire)
		FSDoTDamage = FSDoTDamage * (1 - resilienceEffect)
		FSDoTDamage = FSDoTDamage * (1 + EquipEval.db.profile["NumberOfAdditionalTargets"])
		SpellMPS = ManaCostModifierFire * SpellMPS

	end
	local FlamestrikeDmg = SpellDPS * (1 + SpellCritChance * CritModifierFire) + FSDoTDamage
	local FlamestrikeDmgFrozen = SpellDPS * (1 + SpellCritChanceFrozen * CritModifierFire) + FSDoTDamage
	local FlamestrikeMana = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChance)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local FlamestrikeManaFrozen = SpellMPS * (1 - totalHitFire * (1 - (1 - SpellCritChanceFrozen)^(1 + EquipEval.db.profile["NumberOfAdditionalTargets"])) * CritManaCostReduction)
	local FlamestrikeCastTime = CastTime



	--Build Combos
	local OpenerDmg = 0
	local OpenerMana = 0
	local OpenerTime = 1
	local OpenerRating = 0
	local OpenerName = ""

	--Frostbolt
	local CurOpenerDmg = FrostboltDmgFrozen
	local CurOpenerMana = FrostboltManaFrozen
	local CurOpenerTime = FrostboltCastTime
	local CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "Frostbolt"
	end

	--Fireball
	CurOpenerDmg = FireballDmgFrozen
	CurOpenerMana = FireballManaFrozen
	CurOpenerTime = FireballCastTime
	CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "Fireball"
	end

	--Fireball boosted by Imp Scorch
	CurOpenerDmg = FireballDmgFrozen * ImprovedScorchEffect
	CurOpenerMana = FireballManaFrozen
	CurOpenerTime = FireballCastTime
	CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "Fireball"
	end

	--Arcane Blast
	CurOpenerDmg = ArcaneBlastDmgFrozen
	CurOpenerMana = ArcaneBlast0Mana
	CurOpenerTime = ArcaneBlast0CastTime
	CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "AB"
	end

	--Flamestrike
	CurOpenerDmg = FlamestrikeDmgFrozen
	CurOpenerMana = FlamestrikeManaFrozen
	CurOpenerTime = FlamestrikeCastTime
	CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "FS"
	end

	--Flamestrike boosted by Imp. Scorch
	CurOpenerDmg = EquipEval.db.profile["NumberOfAdditionalTargets"] * FlamestrikeDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) + FlamestrikeDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * ImprovedScorchEffect
	CurOpenerMana = FlamestrikeManaFrozen
	CurOpenerTime = FlamestrikeCastTime
	CurOpenerRating = EquipEval:GetSpellRating(CurOpenerDmg, CurOpenerMana, CurOpenerTime)
	if CurOpenerRating > OpenerRating then
		OpenerDmg = CurOpenerDmg
		OpenerMana = CurOpenerMana
		OpenerTime = CurOpenerTime
		OpenerRating = CurOpenerRating
		OpenerName = "FS"
	end




	local CloserDmg = 0
	local CloserMana = 0
	local CloserTime = 1
	local CloserRating = 0
	local CloserName = ""

	--Icelance
	local CurCloserDmg = IceLanceDmgFrozen
	local CurCloserMana = IceLanceManaFrozen
	local CurCloserTime = IceLanceCastTime
	local CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "IL"
	end

	--Cone of Cold
	CurCloserDmg = CoCDmgFrozen
	CurCloserMana = CoCManaFrozen
	CurCloserTime = CoCCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "CoC"
	end

	--Fireblast
	CurCloserDmg = FireblastDmgFrozen
	CurCloserMana = FireblastManaFrozen
	CurCloserTime = FireblastCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "FB"
	end

	--Fireblast boosted by Imp Scorch
	CurCloserDmg = FireblastDmgFrozen * ImprovedScorchEffect
	CurCloserMana = FireblastManaFrozen
	CurCloserTime = FireblastCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "FB"
	end

	--Arcane Explosion
	CurCloserDmg = ArcaneExplosionDmgFrozen
	CurCloserMana = ArcaneExplosionMana
	CurCloserTime = ArcaneExplosionCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "AE"
	end

	--Blast Wave
	CurCloserDmg = BlastWaveDmgFrozen
	CurCloserMana = BlastWaveManaFrozen
	CurCloserTime = BlastWaveCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "BW"
	end

	--Blast Wave boosted by Imp Scorch
	CurCloserDmg = EquipEval.db.profile["NumberOfAdditionalTargets"] * BlastWaveDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) + BlastWaveDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * ImprovedScorchEffect
	CurCloserMana = BlastWaveManaFrozen
	CurCloserTime = BlastWaveCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "BW"
	end

	--Dragon's Breath
	CurCloserDmg = DragonsBreathDmgFrozen
	CurCloserMana = DragonsBreathManaFrozen
	CurCloserTime = DragonsBreathCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "DB"
	end

	--Dragon's Breath boosted by Imp Scorch
	CurCloserDmg = EquipEval.db.profile["NumberOfAdditionalTargets"] * DragonsBreathDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) + DragonsBreathDmgFrozen / (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * ImprovedScorchEffect
	CurCloserMana = DragonsBreathManaFrozen
	CurCloserTime = DragonsBreathCastTime
	CurCloserRating = EquipEval:GetSpellRating(CurCloserDmg, CurCloserMana, CurCloserTime)
	if CurCloserRating > CloserRating then
		CloserDmg = CurCloserDmg
		CloserMana = CurCloserMana
		CloserTime = CurCloserTime
		CloserRating = CurCloserRating
		CloserName = "DB"
	end



	local ComboDmg = 0
	local ComboMana = 0
	local ComboTime = 1
	local ComboRating = 0
	local ComboName = ""

	if OpenerDmg == 0 then
		ComboDmg = CloserDmg
		ComboMana = CloserMana
		ComboTime = CloserTime
		ComboRating = CloserRating
		ComboName = CloserName
	elseif CloserDmg == 0 then
		ComboDmg =  OpenerDmg
		ComboMana = OpenerMana
		ComboTime = OpenerTime
		ComboRating = OpenerRating
		ComboName = OpenerName
	else
		ComboDmg =  OpenerDmg + CloserDmg
		ComboMana = OpenerMana + CloserMana
		ComboTime = OpenerTime + CloserTime
		ComboRating = EquipEval:GetSpellRating(ComboDmg, ComboMana, ComboTime)
		ComboName = OpenerName.." & "..CloserName
	end



	


	--Build Staples
	local FBStapleCount = 0
	if FrostboltChanceToFreeze > 0.01 then
		FBStapleCount = (1 / FrostboltChanceToFreeze)
	end
	FBStapleCount = max(1, FBStapleCount)
	local FBStapleDmg = FBStapleCount * FrostboltDmg
	local FBStapleMana = FBStapleCount * FrostboltMana
	local FBStapleTime = FBStapleCount * FrostboltCastTime


	local BlizzardStapleCount = 0
	if BlizzardChanceToFreeze > 0.01 then
		BlizzardStapleCount = (1 / BlizzardChanceToFreeze)
	end
	BlizzardStapleCount = max(1, BlizzardStapleCount)
	local BlizzardStapleDmg = BlizzardStapleCount * BlizzardDmg
	local BlizzardStapleMana = BlizzardStapleCount * BlizzardMana
	local BlizzardStapleTime = BlizzardStapleCount * BlizzardCastTime

	local FBwISStapleCount = 1
	if EquipEval:TalentRank(2,10) > 0 then
		FBwISStapleCount = 1 / (totalHitFire * EquipEval:TalentRank(2,10) * 0.33333333)
	end
	FBwISStapleCount = FBwISStapleCount * ScorchCastTime / (30 - ceil(FBwISStapleCount) * ScorchCastTime)
	local FBwISStapleDmg = FBwISStapleCount * ScorchDmg * ImprovedScorchEffect + (1 - FBwISStapleCount) * FireballDmg * ImprovedScorchEffect
	local FBwISStapleMana = FBwISStapleCount * ScorchMana + (1 - FBwISStapleCount) * FireballMana
	local FBwISStapleTime = FBwISStapleCount * ScorchCastTime + (1 - FBwISStapleCount) * FireballCastTime

	local FrostFBStapleCount = ceil((FireblastCoolDown - FireblastCastTime) / FrostboltCastTime)
	local FrostFBStapleDmg = FrostFBStapleCount * FrostboltDmg + FireblastDmg
	local FrostFBStapleMana = FrostFBStapleCount * FrostboltMana + FireblastMana
	local FrostFBStapleTime = FrostFBStapleCount * FrostboltCastTime + FireblastCastTime

	local FBFBStapleCount = ceil((FireblastCoolDown - FireblastCastTime) / FireballCastTime)
	local FBFBStapleDmg = FBFBStapleCount * FireballDmg + FireblastDmg
	local FBFBStapleMana = FBFBStapleCount * FireballMana + FireblastMana
	local FBFBStapleTime = FBFBStapleCount * FireballCastTime + FireblastCastTime

	local FBFBwISStapleDmg = FBwISStapleCount * ScorchDmg * ImprovedScorchEffect + (1 - FBwISStapleCount) * FBFBStapleDmg * ImprovedScorchEffect
	local FBFBwISStapleMana = FBwISStapleCount * ScorchMana + (1 - FBwISStapleCount) * FBFBStapleMana
	local FBFBwISStapleTime = FBwISStapleCount * ScorchCastTime + (1 - FBwISStapleCount) * FBFBStapleTime

	local AB2StapleDmg = ArcaneBlastDmg * 2
	local AB2StapleMana = ArcaneBlast0Mana + ArcaneBlast1Mana
	local AB2StapleTime = ArcaneBlast2CastTime + ArcaneBlast1CastTime

	local AB3StapleDmg = ArcaneBlastDmg * 3
	local AB3StapleMana = ArcaneBlast0Mana + ArcaneBlast1Mana + ArcaneBlast2Mana
	local AB3StapleTime = ArcaneBlast3CastTime + ArcaneBlast1CastTime + ArcaneBlast2CastTime

	local FSAEStapleDmg = FlamestrikeDmg + ArcaneExplosionDmg * 4
	local FSAEStapleMana = FlamestrikeMana + ArcaneExplosionMana * 4
	local FSAEStapleTime = FlamestrikeCastTime + ArcaneExplosionCastTime * 4

	local FSBlizStapleDmg = FlamestrikeDmg + BlizzardDmg
	local FSBlizStapleMana = FlamestrikeMana + BlizzardMana
	local FSBlizStapleTime = FlamestrikeCastTime + BlizzardCastTime


	--Choose Sequence
	local SequenceDmg = 0
	local SequenceMana = 0
	local SequenceTime = 1
	local SequenceRating = 0
	local SequenceName = ""

	local CurSequenceDmg = 0
	local CurSequenceMana = 0
	local CurSequenceTime = 0
	local CurSequenceRating = 0

	--Frostbolts
	CurSequenceDmg = FBStapleDmg
	CurSequenceMana = FBStapleMana
	CurSequenceTime = FBStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Frostbolt"
	end


	--Frostbolts and Fireblasts
	CurSequenceDmg = FrostFBStapleDmg
	CurSequenceMana = FrostFBStapleMana
	CurSequenceTime = FrostFBStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating and FBStapleCount > 1 then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Frostbolt & Fireblast"
	end
	


	--Frostbolts until Combo
	CurSequenceDmg = FBStapleDmg + ComboDmg
	CurSequenceMana = FBStapleMana + ComboMana
	CurSequenceTime = FBStapleTime + ComboTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating and FBStapleCount > 1 then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Frostbolt until "..ComboName
	end
	
	
	--Blizzard
	CurSequenceDmg = BlizzardStapleDmg
	CurSequenceMana = BlizzardStapleMana
	CurSequenceTime = BlizzardStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Blizzard"
	end

	--Blizzard until Combo
	CurSequenceDmg = BlizzardStapleDmg + ComboDmg
	CurSequenceMana = BlizzardStapleMana + ComboMana
	CurSequenceTime = BlizzardStapleTime + ComboTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating and BlizzardStapleCount > 1 then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Blizzard until "..ComboName
	end


	--Fireballs
	CurSequenceDmg = FireballDmg
	CurSequenceMana = FireballMana
	CurSequenceTime = FireballCastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Fireball"
	end

	--Fireballs and Imp Scorch
	CurSequenceDmg = FBwISStapleDmg
	CurSequenceMana = FBwISStapleMana
	CurSequenceTime = FBwISStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Fireball & Scorch"
	end

	--Fireballs and Fireblasts
	CurSequenceDmg = FBFBStapleDmg
	CurSequenceMana = FBFBStapleMana
	CurSequenceTime = FBFBStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Fireball & Fireblast"
	end

	--Fireballs, Fireblasts, and Imp. Scorch
	CurSequenceDmg = FBFBwISStapleDmg
	CurSequenceMana = FBFBwISStapleMana
	CurSequenceTime = FBFBwISStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Fireball, Fireblast & Scorch"
	end

	--Arcane Missiles
	CurSequenceDmg = ArcaneMissilesDmg
	CurSequenceMana = ArcaneMissilesMana
	CurSequenceTime = ArcaneMissilesCastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Arcane Missiles"
	end

	--Arcane Explosion
	CurSequenceDmg = ArcaneExplosionDmg
	CurSequenceMana = ArcaneExplosionMana
	CurSequenceTime = ArcaneExplosionCastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Arcane Explosion"
	end

	--Arcane Blast
	CurSequenceDmg = ArcaneBlastDmg
	CurSequenceMana = ArcaneBlast3Mana
	CurSequenceTime = ArcaneBlast3CastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Arcane Blast"
	end

	--Arcane Blast x 2, Arcane Missiles, Scorch
	CurSequenceDmg = AB2StapleDmg + ArcaneMissilesDmg + ScorchDmg * ImprovedScorchEffect
	CurSequenceMana = AB2StapleMana + ArcaneMissilesMana + ScorchMana
	CurSequenceTime = AB2StapleTime + ArcaneMissilesCastTime + ScorchCastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "AB x 2, Arcane Missiles, and Scorch"
	end

	--Arcane Blast x 3, Arcane Missiles, Scorch
	CurSequenceDmg = AB3StapleDmg + ArcaneMissilesDmg + ScorchDmg * ImprovedScorchEffect
	CurSequenceMana = AB3StapleMana + ArcaneMissilesMana + ScorchMana
	CurSequenceTime = AB3StapleTime + ArcaneMissilesCastTime + ScorchCastTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "AB x 3, Arcane Missiles, and Scorch"
	end

	--Arcane Blast x 2, Frostbolt
	CurSequenceDmg = AB2StapleDmg + FrostboltDmg * 3
	CurSequenceMana = AB2StapleMana + FrostboltMana * 3
	CurSequenceTime = AB2StapleTime + FrostboltCastTime * 3
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "AB x 2 & Frostbolt"
	end

	--Arcane Blast x 3, Frostbolt
	CurSequenceDmg = AB3StapleDmg + FrostboltDmg * 3
	CurSequenceMana = AB3StapleMana + FrostboltMana * 3
	CurSequenceTime = AB3StapleTime + FrostboltCastTime * 3
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "AB x 3 & Frostbolt"
	end

	--Flamestrike and Arcane Explosion
	CurSequenceDmg = FSAEStapleDmg
	CurSequenceMana = FSAEStapleMana
	CurSequenceTime = FSAEStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Flamestrike and Arcane Explosion"
	end

	--Flamestrike and Blizzard
	CurSequenceDmg = FSBlizStapleDmg
	CurSequenceMana = FSBlizStapleMana
	CurSequenceTime = FSBlizStapleTime
	CurSequenceRating = EquipEval:GetSpellRating(CurSequenceDmg, CurSequenceMana, CurSequenceTime)
	if CurSequenceRating > SequenceRating then
		SequenceDmg = CurSequenceDmg
		SequenceMana = CurSequenceMana
		SequenceTime = CurSequenceTime
		SequenceRating = CurSequenceRating
		SequenceName = "Flamestrike and Blizzard"
	end

	if EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = "Spells: "..SequenceName
	end

	--Consider code to force an Imp. Scorch Sequence if an Imp. Scorch Combo is picked
	--if string.find(ComboName, "Imp. Scorch") ~= nil then


	--Add Frost Novas
	if EquipEval:GetSpellRating((FrostNovaDmg + FrostNovaChanceToFreeze * ComboDmg), (FrostNovaMana + FrostNovaChanceToFreeze * ComboMana), (FrostNovaCastTime + FrostNovaChanceToFreeze * ComboTime)) > SequenceRating then
		local ComboTimeFraction = (FrostNovaCastTime + FrostNovaChanceToFreeze * ComboTime) / FrostNovaCoolDown
		ComboTimeFraction = min(ComboTimeFraction, TimeFraction)		

		TotalDPS = TotalDPS + ComboTimeFraction * ((FrostNovaDmg + FrostNovaChanceToFreeze * ComboDmg) / (FrostNovaCastTime + FrostNovaChanceToFreeze * ComboTime))
		TotalMPS = TotalMPS + ComboTimeFraction * ((FrostNovaMana + FrostNovaChanceToFreeze * ComboMana) / (FrostNovaCastTime + FrostNovaChanceToFreeze * ComboTime))
		TimeFraction = TimeFraction - ComboTimeFraction

		SequenceName = SequenceName.." with Frost Nova + "..ComboName
	end



	self:Debug("DPS Sequence: "..SequenceName)


	TotalDPS = TotalDPS + (SequenceDmg / SequenceTime) * TimeFraction
	TotalMPS = TotalMPS + (SequenceMana / SequenceTime) * TimeFraction
	TimeFraction = 0


	if EquipEval.db.profile["DisplayDPSTotal"] <= -2 then

		if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
			totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
			self:Debug("Damped Total Mana: "..totalMana)
		end

		local FightLength = min((20 * 60), (totalMana / (TotalMPS - totalMP5 / 5)))
		if FightLength < 0 then
			FightLength = 20 * 60
		end
		self:Debug("Fight Length: "..FightLength)

		TotalDPS = TotalDPS * FightLength
	end

	return TotalDPS, InfoLine

end






---------------------------------------------------------------------------------------
-- Used to calculate Mage Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateMageMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)

	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health, int = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (0.05 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = ((self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference()))
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)



	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	local hitChance = hitBase - defensePercent - EquipEval:TalentRank(3,20) * 0.01
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..blockChance)

	local stanceModifier = 1
	stanceModifier = stanceModifier * (1 - EquipEval:TalentRank(1,16) * 0.02)


	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")


	--Factor in stats
	local IntModifier = 1 + EquipEval:TalentRank(1,15) * 0.03
	int = int * IntModifier
	
	armor = armor + 2 * agi + addedArmor + int * EquipEval:TalentRank(1,9)
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)

	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 currently
	dodgeChance = dodgeChance + (agi / 25.0) / 100
	self:Debug("Dodge %: "..dodgeChance)

	if parryChance > 0 then
		parryChance = parryChance + defensePercent
		parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	end
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)


	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end


