
local Bonus = AceLibrary("LibItemBonus-2.0")

local eqevAgilityTableHunter = {
3.52, 3.53, 3.69, 3.95, 4.12, 4.28, 4.44, 4.61, 4.88, 5.04, 
5.41, 5.99, 6.46, 6.94, 7.52, 7.89, 8.38, 8.95, 9.43, 10.02, 
10.4, 10.99, 11.47, 12.06, 12.55, 13.04, 13.62, 14.1, 14.71, 15.29, 
15.7, 16.29, 16.89, 17.39, 17.99, 18.48, 19.08, 19.69, 20.28, 20.79, 
21.28, 21.88, 22.52, 23.09, 23.75, 24.21, 24.88, 25.58, 26.18, 26.81,
27.32, 27.93, 28.57, 29.33, 29.94, 30.49, 31.15, 31.85, 32.57, 33.22, 
33.67, 34.48, 35.21, 35.84, 36.63, 37.04, 37.88, 38.61, 39.37, 40 }




---------------------------------------------------------------------------------------
-- Used to calculate Hunter DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateHunterDPS(infoObj, CurrentLevel, LevelRating, WeaponSlotName, WeaponHands)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, spelldmg, holydmg, int, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local _, WeaponSpeed, WeaponAvgDmg = EquipEval:GetWeaponStats(infoObj)
	if WeaponSlotName == "Ranged" then
		meleedmg = 0
	end
	
	--Handle Special Bonuses
	local _, BaseSpeedBoost, ItemSpeedBoost = EquipEval:GetSpecialBonus("RANGED_SPEED_BONUS", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)
	local SpeedModifier = (1 + ItemSpeedBoost / 100) / (1 + BaseSpeedBoost / 100)
	--Since bag slots were not scanned, this did not work properly, so set to 1
	SpeedModifier = 1
	
	local _, BaseAmmoDPS, AmmoDPS = EquipEval:GetSpecialBonus("RANGEDDPS", infoObj)
	if BaseAmmoDPS == 0 then
		local ammoLink = GetInventoryItemLink("player",GetInventorySlotInfo("AmmoSlot"))
		if ammoLink then
			local ammoInfo = Bonus:ScanItemLink(ammoLink)
			if ammoInfo then
				BaseAmmoDPS = (ammoInfo.bonuses.RANGEDDPS or 0)
				AmmoDPS = AmmoDPS + BaseAmmoDPS
			end
		end
	else
		AmmoDPS = AmmoDPS + BaseAmmoDPS
	end
	TotalValue = TotalValue + abs(AmmoDPS - BaseAmmoDPS) + abs(SpeedModifier - 1)
	
	if (TotalValue + WeaponAvgDmg + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local AgilityRating = eqevAgilityTableHunter[CurrentLevel]

	local AgiModifier = (1 + .03 * EquipEval:TalentRank(3,18)) * (1 + .01 * EquipEval:TalentRank(2,14))
	local IntModifier = (1 + .03 * EquipEval:TalentRank(2,14)) * (1 + TotalModInt / 100)


	local ItemAgility = AgiModifier * agi

	local APModifier = (1 + 0.02 * EquipEval:TalentRank(2,19)) * (1 + 0.02 * EquipEval:TalentRank(3,14))

	local ItemAP = APModifier * (rap + ItemAgility)
	ItemAP = ItemAP + APModifier * .15 * EquipEval:TalentRank(2,16) * (int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100)
	BonusAttackPower = APModifier * BonusAttackPower

	local ItemHit = (hit / 10.0  * LevelRating / 100)

	local ItemCrit = (crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating)

	local ItemHaste = (haste / 10.0 * LevelRating) / 100

	weapSkill = (weapSkill / 2.5  * LevelRating)
	expertise = (expertise / 2.5  * LevelRating) * 0.0025

	local baseDPS = EquipEval:CalculateHunterDPSFromStats(CurrentLevel, LevelRating, "None", 0, 0, 0, BaseAmmoDPS, 1, BonusAttackPower, 0, 0, 0, 0, 0, 0, 0, 0)
	local newDPS = EquipEval:CalculateHunterDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, AmmoDPS, SpeedModifier, (ItemAP + BonusAttackPower), ItemCrit, ItemHit, ItemHaste, critbonus, weapSkill, ItemAgility, ignorearmor, expertise)

	return (newDPS - baseDPS), newDPS
end

---------------------------------------------------------------------------------------
-- Used to calculate Hunter DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateHunterDPSFromStats(CurrentLevel, LevelRating, WeaponSlotName, WeaponHands, WeaponSpeed, WeaponAvgDmg, AmmoDPS, SpeedModifier, ap, crit, hit, haste, critbonus, weapSkill, itemAgi, ignoreArmor, expertise)

	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = (1 + .06 * EquipEval:TalentRank(2,10))
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)



	local speed, lowDmg, hiDmg = UnitRangedDamage("player");
	local baseAvgDmg = 0
	if speed == 0 then
		speed = 1.0
	end
	
	
	local baseSpeed = 1.0
	local rangedLink = GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot"))
	if rangedLink then
		local rangedInfo = Bonus:ScanItemLink(rangedLink)
		if rangedInfo then
			_, baseSpeed, baseAvgDmg, lowDmg, hiDmg = EquipEval:GetWeaponStats(rangedInfo)
			self:Debug("Base Ranged Speed: "..baseSpeed)
		end
	end
	
	local APDamageModifier = (1 + .01 * EquipEval:TalentRank(2,15)) * (1 + .01 * EquipEval:TalentRank(1,3))
	
	
	local currentHaste = (1 + GetCombatRatingBonus(CR_HASTE_RANGED) / 100)
	local totalHaste = (baseSpeed / speed) / currentHaste
	totalHaste = SpeedModifier * totalHaste * (currentHaste + haste)
	speed = baseSpeed / totalHaste
	self:Debug("Total Haste: "..totalHaste)
	
	--Replace Weapon if necessary
	if EquipEval.db.profile["CompareToCurrentItems"] and WeaponSlotName == "Ranged" then
		baseSpeed = WeaponSpeed
		speed = baseSpeed / totalHaste
		baseAvgDmg = WeaponAvgDmg
	end
	
	baseAvgDmg = (baseAvgDmg + AmmoDPS * baseSpeed) * APDamageModifier
	
	

	local estimateShotsPerSecond = 0
	if CurrentLevel < 62 then
		estimateShotsPerSecond = (1 + haste) / speed + 0.25
	else
		estimateShotsPerSecond = 2 * (1 + haste) / speed + 0.25
	end


	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_RANGED) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)

	local totalCrit = GetRangedCritChance() - 0.04 * weapSkillDif
	totalCrit = totalCrit + EquipEval:TalentRank(3,22) * 2 * (1 - (1 - 0.06)^(8 * estimateShotsPerSecond))
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = max(0, ((totalCrit + crit) / 100 - resilienceEffect))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local CurrentHit = GetCombatRating(CR_HIT_RANGED) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]

	local currentChanceToHit = (EquipEval:MaxHitChance(expertise, weapSkillDif, 1) - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = currentChanceToHit + .01 * EquipEval:TalentRank(3,12)
	currentChanceToHit = min(currentChanceToHit, EquipEval:MaxHitChance(weapSkillDif, 1))
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	self:Debug("Total Hit: "..totalHit)

	
	local ItemAP = ap + EquipEval.db.profile["BonusAP"]
	if EquipEval:TalentRank(3,21) > 0 then
		local _, TotalAgi, _, _ = UnitStat("player", 2);
		TotalAgi = TotalAgi + itemAgi
		ItemAP = ItemAP + 0.25 * TotalAgi * (1 - (1 - 0.333333 * EquipEval:TalentRank(3,21) * totalCrit)^(7 * estimateShotsPerSecond))
	end
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	baseAP = baseAP + posAPBuff + negAPBuff
	ItemAP = ItemAP + (baseAP + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	local effectiveAP = baseAP + ItemAP
	self:Debug("Item AP: "..ItemAP)

	local ShotDamageFromAP = (effectiveAP / 14 * 2.8) * APDamageModifier

	local ManaCostModifier = 1 - EquipEval:TalentRank(2,4) * 0.02

	local SpellDPS = 0
	local SpellMPS = 0
	local CastTime = 0
	local SpellDuration = 0


	--Serpent Sting
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	SpellDuration = 15
	
	if CurrentLevel >= 67 then
		SpellDPS = 660
		SpellMPS = 275
	elseif CurrentLevel >= 60 then
		SpellDPS = 555
		SpellMPS = 250
	elseif CurrentLevel >= 58 then
		SpellDPS = 490
		SpellMPS = 230
	elseif CurrentLevel >= 50 then
		SpellDPS = 385
		SpellMPS = 190
	elseif CurrentLevel >= 42 then
		SpellDPS = 290
		SpellMPS = 150
	elseif CurrentLevel >= 34 then
		SpellDPS = 210
		SpellMPS = 115
	elseif CurrentLevel >= 24 then
		SpellDPS = 140
		SpellMPS = 85
	elseif CurrentLevel >= 18 then
		SpellDPS = 80
		SpellMPS = 50
	elseif CurrentLevel >= 10 then
		SpellDPS = 40
		SpellMPS = 30
	elseif CurrentLevel >= 4 then
		SpellDPS = 20
		SpellMPS = 15
	end
	
	SpellDPS = SpellDPS + 0.1 * effectiveAP
		
	SpellDPS = (1 + .01 * EquipEval:TalentRank(1,3)) * (1 + EquipEval:TalentRank(2,9) * 0.06) * SpellDPS * totalHit
	SpellDPS = SpellDPS * (1 - EquipEval.db.profile["EnemyIsPoisonImmune"])
	SpellMPS = ManaCostModifier * SpellMPS
	
	local SerpentStingDmg = SpellDPS
	local SerpentStingMana = SpellMPS
	local SerpentStingCastTime = CastTime
	local SerpentStingCoolDown = SpellDuration


	ManaCostModifier = ManaCostModifier * (1 - 0.4 * 0.333333 * EquipEval:TalentRank(3,19) * totalCrit)


	--Arcane Shot
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	SpellDuration = 6 - EquipEval:TalentRank(2,6) * 0.2
	
	if CurrentLevel >= 69 then
		SpellDPS = 273
		SpellMPS = 230
	elseif CurrentLevel >= 60 then
		SpellDPS = 200
		SpellMPS = 190
	elseif CurrentLevel >= 52 then
		SpellDPS = 158
		SpellMPS = 160
	elseif CurrentLevel >= 44 then
		SpellDPS = 125
		SpellMPS = 135
	elseif CurrentLevel >= 36 then
		SpellDPS = 91
		SpellMPS = 105
	elseif CurrentLevel >= 28 then
		SpellDPS = 65
		SpellMPS = 80
	elseif CurrentLevel >= 20 then
		SpellDPS = 36
		SpellMPS = 50
	elseif CurrentLevel >= 12 then
		SpellDPS = 23
		SpellMPS = 35
	elseif CurrentLevel >= 6 then
		SpellDPS = 15
		SpellMPS = 25
	end
	
	SpellDPS = APDamageModifier * (SpellDPS + 0.1 * effectiveAP)
	SpellDPS = SpellDPS * (1 + .01 * EquipEval:TalentRank(2,15)) * (1 + .01 * EquipEval:TalentRank(1,3))
		
	SpellDPS = SpellDPS * totalHit * (1 + totalCrit * CritModifier)
	SpellMPS = ManaCostModifier * SpellMPS
	
	local ArcaneShotDmg = SpellDPS
	local ArcaneShotMana = SpellMPS
	local ArcaneShotCastTime = CastTime
	local ArcaneShotCoolDown = SpellDuration


	--Multi Shot
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0.5
	SpellDuration = 10
	
	if CurrentLevel >= 67 then
		SpellDPS = 205
		SpellMPS = 275
	elseif CurrentLevel >= 60 then
		SpellDPS = 150
		SpellMPS = 230
	elseif CurrentLevel >= 54 then
		SpellDPS = 120
		SpellMPS = 210
	elseif CurrentLevel >= 42 then
		SpellDPS = 80
		SpellMPS = 175
	elseif CurrentLevel >= 30 then
		SpellDPS = 40
		SpellMPS = 140
	elseif CurrentLevel >= 18 then
		SpellDPS = 0
		SpellMPS = 100
	end
	
	SpellDPS = APDamageModifier * SpellDPS + ShotDamageFromAP + baseAvgDmg
	SpellDPS = SpellDPS * (1 + .01 * EquipEval:TalentRank(2,15)) * (1 + .01 * EquipEval:TalentRank(1,3))
		
	SpellDPS = (1 + EquipEval:TalentRank(2,13) * 0.04) * SpellDPS * totalHit * (1 + min(1, (totalCrit + EquipEval:TalentRank(2,18) * 0.04)) * CritModifier)
	SpellDPS = (1 - ArmorEffect) * SpellDPS * min(3, (1 + self.db.profile["NumberOfAdditionalTargets"]))
	SpellMPS = ManaCostModifier * SpellMPS
	
	local MultiShotDmg = SpellDPS
	local MultiShotMana = SpellMPS
	local MultiShotCastTime = CastTime
	local MultiShotCoolDown = SpellDuration


	--Steady Shot
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 1,5 / (1 + totalHaste)
	SpellDuration = 0
	
	SpellDPS = baseAvgDmg / baseSpeed * 2.8
	SpellDPS = SpellDPS + APDamageModifier * (150 + 0.2 * effectiveAP)
	SpellMPS = 110
		
	SpellDPS = (1 - ArmorEffect) * (SpellDPS * totalHit * (1 + totalCrit * CritModifier))
	SpellMPS = ManaCostModifier * SpellMPS
	
	local SteadyShotDmg = SpellDPS
	local SteadyShotMana = SpellMPS
	local SteadyShotCastTime = CastTime
	local SteadyShotCoolDown = SpellDuration


	--Auto Shot
	SpellDPS = 0
	SpellMPS = 0
	CastTime = max(0.5, speed)
	SpellDuration = 0

	SpellDPS = APDamageModifier * ItemAP/14.0 * baseSpeed + baseAvgDmg
	SpellMPS = 0
	
	SpellDPS = (1 - ArmorEffect) * (SpellDPS * (totalHit + totalCrit * CritModifier))
	SpellMPS = ManaCostModifier * SpellMPS

	local AutoShotDmg = SpellDPS
	local AutoShotMana = SpellMPS
	local AutoShotCastTime = 0.5
	local AutoShotCoolDown = CastTime - AutoShotCastTime


	--Build Shot Rotation
	local RotationDamage, RotationMana, RotationHitCount, RotationName, RotationTime = EquipEval:FindHunterShotRotation(CurrentLevel, 0, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	local TotalDPS = RotationDamage / RotationTime
	local HitsPerSecond = totalHit * RotationHitCount / RotationTime
	self:Debug("Shot Rotation: "..RotationName)
	self:Debug("Rotation DPS: "..TotalDPS)
	self:Debug("Rotation DPM: "..(RotationDamage / RotationMana))

	--Handle Improved Aspect of the Hawk
	local IAotHChance = (1 - (1 - 0.1 * EquipEval.db.profile["BurstFactor"])^(12 * HitsPerSecond))
	local IAotHEffect = (1 + EquipEval:TalentRank(1,1) * 0.03)
	CastTime = max(0.5, (CastTime / IAotHEffect))
	local AutoShotCastTime = 0.5
	local AutoShotCoolDown = CastTime - AutoShotCastTime

	if IAotHEffect ~= 1 then
		--Build Hasted Shot Rotation
		local HRotationDamage, HRotationMana, HRotationHitCount, HRotationName, HRotationTime = EquipEval:FindHunterShotRotation(CurrentLevel, 0, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
		local TotalDPSHasted = HRotationDamage / HRotationTime
		local HitsPerSecondHasted = totalHit * HRotationHitCount / HRotationTime
		self:Debug("Hasted Shot Rotation: "..HRotationName)
		self:Debug("Hasted Rotation DPS: "..TotalDPSHasted)
		self:Debug("Hasted Rotation DPM: "..(HRotationDamage / HRotationMana))


		IAotHChance = (IAotHChance + (1 - (1 - 0.1 * EquipEval.db.profile["BurstFactor"])^(12 * HitsPerSecondHasted))) / 2

		TotalDPS = (1 - IAotHChance) * TotalDPS + IAotHChance * TotalDPSHasted
		self:Debug("Total DPS: "..TotalDPS)
	end


	return TotalDPS

end

---------------------------------------------------------------------------------------
-- This function finds the best hunter shot rotation
--
-- This is based off of Uncas' guide at http://www.tkasomething.com/castsequence.php
---------------------------------------------------------------------------------------
function EquipEval:FindHunterShotRotation(CurrentLevel, CheckDPM, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)

	local WeaponSpeed = (AutoShotCastTime + AutoShotCoolDown)

	local TotalDamage = 0
	local TotalMana = 1
	local HitCount = 0
	local RotationName = ""
	local RotationTime = 1

	local RotationDamage = 0
	local RotationMana = 0
	local RotationHitCount = 0
	local TempRotationName = ""
	local TempRotationTime = 0

	if EquipEval.db.profile["IncludeStrikes"] == 0 then
		return 	AutoShotDmg, 1, 1, "Auto-Shot", WeaponSpeed
	end


	TempRotationTime = 2 * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((2 * ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end

	TempRotationTime = (floor((2 * ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 0, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((3 * ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((3 * ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 0, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((3 * ArcaneShotCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 0, 0, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor(((MultiShotCoolDown + MultiShotCastTime) / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((SerpentStingCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 1, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	TempRotationTime = (floor((SerpentStingCoolDown / WeaponSpeed) - 0.0000001) + 1) * WeaponSpeed
	RotationDamage, RotationMana, RotationHitCount, TempRotationName, TempRotationTime = EquipEval:BuildHunterShotRotation(CurrentLevel, TempRotationTime, 1, 0, 1, 1, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)
	if ((RotationDamage / TempRotationTime) > (TotalDamage / RotationTime) and CheckDPM == 0) or ((RotationDamage / RotationMana) > (TotalDamage / TotalMana) and CheckDPM == 1) then
		TotalDamage = RotationDamage
		TotalMana = RotationMana
		HitCount = RotationHitCount
		RotationName = TempRotationName
		RotationTime = TempRotationTime
	end


	return 	TotalDamage, TotalMana, HitCount, RotationName, RotationTime
end

---------------------------------------------------------------------------------------
-- This function builds a hunter shot rotation
--
-- This is based off of Uncas' guide at http://www.tkasomething.com/castsequence.php
---------------------------------------------------------------------------------------
function EquipEval:BuildHunterShotRotation(CurrentLevel, RotationTime, UseSerpentSting, UseMultiShot, UseArcaneShot, UseSteadyShot, AutoShotDmg, AutoShotMana, AutoShotCastTime, AutoShotCoolDown, SteadyShotDmg, SteadyShotMana, SteadyShotCastTime, SteadyShotCoolDown, SerpentStingDmg, SerpentStingMana, SerpentStingCastTime, SerpentStingCoolDown, MultiShotDmg, MultiShotMana, MultiShotCastTime, MultiShotCoolDown, ArcaneShotDmg, ArcaneShotMana, ArcaneShotCastTime, ArcaneShotCoolDown)

	--This is the lag buffer
	local TimeBetweenShots = EquipEval.db.profile["CastTimePadding"]

	local GlobalCoolDown = 1.5

	local TimePosition = 0.0
	local TotalDamage = 0
	local TotalMana = 0
	local HitCount = 0
	local RotationName = ""

	local FirstArcaneShotTime = RotationTime + 1
	local FirstMultiShotTime = RotationTime + 1
	local FirstSerpentStingTime = RotationTime + 1

	local NextAutoShotTime = 0.0
	local NextArcaneShotTime = 0.0
	local NextSteadyShotTime = 0.0
	local NextMultiShotTime = 0.0
	local NextSerpentStingTime = 0.0


	if RotationTime < SerpentStingCoolDown or CurrentLevel < 4 then
		UseSerpentSting = 0
	end
	if RotationTime < MultiShotCoolDown or CurrentLevel < 18 then
		UseMultiShot = 0
	end
	if RotationTime < ArcaneShotCoolDown or CurrentLevel < 6 then
		UseArcaneShot = 0
	end
	if CurrentLevel < 62 then
		UseSteadyShot = 0
	end

	while TimePosition < RotationTime do
		if TimePosition >= NextAutoShotTime then
			--Add an auto shot
			RotationName = RotationName.."Auto-Shot "
			TotalDamage = TotalDamage + AutoShotDmg
			TotalMana = TotalMana + AutoShotMana
			HitCount = HitCount + 1

			TimePosition = TimePosition + AutoShotCastTime
			NextAutoShotTime = TimePosition + AutoShotCoolDown

			TimePosition = TimePosition + TimeBetweenShots
			NextSteadyShotTime = TimePosition
		elseif UseSteadyShot >= 1 and TimePosition >= NextSteadyShotTime and (TimePosition + SteadyShotCastTime + TimeBetweenShots) < NextAutoShotTime then
			--Add a steady shot
			RotationName = RotationName.."Steady-Shot "
			TotalDamage = TotalDamage + SteadyShotDmg
			TotalMana = TotalMana + SteadyShotMana
			HitCount = HitCount + 1

			TimePosition = TimePosition + SteadyShotCastTime
			NextSteadyShotTime = max((TimePosition + SteadyShotCoolDown), (TimePosition + TimeBetweenShots))

			TimePosition = TimePosition + TimeBetweenShots
		elseif UseArcaneShot >= 1 and TimePosition >= NextArcaneShotTime and (TimePosition + ArcaneShotCastTime + TimeBetweenShots) < NextAutoShotTime and (TimePosition + ArcaneShotCastTime + ArcaneShotCoolDown - RotationTime) < FirstArcaneShotTime then
			--Add an arcane shot
			if FirstArcaneShotTime == (RotationTime + 1) then
				FirstArcaneShotTime = TimePosition
			end

			RotationName = RotationName.."Arcane-Shot "
			TotalDamage = TotalDamage + ArcaneShotDmg
			TotalMana = TotalMana + ArcaneShotMana
			HitCount = HitCount + 1

			TimePosition = TimePosition + ArcaneShotCastTime
			NextArcaneShotTime = TimePosition + ArcaneShotCoolDown

			NextSteadyShotTime = max(NextSteadyShotTime, (TimePosition + GlobalCoolDown))
			NextMultiShotTime = max(NextMultiShotTime, (TimePosition + GlobalCoolDown))
			NextArcaneShotTime = max(NextArcaneShotTime, (TimePosition + GlobalCoolDown))
			NextSerpentStingTime = max(NextSerpentStingTime, (TimePosition + GlobalCoolDown))

			TimePosition = TimePosition + TimeBetweenShots
		elseif UseMultiShot >= 1 and TimePosition >= NextMultiShotTime and (TimePosition + MultiShotCastTime + TimeBetweenShots) < NextAutoShotTime and (TimePosition + MultiShotCastTime + MultiShotCoolDown - RotationTime) < FirstMultiShotTime then
			--Add a multi shot
			if FirstMultiShotTime == (RotationTime + 1) then
				FirstMultiShotTime = TimePosition
			end

			RotationName = RotationName.."Multi-Shot "
			TotalDamage = TotalDamage + MultiShotDmg
			TotalMana = TotalMana + MultiShotMana
			HitCount = HitCount + 1

			NextSteadyShotTime = max(NextSteadyShotTime, (TimePosition + GlobalCoolDown))
			NextMultiShotTime = max(NextMultiShotTime, (TimePosition + GlobalCoolDown))
			NextArcaneShotTime = max(NextArcaneShotTime, (TimePosition + GlobalCoolDown))
			NextSerpentStingTime = max(NextSerpentStingTime, (TimePosition + GlobalCoolDown))

			TimePosition = TimePosition + MultiShotCastTime
			NextMultiShotTime = TimePosition + MultiShotCoolDown

			TimePosition = TimePosition + TimeBetweenShots
		elseif UseSerpentSting >= 1 and TimePosition >= NextSerpentStingTime and (TimePosition + SerpentStingCastTime + TimeBetweenShots) < NextAutoShotTime and (TimePosition + SerpentStingCastTime + SerpentStingCoolDown - RotationTime) < FirstSerpentStingTime then
			--Add a serpent sting
			if FirstSerpentStingTime == (RotationTime + 1) then
				FirstSerpentStingTime = TimePosition
			end

			RotationName = RotationName.."Serpent-Sting "
			TotalDamage = TotalDamage + SerpentStingDmg
			TotalMana = TotalMana + SerpentStingMana

			TimePosition = TimePosition + SerpentStingCastTime
			NextSerpentStingTime = TimePosition + SerpentStingCoolDown

			NextSteadyShotTime = max(NextSteadyShotTime, (TimePosition + GlobalCoolDown))
			NextMultiShotTime = max(NextMultiShotTime, (TimePosition + GlobalCoolDown))
			NextArcaneShotTime = max(NextArcaneShotTime, (TimePosition + GlobalCoolDown))
			NextSerpentStingTime = max(NextSerpentStingTime, (TimePosition + GlobalCoolDown))

			TimePosition = TimePosition + TimeBetweenShots
		else

			TimePosition = max((TimePosition + TimeBetweenShots), min(NextAutoShotTime, NextArcaneShotTime, NextSteadyShotTime, NextMultiShotTime, NextSerpentStingTime))
		end
	end

	return 	TotalDamage, TotalMana, HitCount, RotationName, TimePosition

end






---------------------------------------------------------------------------------------
-- Used to calculate Hunter Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateHunterMit(infoObj, CurrentLevel, LevelRating, LevelRatingDS)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end

	local mitTotal = 0
	local hitBase = (1 - (self.db.profile["EnemyBaseCritPercentage"] / 100 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = (self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference())
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	local healthMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end

	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	self:Debug("Base Resilience %: "..resiliencePercent)

	local critChance = critBase - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)
	local blockChance = GetBlockChance() / 100
	self:Debug("Base Block %: "..parryChance)

	local stanceModifier = 1 - EquipEval:TalentRank(3,14) * 0.02

	
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")



	--Factor in stats
	local AgilityModifier = (1 + EquipEval:TalentRank(2,14) * 0.01) * (1 + EquipEval:TalentRank(3,18) * 0.03)
	healthMultiplier = healthMultiplier * (1 + EquipEval:TalentRank(1,2) * 0.01) * (1 + EquipEval:TalentRank(3,9) * 0.01)
	armor = armor * (1 + EquipEval:TalentRank(1,5) * 0.02)
	agi = agi * AgilityModifier

	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + (stamMultiplier * stam * 10 + health) * healthMultiplier

	defensePercent = 0.04 * defense / 1.5 * LevelRatingDS / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)


	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 and level 60 currently
	if CurrentLevel > 60 then 
		dodgeChance = dodgeChance + (agi / 25.0) / 100
	else
		dodgeChance = dodgeChance + (agi / 20) / 100
	end
	self:Debug("Dodge %: "..dodgeChance)

	parryChance = parryChance + defensePercent
	parryChance = parryChance + parry / 20.0 * LevelRatingDS / 100
	self:Debug("Parry %: "..parryChance)

	if blockChance > 0 then
		blockChance = blockChance + defensePercent
		blockChance = blockChance + block / 5.0 * LevelRatingDS / 100
	end
	self:Debug("Block %: "..blockChance)

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, blockChance, critChance, critBonus, crushChance, armorPercent, stanceModifier, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end






