

local Bonus = AceLibrary("LibItemBonus-2.0")


local eqevAgilityTableDruid = {
4.95, 4.95, 5.2, 5.2, 5.45, 5.45, 5.69, 5.69, 5.94, 6.44, 
6.68, 6.68, 6.93, 6.93, 7.43, 7.43, 7.67, 7.92, 7.92, 8.91, 
8.91, 9.16, 9.41, 9.41, 9.9, 9.9, 10.15, 10.4, 10.4, 11.39, 
11.64, 11.64, 11.89, 12.14, 12.38, 12.63, 12.87, 12.87, 13.12, 14.1, 
14.37, 14.37, 14.6, 14.86, 15.36, 15.6, 15.6, 15.85, 16.1, 17.09, 
17.33, 17.57, 17.83, 17.83, 18.32, 18.55, 18.83, 19.05, 19.31, 20.28, 
20.92, 21.19, 21.93, 22.37, 22.83, 23.26, 23.58, 24.27, 24.63, 25 }

local eqevIntTableDruid = {
6.99, 7.3, 7.62, 7.94, 8.26, 8.58, 8.9, 8.9, 9.21, 10.16, 
10.8, 11.75, 12.39, 13.33, 14.62, 15.24, 16.21, 16.84, 17.79, 19.38, 
20, 20.96, 21.6, 22.88, 23.81, 24.45, 25.38, 26.04, 27.32, 28.9, 
29.5, 30.77, 31.45, 32.36, 33.67, 34.25, 35.21, 36.23, 37.17, 39.06, 
39.68, 40.98, 41.67, 42.92, 43.86, 44.84, 45.66, 46.73, 47.85, 49.5, 
50.51, 51.81, 52.36, 53.76, 54.95, 55.87, 56.82, 57.8, 59.17, 60.98, 
61.73, 63.69, 66.67, 68.49, 70.42, 72.99, 75.19, 76.34, 78.13, 80 }





--Druid Spells

local EquipEval_SpellTableRegrowth = {
	All = {
		Level = 0,
		Coefficient = 0.3,
		OverTimeCoefficient = 0.7,
		CastTime = 2,
		Duration = 21,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 12,
		DirectHealAmount = (84 + 98) / 2,
		HealOverTimeAmount = 98,
		ManaCost = 80
	},

	{
		Level = 18,
		DirectHealAmount = (164 + 188) / 2,
		HealOverTimeAmount = 175,
		ManaCost = 135
	},

	{
		Level = 24,
		DirectHealAmount = (240 + 274) / 2,
		HealOverTimeAmount = 259,
		ManaCost = 185
	},

	{
		Level = 30,
		DirectHealAmount = (318 + 360) / 2,
		HealOverTimeAmount = 343,
		ManaCost = 230
	},

	{
		Level = 36,
		DirectHealAmount = (405 + 457) / 2,
		HealOverTimeAmount = 427,
		ManaCost = 275
	},

	{
		Level = 42,
		DirectHealAmount = (511 + 575) / 2,
		HealOverTimeAmount = 546,
		ManaCost = 335
	},

	{
		Level = 48,
		DirectHealAmount = (646 + 724) / 2,
		HealOverTimeAmount = 686,
		ManaCost = 405
	},

	{
		Level = 54,
		DirectHealAmount = (809 + 905) / 2,
		HealOverTimeAmount = 861,
		ManaCost = 485
	},

	{
		Level = 60,
		DirectHealAmount = (1003 + 1119) / 2,
		HealOverTimeAmount = 1064,
		ManaCost = 575
	},

	{
		Level = 65,
		DirectHealAmount = (1215 + 1355) / 2,
		HealOverTimeAmount = 1274,
		ManaCost = 675
	},
}



local EquipEval_SpellTableRejuvenation = {
	All = {
		Level = 0,
		Coefficient = 0,
		OverTimeCoefficient = 0.8,
		CastTime = 0,
		Duration = 12,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 4,
		HealOverTimeAmount = 32,
		ManaCost = 25
	},

	{
		Level = 10,
		HealOverTimeAmount = 56,
		ManaCost = 40
	},

	{
		Level = 16,
		HealOverTimeAmount = 116,
		ManaCost = 75
	},

	{
		Level = 22,
		HealOverTimeAmount = 180,
		ManaCost = 105
	},

	{
		Level = 28,
		HealOverTimeAmount = 244,
		ManaCost = 135
	},

	{
		Level = 34,
		HealOverTimeAmount = 304,
		ManaCost = 160
	},

	{
		Level = 40,
		HealOverTimeAmount = 388,
		ManaCost = 195
	},

	{
		Level = 46,
		HealOverTimeAmount = 488,
		ManaCost = 235
	},

	{
		Level = 52,
		HealOverTimeAmount = 608,
		ManaCost = 280
	},

	{
		Level = 58,
		HealOverTimeAmount = 756,
		ManaCost = 335
	},

	{
		Level = 60,
		HealOverTimeAmount = 888,
		ManaCost = 360
	},

	{
		Level = 63,
		HealOverTimeAmount = 932,
		ManaCost = 370
	},

	{
		Level = 69,
		HealOverTimeAmount = 1060,
		ManaCost = 415
	},
}


local EquipEval_SpellTableLifebloom = {
	All = {
		Level = 0,
		Coefficient = (1.5 / 3.5 * .8),
		OverTimeCoefficient = 0.518,
		CastTime = 0,
		Duration = 7,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 64,
		DirectHealAmount = 600,
		HealOverTimeAmount = 273,
		ManaCost = 220
	},
}


local EquipEval_SpellTableLifebloomStacked = {
	All = {
		Level = 0,
		Coefficient = 0,
		OverTimeCoefficient = 0.518 * 3 * (6/7),
		CastTime = 0,
		Duration = 7 * (6/7),
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 64,
		DirectHealAmount = 0,
		HealOverTimeAmount = 273 * 3 * (6/7),
		ManaCost = 220
	},
}



local EquipEval_SpellTableHealingTouch = {
	All = {
		Level = 0,
		Coefficient = (3.5 / 3.5),
		CastTime = 3.5,
		Duration = 0,
		CoolDown = 0,
		DirectHealAmount = 0,
		HealOverTimeAmount = 0,
		ManaCost = 0,
		MaxTargets = 1
	},

	{
		Level = 1,
		Coefficient = (1.5 / 3.5),
		CastTime = 1.5,
		DirectHealAmount = (37 + 51) / 2,
		ManaCost = 25
	},
	
	{
		Level = 8,
		Coefficient = (2.0 / 3.5),
		CastTime = 2.0,
		DirectHealAmount = (88 + 112) / 2,
		ManaCost = 55
	},
	
	{
		Level = 14,
		Coefficient = (2.5 / 3.5),
		CastTime = 2.5,
		DirectHealAmount = (195 + 243) / 2,
		ManaCost = 110
	},
	
	{
		Level = 20,
		Coefficient = (3.0 / 3.5),
		CastTime = 3.0,
		DirectHealAmount = (363 + 445) / 2,
		ManaCost = 185
	},
	
	{
		Level = 26,
		DirectHealAmount = (572 + 694) / 2,
		ManaCost = 270
	},
	
	{
		Level = 32,
		DirectHealAmount = (742 + 894) / 2,
		ManaCost = 335
	},
	
	{
		Level = 38,
		DirectHealAmount = (936 + 1120) / 2,
		ManaCost = 405
	},
	
	{
		Level = 44,
		DirectHealAmount = (1199 + 1427) / 2,
		ManaCost = 495
	},
	
	{
		Level = 50,
		DirectHealAmount = (1516 + 1796) / 2,
		ManaCost = 600
	},
	
	{
		Level = 56,
		DirectHealAmount = (1890 + 2230) / 2,
		ManaCost = 720
	},
	
	{
		Level = 60,
		DirectHealAmount = (2267 + 2677) / 2,
		ManaCost = 800
	},
	
	{
		Level = 62,
		DirectHealAmount = (2364 + 2790) / 2,
		ManaCost = 820
	},
	
	{
		Level = 69,
		DirectHealAmount = (2707 + 2790) / 2,
		ManaCost = 935
	},
}







---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid in cat form
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergy(level, ArmorEffect, crit, hit ,ap, avgDmg, damageModifier, critModifier, resilEffect, attackSpeed)
	if level < 20 then
		return 0
	end

	local tickEnergy = EquipEval.db.profile['EnergyGenerationPerTick']

	local dmgPerEnergy = 0
	local hitsPerEnergy = 0
	local rotationDPE = 0
	local rotationHPE = 0
	local rotationName = "None"

	local dpe0crit = 0
	local dpe1crit = 0
	local dpe2crit = 0
	local hpe0crit = 0
	local hpe1crit = 0
	local hpe2crit = 0

	local effectiveCrit = crit * EquipEval:TalentRank(2,11) * 0.5

	local chance0crit = (1 - effectiveCrit)^5
	local chance1crit = 4 * (1 - effectiveCrit)^3 * effectiveCrit
	local chance2crit = 3 * (1 - effectiveCrit) * (effectiveCrit)^2
	local chance3crit = effectiveCrit^3

	--Normalizing the chance to crit
	--This means the probabilities above aren't really correct
	local totalChance = chance0crit + chance1crit + chance2crit + chance3crit
	chance0crit = chance0crit / totalChance
	chance1crit = chance1crit / totalChance
	chance2crit = chance2crit / totalChance
	chance3crit = chance3crit / totalChance

	local hasMangle = EquipEval:TalentRank(2,21)

	local oocProcChance = min(1, (EquipEval:TalentRank(3,8) * 2 / 60 * EquipEval.db.profile["BurstFactor"]))
	self:Debug("OoC Proc Chance: "..oocProcChance)
	local oocPPS = hit * oocProcChance / attackSpeed

	local clawDamageModifier = 1 + EquipEval:TalentRank(2,12) * 0.1
	local clawEnergyCost = 45 - EquipEval:TalentRank(2,1)
	local clawDPE = EquipEval:FindDruidDamagePerEnergyClaw(level, ArmorEffect, crit, hit, avgDmg, (damageModifier * clawDamageModifier), critModifier, EquipEval:TalentRank(2,1))
	self:Debug("Claw DPE: "..clawDPE)
	local mangleDPE = EquipEval:FindDruidDamagePerEnergyMangle(level, ArmorEffect, crit, hit, avgDmg, (damageModifier * clawDamageModifier), critModifier, EquipEval:TalentRank(2,1))
	self:Debug("Mangle DPE: "..mangleDPE)
	local rakeDPE = EquipEval:FindDruidDamagePerEnergyRake(level, crit, hit, ap, (damageModifier * clawDamageModifier), critModifier, EquipEval:TalentRank(2,1), resilEffect)
	self:Debug("Rake DPE: "..rakeDPE)
	local rakeMDPE = EquipEval:FindDruidDamagePerEnergyRake(level, crit, hit, ap, (damageModifier * clawDamageModifier * 1.3), critModifier, EquipEval:TalentRank(2,1), resilEffect)
	self:Debug("Mangled Rake DPE: "..rakeMDPE)

	local shredEnergyCost = 60 - EquipEval:TalentRank(2,9) * 9
	local shredDPE = EquipEval:FindDruidDamagePerEnergyShred(level, ArmorEffect, crit, hit, avgDmg, damageModifier, critModifier, (EquipEval:TalentRank(2,9) * 9))
	self:Debug("Shred DPE: "..shredDPE)
	local shredMDPE = EquipEval:FindDruidDamagePerEnergyShred(level, ArmorEffect, crit, hit, avgDmg, (damageModifier * 1.3), critModifier, (EquipEval:TalentRank(2,9) * 9))
	self:Debug("Mangled Shred DPE: "..shredMDPE)


	local rip3DPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, damageModifier, 0, 3, resilEffect)
	self:Debug("Rip 3 DPE: "..rip3DPE)
	local rip4DPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, damageModifier, 0, 4, resilEffect)
	self:Debug("Rip 4 DPE: "..rip4DPE)
	local rip5DPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, damageModifier, 0, 5, resilEffect)
	self:Debug("Rip 5 DPE: "..rip5DPE)
	local rip3MDPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, (damageModifier * 1.3), 0, 3, resilEffect)
	self:Debug("Mangled Rip 3 DPE: "..rip3MDPE)
	local rip4MDPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, (damageModifier * 1.3), 0, 4, resilEffect)
	self:Debug("Mangled Rip 4 DPE: "..rip4MDPE)
	local rip5MDPE = EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, (damageModifier * 1.3), 0, 5, resilEffect)
	self:Debug("Mangled Rip 5 DPE: "..rip5MDPE)

	local biteDPE = 0
	local biteExtraEnergy = 0
	local biteModifier = 1 + EquipEval:TalentRank(2,2) * 0.03


	if EquipEval.db.profile['PermanentMangleOnTarget'] > 0 then
		rip4DPE = rip4MDPE
		rip5DPE = rip5MDPE
		shredDPE = shredMDPE
		rakeDPE = rakeMDPE
	end


	--Rotations without mangle

	--just claw
	rotationDPE = clawDPE
	rotationHPE = 1 / clawEnergyCost
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Claw"
		hitsPerEnergy = rotationHPE
	end
	
	--claw to 5 and bite
	biteExtraEnergy = floor((5 * clawEnergyCost + 35) / tickEnergy + 0.99) * tickEnergy - (5 * clawEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	self:Debug("Bite 5 DPE with "..biteExtraEnergy.." extra energy: "..biteDPE)
	dpe0crit = (5 * clawDPE + biteDPE) / 6
	hpe0crit = 6 / (5 * clawEnergyCost + 35 + biteExtraEnergy)
	biteExtraEnergy = floor((4 * clawEnergyCost + 35) / tickEnergy + 0.99) * tickEnergy - (4 * clawEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	dpe1crit = (4 * clawDPE + biteDPE) / 5
	hpe1crit = 5 / (4 * clawEnergyCost + 35 + biteExtraEnergy)
	biteExtraEnergy = floor((3 * clawEnergyCost + 35) / tickEnergy + 0.99) * tickEnergy - (3 * clawEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	dpe2crit = (3 * clawDPE + biteDPE) / 4
	hpe2crit = 4 / (3 * clawEnergyCost + 35 + biteExtraEnergy)
	rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
	rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Claw, Bite"
		hitsPerEnergy = rotationHPE
	end

	--claw to 5 and rip
	dpe0crit = (5 * clawDPE + rip5DPE) / 6
	hpe0crit = 5 / (5 * clawEnergyCost + 30)
	dpe1crit = (4 * clawDPE + rip5DPE) / 5
	hpe1crit = 4 / (4 * clawEnergyCost + 30)
	dpe2crit = (3 * clawDPE + rip5DPE) / 4
	hpe2crit = 3 / (3 * clawEnergyCost + 30)
	rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
	rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Claw, Rip"
		hitsPerEnergy = rotationHPE
	end

	--Shred to 5 and bite
	biteExtraEnergy = (floor((5 * shredEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (5 * shredEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	dpe0crit = (5 * shredDPE + biteDPE) / 6
	hpe0crit = 6 / (5 * shredEnergyCost + 35 + biteExtraEnergy)
	biteExtraEnergy = (floor((4 * shredEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (4 * shredEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	dpe1crit = (4 * shredDPE + biteDPE) / 5
	hpe1crit = 5 / (4 * shredEnergyCost + 35 + biteExtraEnergy)
	biteExtraEnergy = (floor((3 * shredEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (3 * shredEnergyCost + 35)
	biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
	dpe2crit = (3 * shredDPE + biteDPE) / 4
	hpe0crit = 4 / (3 * shredEnergyCost + 35 + biteExtraEnergy)
	rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
	rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Shred, Bite"
		hitsPerEnergy = rotationHPE
	end

	--Shred to 5 and rip
	dpe0crit = (5 * shredDPE + rip5DPE) / 6
	hpe0crit = 5 / (5 * shredEnergyCost + 30)
	dpe1crit = (4 * shredDPE + rip5DPE) / 5
	hpe1crit = 4 / (4 * shredEnergyCost + 30)
	dpe2crit = (3 * shredDPE + rip5DPE) / 4
	hpe2crit = 3 / (3 * shredEnergyCost + 30)
	rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
	rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Shred, Rip"
		hitsPerEnergy = rotationHPE
	end

	--Just Shred
	rotationDPE = shredDPE
	rotationHPE = 1 / shredEnergyCost
	rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
	dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
	if rotationDPE == dmgPerEnergy then
		rotationName = "Shred"
		hitsPerEnergy = rotationHPE
	end

	if hasMangle == 1 then
		--Rotations with mangle

		--Mangle to 5 and bite
		biteExtraEnergy = (floor((5 * clawEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (5 * clawEnergyCost - 35)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe0crit = (5 * mangleDPE + biteDPE) / 6
		hpe0crit = 6 / (5 * shredEnergyCost + 35 + biteExtraEnergy)
		biteExtraEnergy = (floor((4 * clawEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (4 * clawEnergyCost - 35)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe1crit = (4 * mangleDPE + biteDPE) / 5
		hpe1crit = 5 / (4 * shredEnergyCost + 35 + biteExtraEnergy)
		biteExtraEnergy = (floor((3 * clawEnergyCost + 35) / tickEnergy) + 0.99) * tickEnergy - (3 * clawEnergyCost - 35)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe2crit = (3 * mangleDPE + biteDPE) / 4
		hpe2crit = 4 / (3 * shredEnergyCost + 35 + biteExtraEnergy)
		rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
		rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Bite"
			hitsPerEnergy = rotationHPE
		end

		--Mangle to 5 and Rip
		dpe0crit = (5 * mangleDPE + rip5MDPE) / 6
		hpe0crit = 5 / (5 * shredEnergyCost + 30)
		dpe1crit = (4 * mangleDPE + rip5MDPE) / 5
		hpe1crit = 4 / (4 * shredEnergyCost + 30)
		dpe2crit = (3 * mangleDPE + rip5MDPE) / 4
		hpe2crit = 3 / (3 * shredEnergyCost + 30)
		rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
		rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Rip"
			hitsPerEnergy = rotationHPE
		end

		--Mangle, Shred and Rip
		local numShreds = (6 * tickEnergy + 60.5 - clawEnergyCost) / shredEnergyCost
		dpe0crit = (mangleDPE + numShreds * shredMDPE + (4 - numShreds) * shredDPE + rip5MDPE) / 6
		hpe0crit = 5 / (clawEnergyCost + 4 * shredEnergyCost + 30)
		dpe1crit = (mangleDPE + min(3, numShreds) * shredMDPE + (3 - min(3, numShreds)) * shredDPE + rip5MDPE) / 5
		hpe1crit = 4 / (clawEnergyCost + 3 * shredEnergyCost + 30)
		dpe2crit = (mangleDPE + 2 * shredMDPE  + rip5MDPE) / 4
		hpe2crit = 3 / (clawEnergyCost + 2 * shredEnergyCost + 30)
		rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
		rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Shred, Rip"
			hitsPerEnergy = rotationHPE
		end


		--Mangle, Rake, Shred to 5 and Rip
		local numShreds = (6 * tickEnergy + 25.5 - clawEnergyCost) / shredEnergyCost
		dpe0crit = (mangleDPE + rakeMDPE + numShreds * shredMDPE + (3 - numShreds) * shredDPE + rip5MDPE) / 6
		hpe0crit = 5 / (clawEnergyCost + 35 + 3 * shredEnergyCost + 30)
		dpe1crit = (mangleDPE + rakeMDPE + min(2, numShreds) * shredMDPE + (2 - min(2, numShreds)) * shredDPE + rip5MDPE) / 5
		hpe1crit = 4 / (clawEnergyCost + 35 + 2 * shredEnergyCost + 30)
		dpe2crit = (mangleDPE + rakeMDPE + shredMDPE  + rip5MDPE) / 4
		hpe2crit = 3 / (clawEnergyCost + 35 + shredEnergyCost + 30)
		rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
		rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Rake, Shred, Rip"
			hitsPerEnergy = rotationHPE
		end

		--Mangle, Shred to 5 and Bite
		numShreds = floor((6 * tickEnergy + 100 - clawEnergyCost) / shredEnergyCost)
		biteExtraEnergy = (floor((clawEnergyCost + 4 * shredEnergyCost) / 20) + 1) * 20 - (clawEnergyCost + 4 * shredEnergyCost)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe0crit = (mangleDPE + numShreds * shredMDPE + (4 - numShreds) * shredDPE + biteDPE) / 6
		hpe0crit = 6 / (clawEnergyCost + 4 * shredEnergyCost + 35 + biteExtraEnergy)
		biteExtraEnergy = (floor((clawEnergyCost + 3 * shredEnergyCost) / 20) + 1) * 20 - (clawEnergyCost + 3 * shredEnergyCost)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe1crit = (mangleDPE + max(3, numShreds) * shredMDPE + (3 - max(3, numShreds)) * shredDPE + biteDPE) / 5
		hpe1crit = 5 / (clawEnergyCost + 3 * shredEnergyCost + 35 + biteExtraEnergy)
		biteExtraEnergy = (floor((clawEnergyCost + 2 * shredEnergyCost) / 20) + 1) * 20 - (clawEnergyCost + 2 * shredEnergyCost)
		biteDPE = EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, (biteModifier * damageModifier), critModifier, biteExtraEnergy, 5)
		dpe2crit = (mangleDPE + 2 * shredMDPE  + biteDPE) / 4
		hpe2crit = 4 / (clawEnergyCost + 2 * shredEnergyCost + 35 + biteExtraEnergy)
		rotationDPE = dpe2crit * (chance2crit + chance3crit) + dpe1crit * chance1crit + dpe0crit * chance0crit
		rotationHPE = hpe2crit * (chance2crit + chance3crit) + hpe1crit * chance1crit + hpe0crit * chance0crit
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Shred, Bite"
			hitsPerEnergy = rotationHPE
		end


		--Shred with Mangle up
		numShreds = floor((6 * tickEnergy + 90.5 - clawEnergyCost) / shredEnergyCost)
		rotationDPE = (mangleDPE + numShreds * shredMDPE) / (1 + numShreds)
		rotationHPE = (1 + numShreds) / (clawEnergyCost + numShreds * shredEnergyCost)
		rotationDPE = rotationDPE * (1 + (rotationHPE * tickEnergy / 2 * oocProcChance + oocPPS) / (rotationHPE * tickEnergy / 2))
		dmgPerEnergy = max(dmgPerEnergy, rotationDPE)
		if rotationDPE == dmgPerEnergy then
			rotationName = "Mangle, Shred"
			hitsPerEnergy = rotationHPE
		end

	end

	self:Debug("Cat Attack Rotation: "..rotationName)


	return dmgPerEnergy, rotationName
end

---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using claw
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyClaw(level, ArmorEffect, crit, hit, avgDmg, damageModifier, critModifier, energyReduction)
	if level < 20 then
		return 0
	end
	
	local damage = avgDmg

	if level >= 67 then
		damage = damage + 190
	elseif level >= 58 then
		damage = damage + 115
	elseif level >= 48 then
		damage = damage + 88
	elseif level >= 38 then
		damage = damage + 57
	elseif level >= 28 then
		damage = damage + 39
	elseif level >= 20 then
		damage = damage + 27
	end

	damage = damage * damageModifier
	damage = damage * hit * (1 + crit * critModifier)
	damage = damage * (1 - ArmorEffect)

	local energy = 45 - energyReduction
	local missEnergy = energy * .2

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end

---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using mangle
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyMangle(level, ArmorEffect, crit, hit, avgDmg, damageModifier, critModifier, energyReduction)
	if level < 50 then
		return 0
	end
	
	local damage = avgDmg * 1.6

	if level >= 68 then
		damage = damage + 264
	elseif level >= 58 then
		damage = damage + 204
	elseif level >= 50 then
		damage = damage + 158
	end

	damage = damage * damageModifier
	damage = damage * hit * (1 + crit * critModifier)
	damage = damage * (1 - ArmorEffect)

	local energy = 45 - energyReduction
	local missEnergy = energy * .2

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end

---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using shred
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyShred(level, ArmorEffect, crit, hit, avgDmg, damageModifier, critModifier, energyReduction)
	if level < 22 then
		return 0
	end
	
	local damage = avgDmg * 2.25

	if level >= 70 then
		damage = damage + 405
	elseif level >= 61 then
		damage = damage + 236
	elseif level >= 54 then
		damage = damage + 180
	elseif level >= 46 then
		damage = damage + 144
	elseif level >= 38 then
		damage = damage + 99
	elseif level >= 30 then
		damage = damage + 72
	elseif level >= 22 then
		damage = damage + 54
	end

	damage = damage * damageModifier
	damage = damage * hit * (1 + crit * critModifier)
	damage = damage * (1 - ArmorEffect)

	local energy = 60 - energyReduction
	local missEnergy = energy * .2

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end


---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using rake
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyRake(level, crit, hit, ap, damageModifier, critModifier, energyReduction, resilEffect)
	if level < 24 then
		return 0
	end
	
	local dirDmg = ap / 100
	local dotDmg = ap * 0.06

	if level >= 64 then
		dirDmg = dirDmg + 78
		dotDmg = dotDmg + 108
	elseif level >= 54 then
		dirDmg = dirDmg + 55
		dotDmg = dotDmg + 75
	elseif level >= 44 then
		dirDmg = dirDmg + 40
		dotDmg = dotDmg + 60
	elseif level >= 34 then
		dirDmg = dirDmg + 26
		dotDmg = dotDmg + 45
	elseif level >= 24 then
		dirDmg = dirDmg + 17
		dotDmg = dotDmg + 30
	end

	dirDmg = dirDmg * hit * (1 + crit * critModifier)
	dotDmg = dotDmg * hit * (1 - resilEffect) * (1 - self.db.profile["EnemyIsBleedImmune"])

	local damage = dirDmg + dotDmg

	damage = damage * damageModifier

	local energy = 40 - energyReduction
	local missEnergy = energy * .2

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end

---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using Rip
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyRip(level, hit, ap, damageModifier, energyReduction, comboPoints, resilEffect)
	if level < 22 then
		return 0
	end

	local apRate = min(0.24, comboPoints * 0.06)

	local damage = 0

	if level >= 70 then
		damage = damage + 102 + 198 * comboPoints
	elseif level >= 61 then
		damage = damage + 102 + 168 * comboPoints
	elseif level >= 54 then
		damage = damage + 72 + 120 * comboPoints
	elseif level >= 46 then
		damage = damage + 54 + 84 * comboPoints
	elseif level >= 38 then
		damage = damage + 36 + 54 * comboPoints
	elseif level >= 30 then
		damage = damage + 24 + 42 * comboPoints
	elseif level >= 22 then
		damage = damage + 18 + 24 * comboPoints
	end

	--Internal modifier independent of spec as discussed at
	--http://elitistjerks.com/showthread.php?t=12366&page=2
	damage = damage * 1.3 * 1.1

	damage = damage + apRate * ap

	damage = damage * damageModifier
	damage = damage * hit * (1 - resilEffect) * (1 - self.db.profile["EnemyIsBleedImmune"])

	local energy = 30 - energyReduction
	local missEnergy = energy

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end

---------------------------------------------------------------------------------------
-- Find the damage per energy for a druid using ferocious bite
---------------------------------------------------------------------------------------
function EquipEval:FindDruidDamagePerEnergyFerociousBite(level, ArmorEffect, crit, hit, ap, damageModifier, critModifier, extraEnergy, comboPoints)
	if level < 32 then
		return 0
	end
	
	local apRate = comboPoints * 0.03
	local damage = ap * apRate

	if level >= 63 then
		damage = damage + (90 + 123) / 2 + 169 * comboPoints + 4.1 * extraEnergy
	elseif level >= 60 then
		damage = damage + (52 + 112) / 2 + 147 * comboPoints + 2.7 * extraEnergy
	elseif level >= 56 then
		damage = damage + (45 + 95) / 2 + 128 * comboPoints + 2.5 * extraEnergy
	elseif level >= 48 then
		damage = damage + (30 + 70) / 2 + 92 * comboPoints + 2.0 * extraEnergy
	elseif level >= 40 then
		damage = damage + (20 + 44) / 2 + 59 * comboPoints + 1.5 * extraEnergy
	elseif level >= 32 then
		damage = damage + (14 + 30) / 2 + 36 * comboPoints + 1.0 * extraEnergy
	end

	damage = damage * damageModifier
	damage = damage * hit * (1 + crit * critModifier)
	damage = damage * (1 - ArmorEffect)

	local energy = 35 + extraEnergy
	local missEnergy = 35

	return (damage / ((1 - hit) * missEnergy + hit * energy))
end




---------------------------------------------------------------------------------------
-- Used to calculate Druid DPS given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidDPS(infoObj, CurrentLevel, LevelRating)

	local TotalValue, str, agi, ap, rap, fap, crit, hit, meleedmg, _, holydmg, _, haste, critbonus, weapSkill, ignorearmor, expertise = EquipEval:CalculateStats(infoObj)
	local TotalValueCaster, int, spi, mana, mp5, spellcrit, holycrit, naturecrit, heal, spelldmg, spellhaste, spellhit, frostdmg, shadowdmg, firedmg, _, stam, arcanedmg, spellpen, naturedmg, _, spellcritbonus = EquipEval:CalculateCasterStats(infoObj)

	--Handle Special Bonuses
	local _, BonusSpellDmg = EquipEval:GetSpecialBonus("BONUS_DMG", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local _, BonusAttackPower = EquipEval:GetSpecialBonus("BONUS_ATTACKPOWER", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)

	if (TotalValue + TotalValueCaster + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end


	local AgilityRating = eqevAgilityTableDruid[CurrentLevel]

	local AgiModifier = 1 + .01 * EquipEval:TalentRank(2,16)
	local StrModifier = 1 + .01 * EquipEval:TalentRank(2,16)

	local ItemAgility = AgiModifier * agi

	local APModifier = 1

	--If the druid is in cat form
	if UnitPowerType("player") == 3 then
		--Pre 2.3 calculation commented out
		--StrModifier = StrModifier * (1 + .04 * EquipEval:TalentRank(2,15))
		APModifier = APModifier * (1 + .02 * EquipEval:TalentRank(2,15))
	end

	local ItemAP = APModifier * (ap + 2 * StrModifier * str)
	BonusAttackPower = APModifier * BonusAttackPower
	local _, _, moonkinActive = GetShapeshiftFormInfo(5);
	if UnitPowerType("player") ~= 0 or moonkinActive == 1 then
		ItemAP = ItemAP + APModifier * fap
	end
	if UnitPowerType("player") == 3 then
		ItemAP = ItemAP + APModifier * ItemAgility
	end

	local ItemHit = (hit / 10.0  * LevelRating / 100)

	local ItemCrit = (crit / 14.0 * LevelRating) + (ItemAgility/AgilityRating)

	local ItemHaste = (haste / 10.0 * LevelRating) / 100

	weapSkill = (weapSkill / 2.5  * LevelRating)
	expertise = (expertise / 2.5  * LevelRating) * 0.0025

	local baseDPS = EquipEval:CalculateDruidDPSFromStats(CurrentLevel, LevelRating, BonusAttackPower, 0, 0, 0, 0, 0, 0, 0, 0)
	local newDPS, InfoLine = EquipEval:CalculateDruidDPSFromStats(CurrentLevel, LevelRating, (ItemAP + BonusAttackPower), ItemCrit, ItemHit, meleedmg, ItemHaste, critbonus, weapSkill, ignorearmor, expertise)
	
	if newDPS == baseDPS then
		InfoLine = nil
	end



	local IntRating = eqevIntTableDruid[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(2,15) * 0.04) * (1 + EquipEval:TalentRank(2,16) * 0.01) * (1 + TotalModInt / 100)
	local SpiModifier = (1 + EquipEval:TalentRank(3,16) * 0.05) * (1 + EquipEval:TalentRank(2,16) * 0.01)
	local ManaModifier = 1
	local CastingRegen = EquipEval:TalentRank(3,6) * 0.1



	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)

	local itemDmg = spelldmg + 0.08 * EquipEval:TalentRank(1,12) * itemInt
	if EquipEval:TalentRank(1,12) >= 3 then
		itemDmg = itemDmg + 0.01 * itemInt
	end
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemSpellCrit = ((spellcrit / 14.0 * LevelRating) + (itemInt/IntRating)) / 100
	local itemSpellHit = (spellhit / 8.0 * LevelRating) / 100
	local itemSpellHaste = (spellhaste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	itemMP5 = itemMP5 + CastingRegen * SpiritEffect
	if EquipEval:TalentRank(1,17) >= 1 then
		itemMP5 = itemMP5 + (EquipEval:TalentRank(1,17) * 0.03 + 0.01) * itemInt
	end


	local baseSpellDPS, baseTime = EquipEval:CalculateDruidDPSFromStatsSpell(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, 0, BonusSpellDmg, BonusSpellHaste, 0, 0, 0, 0, 0, 0)
	baseSpellDPS = baseSpellDPS / baseTime

	local newSpellDPS, newTime, SpellInfoLine = EquipEval:CalculateDruidDPSFromStatsSpell(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemInt, itemSpi, itemSpellCrit, (itemDmg + BonusSpellDmg), (itemSpellHaste + BonusSpellHaste), itemSpellHit, naturecrit, naturedmg, arcanedmg, spellpen, spellcritbonus)
	newSpellDPS = newSpellDPS / newTime
	
	if newSpellDPS == baseSpellDPS then
		SpellInfoLine = nil
	end

	if baseSpellDPS > baseDPS then
		baseDPS = baseSpellDPS * baseTime
	end
	if newSpellDPS > newDPS then
		newDPS = newSpellDPS * newTime
		InfoLine = SpellInfoLine
	end


	return (newDPS - baseDPS), newDPS, InfoLine
end

---------------------------------------------------------------------------------------
-- Used to calculate Druid DPS given stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidDPSFromStats(CurrentLevel, LevelRating, ap, crit, hit, meleedmg, haste, critbonus, weapSkill, ignoreArmor, expertise)
	--Include the effects of Feral Faerie Fire
	if EquipEval:TalentRank(2,13) == 1 and EquipEval.db.profile['IncludeStrikes'] == 1 then
		if CurrentLevel >= 66 then
			ignoreArmor = ignoreArmor + 610
		elseif CurrentLevel >= 54 then
			ignoreArmor = ignoreArmor + 505
		elseif CurrentLevel >= 42 then
			ignoreArmor = ignoreArmor + 395
		elseif CurrentLevel >= 30 then
			ignoreArmor = ignoreArmor + 285
		end
	end

	local InfoLine = nil
	local ArmorEffect = EquipEval:GetArmorModifer(EquipEval:GetArmorPenetration() + ignoreArmor)

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100
	local CritModifier = 1 + .02 * EquipEval:TalentRank(2,20)
	CritModifier = (CritModifier + 1) * (1 + critbonus / 100 + EquipEval:GetBonusCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local AgilityRating = eqevAgilityTableDruid[CurrentLevel]
	--self:Debug("Agility Rating: "..AgilityRating)

        local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentmod = UnitDamage("player");
	local mainSpeed, offSpeed = UnitAttackSpeed("player");
	if mainSpeed == 0 then
		mainSpeed = 1
	end
	local offHandModifier = 0
	self:Debug("HiDmg: "..hiDmg)
	self:Debug("Damage Mod %: "..percentmod)
	local APDamageModifier = 1 + .02 * EquipEval:TalentRank(3,3)

	lowDmg = lowDmg + meleedmg * APDamageModifier
	hiDmg = hiDmg + meleedmg * APDamageModifier
	local avgDmg = (lowDmg + hiDmg) / 2;
	local avgDps = avgDmg / mainSpeed;
	--self:Debug("Current DPS: "..avgDps)

	expertise = EquipEval:GetExpertise() + expertise
	local weapSkillDif = EquipEval:GetSkillDifference(weapSkill + CurrentLevel * 5 + GetCombatRatingBonus(CR_WEAPON_SKILL_MAINHAND) + EquipEval.db.profile["BonusWeaponSkill"])
	self:Debug("Weapon Skill Difference: "..weapSkillDif)

	local totalCrit = GetCritChance() - 0.04 * weapSkillDif
	totalCrit = totalCrit + EquipEval.db.profile["BonusCritChancePercent"]
	totalCrit = max(0, ((totalCrit + crit) / 100 - resilienceEffect))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local CurrentHit = GetCombatRating(CR_HIT_MELEE) / 10.0  * LevelRating
	CurrentHit = CurrentHit + EquipEval.db.profile["BonusHitPercent"]

	local currentChanceToHit = (EquipEval:MaxHitChance(expertise, weapSkillDif) - (0.05 + EquipEval:GetMissFromSkillDifference(weapSkillDif))) + (CurrentHit)/100 + hit
	currentChanceToHit = min(currentChanceToHit, EquipEval:MaxHitChance(expertise, weapSkillDif))
	local totalHit = max(0.01, (1 - (1 - currentChanceToHit) / EquipEval.db.profile["BurstFactor"]))
	self:Debug("Total Hit: "..totalHit)

	local GlanceChance, GlanceModifier = EquipEval:GetGlancingBlowInfo()

	local totalHaste = haste
	APDamageModifier = APDamageModifier * (1 + totalHaste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100)
	mainSpeed = mainSpeed / (1 + totalHaste)
	if offSpeed ~= nil then
		offSpeed = offSpeed / (1 + totalHaste)
	end
	avgDps = avgDps * (1 + totalHaste)
	totalHaste = totalHaste + GetCombatRatingBonus(CR_HASTE_MELEE) / 100
	self:Debug("Total Haste: "..totalHaste)

	local ItemAP = ap + EquipEval.db.profile["BonusAP"]
	local baseAP, posAPBuff, negAPBuff = UnitAttackPower("player")
	ItemAP = ItemAP + (baseAP + posAPBuff + negAPBuff + ItemAP) * EquipEval.db.profile["BonusAPPercent"] / 100
	local effectiveAP = baseAP + posAPBuff + negAPBuff + ItemAP
	self:Debug("Item AP: "..ItemAP)

	local DPSFromAP = (avgDps + APDamageModifier * ItemAP/14.0) * (totalHit + min(totalCrit, max(0, totalHit - GlanceChance)) * CritModifier - (1 - GlanceModifier) * GlanceChance)
	self:Debug("DPS From AP: "..DPSFromAP)


	local DPSFromStrikes = 0
	--If the druid is in cat form
	if UnitPowerType("player") == 3 and EquipEval.db.profile['IncludeStrikes'] == 1 then
		--Does not account for Powershifting
		DPSFromStrikes, InfoLine = EquipEval:FindDruidDamagePerEnergy(CurrentLevel, ArmorEffect, totalCrit, totalHit, effectiveAP, (avgDmg + ItemAP/14.0 * mainSpeed), APDamageModifier, CritModifier, resilienceEffect, mainSpeed)
		DPSFromStrikes = EquipEval.db.profile['EnergyGenerationPerTick'] / 2 * DPSFromStrikes
		if InfoLine and InfoLine ~= "None" and EquipEval.db.profile['ChosenAttacksDisplayed'] then
			InfoLine = "Attacks: "..InfoLine
		else
			InfoLine = nil
		end
	elseif UnitPowerType("player") == 1 and EquipEval.db.profile['IncludeStrikes'] == 1 then
		local threatMultiplier = (1.30 + EquipEval:TalentRank(2,3) * 0.05)
		DPSFromStrikes = DPSFromStrikes + DPSFromAP * (threatMultiplier - 1) * (1 - ArmorEffect)

		local mangleExtraDamage = 0
		if CurrentLevel >= 68 then
			mangleExtraDamage = 155
		elseif CurrentLevel >= 58 then
			mangleExtraDamage = 121
		elseif CurrentLevel >= 50 then
			mangleExtraDamage = 86
		end
		mangleExtraDamage = mangleExtraDamage * APDamageModifier
		DPSFromStrikes = DPSFromStrikes + EquipEval:TalentRank(2,21) * 1.5 * ((avgDmg + APDamageModifier * ItemAP/14.0 * mainSpeed + mangleExtraDamage) * (totalHit + totalCrit * CritModifier)) / 6 * (1 - ArmorEffect)

		if CurrentLevel >= 66 then
			DPSFromStrikes = DPSFromStrikes + threatMultiplier * 285 * totalHit * (3 + (1 - EquipEval:TalentRank(2,21))) / 6
			DPSFromStrikes = DPSFromStrikes + threatMultiplier * 31 * APDamageModifier * (totalHit + totalCrit * CritModifier) * (3 + (1 - EquipEval:TalentRank(2,21))) / 6
			DPSFromStrikes = DPSFromStrikes + threatMultiplier * (5 * (155 + effectiveAP / 20) / 15) * APDamageModifier * (1 + 0.3 * EquipEval:TalentRank(2,21))
		elseif CurrentLevel >= 16 then
			--put in code for aggro from swipe spam
		end

		if CurrentLevel >= 67 then
			DPSFromStrikes = DPSFromStrikes + threatMultiplier * 322 * totalHit / mainSpeed
			DPSFromStrikes = DPSFromStrikes + threatMultiplier * 176 * APDamageModifier * (totalHit + totalCrit * CritModifier) / mainSpeed * (1 - ArmorEffect)
		end
	end
	self:Debug("DPS From Strikes: "..DPSFromStrikes)

	return (1 - ArmorEffect) * DPSFromAP + DPSFromStrikes, InfoLine
end


---------------------------------------------------------------------------------------
-- Used to calculate Druid Spell DPS From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidDPSFromStatsSpell(CurrentLevel, LevelRating, mana, mp5, itemInt, itemSpi, crit, spelldmg, haste, hit, naturecrit, naturedmg, arcanedmg, spellpen, spellcritbonus)
	local InfoLine = "Spells: "
	if UnitPowerType("player") ~= 0 then
		return 0, 1
	end

	local resilienceEffect = EquipEval.db.profile["EnemyResilience"] / 25.0 * EquipEval:GetLevelRating(CurrentLevel + self.db.profile["EnemyLevelDifference"]) / 100

	local CritModifier = 0.5 * (1 + EquipEval:TalentRank(1,10) * 0.2)
	CritModifier = (CritModifier + 1) * (1 + spellcritbonus / 100 + EquipEval:GetBonusSpellCritDamage()) - 1
	CritModifier = (CritModifier + 1) * (1 + EquipEval.db.profile["BonusCritDamagePercent"] / 100) - 1
	CritModifier = (CritModifier + 1) * (1 - min(0.25, (resilienceEffect * 2))) - 1
	self:Debug("Crit Modifier: "..CritModifier)

	local ManaCostModifier = 1
	self:Debug("Mana Cost Modifier: "..ManaCostModifier)

	local DamageModifier = 1
	self:Debug("Damage Modifier: "..DamageModifier)

	local totalCritNature = GetSpellCritChance(4)
	totalCritNature = totalCritNature + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritNature = max(0, (totalCritNature / 100 + crit + naturecrit / 100 - resilienceEffect))
	totalCritNature = min(1, totalCritNature * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Nature: "..totalCritNature)

	local totalCritArcane = GetSpellCritChance(7)
	totalCritArcane = totalCritArcane + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCritArcane = max(0, (totalCritArcane / 100 + crit - resilienceEffect))
	totalCritArcane = min(1, totalCritArcane * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit Arcane: "..totalCritArcane)

	local totalHit = EquipEval:GetSpellHitChance() + hit + EquipEval:TalentRank(1,16) * 0.02
	totalHit = totalHit + GetCombatRatingBonus(CR_HIT_SPELL) / 100 + EquipEval.db.profile["BonusSpellHitPercent"] / 100
	totalHit = max(0.01, (1 - (1 - totalHit) / EquipEval.db.profile["BurstFactor"]))
	totalHit = min(0.99, totalHit) * EquipEval:GetResistanceModifier(GetSpellPenetration() + spellpen)
	self:Debug("Total Hit: "..totalHit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenCasting
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	if CurrentLevel >= 40 then
		totalMP5 = totalMP5 + 4 * EquipEval:GetBaseMP5FromStats(nil, nil, nil, itemSpi, itemInt) * 20 / 360
	end
	self:Debug("Total MP5: "..totalMP5)

	local totalDmgNature = GetSpellBonusDamage(4) + spelldmg + naturedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Nature: "..totalDmgNature)

	local totalDmgArcane = GetSpellBonusDamage(7) + spelldmg + arcanedmg + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Dmg Arcane: "..totalDmgArcane)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local SpellDPS = 0
	local SpellMPS = 0
	local TotalDPS = 0
	local TotalMPS = 0
	local CastTime = 0
	local SpellDuration = 0
	local SpellCritChance = 0
	local SpellTimeFraction = 0


	--Force of Nature not modeled


	--Moonfire
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	CastTime = CastTime / (1 + totalHaste)
	CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / totalHit
	SpellDuration = 12
	SpellCritChance = min(1, totalCritArcane + EquipEval:TalentRank(1,6) * 0.05 * EquipEval.db.profile["BurstFactor"])
	if CurrentLevel >= 4 and TimeFraction > 0 then
		local DoTDamage = 0

		if CurrentLevel >= 70 then
			SpellDPS = (305 + 357) / 2
			DoTDamage = 600
			SpellMPS = 495
		elseif CurrentLevel >= 63 then
			SpellDPS = (220 + 258) / 2
			DoTDamage = 444
			SpellMPS = 430
		elseif CurrentLevel >= 58 then
			SpellDPS = (189 + 221) / 2
			DoTDamage = 384
			SpellMPS = 375
		elseif CurrentLevel >= 52 then
			SpellDPS = (157 + 185) / 2
			DoTDamage = 320
			SpellMPS = 325
		elseif CurrentLevel >= 46 then
			SpellDPS = (130 + 154) / 2
			DoTDamage = 264
			SpellMPS = 280
		elseif CurrentLevel >= 40 then
			SpellDPS = (105 + 125) / 2
			DoTDamage = 212
			SpellMPS = 235
		elseif CurrentLevel >= 34 then
			SpellDPS = (81 + 97) / 2
			DoTDamage = 164
			SpellMPS = 190
		elseif CurrentLevel >= 28 then
			SpellDPS = (61 + 73) / 2
			DoTDamage = 124
			SpellMPS = 150
		elseif CurrentLevel >= 22 then
			SpellDPS = (40 + 48) / 2
			DoTDamage = 80
			SpellMPS = 105
		elseif CurrentLevel >= 16 then
			SpellDPS = (25 + 31) / 2
			DoTDamage = 52
			SpellMPS = 75
		elseif CurrentLevel >= 10 then
			SpellDPS = (13 + 17) / 2
			DoTDamage = 32
			SpellMPS = 50
		elseif CurrentLevel >= 4 then
			SpellDPS = (7 + 9) / 2
			DoTDamage = 12
			SpellMPS = 25
		end


		SpellDPS = SpellDPS + 0.347 * 1.5 / 3.5 * totalDmgArcane
		DoTDamage = DoTDamage + 0.653 * 12 / 15 * totalDmgArcane
		DoTDamage = DoTDamage * (1 - resilienceEffect)

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,15) * 0.02) * ((1 + SpellCritChance * CritModifier) * SpellDPS + DoTDamage)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,14) * 0.03) * SpellMPS / totalHit

		--[[SpellTimeFraction = min((CastTime / SpellDuration), TimeFraction)
		TotalDPS = TotalDPS + SpellDPS / CastTime * SpellTimeFraction
		TotalMPS = TotalMPS + SpellMPS / CastTime * SpellTimeFraction
		TimeFraction = TimeFraction - SpellTimeFraction
		
		InfoLine = InfoLine.."Moonfire, "]]
	end
	local MoonfireRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local MoonfireDmg = SpellDPS / CastTime
	local MoonfireMana = SpellMPS / CastTime
	local MoonfireMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * CastTime / SpellDuration




	--Insect Swarm
	SpellDPS = 0
	SpellMPS = 0
	CastTime = 0
	CastTime = CastTime / (1 + totalHaste)
	CastTime = (max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]) / totalHit
	SpellDuration = 12
	SpellCritChance = 0
	if EquipEval:TalentRank(1,8) >= 1 and TimeFraction > 0 then


		if CurrentLevel >= 70 then
			SpellDPS = 792
			SpellMPS = 175
		elseif CurrentLevel >= 60 then
			SpellDPS = 594
			SpellMPS = 155
		elseif CurrentLevel >= 50 then
			SpellDPS = 432
			SpellMPS = 135
		elseif CurrentLevel >= 40 then
			SpellDPS = 300
			SpellMPS = 110
		elseif CurrentLevel >= 30 then
			SpellDPS = 192
			SpellMPS = 85
		elseif CurrentLevel >= 20 then
			SpellDPS = 108
			SpellMPS = 50
		end


		SpellDPS = DamageModifier * (SpellDPS + (12/15 * 0.95) * totalDmgNature)
		SpellDPS = SpellDPS * (1 - resilienceEffect)
		SpellMPS = ManaCostModifier * SpellMPS / totalHit

		--[[SpellTimeFraction = min((CastTime / SpellDuration), TimeFraction)
		TotalDPS = TotalDPS + SpellDPS / CastTime * SpellTimeFraction
		TotalMPS = TotalMPS + SpellMPS / CastTime * SpellTimeFraction
		TimeFraction = TimeFraction - SpellTimeFraction
		
		InfoLine = InfoLine.."Insect Swarm, "]]
	end
	local InsectSwarmRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local InsectSwarmDmg = SpellDPS / CastTime
	local InsectSwarmMana = SpellMPS / CastTime
	local InsectSwarmMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * CastTime / SpellDuration

	

	--Starfire
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, totalCritArcane + EquipEval:TalentRank(1,5) * 0.02 * EquipEval.db.profile["BurstFactor"])
	CastTime = 3.5 - EquipEval:TalentRank(1,1) * 0.1 - EquipEval:TalentRank(1,13) * 0.5 * SpellCritChance
	CastTime = CastTime / (1 + totalHaste)
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
	if CurrentLevel >= 20 and TimeFraction > 0 then

		if CurrentLevel >= 67 then
			SpellDPS = (540 + 636) / 2
			SpellMPS = 370
		elseif CurrentLevel >= 60 then
			SpellDPS = (496 + 584) / 2
			SpellMPS = 340
		elseif CurrentLevel >= 58 then
			SpellDPS = (445 + 525) / 2
			SpellMPS = 315
		elseif CurrentLevel >= 50 then
			SpellDPS = (362 + 428) / 2
			SpellMPS = 275
		elseif CurrentLevel >= 42 then
			SpellDPS = (280 + 334) / 2
			SpellMPS = 230
		elseif CurrentLevel >= 34 then
			SpellDPS = (201 + 241) / 2
			SpellMPS = 180
		elseif CurrentLevel >= 26 then
			SpellDPS = (137 + 167) / 2
			SpellMPS = 135
		elseif CurrentLevel >= 20 then
			SpellDPS = (89 + 109) / 2
			SpellMPS = 95
		end


		SpellDPS = SpellDPS + (3.5 / 3.5 + EquipEval:TalentRank(1,20) * 0.04) * totalDmgArcane

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,15) * 0.02) * totalHit * ((1 + SpellCritChance * CritModifier) * SpellDPS)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,14) * 0.03) * SpellMPS

	end
	local StarfireRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local StarfireDmg = SpellDPS / CastTime
	local StarfireMana = SpellMPS / CastTime
	local StarfireMaxTimeFraction = 1


	--Wrath
	SpellDPS = 0
	SpellMPS = 0
	SpellDuration = 0
	SpellCritChance = min(1, totalCritNature + EquipEval:TalentRank(1,5) * 0.02 * EquipEval.db.profile["BurstFactor"])
	CastTime = 2 - EquipEval:TalentRank(1,1) * 0.1 - EquipEval:TalentRank(1,13) * 0.5 * SpellCritChance
	CastTime = CastTime / (1 + totalHaste)
	CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime) + EquipEval.db.profile["CastTimePadding"]
	if TimeFraction > 0 then

		if CurrentLevel >= 69 then
			SpellDPS = (381 + 429) / 2
			SpellMPS = 255
		elseif CurrentLevel >= 61 then
			SpellDPS = (278 + 312) / 2
			SpellMPS = 210
		elseif CurrentLevel >= 54 then
			SpellDPS = (236 + 264) / 2
			SpellMPS = 180
		elseif CurrentLevel >= 46 then
			SpellDPS = (188 + 210) / 2
			SpellMPS = 155
		elseif CurrentLevel >= 38 then
			SpellDPS = (139 + 157) / 2
			SpellMPS = 125
		elseif CurrentLevel >= 30 then
			SpellDPS = (101 + 115) / 2
			SpellMPS = 100
		elseif CurrentLevel >= 22 then
			SpellDPS = (63 + 73) / 2
			SpellMPS = 70
		elseif CurrentLevel >= 14 then
			SpellDPS = (44 + 52) / 2
			SpellMPS = 55
		elseif CurrentLevel >= 6 then
			SpellDPS = (25 + 29) / 2
			SpellMPS = 35
		elseif CurrentLevel >= 1 then
			SpellDPS = (12 + 14) / 2
			SpellMPS = 20
		end


		SpellDPS = SpellDPS + (2 / 3.5 + EquipEval:TalentRank(1,20) * 0.02) * totalDmgNature

		SpellDPS = DamageModifier * (1 + EquipEval:TalentRank(1,15) * 0.02) * totalHit * ((1 + SpellCritChance * CritModifier) * SpellDPS)
		SpellMPS = ManaCostModifier * (1 - EquipEval:TalentRank(1,14) * 0.03) * SpellMPS

	end
	local WrathRating = EquipEval:GetSpellRating(SpellDPS, SpellMPS, CastTime)
	local WrathDmg = SpellDPS / CastTime
	local WrathMana = SpellMPS / CastTime
	local WrathMaxTimeFraction = 1



	--Choose Spells
	while TimeFraction > 0 do
		local MaxRating = max(MoonfireRating, InsectSwarmRating, StarfireRating, WrathRating)
		local SpellTimeFraction = 0
		
		if MaxRating <= 0 then
			break
		end

		if MoonfireRating == MaxRating then
			SpellTimeFraction = MoonfireMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * MoonfireMana
			TotalDPS = TotalDPS + MoonfireDmg * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			MoonfireRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Moonfire "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."Moonfire, "
			end
		elseif InsectSwarmRating == MaxRating then
			SpellTimeFraction = InsectSwarmMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * InsectSwarmMana
			TotalDPS = TotalDPS + InsectSwarmDmg * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			InsectSwarmRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Insect Swarm "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."IS, "
			end
		elseif StarfireRating == MaxRating then
			SpellTimeFraction = StarfireMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * StarfireMana
			TotalDPS = TotalDPS + StarfireDmg * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			StarfireRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Starfire "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."Starfire, "
			end
		elseif WrathRating == MaxRating then
			SpellTimeFraction = WrathMaxTimeFraction
			
			SpellTimeFraction = min(TimeFraction, SpellTimeFraction)
			TotalMPS = TotalMPS + SpellTimeFraction * WrathMana
			TotalDPS = TotalDPS + WrathDmg * SpellTimeFraction
			
			TimeFraction = TimeFraction - SpellTimeFraction
			WrathRating = 0
			if SpellTimeFraction > 0 then
				self:Debug("Add Spell: Wrath "..(SpellTimeFraction * 100).."%")
				InfoLine = InfoLine.."Wrath, "
			end
		else
			break
		end
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenAttacksDisplayed"] then
		InfoLine = nil
	end


	local FightLength = 1
	if EquipEval.db.profile["DisplayDPSTotal"] <= -2 then

		if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
			totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
			self:Debug("Damped Total Mana: "..totalMana)
		end

		FightLength = min((20 * 60), (totalMana / (TotalMPS - totalMP5 / 5)))

		if FightLength < 0 then
			FightLength = 20 * 60
		end
		self:Debug("Fight Length: "..FightLength)

		TotalDPS = TotalDPS * FightLength
	end

	return TotalDPS, FightLength, InfoLine

end






---------------------------------------------------------------------------------------
-- Used to calculate Druid Mitigation given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidMit(infoObj, CurrentLevel, LevelRating)
	local TotalValue, agi, dodge, parry, block, armor, defense, resilience, addedArmor, stam, health = EquipEval:CalculateMitigationStats(infoObj)

	if TotalValue == 0 then
		return 0, 0
	end


	local TotalResiliencePercent = 0
	local HitsPerSecond = self.db.profile["EnemyHitsPerSecond"] * (1 + self.db.profile["NumberOfAdditionalTargets"])
	local mitTotal = 0
	local hitBase = (1 - (0.05 - 0.0004 * EquipEval:GetSkillDifference()))
	hitbase = min(hitBase, 1)
	local critBase = (self.db.profile["EnemyBaseCritPercentage"] / 100 + 0.0004 * EquipEval:GetSkillDifference())
	local critChance = critBase
	local crushChance = 0
	local maxHP = UnitHealthMax("player") + self.db.profile["BonusHP"]
	local stamMultiplier = 1
	if self.db.profile["EnemyLevelDifference"] >= 3 then
		crushChance = (self.db.profile["EnemyLevelDifference"] * 0.1 - 0.15)
	end


	local dmgBase = (1 - EquipEval:FindMitigation(hitbase, 0, 0, 0, critBase, 1, crushChance, 0, 1, 1))


	critChance = critChance - EquipEval:TalentRank(2,16) * .01

	local defensePercent = 0.04 * GetCombatRatingBonus(CR_DEFENSE_SKILL) / 100
	self:Debug("Base Defense %: "..defensePercent)
	local resiliencePercent = GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE) / 100
	TotalResiliencePercent = TotalResiliencePercent + resiliencePercent
	self:Debug("Base Resilience %: "..resiliencePercent)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	local critBonus = 1 - resiliencePercent * 4
	critBonus = max(critBonus, 0)
	self:Debug("Base % To Be Crit: "..critChance)
	self:Debug("Base Crit Bonus: "..critBonus)

	local hitChance = hitBase - defensePercent
	self:Debug("Base % To Be Hit: "..hitChance)
	local _, effectiveArmor = UnitArmor("player");
	local armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Base Armor %: "..armorPercent)
	local dodgeChance = GetDodgeChance() / 100
	self:Debug("Base Dodge %: "..dodgeChance)
	local parryChance = GetParryChance() / 100
	self:Debug("Base Parry %: "..parryChance)

	--Handle crit reactive effects
	local NaturalPerfectionEffect = 1
	local CritReactivePPS = (critChance * HitsPerSecond + hitChance * HitsPerSecond * TotalResiliencePercent)
	if EquipEval:TalentRank(3,18) > 0 then
		local NaturalPerfectionChance = (1 - (1 - min(1, CritReactivePPS))^8)
		local NaturalPerfectionBonus = 0.01 + EquipEval:TalentRank(3,18) * 0.01
		NaturalPerfectionEffect = (1 - NaturalPerfectionBonus * NaturalPerfectionChance - NaturalPerfectionBonus * NaturalPerfectionChance ^ 2 - NaturalPerfectionBonus * NaturalPerfectionChance ^ 3)
	end
	
	local mitBase = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, 0, critChance, critBonus, crushChance, armorPercent, NaturalPerfectionEffect, dmgBase)
	local ttlBase = maxHP / (1 - mitBase)
	self:Debug("Base Mitigation: "..(mitBase * 100).."%")



	--Factor in stats
	agi = agi * (1 + EquipEval:TalentRank(2,16) * .01)

	if EquipEval:TalentRank(2,5) > 0 then
		armor = armor * (1 + (EquipEval:TalentRank(2,5) * .03 + 0.01))
	end

	stamMultiplier = stamMultiplier * (1 + EquipEval:TalentRank(2,16) * .01)

	--If the druid is in a bear form or moonkin form
	local _, _, moonkinActive = GetShapeshiftFormInfo(5);
	if UnitPowerType("player") == 1 or moonkinActive == 1 then
		if CurrentLevel >= 40 then
			armor = armor * 5
		else
			armor = armor * 2.8
		end

		stamMultiplier = stamMultiplier * 1.25 * (1 + EquipEval:TalentRank(2,15) * .04)
	end
	armor = armor + 2 * agi + addedArmor
	self:Debug("Armor: "..armor)
	armorPercent = EquipEval:GetDamageReductionFromArmor(effectiveArmor + armor, (CurrentLevel + self.db.profile["EnemyLevelDifference"]))
	self:Debug("Armor %: "..armorPercent)

	maxHP = maxHP + stamMultiplier * stam * 10 + health

	defensePercent = 0.04 * defense / 1.5 * LevelRating / 100
	self:Debug("Defense %: "..defensePercent)
	resiliencePercent = resilience / 25.0 * LevelRating / 100
	TotalResiliencePercent = TotalResiliencePercent + resiliencePercent
	self:Debug("Resilience %: "..resiliencePercent)

	hitChance = hitChance - defensePercent
	self:Debug("% To Be Hit: "..hitChance)

	critChance = critChance - (defensePercent + resiliencePercent)
	critChance = max(critChance, 0)
	critBonus = critBonus - resiliencePercent * 4
	critBonus = max(critBonus, 0)
	self:Debug("% To Be Crit: "..critChance)
	self:Debug("Crit Bonus: "..critBonus)

	dodgeChance = dodgeChance + defensePercent
	dodgeChance = dodgeChance + dodge / 12.0 * LevelRating / 100
	--Dodge from agility is only accurate at level 70 currently
	dodgeChance = dodgeChance + (agi / 14.7) / 100
	self:Debug("Dodge %: "..dodgeChance)

	--Handle crit reactive effects
	CritReactivePPS = (critChance * HitsPerSecond + hitChance * HitsPerSecond * TotalResiliencePercent)
	if EquipEval:TalentRank(3,18) > 0 then
		local NaturalPerfectionChance = (1 - (1 - min(1, CritReactivePPS))^8)
		local NaturalPerfectionBonus = 0.01 + EquipEval:TalentRank(3,18) * 0.01
		NaturalPerfectionEffect = (1 - NaturalPerfectionBonus * NaturalPerfectionChance - NaturalPerfectionBonus * NaturalPerfectionChance ^ 2 - NaturalPerfectionBonus * NaturalPerfectionChance ^ 3)
	end

	mitTotal = EquipEval:FindMitigation(hitChance, dodgeChance, parryChance, 0, critChance, critBonus, crushChance, armorPercent, NaturalPerfectionEffect, dmgBase)
	local ttlTotal = maxHP / (1 - mitTotal)
	self:Debug("Total Mitigation: "..(mitTotal * 100).."%")


	self:Debug("Mitigation Difference: "..((mitTotal - mitBase) * 100).."%")
	if EquipEval.db.profile["DisplayMitTotal"] < -1 then
		mitTotal = ttlTotal
		mitBase = ttlBase
	end
	return ((mitTotal - mitBase) * 100), (mitTotal * 100)
end





---------------------------------------------------------------------------------------
-- Used to calculate Druid Healing given an info object that came out of ItemBonusLib
--
-- infoObj: already parsed info object
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidHealing(infoObj, CurrentLevel, LevelRating)

	local TotalValue, int, spi, mana, mp5, crit, holycrit, naturecrit, heal, spelldmg, haste, hit, frostdmg, shadowdmg, firedmg, str, _, _, _, _, _, _, agi = EquipEval:CalculateCasterStats(infoObj)
	
	--Handle Special Bonuses
	local _, BonusHealing = EquipEval:GetSpecialBonus("BONUS_HEAL", infoObj)
	local _, BonusManaRegen = EquipEval:GetSpecialBonus("BONUS_MANAREG", infoObj)
	local _, BonusSpellHaste = EquipEval:GetSpecialBonus("BONUS_CR_SPELLHASTE", infoObj)
	local TotalModInt, BaseModInt, AdditionalModInt = EquipEval:GetSpecialBonus("MOD_INT", infoObj)
	local ImpRejuvenation, BaseImpRejuvenation = EquipEval:GetSpecialBonus("IMPREJUVENATION", infoObj)
	TotalValue = TotalValue + (ImpRejuvenation - BaseImpRejuvenation)
	
	if (TotalValue + abs(AdditionalModInt)) == 0 then
		return 0, 0
	end

	local IntRating = eqevIntTableDruid[CurrentLevel]

	local IntModifier = (1 + EquipEval:TalentRank(2,15) * 0.04) * (1 + EquipEval:TalentRank(2,16) * 0.01) * (1 + TotalModInt / 100)
	local SpiModifier = (1 + EquipEval:TalentRank(3,16) * 0.05) * (1 + EquipEval:TalentRank(2,16) * 0.01)
	local StrModifier = (1 + EquipEval:TalentRank(2,16) * 0.01)
	local AgiModifier = (1 + EquipEval:TalentRank(2,16) * 0.01)
	local ManaModifier = 1

	local CastingRegen = EquipEval:TalentRank(3,6) * 0.1

	local itemInt = int * IntModifier + EquipEval:GetTotalIntellect() * AdditionalModInt / 100
	local itemSpi = spi * SpiModifier
	local itemStr = str * StrModifier
	local itemAgi = agi * AgiModifier
	local SpiritEffect = EquipEval:GetDeltaMP5FromStats(itemSpi, itemInt)
	local itemHeal = heal + 0.08 * EquipEval:TalentRank(1,12) * itemInt + 0.50 * EquipEval:TalentRank(2,14) * itemAgi
	if EquipEval:TalentRank(1,12) >= 3 then
		itemHeal = itemHeal + 0.01 * itemInt
	end
	local _, _, treeformActive = GetShapeshiftFormInfo(5);
	if EquipEval:TalentRank(3,20) >= 1 and treeformActive == 1 then
		itemHeal = itemHeal + 0.25 * itemSpi
	end
	local itemMana = (itemInt * 15 + mana) * ManaModifier
	local itemCrit = ((crit / 14.0 * LevelRating) + (itemInt/IntRating) + naturecrit) / 100
	local itemHaste = (haste / 10.0 * LevelRating) / 100
	BonusSpellHaste = (BonusSpellHaste / 10.0 * LevelRating) / 100
	local itemMP5 = mp5
	if EquipEval:TalentRank(1,17) >= 1 then
		itemMP5 = itemMP5 + (EquipEval:TalentRank(1,17) * 0.03 + 0.01) * itemInt
	end
	itemMP5 = itemMP5 + SpiritEffect * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + CastingRegen * SpiritEffect * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100


	local baseHeal = EquipEval:CalculateDruidHealingFromStats(CurrentLevel, LevelRating, 0, BonusManaRegen, 0, 0, 0, BonusHealing, BonusSpellHaste, BaseImpRejuvenation)
	local newHeal, InfoLine = EquipEval:CalculateDruidHealingFromStats(CurrentLevel, LevelRating, itemMana, (itemMP5 + BonusManaRegen), itemSpi, itemInt, itemCrit, (itemHeal + BonusHealing), (itemHaste + BonusSpellHaste), ImpRejuvenation)
	
	if baseHeal == newHeal then
		InfoLine = nil
	end

	return (newHeal - baseHeal), newHeal, InfoLine
end



---------------------------------------------------------------------------------------
-- Used to calculate Druid Healing From Stats
---------------------------------------------------------------------------------------
function EquipEval:CalculateDruidHealingFromStats(CurrentLevel, LevelRating, mana, mp5, itemSpi, itemInt, crit, heal, haste, ImpRejuvenation)
	local InfoLine = "Heals: "
	if UnitPowerType("player") ~= 0 then
		return 0
	end

	local CritModifier = 0.5
	local ManaCostModifier = 1
	local HealingModifier = 1 + EquipEval:TalentRank(3,12) * 0.02

	local totalCrit = GetSpellCritChance(4)
	totalCrit = totalCrit + EquipEval.db.profile["BonusSpellCritChancePercent"]
	totalCrit = max(0, (totalCrit / 100 + crit))
	totalCrit = min(1, totalCrit * EquipEval.db.profile["BurstFactor"])
	self:Debug("Total Crit: "..totalCrit)

	local totalMana = UnitManaMax("player") + mana + EquipEval.db.profile["BonusMana"]
	self:Debug("Total Mana: "..totalMana)

	local RegenBase, RegenCasting = GetManaRegen();
	RegenBase = RegenBase * 5
	RegenCasting = RegenCasting * 5
	local totalMP5 = RegenBase * (1 - EquipEval.db.profile["PercentTimeIn5SecRule"] / 100) + RegenCasting * EquipEval.db.profile["PercentTimeIn5SecRule"] / 100
	totalMP5 = totalMP5 + mp5 + EquipEval:GetMP5FromPotionUse(CurrentLevel) + EquipEval.db.profile["BonusMP5"]
	if CurrentLevel >= 40 then
		totalMP5 = totalMP5 + 4 * EquipEval:GetBaseMP5FromStats(nil, nil, nil, itemSpi, itemInt) * 20 / 360
	end
	self:Debug("Total MP5: "..totalMP5)

	local totalHeal = GetSpellBonusHealing() + heal + EquipEval.db.profile["BonusSpellDamage"]
	self:Debug("Total +Healing: "..totalHeal)

	local totalHaste = GetCombatRatingBonus(CR_HASTE_SPELL) / 100 + haste
	self:Debug("Total Haste: "..totalHaste)


	local TimeFraction = 1
	local CastTime = 0
	local SpellHPS = 0
	local SpellMPS = 0
	local TotalHPS = 0
	local TotalMPS = 0
	local SpellDuration = 0
	local SpellTimeFraction = 0

	local _, _, treeformActive = GetShapeshiftFormInfo(5)
	local moonkinActive = (treeformActive or 0) * EquipEval:TalentRank(1,18)
	treeformActive = (treeformActive or 0) * EquipEval:TalentRank(3,20)

	if moonkinActive == 1 then
		totalCrit = max(0, (totalCrit - 0.05 * EquipEval.db.profile["BurstFactor"]))
	end

	if treeformActive == 1 then
		ManaCostModifier = ManaCostModifier * 0.8
	end

	--Time Spent Not Casting
	TimeFraction = TimeFraction - (EquipEval.db.profile["PercentIdleTimeWhileHealing"] / 100)
	if TimeFraction == 0 then
		return 0
	end


	--Regrowth
	local RegrowthRankName = ""
	local RegrowthHealing = 0
	local RegrowthMana = 0
	local RegrowthCastTime = 0
	local RegrowthDuration = 0
	local RegrowthRating = 0
	local RegrowthMaxTimeFraction = 0
	if CurrentLevel >= 12 and TimeFraction > 0 then
		local RegrowthCritChance = min(1, (totalCrit + 0.1 * EquipEval:TalentRank(3,15) * EquipEval.db.profile["BurstFactor"]))
		local RegrowthManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,14) * 0.03)
		local RegrowthHealingModifier = HealingModifier
		local RegrowthCastTimeModifier = EquipEval:TalentRank(1,13) * 0.5 * RegrowthCritChance
		local RegrowthCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRegrowth["All"].Coefficient)
		local RegrowthOverTimeCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRegrowth["All"].OverTimeCoefficient)
		
		RegrowthRankName, RegrowthHealing, RegrowthMana, RegrowthCastTime, RegrowthDuration, _, _, RegrowthRating = EquipEval:ChooseHeal(EquipEval_SpellTableRegrowth, CurrentLevel, RegrowthManaCostModifier, RegrowthHealingModifier, RegrowthCastTimeModifier, RegrowthCoefficientModifier, RegrowthOverTimeCoefficientModifier, totalHeal, RegrowthCritChance, CritModifier, totalHaste, 0, 0)
		RegrowthMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * RegrowthCastTime / RegrowthDuration
		RegrowthRankName = "Regrowth "..RegrowthRankName
	end

	


	--Rejuvenation
	local RejuvenationRankName = ""
	local RejuvenationHealing = 0
	local RejuvenationMana = 0
	local RejuvenationCastTime = 0
	local RejuvenationDuration = 0
	local RejuvenationRating = 0
	if CurrentLevel >= 4 and TimeFraction > 0 then
		local RejuvenationCritChance = 0
		local RejuvenationManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(1,14) * 0.03)
		local RejuvenationHealingModifier = HealingModifier * (1 + EquipEval:TalentRank(3,10) * 0.05)
		local RejuvenationCastTimeModifier = 0
		local RejuvenationCoefficientModifier = 0
		local RejuvenationOverTimeCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRejuvenation["All"].OverTimeCoefficient)
		local RejuvenationHealingOverTimeBonus = ImpRejuvenation
		
		RejuvenationRankName, RejuvenationHealing, RejuvenationMana, RejuvenationCastTime, RejuvenationDuration, _, _, RejuvenationRating = EquipEval:ChooseHeal(EquipEval_SpellTableRejuvenation, CurrentLevel, RejuvenationManaCostModifier, RejuvenationHealingModifier, RejuvenationCastTimeModifier, RejuvenationCoefficientModifier, RejuvenationOverTimeCoefficientModifier, totalHeal, RejuvenationCritChance, CritModifier, totalHaste, 0, RejuvenationHealingOverTimeBonus)
		RejuvenationMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * RejuvenationCastTime / RejuvenationDuration
		RejuvenationRankName = "Rejuvenation "..RejuvenationRankName
	end


	--Swiftmend --Not Modeled
	--[[
	if EquipEval:TalentRank(3,17) >= 1 and TimeFraction > 0 then
		CastTime = 0
		SpellHPS = RejuvenationHealing
		SpellMPS = 350
		SpellDuration = 15

		CastTime = CastTime / (1 + totalHaste)
		CastTime = max(EquipEval:GetSpellGCD(totalHaste), CastTime)

		SpellHPS = SpellHPS / CastTime
		SpellMPS = ManaCostModifier * SpellMPS / CastTime

		SpellTimeFraction = min((CastTime / SpellDuration * 0.25), TimeFraction)

		TotalHPS = TotalHPS + SpellHPS * SpellTimeFraction
		TotalMPS = TotalMPS + SpellMPS * SpellTimeFraction
		TimeFraction = TimeFraction - SpellTimeFraction

	end
	]]


	--Lifebloom
	local LifebloomRankName = ""
	local LifebloomHealing = 0
	local LifebloomMana = 0
	local LifebloomCastTime = 0
	local LifebloomDuration = 0
	local LifebloomRating = 0
	if CurrentLevel >= 64 and TimeFraction > 0 then
		local LifebloomCritChance = totalCrit
		local LifebloomManaCostModifier = ManaCostModifier
		local LifebloomHealingModifier = HealingModifier
		local LifebloomCastTimeModifier = 0
		local LifebloomCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRejuvenation["All"].Coefficient)
		local LifebloomOverTimeCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRejuvenation["All"].OverTimeCoefficient)
		
		LifebloomRankName, LifebloomHealing, LifebloomMana, LifebloomCastTime, LifebloomDuration, _, _, LifebloomRating = EquipEval:ChooseHeal(EquipEval_SpellTableLifebloom, CurrentLevel, LifebloomManaCostModifier, LifebloomHealingModifier, LifebloomCastTimeModifier, LifebloomCoefficientModifier, LifebloomOverTimeCoefficientModifier, totalHeal, LifebloomCritChance, CritModifier, totalHaste, 0, 0)
		LifebloomMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * LifebloomCastTime / LifebloomDuration
		LifebloomRankName = "Blooming Lifebloom"
	end
	
	
	--Rolling Lifebloom
	local RollingLifebloomRankName = ""
	local RollingLifebloomHealing = 0
	local RollingLifebloomMana = 0
	local RollingLifebloomCastTime = 0
	local RollingLifebloomDuration = 0
	local RollingLifebloomRating = 0
	if CurrentLevel >= 64 and TimeFraction > 0 then
		local LifebloomCritChance = totalCrit
		local LifebloomManaCostModifier = ManaCostModifier
		local LifebloomHealingModifier = HealingModifier
		local LifebloomCastTimeModifier = 0
		local LifebloomCoefficientModifier = 0
		local LifebloomOverTimeCoefficientModifier = (EquipEval:TalentRank(3,19) * 0.04) * (EquipEval_SpellTableRejuvenation["All"].OverTimeCoefficient)
		
		RollingLifebloomRankName, RollingLifebloomHealing, RollingLifebloomMana, RollingLifebloomCastTime, RollingLifebloomDuration, _, _, RollingLifebloomRating = EquipEval:ChooseHeal(EquipEval_SpellTableLifebloomStacked, CurrentLevel, LifebloomManaCostModifier, LifebloomHealingModifier, LifebloomCastTimeModifier, LifebloomCoefficientModifier, LifebloomOverTimeCoefficientModifier, totalHeal, LifebloomCritChance, CritModifier, totalHaste, 0, 0)
		RollingLifebloomMaxTimeFraction = (1 + EquipEval.db.profile["NumberOfAdditionalTargets"]) * RollingLifebloomCastTime / RollingLifebloomDuration
		RollingLifebloomRankName = "Rolling Lifebloom"
	end
	
	--Choose Lifebloom Method
	if RollingLifebloomRating > LifebloomRating then
		LifebloomRankName = RollingLifebloomRankName
		LifebloomHealing = RollingLifebloomHealing
		LifebloomMana = RollingLifebloomMana
		LifebloomCastTime = RollingLifebloomCastTime
		LifebloomDuration = RollingLifebloomDuration
		LifebloomRating = RollingLifebloomRating
	end


	--Tranquility Not Modeled Yet

	--Healing Touch
	local HTRankName = ""
	local HTHealing = 0
	local HTMana = 0
	local HTCastTime = 0
	local HTRating = 0
	local HTMaxTimeFraction = 0
	if treeformActive == 0 and CurrentLevel >= 1 and TimeFraction > 0 then
		local HealingTouchCritChance = totalCrit
		local HealingTouchManaCostModifier = ManaCostModifier * (1 - EquipEval:TalentRank(3,9) * 0.02) * (1 - EquipEval:TalentRank(1,14) * 0.03)
		local HealingTouchHealingModifier = HealingModifier
		local HealingTouchCastTimeModifier = (EquipEval:TalentRank(3,3) * 0.1 + EquipEval:TalentRank(1,13) * 0.5 * totalCrit)
		local HealingTouchCoefficientModifier = (EquipEval:TalentRank(3,14) * 0.1)
		local HealingTouchOverTimeCoefficientModifier = 0
	
		HTRankName, HTHealing, HTMana, HTCastTime, _, _, _, HTRating = EquipEval:ChooseHeal(EquipEval_SpellTableHealingTouch, CurrentLevel, HealingTouchManaCostModifier, HealingTouchHealingModifier, HealingTouchCastTimeModifier, HealingTouchCoefficientModifier, HealingTouchOverTimeCoefficientModifier, totalHeal, HealingTouchCritChance, CritModifier, totalHaste, 0, 0)
		HTMaxTimeFraction = 1
		HTRankName = "Healing Touch "..HTRankName
	end
	
	
	while TimeFraction > 0 do
		local MaxRating = max(RegrowthRating, RejuvenationRating, LifebloomRating, HTRating)
		local RatingTotal = RegrowthRating + RejuvenationRating + LifebloomRating + HTRating
		RatingTotal = max(MaxRating, (RatingTotal - MaxRating))
		local MaxTimeFraction = 0
		
		if MaxRating <= 0 then
			TimeFraction  = 0
			break
		end
		
		
		if MaxRating == LifebloomRating then
			MaxTimeFraction = LifebloomMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
		
			TotalHPS = TotalHPS + LifebloomHealing / LifebloomCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + LifebloomMana / LifebloomCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..LifebloomRankName.." "..(MaxTimeFraction * 100).."% "..MaxRating.." / "..RatingTotal)
			InfoLine = InfoLine.."LB, "
			LifebloomRating = 0
		elseif MaxRating == RegrowthRating then
			MaxTimeFraction = RegrowthMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + RegrowthHealing / RegrowthCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + RegrowthMana / RegrowthCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..RegrowthRankName.." "..(MaxTimeFraction * 100).."% "..MaxRating.." / "..RatingTotal)
			InfoLine = InfoLine.."Regrowth, "
			RegrowthRating = 0
		elseif MaxRating == RejuvenationRating then
			MaxTimeFraction = RejuvenationMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + RejuvenationHealing / RejuvenationCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + RejuvenationMana / RejuvenationCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..RejuvenationRankName.." "..(MaxTimeFraction * 100).."% "..MaxRating.." / "..RatingTotal)
			InfoLine = InfoLine.."Rejuv, "
			RejuvenationRating = 0
		elseif MaxRating == HTRating then
			MaxTimeFraction = HTMaxTimeFraction
			MaxTimeFraction = min(MaxTimeFraction, (TimeFraction * MaxRating / RatingTotal))
			
			TotalHPS = TotalHPS + HTHealing / HTCastTime * MaxTimeFraction
			TotalMPS = TotalMPS + HTMana / HTCastTime * MaxTimeFraction
			TimeFraction = TimeFraction - MaxTimeFraction
			self:Debug("Add Spell: "..HTRankName.." "..(MaxTimeFraction * 100).."% "..MaxRating.." / "..RatingTotal)
			InfoLine = InfoLine.."HT, "
			HTRating = 0
		else
			TimeFraction = 0
		end
	end
	
	InfoLine = string.sub(InfoLine, 1, #InfoLine - 2)
	if not EquipEval.db.profile["ChosenHealsDisplayed"] then
		InfoLine = nil
	end

	if EquipEval.db.profile["ManaVolatilityDampingFactor"] < 1 and EquipEval.db.profile["ManaVolatilityDampingFactor"] >= 0 then
		totalMana = (totalMana ^ EquipEval.db.profile["ManaVolatilityDampingFactor"]) * 2 ^ ((10 - EquipEval.db.profile["ManaVolatilityDampingFactor"] * 10) * (log(UnitManaMax("player")) / (10 * log(2))))
		self:Debug("Damped Total Mana: "..totalMana)
	end

	local FightLength =  (totalMana / (TotalMPS - totalMP5 / 5))
	if EquipEval.db.profile["AutoSetHealingFightTotalMPS"] and EquipEval.db.profile["AutoSetHealingVars"] then
		FightLength = (FightLength + totalMana / -EquipEval.db.profile["AutoSetHealingFightTotalMPS"]) / 2
	end

	FightLength = min((20 * 60), FightLength)
	if FightLength < 0 then
		FightLength = 20 * 60
	end
	self:Debug("Fight Length: "..FightLength)

	self:Debug("Total HPS: "..TotalHPS)
	self:Debug("Total MPS: "..TotalMPS)
	
	if EquipEval.db.profile["HealingDurationDisplayed"] then
		InfoLine = EquipEval:AddStringToTable("Healing Duration: "..format("%.2f", (FightLength / 60)).." min.", InfoLine)
	end
	
	if EquipEval.db.profile["DisplayHealingTotal"] < -1 then
		TotalHPS = TotalHPS * FightLength
	end

	return TotalHPS, InfoLine
end






