--Gui for EpicMusicPlayer  by yess

local playerframe;
local guitext;
local timeframe
local timeframewidth = 1
local timeframestep = 0
local exchangecount = 0
local displaysong = true;
local songlength;
local currartist 
local currsongname
local playbutton
local randombutton
local volumechanged = false
local tooltip = nil
local hasartist = false;

EpicMusicPlayerGui = LibStub("AceAddon-3.0"):NewAddon("EpicMusicPlayerGui", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("EpicMusicPlayer")

local options={
			name=L["Gui"],
			order = 4,
			type="group",
			args={
				showgui = {
			           type = "toggle",
			           order = 6,
					   name = L["Show Gui"],
			           desc = L["Toggle show gui"],
			           get = function(name)
							return EpicMusicPlayer:IsPlayerGui()
					   end,
					   set = function(name)
							EpicMusicPlayer:TogglePlayerGui()
						end,
			       },
				minimap = {
			           type = "toggle",
			           order = 6,
					   name = L["Minimap Button"],
			           desc = L["Toggle show minimap button"],
			           get = function(name)
							return EpicMusicPlayer:IsMinimap()
					   end,
					   set = function(name)
							EpicMusicPlayer:ToggleMinimap()
						end,
			     },
				 scale = {
		            type = 'range',
					order = 8,
					name = L["Gui Size"],
		            desc = L["Adjust the size of the gui"],
		            step = 0.1,
					min = 0.1,
					max = 5,
					get = function() 
						return EMPGUI:GetScale()
					end,
		            set =  function(info,val) 
						EpicMusicPlayer.db.char.guiscale = val
						EMPGUI:SetScale(val)
					end,
				},
			}
	}

function EpicMusicPlayerGui:OnInitialize()
	if(EMPGUI == nil)then
		self:CreateGuiFrame()
	end
	
	if(EpicMusicPlayer.db.profile.minimapbutton)then
		EpicMusicPlayerGui:CreateMinimapButton()
	end

	self:RegisterMessage("EMPUpdateStop")
	self:RegisterMessage("EMPUpdatePlay")
	self:RegisterMessage("EMPUpdateTime")
	self:RegisterMessage("EMPUpdateVolume")
	self:RegisterMessage("EMPUpdateRandom")
	EpicMusicPlayer:AddOptions("gui",options)
end

function EpicMusicPlayerGui:OnEnable(first)	
	if(EMPGUI == nil)then
		self:CreateGuiFrame()
	end
	self:RegisterMessage("EMPUpdateStop")
	self:RegisterMessage("EMPUpdatePlay")
	self:RegisterMessage("EMPUpdateTime")
	self:RegisterMessage("EMPUpdateRandom")
	
	self:SendMessage("EMPGuiLoaded")
	
end

function EpicMusicPlayerGui:OnDisable()
    playerframe:Hide();
	EMPGUI = nil
	self:UnregisterAllEvents("EpicMusicPlayerGui")
end

function EpicMusicPlayerGui:ToggleMinimap()
	if(EMPMINIMAPBUTTON)then
		if(EMPMINIMAPBUTTON:IsVisible())then
			EMPMINIMAPBUTTON:Hide()
		else
			EMPMINIMAPBUTTON:Show()
		end
	else
		self:CreateMinimapButton()
	end
end

-----------------------------------------------------------------------------------------------------------------------------
-- Update functions 
------------------------------------------------------------------------------------------------------------------------------
function EpicMusicPlayerGui:EMPUpdateTime(event)
	timeframewidth = timeframewidth + timeframestep
	exchangecount = exchangecount +1
	timeframe:SetWidth(timeframewidth)
	
	if(not volumechanged)then
		if(exchangecount > 3) then
			if(hasartist)then
				if(displaysong)then
					guitext:SetText(currsongname)
				else
					guitext:SetText(currartist)
				end
				displaysong = not displaysong
				exchangecount = 0
			end
		end
	end
end

function EpicMusicPlayerGui:EMPUpdateVolume(event, voltype, vol)	
	if(voltype == "music")then
		volumechanged = true
		guitext:SetText(L["Music volume: "]..math.floor((vol*100)).."%")
	elseif(voltype == "sound")then
		volumechanged = true
		guitext:SetText(L["Effects vol.: "]..math.floor((vol*100)).."%")
	elseif(voltype == "done")then
		volumechanged = false
		if(playing)then
			self:EMPUpdateTime()
		else
			self:EMPUpdateStop()
		end
	end
end

function EpicMusicPlayerGui:EMPUpdatePlay(event, artist, songname, length)
	songlength = length
	currsongname = songname
	if(artist=="")then
		hasartist = false
	else
		hasartist = true
	end
	currartist = "|cffa335ee"..artist
	displaysong = true
	playing = true;
		
	exchangecount = 0
	timeframewidth = 1
	timeframe:Show()
	timeframe:SetWidth(timeframewidth)
	
	timeframestep = (playerframe:GetWidth()-20) / songlength 
	guitext:SetText(songname)
	playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-stop.tga")
	playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-stop-p.tga")
	if(tooltip) then
		self:ShowTooltip(tooltip)
	end
end

function EpicMusicPlayerGui:EMPUpdateStop(event)
	timeframe:Hide()
	playing = false;
	guitext:SetText(L["Stopped"])
	timeframestep = 0
	playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play.tga")
	playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play-p.tga")
	if(tooltip) then
		self:ShowTooltip(tooltip)
	end
end

function EpicMusicPlayerGui:EMPUpdateRandom(event, val)
	if(val)then
		randombutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomon.tga")
		randombutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomon-p.tga")
	else
		randombutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomoff.tga")
		randombutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomoff-p.tga")
	end
	
end

function EpicMusicPlayerGui:Toggle()
	if(EMPGUI)then
		if(EMPGUI:IsShown()) then
			EMPGUI:Hide()
			if(EpicMusicDancer)then
				if(EpicMusicDancer:IsGuiToggle())then
					EpicMusicDancer:Hide()
				end
			end
	    else
	        EMPGUI:Show()
			if(EpicMusicDancer)then
				if(EpicMusicDancer:IsGuiToggle())then
					EpicMusicDancer:Show()
				end
			end
	    end
	end
end


function EpicMusicPlayerGui:ShowTooltip(parent)
	local emp = EpicMusicPlayer
	GameTooltip:SetOwner(parent, "ANCHOR_BOTTOMRIGHT");
	
	if(EpicMusicPlayer.Playing)then		
		GameTooltip:SetText("|cffa335ee"..
			EpicMusicPlayer:GetCurrentArtistName().."|r  |cffffffee"..EpicMusicPlayer:GetCurrentSongName())
		local album = EpicMusicPlayer:GetCurrentAlbumName();
		if(album=="")then
		else
			GameTooltip:AddLine("|cffffffee"..L["Album: "]..album)
		end
		
		GameTooltip:AddLine("|cffffffee"..L["List: "]..EpicMusicPlayer:GetListName())
		GameTooltip:AddLine("|cffffffee"..L["Length: "]..EpicMusicPlayer:GetTimeSTring(songlength))
		GameTooltip:Show()
	else
		GameTooltip:SetText(L["Stopped"], 1,1,1)
		GameTooltip:AddLine(L["Left Click"].." - "..emp.controlslist[emp.db.profile.controlset.left])	
		GameTooltip:AddLine(L["Middle Click"].." - "..emp.controlslist[emp.db.profile.controlset.middle])
		GameTooltip:AddLine(L["Right Click"].." - "..emp.controlslist[emp.db.profile.controlset.right])
		GameTooltip:Show()
	end
end

------------------------------------------------------------------------------------------------------------------------------
-- Create gui frame
------------------------------------------------------------------------------------------------------------------------------
function EpicMusicPlayerGui:CreateGuiFrame()
	
	playerframe = CreateFrame("PlayerModel","EMPGUI",UIParent)
	playerframe:SetWidth(150)
	playerframe:SetHeight(50)
	--frame background
	
	playerframe:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
	                                        edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
	                                        tile = true, tileSize = 16, edgeSize = 16, 
	                                        insets = { left = 4, right = 4, top = 4, bottom = 4 }});
	playerframe:SetBackdropColor(0,0,0,1);
	playerframe:SetPoint("CENTER",0,0)
	playerframe:Show()
	
	playerframe:EnableMouse(true); 

	playerframe:SetMovable(true) 

	playerframe:RegisterForDrag("LeftButton");
    --playerframe:RegisterForClicks("RightButtonUp")

	playerframe:SetScript("OnDragStart", 
	    function()
			this:StartMoving()
			this.isMoving = true
		end
	)
	playerframe:SetScript("OnDragStop", 
	    function()
			this:StopMovingOrSizing()
			this.isMoving = false
		end
	)
	
	timeframe = CreateFrame("Frame",nil,EMPGUI)
	timeframe.timebar = timeframe:CreateTexture()
	--timeframe:SetAllPoints(playerframe)
	timeframe.timebar:SetAllPoints(timeframe)
	timeframe.timebar:SetTexture(0.6,0.2,0.8,0.8)
	timeframe:SetWidth(0)
	timeframe:SetHeight(2)
	timeframe:SetPoint("BOTTOMLEFT",8,6)
	
	
	local textframe = CreateFrame("Button",nil,EMPGUI)
	textframe:SetWidth(playerframe:GetWidth()-20)
	textframe:SetHeight(16)
	textframe:SetPoint("TOP",0,-5)
	
	textframe:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp","Button4Up","Button5Up")
	--textframe:SetScript("OnClick",EpicMusicPlayer:GetDisplayClickHandler())
	textframe:SetScript("OnClick", 
	    function()
			--if(arg1 == "RightButton")then
			--	EpicMusicPlayer:OnDisplayRightClick(this)
			--else
				EpicMusicPlayer:OnDisplayClick(this)
			--end
		end
	)
	
	
	guitext = textframe:CreateFontString()
	local fontSize = 12
	guitext:SetFont("Interface\\AddOns\\EpicMusicPlayer\\font1.ttf", fontSize);
	guitext:SetTextColor(1,1,1,1)
	--s:SetJustifyH("LEFT");
	guitext:SetText(EpicMusicPlayer:GetCurrentSongName())
	guitext:SetAllPoints(textframe)

	playerframe:EnableMouseWheel(1) 
	playerframe:SetScript("OnMouseWheel", 
		function()
			EpicMusicPlayer:DisplyScrollHandler()
		end
    )
	
	playbutton = CreateFrame("Button","EMPPLAYBUTTON",EMPGUI)
	playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play.tga")
	--playbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play-p.tga")

	playbutton:SetWidth(16) 
	playbutton:SetHeight(16)
	playbutton:SetPoint("BOTTOMLEFT",playbutton:GetWidth()+20,10)
	playbutton:EnableMouse(true); 
	playbutton:RegisterForClicks("LeftButtonUp")



	playbutton:SetScript("OnClick", 
	    function()
			EpicMusicPlayer:TogglePlay()
		end
	)

	
	local lastbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	lastbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-last.tga")
	--nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	lastbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-last-p.tga")

	lastbutton:SetWidth(16)
	lastbutton:SetHeight(16)
	lastbutton:SetPoint("BOTTOMLEFT",-playbutton:GetWidth(),0)
	lastbutton:EnableMouse(true); 
	lastbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	lastbutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:PlayLast()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:SetLastModel()
				end
			end
		end
	)
	
	local nextbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	nextbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-next.tga")
	--nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	nextbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-next-p.tga")

	nextbutton:SetWidth(16)
	nextbutton:SetHeight(16)
	nextbutton:SetPoint("BOTTOMLEFT",(playbutton:GetWidth()),0)
	nextbutton:EnableMouse(true); 
	nextbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	nextbutton:SetScript("OnClick", 
		function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer.db.profile.loopsong = false
				EpicMusicPlayer:PlayNext()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:SetNextModel()
				end
			end
		end
	)
	
	local listbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	listbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-list.tga")
	--nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	listbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-list-p.tga")

	listbutton:SetWidth(16)
	listbutton:SetHeight(16)
	listbutton:SetPoint("BOTTOMLEFT",(playbutton:GetWidth()*5),0)
	listbutton:EnableMouse(true); 
	listbutton:RegisterForClicks("LeftButtonUp")

	listbutton:SetScript("OnClick", 
	    function()
			EpicMusicPlayer:ToggleList()
		end
	)
	
	randombutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	EpicMusicPlayerGui:EMPUpdateRandom(event, EpicMusicPlayer:IsRandom()) --set texture according to random status

	randombutton:SetWidth(16)
	randombutton:SetHeight(16)
	randombutton:SetPoint("BOTTOMLEFT",(playbutton:GetWidth()*3),0)
	randombutton:EnableMouse(true); 
	randombutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	randombutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:ToggleRandom()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:ToggleShow()
				end
			end
		end
	)
	
	confbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	confbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-conf.tga")
	confbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-conf-p.tga")

	confbutton:SetWidth(16)
	confbutton:SetHeight(16)
	confbutton:SetPoint("BOTTOMLEFT",(playbutton:GetWidth()*4),0)
	confbutton:EnableMouse(true); 
	confbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	confbutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:ToggleMute()
			else
				EpicMusicPlayer:ShowConfig()
			end
		end
	)
	if(EpicMusicPlayer.db.char.guiscale)then
		EMPGUI:SetScale(EpicMusicPlayer.db.char.guiscale)
	end
end

function EpicMusicPlayerGui:CreateMinimapButton()
	
	---------------------------------------
	minibutton = CreateFrame("Button","EMPMINIMAPBUTTON",Minimap)
	minibutton:SetWidth(32)
	minibutton:SetHeight(32)
	minibutton:SetFrameStrata("LOW")
	minibutton:SetPoint("TOP", "Minimap", "LEFT", -8, 0);
	
	minibutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-minimap.tga")
	minibutton:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	minibutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\emp-minimap-p.tga")
	
	--minibutton:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp")
	minibutton:RegisterForClicks("AnyUp")
	
	minibutton:SetScript("OnClick", 
	    function()
			--if(arg1 == "RightButton")then
			--	EpicMusicPlayer:OnDisplayRightClick(this)
			--else
				EpicMusicPlayer:OnDisplayClick(this)
			--end
		end
	)
	
	minibutton:Show()
	minibutton:EnableMouse(true)
	minibutton:SetMovable(true) 
	minibutton:RegisterForDrag("RightButton");
	
	minibutton:SetScript("OnDragStart", 
	    function()
			this:StartMoving()
			this.isMoving = true
		end
	)
	minibutton:SetScript("OnDragStop", 
	    function()
			this:StopMovingOrSizing()
			this.isMoving = false
		end
	)
	
	minibutton:SetScript("OnEnter", 
	    function()
			tooltip = this
			EpicMusicPlayerGui:ShowTooltip(this)			
		end
	)
	
	minibutton:SetScript("OnLeave", 
	    function()
			tooltip = nil
			GameTooltip:Hide();
		end
	)
	
	minibutton:EnableMouseWheel(true) 
	minibutton:SetScript("OnMouseWheel", 
		function()
			EpicMusicPlayer:DisplyScrollHandler()
		end
    )
end