--[[ Local                                                            ]]
local LibStub = _G["LibStub"];
assert(LibStub, "Error, Enhancer requires LibStub");

--[[ Create                                                           ]]
local L = LibStub("AceLocale-3.0"):NewLocale("Enhancer", "enUS", true);
if (not L) then return; end

--[[ Add Stuff                                                        ]]
local tags = "%element%, %name%";

-- Just vanity stuff
L["__URL__"] = "http://files [dot] wowace [dot] com/Enhancer";
L["__EMAIL__"] = "dennis [dot] hafstrom [at] gmail [dot] com";

-- _
L["_print"] = "|cff" .. "ffdc5f" .. "Enhancer" .. "|r" .. ":";
L["_debug"] = "|cff" .. "ff7777" .. "Enhancer Debug [%s]" .. "|r" .. ":"; -- %s = time

L["Totem gsub"] = "Totem";

-- slash
L["/Enhancer"] = "Enhancer";
L["/Enh"] = "Enh";
L["/Enhance"] = "Enhance";

-- cmd Groups
L["cmd name Enhancer"] = "Enhancer";
L["cmd name quickcast"] = "Quick Cast";
L["cmd name buttonsettings"] = "Button Settings";
L["cmd name textsettings"] = "Text Settings";
L["cmd name layout"] = "Layout";
L["cmd name dev tools"] = "Dev Tools";
L["cmd name extras"] = "Extras";
L["cmd name disable"] = "Disabled Buttons";

-- cmd Headers
L["Earth macro text"] = "Earth macro totem (cast on left-click, set to blank to use queue-system)";
L["Fire macro text"] = "Fire macro totem (cast on left-click, set to blank to use queue-system)";
L["Water macro text"] = "Water macro totem (cast on left-click, set to blank to use queue-system)";
L["Air macro text"] = "Air macro totem (cast on left-click, set to blank to use queue-system)";
L["cmd header Measures"] = "Measures";
L["cmd header Opacity"] = "Opacity";
L["cmd header Top"] = "Top";
L["cmd header Center"] = "Center";
L["cmd header Bottom"] = "Bottom";
L["cmd header Messages"] = "Messages";
L["cmd name Contact"] = "Contact";
L["cmd name Misc"] = "Misc";

-- cmd Normal
L["cmd name Config"] = "Config";
L["cmd desc Config"] = "Open config";
L["cmd name locked"] = "Lock";
L["cmd desc locked"] = "Prevents buttons from accidently moving";
L["cmd name tooltip"] = "Tooltips";
L["cmd desc tooltip"] = "Show tooltips when hovering over buttons";
L["cmd name debug"] = "Debug";
L["cmd desc debug"] = "Show debug messages";
L["cmd name hideblizz"] = "Hide Blizzframe";
L["cmd desc hideblizz"] = "Toggle showing of Blizzard totem frames";
L["cmd name btnwidth"] = "Size";
L["cmd desc btnwidth"] = "Sets width/height for buttons";
L["cmd name activealpha"] = "Active";
L["cmd desc activealpha"] = "Opacity for the buttons when they are active";
L["cmd name inactivealpha"] = "Inactive";
L["cmd desc inactivealpha"] = "Opacity for the buttons when they are inactive (during combat)";
L["cmd name oocalpha"] = "OOC";
L["cmd desc oocalpha"] = "Opacity for the buttons when they are inactive and you are out of combat";
L["cmd name font"] = "Font";
L["cmd desc font"] = "Set wich font to use";
L["cmd name fontsize"] = "Size";
L["cmd desc fontsize"] = "Size for the font";
L["cmd name fontflags"] = "Outline";
L["cmd desc fontflags"] = "Outline for the font";
L["cmd name natural"] = "Lost";
L["cmd desc natural"] = "Text to display when a totem is lost naturally (range/duration/etc), tags: " .. tags;
L["cmd name slain"] = "Slain";
L["cmd desc slain"] = "Text to display when a totem is slain, tags: " .. tags;
L["cmd name below"] = "Below";
L["cmd desc below"] = "Position frames centered below player";
L["cmd name xpos"] = "XPos";
L["cmd desc xpos"] = "Position frames as an X around player";
L["cmd name resetdb"] = "Reset";
L["cmd desc resetdb"] = "Resets all settings from current profile";
L["cmd name news"] = "News";
L["cmd desc news"] = "Display the news window in case you missed something really important in there ;)";
L["cmd name email"] = "E-mail/MSN";
L["cmd desc email"] = "E-mail/MSN (just copy paste to drop me a line) ^^";
L["cmd name website"] = "Website";
L["cmd desc website"] = "Website (and issue tracker if available)";
L["cmd name showPurged"] = "Show Purge";
L["cmd desc showPurged"] = "Show what was purged in the output";
L["cmd name showPulses"] = "Show Pulses";
L["cmd desc showPulses"] = "Graphically grow button on pulses";
L["cmd name topTextHidden"] = "Hide Top";
L["cmd desc topTextHidden"] = "Hides the text at the top";
L["cmd name centerTextHidden"] = "Hide Center";
L["cmd desc centerTextHidden"] = "Hides the text at the center";
L["cmd name bottomTextHidden"] = "Hide Bottom";
L["cmd desc bottomTextHidden"] = "Hides the text at the bottom";
L["cmd name topDisplay"] = "Top Display";
L["cmd desc topDisplay"] = "What to display as the top text (updates on cast or ReloadUI /rl)";
L["cmd name centerDisplay"] = "Center Display";
L["cmd desc centerDisplay"] = "What to display as the center text";
L["cmd name bottomDisplay"] = "Bottom Display";
L["cmd desc bottomDisplay"] = "What to display as the bottom text";
L["cmd name purgeAnnounce"] = "Announce Purge";
L["cmd desc purgeAnnounce"] = "Set where to announce what you purge";
L["cmd name disableOmniCC"] = "Disable OmniCC";
L["cmd desc disableOmniCC"] = "Disables OmniCC for Enhancer Frames (if you use center counter for something else)";

-- Select options
L["None"] = true;
L["Outline"] = true;
L["Thick Outline"] = true;

L["Cast: Totem"] = true;
L["Totem only"] = true;
L["Pulse (if avail)"] = true;
L["Estimated life left"] = true;
L["Duration of Totem"] = true;
L["Nothing"] = true;

L["Announce to raidwarning"] = true;
L["Announce to raid"] = true;
L["Announce to party"] = true;
L["Announce to smart"] = true;
L["Announce to smart with raidwarning"] = true;
L["Announce to nowhere"] = true;

-- Purge
L["Purge Sink"] = "Purged %s from %s (%s)";
L["Purge Group"] = "I just purged %s from %s (%s)";

-- Elements
L["Earth"] = true;
L["Fire"] = true;
L["Air"] = true;
L["Water"] = true;

-- Alerts
L["totem lost"] = "%element% totem [%name%] lost";
L["totem slain"] = "%element% totem [%name%] SLAIN!!";
L["%s totem lost"] = true;
L["%s totem was SLAIN!!"] = true;

-- News stuff
L["Enhancer"] = true;
L["ENHANCER"] = true;
L["Command"] = true;
L["Website"] = true;
L["E-mail"] = true;
L["News Disclaimer"] = "News is only shown on first load!";
L["'/%s %s' or '/%s %s'"] = true;