--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer");
local LSM3 = LibStub("LibSharedMedia-3.0");

--local legoDefaults = { width = 35, height = 35, text = nil, icon = nil, x = nil, y = nil, anchor = nil, showIcon = nil, showText = false, hidden = nil, savedFields = nil, bg = optionsBg, noResize = true };
local legoDefaults = { bg = optionsBg, noResize = true };

local defaults =
{
	profile = {
		totemSettings = {
			[FIRE_TOTEM_SLOT] = AddOn.table_copy(legoDefaults),
			[EARTH_TOTEM_SLOT] = AddOn.table_copy(legoDefaults),
			[WATER_TOTEM_SLOT] = AddOn.table_copy(legoDefaults),
			[AIR_TOTEM_SLOT] = AddOn.table_copy(legoDefaults),
		},
		
		btnSize = 35,
		btnActiveAlpha = 1.0,
		btnInactiveAlpha = 0.7,
		btnOocAlpha = 0.3,
		
		topTextHidden = false,
		topFontID = "Friz Quadrata TT",
		topFontIDTTF = [[Fonts\FRIZQT__.ttf]],
		topFontSize = 12,
		topFontFlags = "OUTLINE",
		topDisplay = "Cast",
		
		centerTextHidden = false,
		centerFontID = "Adventure",
		centerFontIDTTF = [[Interface\AddOns\Enhancer\fonts\Adventure.ttf]],
		centerFontSize = 16,
		centerFontFlags = "OUTLINE",
		centerDisplay = "Pulse",
		
		bottomTextHidden = false,
		bottomFontID = "Adventure",
		bottomFontIDTTF = [[Interface\AddOns\Enhancer\fonts\Adventure.ttf]],
		bottomFontSize = 12,
		bottomFontFlags = "OUTLINE",
		bottomDisplay = "Time",
		
		quickCast = {
			[FIRE_TOTEM_SLOT] = "",
			[EARTH_TOTEM_SLOT] = "",
			[WATER_TOTEM_SLOT] = "",
			[AIR_TOTEM_SLOT] = "",
		},
		
		msgTotemLost = L["totem lost"],
		msgTotemSlain = L["totem slain"],
		
		locked = true,
		tooltip = false,
		hideBlizz = true,
		disableOmniCC = true,
		newsItem = 0,
		sinkOptions = {},
		
		showPurged = true,
		purgeAnnounce = "",
		showPulses = true,
	},
};

defaults.profile.totemSettings[EARTH_TOTEM_SLOT].x = 130;
defaults.profile.totemSettings[EARTH_TOTEM_SLOT].y = 130;
defaults.profile.totemSettings[FIRE_TOTEM_SLOT].x = -130;
defaults.profile.totemSettings[FIRE_TOTEM_SLOT].y = 130;
defaults.profile.totemSettings[WATER_TOTEM_SLOT].x = 130;
defaults.profile.totemSettings[WATER_TOTEM_SLOT].y = -130;
defaults.profile.totemSettings[AIR_TOTEM_SLOT].x = -130;
defaults.profile.totemSettings[AIR_TOTEM_SLOT].y = -130;

function AddOn:RegisterDB()
	-- Check old db here and use those settings as default if they exist???
	
	self.db = LibStub("AceDB-3.0"):New("EnhDB", defaults);
end

--[[ Load up settings from old Enhancer!                              ] ]
local oldEnhancer = AceLibrary("AceAddon-2.0"):new("AceDB-2.0");
oldEnhancer:RegisterDB("EnhancerDB", nil, "class");
local oldEnhancerDefaults = {
	locked = true,
	framesize = 35,
	
	combatinactiveAlpha = (3 / 10),
	oocinactiveAlpha = 0,
	combatAlpha = 1,
	oocombatAlpha = (7 / 10),
	specialAlpha = true,
	killYards = 150,
	yardKill = true,
	
	playSound = false,
	growingPulse = true,
	borderPulse = false,
	buffIndicator = "noindication",
	snap = true,
	roman = true,
	blizzTime = false,
	blizzSsec = true,
	warnExpire = true,
	warnDeath = true,
	warnSlain = true,
	warnTime = 7,
	purgeAnnounce = false,
	purgeAnnounceRaidOnly = false,
	
	EPZero = true,
	AEP = true,
	AEPH = true,
	WAEP = true,
	HEP = false,
	DEP = false,
	DEPH = false,
	EIP = true,
	EPGems = {
		maxQuality = 3,
		maxQualityNonEpic = 0,
		metaGems = true,
	},
	EPGuesstimates = true,
	EPGemGuesstimates = false,
	EPExpertiseHack = false,
	
	aboveFontID = "Friz Quadrata TT",
	aboveFontName = [ [Fonts\FRIZQT__.ttf] ],
	aboveFontSize = 12,
	aboveFontFlags = "OUTLINE",
	
	centerFontID = "Adventure",
	centerFontName = [ [Interface\AddOns\Enhancer\fonts\Adventure.ttf] ],
	centerFontSize = 16,
	centerFontFlags = "OUTLINE",
	
	belowFontID = "Adventure",
	belowFontName = [ [Interface\AddOns\Enhancer\fonts\Adventure.ttf] ],
	belowFontSize = 12,
	belowFontFlags = "OUTLINE",
	
	gaugeFontID = "Friz Quadrata TT",
	gaugeFontName = [ [Fonts\FRIZQT__.ttf] ],
	gaugeFontSize = 10,
	gaugeFontFlags = "OUTLINE",
	
	Gauges = {
		AttackPower = {
			Width = 32,
			Height = 96,
			TrueMax,
		},
	},
	
	AEPNumbers = {
		ATTACKPOWER = 1,
		STR = 2,
		AGI = (174 / 100),
		STA = 0,
		CR_CRIT = (197 / 100),
		CR_HIT = (134 / 100),
		CR_HASTE = (128 / 100),
		CR_EXPERTISE = (248 / 100),  -- Multiply hit rating AEP by 1.8 if you assume that the mob will never cast and never parry.
		CR_RESILIENCE = 0,
		IGNOREARMOR = (22 / 100),
		MH_DPS = (903 / 100),
		OH_DPS = (37 / 10),
	},
	HEPNumbers = {
		HEAL = (10 / 10),
		INT = (8 / 10),
		SPI = (0 / 10), --1
		STA = (0 / 10),
		CR_SPELLCRIT = (1 / 10),
		CR_SPELLHASTE = (0 / 10), --3
		CR_RESILIENCE = (0 / 10),
		MANAREG = (27 / 10),
	},
	DEPNumbers = {
		DMG = (10 / 10),
		INT = (1 / 10),
		SPI = (0 / 10), --1,
		STA = (0 / 10),
		CR_SPELLCRIT = (2 / 10),
		CR_SPELLHIT = (6 / 10),
		CR_SPELLHASTE = (0 / 10), --3,
		CR_RESILIENCE = (0 / 10),
		MANAREG = (15 / 10),
	},
	
	startAnnounceDisabled = false,
	
	bonus = {},
	
	nagShit = {
		WF3Sec = 0,
	},
};
oldEnhancer:RegisterDefaults('profile', oldEnhancerDefaults);
AddOn.dbo = AddOn.table_copy(oldEnhancer.db);
]]