--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer");

local gsub, trim = _G.string.gsub, _G.strtrim;

function AddOn:QueueMacro(slot, name)
	local totem, rank = self:TotemAndRank(name);
	
	if (self.db.profile.quickCast[slot] == "") then
		self.queue[slot] = totem;
		self:DoQueue();
	end
end

function AddOn:DoQueue() -- Called on by CombatEnd
	if (self.combat) then return; end
	
	for slot, name in pairs(self.queue) do
		self.queue[slot] = nil;
		if (self.db.profile.quickCast[slot] == "") then
			self:MacroQueue(slot, name);
			self:TextQueue(slot, name);
		end
	end
end

function AddOn:MacroQueue(slot, name)
	local button = self.totems[slot];
	--self.totems[slot]:SetMacro("/script DestroyTotem(" .. slot .. ");\n/cast " .. name);
	self.totems[slot]:SetMacro("/cast " .. name);
end

function AddOn:TextQueue(slot, name)
	local button = self.totems[slot];
	local prefix = (self.db.profile.topDisplay == "Cast" and "Cast: ") or ""
	button:SetText(prefix .. trim(gsub(name, L["Totem gsub"], "")), "Top");
end

function AddOn:SetQueue(slot, name)
	name = trim(name);
	self.db.profile.quickCast[slot] = name;
	
	if (name ~= "") then
		self:MacroQueue(slot, name);
		self:TextQueue(slot, name);
	end
end