--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local lego = LibStub:GetLibrary("LegoBlock-Beta1");

local lcase, gsub, trim = _G.string.lower, _G.string.gsub, _G.strtrim;
local assert = _G.assert;

local legoBackdrop = { bgFile = [[Interface/Icons/Spell_Totem_WardOfDraining]], edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = false, tileSize = 0, edgeSize = 16, insets = { left = 3, right = 3, top = 3, bottom = 3 } };

function AddOn:CreateButton(gname, options)
	assert(gname, "Can't create a nameless button!");
	assert(options, "Need options table to create button!");
	
	local retVal = {};
	retVal.Texts = {};
	
	-- Save important default values
	retVal.dValues = {};
	retVal.dValues.icon = legoBackdrop.bgFile;
	options.width = self.db.profile.btnSize;
	options.height = self.db.profile.btnSize;
	
	-- Create a Secure Button we can mash if we want
	retVal.Button = lego:New("EnhancerButton_"..gname, "", nil, options);
	retVal.Button:SetBackdrop(legoBackdrop); -- Make it pretty
	retVal.Button:SetBackdropBorderColor(1, 1, 1, 0); -- Hide the border
	retVal.Button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	local globalname = retVal.Button:GetName();
	local bWidth = retVal.Button:GetWidth();
	
	-- Create a Cooldown on top of it
	retVal.Cooldown = CreateFrame("Cooldown", "EnhancerCooldown_"..gname, retVal.Button, "CooldownFrameTemplate");
	retVal.Cooldown:ClearAllPoints();
	retVal.Cooldown:SetWidth(bWidth * 0.75);
	retVal.Cooldown:SetHeight(bWidth * 0.75);
	retVal.Cooldown:SetPoint("CENTER", retVal.Button, "CENTER", 0, 0);
	retVal.Cooldown.noomnicc = self.db.profile.disableOmniCC; -- true will disable omnicc
	--retVal.Cooldown:SetAllPoints(globalname);
	
	-- Create a texture :)
	retVal.Texture = retVal.Button:CreateTexture();
	retVal.Texture:ClearAllPoints();
	retVal.Texture:SetWidth(bWidth * 0.75);
	retVal.Texture:SetHeight(bWidth * 0.75);
	retVal.Texture:SetPoint("CENTER", retVal.Button, "CENTER", 0, 0);
	retVal.Texture:SetTexture([[Interface/Icons/Spell_Totem_WardOfDraining]]);
	retVal.Texture:SetAlpha(0);
	-- Flashing (aggro like) just change alpha on it!
	--retVal.Texture:SetTexture([[Interface/AddOns/Enhancer/textures/flash.tga]]);
	--retVal.Texture:SetBlendMode("ADD");
  --retVal.Texture:SetVertexColor(0, 1, 0.3);
	
	-- Create a text holder in the center
	retVal.Texts.Center = retVal.Button:CreateFontString("EnhancerTextCenter"..gname, "OVERLAY");
	retVal.Texts.Center:SetFontObject(GameFontHighlightSmall)
	retVal.Texts.Center:SetFont(self.db.profile.centerFontIDTTF, self.db.profile.centerFontSize, self.db.profile.centerFontFlags);
	retVal.Texts.Center:ClearAllPoints();
	retVal.Texts.Center:SetTextColor(1, 1, 1, 1);
	retVal.Texts.Center:SetWidth(bWidth);
	retVal.Texts.Center:SetHeight(bWidth);
	retVal.Texts.Center:SetPoint("CENTER", globalname, "CENTER");
	retVal.Texts.Center:SetJustifyH("CENTER");
	retVal.Texts.Center:SetJustifyV("MIDDLE");
	retVal.Texts.Center:SetShadowColor(0, 0, 0, 1);
	retVal.Texts.Center:SetShadowOffset(0.8, -0.8);
	retVal.Texts.Center:SetText("");
	
	-- Create a text holder at the top
	retVal.Texts.Top = retVal.Button:CreateFontString("EnhancerTextTop"..gname, "OVERLAY");
	retVal.Texts.Top:SetFontObject(GameFontHighlightSmall)
	retVal.Texts.Top:SetFont(self.db.profile.topFontIDTTF, self.db.profile.topFontSize, self.db.profile.topFontFlags);
	retVal.Texts.Top:ClearAllPoints();
	retVal.Texts.Top:SetTextColor(1, 1, 1, 1);
	retVal.Texts.Top:SetWidth(bWidth * 1.5);
	retVal.Texts.Top:SetHeight(self.db.profile.topFontSize + self.db.profile.topFontSize + 10);
	retVal.Texts.Top:SetPoint("BOTTOM", globalname, "TOP");
	retVal.Texts.Top:SetJustifyH("CENTER");
	retVal.Texts.Top:SetJustifyV("BOTTOM");
	retVal.Texts.Top:SetShadowColor(0, 0, 0, 1);
	retVal.Texts.Top:SetShadowOffset(0.8, -0.8);
	retVal.Texts.Top:SetText("");
	
	-- Create a text holder at the bottom
	retVal.Texts.Bottom = retVal.Button:CreateFontString("EnhancerTextBottom"..gname, "OVERLAY");
	retVal.Texts.Bottom:SetFontObject(GameFontHighlightSmall)
	retVal.Texts.Bottom:SetFont(self.db.profile.bottomFontIDTTF, self.db.profile.bottomFontSize, self.db.profile.bottomFontFlags);
	retVal.Texts.Bottom:ClearAllPoints();
	retVal.Texts.Bottom:SetTextColor(1, 1, 1, 1);
	retVal.Texts.Bottom:SetWidth(bWidth * 1.5);
	retVal.Texts.Bottom:SetHeight(self.db.profile.bottomFontSize + self.db.profile.bottomFontSize + 10);
	retVal.Texts.Bottom:SetPoint("TOP", globalname, "BOTTOM");
	retVal.Texts.Bottom:SetJustifyH("CENTER");
	retVal.Texts.Bottom:SetJustifyV("TOP");
	retVal.Texts.Bottom:SetShadowColor(0, 0, 0, 1);
	retVal.Texts.Bottom:SetShadowOffset(0.8, -0.8);
	retVal.Texts.Bottom:SetText("");
	
	-- Create some functions
	retVal.SetAlpha = function(tbl, alpha)
		tbl.Button:SetAlpha(alpha);
		tbl.Cooldown:SetAlpha(alpha);
		--tbl.Texts.Center:SetAlpha(alpha);
		--tbl.Texts.Top:SetAlpha(alpha);
		--tbl.Texts.Bottom:SetAlpha(alpha);
	end
	
	retVal.Redraw = function(tbl, safeonly)
		if (tbl.Slot and self.db.profile.totemSettings[tbl.Slot].disabled) then tbl:Hide(); return; end
		tbl:Show();
		
		if (not safeonly) then
			tbl.Button:SetWidth(self.db.profile.btnSize);
			tbl.Button:SetHeight(self.db.profile.btnSize);
		end
		
		tbl.Cooldown:SetWidth(self.db.profile.btnSize * 0.75);
		tbl.Cooldown:SetHeight(self.db.profile.btnSize * 0.75);
		tbl.Texture:SetWidth(bWidth * 0.75);
		tbl.Texture:SetHeight(bWidth * 0.75);
		
		tbl.Texts.Center:SetWidth(self.db.profile.btnSize);
		tbl.Texts.Center:SetHeight(self.db.profile.btnSize);
		tbl.Texts.Top:SetWidth(self.db.profile.btnSize * 1.5);
		tbl.Texts.Bottom:SetWidth(self.db.profile.btnSize * 1.5);
		
		tbl.Texts.Center:SetFont(self.db.profile.centerFontIDTTF, self.db.profile.centerFontSize, self.db.profile.centerFontFlags);
		tbl.Texts.Top:SetFont(self.db.profile.topFontIDTTF, self.db.profile.topFontSize, self.db.profile.topFontFlags);
		tbl.Texts.Top:SetHeight(self.db.profile.topFontSize + self.db.profile.topFontSize + 10);
		tbl.Texts.Bottom:SetHeight(self.db.profile.bottomFontSize + self.db.profile.bottomFontSize + 10);
		tbl.Texts.Bottom:SetFont(self.db.profile.bottomFontIDTTF, self.db.profile.bottomFontSize, self.db.profile.bottomFontFlags);
		
		if (self.db.profile.topTextHidden) then tbl.Texts.Top:Hide(); else tbl.Texts.Top:Show(); end
		if (self.db.profile.centerTextHidden) then tbl.Texts.Center:Hide(); else tbl.Texts.Center:Show(); end
		if (self.db.profile.bottomTextHidden) then tbl.Texts.Bottom:Hide(); else tbl.Texts.Bottom:Show(); end
		
		tbl:UpdateAlpha();
	end
	
	retVal.Show = function(tbl)
		local function Show(timerInfo)
			if ( self.combat ) then return; end
			
			local tbl = timerInfo.tbl;
			tbl.Button:Show();
			tbl.Cooldown:Show();
			tbl.Texts.Center:Show();
			tbl.Texts.Top:Show();
			tbl.Texts.Bottom:Show();
			tbl.State = nil;
			
			if (tbl.Button:IsVisible()) then
				self:CancelTimer(timerInfo.Timer, true);
			end
		end
		
		local timerInfo = { tbl = tbl };
		timerInfo.Timer = self:ScheduleRepeatingTimer(Show, 1, timerInfo);
		Show(timerInfo);
	end
	
	retVal.Hide = function(tbl)
		local function Hide(timerInfo)
			if ( self.combat ) then return; end
			
			local tbl = timerInfo.tbl;
			tbl.Button:Hide();
			tbl.Cooldown:Hide();
			tbl.Texts.Center:Hide();
			tbl.Texts.Top:Hide();
			tbl.Texts.Bottom:Hide();
			tbl.State = "Hidden";
			
			if (not tbl.Button:IsVisible()) then
				self:CancelTimer(timerInfo.Timer, true);
			end
		end
		
		local timerInfo = { tbl = tbl };
		timerInfo.Timer = self:ScheduleRepeatingTimer(Hide, 1, timerInfo);
		Hide(timerInfo);
	end
	
	retVal.Pulse = function(tbl)
		if (not self.db.profile.showPulses) then return; end
		
		EnhancerPulseFrame:SetScript("OnUpdate", function() self:DoPulse(); end)
		self.pulsing[tbl] = 0;
	end
	
	retVal.SetScript = function(tbl, event, script)
		tbl.Button:SetScript(event, script);
	end
	
	retVal.SetIcon = function(tbl, icon)
		local backdrop = tbl.Button:GetBackdrop();
		backdrop.bgFile = icon;
		tbl.Button:SetBackdrop(backdrop);
		tbl.Button:SetBackdropBorderColor(1, 1, 1, 0);
		tbl.Texture:SetTexture(icon);
	end
	
	retVal.SetTexture = function(tbl, icon)
		tbl.Texture:SetTexture(icon);
	end
	
	retVal.SetMacro = function(tbl, macro, button)
		button = button or 1;
		tbl.Button:SetAttribute("type" .. button, "macro");
		tbl.Button:SetAttribute("macrotext" .. button, macro);
	end
	
	retVal.SetAttribute = function(tbl, key, value)
		tbl.Button:SetAttribute(key, value);
	end
	
	retVal.SetText = function(tbl, text, location)
		location = location or "Center";
		tbl.Texts[location]:SetText(trim(text));
	end
	
	retVal.SetCooldown = function(tbl, start, duration) 
		tbl.Cooldown:SetCooldown(start, duration);
	end
	
	retVal.storage = {};
	retVal.Get = function(tbl, key)
		return tbl.storage and tbl.storage[lcase(key)];
	end
	retVal.Set = function(tbl, key, value)
		tbl.storage = tbl.storage or {};
		tbl.storage[lcase(key)] = value;
	end
	retVal.Clear = function(tbl)
		tbl.storage = nil;
	end
	retVal.Reset = function(tbl, icon)
		local backdrop = tbl.Button:GetBackdrop();
		backdrop.bgFile = legoBackdrop.bgFile;
		tbl.Button:SetBackdrop(backdrop);
		tbl.Button:SetBackdropBorderColor(1, 1, 1, 0);
		tbl.storage = nil;
		
		tbl.Texts.Bottom:SetText("");
		tbl.Texts.Center:SetText("");
	end
	
	retVal.UpdateAlpha = function(tbl)
		if ( tbl:Get("active") or not tbl.Button.optionsTbl.locked ) then
			tbl:SetAlpha(self.db.profile.btnActiveAlpha);
		else
			if ( self.combat ) then
				tbl:SetAlpha(self.db.profile.btnInactiveAlpha);
			else
				tbl:SetAlpha(self.db.profile.btnOocAlpha);
			end
		end
	end
	
	retVal.Lock = function(tbl)
		tbl.Button.optionsTbl.locked = self.db.profile.locked;
	end
	
	retVal.SavePos = function(tbl)
		local func = tbl.Button:GetScript("OnDragStop");
		tbl.Button.isMoving = true;
		return xpcall(func, tbl.Button);
	end
	
	retVal.IsLocked = function(tbl)
		return tbl.Button.optionsTbl.locked;
	end
	
	retVal.Info = function(tbl, key)
		return self.TotemInfo[tbl:Get("name")] and self.TotemInfo[tbl:Get("name")][key];
	end
	retVal.RankInfo = function(tbl, key)
		return self.TotemInfo[tbl:Get("name")] and self.TotemInfo[tbl:Get("name")][tbl:Get("rank")] and self.TotemInfo[tbl:Get("name")][tbl:Get("rank")][key];
	end
	
	retVal.format = function(tbl, text)
		return (gsub(text,"%%(.-)%%", function(a) if (lcase(a) == "element") then return self.slotElement[tbl.Slot] else return tostring(tbl:Get(a)) end end ))
	end
	
	retVal.Button:SetScript("OnEnter", function() GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT"); end);
	retVal.Button:SetScript("OnLeave", function() GameTooltip:Hide(); end);
	
	retVal:Lock(); -- Update lock
	retVal:Redraw(); -- Redraw with db size etc
	
	return retVal;
end

function AddOn:DoPulse()
	if (not self.pulsing) then return; end
	
	for tbl, count in pairs(self.pulsing) do
		count = count + 1;
		self.pulsing[tbl] = count;
		
		if (count == 1 and tbl.Texture:GetAlpha() == 0) then tbl.Texture:SetAlpha(1); end
		
		local curSize = tbl.Texture:GetWidth();
		local norSize = tbl.Button:GetWidth() * 0.75;
		if (count < 10) then
			local newSize = curSize + (curSize * 0.1);
			if (newSize <= (norSize * 2)) then
				tbl.Texture:SetWidth(newSize);
				tbl.Texture:SetHeight(newSize);
			end
		elseif (count <= 17) then
			local newSize = curSize - (curSize * 0.1);
			
			if (newSize >= (norSize / 2)) then
				tbl.Texture:SetWidth(newSize);
				tbl.Texture:SetHeight(newSize);
			end
		else
			tbl.Texture:SetWidth(norSize);
			tbl.Texture:SetHeight(norSize);
			tbl.Texture:SetAlpha(0);
			self.pulsing[tbl] = nil;
		end
	end
	
	local canStop = true;
	for tbl, count in pairs(self.pulsing) do
		canStop = false;
	end
	if (canStop) then
		EnhancerPulseFrame:SetScript("OnUpdate", nil)
	end
end

AddOn.pulsing = {};
EnhancerPulseFrame = CreateFrame("Frame");
EnhancerPulseFrame:SetScript("OnUpdate", nil)

--[[
item:SetAttribute("type1", "item")
item:SetAttribute("item1", "item:"..uitem)

f:SetAttribute("type1", "spell")
f:SetAttribute("spell1", "Lightning Bolt")

f:SetAttribute("type1", nil)
f:SetAttribute("spell1", nil)
]]