--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer");
local LSM = LibStub("LibSharedMedia-3.0");

local pairs = _G.pairs;
local gsub = _G.string.gsub;

--[[ Print/Debug                                                      ]]
local print = function(...) AddOn:PrintFunction(...); end
local debug = function(...) AddOn:DebugFunction(...); end

--[[ SharedMedia stuff                                                ]]
LSM:Register("font", "Adventure",	[[Interface\AddOns\Enhancer\fonts\Adventure.ttf]]);
LSM:Register("font", "The Godfather",	[[Interface\AddOns\Enhancer\fonts\CorleoneDue.ttf]]);
LSM:Register("font", "Corleone",	[[Interface\AddOns\Enhancer\fonts\Corleone.ttf]]);
LSM:Register("font", "Sopranos",	[[Interface\AddOns\Enhancer\fonts\Mobsters.ttf]]);
LSM:Register("font", "Friz Quadrata TT", [[Fonts\FRIZQT__.ttf]]);
LSM:Register("font", "Weltron Urban", [[Interface\AddOns\Enhancer\fonts\weltu.ttf]]);
LSM:Register("font", "Jokewood", [[Interface\AddOns\Enhancer\fonts\jokewood.ttf]]);
LSM:Register("font", "Freshbot", [[Interface\AddOns\Enhancer\fonts\freshbot.ttf]]);
LSM:Register("font", "Chick", [[Interface\AddOns\Enhancer\fonts\chick.ttf]]);
LSM:Register("font", "Alba Super", [[Interface\AddOns\Enhancer\fonts\albas.ttf]]);
LSM:Register("font", "Wild Ride", [[Interface\AddOns\Enhancer\fonts\WildRide.ttf]]);
LSM:Register("font", "Caslon Antique", [[Interface\AddOns\Enhancer\fonts\CAS_ANTN.TTF]]);
LSM:Register("font", "Caslon Antique", [[Interface\AddOns\Enhancer\fonts\Cella.otf]]);

--[[ I LOVE THESE                                                     ]]
local orderNum = 0;
local function OrderNum()
	orderNum = orderNum + 1;
	return orderNum;
end

local function BR()
	return {order = OrderNum(), type = "description", name = " " };
end

local headerNum = 0;
local function HeaderName()
	headerNum = headerNum + 1;
	return "Header"..headerNum;
end

local function Header(text, Width)
	return { name = text, order = OrderNum(), type = "header", cmdHidden = true, width = (Width or "full") };
end

local function getBaseOption(info)
	return AddOn.db.profile[info[#info]];
end

local function setBaseOption(info, value)
	AddOn.db.profile[info[#info]] = value;
end

local function tglBaseOption(info)
	AddOn.db.profile[info[#info]] = not AddOn.db.profile[info[#info]];
end

local function setButtonOption(info, value)
	setBaseOption(info, value);
	AddOn:UpdateAll();
end

local function tglButtonOption(info)
	tglBaseOption(info);
	AddOn:UpdateAll();
end

-- stolen from Omen Config.lua
local function GetLSMIndex(t, value)
	for k, v in pairs(LSM:List(t)) do
		if v == value then
			return k
		end
	end
	return nil
end

local outlines = {[""] = L["None"], ["OUTLINE"] = L["Outline"], ["THICKOUTLINE"] = L["Thick Outline"]};

function AddOn:ConsoleTable()
	local options = {
		type = "group",
		icon = [[Interface/Icons/INV_Jewelcrafting_LivingRuby_02]],
		name = L["cmd name Enhancer"],
		childGroups = "tree", inline = true,
		args = {
			Config = {
				order = OrderNum(), type = "execute",
				name = L["cmd name Config"], desc = L["cmd desc Config"],
				func = function() LibStub("AceConfigDialog-3.0"):Open("Enhancer") end,
				guiHidden = true,
				dialogHidden = true,
				dropdownHidden = true,
			},
			locked = {
				order = OrderNum(), type = "toggle",
				name = L["cmd name locked"], desc = L["cmd desc locked"],
				get = getBaseOption,
				set = tglButtonOption,
				width = nil,
			},
			hideBlizz = {
				order = OrderNum(), type = "toggle",
				name = L["cmd name hideblizz"], desc = L["cmd desc hideblizz"],
				get = getBaseOption,
				set = function()
					self.db.profile.hideBlizz = not self.db.profile.hideBlizz;
					if (self.db.profile.hideBlizz) then _G["TotemFrame"]:Hide(); end
				end,
				width = nil,
			},
			tooltip = {
				order = OrderNum(), type = "toggle",
				name = L["cmd name tooltip"], desc = L["cmd desc tooltip"],
				get = getBaseOption,
				set = tglBaseOption,
				width = nil,
			},
			
			buttonSettings = {
				order = OrderNum(), type = "group",
				name = L["cmd name buttonsettings"],
				childGroups = "tree",
				cmdHidden = true,
				args = {
					[HeaderName()] = Header(L["cmd header Measures"], "full"),
					btnSize = {
						order = OrderNum(), type = "range",
						name = L["cmd name btnwidth"], desc = L["cmd desc btnwidth"],
						min = 15, max = 75, step = 1,
						get = getBaseOption,
						set = setButtonOption,
						width = nil,
					},
					
					[HeaderName()] = Header(L["cmd header Opacity"], "full"),
					btnActiveAlpha = {
						order = OrderNum(), type = "range",
						name = L["cmd name activealpha"], desc = L["cmd desc activealpha"],
						min = 0, max = 1, step = 0.1,
						get = getBaseOption,
						set = setButtonOption,
						width = nil,
					},
					btnInactiveAlpha = {
						order = OrderNum(), type = "range",
						name = L["cmd name inactivealpha"], desc = L["cmd desc inactivealpha"],
						min = 0, max = 1, step = 0.1,
						get = getBaseOption,
						set = setButtonOption,
						width = nil,
					},
					btnOocAlpha = {
						order = OrderNum(), type = "range",
						name = L["cmd name oocalpha"], desc = L["cmd desc oocalpha"],
						min = 0, max = 1, step = 0.1,
						get = getBaseOption,
						set = setButtonOption,
						width = nil,
					},
					
					[HeaderName()] = Header(L["cmd header Messages"], "full"),
					msgTotemLost = {
						order = OrderNum(), type = "input",
						name = L["cmd name natural"], desc = L["cmd desc natural"],
						get = getBaseOption,
						set = setBaseOption,
						width = "full",
					},
					msgTotemSlain = {
						order = OrderNum(), type = "input",
						name = L["cmd name slain"], desc = L["cmd desc slain"],
						get = getBaseOption,
						set = setBaseOption,
						width = "full",
					},
				},
			},
			
			textSettings = {
				order = OrderNum(), type = "group",
				name = L["cmd name textsettings"],
				childGroups = "tree",
				cmdHidden = true,
				args = {
					[HeaderName()] = Header(L["cmd header Top"], "full"),
					topFontID = {
						order = OrderNum(), type = "select",
						name = L["cmd name font"], desc = L["cmd desc font"],
						values = LSM:List("font"),
						get = function(info) return GetLSMIndex("font", AddOn.db.profile[info[#info]]); end,
						set = function(info, value)
							self.db.profile[info[#info].."TTF"] = LSM:Fetch("font", LSM:List("font")[value]);
							setButtonOption(info, LSM:List("font")[value]);
						end,
						width = nil,
					},
					topFontFlags = {
						order = OrderNum(), type = "select",
						name = L["cmd name fontflags"], desc = L["cmd desc fontflags"],
						values = outlines,
						get = getBaseOption,
						set = setButtonOption,
					},
					topFontSize = {
						order = OrderNum(), type = "range",
						name = L["cmd name fontsize"], desc = L["cmd desc fontsize"],
						min = 4, max = 30, step = 1,
						get = getBaseOption,
						set = setButtonOption,
					},
					topTextHidden = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name topTextHidden"], desc = L["cmd desc topTextHidden"],
						get = getBaseOption,
						set = tglButtonOption,
						width = nil,
					},
					topDisplay = {
						order = OrderNum(), type = "select",
						name = L["cmd name topDisplay"], desc = L["cmd desc topDisplay"],
						values = { ["Cast"] = L["Cast: Totem"], ["Totem"] = L["Totem only"]},
						get = getBaseOption,
						set = setButtonOption,
					},
					
					[HeaderName()] = Header(L["cmd header Center"], "full"),
					centerFontID = {
						order = OrderNum(), type = "select",
						name = L["cmd name font"], desc = L["cmd desc font"],
						values = LSM:List("font"),
						get = function(info) return GetLSMIndex("font", AddOn.db.profile[info[#info]]); end,
						set = function(info, value)
							self.db.profile[info[#info].."TTF"] = LSM:Fetch("font", LSM:List("font")[value]);
							setButtonOption(info, LSM:List("font")[value]);
						end,
						width = nil,
					},
					centerFontFlags = {
						order = OrderNum(), type = "select",
						name = L["cmd name fontflags"], desc = L["cmd desc fontflags"],
						values = outlines,
						get = getBaseOption,
						set = setButtonOption,
					},
					centerFontSize = {
						order = OrderNum(), type = "range",
						name = L["cmd name fontsize"], desc = L["cmd desc fontsize"],
						min = 4, max = 30, step = 1,
						get = getBaseOption,
						set = setButtonOption,
					},
					centerTextHidden = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name centerTextHidden"], desc = L["cmd desc centerTextHidden"],
						get = getBaseOption,
						set = tglButtonOption,
						width = nil,
					},
					centerDisplay = {
						order = OrderNum(), type = "select",
						name = L["cmd name centerDisplay"], desc = L["cmd desc centerDisplay"],
						values = { ["Pulse"] = L["Pulse (if avail)"], ["Hitpoints"] = L["Estimated life left"]},
						get = getBaseOption,
						set = setButtonOption,
					},
					
					[HeaderName()] = Header(L["cmd header Bottom"], "full"),
					bottomFontID = {
						order = OrderNum(), type = "select",
						name = L["cmd name font"], desc = L["cmd desc font"],
						values = LSM:List("font"),
						get = function(info) return GetLSMIndex("font", AddOn.db.profile[info[#info]]); end,
						set = function(info, value)
							local fontID = LSM:List("font")[value];
							self.db.profile[info[#info].."TTF"] = LSM:Fetch("font", fontID);
							setButtonOption(info, fontID);
						end,
						width = nil,
					},
					bottomFontFlags = {
						order = OrderNum(), type = "select",
						name = L["cmd name fontflags"], desc = L["cmd desc fontflags"],
						values = outlines,
						get = getBaseOption,
						set = setButtonOption,
					},
					bottomFontSize = {
						order = OrderNum(), type = "range",
						name = L["cmd name fontsize"], desc = L["cmd desc fontsize"],
						min = 4, max = 30, step = 1,
						get = getBaseOption,
						set = setButtonOption,
					},
					bottomTextHidden = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name bottomTextHidden"], desc = L["cmd desc bottomTextHidden"],
						get = getBaseOption,
						set = tglButtonOption,
						width = nil,
					},
					bottomDisplay = {
						order = OrderNum(), type = "select",
						name = L["cmd name bottomDisplay"], desc = L["cmd desc bottomDisplay"],
						values = { ["Hitpoints"] = L["Estimated life left"], ["Time"] = L["Duration of Totem"]},
						get = getBaseOption,
						set = setButtonOption,
					},
				},
			},
			
			extras = {
				order = OrderNum(), type = "group",
				name = L["cmd name extras"],
				childGroups = "tree",
				cmdHidden = true,
				args = {
					showPurged = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name showPurged"], desc = L["cmd desc showPurged"],
						get = getBaseOption,
						set = tglBaseOption,
						width = nil,
					},
					purgeAnnounce = {
						order = OrderNum(), type = "select",
						name = L["cmd name purgeAnnounce"], desc = L["cmd desc purgeAnnounce"],
						values = { ["RAID_WARNING"] = L["Announce to raidwarning"], ["RAID"] = L["Announce to raid"], ["PARTY"] = L["Announce to party"], [""] = L["Announce to nowhere"], ["SMART"] = L["Announce to smart"], ["SMARTRW"] = L["Announce to smart with raidwarning"] },
						get = getBaseOption,
						set = setButtonOption,
					},
					showPulses = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name showPulses"], desc = L["cmd desc showPulses"],
						get = getBaseOption,
						set = tglBaseOption,
						width = nil,
					},
				}
			},
			
			quickCast = {
				order = OrderNum(), type = "group",
				name = L["cmd name quickcast"],
				childGroups = "tree",
				cmdHidden = true,
				args = {
					earth = {
						order = OrderNum(), type = "input",
						name = L["Earth"], desc = L["Earth macro text"],
						get = function() return self.db.profile.quickCast[EARTH_TOTEM_SLOT]; end,
						set = function(info, value) self:SetQueue(EARTH_TOTEM_SLOT, value); end,
						width = "full",
					},
					
					[HeaderName()] = Header("", "full"),
					
					fire = {
						order = OrderNum(), type = "input",
						name = L["Fire"], desc = L["Fire macro text"],
						get = function() return self.db.profile.quickCast[FIRE_TOTEM_SLOT]; end,
						set = function(info, value) self:SetQueue(FIRE_TOTEM_SLOT, value); end,
						width = "full",
					},
					
					[HeaderName()] = Header("", "full"),
					
					water = {
						order = OrderNum(), type = "input",
						name = L["Water"], desc = L["Water macro text"],
						get = function() return self.db.profile.quickCast[WATER_TOTEM_SLOT]; end,
						set = function(info, value) self:SetQueue(WATER_TOTEM_SLOT, value); end,
						width = "full",
					},
					
					[HeaderName()] = Header("", "full"),
					
					air = {
						order = OrderNum(), type = "input",
						name = L["Air"], desc = L["Air macro text"],
						get = function() return self.db.profile.quickCast[AIR_TOTEM_SLOT]; end,
						set = function(info, value) self:SetQueue(AIR_TOTEM_SLOT, value); end,
						width = "full",
					},
				},
			},
			
			disable = {
				order = OrderNum(), type = "group",
				name = L["cmd name disable"],
				childGroups = "tree",
				cmdHidden = true, --inline = true,
				args = {
				},
			},
			
			layouts = {
				order = OrderNum(), type = "group",
				name = L["cmd name layout"],
				childGroups = "tree",
				cmdHidden = true, --inline = true,
				args = {
					below = {
						order = OrderNum(), type = "execute",
						name = L["cmd name below"], desc = L["cmd desc below"],
						func = function()
							for slot, button in pairs(self.totems) do
								local y = -130;
								local x = self.db.profile.btnSize;
								if (slot == EARTH_TOTEM_SLOT) then x = (x + (x / 2)) * -1; end
								if (slot == FIRE_TOTEM_SLOT) then x = (x / 2) * -1; end
								if (slot == WATER_TOTEM_SLOT) then x = (x / 2); end
								if (slot == AIR_TOTEM_SLOT) then x = (x + (x / 2)); end
								button.Button:ClearAllPoints();
								button.Button:SetPoint("CENTER", UIParent, "CENTER", x, y);
								button:SavePos();
							end
						end,
					},
					xpos = {
						order = OrderNum(), type = "execute",
						name = L["cmd name xpos"], desc = L["cmd desc xpos"],
						func = function()
							for slot, button in pairs(self.totems) do
								local x, y = 130, 130;
								if (slot == FIRE_TOTEM_SLOT or slot == AIR_TOTEM_SLOT) then x = (x * -1); end --x-offset (negative values will move obj left, positive values will move obj right), defaults to 0 if not specified. 
								if (slot == WATER_TOTEM_SLOT or slot == AIR_TOTEM_SLOT) then y = (y * -1); end --y-offset (negative values will move obj down, positive values will move obj up), defaults to 0 if not specified.
								button.Button:ClearAllPoints();
								button.Button:SetPoint("CENTER", UIParent, "CENTER", x, y);
								button:SavePos();
							end
						end,
					},
					disableOmniCC = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name disableOmniCC"], desc = L["cmd desc disableOmniCC"],
						get = getBaseOption,
						set = function(info, value)
							self.db.profile.disableOmniCC = not self.db.profile.disableOmniCC;
							for _, button in pairs(self.totems) do
								if (not button.Cooldown.omniccfixed) then
									button.Cooldown.noomnicc = self.db.profile.disableOmniCC;
									print(button.Cooldown.noomnicc, button.Slot);
								end
							end
							for _, button in pairs(self.extras) do
								if (not button.Cooldown.omniccfixed) then
									button.Cooldown.noomnicc = self.db.profile.disableOmniCC;
								end
							end
						end,
						width = nil,
					},
				},
			},
			
			output = OrderNum(), -- save where sink options should be
			
			resetDB = {
				order = OrderNum(), type = "execute",
				name = L["cmd name resetdb"], desc = L["cmd desc resetdb"],
				func = function() self.db:ResetProfile(); end,
			},
			
			Dev = {
				order = OrderNum(), type = "group",
				name = L["cmd name dev tools"],
				childGroups = "tree",
				cmdHidden = true,
				args = {
					debug = {
						order = OrderNum(), type = "toggle",
						name = L["cmd name debug"], desc = L["cmd desc debug"],
						get = function() return AddOn.debug; end,
						set = function() AddOn.debug = not AddOn.debug; end,
						width = nil,
					},
					
					[HeaderName()] = Header(L["cmd name Contact"]),
					
					Email = {
						order = OrderNum(), type = "input",
						name = L["cmd name email"],
						desc = L["cmd desc email"],
						get = function() return self:SpamSafe(L["__EMAIL__"]); end,
						set = function(info, value) return; end,
						width = "full",
					},
					
					Website = {
						order = OrderNum(), type = "input",
						name = L["cmd name website"],
						desc = L["cmd desc website"],
						get = function() return self:SpamSafe(L["__URL__"]); end,
						set = function(info, value) return; end,
						width = "full",
					},
					
					[HeaderName()] = Header(L["cmd name Misc"]),
					
					news = {
						order = OrderNum(), type = "execute",
						name = L["cmd name news"], desc = L["cmd desc news"],
						func = function() self:News(true); end,
					},
					
					--[[
					crap = {
						order = OrderNum(), type = "execute",
						name = "Crap", desc = "Crap",
						func = function()
							local SendTo = LibStub("AceAddon-3.0"):GetAddon("Enhancer_Windfury");
							SendTo:CombatLogEvent(nil, nil, nil, nil, nil, 0x00000001, nil, nil, nil, "Windfury Attack");
						end,
					},]]
				},
			},
			
			news = {
				order = OrderNum(), type = "execute",
				name = L["cmd name news"], desc = L["cmd desc news"],
				func = function() self:News(true); end,
			},
		},
	};
	
	-- Hack to get sink setting where I want it
	local sinkorder = options.args.output;
	options.args.output = self:GetSinkAce3OptionsDataTable();
	options.args.output.order = sinkorder;
	options.args.output.cmdHidden = true;
	
	for slot, button in pairs(self.totems) do
		local key = gsub(button.Button:GetName(), "^LegoEnhancerButton_", "");
		options.args.disable.args[key] = {
			order = OrderNum(), type = "toggle",
			name = key, desc = key,
			get = function() return self.db.profile.totemSettings[slot].disabled; end,
			set = function() self.db.profile.totemSettings[slot].disabled = not self.db.profile.totemSettings[slot].disabled; self:ButtonUpdate(button); end,
			width = nil,
		};
	end
	
	return options;
end

function AddOn:Console()
	self.opts = LibStub("AceConfig-3.0"):RegisterOptionsTable("Enhancer", function() return self:ConsoleTable(); end, {L["/Enhancer"], L["/Enh"], L["/Enhance"]});
end