--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");

function AddOn:SendChatMessage(msg, chatType)
	if (chatType == "") then return; end
	
	if (chatType == "SMART") then
		if (GetNumRaidMembers() > 0) then
			chatType = "RAID"
		elseif (GetNumPartyMembers() > 0) then
			chatType = "PARTY"
		else
			return;
		end
	elseif (chatType == "SMARTRW") then
		if (GetNumRaidMembers() > 0) then
			chatType = "RAID"
			if (IsRaidLeader() or IsRaidOfficer()) then chatType = "RAID_WARNING"; end
		elseif (GetNumPartyMembers() > 0) then
			chatType = "RAID_WARNING"
		else
			return;
		end
	elseif (chatType == "RAID_WARNING") then
		if (GetNumRaidMembers() > 0) then
			-- In a raid
			if (not IsRaidLeader() and not IsRaidOfficer()) then return; end
		elseif (GetNumPartyMembers() < 1) then
			-- No raid and no party
			return;
		end
	elseif (chatType == "RAID" and GetNumRaidMembers() < 1) then
		-- no raid
		return;
	elseif (chatType == "PARTY" and GetNumPartyMembers() < 1) then
		-- no party
		return;
	else
		return;
	end
	
	SendChatMessage(msg, chatType);
end