--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer")
local LR = LibStub:GetLibrary("LibRoman-1.0");

local format, trim = _G.string.format, _G.strtrim;
local find, sub, len = _G.string.find, _G.string.sub, _G.string.len;
local floor, ceil, abs, mod = _G.math.floor, _G.math.ceil, _G.math.abs, _G.mod;
local round = AddOn.math_round;

--[[ Print/Debug                                                      ]]
local debug = function(...) AddOn:DebugFunction(...); end

function AddOn:UpdateTotems()
	local haveTotem, name, startTime, duration, icon;
	local slot;
	local button;
	local buttonIndex = 1;
	
	-- FIRE_TOTEM_SLOT, EARTH_TOTEM_SLOT, WATER_TOTEM_SLOT, AIR_TOTEM_SLOT
	for totemIndex=1, MAX_TOTEMS do
		slot = TOTEM_PRIORITIES[totemIndex];
		haveTotem, name, startTime, duration, icon = GetTotemInfo(slot);
		button = self.totems[slot];
		
		if ( haveTotem ) then
			self:TotemUpdate(button, startTime, duration, icon, name);
			
			if (name and name ~= "") then
				self:QueueMacro(slot, name);
			end
		else
			button:Reset();
		end
		
		button:UpdateAlpha();
	end
end

function AddOn:TotemUpdate(button, startTime, duration, icon, name)
	if ( duration > 0 ) then
		self:ActivateButton(button, startTime, duration, icon, name);
	else
		self:DeactivateButton(button);
	end
end

function AddOn:TotemAndRank(name)
	local totem, rank = nil, 1;
	
	for totem, _ in pairs(AddOn.TotemInfo) do
		if ( find(name, "^"..totem, 1) ) then
			rank = LR:Arabic(trim(sub(name, len(totem) + 1)));
			if (rank == 0) then rank = 1; end
			return totem, rank or 1;
		end
	end
	
	return name, rank;
end

function AddOn:ActivateButton(button, startTime, duration, icon, name)
	local totem, rank = self:TotemAndRank(name);
	debug("ActivateButton", button, startTime, duration, icon, name, totem, rank);
	button:SetScript("OnUpdate", self.TotemButtonOnUpdate);
	button:Clear();
	button:Set("active", true);
	button:Set("namerank", name);
	button:Set("name", totem);
	button:Set("rank", rank);
	button:Set("guid", AddOn.guids[name]);
	debug(name, AddOn.guids[name]);
	button:Set("startTime", startTime);
	button:Set("duration", duration);
	if (button:Info("Pulse")) then
		local _, _, lag = GetNetStats();
		button:Set("Pulse", GetTime() + button:Info("Pulse") - (lag/1000));
	end
	
	-- Doesn't work as some have diff life on rank so fix it here!
	local life = button:Info("Life") or button:RankInfo("Life");
	local level = button:RankInfo("Level");
	if (level) then
		life = life + (((UnitLevel("player") or level) - level) * 3);
	end
	button:Set("hp", life);
	
	button:SetIcon(icon);
	button:SetCooldown(startTime, duration);
	
	if (button.Timer) then self:CancelTimer(button.Timer, true); end
	local timerInfo = { Slot = button.Slot, Started = GetTime() };
	timerInfo.Timer = self:ScheduleRepeatingTimer("UpdateButton", 0.3, timerInfo);
	button.Timer = timerInfo.Timer;
end

function AddOn:DeactivateButton(button)
	debug("DeactivateButton", button);
	button:SetScript("OnUpdate", nil);
	if (button:Get("active")) then
		button:SetCooldown(0, 0);
		
		if (button:Get("hp") and button:Get("hp") <= 0) then
			self:SinkMsg(button:format(self.db.profile.msgTotemSlain), 1, 0, 0);
		else
			self:SinkMsg(button:format(self.db.profile.msgTotemLost), 1, 0.5, 0);
		end
	end
	
	button:Reset();
end

function AddOn:UpdateButton(timerInfo) -- local elapsedSinceLastVisit = arg1;
	local button = self.totems[timerInfo.Slot];
	local startTime, duration = button:Get("startTime"), button:Get("duration");
	
	if (not startTime) then
		self:CancelTimer(timerInfo.Timer, true);
		timerInfo = nil;
		return;
	end
	
	local timeLeft = duration - (GetTime() - startTime);
	local elapsed = ceil(GetTime() - startTime) + (self.db.profile.pulseOffset or 1);
	
	if (button:Get("Pulse") and (button:Get("Pulse") - GetTime()) <= 0) then
		button:Pulse();
		local _, _, lag = GetNetStats();
		button:Set("Pulse", button:Get("Pulse") + button:Info("Pulse") - (lag/1000));
	end
	local centerText = (button:Info("Pulse") and self.db.profile.centerDisplay == "Pulse" and abs(ceil(button:Get("Pulse") - GetTime() - 0.1))) or (self.db.profile.centerDisplay == "Hitpoints" and button:Get("hp")) or "";
	button:SetText(centerText, "Center");
	
	local bottomText = (self.db.profile.bottomDisplay == "Time" and self:FormatTime(timeLeft)) or (self.db.profile.bottomDisplay == "Hitpoints" and button:Get("hp")) or "";
	button:SetText(bottomText, "Bottom");
end

function AddOn:FormatTime(seconds)
	if (seconds < 0) then seconds = 0; end
	
	seconds = seconds;
	seconds = floor(seconds);
	secs = mod(seconds, 60);
	mins = (seconds - secs) / 60;
	
	if (false) then --false was Enhancer.db.profile.blizzTime
		if (seconds > 60) then
			return string.sub("00"..(mins + 1), -2).." m";
		else
			return seconds .. (false and " s" or ""); -- false was Enhancer.db.profile.blizzSsec
		end
	else
		if (mins > 0) then
			return mins .. ":" .. sub("00"..secs, -2);
		else
			return sub("00" .. secs, -2);
		end
	end
end

--[[
function AddOn:ButtonUpdateAlpha(button)
	if ( button:Get("active") ) then
		button:SetAlpha(self.db.profile.btnActiveAlpha);
	else
		if ( self.combat ) then
			button:SetAlpha(self.db.profile.btnInactiveAlpha);
		else
			button:SetAlpha(self.db.profile.btnOocAlpha);
		end
	end
end
]]

function AddOn:UpdateAll()
	for slot, button in pairs(self.totems) do
		self:ButtonUpdate(button);
	end
	
	for _, button in pairs(self.extras) do
		self:ButtonUpdate(button);
	end
end

function AddOn:ButtonUpdate(button)
	button:Lock();
	button:Redraw();
end

function AddOn.TotemButtonOnUpdate(legoButton, elapsed)
	if ( GameTooltip:IsOwned(legoButton) and AddOn.db.profile.tooltip ) then
		GameTooltip:SetTotem(legoButton.slot);
	end
end