--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer")

local assert = assert;

--[[ Print/Debug                                                      ]]
local print = function(...) AddOn:PrintFunction(...); end
local debug = function(...) AddOn:DebugFunction(...); end

--[[ Booooooring                                                      ]]
function AddOn:OnInitialize()
	self:RegisterDB();
	self:Console();
	self:News();
	
	self:SetSinkStorage(self.db.profile.sinkOptions);
	
	if (OmniCC and OmniCC.Blacklist) then
		OmniCC:Blacklist("Enhancer");
	end
	
	self.totems = self.totems or {};
	self.extras = self.extras or {};
	
	self.totems[FIRE_TOTEM_SLOT] = self:CreateButton("fire", self.db.profile.totemSettings[1]);
	self.totems[EARTH_TOTEM_SLOT] = self:CreateButton("earth", self.db.profile.totemSettings[2]);
	self.totems[WATER_TOTEM_SLOT] = self:CreateButton("water", self.db.profile.totemSettings[3]);
	self.totems[AIR_TOTEM_SLOT] = self:CreateButton("air", self.db.profile.totemSettings[4]);
	
	for slot, button in pairs(self.totems) do
		button:SetMacro("/script DestroyTotem(" .. slot .. ");", 2)
		button.Slot = slot;
		button.Button.slot = slot; -- Tooltips need this
		
		self:SetQueue(slot, self.db.profile.quickCast[slot])
	end
	
	self:UpdateAll()
	
	self.db.profile.firstTime = nil;
	self.db.profile.FirstTime = nil;
end

function AddOn:OnEnable()
	self:RegisterEvent("PLAYER_TOTEM_UPDATE", "UpdateTotems");
	--self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateTotems"); -- Useless as it doesn't recognize your totems after a /rl anyway
	
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "CombatStart");
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "CombatEnd");
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEvent");
	
	self:Visibility(true);
	
	self:UpdateTotems();
end

TotemFrame_Show_orig = TotemFrame.Show;
TotemFrame.Show = function(...)
	AddOn:ShowTotemFrame(...);
end

function AddOn:ShowTotemFrame(...)
	if (not self.db.profile.hideBlizz) then
		TotemFrame_Show_orig(...);
	end
end

function AddOn:OnDisable()
	self:UnregisterAllEvents();
	
	_G["TotemFrame"]:Show();
	
	self:Visibility(false);
end

function AddOn:CombatStart()
	self.combat = true;
end

AddOn.queue = {};
function AddOn:CombatEnd()
	self.combat = false;
	self:DoQueue()
end

function AddOn:Visibility(show)
	for _, button in pairs(self.totems) do
		if (show) then
			button:Show();
		else
			button:Hide();
		end
	end
end

