--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer")
local format = _G.string.format;

--[[ Print/Debug                                                      ]]
local print = function(...) AddOn:PrintFunction(...); end
local debug = function(...) AddOn:DebugFunction(...); end

AddOn.guids = {};
function AddOn:CombatLogEvent(combatLogEventType, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	
	if (event == "SPELL_SUMMON" and self:LogIsPlayer(sourceFlags)) then
		self:SPELL_SUMMON(destName, destGUID);
		
	elseif (event == "SWING_DAMAGE" and self:LogIsPlayer(destFlags)) then
		self:SWING_DAMAGE(destGUID, (select("1", ...)));
		
	elseif (event == "SPELL_AURA_DISPELLED" and self:LogIsPlayer(sourceFlags)) then
		-- local spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool, auraType = select(1, ...);
		local _, spellName, _, _, extraSpellName, _, auraType = select(1, ...);
		if (spellName == self.PurgeSpellName) then
			self:Purged(extraSpellName, destName, auraType);
		end
	end
	
	if (self:LogIsPlayer(sourceFlags) or self:LogIsPlayer(destFlags)) then
		debug(self:LogIsPlayer(destFlags), event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...);
	end
end

function AddOn:SWING_DAMAGE(guid, dmg)
	for slot, button in pairs(self.totems) do
		if (button:Get("guid") == guid and button:Get("hp")) then
			button:Set("hp", button:Get("hp") - dmg);
		end
	end
end

function AddOn:Purged(spell, from, aType)
	if (self.db.profile.showPurged) then
		self:SinkMsg(format(L["Purge Sink"], spell, from, aType), 0, 1, 0.5);
	end
	
	self:SendChatMessage(format(L["Purge Group"], spell, from, aType), self.db.profile.purgeAnnounce) -- purgeAnnounce is "" if user doesn't want to send anything so will ignore sending in that function
end

function AddOn:SPELL_SUMMON(name, guid)
	self.guids[name] = guid;
end

function AddOn:LogIsPlayer(flags)
	return (bit.band(flags, 0x00000001) == 0x00000001);
end

function AddOn:SinkMsg(message, r, g, b)
	self:Pour(message, r or 0, g or 0.75, b or 0.75, nil, 24, "OUTLINE", true);
end