--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AceLibrary = _G["AceLibrary"];
local Enhancer = LibStub("AceAddon-3.0"):GetAddon("Enhancer");

local select, GetTime = _G.select, _G.GetTime;

assert(Enhancer													, "Error, Windfury requires Enhancer");

--[[ Create the AddOn                                                 ]]
local AddOn = LibStub("AceAddon-3.0"):NewAddon("Enhancer_Windfury", "AceEvent-3.0", "AceTimer-3.0");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer"); -- Yes I cheat and use Enhancers locale (for now)

--[[ local print = function(...) AddOn:PrintFunction(...); end;       ]]
local print = function(...) Enhancer:PrintFunction(...); end;
local debug = function(...) Enhancer:DebugFunction(...); end;

--[[ Windfury proc for Enhancer                                       ]]

local defaults = {
	profile = {
		buttonSettings = { bg = optionsBg, noResize = true, x = 0, y = 0 }
	}
};

function AddOn:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("WindfuryDB", defaults);
	self.button = Enhancer:CreateButton("windfury", self.db.profile.buttonSettings);
	self.button:SetIcon([[Interface\AddOns\Enhancer\textures\EnhancerSSWF.tga]]);
	self.button:SetTexture([[Interface\AddOns\Enhancer\textures\buttonNo.tga]]);
	self.button.Texture:SetBlendMode("ADD");
	self.button.Texture:SetVertexColor(1, 0.1, 0.1);
	self.button.Texture:SetAlpha(0);
	self.button.Cooldown.omniccfixed = true;
	self.button.Cooldown.noomnicc = true; -- will disable omnicc
	
	Enhancer.extras[#Enhancer.extras+1] = self.button;
	
	local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable();
	self.spellName = BS["Windfury Attack"];
	self.spellName2 = BS["Stormstrike"];
	
	
	self.button:SetAttribute("type1", "spell");
	self.button:SetAttribute("spell1", BS["Stormstrike"]);
	self.button:SetAttribute("type2", "spell");
	self.button:SetAttribute("spell2", BS["Windfury Weapon"]);
	
	BS = nil;
end

function AddOn:OnEnable()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEvent");
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "CombatStart");
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "CombatEnd");
end

function AddOn:OnDisable()
	self:UnregisterAllEvents();
	self:CancelAllScheduledEvents();
end

function AddOn:StormstrikeCooldown(timerInfo)
	local start, duration = GetSpellCooldown(self.spellName2);
	if (not tonumber(start)) then return; end
	if (not tonumber(duration)) then return; end
	local cd = ceil(start + duration - GetTime());
	
	if (cd > 0) then
		self.button:SetText(cd, "Top");
		
		if (not self.button:Get("Running")) then
			self.button.Texture:SetAlpha(0.7);
			self.button:Set("Running", true);
		end
	elseif (self.button:Get("Running")) then
		self.button:Pulse();
		self.button:Set("Running", nil);
		
		if (timerInfo) then
			self:CancelTimer(timerInfo.Timer, true);
			timerInfo = nil;
			return;
		end
	else
		if (timerInfo) then
			self:CancelTimer(timerInfo.Timer, true);
			timerInfo = nil;
			return;
		end
	end
end

function AddOn:CombatStart()
	self.button:Set("active", true);
	self.button:UpdateAlpha();
end

function AddOn:CombatEnd()
	self.button:Set("active", false);
	self.button:UpdateAlpha();
end

local lastWindfury = GetTime();
function AddOn:CombatLogEvent(combatLogEventType, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	if (Enhancer:LogIsPlayer(sourceFlags)) then
		local spell = select("2", ...);
		if (spell == self.spellName) then
			
			if (GetTime() - lastWindfury > 1) then
				self.button:SetCooldown(GetTime(), 3);
				self.button:UpdateAlpha();
			end
			lastWindfury = GetTime();
			
		elseif (spell == self.spellName2) then
			self:StormstrikeCooldown();
			local timerInfo = { };
			timerInfo.Timer = self:ScheduleRepeatingTimer("StormstrikeCooldown", 0.3, timerInfo);
		end
	end
end