--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AceLibrary = _G["AceLibrary"];
local Enhancer = LibStub("AceAddon-3.0"):GetAddon("Enhancer");

assert(Enhancer													, "Error, Reincarnation requires Enhancer");

--[[ Create the AddOn                                                 ]]
local AddOn = LibStub("AceAddon-3.0"):NewAddon("Enhancer_Reincarnation", "AceEvent-3.0", "AceTimer-3.0");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer"); -- Yes I cheat and use Enhancers locale (for now)

--[[ local print = function(...) AddOn:PrintFunction(...); end;       ]]
local print = function(...) Enhancer:PrintFunction(...); end;
local debug = function(...) Enhancer:DebugFunction(...); end;

--[[ Reincarnation for Enhancer                                       ]]

local defaults = {
	profile = {
		buttonSettings = { bg = optionsBg, noResize = true, x = 0, y = -130 }
	}
};

function AddOn:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("ReincarnationDB", defaults);
	self.button = Enhancer:CreateButton("reincarnation", self.db.profile.buttonSettings);
	self.button:SetIcon([[Interface/Icons/Spell_Nature_Reincarnation]]);
	self.button.Cooldown.omniccfixed = true;
	self.button.Cooldown.noomnicc = true; -- will disable omnicc
	
	Enhancer.extras[#Enhancer.extras+1] = self.button;
	
	local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable();
	self.spellName = BS["Reincarnation"];
	BS = nil;
end

function AddOn:OnEnable()
	self:BagUpdate();
	
	self:RegisterEvent("PLAYER_ALIVE", "PlayerAlive");
	self:RegisterEvent("BAG_UPDATE", "BagUpdate");
	
	self:ScheduleTimer("CheckReincarnation", 5);
end

function AddOn:OnDisable()
	self:UnregisterAllEvents();
	self:CancelAllScheduledEvents();
end

function AddOn:PlayerAlive()
	self:ScheduleTimer("CheckReincarnation", 5);
end

function AddOn:BagUpdate()
	self.button:SetText(GetItemCount(17030), "Center");
end

function AddOn:CheckReincarnation()
	debug("CheckReincarnation()");
	
	if (self:GetReincarnationIDCached()) then
		local start, duration = self:GetReincarnationCooldown();
		
		if ( start > 0 and duration > 0) then
			--self.button:Show(); -- self.button:SetAlpha(Enhancer.db.profile.btnActiveAlpha);
			local timerInfo = {};
			timerInfo.Timer = self:ScheduleRepeatingTimer("ReincarnationUpdate", 1, timerInfo);
		end
	end
end

function AddOn:GetReincarnationIDCached()
	if (not self.reincarnationID) then
		self.reincarnationID = self:GetReincarnationID()
	else
		local spellName, spellRank = GetSpellName(self.reincarnationID, BOOKTYPE_SPELL)
		if (spellName ~= self.spellName) then
			self.reincarnationID = self:GetReincarnationID();
		end
	end
	return self.reincarnationID;
end

function AddOn:GetReincarnationID()
	local spellCheckID = 1;
	local spellID = nil;
	
	while true do
		local spellName, spellRank = GetSpellName(spellCheckID, BOOKTYPE_SPELL)
		
		if (spellName == self.spellName) then spellID = spellCheckID; break; end
   	if (not spellName) then do break; end end
		
		spellCheckID = spellCheckID + 1;
	end
	
	return spellID;
end

function AddOn:GetReincarnationCooldown()
	local ReincarnationID = self:GetReincarnationIDCached();
	return GetSpellCooldown(ReincarnationID, BOOKTYPE_SPELL);
end



function AddOn:ReincarnationUpdate(timerInfo)
	debug("ReincarnationUpdate(timerInfo)");
	if (self:GetReincarnationIDCached()) then
		local start, duration = self:GetReincarnationCooldown();
		
		if ( start > 0 and duration > 0) then
			local ReincarnationCD = duration - ( GetTime() - start);
			
			self.button:SetText(Enhancer:FormatTime(ReincarnationCD), "Bottom");
		else
			--self.button:Hide(); -- self.button:SetAlpha(Enhancer.db.profile.btnOocAlpha);
			self:CancelTimer(timerInfo.Timer, true);
		end
	end
end