local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AddOn = LibStub("AceAddon-3.0"):GetAddon("Enhancer");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer")

local format, len = _G.string.format, _G.string.len;
local gsub, trim = _G.string.gsub, _G.strtrim;

AddOn.newsCurrent = 5; -- Can only ever increase
function AddOn:News(override)
	if (not override and ((self.db.profile.newsItem or 0) >= self.newsCurrent)) then return; end
	self:CreateNewsFrame();
	
	self.newsFrame:Clear();
	self.newsFrame.title:SetText("|cffffd200"..L["ENHANCER"].."|r");
	self.newsFrame.disclaimer:SetText(L["News Disclaimer"]);
	
	-------- max length for "subject    ","body"---------------------------------------------------
	self.newsFrame:AddLine("Tune In     ","Quick update allowing to hide OmniCC on Enhancers");
	self.newsFrame:AddLine("            ","frames, option can be found in settings to reenable");
	self.newsFrame:AddLine("            ","OmniCC on Enhancer frames (off by default).");
	self.newsFrame:AddLine("            ","");
	-------- max length for "subject    ","body"---------------------------------------------------
	self.newsFrame:AddLine("Turn on     ","Things planned in almost no particular order are|cff00ff00:|r");
	self.newsFrame:AddLine("            ","|cff00ff001) Temporary Enchants (Buttons will now apply it too)");
	self.newsFrame:AddLine("            ","*) Healing Way information");
	self.newsFrame:AddLine("            ","*) Earth Shield Button");
	self.newsFrame:AddLine("            ","*) Water Shield Button");
	self.newsFrame:AddLine("            ","*) Lightning Shield Button");
	self.newsFrame:AddLine("            ","*) Clickthrough buttons option");
	self.newsFrame:AddLine("            ","*) Attack Power meter");
	self.newsFrame:AddLine("            ","");
	-------- max length for "subject    ","body"---------------------------------------------------
	self.newsFrame:AddLine("Burn out    ","All old versions are available at the url listed as");
	self.newsFrame:AddLine("            ","website, if you can't wait for this version to be");
	self.newsFrame:AddLine("            ","finished and are urged to write me an angry letter");
	self.newsFrame:AddLine("            ","about how I updated my repository before everything");
	self.newsFrame:AddLine("            ","was completed then feel free to download");
	self.newsFrame:AddLine("            ","Enhancer-r66928.zip and use the pre 2.4 version though");
	self.newsFrame:AddLine("            ","it is defunct and errorous in some parts");
	self.newsFrame:AddLine("            ","");
	-------- max length for "subject    ","body"---------------------------------------------------
	self.newsFrame:AddLine("            ","");
	self.newsFrame:AddLine("Equivalence", "http://files.wowace.com/EquivalencePoints");
	-------- max length for "subject    ","body"---------------------------------------------------
	self.newsFrame:AddLine("            ",""); -- Some spacing
	self.newsFrame:AddLine("            ","");
	
	self.newsFrame:AddLine(L["Command"],	format(L["'/%s %s' or '/%s %s'"], L["/Enh"], L["cmd name Config"], L["/Enhancer"], L["cmd name Config"]));
	self.newsFrame:AddLine(L["Website"],	self:SpamSafe(L["__URL__"]));
	self.newsFrame:AddLine(L["E-mail"],		self:SpamSafe(L["__EMAIL__"]));
	self.newsFrame:AddLine("", 					"");
	self.newsFrame:AddLine("", 					"THANK YOU:");
	self.newsFrame:AddLine("Isolde", 		"For everything! <3 <3 <3");
	
	-- do return; end
	self.newsFrame:Show();
	self.db.profile.newsItem = self.newsCurrent;
end

function AddOn:SpamSafe(text)
	-- replace ' [dot] ' with '.' and ' [at] ' with '@'
	return gsub(gsub(text, " %[at%] ", "@"), " %[dot%] ", ".");
end

function AddOn:CreateNewsFrame()
	AddOn.newsFrame = CreateFrame("Frame", "AddOnNewsFrame", UIParent, "DialogBoxFrame")
	AddOn.newsFrame:SetWidth(500)
	AddOn.newsFrame:SetHeight(400)
	AddOn.newsFrame:SetPoint("CENTER")
	AddOn.newsFrame:SetBackdrop({
		bgFile = [[Interface\DialogFrame\UI-DialogBox-Background]],
	    edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
	    tile = true, tileSize = 16, edgeSize = 16,
	    insets = { left = 5, right = 5, top = 5, bottom = 5 }
	})
	AddOn.newsFrame:SetBackdropColor(0,0,0,1)

	local text = AddOn.newsFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
	text:SetFont([[Interface\AddOns\Enhancer\fonts\CAS_ANTN.TTF]], 24, "OUTLINE"); -- http://wdnaddons.com/2307561/FrameXML/Fonts.xml
	AddOn.newsFrame.title = text
	text:SetPoint("TOP", 0, -5)

	AddOn.newsFrame:Hide()

	AddOn.newsFrame.lefts = {}
	AddOn.newsFrame.rights = {}
	AddOn.newsFrame.textLefts = {}
	AddOn.newsFrame.textRights = {}
	function AddOn.newsFrame:Clear()
		self.title:SetText("")
		self.disclaimer:SetText("")
		for i = 1, #self.lefts do
			self.lefts[i] = nil
			self.rights[i] = nil
		end
	end
	
	local function rightColor(right)
		-- Email color as link
		right = gsub(right, "[A-Za-z0-9%.%%%+%-]+@[A-Za-z0-9%.%%%+%-]+%.%w%w%w?%w?", function(v) return "|cff007fff"..v.."|r"; end)
		
		-- URL color as link (is crap need better URL matching)
		right = gsub(right, "http%:%/%/[A-Za-z0-9%.%/]+", function(v) return "|cff007fff"..v.."|r"; end)
		
		-- '-quoted color gray
		right = gsub(right, "(%')(%/%w-%s?%w-)(%')", function(v1, v2, v3) return v1.."|cffcccccc"..v2.."|r"..v3; end) --00ff7f
		
		-- *) lists
		right = gsub(right, "^(%*%)%s)(.+)", function(v1, v2) return "|cff00cccc"..v1.."|r"..v2; end)
		
		-- return the mess
		return right;
	end

	function AddOn.newsFrame:AddLine(left, right)
		AddOn.newsFrame.lefts[#AddOn.newsFrame.lefts+1] = trim(left);
		AddOn.newsFrame.rights[#AddOn.newsFrame.rights+1] = rightColor(trim(right));
	end

	local newsFrame_Show = AddOn.newsFrame.Show
	function AddOn.newsFrame:Show(...)
		local maxLeftWidth = 0
		local maxRightWidth = 0
		local textHeight = 0
		for i = 1, #self.lefts do
			if not self.textLefts[i] then
				local left = AddOn.newsFrame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
				left:SetFont([[Interface\AddOns\Enhancer\fonts\CAS_ANTN.TTF]], 12, "OUTLINE");
				self.textLefts[i] = left
				local right = AddOn.newsFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
				right:SetFont([[Interface\AddOns\Enhancer\fonts\Cella.ttf]], 10, "OUTLINE");
				self.textRights[i] = right
				if i == 1 then
					left:SetPoint("TOPRIGHT", AddOn.newsFrame, "TOPLEFT", 75, -35)
				else
					left:SetPoint("TOPRIGHT", self.textLefts[i-1], "BOTTOMRIGHT", 0, -1)
				end
				right:SetPoint("LEFT", left, "RIGHT", 5, 0)
			end
			self.textLefts[i]:SetText(self.lefts[i] .. ((len(self.lefts[i]) > 0 and len(strtrim(self.lefts[i])) > 0 and ":") or " "))
			self.textRights[i]:SetText(self.rights[i])
			local leftWidth = self.textLefts[i]:GetWidth()
			local rightWidth = self.textRights[i]:GetWidth()
			textHeight = self.textLefts[i]:GetHeight()
			if maxLeftWidth < leftWidth then
				maxLeftWidth = leftWidth
			end
			if maxRightWidth < rightWidth then
				maxRightWidth = rightWidth
			end
		end
		for i = #self.lefts+1, #self.textLefts do
			self.textLefts[i]:SetText('')
			self.textRights[i]:SetText('')
		end
		local finalWidth = 85 + maxRightWidth + 10;-- + 10 + 30;
		if (finalWidth < 360) then finalWidth = 360; end
		AddOn.newsFrame:SetWidth(finalWidth)
		AddOn.newsFrame:SetHeight(#self.lefts * (textHeight + 1) + 100)

		newsFrame_Show(self, ...)
	end
	AddOn.newsFrame:Hide()
	
	local disclaimer = AddOn.newsFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
	disclaimer:SetFont([[Interface\AddOns\Enhancer\fonts\Cella.ttf]], 8, "");
	AddOn.newsFrame.disclaimer = disclaimer
	disclaimer:SetPoint("BOTTOMRIGHT", AddOn.newsFrame:GetName(), "BOTTOMRIGHT", -5, 5)
	
	AddOn.CreateNewsFrame = function() return; end;
end