--[[ Local                                                            ]]
local _G = getfenv(0);
local LibStub = _G["LibStub"];
local AceLibrary = _G["AceLibrary"];

local assert, setmetatable, getmetatable = assert, setmetatable, getmetatable;
local type, date = type, date;
local format = string.format;
local floor = math.floor;

--[[ ASSERT (This file only)                                          ]]
assert(LibStub													, "Error, Enhancer requires LibStub");
assert(LibStub("AceAddon-3.0")					, "Error, Enhancer requires AceAddon-3.0");
assert(LibStub("AceConsole-3.0")				, "Error, Enhancer requires AceConsole-3.0");
assert(LibStub("AceEvent-3.0")					, "Error, Enhancer requires AceEvent-3.0");
assert(LibStub("AceTimer-3.0")					, "Error, Enhancer requires AceTimer-3.0");
assert(LibStub("AceDB-3.0")							, "Error, Enhancer requires AceDB-3.0");
assert(LibStub("AceSerializer-3.0")			, "Error, Enhancer requires AceSerializer-3.0");
assert(LibStub("AceLocale-3.0")					, "Error, Enhancer requires AceLocale-3.0");
assert(AceLibrary												, "Error, Enhancer requires Ace2");

--[[ Create the AddOn                                                 ]]
local AddOn = LibStub("AceAddon-3.0"):NewAddon("Enhancer", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0", "AceComm-3.0", "LibSink-2.0");
local L = LibStub("AceLocale-3.0"):GetLocale("Enhancer")

--[[ local print = function(...) AddOn:PrintFunction(...); end;       ]]
function AddOn:PrintFunction(...) _G["print"](L["_print"], ...); end
function AddOn:DebugFunction(...) if (AddOn.debug) then _G["print"](format(L["_debug"], date("[%H:%M:%S]")), ...); end end -- date("[%Y-%m-%d %H:%M:%S]")

--[[ Some functions I sometimes find usefull (remove later)           ]]

AddOn.slotElement = {
	[FIRE_TOTEM_SLOT] = L["Fire"], -- 1
	[EARTH_TOTEM_SLOT] = L["Earth"], -- 2
	[WATER_TOTEM_SLOT] = L["Water"], -- 3
	[AIR_TOTEM_SLOT] = L["Air"], -- 4
};

function AddOn.table_copy(from, to)
	assert(type(from) == "table", "Bad argument #1 to 'table_copy(from, to)' (table expected)");
	to = to or {}; -- Destination is either a supplied table or a new table
	
	for key, value in pairs(from) do 
		local newKey = ((type(key) == "table") and AddOn.table_copy(key)) or key;
			
		if (type(value) == "table") then
			to[newKey] = AddOn.table_copy(value);
		else
			to[newKey] = value;
		end
	end
	
	setmetatable(to, getmetatable(from));
	return to;
end

function AddOn.math_round(number, decimals)
	assert(type(number) == "number", "Bad argument #1 to 'round(number, decimals)' (number expected)");
	assert(type(decimals) == "number" or type(decimals) == "nil", "Bad argument #2 to 'round(number, decimals)' (number or nil expected)");
	
  local multiplier = (10^(decimals or 0));
  return floor(number * multiplier + 0.5) / multiplier;
end;