
-- if the Debug library is available then use it
if AceLibrary:HasInstance("AceDebug-2.0") then
	EnhCP = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceHook-2.1", "AceDebug-2.0")
--	EnhCP:SetDebugging(true)
else
	EnhCP = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceHook-2.1")
	function EnhCP:Debug() end
end

-- specify where debug messages go
EnhCP.debugFrame = ChatFrame7

function EnhCP:OnEnable()
--	self:Debug("OnEnable")

	-- Initial setup when starting, reloading or zoning
	self:RegisterEvent("AceEvent_FullyInitialized", "Addon_FullyInitialized")
	
	-- when addon taken out of standby
	if AceLibrary("AceEvent-2.0"):IsFullyInitialized() then
		self:Addon_FullyInitialized()
	end
	
end

function EnhCP:Addon_FullyInitialized()
--	self:Debug("Addon_FullyInitialized")
	
	-- hook the functions to be used on a change of colour and opacity
	self:HookScript(ColorPickerFrame, "OnColorSelect", function()
--		self:Debug("CPF - OnColorSelect")
		self.hooks[ColorPickerFrame].OnColorSelect()
		self:UpdateEB(arg1, arg2, arg3, this.opacity)
		end)
		
	self:HookScript(ColorPickerFrame, "OnShow", function()
--		self:Debug("CPF - OnShow")
		self.hooks[ColorPickerFrame].OnShow()
		-- show/hide the Alpha Edit box as required
		if this.hasOpacity then 
			EnhCPAlphaBox:Show() 
			EnhCPAlphaBoxLabel:Show() 
			EnhCPAlphaBoxText:Show()
		else
			EnhCPAlphaBox:Hide() 
			EnhCPAlphaBoxLabel:Hide() 
			EnhCPAlphaBoxText:Hide()		
		end
	
		end)
		
	self:HookScript(OpacitySliderFrame, "OnValueChanged", function()
--		self:Debug("OSF - OnValueChanged")
		self.hooks[OpacitySliderFrame].OnValueChanged()
		self:UpdateEB(nil, nil, nil, this.opacity)
		end)
		
	-- Add Buttons and EditBoxes to the original ColorPicker Frame
	local cb = CreateFrame("Button", "EnhCPCopy", ColorPickerFrame, "UIPanelButtonTemplate")
	cb:SetText("Copy")
	cb:SetWidth("75")
	cb:SetHeight("22")
	cb:SetPoint("BOTTOMLEFT", "ColorPickerFrame", "TOPLEFT", 10, -32)
	cb:SetScript("OnClick", function() 
		local r, g, b = ColorPickerFrame:GetColorRGB()
		local a
		if ColorPickerFrame.hasOpacity then
			a = OpacitySliderFrame:GetValue()
		else
			a = 1
		end
		local CurrentlyCopiedColor = _G.CurrentlyCopiedColor
		if not CurrentlyCopiedColor then
			CurrentlyCopiedColor = {}
			_G.CurrentlyCopiedColor = CurrentlyCopiedColor
		end
		CurrentlyCopiedColor.r = r
		CurrentlyCopiedColor.g = g
		CurrentlyCopiedColor.b = b
		CurrentlyCopiedColor.a = a
	end)
	
	local pb = CreateFrame("Button", "EnhCPPaste", ColorPickerFrame, "UIPanelButtonTemplate")
	pb:SetText("Paste")
	pb:SetWidth("75")
	pb:SetHeight("22")
	pb:SetPoint("BOTTOMRIGHT", "ColorPickerFrame", "TOPRIGHT", -10, -32)
	pb:SetScript("OnClick", function()
		local CurrentlyCopiedColor = _G.CurrentlyCopiedColor
		if CurrentlyCopiedColor then
			ColorPickerFrame:SetColorRGB(CurrentlyCopiedColor.r, CurrentlyCopiedColor.g, CurrentlyCopiedColor.b)
			if ColorPickerFrame.hasOpacity then
				OpacitySliderFrame:SetValue(CurrentlyCopiedColor.a)
			end
			ColorSwatch:SetTexture(CurrentlyCopiedColor.r, CurrentlyCopiedColor.g, CurrentlyCopiedColor.b)
		end 
	end)
		
	-- move the Color Picker Wheel
	ColorPickerWheel:ClearAllPoints()
	ColorPickerWheel:SetPoint("TOPLEFT", 16, -34)
	-- move the Opacity Slider Frame
	OpacitySliderFrame:ClearAllPoints()
	OpacitySliderFrame:SetPoint("TOPLEFT", "ColorSwatch", "TOPRIGHT", 52, -4)
		
	local editBoxes = { "Red", "Green", "Blue", "Alpha" }	
	for i = 1, table.getn(editBoxes) do
	
		local ebn = editBoxes[i]
		local obj = CreateFrame("EditBox", "EnhCP"..ebn.."Box", ColorPickerFrame, "InputBoxTemplate")
		obj:SetFrameStrata("DIALOG")
		obj:SetMaxLetters(4)
		obj:SetAutoFocus(false)
		obj:SetWidth(35)
		obj:SetHeight(25)
		obj:SetID(i)
		if i == 1 then 
			obj:SetPoint("TOPLEFT", 265, -68)
		else
			obj:SetPoint("TOP", "EnhCP"..editBoxes[i - 1].."Box", "BOTTOM", 0, 3)
		end
		obj:SetScript("OnEscapePressed", function()	this:ClearFocus() EnhCP:UpdateEB() end)
		obj:SetScript("OnEnterPressed", function() this:ClearFocus() EnhCP:UpdateEB() end)
		obj:SetScript("OnTextChanged", function() EnhCP:UpdateColour_Alpha() end)
		obj:SetScript("OnEditFocusGained", function() EnhCP.editBoxFocus = true end)
		obj:SetScript("OnEditFocusLost", function()	EnhCP.editBoxFocus = nil end)
		local objl = obj:CreateFontString("EnhCP"..ebn.."BoxLabel", "ARTWORK", "GameFontNormal")
		objl:SetPoint("RIGHT", "EnhCP"..ebn.."Box", "LEFT", -38, 0)
		objl:SetText(string.sub(ebn, 1, 1)..":")
		objl:SetTextColor(1, 1, 1)
		local objl = obj:CreateFontString("EnhCP"..ebn.."BoxText", "ARTWORK", "GameFontNormal")
		objl:SetPoint("LEFT", "EnhCP"..ebn.."Box", "LEFT", -38, 0)
		objl:SetTextColor(1, 1, 1)
		
		obj:Show()
	end
	-- define the Tab Pressed Scripts
	EnhCPRedBox:SetScript("OnTabPressed", function() EnhCPGreenBox:SetFocus() end)
	EnhCPGreenBox:SetScript("OnTabPressed", function() EnhCPBlueBox:SetFocus() end)
	EnhCPBlueBox:SetScript("OnTabPressed", function() EnhCPAlphaBox:SetFocus() end)
	EnhCPAlphaBox:SetScript("OnTabPressed", function() EnhCPRedBox:SetFocus() end)
	
	-- move buttons & skin EditBoxes if Skinner is present
	if IsAddOnLoaded("Skinner") then
		if Skinner.db.profile.Colours then 
			Skinner:moveObject(EnhCPCopy, nil, nil, "+", 4)
			Skinner:moveObject(EnhCPPaste, nil, nil, "+", 4)
		end
		Skinner:skinEditBox(EnhCPRedBox, {9,10})
		Skinner:moveObject(EnhCPRedBox, "-", 10, nil, nil)
		Skinner:moveObject(EnhCPRedBoxLabel, "+", 10, nil, nil)
		Skinner:moveObject(EnhCPRedBoxText, "+", 10, nil, nil)
		Skinner:skinEditBox(EnhCPGreenBox, {9,10})
		Skinner:moveObject(EnhCPGreenBoxLabel, "+", 10, nil, nil)
		Skinner:moveObject(EnhCPGreenBoxText, "+", 10, nil, nil)
		Skinner:skinEditBox(EnhCPBlueBox, {9,10})
		Skinner:moveObject(EnhCPBlueBoxLabel, "+", 10, nil, nil)
		Skinner:moveObject(EnhCPBlueBoxText, "+", 10, nil, nil)
		Skinner:skinEditBox(EnhCPAlphaBox, {9,10})
		Skinner:moveObject(EnhCPAlphaBoxLabel, "+", 10, nil, nil)
		Skinner:moveObject(EnhCPAlphaBoxText, "+", 10, nil, nil)
	end
	
end

function EnhCP:UpdateColour_Alpha()
--	self:Debug("UpdateColour_Alpha: [%s, %s]", this:GetID(), this:GetText())

	if not this:GetText() or this:GetText() == "" then return end
	
	local r, g, b = ColorPickerFrame:GetColorRGB()
	local a = OpacitySliderFrame:GetValue()
	
--	self:Debug("UpdateColour_Alpha#2: [%s, %s, %s, %s]", r, g, b, a)

	local id = this:GetID()
	
	if id == 1 then
		r = string.format("%.2f", this:GetNumber())
		if not r then r = 0 end
	elseif id == 2 then
		g = string.format("%.2f", this:GetNumber())
		if not g then g = 0 end
	elseif id == 3 then
		b = string.format("%.2f", this:GetNumber())
		if not b then b = 0 end
	else
		a = string.format("%.2f", this:GetNumber())
		if not a then a = 0 end
	end

--	self:Debug("UpdateColour_Alpha#3: [%s, %s, %s, %s]", r, g, b, a)

	if id ~= 4 then 
		ColorPickerFrame:SetColorRGB(r, g, b)
		ColorSwatch:SetTexture(r, g, b)
	else
		OpacitySliderFrame:SetValue(a)
	end
	
end

function EnhCP:UpdateEB(r, g, b, a)
--	self:Debug("UpdateEB: [%s, %s, %s, %s]", r, g, b, a)

	if self.editBoxFocus then return end

	if not r then r, g, b = ColorPickerFrame:GetColorRGB() end
	if not a then a = OpacitySliderFrame:GetValue() end
	
--	self:Debug("UpdateEB#2: [%s, %s, %s, %s]", r, g, b, a)
	
    EnhCPRedBoxText:SetText(string.format("%.2f", r))
    EnhCPGreenBoxText:SetText(string.format("%.2f", g))
    EnhCPBlueBoxText:SetText(string.format("%.2f", b))
    EnhCPAlphaBoxText:SetText(string.format("%.2f", a))

    EnhCPRedBox:SetText("")
    EnhCPGreenBox:SetText("")
    EnhCPBlueBox:SetText("")
    EnhCPAlphaBox:SetText("")

end
