--[[
Name: Auction-1.0
Revision: $Rev: 39 $
Author(s): Shamino (Shamino.wow@gmail.com)
Website: http://www.wowace.com/index.php/Auction-1.0
Documentation: http://www.wowace.com/index.php/Auction-1.0
SVN: http://svn.wowace.com/wowace/trunk/Auction-1.0
Description: Provides a library for accessing auction data and pricing from various Auction Data mods
Dependencies: AceLibrary, AceEvent-2.0
--]]

local MAJOR_VERSION = "Auction-1.0"
local MINOR_VERSION = 90000 + tonumber(("$Revision: 39 $"):match("(%d+)"))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary.") end
if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local AuctionLib = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0")

function AuctionLib:OnInitialize()
	self:RegisterEvent("ADDON_LOADED");
end

--find supported addons.  if one is found, automatically set it to be used.
-- it will stop looking after the first one is found
function AuctionLib:ADDON_LOADED()
	if (not self.autofound) then
		for k, v in pairs(self.supportedAddons) do
			if (k == arg1) then
				self:SetAuctionAddon(arg1);
				self.autofound=true;
				self:UnregisterEvent("ADDON_LOADED");
			end
		end
	end
end

function AuctionLib:GetSupportedAuctionAddons()
	local tab={};
	for k, v in pairs(self.supportedAddons) do
		table.insert(tab, k);
	end
	return tab;
end

function AuctionLib:SetAuctionAddon(addon)
	if (IsAddOnLoaded(addon) and self.supportedAddons[addon]) then
		self.AuctionAddon=addon;
		return true;
	else
		self:error("'%q' is not supported or not currently loaded", addon);
		return false;
	end
end

function AuctionLib:GetAuctionAddon()
	return self.AuctionAddon;
end


function AuctionLib:GetPrice(itemLink)
	if not itemLink then return end
	
	--todo, raise error. auction addon needs to be established
	if not self.AuctionAddon then 
		self:error("Auction Addon has not yet been set.  Use SetAuctionAddon");
		return 
	end

	return self:pcall(self.supportedAddonsFunctions[self.AuctionAddon], itemLink)
end

function AuctionLib:GetAuctioneerPrice(itemLink)
	   local itemID, randomProp, enchant = EnhTooltip.BreakLink(itemLink);
	   local itemKey = itemID..":"..randomProp..":"..enchant;	

	   local medianPrice, medianCount;

	   if (Auctioneer and Auctioneer.Statistic and Auctioneer.Statistic.GetUsableMedian) then
		medianPrice, medianCount = Auctioneer.Statistic.GetUsableMedian(itemKey);
	   else 
		return nil;
	   end

	   if (not medianCount or not medianPrice) then
		return nil;
	   end

	   if (medianCount < 5 or medianPrice == 0) then
		return nil;
	   else
		return medianPrice;
	   end
end

function AuctionLib:GetAucAdvancedPrice(itemLink)
	local price, seen, count = AucAdvanced.API.GetMarketValue(itemLink);
	return price;
end

--based on the KC_Items tooltip logic. This function will return the recent buyout price that is displayed in the KC_Items tooltip.
function AuctionLib:GetKCItemsPrice(itemLink)
        local itemID, suffixID = itemLink:match("item:(%-?%d+):(%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:)%-?%d+")
        itemID = suffixID:match("[1-9]") and ("%s:%s0"):format(itemID, suffixID) or itemID
	local fullID = ("%s:%s0"):format(itemID, suffixID)

-- KC_Items tooltip logic
--	    if mktV then 
--		if mAvg > 0 then tt:AddPriceLine(self:Round((mAvg-mStdDev) * tt.qty), self.db.profile.labels.mAvg, self.db.profile.labels.sep) end
--		if hmAvg > 0 then tt:AddPriceLine(self:Round((hmAvg-mStdDev) * tt.qty), self.db.profile.labels.hmAvg, self.db.profile.labels.sep) end
--		tt:CleanUp()
--		tt:AddBlankLine()
--		if yAvg > 0 then tt:AddPriceLine(self:Round((yAvg-yStdDev) * tt.qty), self.db.profile.labels.yAvg, self.db.profile.labels.sep) end
--		if hyAvg > 0 then tt:AddPriceLine(self:Round((hyAvg-yStdDev) * tt.qty), self.db.profile.labels.hyAvg, self.db.profile.labels.sep) end
--	    end

	--based on the KC_Items tooltip logic. This function will return the recent buyout price that is displayed in the KC_Items tooltip.
	local mktV, hmktV, avgStkSz, stkSzCfrm, mAvg, hmAvg, mStdDev, mMax, yAvg, hyAvg, yStdDev, yMin, bAvg, hbAvg, bStdDev, bMax = AuctionSpy:GetItemInfo(UnitFactionGroup("player"), fullID)
	if mktV and yAvg > 0 then
		return math.floor(((yAvg-yStdDev) * (10^0)) + .5) / (10^0)
	else 
		return 0;
	end    
end

function AuctionLib:GetWowEconPrice(itemLink)
	--integer:auction_price in copper, integer:auction_volume, bool:server-specific data
	local auction_price, auction_volume = WOWEcon_GetAuctionPrice_ByLink(itemLink);

	if (auction_price) then
		return auction_price;
	else 
		return nil;
	end
end

local function AuctionLib_NameFromLink(link)
	local itemName = GetItemInfo(link);
	return itemName;
end

local function activate(self, oldLib, oldDeactivate)
	--used to listen for addons being loaded.  will be true if one of the supported addons is found via ADDON_LOADED event
	self.autofound=false;

	--setup the supported auction addons
	self.supportedAddons={
		["Auctioneer"]="Auctioneer",
		["Auc-Advanced"]="Auc-Advanced",
		["KC_Items"]="KC_Items",
		["WOWEcon_PriceMod"]="WOWEcon_PriceMod",
	}
	self.supportedAddonsFunctions={
		["Auc-Advanced"] = function(itemLink)
			return self:GetAucAdvancedPrice(itemLink)
		end,
		["Auctioneer"] = function(itemLink)
			return self:GetAuctioneerPrice(itemLink)
		end,
		["KC_Items"] = function(itemLink)
			return self:GetKCItemsPrice(itemLink)
		end,
		["WOWEcon_PriceMod"] = function(itemLink)
			return self:GetWowEconPrice(itemLink)
		end,
	}

	if oldLib then -- if upgrading
		self.AuctionAddon = oldLib.AuctionAddon
		self.autofound = oldLib.autofound
	end

	if oldDeactivate then -- clean up the old library
		oldDeactivate(oldLib)
	end
end

AceLibrary:Register(AuctionLib, MAJOR_VERSION, MINOR_VERSION, activate)
AuctionLib = nil
