local L = AceLibrary("AceLocale-2.2"):new("EnchantingSell")

    EnchantingSell_Quality = {
	["Quality_Health"] = {
		[1] = {"Minor"; 5};
		[2] = {"Lesser"; 15};
		[3] = {"None"; 25};
		[4] = {"Greater"; 35};
		[5] = {"Superior"; 50};
		[6] = {"Major"; 100};
		[7] = {"Exceptional"; 150};
	};
	["Quality_Deflection"] = {
		[1] = {"Minor"; 2};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
	};
	["Quality_Mana"] = {
		[1] = {"Minor"; 5};
		[2] = {"Lesser"; 20};
		[3] = {"None"; 30};
		[4] = {"Greater"; 50};
		[5] = {"Superior"; 65};
		[6] = {"Major"; 100};
--		[7] = {"Exceptional"; 150};		--added but commented out.  this is not currently in-game
	};
	["Quality_Absorption"] = {
		[1] = {"Minor"; "2% Abs10pd"};
		[2] = {"Lesser"; "5% Abs25pd"};
	};
	["Quality_OneCarac"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
		[4] = {"Greater"; 7};
		[5] = {"Superior"; 9};
		[6] = {"Major"; 9};
	};
	["Quality_Int_Bracers"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
		[4] = {"Greater"; 7};
		[5] = {"Superior"; 9};
		[6] = {"Major"; 12};
	};
	["Quality_Int_2HWeapon"] = {
		[1] = {"Lesser"; 3};
		[2] = {"Major"; 9};
	};
	["Quality_Int_Weapon"] = {
		[1] = {"Mighty"; 22};
		[2] = {"Major"; 30};
	};
	["Quality_Spirit_Weapon"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
		[4] = {"Greater"; 7};
		[5] = {"Superior"; 9};
		[6] = {"Major"; 9};
		[7] = {"Mighty"; 20};
	};
	["Quality_Caract"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 2};
		[3] = {"None"; 3};
		[4] = {"Greater"; 4};
		[5] = {"Exceptional"; 6};
	};
	["Quality_Armure"] = {
		[1] = {"Minor"; 10};
		[2] = {"Lesser"; 20};
		[3] = {"None"; 30};
		[4] = {"Greater"; 50};
		[5] = {"Superior"; 70};
	};
	["Quality_Degat1M"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 2};
		[3] = {"None"; 3};
		[4] = {"Greater"; 4};
		[5] = {"Superior"; 5};
		[6] = {"Major"; 7};
	};
	["Quality_Degat2M"] = {
		[1] = {"Minor"; 2};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
		[4] = {"Greater"; 7};
		[5] = {"Superior"; 9};
	};
	["Quality_Tueur"] = {
		[1] = {"Minor"; 2};
		[2] = {"Lesser"; 6};
	};
	["Quality_Metier"] = {
		[1] = {"None"; 2};
		[2] = {"Advanced"; 5};
	};
	["Quality_Cloak_FireResist"] = {
		[1] = {"Lesser"; 5};
		[2] = {"None"; 7};
		[3] = {"Greater"; 15};
	};
	["Quality_Cloak_ShadowResist"] = {
		[1] = {"Lesser"; 10};
		[2] = {"Greater"; 15};
	};
	["Quality_Agility_2HWeapon"] = {
		[1] = {"None"; 25};
		[2] = {"Major"; 35};
	};
	["Quality_Agility_Weapon"] = {
		[1] = {"None"; 15};
		[2] = {"Greater"; 20};
	};
	["Quality_AllResist"] = {
		[1] = {"Minor"; 1};
		[2] = {"None"; 3};
		[3] = {"Greater"; 5};
		[4] = {"Major"; 7};
	};
	["Quality_ForNew"] = {
		[1] = {"Minor"; 0};
		[2] = {"Lesser"; 0};
		[3] = {"None"; 0};
		[4] = {"Greater"; 0};
		[5] = {"Superior"; 0};
		[6] = {"Major"; 0};
	};
	["Quality_Agility_Gloves"] = {
		[1] = {"None"; 5};
		[2] = {"Greater"; 7};
		[3] = {"Superior"; 15};
	};
	["Quality_Agility_Cloak"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 3};
		[3] = {"Greater"; 12};
	};
	["Quality_Mana_Regen"] = {
		[1] = {"None"; 4};
	};
	["Quality_Stamina_Shield"] = {
		[1] = {"Minor"; 1};
		[2] = {"Lesser"; 3};
		[3] = {"None"; 5};
		[4] = {"Greater"; 7};
		[5] = {"Major"; 18};
	};
	["Quality_Block_Shield"] = {
		[1] = {"Lesser"; 10};
		[2] = {"Shield"; 15};
	};
	["Quality_Strength_Gloves"] = {
		[1] = {"None"; 5};
		[2] = {"Greater"; 7};
		[3] = {"Major"; 15};
	};
	["Quality_SplPwr_Weapon"] = {
		[1] = {"None"; 30};
		[2] = {"Major"; 40};
	};
    };
    
L:RegisterTranslations("enUS", function() return {
    ["Enchanting"] = true,
    ["Enchant"] = true,
    ["Enchanting Seller"] = true,
    ["Filter By Armor"] = true,
    ["Have Materials"] = true,
    ["Sort by feasibility"] = true,
    ["EnchantingSeller has prevented you from changing this filter.  Changing this filter can have an unexpected result while using EnchantingSeller."] = true,
    ["EnchantingSeller has detected that your database is outdated.  It will be reset now."] = true,
    ["PATTERN_EnchantName"] = "^(.+)%s%-%s.+",
    ["PATTERN_Quality"] = "^.+%s%-%s(.+)",
    ["Header tooltip"] = "Click to Sort this column",
    ["Reagent Header tooltip"] = "Click to send reagent list to chat",
    ["A copy of your enchants and reagents has been created.  Logoff and exit the game and follow the rest of the instructions"] = true,
    ["Default database not yet supported for your client locale"] = true,
    ["Import complete"] = true,
    ["Waterfall-1.0 is required to access the GUI."] = true,
    ["\n|cffeda55fShift-Click|r to open Enchanting.\n|cffeda55fAlt-Click|r to open Options.\n|cffeda55fLeft-Click|r to toggle EnchantingSell"] = true,
    ["ENCHANT_ALT"] = "Color Schemes:\n\rClear green-> You have all the ingredients and rod in your bags.\n\rDark green-> Some ingredients necessary are in the bank.\n\rBrown-> Some ingredients necessary are on Alts.\n\rGray-> You do not know this enchant.";

    ["ARMOR_TYPES"] = {
	[1] = {"Boots", "Boots"};
	[2] = {"Bracer", "Bracer"};
	[3] = {"Chest", "Chest"};
	[4] = {"Cloak", "Cloak"};
	[5] = {"Gloves", "Gloves"};
	[6] = {"Oil", "Oil"};
	[7] = {"Ring", "Ring"};
	[8] = {"Rod", "Rod"};
	[9] = {"Shield", "Shield"};
	[10] = {"Trinket", "Trinket"};
	[11] = {"Wand", "Wand"};
	[12] = {"2H Weapon", "2H Weap"};
	[13] = {"Weapon", "Weapon"};
	[14] = {"Other", "Other"};
    };
    ["OBJECT_TYPES"] = {
	{"Runed Copper Rod", "Runed Copper", "Rod"},
	{"Runed Silver Rod", "Runed Silver", "Rod"},
	{"Runed Golden Rod", "Runed Golden", "Rod"},
	{"Runed Truesilver Rod", "Runed Truesilver", "Rod"},
	{"Runed Arcanite Rod", "Runed Arcanite", "Rod"},
	{"Runed Fel Iron Rod", "Runed Fel Iron", "Rod"},
	{"Runed Adamantite Rod", "Runed Adamantite", "Rod"},
	{"Runed Eternium Rod", "Runed Eternium", "Rod"},
	{"Lesser Magic Wand", "(Arc)dps:11.3", "Wand"},
	{"Greater Magic Wand", "(Arc)dps:17.5", "Wand"},
	{"Lesser Mystic Wand", "(Arc)dps:25.4", "Wand"},
	{"Greater Mystic Wand", "(Arc)dps:29.0", "Wand"},
	{"Minor Mana Oil", "Mana +4", "Oil"},
	{"Lesser Mana Oil", "Mana +8", "Oil"},
	{"Brilliant Mana Oil", "Mana +12", "Oil"},
	{"Superior Mana Oil", "Mana +14", "Oil"},
	{"Minor Wizard Oil", "Spl Dmg +8", "Oil"},
	{"Lesser Wizard Oil", "Spl Dmg +16", "Oil"},
	{"Wizard Oil", "Spl Dmg +24", "Oil"},
	{"Brilliant Wizard Oil", "Spl Dmg +36", "Oil"},
	{"Superior Wizard Oil", "Spl Dmg +42", "Oil"},
	{"Enchanted Thorium", "Enchanted Thorium", "Other"},
	{"Enchanted Leather", "Enchanted Leather", "Other"},
	{"Charged Scale of Onyxia", "Charged Scale of Onyxia", "Other"},
	{"Smoking Heart of the Mountain", "Smoking Heart of the Mountain", "Trinket"},
	{"Large Prismatic Shard", "Large Prismatic", "Other"},
	{"Prismatic Sphere", "Prismatic Sphere", "Other"},
	{"Void Sphere", "Void Sphere", "Other"},
	{"Nexus Transformation", "Nexus Transformation", "Other"},
	{"Small Prismatic Shard", "Small Prismatic Shard", "Other"},
	{"Void Shatter", "Void Shatter", "Other"},
    };

-- to transform (Quality add) to (ShortQuality +number)
-- exemple : for (Enchant Bracer - Minor Stamina)
-- name is (Enchant Bracer); and Quality is (Minor Stamina)
-- for the name the mod check if exist in table EnchantingSell_ArmorCarac[i][1];
-- 		EnchantingSell_ArmorCarac[2][1] == Bracer, ok is good; show in framemod EnchantingSell_ArmorCarac[2][2] (Bracer)
-- for the quality the mod check if exist in table EnchantingSell_BonusCarac[i][1];
--		EnchantingSell_BonusCarac[12][1] == Stamina, ok is good; show in framemod EnchantingSell_BonusCarac[12][1] (Sta);
--		now for add check in table EnchantingSell_BonusCarac[7][3](ref in other table EnchantingSell_Quality) if exist,
--		ok for Minor in ["Quality_OneCarac"] is (1)
-- (Enchant Bracer - Minor Stamina) become (Bracer Sta +1)
-- the fourting param (EnchantingSell_BonusCarac[i][4]) is for characteristic, exemple for protection on the shield Lesser = +30 and normally is +20
    ["BONUS_TYPES"] = {
	{"Intellect";							"Int";					{[1] = {"None"; 12}};								"Shield"};
	{"Intellect";							"Int";					EnchantingSell_Quality["Quality_Int_Weapon"];					"Weapon"};
	{"Intellect";							"Int";					EnchantingSell_Quality["Quality_Int_2HWeapon"];					"2H Weap"};
	{"Intellect";							"Int";					EnchantingSell_Quality["Quality_Int_Bracers"];			nil};
	{"Agility";							"Agi";					EnchantingSell_Quality["Quality_Agility_Weapon"];				"Weapon"};
	{"Agility";							"Agi";					EnchantingSell_Quality["Quality_Agility_2HWeapon"];				"2H Weap"};
	{"Agility";							"Agi";					EnchantingSell_Quality["Quality_Agility_Gloves"];				"Gloves"};
	{"Agility";							"Agi";					EnchantingSell_Quality["Quality_Agility_Cloak"];			"Cloak"};
	{"Agility";							"Agi";					EnchantingSell_Quality["Quality_OneCarac"];			nil};
	{"Dexterity";							"Agi";					{[1] = {"None"; 12}};								"Boots"};
	{"Stamina";							"Sta";					EnchantingSell_Quality["Quality_Stamina_Shield"];				"Shield"};
	{"Stamina";							"Sta";					EnchantingSell_Quality["Quality_OneCarac"];			nil};
	{"Fortitude";							"Sta";					{[1] = {"None"; 12}};								nil};
	{"Spirit";							"Spi";					EnchantingSell_Quality["Quality_Spirit_Weapon"];				"Weapon"};
	{"Spirit";							"Spi";					{[1] = {"Major"; 15}};								"Chest"};
	{"Spirit";							"Spi";					EnchantingSell_Quality["Quality_OneCarac"];			nil};
	{"Strength";							"Str";					{[1] ={"None"; 15}};								"Weapon"};
	{"Strength";							"Str";					EnchantingSell_Quality["Quality_Strength_Gloves"];				"Gloves"};
	{"Strength";							"Str";					EnchantingSell_Quality["Quality_OneCarac"];			nil};
	{"Potency";							"Str";					{[1] ={"None"; 20}};								"Weapon"};
	{"Brawn";							"Str";					{[1] = {"None"; 12}};								"Bracer"};
	{"Stats";							"AllStats";				EnchantingSell_Quality["Quality_Caract"];			"Chest"};
	{"Stats";							"AllStats";				{[1] = {"None"; 4}};						"Bracer"};
	{"Stats";							"AllStats";				{[1] = {"None"; 4}};								"Ring"};
	{"Assault";							"AP";					{[1] = {"None"; 24}};								"Bracer"};
	{"Assault";							"AP";					{[1] = {"None"; 26}};								"Gloves"};
	{"Savagery";							"AP";					{[1] ={"None"; 70}};								"2H Weap"};
	{"Striking";							"Damage";				{[1] = {"None"; 2}};								"Ring"};
	{"Striking";							"Damage";				EnchantingSell_Quality["Quality_Degat1M"];			nil};
	{"Impact";							"Damage";				EnchantingSell_Quality["Quality_Degat2M"];			nil};
	{"Haste";							"At speed";				{[1] = {"Minor"; "1%"}};						nil};
	{"Spellpower";							"Spl Dmg";				{[1] = {"None"; 12}};								"Ring"};
	{"Spellpower";							"Spl Dmg";				{[1] = {"None"; 15}};								"Bracer"};
	{"Spellpower";							"Spl Dmg";				EnchantingSell_Quality["Quality_SplPwr_Weapon"];				"Weapon"};
	{"Major Spellpower";						"Spl Dmg";				{[1] = {"None"; 20}};								"Gloves"};
	{"Shadow Power";						"Sha Dmg";				{[1] = {"None"; 20}};								"Gloves"};
	{"Frost Power";							"Frost Dmg";				{[1] = {"None"; 20}};								"Gloves"};
	{"Fire Power";							"Fire Dmg";				{[1] = {"None"; 20}};								"Gloves"};
	{"Healing Power";						"Healing";				{[1] = {"None"; 55}};								"Weapon"};
	{"Healing Power";						"Healing";				{[1] = {"None"; 30}};								"Gloves"};
	{"Healing Power";						"Healing";				{[1] = {"None"; 24}};								"Bracer"};
	{"Healing Power";						"Healing";				{[1] = {"None"; 20}};								"Ring"};
	{"Superior Healing";						"Healing";				{[1] = {"None"; 30}};								"Bracer"};
	{"Major Healing";						"Healing";				{[1] = {"None"; 35}};								"Gloves"};
	{"Major Healing";						"Healing";				{[1] ={"None"; 81}};								"Weapon"};
	{"Restore Mana Prime";						"mp5";					{[1] = {"None"; 6}};								nil};
	{"Mana Regeneration";						"mp5";					EnchantingSell_Quality["Quality_Mana_Regen"];				"Bracer"};
	{"Vitality";							"mp5";					{[1] = {"None"; 4}};								"Boots"};
	{"Minor Health";						"Health";				{[1] = {"None"; 5}};								"Bracer"};
	{"Health";							"Health";				EnchantingSell_Quality["Quality_Health"];			"Chest"};
	{"Mana";							"Mana";					EnchantingSell_Quality["Quality_Mana"];				"Chest"};
	{"Spell Strike";						"Spl Hit";				{[1] = {"None"; 15}};								"Gloves"};
	{"Blasting";							"Spl Crit";				{[1] = {"None"; 10}};								"Gloves"};
	{"Spell Penetration";						"Spl Pen";				{[1] = {"None"; 20}};								"Cloak"};
	{"Dodge";							"Dodge";				{[1] = {"None"; 12}};								"Cloak"};
	{"Block";							"BR";					EnchantingSell_Quality["Quality_Block_Shield"];					"Shield"};
	{"Tough Shield";						"BV";					{[1] = {"None"; 18}};								"Shield"};
	{"Major Armor";							"Armor";				{[1] = {"None"; 120}};								"Cloak"};
	{"Protection";							"Armor";				{[1] = {"Lesser"; 30}};								"Shield"};
	{"Protection";							"Armor";				EnchantingSell_Quality["Quality_Armure"];					nil};
	{"Defense";							"Armor";				EnchantingSell_Quality["Quality_Armure"];					"Cloak"};
	{"Major Defense";						"Def";					{[1] = {"None"; 12}};								"Bracer"};
	{"Deflection";							"Def";					EnchantingSell_Quality["Quality_Deflection"];					"Bracer"};
	{"Absorption";							"";					EnchantingSell_Quality["Quality_Absorption"];		nil};
	{"Beastslayer";							"Beast";				EnchantingSell_Quality["Quality_Tueur"];			nil};
	{"Elemental Slayer";						"Elemental Slayer";			EnchantingSell_Quality["Quality_Tueur"];			nil};
	{"Demonslaying";						"Demonslaying";				nil;												nil};
	{"Fire Resistance";						"Fire Resi";				EnchantingSell_Quality["Quality_Cloak_FireResist"];		nil};
	{"Nature Resistance";						"Nat Resi";				{[1] = {"Greater"; 15}};							"Cloak"};
	{"Frost Resistance";						"Frost Resi";				{[1] = {"None"; 8}};								nil};
	{"Shadow Resistance";						"Sha Resi";				EnchantingSell_Quality["Quality_Cloak_ShadowResist"];								nil};
	{"Arcane Resistance";						"Arc Resi";				{[1] = {"Greater"; 15}};							"Cloak"};
	{"Resistance";							"Resistance";				{[1] = {"None"; 5}};								"Shield"};
	{"Resistance";							"Resistance";				EnchantingSell_Quality["Quality_AllResist"];		nil};
	{"Resilience";							"Resi";					{[1] = {"Major"; 15}};								"Chest"};
	{"Herbalism";							"Herbalism";				EnchantingSell_Quality["Quality_Metier"];			nil};
	{"Mining";							"Mining";					EnchantingSell_Quality["Quality_Metier"];			nil};
	{"Fishing";							"Fishing";					EnchantingSell_Quality["Quality_Metier"];			nil};
	{"Skinning";							"Skinning";					{[1] = {"None"; 5}};								nil};
	{"Weapon Might";						"Damage";				{[1] = {"None"; 2}};								"Ring"};
    };

["DEFAULT_DATABASE"] = {
	["Enchants"] = {
		{
			["OnThis"] = "Ring",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27926|h[Enchant Ring - Healing Power]|h|r",
			["Quality"] = "Healing Power",
			["EnchantName"] = "Enchant Ring - Healing Power",
			["BonusNb"] = 20,
			["Name"] = "Enchant Ring",
			["Bonus"] = "Healing",
			["Description"] = "Permanently enchant a ring to increase healing spells by up to 20 and damage spells by up to 7.  Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 5,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [1]
		{
			["OnThis"] = "Ring",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27927|h[Enchant Ring - Stats]|h|r",
			["Quality"] = "Stats",
			["EnchantName"] = "Enchant Ring - Stats",
			["BonusNb"] = 4,
			["Name"] = "Enchant Ring",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a ring to increase all stats by 4.  Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [2]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Eternium Rod",
			["Link"] = "|cffffd000|Henchant:27981|h[Enchant Weapon - Sunfire]|h|r",
			["Quality"] = "Sunfire",
			["EnchantName"] = "Enchant Weapon - Sunfire",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Sunfire",
			["Description"] = "Permanently enchant a Melee Weapon to add up to 50 damage to fire and arcane spells.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 10,
				}, -- [2]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [3]
				{
					["Name"] = "Primal Fire",
					["Count"] = 6,
				}, -- [4]
				{
					["Name"] = "Primal Might",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [3]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:34008|h[Enchant Boots - Boar's Speed]|h|r",
			["Quality"] = "Boar's Speed",
			["EnchantName"] = "Enchant Boots - Boar's Speed",
			["Name"] = "Enchant Boots",
			["Bonus"] = "Boar's Speed",
			["Description"] = "Permanently enchant boots to give a minor movement speed increase and 9 Stamina.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Primal Earth",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [4]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:34007|h[Enchant Boots - Cat's Swiftness]|h|r",
			["Quality"] = "Cat's Swiftness",
			["EnchantName"] = "Enchant Boots - Cat's Swiftness",
			["Name"] = "Enchant Boots",
			["Bonus"] = "Cat's Swiftness",
			["Description"] = "Permanently enchant boots to give a minor movement speed increase and 6 Agility.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Primal Air",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [5]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27917|h[Enchant Bracer - Spellpower]|h|r",
			["Quality"] = "Spellpower",
			["EnchantName"] = "Enchant Bracer - Spellpower",
			["BonusNb"] = 15,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spl Dmg",
			["Description"] = "Permanently enchant bracers to increase spell damage and healing by up to 15.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Primal Fire",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Primal Water",
					["Count"] = 6,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [6]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:33997|h[Enchant Gloves - Major Spellpower]|h|r",
			["Quality"] = "Major Spellpower",
			["EnchantName"] = "Enchant Gloves - Major Spellpower",
			["BonusNb"] = 20,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Spl Dmg",
			["Description"] = "Permanently enchant gloves to increase damage and healing by up to 20.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Primal Mana",
					["Count"] = 6,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [7]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:33994|h[Enchant Gloves - Spell Strike]|h|r",
			["Quality"] = "Spell Strike",
			["EnchantName"] = "Enchant Gloves - Spell Strike",
			["BonusNb"] = 15,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Spl Hit",
			["Description"] = "Permanently enchant gloves to grant 15 spell hit rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [8]
		{
			["OnThis"] = "Ring",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27924|h[Enchant Ring - Spellpower]|h|r",
			["Quality"] = "Spellpower",
			["EnchantName"] = "Enchant Ring - Spellpower",
			["BonusNb"] = 12,
			["Name"] = "Enchant Ring",
			["Bonus"] = "Spl Dmg",
			["Description"] = "Permanently enchant a ring to increase spell damage and healing by up to 12.  Only the Enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [9]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27947|h[Enchant Shield - Resistance]|h|r",
			["Quality"] = "Resistance",
			["EnchantName"] = "Enchant Shield - Resistance",
			["BonusNb"] = 5,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Resistance",
			["Description"] = "Permanently enchant a shield to increase resistance to all magic schools by 5.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Mote of Earth",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Mote of Fire",
					["Count"] = 1,
				}, -- [3]
				{
					["Name"] = "Mote of Air",
					["Count"] = 1,
				}, -- [4]
				{
					["Name"] = "Mote of Water",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [10]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:28004|h[Enchant Weapon - Battlemaster]|h|r",
			["Quality"] = "Battlemaster",
			["EnchantName"] = "Enchant Weapon - Battlemaster",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Battlemaster",
			["Description"] = "Permanently enchant a Melee Weapon to occasionaly heal nearby  party members of 180 to 300 health when an enemy is struck.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [2]
				{
					["Name"] = "Primal Water",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [11]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:28003|h[Enchant Weapon - Spellsurge]|h|r",
			["Quality"] = "Spellsurge",
			["EnchantName"] = "Enchant Weapon - Spellsurge",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Spellsurge",
			["Description"] = "Permanently enchant a Melee Weapon to have a 3% chance on spellcast to restore 100 mana to all party members over 10 seconds.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 10,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 20,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [12]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cff0070dd|Hitem:22463:0:0:0:0:0:0:0|h[Runed Eternium Rod]|h|r",
			["EnchantName"] = "Runed Eternium Rod",
			["Name"] = "Runed Eternium Rod",
			["Quality"] = "Runed Eternium Rod",
			["Bonus"] = "Runed Eternium",
			["Icon"] = "Interface\\Icons\\INV_Wand_09",
			["Reagents"] = {
				{
					["Name"] = "Eternium Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 12,
				}, -- [2]
				{
					["Name"] = "Void Crystal",
					["Count"] = 2,
				}, -- [3]
				{
					["Name"] = "Primal Might",
					["Count"] = 4,
				}, -- [4]
				{
					["Name"] = "Runed Adamantite Rod",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [13]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27951|h[Enchant Boots - Dexterity]|h|r",
			["Quality"] = "Dexterity",
			["EnchantName"] = "Enchant Boots - Dexterity",
			["BonusNb"] = 12,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant boots to increase Agility by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [14]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27914|h[Enchant Bracer - Fortitude]|h|r",
			["Quality"] = "Fortitude",
			["EnchantName"] = "Enchant Bracer - Fortitude",
			["BonusNb"] = 12,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchants bracers to give 12 Stamina.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 10,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 20,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [15]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27960|h[Enchant Chest - Exceptional Stats]|h|r",
			["Quality"] = "Exceptional Stats",
			["EnchantName"] = "Enchant Chest - Exceptional Stats",
			["BonusNb"] = 6,
			["Name"] = "Enchant Chest",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a piece of chest armor to add 6 to all stats.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [16]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:33992|h[Enchant Chest - Major Resilience]|h|r",
			["Quality"] = "Major Resilience",
			["EnchantName"] = "Enchant Chest - Major Resilience",
			["BonusNb"] = 15,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Resi",
			["Description"] = "Permanently enchant a piece of chest armor to grant 15 resilience rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [17]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:34005|h[Enchant Cloak - Greater Arcane Resistance]|h|r",
			["Quality"] = "Greater Arcane Resistance",
			["EnchantName"] = "Enchant Cloak - Greater Arcane Resistance",
			["BonusNb"] = 15,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Arc Resi",
			["Description"] = "Permanently enchant a cloak to increase Arcane Resistance by 15.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Primal Mana",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [18]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:34006|h[Enchant Cloak - Greater Shadow Resistance]|h|r",
			["Quality"] = "Greater Shadow Resistance",
			["EnchantName"] = "Enchant Cloak - Greater Shadow Resistance",
			["BonusNb"] = 15,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Sha Resi",
			["Description"] = "Permanently enchant a cloak to increase Shadow Resistance by 15.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Primal Shadow",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [19]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:33999|h[Enchant Gloves - Major Healing]|h|r",
			["Quality"] = "Major Healing",
			["EnchantName"] = "Enchant Gloves - Major Healing",
			["BonusNb"] = 35,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Healing",
			["Description"] = "Permanently enchant gloves to increase Healing by 35 and Spell Damage by 12. Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Primal Life",
					["Count"] = 6,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [20]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:33995|h[Enchant Gloves - Major Strength]|h|r",
			["Quality"] = "Major Strength",
			["EnchantName"] = "Enchant Gloves - Major Strength",
			["BonusNb"] = 15,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant gloves to grant +15 Strength.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [21]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27946|h[Enchant Shield - Shield Block]|h|r",
			["Quality"] = "Shield Block",
			["EnchantName"] = "Enchant Shield - Shield Block",
			["BonusNb"] = 15,
			["Name"] = "Enchant Shield",
			["Bonus"] = "BR",
			["Description"] = "Permanently enchant a shield to give 15 block rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Primal Earth",
					["Count"] = 10,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [22]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:34010|h[Enchant Weapon - Major Healing]|h|r",
			["Quality"] = "Major Healing",
			["EnchantName"] = "Enchant Weapon - Major Healing",
			["BonusNb"] = 81,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Healing",
			["Description"] = "Permanently enchant a Melee Weapon to add +81 Healing and +27 Spell Damage.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Primal Water",
					["Count"] = 8,
				}, -- [2]
				{
					["Name"] = "Primal Life",
					["Count"] = 8,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [23]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27968|h[Enchant Weapon - Major Intellect]|h|r",
			["Quality"] = "Major Intellect",
			["EnchantName"] = "Enchant Weapon - Major Intellect",
			["BonusNb"] = 30,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a melee weapon to grant +30 Intellect.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [24]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27975|h[Enchant Weapon - Major Spellpower]|h|r",
			["Quality"] = "Major Spellpower",
			["EnchantName"] = "Enchant Weapon - Major Spellpower",
			["BonusNb"] = 40,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Spl Dmg",
			["Description"] = "Permanently enchant a melee weapon to increase spell damage and healing by up to 40.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [25]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27967|h[Enchant Weapon - Major Striking]|h|r",
			["Quality"] = "Major Striking",
			["EnchantName"] = "Enchant Weapon - Major Striking",
			["BonusNb"] = 7,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 7 additional points of damage.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [26]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:27972|h[Enchant Weapon - Potency]|h|r",
			["Quality"] = "Potency",
			["EnchantName"] = "Enchant Weapon - Potency",
			["BonusNb"] = 20,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant a Melee Weapon to add 20 Strength.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 5,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 20,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [27]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cff1eff00|Hitem:22462:0:0:0:0:0:0:0|h[Runed Adamantite Rod]|h|r",
			["EnchantName"] = "Runed Adamantite Rod",
			["Name"] = "Runed Adamantite Rod",
			["Quality"] = "Runed Adamantite Rod",
			["Bonus"] = "Runed Adamantite",
			["Icon"] = "Interface\\Icons\\INV_Wand_09",
			["Reagents"] = {
				{
					["Name"] = "Adamantite Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [2]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [3]
				{
					["Name"] = "Primal Might",
					["Count"] = 1,
				}, -- [4]
				{
					["Name"] = "Runed Fel Iron Rod",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [28]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:28028|h[Void Sphere]|h|r",
			["Quality"] = "Void Sphere",
			["EnchantName"] = "Void Sphere",
			["Name"] = "Void Sphere",
			["Bonus"] = "Void Sphere",
			["Description"] = "Creates a Void Sphere out of two Void Crystals.",
			["Icon"] = "Interface\\Icons\\INV_Enchant_VoidSphere",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [29]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25130|h[Brilliant Mana Oil]|h|r",
			["Quality"] = "Brilliant Mana Oil",
			["EnchantName"] = "Brilliant Mana Oil",
			["Name"] = "Brilliant Mana Oil",
			["Bonus"] = "Mana +12",
			["Description"] = "Creates Brilliant Mana Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_100",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Purple Lotus",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Imbued Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [30]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25129|h[Brilliant Wizard Oil]|h|r",
			["Quality"] = "Brilliant Wizard Oil",
			["EnchantName"] = "Brilliant Wizard Oil",
			["Name"] = "Brilliant Wizard Oil",
			["Bonus"] = "Spl Dmg +36",
			["Description"] = "Creates Brilliant Wizard Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_105",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Firebloom",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Imbued Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [31]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:27837|h[Enchant 2H Weapon - Agility]|h|r",
			["Quality"] = "Agility",
			["EnchantName"] = "Enchant 2H Weapon - Agility",
			["BonusNb"] = 25,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a two-handed melee weapon to grant +25 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 10,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 14,
				}, -- [3]
				{
					["Name"] = "Essence of Air",
					["Count"] = 4,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [32]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13937|h[Enchant 2H Weapon - Greater Impact]|h|r",
			["Quality"] = "Greater Impact",
			["EnchantName"] = "Enchant 2H Weapon - Greater Impact",
			["BonusNb"] = 7,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a two-handed melee weapon to do +7 damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [33]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13695|h[Enchant 2H Weapon - Impact]|h|r",
			["Quality"] = "Impact",
			["EnchantName"] = "Enchant 2H Weapon - Impact",
			["BonusNb"] = 5,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Two-handed Melee Weapon to do 5 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Large Glowing Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [34]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13529|h[Enchant 2H Weapon - Lesser Impact]|h|r",
			["Quality"] = "Lesser Impact",
			["EnchantName"] = "Enchant 2H Weapon - Lesser Impact",
			["BonusNb"] = 3,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Two-handed Melee Weapon to do 3 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Large Glimmering Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [35]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7793|h[Enchant 2H Weapon - Lesser Intellect]|h|r",
			["Quality"] = "Lesser Intellect",
			["EnchantName"] = "Enchant 2H Weapon - Lesser Intellect",
			["BonusNb"] = 3,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a Two-Handed Melee Weapon to add 3 to intellect.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [36]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:13380|h[Enchant 2H Weapon - Lesser Spirit]|h|r",
			["Quality"] = "Lesser Spirit",
			["EnchantName"] = "Enchant 2H Weapon - Lesser Spirit",
			["BonusNb"] = 3,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a Two-Handed Melee Weapon to add 3 to Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 6,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [37]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20036|h[Enchant 2H Weapon - Major Intellect]|h|r",
			["Quality"] = "Major Intellect",
			["EnchantName"] = "Enchant 2H Weapon - Major Intellect",
			["BonusNb"] = 9,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a Two-Handed Melee Weapon to add 9 to intellect.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [38]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20035|h[Enchant 2H Weapon - Major Spirit]|h|r",
			["Quality"] = "Major Spirit",
			["EnchantName"] = "Enchant 2H Weapon - Major Spirit",
			["BonusNb"] = 9,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a Two-Handed Melee Weapon to add 9 to Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 12,
				}, -- [1]
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [39]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7745|h[Enchant 2H Weapon - Minor Impact]|h|r",
			["Quality"] = "Minor Impact",
			["EnchantName"] = "Enchant 2H Weapon - Minor Impact",
			["BonusNb"] = 2,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Two-Handed Melee Weapon to do 2 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Small Glimmering Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [40]
		{
			["OnThis"] = "2H Weap",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20030|h[Enchant 2H Weapon - Superior Impact]|h|r",
			["Quality"] = "Superior Impact",
			["EnchantName"] = "Enchant 2H Weapon - Superior Impact",
			["BonusNb"] = 9,
			["Name"] = "Enchant 2H Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a two-handed melee weapon to do +9 damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [41]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13935|h[Enchant Boots - Agility]|h|r",
			["Quality"] = "Agility",
			["EnchantName"] = "Enchant Boots - Agility",
			["BonusNb"] = 5,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant boots to give +5 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [42]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27950|h[Enchant Boots - Fortitude]|h|r",
			["Quality"] = "Fortitude",
			["EnchantName"] = "Enchant Boots - Fortitude",
			["BonusNb"] = 12,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant boots to increase Stamina by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 12,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [43]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20023|h[Enchant Boots - Greater Agility]|h|r",
			["Quality"] = "Greater Agility",
			["EnchantName"] = "Enchant Boots - Greater Agility",
			["BonusNb"] = 7,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant boots to give +7 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [44]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20020|h[Enchant Boots - Greater Stamina]|h|r",
			["Quality"] = "Greater Stamina",
			["EnchantName"] = "Enchant Boots - Greater Stamina",
			["BonusNb"] = 7,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant boots to give +7 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Dream Dust",
					["Count"] = 10,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [45]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13637|h[Enchant Boots - Lesser Agility]|h|r",
			["Quality"] = "Lesser Agility",
			["EnchantName"] = "Enchant Boots - Lesser Agility",
			["BonusNb"] = 3,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant boots to give +3 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [46]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13687|h[Enchant Boots - Lesser Spirit]|h|r",
			["Quality"] = "Lesser Spirit",
			["EnchantName"] = "Enchant Boots - Lesser Spirit",
			["BonusNb"] = 3,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant boots to give +3 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [47]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13644|h[Enchant Boots - Lesser Stamina]|h|r",
			["Quality"] = "Lesser Stamina",
			["EnchantName"] = "Enchant Boots - Lesser Stamina",
			["BonusNb"] = 3,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant boots to give +3 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 4,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [48]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:7867|h[Enchant Boots - Minor Agility]|h|r",
			["Quality"] = "Minor Agility",
			["EnchantName"] = "Enchant Boots - Minor Agility",
			["BonusNb"] = 1,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a pair of boots so they increase the wearer's Agility by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [49]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13890|h[Enchant Boots - Minor Speed]|h|r",
			["Quality"] = "Minor Speed",
			["EnchantName"] = "Enchant Boots - Minor Speed",
			["Name"] = "Enchant Boots",
			["Bonus"] = "Minor Speed",
			["Description"] = "Permanently enchant boots to give a slight movement speed increase.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Radiant Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Aquamarine",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [50]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:7863|h[Enchant Boots - Minor Stamina]|h|r",
			["Quality"] = "Minor Stamina",
			["EnchantName"] = "Enchant Boots - Minor Stamina",
			["BonusNb"] = 1,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a pair of boots so they increase the wearer's Stamina by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [51]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20024|h[Enchant Boots - Spirit]|h|r",
			["Quality"] = "Spirit",
			["EnchantName"] = "Enchant Boots - Spirit",
			["BonusNb"] = 5,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant boots to give +5 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [52]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13836|h[Enchant Boots - Stamina]|h|r",
			["Quality"] = "Stamina",
			["EnchantName"] = "Enchant Boots - Stamina",
			["BonusNb"] = 5,
			["Name"] = "Enchant Boots",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant boots to give +5 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 5,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [53]
		{
			["OnThis"] = "Boots",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27948|h[Enchant Boots - Vitality]|h|r",
			["Quality"] = "Vitality",
			["EnchantName"] = "Enchant Boots - Vitality",
			["BonusNb"] = 4,
			["Name"] = "Enchant Boots",
			["Bonus"] = "mp5",
			["Description"] = "Permanently enchant boots to restore 4 health and mana every 5 seconds.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Major Healing Potion",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Major Mana Potion",
					["Count"] = 4,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [54]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:34002|h[Enchant Bracer - Assault]|h|r",
			["Quality"] = "Assault",
			["EnchantName"] = "Enchant Bracer - Assault",
			["BonusNb"] = 24,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "AP",
			["Description"] = "Permanently enchants bracers to increase attack power by 24.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [55]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:27899|h[Enchant Bracer - Brawn]|h|r",
			["Quality"] = "Brawn",
			["EnchantName"] = "Enchant Bracer - Brawn",
			["BonusNb"] = 12,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchants bracers to increase Strength by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [56]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13931|h[Enchant Bracer - Deflection]|h|r",
			["Quality"] = "Deflection",
			["EnchantName"] = "Enchant Bracer - Deflection",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchants bracers to give +5 defense rating.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [57]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20008|h[Enchant Bracer - Greater Intellect]|h|r",
			["Quality"] = "Greater Intellect",
			["EnchantName"] = "Enchant Bracer - Greater Intellect",
			["BonusNb"] = 7,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchants bracers to give +7 Intellect.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [58]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13846|h[Enchant Bracer - Greater Spirit]|h|r",
			["Quality"] = "Greater Spirit",
			["EnchantName"] = "Enchant Bracer - Greater Spirit",
			["BonusNb"] = 7,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchants bracers to give +7 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [59]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13945|h[Enchant Bracer - Greater Stamina]|h|r",
			["Quality"] = "Greater Stamina",
			["EnchantName"] = "Enchant Bracer - Greater Stamina",
			["BonusNb"] = 7,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchants bracers to give +7 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Dream Dust",
					["Count"] = 5,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [60]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13939|h[Enchant Bracer - Greater Strength]|h|r",
			["Quality"] = "Greater Strength",
			["EnchantName"] = "Enchant Bracer - Greater Strength",
			["BonusNb"] = 7,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchants bracers to give +7 Strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Dream Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [61]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23802|h[Enchant Bracer - Healing Power]|h|r",
			["Quality"] = "Healing Power",
			["EnchantName"] = "Enchant Bracer - Healing Power",
			["BonusNb"] = 24,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Healing",
			["Description"] = "Permanently enchants bracers to increase the effects of your healing spells by 24 and your damage spells by 8.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 20,
				}, -- [2]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 4,
				}, -- [3]
				{
					["Name"] = "Living Essence",
					["Count"] = 6,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [62]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13822|h[Enchant Bracer - Intellect]|h|r",
			["Quality"] = "Intellect",
			["EnchantName"] = "Enchant Bracer - Intellect",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchants bracers to give +5 Intellect.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [63]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13646|h[Enchant Bracer - Lesser Deflection]|h|r",
			["Quality"] = "Lesser Deflection",
			["EnchantName"] = "Enchant Bracer - Lesser Deflection",
			["BonusNb"] = 3,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchants bracers to give +3 defense rating.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Soul Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [64]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13622|h[Enchant Bracer - Lesser Intellect]|h|r",
			["Quality"] = "Lesser Intellect",
			["EnchantName"] = "Enchant Bracer - Lesser Intellect",
			["BonusNb"] = 3,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a bracer so it increases the wearer's Intellect by 3.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [65]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:7859|h[Enchant Bracer - Lesser Spirit]|h|r",
			["Quality"] = "Lesser Spirit",
			["EnchantName"] = "Enchant Bracer - Lesser Spirit",
			["BonusNb"] = 3,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a bracer so it increases the wearer's Spirit by 3.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [66]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13501|h[Enchant Bracer - Lesser Stamina]|h|r",
			["Quality"] = "Lesser Stamina",
			["EnchantName"] = "Enchant Bracer - Lesser Stamina",
			["BonusNb"] = 3,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a bracer so it increases the wearer's Stamina by 3.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [67]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13536|h[Enchant Bracer - Lesser Strength]|h|r",
			["Quality"] = "Lesser Strength",
			["EnchantName"] = "Enchant Bracer - Lesser Strength",
			["BonusNb"] = 3,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant a bracer so it increases the wearer's Strength by 3.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [68]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27906|h[Enchant Bracer - Major Defense]|h|r",
			["Quality"] = "Major Defense",
			["EnchantName"] = "Enchant Bracer - Major Defense",
			["BonusNb"] = 12,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchants bracers to increase your defense rating by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [69]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:34001|h[Enchant Bracer - Major Intellect]|h|r",
			["Quality"] = "Major Intellect",
			["EnchantName"] = "Enchant Bracer - Major Intellect",
			["BonusNb"] = 12,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchants bracers to increase Intellect by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Planar Essence",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [70]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23801|h[Enchant Bracer - Mana Regeneration]|h|r",
			["Quality"] = "Mana Regeneration",
			["EnchantName"] = "Enchant Bracer - Mana Regeneration",
			["BonusNb"] = 4,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "mp5",
			["Description"] = "Permanently enchants bracers to restore 4 mana every 5 seconds.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 16,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Essence of Water",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [71]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7779|h[Enchant Bracer - Minor Agility]|h|r",
			["Quality"] = "Minor Agility",
			["EnchantName"] = "Enchant Bracer - Minor Agility",
			["BonusNb"] = 1,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant bracers so they increase the wearer's Agility by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [72]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7428|h[Enchant Bracer - Minor Deflection]|h|r",
			["Quality"] = "Minor Deflection",
			["EnchantName"] = "Enchant Bracer - Minor Deflection",
			["BonusNb"] = 2,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchants bracers to give +2 defense rating.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [73]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7418|h[Enchant Bracer - Minor Health]|h|r",
			["Quality"] = "Minor Health",
			["EnchantName"] = "Enchant Bracer - Minor Health",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant bracers to increase the health of the wearer by 5.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [74]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7766|h[Enchant Bracer - Minor Spirit]|h|r",
			["Quality"] = "Minor Spirit",
			["EnchantName"] = "Enchant Bracer - Minor Spirit",
			["BonusNb"] = 1,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant bracers so they increase the wearer's Spirit by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [75]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7457|h[Enchant Bracer - Minor Stamina]|h|r",
			["Quality"] = "Minor Stamina",
			["EnchantName"] = "Enchant Bracer - Minor Stamina",
			["BonusNb"] = 1,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant bracers so they increase the wearer's Stamina by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [76]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7782|h[Enchant Bracer - Minor Strength]|h|r",
			["Quality"] = "Minor Strength",
			["EnchantName"] = "Enchant Bracer - Minor Strength",
			["BonusNb"] = 1,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant bracers so they increase the wearer's Strength by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 5,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [77]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27913|h[Enchant Bracer - Restore Mana Prime]|h|r",
			["Quality"] = "Restore Mana Prime",
			["EnchantName"] = "Enchant Bracer - Restore Mana Prime",
			["BonusNb"] = 6,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "mp5",
			["Description"] = "Permanently enchants bracers to restore 6 mana every 5 seconds.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [78]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13642|h[Enchant Bracer - Spirit]|h|r",
			["Quality"] = "Spirit",
			["EnchantName"] = "Enchant Bracer - Spirit",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchants bracers to give +5 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [79]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13648|h[Enchant Bracer - Stamina]|h|r",
			["Quality"] = "Stamina",
			["EnchantName"] = "Enchant Bracer - Stamina",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchants bracers to give +5 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 6,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [80]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27905|h[Enchant Bracer - Stats]|h|r",
			["Quality"] = "Stats",
			["EnchantName"] = "Enchant Bracer - Stats",
			["BonusNb"] = 4,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchants bracers to increase all Stats by 4.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Lesser Planar Essence",
					["Count"] = 6,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [81]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13661|h[Enchant Bracer - Strength]|h|r",
			["Quality"] = "Strength",
			["EnchantName"] = "Enchant Bracer - Strength",
			["BonusNb"] = 5,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchants bracers to give +5 Strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [82]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27911|h[Enchant Bracer - Superior Healing]|h|r",
			["Quality"] = "Superior Healing",
			["EnchantName"] = "Enchant Bracer - Superior Healing",
			["BonusNb"] = 30,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Healing",
			["Description"] = "Permanently enchants bracers to increase the effect of your healing spells by up to 30 and your damage spells by up to 10.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Primal Life",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [83]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20009|h[Enchant Bracer - Superior Spirit]|h|r",
			["Quality"] = "Superior Spirit",
			["EnchantName"] = "Enchant Bracer - Superior Spirit",
			["BonusNb"] = 9,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchants bracers to give +9 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [84]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20011|h[Enchant Bracer - Superior Stamina]|h|r",
			["Quality"] = "Superior Stamina",
			["EnchantName"] = "Enchant Bracer - Superior Stamina",
			["BonusNb"] = 9,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchants bracers to give +9 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 15,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [85]
		{
			["OnThis"] = "Bracer",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20010|h[Enchant Bracer - Superior Strength]|h|r",
			["Quality"] = "Superior Strength",
			["EnchantName"] = "Enchant Bracer - Superior Strength",
			["BonusNb"] = 9,
			["Name"] = "Enchant Bracer",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchants bracers to give +9 Strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 6,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [86]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27957|h[Enchant Chest - Exceptional Health]|h|r",
			["Quality"] = "Exceptional Health",
			["EnchantName"] = "Enchant Chest - Exceptional Health",
			["BonusNb"] = 150,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor to grant +150 health.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Major Healing Potion",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [87]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13640|h[Enchant Chest - Greater Health]|h|r",
			["Quality"] = "Greater Health",
			["EnchantName"] = "Enchant Chest - Greater Health",
			["BonusNb"] = 35,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor to give +35 health.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [88]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13663|h[Enchant Chest - Greater Mana]|h|r",
			["Quality"] = "Greater Mana",
			["EnchantName"] = "Enchant Chest - Greater Mana",
			["BonusNb"] = 50,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor to give +50 mana.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [89]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20025|h[Enchant Chest - Greater Stats]|h|r",
			["Quality"] = "Greater Stats",
			["EnchantName"] = "Enchant Chest - Greater Stats",
			["BonusNb"] = 4,
			["Name"] = "Enchant Chest",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a piece of chest armor to grant +4 to all stats.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 15,
				}, -- [2]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 10,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [90]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:7857|h[Enchant Chest - Health]|h|r",
			["Quality"] = "Health",
			["EnchantName"] = "Enchant Chest - Health",
			["BonusNb"] = 25,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor to increase the health of the wearer by 25.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [91]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13538|h[Enchant Chest - Lesser Absorption]|h|r",
			["Quality"] = "Lesser Absorption",
			["EnchantName"] = "Enchant Chest - Lesser Absorption",
			["BonusNb"] = "5% Abs25pd",
			["Name"] = "Enchant Chest",
			["Bonus"] = "",
			["Description"] = "Enchant a piece of chest armor so it has a 5% chance per hit of giving you 25 points of damage absorption.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Large Glimmering Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [92]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7748|h[Enchant Chest - Lesser Health]|h|r",
			["Quality"] = "Lesser Health",
			["EnchantName"] = "Enchant Chest - Lesser Health",
			["BonusNb"] = 15,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor so that it increases the health of the wearer by 15.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [93]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7776|h[Enchant Chest - Lesser Mana]|h|r",
			["Quality"] = "Lesser Mana",
			["EnchantName"] = "Enchant Chest - Lesser Mana",
			["BonusNb"] = 20,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor so that it increases the mana of the wearer by 20.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [94]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13700|h[Enchant Chest - Lesser Stats]|h|r",
			["Quality"] = "Lesser Stats",
			["EnchantName"] = "Enchant Chest - Lesser Stats",
			["BonusNb"] = 2,
			["Name"] = "Enchant Chest",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a piece of chest armor to grant +2 to all stats.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Large Glowing Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [95]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20026|h[Enchant Chest - Major Health]|h|r",
			["Quality"] = "Major Health",
			["EnchantName"] = "Enchant Chest - Major Health",
			["BonusNb"] = 100,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor to grant +100 health.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Small Brilliant Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [96]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20028|h[Enchant Chest - Major Mana]|h|r",
			["Quality"] = "Major Mana",
			["EnchantName"] = "Enchant Chest - Major Mana",
			["BonusNb"] = 100,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor to give +100 mana.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Small Brilliant Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [97]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:33990|h[Enchant Chest - Major Spirit]|h|r",
			["Quality"] = "Major Spirit",
			["EnchantName"] = "Enchant Chest - Major Spirit",
			["BonusNb"] = 15,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a piece of chest armor to grant +15 Spirit.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [98]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13607|h[Enchant Chest - Mana]|h|r",
			["Quality"] = "Mana",
			["EnchantName"] = "Enchant Chest - Mana",
			["BonusNb"] = 30,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor to increase the mana of the wearer by 30.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [99]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7426|h[Enchant Chest - Minor Absorption]|h|r",
			["Quality"] = "Minor Absorption",
			["EnchantName"] = "Enchant Chest - Minor Absorption",
			["BonusNb"] = "2% Abs10pd",
			["Name"] = "Enchant Chest",
			["Bonus"] = "",
			["Description"] = "Enchant a piece of chest armor so it has a 2% chance per hit of giving you 10 points of damage absorption.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [100]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7420|h[Enchant Chest - Minor Health]|h|r",
			["Quality"] = "Minor Health",
			["EnchantName"] = "Enchant Chest - Minor Health",
			["BonusNb"] = 5,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor so that it increases the health of the wearer by 5.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [101]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7443|h[Enchant Chest - Minor Mana]|h|r",
			["Quality"] = "Minor Mana",
			["EnchantName"] = "Enchant Chest - Minor Mana",
			["BonusNb"] = 5,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor so that it increases the mana of the wearer by 5.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [102]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13626|h[Enchant Chest - Minor Stats]|h|r",
			["Quality"] = "Minor Stats",
			["EnchantName"] = "Enchant Chest - Minor Stats",
			["BonusNb"] = 1,
			["Name"] = "Enchant Chest",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a piece of chest armor to grant +1 to all stats.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Large Glimmering Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [103]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:33991|h[Enchant Chest - Restore Mana Prime]|h|r",
			["Quality"] = "Restore Mana Prime",
			["EnchantName"] = "Enchant Chest - Restore Mana Prime",
			["BonusNb"] = 6,
			["Name"] = "Enchant Chest",
			["Bonus"] = "mp5",
			["Description"] = "Permanently enchant a piece of chest armor to grant 6 Mana every 5 seconds.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Planar Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [104]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13941|h[Enchant Chest - Stats]|h|r",
			["Quality"] = "Stats",
			["EnchantName"] = "Enchant Chest - Stats",
			["BonusNb"] = 3,
			["Name"] = "Enchant Chest",
			["Bonus"] = "AllStats",
			["Description"] = "Permanently enchant a piece of chest armor to grant +3 to all stats.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [105]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13858|h[Enchant Chest - Superior Health]|h|r",
			["Quality"] = "Superior Health",
			["EnchantName"] = "Enchant Chest - Superior Health",
			["BonusNb"] = 50,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Health",
			["Description"] = "Permanently enchant a piece of chest armor to grant +50 health.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 6,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [106]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13917|h[Enchant Chest - Superior Mana]|h|r",
			["Quality"] = "Superior Mana",
			["EnchantName"] = "Enchant Chest - Superior Mana",
			["BonusNb"] = 65,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Mana",
			["Description"] = "Permanently enchant a piece of chest armor to give +65 mana.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [107]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13635|h[Enchant Cloak - Defense]|h|r",
			["Quality"] = "Defense",
			["EnchantName"] = "Enchant Cloak - Defense",
			["BonusNb"] = 30,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a cloak to give 30 additional armor.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Glowing Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Soul Dust",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [108]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25086|h[Enchant Cloak - Dodge]|h|r",
			["Quality"] = "Dodge",
			["EnchantName"] = "Enchant Cloak - Dodge",
			["BonusNb"] = 12,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Dodge",
			["Description"] = "Permanently enchant a cloak to give 12 dodge rating.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Primal Earth",
					["Count"] = 8,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [109]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13657|h[Enchant Cloak - Fire Resistance]|h|r",
			["Quality"] = "Fire Resistance",
			["EnchantName"] = "Enchant Cloak - Fire Resistance",
			["BonusNb"] = 7,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Fire Resi",
			["Description"] = "Permanently enchant a cloak to give 7 Fire Resistance.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Elemental Fire",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [110]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:34004|h[Enchant Cloak - Greater Agility]|h|r",
			["Quality"] = "Greater Agility",
			["EnchantName"] = "Enchant Cloak - Greater Agility",
			["BonusNb"] = 12,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a cloak to increase Agility by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Primal Air",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [111]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13746|h[Enchant Cloak - Greater Defense]|h|r",
			["Quality"] = "Greater Defense",
			["EnchantName"] = "Enchant Cloak - Greater Defense",
			["BonusNb"] = 50,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a cloak to give 50 additional armor.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [112]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25081|h[Enchant Cloak - Greater Fire Resistance]|h|r",
			["Quality"] = "Greater Fire Resistance",
			["EnchantName"] = "Enchant Cloak - Greater Fire Resistance",
			["BonusNb"] = 15,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Fire Resi",
			["Description"] = "Permanently enchant a cloak to give 15 fire resistance.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Essence of Fire",
					["Count"] = 4,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [113]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25082|h[Enchant Cloak - Greater Nature Resistance]|h|r",
			["Quality"] = "Greater Nature Resistance",
			["EnchantName"] = "Enchant Cloak - Greater Nature Resistance",
			["BonusNb"] = 15,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Nat Resi",
			["Description"] = "Permanently enchant a cloak to give 15 nature resistance.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Living Essence",
					["Count"] = 4,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [114]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20014|h[Enchant Cloak - Greater Resistance]|h|r",
			["Quality"] = "Greater Resistance",
			["EnchantName"] = "Enchant Cloak - Greater Resistance",
			["BonusNb"] = 5,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Resistance",
			["Description"] = "Permanently enchant a cloak to give 5 to all resistances.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Heart of Fire",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Core of Earth",
					["Count"] = 1,
				}, -- [3]
				{
					["Name"] = "Globe of Water",
					["Count"] = 1,
				}, -- [4]
				{
					["Name"] = "Breath of Wind",
					["Count"] = 1,
				}, -- [5]
				{
					["Name"] = "Ichor of Undeath",
					["Count"] = 1,
				}, -- [6]
				["Feasibility"] = -2,
			},
		}, -- [115]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13882|h[Enchant Cloak - Lesser Agility]|h|r",
			["Quality"] = "Lesser Agility",
			["EnchantName"] = "Enchant Cloak - Lesser Agility",
			["BonusNb"] = 3,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a cloak to give 3 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 2,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [116]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:7861|h[Enchant Cloak - Lesser Fire Resistance]|h|r",
			["Quality"] = "Lesser Fire Resistance",
			["EnchantName"] = "Enchant Cloak - Lesser Fire Resistance",
			["BonusNb"] = 5,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Fire Resi",
			["Description"] = "Permanently enchant a cloak so that it increases resistance to fire by 5.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Fire Oil",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [117]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:13421|h[Enchant Cloak - Lesser Protection]|h|r",
			["Quality"] = "Lesser Protection",
			["EnchantName"] = "Enchant Cloak - Lesser Protection",
			["BonusNb"] = 20,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a cloak to increase armor by 20.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Small Glimmering Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [118]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13522|h[Enchant Cloak - Lesser Shadow Resistance]|h|r",
			["Quality"] = "Lesser Shadow Resistance",
			["EnchantName"] = "Enchant Cloak - Lesser Shadow Resistance",
			["BonusNb"] = 10,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Sha Resi",
			["Description"] = "Permanently enchant a cloak so that it increases resistance to shadow by 10.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Shadow Protection Potion",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [119]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:27961|h[Enchant Cloak - Major Armor]|h|r",
			["Quality"] = "Major Armor",
			["EnchantName"] = "Enchant Cloak - Major Armor",
			["BonusNb"] = 120,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a cloak to give 120 additional armor.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [120]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27962|h[Enchant Cloak - Major Resistance]|h|r",
			["Quality"] = "Major Resistance",
			["EnchantName"] = "Enchant Cloak - Major Resistance",
			["BonusNb"] = 7,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Resistance",
			["Description"] = "Permanently enchant a cloak to increase all Resistances by 7.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Primal Fire",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Primal Air",
					["Count"] = 4,
				}, -- [3]
				{
					["Name"] = "Primal Earth",
					["Count"] = 4,
				}, -- [4]
				{
					["Name"] = "Primal Water",
					["Count"] = 4,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [121]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13419|h[Enchant Cloak - Minor Agility]|h|r",
			["Quality"] = "Minor Agility",
			["EnchantName"] = "Enchant Cloak - Minor Agility",
			["BonusNb"] = 1,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a cloak to grant +1 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [122]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7771|h[Enchant Cloak - Minor Protection]|h|r",
			["Quality"] = "Minor Protection",
			["EnchantName"] = "Enchant Cloak - Minor Protection",
			["BonusNb"] = 10,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Enchant a cloak to provide 10 additional points of armor.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [123]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7454|h[Enchant Cloak - Minor Resistance]|h|r",
			["Quality"] = "Minor Resistance",
			["EnchantName"] = "Enchant Cloak - Minor Resistance",
			["BonusNb"] = 1,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Resistance",
			["Description"] = "Permanently enchant a cloak so that it increases the resistance to all schools of magic by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [124]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13794|h[Enchant Cloak - Resistance]|h|r",
			["Quality"] = "Resistance",
			["EnchantName"] = "Enchant Cloak - Resistance",
			["BonusNb"] = 3,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Resistance",
			["Description"] = "Permanently enchant a cloak to give 3 to all resistances.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [125]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:34003|h[Enchant Cloak - Spell Penetration]|h|r",
			["Quality"] = "Spell Penetration",
			["EnchantName"] = "Enchant Cloak - Spell Penetration",
			["BonusNb"] = 20,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Spl Pen",
			["Description"] = "Permanently enchant a cloak to increase Spell Penetration by 20.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Primal Mana",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [126]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25083|h[Enchant Cloak - Stealth]|h|r",
			["Quality"] = "Stealth",
			["EnchantName"] = "Enchant Cloak - Stealth",
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Stealth",
			["Description"] = "Permanently enchant a cloak to increase stealth.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Fel Lotus",
					["Count"] = 2,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [127]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25084|h[Enchant Cloak - Subtlety]|h|r",
			["Quality"] = "Subtlety",
			["EnchantName"] = "Enchant Cloak - Subtlety",
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Subtlety",
			["Description"] = "Permanently enchant a cloak to decrease threat caused by the wearer by 2%.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Primal Shadow",
					["Count"] = 8,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [128]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20015|h[Enchant Cloak - Superior Defense]|h|r",
			["Quality"] = "Superior Defense",
			["EnchantName"] = "Enchant Cloak - Superior Defense",
			["BonusNb"] = 70,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a cloak to give 70 additional armor.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [129]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13868|h[Enchant Gloves - Advanced Herbalism]|h|r",
			["Quality"] = "Advanced Herbalism",
			["EnchantName"] = "Enchant Gloves - Advanced Herbalism",
			["BonusNb"] = 5,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Herbalism",
			["Description"] = "Permanently enchant gloves to grant +5 herbalism skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Sungrass",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [130]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13841|h[Enchant Gloves - Advanced Mining]|h|r",
			["Quality"] = "Advanced Mining",
			["EnchantName"] = "Enchant Gloves - Advanced Mining",
			["BonusNb"] = 5,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Mining",
			["Description"] = "Permanently enchant gloves to grant +5 mining skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Truesilver Bar",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [131]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13815|h[Enchant Gloves - Agility]|h|r",
			["Quality"] = "Agility",
			["EnchantName"] = "Enchant Gloves - Agility",
			["BonusNb"] = 5,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant gloves to grant +5 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [132]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:33996|h[Enchant Gloves - Assault]|h|r",
			["Quality"] = "Assault",
			["EnchantName"] = "Enchant Gloves - Assault",
			["BonusNb"] = 26,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "AP",
			["Description"] = "Permanently enchant gloves to grant 26 attack power.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [133]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:33993|h[Enchant Gloves - Blasting]|h|r",
			["Quality"] = "Blasting",
			["EnchantName"] = "Enchant Gloves - Blasting",
			["BonusNb"] = 10,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Spl Crit",
			["Description"] = "Permanently enchant gloves to grant 10 spell critical strike rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Planar Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [134]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13620|h[Enchant Gloves - Fishing]|h|r",
			["Quality"] = "Fishing",
			["EnchantName"] = "Enchant Gloves - Fishing",
			["BonusNb"] = 2,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Fishing",
			["Description"] = "Permanently enchant gloves to grant +2 fishing skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Blackmouth Oil",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [135]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20012|h[Enchant Gloves - Greater Agility]|h|r",
			["Quality"] = "Greater Agility",
			["EnchantName"] = "Enchant Gloves - Greater Agility",
			["BonusNb"] = 7,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant gloves to grant +7 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [136]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20013|h[Enchant Gloves - Greater Strength]|h|r",
			["Quality"] = "Greater Strength",
			["EnchantName"] = "Enchant Gloves - Greater Strength",
			["BonusNb"] = 7,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant gloves to grant +7 Strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [137]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13617|h[Enchant Gloves - Herbalism]|h|r",
			["Quality"] = "Herbalism",
			["EnchantName"] = "Enchant Gloves - Herbalism",
			["BonusNb"] = 2,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Herbalism",
			["Description"] = "Permanently enchant gloves to grant +2 herbalism skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Kingsblood",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [138]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13612|h[Enchant Gloves - Mining]|h|r",
			["Quality"] = "Mining",
			["EnchantName"] = "Enchant Gloves - Mining",
			["BonusNb"] = 2,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Mining",
			["Description"] = "Permanently enchant gloves to grant +2 mining skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Iron Ore",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [139]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13948|h[Enchant Gloves - Minor Haste]|h|r",
			["Quality"] = "Minor Haste",
			["EnchantName"] = "Enchant Gloves - Minor Haste",
			["BonusNb"] = "1%",
			["Name"] = "Enchant Gloves",
			["Bonus"] = "At speed",
			["Description"] = "Permanently enchant gloves to increase melee and ranged haste rating by 10.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Wildvine",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [140]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13947|h[Enchant Gloves - Riding Skill]|h|r",
			["Quality"] = "Riding Skill",
			["EnchantName"] = "Enchant Gloves - Riding Skill",
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Riding Skill",
			["Description"] = "Permanently enchant gloves to grant a minor movement bonus while mounted.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [141]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13698|h[Enchant Gloves - Skinning]|h|r",
			["Quality"] = "Skinning",
			["EnchantName"] = "Enchant Gloves - Skinning",
			["BonusNb"] = 5,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Skinning",
			["Description"] = "Permanently enchant gloves to grant +5 skinning skill.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Green Whelp Scale",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [142]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13887|h[Enchant Gloves - Strength]|h|r",
			["Quality"] = "Strength",
			["EnchantName"] = "Enchant Gloves - Strength",
			["BonusNb"] = 5,
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant gloves to grant +5 Strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Nether Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [143]
		{
			["OnThis"] = "Gloves",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:25072|h[Enchant Gloves - Threat]|h|r",
			["Quality"] = "Threat",
			["EnchantName"] = "Enchant Gloves - Threat",
			["Name"] = "Enchant Gloves",
			["Bonus"] = "Threat",
			["Description"] = "Permanently enchant gloves to increase threat from all attacks and spells by 2%.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Primal Life",
					["Count"] = 8,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [144]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13933|h[Enchant Shield - Frost Resistance]|h|r",
			["Quality"] = "Frost Resistance",
			["EnchantName"] = "Enchant Shield - Frost Resistance",
			["BonusNb"] = 8,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Frost Resi",
			["Description"] = "Permanently enchant a shield to give +8 Frost Resistance.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Frost Oil",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [145]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13905|h[Enchant Shield - Greater Spirit]|h|r",
			["Quality"] = "Greater Spirit",
			["EnchantName"] = "Enchant Shield - Greater Spirit",
			["BonusNb"] = 7,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a shield to give +7 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [146]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20017|h[Enchant Shield - Greater Stamina]|h|r",
			["Quality"] = "Greater Stamina",
			["EnchantName"] = "Enchant Shield - Greater Stamina",
			["BonusNb"] = 7,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a shield to give +7 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Dream Dust",
					["Count"] = 10,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [147]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:27945|h[Enchant Shield - Intellect]|h|r",
			["Quality"] = "Intellect",
			["EnchantName"] = "Enchant Shield - Intellect",
			["BonusNb"] = 12,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a shield to give 12 intellect.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [148]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13689|h[Enchant Shield - Lesser Block]|h|r",
			["Quality"] = "Lesser Block",
			["EnchantName"] = "Enchant Shield - Lesser Block",
			["BonusNb"] = 10,
			["Name"] = "Enchant Shield",
			["Bonus"] = "BR",
			["Description"] = "Permanently enchant a shield to give 10 block rating.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Large Glowing Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [149]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13464|h[Enchant Shield - Lesser Protection]|h|r",
			["Quality"] = "Lesser Protection",
			["EnchantName"] = "Enchant Shield - Lesser Protection",
			["BonusNb"] = 30,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Armor",
			["Description"] = "Permanently enchant a shield to increase its armor by 30.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Small Glimmering Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [150]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13485|h[Enchant Shield - Lesser Spirit]|h|r",
			["Quality"] = "Lesser Spirit",
			["EnchantName"] = "Enchant Shield - Lesser Spirit",
			["BonusNb"] = 3,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a shield to give 3 spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [151]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13631|h[Enchant Shield - Lesser Stamina]|h|r",
			["Quality"] = "Lesser Stamina",
			["EnchantName"] = "Enchant Shield - Lesser Stamina",
			["BonusNb"] = 3,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a shield to give 3 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [152]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:34009|h[Enchant Shield - Major Stamina]|h|r",
			["Quality"] = "Major Stamina",
			["EnchantName"] = "Enchant Shield - Major Stamina",
			["BonusNb"] = 18,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a shield to give 18 Stamina.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 15,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [153]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:13378|h[Enchant Shield - Minor Stamina]|h|r",
			["Quality"] = "Minor Stamina",
			["EnchantName"] = "Enchant Shield - Minor Stamina",
			["BonusNb"] = 1,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a shield so that it increases the Stamina of the bearer by 1.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Astral Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [154]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:44383|h[Enchant Shield - Resilience]|h|r",
			["Quality"] = "Resilience",
			["EnchantName"] = "Enchant Shield - Resilience",
			["Name"] = "Enchant Shield",
			["Bonus"] = "Resilience",
			["Description"] = "Permanently enchant a shield to increase Resilience by 12.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Planar Essence",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [155]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13659|h[Enchant Shield - Spirit]|h|r",
			["Quality"] = "Spirit",
			["EnchantName"] = "Enchant Shield - Spirit",
			["BonusNb"] = 5,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a shield to give 5 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [156]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13817|h[Enchant Shield - Stamina]|h|r",
			["Quality"] = "Stamina",
			["EnchantName"] = "Enchant Shield - Stamina",
			["BonusNb"] = 5,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Sta",
			["Description"] = "Permanently enchant a shield to give +5 Stamina.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 5,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [157]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20016|h[Enchant Shield - Superior Spirit]|h|r",
			["Quality"] = "Superior Spirit",
			["EnchantName"] = "Enchant Shield - Superior Spirit",
			["BonusNb"] = 9,
			["Name"] = "Enchant Shield",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a shield to give +9 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [158]
		{
			["OnThis"] = "Shield",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:27944|h[Enchant Shield - Tough Shield]|h|r",
			["Quality"] = "Tough Shield",
			["EnchantName"] = "Enchant Shield - Tough Shield",
			["BonusNb"] = 18,
			["Name"] = "Enchant Shield",
			["Bonus"] = "BV",
			["Description"] = "Permanently enchant a shield to give 18 additional block value.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Primal Earth",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [159]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23800|h[Enchant Weapon - Agility]|h|r",
			["Quality"] = "Agility",
			["EnchantName"] = "Enchant Weapon - Agility",
			["BonusNb"] = 15,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a melee weapon to grant +15 Agility.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 4,
				}, -- [3]
				{
					["Name"] = "Essence of Air",
					["Count"] = 2,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [160]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20034|h[Enchant Weapon - Crusader]|h|r",
			["Quality"] = "Crusader",
			["EnchantName"] = "Enchant Weapon - Crusader",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Crusader",
			["Description"] = "Permanently enchant a melee weapon so that often when attacking in melee it heals for 75 to 125 and increases Strength by 100 for 15 sec.  Has a reduced effect for players above level 60.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Righteous Orb",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [161]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13915|h[Enchant Weapon - Demonslaying]|h|r",
			["Quality"] = "Demonslaying",
			["EnchantName"] = "Enchant Weapon - Demonslaying",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Demonslaying",
			["Description"] = "Permanently enchant a melee weapon to have a chance of stunning and doing heavy damage to demons.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Radiant Shard",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Elixir of Demonslaying",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [162]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13898|h[Enchant Weapon - Fiery Weapon]|h|r",
			["Quality"] = "Fiery Weapon",
			["EnchantName"] = "Enchant Weapon - Fiery Weapon",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Fiery Weapon",
			["Description"] = "Permanently enchant a melee weapon to often strike for 40 additional fire damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Radiant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Essence of Fire",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [163]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:42620|h[Enchant Weapon - Greater Agility]|h|r",
			["Quality"] = "Greater Agility",
			["EnchantName"] = "Enchant Weapon - Greater Agility",
			["BonusNb"] = 20,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Agi",
			["Description"] = "Permanently enchant a weapon to increase Agility by 20.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 6,
				}, -- [3]
				{
					["Name"] = "Primal Air",
					["Count"] = 2,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [164]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:13943|h[Enchant Weapon - Greater Striking]|h|r",
			["Quality"] = "Greater Striking",
			["EnchantName"] = "Enchant Weapon - Greater Striking",
			["BonusNb"] = 4,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 4 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Radiant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Nether Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [165]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:20029|h[Enchant Weapon - Icy Chill]|h|r",
			["Quality"] = "Icy Chill",
			["EnchantName"] = "Enchant Weapon - Icy Chill",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Icy Chill",
			["Description"] = "Permanently enchant a melee weapon to often chill the target reducing their movement and attack speed.  Has a reduced effect for players above level 60.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Brilliant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Essence of Water",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Essence of Air",
					["Count"] = 1,
				}, -- [3]
				{
					["Name"] = "Icecap",
					["Count"] = 1,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [166]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13653|h[Enchant Weapon - Lesser Beastslayer]|h|r",
			["Quality"] = "Lesser Beastslayer",
			["EnchantName"] = "Enchant Weapon - Lesser Beastslayer",
			["BonusNb"] = 6,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Beast",
			["Description"] = "Permanently enchant a Melee Weapon to do 6 additional points of damage to Beasts.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Large Fang",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Small Glowing Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [167]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13655|h[Enchant Weapon - Lesser Elemental Slayer]|h|r",
			["Quality"] = "Lesser Elemental Slayer",
			["EnchantName"] = "Enchant Weapon - Lesser Elemental Slayer",
			["BonusNb"] = 6,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Elemental Slayer",
			["Description"] = "Permanently enchant a Melee Weapon to do 6 additional damage against Elementals.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Elemental Earth",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Small Glowing Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [168]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:13503|h[Enchant Weapon - Lesser Striking]|h|r",
			["Quality"] = "Lesser Striking",
			["EnchantName"] = "Enchant Weapon - Lesser Striking",
			["BonusNb"] = 2,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 2 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Large Glimmering Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [169]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20032|h[Enchant Weapon - Lifestealing]|h|r",
			["Quality"] = "Lifestealing",
			["EnchantName"] = "Enchant Weapon - Lifestealing",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Lifestealing",
			["Description"] = "Permanently enchant a melee weapon to often steal life from the enemy and give it to the wielder.  Has a reduced effect for players above level 60.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Essence of Undeath",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Living Essence",
					["Count"] = 6,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [170]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23804|h[Enchant Weapon - Mighty Intellect]|h|r",
			["Quality"] = "Mighty Intellect",
			["EnchantName"] = "Enchant Weapon - Mighty Intellect",
			["BonusNb"] = 22,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Int",
			["Description"] = "Permanently enchant a melee weapon to grant +22 Intellect.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 15,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 12,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 20,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [171]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23803|h[Enchant Weapon - Mighty Spirit]|h|r",
			["Quality"] = "Mighty Spirit",
			["EnchantName"] = "Enchant Weapon - Mighty Spirit",
			["BonusNb"] = 20,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Spi",
			["Description"] = "Permanently enchant a melee weapon to grant +20 Spirit.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 10,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 8,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 15,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [172]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7786|h[Enchant Weapon - Minor Beastslayer]|h|r",
			["Quality"] = "Minor Beastslayer",
			["EnchantName"] = "Enchant Weapon - Minor Beastslayer",
			["BonusNb"] = 2,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Beast",
			["Description"] = "Permanently enchant a Melee Weapon to do 2 additional points of damage to Beasts.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 2,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [173]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:7788|h[Enchant Weapon - Minor Striking]|h|r",
			["Quality"] = "Minor Striking",
			["EnchantName"] = "Enchant Weapon - Minor Striking",
			["BonusNb"] = 1,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 1 additional point of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Small Glimmering Shard",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [174]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:23799|h[Enchant Weapon - Strength]|h|r",
			["Quality"] = "Strength",
			["EnchantName"] = "Enchant Weapon - Strength",
			["BonusNb"] = 15,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Str",
			["Description"] = "Permanently enchant a melee weapon to grant +15 strength.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 6,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 4,
				}, -- [3]
				{
					["Name"] = "Essence of Earth",
					["Count"] = 2,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [175]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:13693|h[Enchant Weapon - Striking]|h|r",
			["Quality"] = "Striking",
			["EnchantName"] = "Enchant Weapon - Striking",
			["BonusNb"] = 3,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 3 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Large Glowing Shard",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [176]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20031|h[Enchant Weapon - Superior Striking]|h|r",
			["Quality"] = "Superior Striking",
			["EnchantName"] = "Enchant Weapon - Superior Striking",
			["BonusNb"] = 5,
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Damage",
			["Description"] = "Permanently enchant a Melee Weapon to do 5 additional points of damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 10,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [177]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Arcanite Rod",
			["Link"] = "|cffffd000|Henchant:20033|h[Enchant Weapon - Unholy Weapon]|h|r",
			["Quality"] = "Unholy Weapon",
			["EnchantName"] = "Enchant Weapon - Unholy Weapon",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Unholy Weapon",
			["Description"] = "Permanently enchant a melee weapon to often inflict a curse on the target reducing their melee damage.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Essence of Undeath",
					["Count"] = 4,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [178]
		{
			["OnThis"] = "Weapon",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:21931|h[Enchant Weapon - Winter's Might]|h|r",
			["Quality"] = "Winter's Might",
			["EnchantName"] = "Enchant Weapon - Winter's Might",
			["Name"] = "Enchant Weapon",
			["Bonus"] = "Winter's Might",
			["Description"] = "Permanently enchant a weapon to grant up to 7 additional frost damage when casting frost spells.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [2]
				{
					["Name"] = "Large Glowing Shard",
					["Count"] = 1,
				}, -- [3]
				{
					["Name"] = "Wintersbite",
					["Count"] = 2,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [179]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:17181|h[Enchanted Leather]|h|r",
			["EnchantName"] = "Enchanted Leather",
			["Name"] = "Enchanted Leather",
			["Quality"] = "Enchanted Leather",
			["Bonus"] = "Enchanted Leather",
			["Icon"] = "Interface\\Icons\\INV_Misc_Rune_05",
			["Reagents"] = {
				{
					["Name"] = "Rugged Leather",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Eternal Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [180]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:17180|h[Enchanted Thorium]|h|r",
			["EnchantName"] = "Enchanted Thorium",
			["Name"] = "Enchanted Thorium",
			["Quality"] = "Enchanted Thorium",
			["Bonus"] = "Enchanted Thorium",
			["Icon"] = "Interface\\Icons\\INV_Ingot_Eternium",
			["Reagents"] = {
				{
					["Name"] = "Thorium Bar",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Dream Dust",
					["Count"] = 3,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [181]
		{
			["OnThis"] = "Wand",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cff1eff00|Hitem:11288:0:0:0:0:0:0:0|h[Greater Magic Wand]|h|r",
			["Quality"] = "Greater Magic Wand",
			["EnchantName"] = "Greater Magic Wand",
			["Name"] = "Greater Magic Wand",
			["Bonus"] = "(Arc)dps:17.5",
			["Description"] = "Creates a greater magic wand.",
			["Icon"] = "Interface\\Icons\\INV_Staff_07",
			["Reagents"] = {
				{
					["Name"] = "Simple Wood",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [182]
		{
			["OnThis"] = "Wand",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cff1eff00|Hitem:11290:0:0:0:0:0:0:0|h[Greater Mystic Wand]|h|r",
			["Quality"] = "Greater Mystic Wand",
			["EnchantName"] = "Greater Mystic Wand",
			["Name"] = "Greater Mystic Wand",
			["Bonus"] = "(Arc)dps:29.0",
			["Description"] = "Creates a greater mystic wand.",
			["Icon"] = "Interface\\Icons\\INV_Wand_07",
			["Reagents"] = {
				{
					["Name"] = "Star Wood",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Vision Dust",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [183]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r",
			["Quality"] = "Large Prismatic Shard",
			["EnchantName"] = "Large Prismatic Shard",
			["Name"] = "Large Prismatic Shard",
			["Bonus"] = "Large Prismatic",
			["Description"] = "Transforms three Small Prismatic Shard into a Large Prismatic Shard.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Small Prismatic Shard",
					["Count"] = 3,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [184]
		{
			["OnThis"] = "Wand",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cff1eff00|Hitem:11287:0:0:0:0:0:0:0|h[Lesser Magic Wand]|h|r",
			["Quality"] = "Lesser Magic Wand",
			["EnchantName"] = "Lesser Magic Wand",
			["Name"] = "Lesser Magic Wand",
			["Bonus"] = "(Arc)dps:11.3",
			["Description"] = "Creates a lesser magic wand.",
			["Icon"] = "Interface\\Icons\\INV_Staff_02",
			["Reagents"] = {
				{
					["Name"] = "Simple Wood",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [185]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:25127|h[Lesser Mana Oil]|h|r",
			["Quality"] = "Lesser Mana Oil",
			["EnchantName"] = "Lesser Mana Oil",
			["Name"] = "Lesser Mana Oil",
			["Bonus"] = "Mana +8",
			["Description"] = "Creates Lesser Mana Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_99",
			["Reagents"] = {
				{
					["Name"] = "Dream Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Purple Lotus",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Crystal Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [186]
		{
			["OnThis"] = "Wand",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cff1eff00|Hitem:11289:0:0:0:0:0:0:0|h[Lesser Mystic Wand]|h|r",
			["Quality"] = "Lesser Mystic Wand",
			["EnchantName"] = "Lesser Mystic Wand",
			["Name"] = "Lesser Mystic Wand",
			["Bonus"] = "(Arc)dps:25.4",
			["Description"] = "Creates a lesser mystic wand.",
			["Icon"] = "Interface\\Icons\\INV_Staff_02",
			["Reagents"] = {
				{
					["Name"] = "Star Wood",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Lesser Mystic Essence",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Soul Dust",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [187]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Golden Rod",
			["Link"] = "|cffffd000|Henchant:25126|h[Lesser Wizard Oil]|h|r",
			["Quality"] = "Lesser Wizard Oil",
			["EnchantName"] = "Lesser Wizard Oil",
			["Name"] = "Lesser Wizard Oil",
			["Bonus"] = "Spl Dmg +16",
			["Description"] = "Creates Lesser Wizard Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_103",
			["Reagents"] = {
				{
					["Name"] = "Vision Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Stranglethorn Seed",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Leaded Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [188]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Silver Rod",
			["Link"] = "|cffffd000|Henchant:25125|h[Minor Mana Oil]|h|r",
			["Quality"] = "Minor Mana Oil",
			["EnchantName"] = "Minor Mana Oil",
			["Name"] = "Minor Mana Oil",
			["Bonus"] = "Mana +4",
			["Description"] = "Creates Minor Mana Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_98",
			["Reagents"] = {
				{
					["Name"] = "Soul Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Maple Seed",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Leaded Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [189]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Copper Rod",
			["Link"] = "|cffffd000|Henchant:25124|h[Minor Wizard Oil]|h|r",
			["Quality"] = "Minor Wizard Oil",
			["EnchantName"] = "Minor Wizard Oil",
			["Name"] = "Minor Wizard Oil",
			["Bonus"] = "Spl Dmg +8",
			["Description"] = "Creates Minor Wizard Oil.",
			["Icon"] = "Interface\\Icons\\INV_Poison_MindNumbing",
			["Reagents"] = {
				{
					["Name"] = "Strange Dust",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Maple Seed",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Empty Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [190]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cff0070dd|Hitem:22448:0:0:0:0:0:0:0|h[Small Prismatic Shard]|h|r",
			["Quality"] = "Nexus Transformation",
			["EnchantName"] = "Nexus Transformation",
			["Name"] = "Nexus Transformation",
			["Bonus"] = "Nexus Transformation",
			["Description"] = "Transforms a Nexus Crystal into a Small Prismatic Shard.",
			["Icon"] = "Interface\\Icons\\INV_Enchant_ShardPrismaticSmall",
			["Reagents"] = {
				{
					["Name"] = "Nexus Crystal",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [191]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:28027|h[Prismatic Sphere]|h|r",
			["Quality"] = "Prismatic Sphere",
			["EnchantName"] = "Prismatic Sphere",
			["Name"] = "Prismatic Sphere",
			["Bonus"] = "Prismatic Sphere",
			["Description"] = "Creates a Prismatic Sphere out of four Large Prismatic Shards.",
			["Icon"] = "Interface\\Icons\\INV_Enchant_PrismaticSphere",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [192]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:16207:0:0:0:0:0:0:0|h[Runed Arcanite Rod]|h|r",
			["EnchantName"] = "Runed Arcanite Rod",
			["Name"] = "Runed Arcanite Rod",
			["Quality"] = "Runed Arcanite Rod",
			["Bonus"] = "Runed Arcanite",
			["Icon"] = "Interface\\Icons\\INV_Wand_09",
			["Reagents"] = {
				{
					["Name"] = "Arcanite Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Golden Pearl",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Illusion Dust",
					["Count"] = 10,
				}, -- [3]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 4,
				}, -- [4]
				{
					["Name"] = "Runed Truesilver Rod",
					["Count"] = 1,
				}, -- [5]
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 2,
				}, -- [6]
				["Feasibility"] = -2,
			},
		}, -- [193]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:6218:0:0:0:0:0:0:0|h[Runed Copper Rod]|h|r",
			["EnchantName"] = "Runed Copper Rod",
			["Name"] = "Runed Copper Rod",
			["Quality"] = "Runed Copper Rod",
			["Bonus"] = "Runed Copper",
			["Icon"] = "Interface\\Icons\\INV_Staff_Goldfeathered_01",
			["Reagents"] = {
				{
					["Name"] = "Copper Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Lesser Magic Essence",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [194]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:22461:0:0:0:0:0:0:0|h[Runed Fel Iron Rod]|h|r",
			["EnchantName"] = "Runed Fel Iron Rod",
			["Name"] = "Runed Fel Iron Rod",
			["Quality"] = "Runed Fel Iron Rod",
			["Bonus"] = "Runed Fel Iron",
			["Icon"] = "Interface\\Icons\\INV_Rod_EnchantedFelsteel",
			["Reagents"] = {
				{
					["Name"] = "Fel Iron Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Greater Eternal Essence",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Large Brilliant Shard",
					["Count"] = 6,
				}, -- [3]
				{
					["Name"] = "Runed Arcanite Rod",
					["Count"] = 1,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [195]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:11130:0:0:0:0:0:0:0|h[Runed Golden Rod]|h|r",
			["EnchantName"] = "Runed Golden Rod",
			["Name"] = "Runed Golden Rod",
			["Quality"] = "Runed Golden Rod",
			["Bonus"] = "Runed Golden",
			["Icon"] = "Interface\\Icons\\INV_Staff_10",
			["Reagents"] = {
				{
					["Name"] = "Golden Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Iridescent Pearl",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Greater Astral Essence",
					["Count"] = 2,
				}, -- [3]
				{
					["Name"] = "Soul Dust",
					["Count"] = 2,
				}, -- [4]
				{
					["Name"] = "Runed Silver Rod",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [196]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:6339:0:0:0:0:0:0:0|h[Runed Silver Rod]|h|r",
			["EnchantName"] = "Runed Silver Rod",
			["Name"] = "Runed Silver Rod",
			["Quality"] = "Runed Silver Rod",
			["Bonus"] = "Runed Silver",
			["Icon"] = "Interface\\Icons\\INV_Staff_01",
			["Reagents"] = {
				{
					["Name"] = "Silver Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Strange Dust",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Greater Magic Essence",
					["Count"] = 3,
				}, -- [3]
				{
					["Name"] = "Runed Copper Rod",
					["Count"] = 1,
				}, -- [4]
				["Feasibility"] = -2,
			},
		}, -- [197]
		{
			["OnThis"] = "Rod",
			["Link"] = "|cffffffff|Hitem:11145:0:0:0:0:0:0:0|h[Runed Truesilver Rod]|h|r",
			["EnchantName"] = "Runed Truesilver Rod",
			["Name"] = "Runed Truesilver Rod",
			["Quality"] = "Runed Truesilver Rod",
			["Bonus"] = "Runed Truesilver",
			["Icon"] = "Interface\\Icons\\INV_Staff_11",
			["Reagents"] = {
				{
					["Name"] = "Truesilver Rod",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Black Pearl",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Greater Mystic Essence",
					["Count"] = 2,
				}, -- [3]
				{
					["Name"] = "Vision Dust",
					["Count"] = 2,
				}, -- [4]
				{
					["Name"] = "Runed Golden Rod",
					["Count"] = 1,
				}, -- [5]
				["Feasibility"] = -2,
			},
		}, -- [198]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cff0070dd|Hitem:22448:0:0:0:0:0:0:0|h[Small Prismatic Shard]|h|r",
			["Quality"] = "Small Prismatic Shard",
			["EnchantName"] = "Small Prismatic Shard",
			["Name"] = "Small Prismatic Shard",
			["Bonus"] = "Small Prismatic Shard",
			["Description"] = "Creates 3 Small Prismatic Shards out of a Large Prismatic Shard.",
			["Icon"] = "Interface\\Icons\\INV_Enchant_ShardPrismaticSmall",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [199]
		{
			["OnThis"] = "Trinket",
			["Required"] = "Black Forge",
			["Link"] = "|cff0070dd|Hitem:11811:0:0:0:0:0:0:0|h[Smoking Heart of the Mountain]|h|r",
			["EnchantName"] = "Smoking Heart of the Mountain",
			["Name"] = "Smoking Heart of the Mountain",
			["Quality"] = "Smoking Heart of the Mountain",
			["Bonus"] = "Smoking Heart of the Mountain",
			["Icon"] = "Interface\\Icons\\INV_Misc_Gem_Bloodstone_01",
			["Reagents"] = {
				{
					["Name"] = "Blood of the Mountain",
					["Count"] = 1,
				}, -- [1]
				{
					["Name"] = "Essence of Fire",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Small Brilliant Shard",
					["Count"] = 3,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [200]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffffff|Hitem:22521:0:0:0:0:0:0:0|h[Superior Mana Oil]|h|r",
			["Quality"] = "Superior Mana Oil",
			["EnchantName"] = "Superior Mana Oil",
			["Name"] = "Superior Mana Oil",
			["Bonus"] = "Mana +14",
			["Description"] = "Creates Superior Mana Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_101",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Netherbloom",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Imbued Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [201]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffffff|Hitem:22522:0:0:0:0:0:0:0|h[Superior Wizard Oil]|h|r",
			["Quality"] = "Superior Wizard Oil",
			["EnchantName"] = "Superior Wizard Oil",
			["Name"] = "Superior Wizard Oil",
			["Bonus"] = "Spl Dmg +42",
			["Description"] = "Creates Superior Wizard Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_141",
			["Reagents"] = {
				{
					["Name"] = "Arcane Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Nightmare Vine",
					["Count"] = 1,
				}, -- [2]
				{
					["Name"] = "Imbued Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [202]
		{
			["OnThis"] = "Oil",
			["Required"] = "Runed Truesilver Rod",
			["Link"] = "|cffffd000|Henchant:25128|h[Wizard Oil]|h|r",
			["Quality"] = "Wizard Oil",
			["EnchantName"] = "Wizard Oil",
			["Name"] = "Wizard Oil",
			["Bonus"] = "Spl Dmg +24",
			["Description"] = "Creates Wizard Oil.",
			["Icon"] = "Interface\\Icons\\INV_Potion_104",
			["Reagents"] = {
				{
					["Name"] = "Illusion Dust",
					["Count"] = 3,
				}, -- [1]
				{
					["Name"] = "Firebloom",
					["Count"] = 2,
				}, -- [2]
				{
					["Name"] = "Crystal Vial",
					["Count"] = 1,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [203]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a Melee Weapon to add up to 30 damage to spells.",
			["Link"] = "|cffffd000|Henchant:22749|h[Enchant Weapon - Spell Power]|h|r",
			["EnchantName"] = "Enchant Weapon - Spell Power",
			["Name"] = "Enchant Weapon",
			["BonusNb"] = 30,
			["Required"] = "Runed Arcanite Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				},
				[2] = {
					["Name"] = "Greater Eternal Essence",
					["Count"] = 12,
				},
				[3] = {
					["Name"] = "Essence of Fire",
					["Count"] = 4,
				},
				[4] = {
					["Name"] = "Essence of Water",
					["Count"] = 4,
				},
				[5] = {
					["Name"] = "Essence of Air",
					["Count"] = 4,
				},
				[6] = {
					["Name"] = "Golden Pearl",
					["Count"] = 2,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Spl Dmg",
		}, -- [204]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a Melee Weapon to add up to 55 points of healing to healing spells.",
			["Link"] = "|cffffd000|Henchant:22750|h[Enchant Weapon - Healing Power]|h|r",
			["EnchantName"] = "Enchant Weapon - Healing Power",
			["Name"] = "Enchant Weapon",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 55,
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 4,
				},
				[2] = {
					["Name"] = "Greater Eternal Essence",
					["Count"] = 8,
				},
				[3] = {
					["Name"] = "Living Essence",
					["Count"] = 6,
				},
				[4] = {
					["Name"] = "Essence of Water",
					["Count"] = 6,
				},
				[5] = {
					["Name"] = "Righteous Orb",
					["Count"] = 1,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Healing",
		}, -- [205]
		{
			["OnThis"] = "Gloves",
			["Description"] = "Permanently enchant gloves to increase frost damage by up to 20.",
			["EnchantName"] = "Enchant Gloves - Frost Power",
			["Link"] = "|cffffd000|Henchant:25074|h[Enchant Gloves - Frost Power]|h|r",
			["Name"] = "Enchant Gloves",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 20,
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 10,
				},
				[2] = {
					["Name"] = "Nexus Crystal",
					["Count"] = 3,
				},
				[3] = {
					["Name"] = "Essence of Water",
					["Count"] = 4,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Frst Dmg",
		}, -- [206]
		{
			["OnThis"] = "Gloves",
			["Description"] = "Permanently enchant gloves to increase agility by 15.",
			["Link"] = "|cffffd000|Henchant:25080|h[Enchant Gloves - Superior Agility]|h|r",
			["EnchantName"] = "Enchant Gloves - Superior Agility",
			["Name"] = "Enchant Gloves",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 15,
			["Reagents"] = {
				[1] = {
					["Name"] = "Small Prismatic Shard",
					["Count"] = 3,
				},
				[2] = {
					["Name"] = "Greater Planar Essence",
					["Count"] = 3,
				},
				[3] = {
					["Name"] = "Primal Air",
					["Count"] = 2,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Agi",
		}, -- [207]
		{
			["OnThis"] = "Gloves",
			["Description"] = "Permanently enchant gloves to increase fire damage by up to 20.",
			["Link"] = "|cffffd000|Henchant:25078|h[Enchant Gloves - Fire Power]|h|r",
			["EnchantName"] = "Enchant Gloves - Fire Power",
			["Name"] = "Enchant Gloves",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 20,
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 10,
				},
				[2] = {
					["Name"] = "Nexus Crystal",
					["Count"] = 2,
				},
				[3] = {
					["Name"] = "Essence of Fire",
					["Count"] = 4,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Fr Power",
		}, -- [208]
		{
			["OnThis"] = "Gloves",
			["Description"] = "Permanently enchant gloves to increase the caster's healing spells by up to 30.",
			["Link"] = "|cffffd000|Henchant:25079|h[Enchant Gloves - Healing Power]|h|r",
			["EnchantName"] = "Enchant Gloves - Healing Power",
			["Name"] = "Enchant Gloves",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 30,
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 8,
				},
				[2] = {
					["Name"] = "Nexus Crystal",
					["Count"] = 3,
				},
				[3] = {
					["Name"] = "Righteous Orb",
					["Count"] = 1,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Healing",
		}, -- [209]
		{
			["OnThis"] = "Gloves",
			["Description"] = "Permanently enchant gloves to increase shadow damage by up to 20.",
			["Link"] = "|cffffd000|Henchant:25073|h[Enchant Gloves - Shadow Power]|h|r",
			["EnchantName"] = "Enchant Gloves - Shadow Power",
			["Name"] = "Enchant Gloves",
			["Required"] = "Runed Arcanite Rod",
			["BonusNb"] = 20,
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Brilliant Shard",
					["Count"] = 10,
				},
				[2] = {
					["Name"] = "Nexus Crystal",
					["Count"] = 3,
				},
				[3] = {
					["Name"] = "Essence of Undeath",
					["Count"] = 6,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Sdw Dmg",
		}, -- [210]
		{
			["OnThis"] = "Boots",
			["Description"] = "Permanently enchant boots to increase snare and root resistance by 5% and increase hit rating by 10.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27954|h[Enchant Boots - Surefooted]|h|r",
			["EnchantName"] = "Enchant Boots - Surefooted",
			["Name"] = "Enchant Boots",
			["Required"] = "Runed Eternium Rod",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				}, -- [2]
				{
					["Name"] = "Primal Nether",
					["Count"] = 1,
				}, -- [3]
				["Etat"] = -2,
			},
			["Bonus"] = "Surefooted",
		}, -- [211]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a Melee Weapon to occasionally increase Agility by 120 and attack speed slightly.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27984|h[Enchant Weapon - Mongoose]|h|r",
			["EnchantName"] = "Enchant Weapon - Mongoose",
			["Name"] = "Enchant Weapon",
			["Required"] = "Runed Eternium Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Void Crystal",
					["Count"] = 6,
				},
				[2] = {
					["Name"] = "Large Prismatic Shard",
					["Count"] = 10,
				},
				[3] = {
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				},
				[4] = {
					["Name"] = "Arcane Dust",
					["Count"] = 40,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Mongoose",
		}, -- [212]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a Melee Weapon to add up to 54 damage to frost and shadow spells.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27982|h[Enchant Weapon - Soulfrost]|h|r",
			["EnchantName"] = "Enchant Weapon - Soulfrost",
			["Name"] = "Enchant Weapon",
			["Required"] = "Runed Eternium Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Void Crystal",
					["Count"] = 6,
				},
				[2] = {
					["Name"] = "Large Prismatic Shard",
					["Count"] = 10,
				},
				[3] = {
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				},
				[4] = {
					["Name"] = "Primal Water",
					["Count"] = 10,
				},
				[5] = {
					["Name"] = "Primal Shadow",
					["Count"] = 10,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Soulfrost",
		}, -- [213]
		{
			["OnThis"] = "2H Weap",
			["Description"] = "Permanently enchant a Two Handed Melee Weapon to add 70 attack power.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27971|h[Enchant 2H Weapon - Savagery]|h|r",
			["EnchantName"] = "Enchant 2H Weapon - Savagery",
			["Name"] = "Enchant 2H Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Large Prismatic Shard",
					["Count"] = 4,
				},
				[2] = {
					["Name"] = "Arcane Dust",
					["Count"] = 40,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Savagery",
		}, -- [214]
		{
			["OnThis"] = "2H Weap",
			["Description"] = "Permanently enchant a Two Handed Melee Weapon to add 35 Agility.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27977|h[Enchant 2H Weapon - Major Agility]|h|r",
			["EnchantName"] = "Enchant 2H Weapon - Major Agility",
			["BonusNb"] = 35,
			["Name"] = "Enchant 2H Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 6,
				}, -- [2]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 20,
				}, -- [3]
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Agi",
		}, -- [215]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a Melee Weapon to occasionally ignore 840 of your enemy's armor.  Requires a level 60 or higher item.",
			["Link"] = "|cffffd000|Henchant:42974|h[Enchant Weapon - Executioner]|h|r",
			["EnchantName"] = "Enchant Weapon - Executioner",
			["Name"] = "Enchant Weapon",
			["Required"] = "Runed Eternium Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Void Crystal",
					["Count"] = 6,
				},
				[2] = {
					["Name"] = "Large Prismatic Shard",
					["Count"] = 10,
				},
				[3] = {
					["Name"] = "Greater Planar Essence",
					["Count"] = 6,
				},
				[4] = {
					["Name"] = "Arcane Dust",
					["Count"] = 30,
				},
				[5] = {
					["Name"] = "Elixir of Major Strength",
					["Count"] = 3,
				},
				["Etat"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Executioner",
		}, -- [216]
		{
			["OnThis"] = "Ring",
			["Description"] = "Permanently enchant ring to add 2 damage to physical attacks.  Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound.  Requires a level 35 or higher item.",
			["Link"] = "|cffffd000|Henchant:27920|h[Enchant Ring - Striking]|h|r",
			["EnchantName"] = "Enchant Ring - Striking",
			["BonusNb"] = 2,
			["Name"] = "Enchant Ring",
			["Required"] = "Runed Adamantite Rod",
			["Bonus"] = "Dmg",
			["Quality"] = "Striking",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Large Prismatic Shard",
					["Count"] = 2,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 6,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [217]
		{
			["OnThis"] = "Cloak",
			["Required"] = "Runed Adamantite Rod",
			["Link"] = "|cffffd000|Henchant:47051|h[Enchant Cloak - Steelweave]|h|r",
			["Quality"] = "Steelweave",
			["EnchantName"] = "Enchant Cloak - Steelweave",
			["BonusNb"] = 12,
			["Name"] = "Enchant Cloak",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchant a cloak to grant 12 defense rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 8,
				}, -- [1]
				{
					["Name"] = "Primal Earth",
					["Count"] = 8,
				}, -- [2]
				["Feasibility"] = -2,
			},
		}, -- [218]
		{
			["OnThis"] = "Chest",
			["Required"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffd000|Henchant:46594|h[Enchant Chest - Defense]|h|r",
			["Quality"] = "Defense",
			["EnchantName"] = "Enchant Chest - Defense",
			["BonusNb"] = 15,
			["Name"] = "Enchant Chest",
			["Bonus"] = "Def",
			["Description"] = "Permanently enchant a piece of chest armor to grant 15 defense rating.  Requires a level 35 or higher item.",
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Reagents"] = {
				{
					["Name"] = "Greater Planar Essence",
					["Count"] = 4,
				}, -- [1]
				{
					["Name"] = "Arcane Dust",
					["Count"] = 8,
				}, -- [2]
				{
					["Name"] = "Eternium Ore",
					["Count"] = 4,
				}, -- [3]
				["Feasibility"] = -2,
			},
		}, -- [219]
		{
			["OnThis"] = "Other",
			["Required"] = "Runed Eternium Rod",
			["Link"] = "|cff0070dd|Hitem:45765:0:0:0:0:0:0:0|h[Void Shatter]|h|r",
			["Quality"] = "Void Shatter",
			["EnchantName"] = "Void Shatter",
			["Name"] = "Void Shatter",
			["Bonus"] = "Void Shatter",
			["Description"] = "Shatters a Void Crystal into two Prismatic Shards.",
			["Icon"] = "Interface\\Icons\\INV_Enchant_ShardPrismaticLarge",
			["Reagents"] = {
				{
					["Name"] = "Void Crystal",
					["Count"] = 1,
				}, -- [1]
				["Feasibility"] = -2,
			},
		}, -- [220]
		{
			["OnThis"] = "Weapon",
			["Description"] = "Permanently enchant a weapon so your damaging spells and melee weapon hits occasionally inflict an additional 150 Frost damage and reduce the target's melee, ranged, and casting speed by 15% for 8 sec.  Requires a level 60 or higher item.",
			["Link"] = "|cffffd000|Henchant:46578|h[Enchant Weapon - Deathfrost]|h|r",
			["EnchantName"] = "Enchant Weapon - Deathfrost",
			["Name"] = "Enchant Weapon",
			["Required"] = "Runed Adamantite Rod",
			["Reagents"] = {
				[1] = {
					["Name"] = "Primal Shadow",
					["Count"] = 2,
				},
				[2] = {
					["Name"] = "Primal Water",
					["Count"] = 2,
				},
				["Feasibility"] = -2,
			},
			["Icon"] = "Interface\\Icons\\Spell_Holy_GreaterHeal",
			["Bonus"] = "Deathfrost",
		}, -- [221]
	},
	["Reagents"] = {
		{
			["Name"] = "Large Prismatic Shard",
			["Link"] = "|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardPrismaticLarge",
		}, -- [1]
		{
			["Name"] = "Greater Planar Essence",
			["Link"] = "|cff1eff00|Hitem:22446:0:0:0:0:0:0:0|h[Greater Planar Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceArcaneLarge",
		}, -- [2]
		{
			["Name"] = "Arcane Dust",
			["Link"] = "|cffffffff|Hitem:22445:0:0:0:0:0:0:0|h[Arcane Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustArcane",
		}, -- [3]
		{
			["Name"] = "Void Crystal",
			["Link"] = "|cffa335ee|Hitem:22450:0:0:0:0:0:0:0|h[Void Crystal]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_VoidCrystal",
		}, -- [4]
		{
			["Name"] = "Primal Fire",
			["Link"] = "|cff1eff00|Hitem:21884:0:0:0:0:0:0:0|h[Primal Fire]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Fire",
		}, -- [5]
		{
			["Name"] = "Primal Might",
			["Link"] = "|cff0070dd|Hitem:23571:0:0:0:0:0:0:0|h[Primal Might]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_LightningOverload",
		}, -- [6]
		{
			["Name"] = "Primal Earth",
			["Link"] = "|cff1eff00|Hitem:22452:0:0:0:0:0:0:0|h[Primal Earth]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Earth",
		}, -- [7]
		{
			["Name"] = "Primal Air",
			["Link"] = "|cff1eff00|Hitem:22451:0:0:0:0:0:0:0|h[Primal Air]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Air",
		}, -- [8]
		{
			["Name"] = "Primal Water",
			["Link"] = "|cff1eff00|Hitem:21885:0:0:0:0:0:0:0|h[Primal Water]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Water",
		}, -- [9]
		{
			["Name"] = "Primal Mana",
			["Link"] = "|cff1eff00|Hitem:22457:0:0:0:0:0:0:0|h[Primal Mana]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Mana",
		}, -- [10]
		{
			["Name"] = "Eternium Rod",
			["Link"] = "|cffffffff|Hitem:25845:0:0:0:0:0:0:0|h[Eternium Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Rod_Eternium",
		}, -- [11]
		{
			["Name"] = "Runed Adamantite Rod",
			["Link"] = "|cff1eff00|Hitem:22462:0:0:0:0:0:0:0|h[Runed Adamantite Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Rod_EnchantedAdamantite",
		}, -- [12]
		{
			["Name"] = "Primal Shadow",
			["Link"] = "|cff1eff00|Hitem:22456:0:0:0:0:0:0:0|h[Primal Shadow]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Shadow",
		}, -- [13]
		{
			["Name"] = "Primal Life",
			["Link"] = "|cff1eff00|Hitem:21886:0:0:0:0:0:0:0|h[Primal Life]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Life",
		}, -- [14]
		{
			["Name"] = "Adamantite Rod",
			["Link"] = "|cffffffff|Hitem:25844:0:0:0:0:0:0:0|h[Adamantite Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Rod_Adamantite",
		}, -- [15]
		{
			["Name"] = "Runed Fel Iron Rod",
			["Link"] = "|cffffffff|Hitem:22461:0:0:0:0:0:0:0|h[Runed Fel Iron Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Rod_EnchantedFelsteel",
		}, -- [16]
		{
			["Name"] = "Large Brilliant Shard",
			["Link"] = "|cff0070dd|Hitem:14344:0:0:0:0:0:0:0|h[Large Brilliant Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardBrilliantLarge",
		}, -- [17]
		{
			["Name"] = "Purple Lotus",
			["Link"] = "|cffffffff|Hitem:8831:0:0:0:0:0:0:0|h[Purple Lotus]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_17",
		}, -- [18]
		{
			["Name"] = "Imbued Vial",
			["Link"] = "|cffffffff|Hitem:18256:0:0:0:0:0:0:0|h[Imbued Vial]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Drink_06",
		}, -- [19]
		{
			["Name"] = "Firebloom",
			["Link"] = "|cffffffff|Hitem:4625:0:0:0:0:0:0:0|h[Firebloom]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_19",
		}, -- [20]
		{
			["Name"] = "Greater Eternal Essence",
			["Link"] = "|cff1eff00|Hitem:16203:0:0:0:0:0:0:0|h[Greater Eternal Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceEternalLarge",
		}, -- [21]
		{
			["Name"] = "Illusion Dust",
			["Link"] = "|cffffffff|Hitem:16204:0:0:0:0:0:0:0|h[Illusion Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustIllusion",
		}, -- [22]
		{
			["Name"] = "Essence of Air",
			["Link"] = "|cff1eff00|Hitem:7082:0:0:0:0:0:0:0|h[Essence of Air]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_EarthBind",
		}, -- [23]
		{
			["Name"] = "Large Radiant Shard",
			["Link"] = "|cff0070dd|Hitem:11178:0:0:0:0:0:0:0|h[Large Radiant Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardRadientLarge",
		}, -- [24]
		{
			["Name"] = "Dream Dust",
			["Link"] = "|cffffffff|Hitem:11176:0:0:0:0:0:0:0|h[Dream Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustDream",
		}, -- [25]
		{
			["Name"] = "Vision Dust",
			["Link"] = "|cffffffff|Hitem:11137:0:0:0:0:0:0:0|h[Vision Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustVision",
		}, -- [26]
		{
			["Name"] = "Large Glowing Shard",
			["Link"] = "|cff0070dd|Hitem:11139:0:0:0:0:0:0:0|h[Large Glowing Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardGlowingLarge",
		}, -- [27]
		{
			["Name"] = "Soul Dust",
			["Link"] = "|cffffffff|Hitem:11083:0:0:0:0:0:0:0|h[Soul Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustSoul",
		}, -- [28]
		{
			["Name"] = "Large Glimmering Shard",
			["Link"] = "|cff0070dd|Hitem:11084:0:0:0:0:0:0:0|h[Large Glimmering Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardGlimmeringLarge",
		}, -- [29]
		{
			["Name"] = "Greater Magic Essence",
			["Link"] = "|cff1eff00|Hitem:10939:0:0:0:0:0:0:0|h[Greater Magic Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceMagicLarge",
		}, -- [30]
		{
			["Name"] = "Lesser Astral Essence",
			["Link"] = "|cff1eff00|Hitem:10998:0:0:0:0:0:0:0|h[Lesser Astral Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceAstralSmall",
		}, -- [31]
		{
			["Name"] = "Strange Dust",
			["Link"] = "|cffffffff|Hitem:10940:0:0:0:0:0:0:0|h[Strange Dust]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_DustStrange",
		}, -- [32]
		{
			["Name"] = "Small Glimmering Shard",
			["Link"] = "|cff0070dd|Hitem:10978:0:0:0:0:0:0:0|h[Small Glimmering Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardGlimmeringSmall",
		}, -- [33]
		{
			["Name"] = "Greater Nether Essence",
			["Link"] = "|cff1eff00|Hitem:11175:0:0:0:0:0:0:0|h[Greater Nether Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceNetherLarge",
		}, -- [34]
		{
			["Name"] = "Lesser Mystic Essence",
			["Link"] = "|cff1eff00|Hitem:11134:0:0:0:0:0:0:0|h[Lesser Mystic Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceMysticalSmall",
		}, -- [35]
		{
			["Name"] = "Greater Mystic Essence",
			["Link"] = "|cff1eff00|Hitem:11135:0:0:0:0:0:0:0|h[Greater Mystic Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceMysticalLarge",
		}, -- [36]
		{
			["Name"] = "Small Radiant Shard",
			["Link"] = "|cff0070dd|Hitem:11177:0:0:0:0:0:0:0|h[Small Radiant Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardRadientSmall",
		}, -- [37]
		{
			["Name"] = "Aquamarine",
			["Link"] = "|cff1eff00|Hitem:7909:0:0:0:0:0:0:0|h[Aquamarine]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Crystal_02",
		}, -- [38]
		{
			["Name"] = "Lesser Nether Essence",
			["Link"] = "|cff1eff00|Hitem:11174:0:0:0:0:0:0:0|h[Lesser Nether Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceNetherSmall",
		}, -- [39]
		{
			["Name"] = "Lesser Eternal Essence",
			["Link"] = "|cff1eff00|Hitem:16202:0:0:0:0:0:0:0|h[Lesser Eternal Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceEternalSmall",
		}, -- [40]
		{
			["Name"] = "Major Healing Potion",
			["Link"] = "|cffffffff|Hitem:13446:0:0:0:0:0:0:0|h[Major Healing Potion]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_54",
		}, -- [41]
		{
			["Name"] = "Major Mana Potion",
			["Link"] = "|cffffffff|Hitem:13444:0:0:0:0:0:0:0|h[Major Mana Potion]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_76",
		}, -- [42]
		{
			["Name"] = "Living Essence",
			["Link"] = "|cff1eff00|Hitem:12803:0:0:0:0:0:0:0|h[Living Essence]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_AbolishMagic",
		}, -- [43]
		{
			["Name"] = "Greater Astral Essence",
			["Link"] = "|cff1eff00|Hitem:11082:0:0:0:0:0:0:0|h[Greater Astral Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceAstralLarge",
		}, -- [44]
		{
			["Name"] = "Small Prismatic Shard",
			["Link"] = "|cff0070dd|Hitem:22448:0:0:0:0:0:0:0|h[Small Prismatic Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardPrismaticSmall",
		}, -- [45]
		{
			["Name"] = "Lesser Planar Essence",
			["Link"] = "|cff1eff00|Hitem:22447:0:0:0:0:0:0:0|h[Lesser Planar Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceArcaneSmall",
		}, -- [46]
		{
			["Name"] = "Essence of Water",
			["Link"] = "|cff1eff00|Hitem:7080:0:0:0:0:0:0:0|h[Essence of Water]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_Acid_01",
		}, -- [47]
		{
			["Name"] = "Lesser Magic Essence",
			["Link"] = "|cff1eff00|Hitem:10938:0:0:0:0:0:0:0|h[Lesser Magic Essence]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_EssenceMagicSmall",
		}, -- [48]
		{
			["Name"] = "Small Brilliant Shard",
			["Link"] = "|cff0070dd|Hitem:14343:0:0:0:0:0:0:0|h[Small Brilliant Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardBrilliantSmall",
		}, -- [49]
		{
			["Name"] = "Small Glowing Shard",
			["Link"] = "|cff0070dd|Hitem:11138:0:0:0:0:0:0:0|h[Small Glowing Shard]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardGlowingSmall",
		}, -- [50]
		{
			["Name"] = "Elemental Fire",
			["Link"] = "|cffffffff|Hitem:7068:0:0:0:0:0:0:0|h[Elemental Fire]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Fire_Fire",
		}, -- [51]
		{
			["Name"] = "Essence of Fire",
			["Link"] = "|cff1eff00|Hitem:7078:0:0:0:0:0:0:0|h[Essence of Fire]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Fire_Volcano",
		}, -- [52]
		{
			["Name"] = "Heart of Fire",
			["Link"] = "|cffffffff|Hitem:7077:0:0:0:0:0:0:0|h[Heart of Fire]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Fire_LavaSpawn",
		}, -- [53]
		{
			["Name"] = "Core of Earth",
			["Link"] = "|cffffffff|Hitem:7075:0:0:0:0:0:0:0|h[Core of Earth]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Stone_05",
		}, -- [54]
		{
			["Name"] = "Globe of Water",
			["Link"] = "|cffffffff|Hitem:7079:0:0:0:0:0:0:0|h[Globe of Water]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Orb_01",
		}, -- [55]
		{
			["Name"] = "Breath of Wind",
			["Link"] = "|cffffffff|Hitem:7081:0:0:0:0:0:0:0|h[Breath of Wind]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_Cyclone",
		}, -- [56]
		{
			["Name"] = "Ichor of Undeath",
			["Link"] = "|cffffffff|Hitem:7972:0:0:0:0:0:0:0|h[Ichor of Undeath]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Slime_01",
		}, -- [57]
		{
			["Name"] = "Fire Oil",
			["Link"] = "|cffffffff|Hitem:6371:0:0:0:0:0:0:0|h[Fire Oil]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_38",
		}, -- [58]
		{
			["Name"] = "Shadow Protection Potion",
			["Link"] = "|cffffffff|Hitem:6048:0:0:0:0:0:0:0|h[Shadow Protection Potion]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_44",
		}, -- [59]
		{
			["Name"] = "Fel Lotus",
			["Link"] = "|cffffffff|Hitem:22794:0:0:0:0:0:0:0|h[Fel Lotus]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_FelLotus",
		}, -- [60]
		{
			["Name"] = "Sungrass",
			["Link"] = "|cffffffff|Hitem:8838:0:0:0:0:0:0:0|h[Sungrass]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_18",
		}, -- [61]
		{
			["Name"] = "Truesilver Bar",
			["Link"] = "|cff1eff00|Hitem:6037:0:0:0:0:0:0:0|h[Truesilver Bar]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Ingot_08",
		}, -- [62]
		{
			["Name"] = "Blackmouth Oil",
			["Link"] = "|cffffffff|Hitem:6370:0:0:0:0:0:0:0|h[Blackmouth Oil]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Drink_12",
		}, -- [63]
		{
			["Name"] = "Kingsblood",
			["Link"] = "|cffffffff|Hitem:3356:0:0:0:0:0:0:0|h[Kingsblood]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_03",
		}, -- [64]
		{
			["Name"] = "Iron Ore",
			["Link"] = "|cffffffff|Hitem:2772:0:0:0:0:0:0:0|h[Iron Ore]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Ore_Iron_01",
		}, -- [65]
		{
			["Name"] = "Wildvine",
			["Link"] = "|cffffffff|Hitem:8153:0:0:0:0:0:0:0|h[Wildvine]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_03",
		}, -- [66]
		{
			["Name"] = "Green Whelp Scale",
			["Link"] = "|cffffffff|Hitem:7392:0:0:0:0:0:0:0|h[Green Whelp Scale]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_MonsterScales_03",
		}, -- [67]
		{
			["Name"] = "Frost Oil",
			["Link"] = "|cffffffff|Hitem:3829:0:0:0:0:0:0:0|h[Frost Oil]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_20",
		}, -- [68]
		{
			["Name"] = "Righteous Orb",
			["Link"] = "|cff1eff00|Hitem:12811:0:0:0:0:0:0:0|h[Righteous Orb]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Pearl_03",
		}, -- [69]
		{
			["Name"] = "Elixir of Demonslaying",
			["Link"] = "|cffffffff|Hitem:9224:0:0:0:0:0:0:0|h[Elixir of Demonslaying]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Potion_27",
		}, -- [70]
		{
			["Name"] = "Icecap",
			["Link"] = "|cffffffff|Hitem:13467:0:0:0:0:0:0:0|h[Icecap]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_IceCap",
		}, -- [71]
		{
			["Name"] = "Large Fang",
			["Link"] = "|cffffffff|Hitem:5637:0:0:0:0:0:0:0|h[Large Fang]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Bone_08",
		}, -- [72]
		{
			["Name"] = "Elemental Earth",
			["Link"] = "|cffffffff|Hitem:7067:0:0:0:0:0:0:0|h[Elemental Earth]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Ore_Iron_01",
		}, -- [73]
		{
			["Name"] = "Essence of Undeath",
			["Link"] = "|cff1eff00|Hitem:12808:0:0:0:0:0:0:0|h[Essence of Undeath]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Shadow_ShadeTrueSight",
		}, -- [74]
		{
			["Name"] = "Essence of Earth",
			["Link"] = "|cff1eff00|Hitem:7076:0:0:0:0:0:0:0|h[Essence of Earth]|h|r",
			["Texture"] = "Interface\\Icons\\Spell_Nature_StrengthOfEarthTotem02",
		}, -- [75]
		{
			["Name"] = "Wintersbite",
			["Link"] = "|cffffffff|Hitem:3819:0:0:0:0:0:0:0|h[Wintersbite]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Flower_03",
		}, -- [76]
		{
			["Name"] = "Rugged Leather",
			["Link"] = "|cffffffff|Hitem:8170:0:0:0:0:0:0:0|h[Rugged Leather]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_LeatherScrap_02",
		}, -- [77]
		{
			["Name"] = "Thorium Bar",
			["Link"] = "|cffffffff|Hitem:12359:0:0:0:0:0:0:0|h[Thorium Bar]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Ingot_07",
		}, -- [78]
		{
			["Name"] = "Simple Wood",
			["Link"] = "|cffffffff|Hitem:4470:0:0:0:0:0:0:0|h[Simple Wood]|h|r",
			["Texture"] = "Interface\\Icons\\INV_TradeskillItem_01",
		}, -- [79]
		{
			["Name"] = "Star Wood",
			["Link"] = "|cffffffff|Hitem:11291:0:0:0:0:0:0:0|h[Star Wood]|h|r",
			["Texture"] = "Interface\\Icons\\INV_TradeskillItem_03",
		}, -- [80]
		{
			["Name"] = "Crystal Vial",
			["Link"] = "|cffffffff|Hitem:8925:0:0:0:0:0:0:0|h[Crystal Vial]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Drink_06",
		}, -- [81]
		{
			["Name"] = "Stranglethorn Seed",
			["Link"] = "|cffffffff|Hitem:17035:0:0:0:0:0:0:0|h[Stranglethorn Seed]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Food_02",
		}, -- [82]
		{
			["Name"] = "Leaded Vial",
			["Link"] = "|cffffffff|Hitem:3372:0:0:0:0:0:0:0|h[Leaded Vial]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Drink_06",
		}, -- [83]
		{
			["Name"] = "Maple Seed",
			["Link"] = "|cffffffff|Hitem:17034:0:0:0:0:0:0:0|h[Maple Seed]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Food_02",
		}, -- [84]
		{
			["Name"] = "Empty Vial",
			["Link"] = "|cffffffff|Hitem:3371:0:0:0:0:0:0:0|h[Empty Vial]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Drink_06",
		}, -- [85]
		{
			["Name"] = "Nexus Crystal",
			["Link"] = "|cffa335ee|Hitem:20725:0:0:0:0:0:0:0|h[Nexus Crystal]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Enchant_ShardNexusLarge",
		}, -- [86]
		{
			["Name"] = "Arcanite Rod",
			["Link"] = "|cffffffff|Hitem:16206:0:0:0:0:0:0:0|h[Arcanite Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_19",
		}, -- [87]
		{
			["Name"] = "Golden Pearl",
			["Link"] = "|cff1eff00|Hitem:13926:0:0:0:0:0:0:0|h[Golden Pearl]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Pearl_04",
		}, -- [88]
		{
			["Name"] = "Runed Truesilver Rod",
			["Link"] = "|cffffffff|Hitem:11145:0:0:0:0:0:0:0|h[Runed Truesilver Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_11",
		}, -- [89]
		{
			["Name"] = "Copper Rod",
			["Link"] = "|cffffffff|Hitem:6217:0:0:0:0:0:0:0|h[Copper Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Flute_01",
		}, -- [90]
		{
			["Name"] = "Fel Iron Rod",
			["Link"] = "|cffffffff|Hitem:25843:0:0:0:0:0:0:0|h[Fel Iron Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Rod_Felsteel",
		}, -- [91]
		{
			["Name"] = "Runed Arcanite Rod",
			["Link"] = "|cffffffff|Hitem:16207:0:0:0:0:0:0:0|h[Runed Arcanite Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Wand_09",
		}, -- [92]
		{
			["Name"] = "Golden Rod",
			["Link"] = "|cffffffff|Hitem:11128:0:0:0:0:0:0:0|h[Golden Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_10",
		}, -- [93]
		{
			["Name"] = "Iridescent Pearl",
			["Link"] = "|cff1eff00|Hitem:5500:0:0:0:0:0:0:0|h[Iridescent Pearl]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Pearl_02",
		}, -- [94]
		{
			["Name"] = "Runed Silver Rod",
			["Link"] = "|cffffffff|Hitem:6339:0:0:0:0:0:0:0|h[Runed Silver Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_01",
		}, -- [95]
		{
			["Name"] = "Silver Rod",
			["Link"] = "|cffffffff|Hitem:6338:0:0:0:0:0:0:0|h[Silver Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_01",
		}, -- [96]
		{
			["Name"] = "Runed Copper Rod",
			["Link"] = "|cffffffff|Hitem:6218:0:0:0:0:0:0:0|h[Runed Copper Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_Goldfeathered_01",
		}, -- [97]
		{
			["Name"] = "Truesilver Rod",
			["Link"] = "|cffffffff|Hitem:11144:0:0:0:0:0:0:0|h[Truesilver Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_11",
		}, -- [98]
		{
			["Name"] = "Black Pearl",
			["Link"] = "|cff1eff00|Hitem:7971:0:0:0:0:0:0:0|h[Black Pearl]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Pearl_01",
		}, -- [99]
		{
			["Name"] = "Runed Golden Rod",
			["Link"] = "|cffffffff|Hitem:11130:0:0:0:0:0:0:0|h[Runed Golden Rod]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Staff_10",
		}, -- [100]
		{
			["Name"] = "Blood of the Mountain",
			["Link"] = "|cff1eff00|Hitem:11382:0:0:0:0:0:0:0|h[Blood of the Mountain]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Gem_Bloodstone_03",
		}, -- [101]
		{
			["Name"] = "Netherbloom",
			["Link"] = "|cffffffff|Hitem:22791:0:0:0:0:0:0:0|h[Netherbloom]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_Netherbloom",
		}, -- [102]
		{
			["Name"] = "Nightmare Vine",
			["Link"] = "|cffffffff|Hitem:22792:0:0:0:0:0:0:0|h[Nightmare Vine]|h|r",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_Nightmarevine",
		}, -- [103]
		{
			["Link"] = "|cff0070dd|Hitem:23572:0:0:0:0:0:0:0|h[Primal Nether]|h|r",
			["Name"] = "Primal Nether",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Primal_Nether",
		}, -- [104]
		{
			["Link"] = "|cff1eff00|Hitem:12809:0:0:0:0:0:0:0|h[Guardian Stone]|h|r",
			["Name"] = "Guardian Stone",
			["Texture"] = "Interface\\Icons\\INV_Stone_02",
		}, -- [105]
		{
			["Link"] = "|cff1eff00|Hitem:12809:0:0:0:0:0:0:0|h[Black Lotus]|h|r",
			["Name"] = "Black Lotus",
			["Texture"] = "Interface\\Icons\\INV_Misc_Herb_BlackLotus",
		}, -- [106]
		{
			["Link"] = "|cff1eff00|Hitem:12809:0:0:0:0:0:0:0|h[Larval Acid]|h|r",
			["Name"] = "Larval Acid",
			["Texture"] = "Interface\\Icons\\INV_Potion_22",
		}, -- [107]
		{
			["Link"] = "|cffffffff|Hitem:22824:0:0:0:0:0:0:0|h[Elixir of Major Strength]|h|r",
			["Name"] = "Elixir of Major Strength",
			["Texture"] = "Interface\\Icons\\INV_Potion_147",
		}, -- [108]
		{
			["Link"] = "|cff1eff00|Hitem:23427:0:0:0:0:0:0:0|h[Eternium Ore]|h|r",
			["Name"] = "Eternium Ore",
			["Texture"] = "Interface\\Icons\\INV_Ore_Eternium",
		}, -- [109]
		{
			["Link"] = "|cffffffff|Hitem:22573:0:0:0:0:0:0:0|h[Mote of Earth]|h|r",
			["Name"] = "Mote of Earth",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Mote_Earth01",
		}, -- [110]
		{
			["Link"] = "|cffffffff|Hitem:22574:0:0:0:0:0:0:0|h[Mote of Fire]|h|r",
			["Name"] = "Mote of Fire",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Mote_Fire01",
		}, -- [111]
		{
			["Link"] = "|cffffffff|Hitem:22572:0:0:0:0:0:0:0|h[Mote of Air]|h|r",
			["Name"] = "Mote of Air",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Mote_Air01",
		}, -- [112]
		{
			["Link"] = "|cffffffff|Hitem:22578:0:0:0:0:0:0:0|h[Mote of Water]|h|r",
			["Name"] = "Mote of Water",
			["Texture"] = "Interface\\Icons\\INV_Elemental_Mote_Water01",
		}, -- [113]
	},
},


} end)
