
---------------------------------------------------------------------------------
-- Loading the Emote options menu
---------------------------------------------------------------------------------
function EmoteMenuOptions_OnLoad()
	-- Makes the frame closable with the ESCape key
	tinsert(UISpecialFrames, this:GetName()); 

	EmoteMenuOptionsScaleSlider:SetMinMaxValues(0.5, 2.0);
	EmoteMenuOptionsScaleSlider:SetValueStep(0.01);
	EmoteMenuOptionsScaleSliderLow:SetText("0.5");
	EmoteMenuOptionsScaleSliderHigh:SetText("2.0");

	EmoteMenuOptionsHSlider:SetMinMaxValues(-100, 100);
	EmoteMenuOptionsHSlider:SetValueStep(1);
	EmoteMenuOptionsHSliderLow:SetText("-100");
	EmoteMenuOptionsHSliderHigh:SetText("100");

	EmoteMenuOptionsDirectionSliderText:SetText("Menu Direction");
	EmoteMenuOptionsDirectionSlider:SetMinMaxValues(0, 1);
	EmoteMenuOptionsDirectionSlider:SetValueStep(1);
	EmoteMenuOptionsDirectionSliderLow:SetText("Down");
	EmoteMenuOptionsDirectionSliderHigh:SetText("Up");

	EmoteMenuOptionsTooltipAnchorSliderText:SetText("Tooltip Anchor");
	EmoteMenuOptionsTooltipAnchorSlider:SetMinMaxValues(1, 2);
	EmoteMenuOptionsTooltipAnchorSlider:SetValueStep(1);
	EmoteMenuOptionsTooltipAnchorSliderLow:SetText("Left");
	EmoteMenuOptionsTooltipAnchorSliderHigh:SetText("Right");

	EmoteMenuVersionInfo:SetText("Emote Menu v" .. EMOTEMENU_VERSION .. " by Shervin");
end

function EmoteMenuOptions_OnShow()
	PlaySound("igMainMenuOptionCheckBoxOn");
	-- Init the options component values
	EmoteMenuOptionsScaleSlider:SetValue(EmoteMenuSettings.Scale);
	EmoteMenuOptionsHSlider:SetValue(EmoteMenuSettings.HPos);
	EmoteMenuOptionsDirectionSlider:SetValue(EmoteMenuSettings.Direction);
	EmoteMenuOptionsTooltipAnchorSlider:SetValue(EmoteMenuSettings.TooltipAnchor);
	StayOpenCheckbutton:SetChecked(EmoteMenuSettings.StayOpen);
	EnableTooltipsCheckbutton:SetChecked(EmoteMenuSettings.Tooltips);
	ClampedToScreenCheckbutton:SetChecked(EmoteMenuSettings.ClampedToScreen);
	EmoteMenuGreenFiltersEditBox:SetText(EmoteMenuSettings.GreenFilter);
	EmoteMenuRedFiltersEditBox:SetText(EmoteMenuSettings.RedFilter);
	EmoteMenuBlueFiltersEditBox:SetText(EmoteMenuSettings.BlueFilter);
	EmoteMenuYellowFiltersEditBox:SetText(EmoteMenuSettings.YellowFilter);
end

function EmoteMenuOptionsScaleSlider_OnValueChanged()
	EmoteMenuSettings.Scale = this:GetValue();
	EmoteMenuOptionsScaleSliderText:SetText("Scale:  " .. format("%.2f", EmoteMenuSettings.Scale));
	EmoteMenuFrame:SetScale(EmoteMenuSettings.Scale);
	EmoteMenuFrame_OnShow();
end

function EmoteMenuOptionsHSlider_OnValueChanged()
	EmoteMenuSettings.HPos = this:GetValue();
	EmoteMenuOptionsHSliderText:SetText("Horizontal Position:  " .. EmoteMenuSettings.HPos);
	EmoteMenuFrame_SetPoint(EmoteMenuSettings.Direction);
	EmoteMenuFrame_OnShow();
end

function EmoteMenuOptionsDirectionSlider_OnValueChanged()
	EmoteMenuSettings.Direction = this:GetValue();
	EmoteMenuFrame_SetPoint(EmoteMenuSettings.Direction);
	EmoteMenuFrame_OnShow();
end

function EmoteMenuOptionsTooltipAnchorSlider_OnValueChanged()
	EmoteMenuSettings.TooltipAnchor = this:GetValue();
end

function StayOpen_OnClick()
	if (this:GetChecked()) then
		EmoteMenuSettings.StayOpen = 1;
		EmoteMenuFrame_OnShow();
	else
		EmoteMenuSettings.StayOpen = 0;
		EmoteMenuFrame_OnLeave();
	end
end

function Tooltips_OnClick()
	if (this:GetChecked()) then
		EmoteMenuSettings.Tooltips = 1;
	else
		EmoteMenuSettings.Tooltips = 0;
	end
end

function ClampedToScreen_OnClick()
	if (this:GetChecked()) then
		EmoteMenuSettings.ClampedToScreen = 1;
	else
		EmoteMenuSettings.ClampedToScreen = 0;
	end
end

function EmoteMenuGreenFiltersEditBox_OnTextChanged()
end

function EmoteMenuRedFiltersEditBox_OnTextChanged()
end

function EmoteMenuBlueFiltersEditBox_OnTextChanged()
end

function EmoteMenuYellowFiltersEditBox_OnTextChanged()
end

function EmoteMenuOptionsCancelButton_OnClick()
	PlaySound("igMainMenuOptionCheckBoxOn");
	this:GetParent():Hide();
end

function EmoteMenuOptionsOkButton_OnClick()
	-- Set Clamped To Screen
	EmoteMenuTitleButton:SetClampedToScreen(EmoteMenuSettings.ClampedToScreen);
	EmoteMenuFrame:SetClampedToScreen(EmoteMenuSettings.ClampedToScreen);
	-- Set Green Emote filters
	EmoteMenuSettings.GreenFilter = f_AddCommaToString(EmoteMenuGreenFiltersEditBox:GetText());
	EmoteMenuGreenFiltersEditBox:SetText(EmoteMenuSettings.GreenFilter);
	-- Set Red Emote filters
	EmoteMenuSettings.RedFilter = f_AddCommaToString(EmoteMenuRedFiltersEditBox:GetText());
	EmoteMenuRedFiltersEditBox:SetText(EmoteMenuSettings.RedFilter);
	-- Set Blue Emote filters
	EmoteMenuSettings.BlueFilter = f_AddCommaToString(EmoteMenuBlueFiltersEditBox:GetText());
	EmoteMenuBlueFiltersEditBox:SetText(EmoteMenuSettings.BlueFilter);
	-- Set Yellow Emote filters
	EmoteMenuSettings.YellowFilter = f_AddCommaToString(EmoteMenuYellowFiltersEditBox:GetText());
	EmoteMenuYellowFiltersEditBox:SetText(EmoteMenuSettings.YellowFilter);
	-- Refresh the menu
	EmoteMenu_LoadMenu();
	EmoteMenuOptionsCancelButton_OnClick();
end

function f_AddCommaToString(text)
	if (string.sub(text, string.len(text)) ~= ",") then
		text = text .. ",";
	end
	if (string.sub(text, 1) ~= ",") then
		text = "," .. text;
	end
	return string.lower(text);
end

