EMOTEMENU_VERSION = GetAddOnMetadata("EmoteMenu", "Version");

---------------------------------------------------------------------------------
-- Default settings
---------------------------------------------------------------------------------
local EMOTEMENU_DEFAULT_SCALE = 1.0;
local EMOTEMENU_DEFAULT_HPOS = 3;
local EMOTEMENU_DEFAULT_VPOS = 6;
local EMOTEMENU_DEFAULT_DIRECTION = 0;
local EMOTEMENU_DEFAULT_STAYOPEN = 0;
local EMOTEMENU_DEFAULT_TOOLTIPS = 1;
local EMOTEMENU_DEFAULT_TOOLTIPANCHOR = 1;
local EMOTEMENU_CLAMPED_TO_SCREEN = 1;

Color = {
Blue = { r = 0, g = 0, b = 1 },
Green = { r = 0, g = 1, b = 0 },
Red = { r = 1, g = 0, b = 0 },
White = { r = 1, g = 1, b = 1 },
Yellow = { r = 1, g = 1, b = 0 }
};

---------------------------------------------------------------------------------
-- Settings table
---------------------------------------------------------------------------------
EmoteMenuSettings = { };

---------------------------------------------------------------------------------
-- TooltipAnchors table
---------------------------------------------------------------------------------
local TooltipAnchors = { "ANCHOR_LEFT", "ANCHOR_RIGHT" };
local ButtonMaxWidth = 0;
---------------------------------------------------------------------------------
-- Events
---------------------------------------------------------------------------------
function EmoteMenu_OnEvent(event)
	if( event == "VARIABLES_LOADED" ) then
		-- Set the default variables
		if (not EmoteMenuSettings.Scale) then EmoteMenuSettings.Scale = EMOTEMENU_DEFAULT_SCALE end;
		if (not EmoteMenuSettings.HPos) then EmoteMenuSettings.HPos = EMOTEMENU_DEFAULT_HPOS end;
		if (not EmoteMenuSettings.VPos) then EmoteMenuSettings.VPos = EMOTEMENU_DEFAULT_VPOS end;
		if (not EmoteMenuSettings.Direction) then EmoteMenuSettings.Direction = EMOTEMENU_DEFAULT_DIRECTION end;
		if (not EmoteMenuSettings.StayOpen) then EmoteMenuSettings.StayOpen = EMOTEMENU_DEFAULT_STAYOPEN end;
		if (not EmoteMenuSettings.Tooltips) then EmoteMenuSettings.Tooltips = EMOTEMENU_DEFAULT_TOOLTIPS end;
		if (not EmoteMenuSettings.TooltipAnchor) then EmoteMenuSettings.TooltipAnchor = EMOTEMENU_DEFAULT_TOOLTIPANCHOR end;
		if (not EmoteMenuSettings.GreenFilter) then EmoteMenuSettings.GreenFilter = EMOTEMENU_FILTER_GREEN end;
		if (not EmoteMenuSettings.RedFilter) then EmoteMenuSettings.RedFilter = EMOTEMENU_FILTER_RED end;
		if (not EmoteMenuSettings.WhiteFilter) then EmoteMenuSettings.WhiteFilter = EMOTEMENU_FILTER_WHITE end;
		if (not EmoteMenuSettings.BlueFilter) then EmoteMenuSettings.BlueFilter = EMOTEMENU_FILTER_BLUE end;
		if (not EmoteMenuSettings.YellowFilter) then EmoteMenuSettings.YellowFilter = EMOTEMENU_FILTER_YELLOW end;
		if (not EmoteMenuSettings.ClampedToScreen) then EmoteMenuSettings.ClampedToScreen = EMOTEMENU_CLAMPED_TO_SCREEN end;

		-- Fill the menu with emotes and set the height
		EmoteMenu_LoadMenu();
		EmoteMenuFrame:SetWidth(ButtonMaxWidth+25);
		EmoteMenuFrame:SetAlpha(0);
		--EmoteMenuFrame:Hide();
		
		-- Set Clamped To Screen
		EmoteMenuTitleButton:SetClampedToScreen(EmoteMenuSettings.ClampedToScreen);
		--EmoteMenuTitleButton:SetFont("Fonts\\FRIZQT__.TTF", 16, "OUTLINE");
		--EmoteMenuTitleButton:SetText("|cFFFFDD00E|r");

		EmoteMenuFrame:SetClampedToScreen(EmoteMenuSettings.ClampedToScreen);
		tinsert(UISpecialFrames, "EmoteMenuFrame"); -- ESC closes the window
	end
end

---------------------------------------------------------------------------------
-- Start loading the Addon
---------------------------------------------------------------------------------
function EmoteMenu_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	local startmsg = "Shervin's EmoteMenu v" .. EMOTEMENU_VERSION .. " loaded.";
	UIErrorsFrame:AddMessage(startmsg, 1.0, 1.0, 0.0, 1.0, 5);
	DEFAULT_CHAT_FRAME:AddMessage(startmsg, 0.0, 0.0, 1.0);
end

---------------------------------------------------------------------------------
-- Start loading the Emote menu
---------------------------------------------------------------------------------
function EmoteMenu_LoadMenu()
	table.foreachi(EmoteList, function(id, command) EmoteMenu_LoadMenuItems(id, command); end);
	EmoteMenu_SetButtonWidth();
	EmoteMenuFrame:SetHeight(EmoteMenuButton_1:GetHeight() * table.getn(EmoteList) + EmoteMenuButton_0:GetHeight());
	EmoteMenuFrame_SetPoint(EmoteMenuSettings.Direction);
end

---------------------------------------------------------------------------------
-- Load the buttons
---------------------------------------------------------------------------------
function EmoteMenu_LoadMenuItems(id, command)
	local btn =  _G["EmoteMenuButton_"..id];
	if ( string.find(EmoteMenuSettings.GreenFilter, ","..string.lower(command[1])..",") ~= nil ) then
		btn:SetTextColor (Color.Green.r, Color.Green.g, Color.Green.b); -- Green
	elseif ( string.find(EmoteMenuSettings.RedFilter, ","..string.lower(command[1])..",") ~= nil ) then
		btn:SetTextColor (Color.Red.r, Color.Red.g, Color.Red.b); -- Red
	elseif ( string.find(EmoteMenuSettings.BlueFilter, ","..string.lower(command[1])..",") ~= nil ) then
		btn:SetTextColor (Color.Blue.r, Color.Blue.g, Color.Blue.b); -- Blue
	elseif ( string.find(EmoteMenuSettings.YellowFilter, ","..string.lower(command[1])..",") ~= nil ) then
		btn:SetTextColor (Color.Yellow.r, Color.Yellow.g, Color.Yellow.b); -- Yellow
	else
		btn:SetTextColor (Color.White.r, Color.White.g, Color.White.b); -- White
	end
	btn:SetText(command[1]);


-- Fix for the patch 1.11 ------------------------------
--btn:SetFont("Fonts\\FRIZQT__.TTF", 10);
-- Fix for the patch 1.11 ------------------------------

		-- Get the Button's FontString
		--local fs = btn:GetFontString();
		
		-- Set the FontString anchor
		--fs:SetPoint("LEFT", btn, "LEFT", 0, 0);

	btn:SetPoint("TOPLEFT", "EmoteMenuButton_"..id-1, "BOTTOMLEFT", 0, 0);
	local w = btn:GetTextWidth();
	if ( w > ButtonMaxWidth) then ButtonMaxWidth = w end
end

---------------------------------------------------------------------------------
-- Set the buttons width
---------------------------------------------------------------------------------
function EmoteMenu_SetButtonWidth()
	local btn;
	local btnhighlight;
	for id = 1, table.getn(EmoteList) do 
		btn =  _G["EmoteMenuButton_"..id];
		btnhighlight =  _G["EmoteMenuButton_"..id.."_HighlightTexture"];
		btn:SetWidth(ButtonMaxWidth+10);
		btnhighlight:SetWidth(ButtonMaxWidth+20);
	end
end

---------------------------------------------------------------------------------
-- Do the Emotes
---------------------------------------------------------------------------------
function EmoteMenuButton_OnClick()
	local editBox = DEFAULT_CHAT_FRAME.editBox;
	editBox:SetText(EmoteList[this:GetID()][2]);
	ChatEdit_SendText(editBox, false);
	--DEFAULT_CHAT_FRAME:AddMessage( editBox:GetText() );
end

---------------------------------------------------------------------------------
-- Open the menu
---------------------------------------------------------------------------------
function EmoteMenuTitleButton_OnClick(button)
	if ( button == "LeftButton" and ( not IsShiftKeyDown() ) ) then
		if ( EmoteMenuFrame:IsShown() ) then
			EmoteMenuFrame:Hide();
			EmoteMenuFrame:SetAlpha(0);
		else
			EmoteMenuFrame_OnShow();
			GameTooltip:Hide();
		end
		--[[
	elseif ( button == "RightButton" ) then
		EmoteMenuOptionsFrame:Show();
		if ( EmoteMenuOptionsFrame:IsShown() ) then
			EmoteMenuOptionsFrame:Hide();
		else
			EmoteMenuOptionsFrame:Show();
		end
		]]--
	end
end

---------------------------------------------------------------------------------
-- Set the position of the main menu
---------------------------------------------------------------------------------
function EmoteMenuFrame_SetPoint(direction)
	EmoteMenuFrame:ClearAllPoints();
	if (direction == 1) then
		EmoteMenuFrame:SetPoint("BOTTOM", "EmoteMenuTitleButton", "TOP", EmoteMenuSettings.HPos, -EmoteMenuSettings.VPos);
	elseif (direction == 0) then
		EmoteMenuFrame:SetPoint("TOP", "EmoteMenuTitleButton", "BOTTOM", EmoteMenuSettings.HPos, EmoteMenuSettings.VPos);
	end
end


---------------------------------------------------------------------------------
-- Set the scale of the main menu
---------------------------------------------------------------------------------
function EmoteMenuFrame_SetScale()
	EmoteMenuFrame:SetScale(EmoteMenuSettings.Scale);
end

---------------------------------------------------------------------------------
-- On Show
---------------------------------------------------------------------------------
function EmoteMenuFrame_OnShow()
	EmoteMenuFrame:Show();
	EmoteMenuFrame_SetScale();
	EmoteMenuFrame_Fade(EmoteMenuFrame, 'IN', 0.3, EmoteMenuFrame:GetAlpha(), 1.0);
end

---------------------------------------------------------------------------------
-- Hide the main menu
---------------------------------------------------------------------------------
function EmoteMenuFrame_OnLeave(force)
	if ( (EmoteMenuSettings.StayOpen ~= 1) or (force == 1) ) then
		EmoteMenuFrame_Fade(EmoteMenuFrame, 'OUT', 1.0, EmoteMenuFrame:GetAlpha(), 0.0);
	end
end


---------------------------------------------------------------------------------
-- General Tooltips function
---------------------------------------------------------------------------------
function EmoteMenu_ShowTooltip(title, body)
	if (EmoteMenuSettings.Tooltips == 0) then return end;
	GameTooltip:SetOwner(this, TooltipAnchors[EmoteMenuSettings.TooltipAnchor]);
	GameTooltip:SetText(title, 1.0, 0.8, 0.0, 1, 1);
	GameTooltip:AddLine(body, 1.0, 1.0, 1.0, 1, 1);
	GameTooltip:Show();
end

---------------------------------------------------------------------------------
-- Button Tooltips function
---------------------------------------------------------------------------------
function EmoteMenu_ShowButtonTooltip(title)
	if (not EmoteMenuTooltips) then return end;
	local id = this:GetID();
	local text1 = EmoteMenuTooltips[id][1];
	local text2 = EmoteMenuTooltips[id][2];
	local text3 = EmoteMenuTooltips[id][3];
	if ( text2 == "" ) then
		text2 = EmoteList[id][2];
	end
	if ( string.len(text1 .. text2 .. text3) > 0 ) then
		EmoteMenu_ShowTooltip(title .. " " .. text3, text1 .. "\n" .. text2 );
	end
end

---------------------------------------------------------------------------------
-- Fade Function
---------------------------------------------------------------------------------
function EmoteMenuFrame_Fade(frame, mode, timeToFade, startAlpha, endAlpha)
	local fade = {};
	fade.mode = mode;
	fade.timeToFade = timeToFade;
	fade.startAlpha = startAlpha;
	fade.endAlpha = endAlpha;
	if (string.lower(mode) == 'out') then
		fade.finishedFunc = function() frame:Hide(); end;
	end
	UIFrameFade(frame, fade);
end

---------------------------------------------------------------------------------
-- Debug Function
---------------------------------------------------------------------------------
function EmoteMenu_Debug(title)
	local r = 1.0;
	local g = 0.7;
	local b = 0.5;
	DEFAULT_CHAT_FRAME:AddMessage("\n<<================ EmoteMenu Debug  ["..title.."]  ================\n\n", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("Scale <"..EmoteMenuSettings.Scale..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("HPos <"..EmoteMenuSettings.HPos..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("VPos <"..EmoteMenuSettings.VPos..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("Direction <"..EmoteMenuSettings.Direction..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("StayOpen <"..EmoteMenuSettings.StayOpen..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("Tooltips <"..EmoteMenuSettings.Tooltips..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("TooltipAnchor <"..EmoteMenuSettings.TooltipAnchor..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("GoodEmotes <"..EmoteMenuSettings.GoodEmotes..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("BadEmotes <"..EmoteMenuSettings.BadEmotes..">", r, g, b);
	DEFAULT_CHAT_FRAME:AddMessage("\n================ EmoteMenu Debug  ["..title.."]  ================>>\n\n", r, g, b);
	--DEFAULT_CHAT_FRAME:AddMessage("EmoteMenu_OnLoad");
	--DEFAULT_CHAT_FRAME:AddMessage("VARIABLES_LOADED");
end

