--[[
--
--	ElementalFlux
--	by Dust of Turalyon
--
--]]

ElementalFlux_Version = GetAddOnMetadata("ElementalFlux", "Version");

ElementalFlux_Settings_Defaults = {
	["Show"]	= true;
	["CastBar"]	= true;
	["Scale"]	= 1.00;
	["Alpha"]	= 1.00;
	["Format"]	= "%02.1f";
	["Version"]	= ElementalFlux_Version;

}

ElementalFlux_OnLoad = function (self)
	--Slash command
	SlashCmdList["ELEMENTALFLUX"] = ElementalFlux_SlashHandler;
	SLASH_ELEMENTALFLUX1 = "/elementalflux";
	SLASH_ELEMENTALFLUX2 = "/ef";

	--Events
	ElementalFlux_MainFrame:RegisterEvent("VARIABLES_LOADED");
	ElementalFlux_MainFrame:RegisterEvent("PLAYER_LOGIN");
	ElementalFlux_OnLoad = nil;
end;

ElementalFlux_OnEvent = function (self, event, ...)
	local arg1 = select(1, ...);
	if (event == "UNIT_PET") then
		if arg1 == "player" then
			if not UnitExists("pet") then
				ElementalFlux_Death();
			else
				ElementalFlux_Summoned();
			end;
		end;
	elseif (event == "UNIT_SPELLCAST_START") and (arg1 == "pet") then
		local spell, rank, displayName, icon, startTime, endTime, isTradeSkill = UnitCastingInfo(arg1);
		ElementalFlux_UpdateCastState(displayName, startTime, endTime);
		-- Start cast animation
	elseif (event == "UNIT_SPELLCAST_DELAYED") and (arg1 == "pet") then
		local spell, rank, displayName, icon, startTime, endTime, isTradeSkill = UnitCastingInfo(arg1);
		ElementalFlux_UpdateCastState(displayName, startTime, endTime);
		-- Update cast animation
	elseif ((event == "UNIT_SPELLCAST_STOP") or (event == "UNIT_SPELLCAST_FAILED")
		or (event == "UNIT_SPELLCAST_INTERRUPTED")) and (arg1 == "pet") then
		ElementalFlux_UpdateCastState(nil, 0, 0);
		-- Stop cast animation
	elseif (event == "VARIABLES_LOADED") then
		if (ElementalFlux_Settings == nil) or (ElementalFlux_Settings["Version"] ~= ElementalFlux_Version) then
			ElementalFlux_MSG("EF: ElementalFlux settings reset");
			ElementalFlux_Settings = ElementalFlux_Settings_Defaults;
		end;

		--Layout
		ElementalFlux_OutputFrame:SetScale(ElementalFlux_Settings["Scale"]);
		ElementalFlux_OutputFrame:SetAlpha(ElementalFlux_Settings["Alpha"]);
		ElementalFlux_OutputFrame:SetClampedToScreen("TRUE");
	elseif (event == "PLAYER_LOGIN") then
		local l, g = UnitClass("player");
		if (g == "MAGE") then
			-- enable for mages
			ElementalFlux_MainFrame:RegisterEvent("UNIT_PET");
			ElementalFlux_MainFrame:RegisterEvent("UNIT_SPELLCAST_START");
			ElementalFlux_MainFrame:RegisterEvent("UNIT_SPELLCAST_STOP");
			ElementalFlux_MainFrame:RegisterEvent("UNIT_SPELLCAST_FAILED");
			ElementalFlux_MainFrame:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
			--ElementalFlux_MainFrame:RegisterEvent("UNIT_SPELLCAST_DELAYED");
		end;
	end;
end;

ElementalFlux_Running	= false;
ElementalFlux_LifeTime	= 0;
--ElementalFlux_NextWarning = 0;
ElementalFlux_CastStart	= 0;	-- start time
ElementalFlux_CastEnd	= 0;	-- end time
ElementalFlux_CastName	= nil;	-- <name> or nil

ElementalFlux_Summoned = function ()
	if not ElementalFlux_Running then
		-- Not needed due to RegisterUnitWatch(x)
		--if ElementalFlux_Settings["Show"] then
			--ElementalFlux_OutputFrame:Show();
		--else
			--ElementalFlux_OutputFrame:Hide();
		--end;
		ElementalFlux_MainFrame:SetScript("OnUpdate", ElementalFlux_OnUpdate);
		ElementalFlux_Running = true;
	end;
	local toc = select(4, GetBuildInfo()); -- version, build, date, toc
	local currRank; -- nameTalent, icon, tier, column, currRank, maxRank
	if toc == 20400 then
		-- Get the Talent info
		currRank = select(5, GetTalentInfo(3,22));
		ElementalFlux_LifeTime = 45*currRank;
	elseif toc == 30000 then
		-- Water Elemental
		currRank = select(5, GetTalentInfo(3,25));
		ElementalFlux_LifeTime = 45*currRank;
		-- Imp. Water Elemental
		currRank = select(5, GetTalentInfo(3,26));
		ElementalFlux_LifeTime = ElementalFlux_LifeTime + 5*currRank;
	end;
end;

ElementalFlux_Death = function ()
	if ElementalFlux_Running then
		--ElementalFlux_OutputFrame:Hide();
		ElementalFlux_MainFrame:SetScript("OnUpdate", nil);
		ElementalFlux_Running = false;
	end;
end;

ElementalFlux_UpdateCastState = function (spellName, startTime, endTime)
	ElementalFlux_CastName	= spellName;	-- <name> or nil
	ElementalFlux_CastStart	= startTime;	-- start time
	ElementalFlux_CastEnd	= endTime;	-- end time
	ElementalFlux_OutputFrame_Bar:SetMinMaxValues(0, (endTime-startTime)/1000);
	ElementalFlux_OutputFrame_Bar:SetValue(0);
end;

ElementalFlux_Passed = 0;
ElementalFlux_OnUpdate = function (self, elapsed)
	ElementalFlux_Passed = ElementalFlux_Passed + elapsed;
	if ElementalFlux_Passed > 0.1 then
		ElementalFlux_LifeTime = ElementalFlux_LifeTime - ElementalFlux_Passed;
		ElementalFlux_Passed = 0;
		ElementalFlux_OutputFrame_Text:SetText(string.format(ElementalFlux_Settings["Format"], ElementalFlux_LifeTime));
		--[[
		if ElementalFlux_LifeTime < ElementalFlux_NextWarning then
			ElementalFlux_NextWarning = ElementalFlux_GetNextWarning(ElementalFlux_LifeTime);
		end;]]
	end;
	if ElementalFlux_Settings["CastBar"] and ElementalFlux_CastName ~= nil then
		local now = GetTime();
		local duration = (ElementalFlux_CastEnd - ElementalFlux_CastStart) / 1000;
		local passed = now - (ElementalFlux_CastStart / 1000);
		ElementalFlux_OutputFrame_Bar:SetValue(passed);
	end;
end;

--[[
ElementalFlux_GetNextWarning = function (time)
	--return math.ceil(time/ElementalFlux_Settings["Interval"])*ElementalFlux_Settings["Interval"];
	return 0;
end;
]]

ElementalFlux_ToggleShown = function (state)
	ElementalFlux_TogglePref("Show", state);
	if ElementalFlux_Settings["Show"] then
		ElementalFlux_OutputFrame:Show();
	else
		ElementalFlux_OutputFrame:Hide();
	end;
end;

ElementalFlux_TogglePref = function (setting, state)
	if state == "off" or state == "false" then
		ElementalFlux_Settings[setting] = false;
		ElementalFlux_MSG("ElementalFlux: "..setting.." Disabled");
	elseif state == "on" or state == "true" then
		ElementalFlux_Settings[setting] = true;
		ElementalFlux_MSG("ElementalFlux: "..setting.." Enabled");
	else
		if ElementalFlux_Settings[setting] then
			ElementalFlux_Settings[setting] = false;
			ElementalFlux_MSG("ElementalFlux: "..setting.." Disabled");
		else
			ElementalFlux_Settings[setting] = true;
			ElementalFlux_MSG("ElementalFlux: "..setting.." Enabled");
		end;
	end;
end;

ElementalFlux_SetPrefNum = function (setting, value)
	local valueNum = tonumber(value);
	if valueNum == nil then
		ElementalFlux_MSG("ElementalFlux: "..setting.." Input Error, "..value.." is not a number");
	else
		ElementalFlux_Settings[setting] = valueNum;
		ElementalFlux_MSG("ElementalFlux: "..setting.." set to "..valueNum);
	end;
end;

ElementalFlux_SetPrefString = function (setting, str)
	ElementalFlux_Settings[setting] = str;
	ElementalFlux_MSG("ElementalFlux: "..setting.." set to "..str);
end;

ElementalFlux_SlashHandler = function (msg)
	local Cmd, SubCmd = ElementalFlux_GetCmd(msg);
	Cmd = string.lower(Cmd);
	if (Cmd == "scale") then
		ElementalFlux_SetPrefNum("Scale", SubCmd);
		ElementalFlux_OutputFrame:SetScale(ElementalFlux_Settings["Scale"]);
	elseif (Cmd == "alpha") then
		ElementalFlux_SetPrefNum("Alpha", SubCmd);
		ElementalFlux_OutputFrame:SetAlpha(ElementalFlux_Settings["Alpha"]);
	elseif (Cmd == "format") then
		ElementalFlux_SetPrefString("Format", SubCmd);
	elseif (Cmd == "castbar") then
		ElementalFlux_TogglePref("CastBar", SubCmd);
	elseif (Cmd == "unlock") then
		UnregisterUnitWatch(ElementalFlux_OutputFrame);
		ElementalFlux_OutputFrame:Show();
	elseif (Cmd == "lock") then
		RegisterUnitWatch(ElementalFlux_OutputFrame);
		if not ElementalFlux_Running then
			ElementalFlux_OutputFrame:Hide();
		end;
	elseif (Cmd == "resetpos") then
		ElementalFlux_OutputFrame:ClearAllPoints();
		ElementalFlux_OutputFrame:SetPoint("CENTER");
		ElementalFlux_OutputFrame:SetWidth(36);
		ElementalFlux_OutputFrame:SetHeight(24);
	else
		ElementalFlux_MSG("|cffff0000ElementalFlux Input Error");
		ElementalFlux_MSG("Shift Click to Move, Alt Click to resize");
		--ElementalFlux_MSG("/ef show [yes|no]");
		ElementalFlux_MSG("/ef scale <num>");
		ElementalFlux_MSG("/ef alpha <num>");
		ElementalFlux_MSG("/ef format <format> (default: %02.1f)");
		ElementalFlux_MSG("/ef castbar [yes|no]");
		ElementalFlux_MSG("/ef unlock");
		ElementalFlux_MSG("/ef lock");
		ElementalFlux_MSG("/ef resetpos");
	end;
end;

ElementalFlux_MSG = function (msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end;

-- Some CMD parsing code, written by Tigerheart on http://www.wowwiki.com/HOWTO:_Extract_Info_from_a_Slash_Command
ElementalFlux_GetCmd = function (msg)
	if msg then
		local a,b,c=strfind(msg, "(%S+)"); --contiguous string of non-space characters
		if a then
			return c, strsub(msg, b+2);
		else
			return "";
		end
	end
end;

ElementalFlux_GetArgument = function (msg)
	if msg then
		local a,b=strfind(msg, "=");
		if a then
			return strsub(msg,1,a-1), strsub(msg, b+1);
		else
			return "";
		end
	end
end;
