--[[
--
--  EkCTRA_RaidStatus 1.07
--
--  Refer to index.html for documentation and complete change history.
--
--  Author: Dargen of Eternal Keggers, Terenas.
--          http://www.eternalkeggers.net
--
--  Addons: http://www.wowinterface.com/portal.php?uid=25131
--          http://my.curse.com/dargen/projects/
--
--]]

-- ----------
-- Variables which get saved.
-- ----------
EkCTRA_RaidStatus_Status = 1;  -- Raid status window enhancements: 0 == disabled, 1 == enabled.
EkCTRA_RaidStatus_Meters = {};  -- User configuration settings array for additional items for raid status window.

-- ----------
-- Variables which are not saved.
-- ----------
EkCTRA_RaidStatus_cVersion = "1.07";

EkCTRA_RaidStatus_Slash1 = "/ekctrars"
EkCTRA_RaidStatus_Slash2 = "/ekctra_raidstatus"
EkCTRA_RaidStatus_Slash3 = "/ekctraraidstatus"

EkCTRA_RaidStatus_CT_RAMeters_UpdateWindow = nil;  -- Used to save original function.
EkCTRA_RaidStatus_CT_RAMeters_InitDropDown = nil;  -- Used to save original function.

EkCTRA_RaidStatus_InWorld = nil;
EkCTRA_RaidStatus_Test = nil; -- nil=Not test mode, 1=Test mode

-- EkCheck configuration for this addon.
EkCTRA_RaidStatus_EkCheck_Config = {
	addonName = "EkCTRA_RaidStatus",
	funcPrefix = "EkCTRA_RaidStatus_EkCheck_",
	defaultColumn = 11,
	columns = {
		{ heading=EkCTRA_RaidStatus_TEXT_EkCheck_Version, width=60, show=11, sort=11, order="A", justify="CENTER", red=nil, green=nil, blue=nil },
	},
};

-- Constants
EkCTRA_RaidStatus_Meters_PVP = "Ek_PVP_Count";  -- EkCTRA_RaidStatus_Meters subscript for the "PVP count" option.
EkCTRA_RaidStatus_Meters_Total = "Ek_Total_Count";  -- EkCTRA_RaidStatus_Meters subscript for the "Total count" option.


-- ------------------------------------------------------------
-- Command line functions.
-- ------------------------------------------------------------


function EkCTRA_RaidStatus_Command(msg)
	-- ----------
	-- Examine command line.
	-- ----------
	local pos1, pos2, cmd, rest = string.find(msg, "^%s-(%S+)(.*)");

	local command = "";
	if (cmd) then
		command = string.lower(cmd);
	else
		cmd = "";
	end

	if (command == EkCTRA_RaidStatus_TEXT_Command_Help or command == "?" or command == "") then
		EkCTRA_RaidStatus_Command_Help();

	elseif (command == EkCTRA_RaidStatus_TEXT_Command_Status) then
		EkCTRA_RaidStatus_Command_Status();

	elseif (command == EkCTRA_RaidStatus_TEXT_Command_Enable) then
		EkCTRA_RaidStatus_Command_Enable();

	elseif (command == EkCTRA_RaidStatus_TEXT_Command_Disable) then
		EkCTRA_RaidStatus_Command_Disable();

	elseif (command == "_test") then
		EkCTRA_RaidStatus_Command_Test();

	else
		-- Invalid command.
		EkCTRA_RaidStatus_InvalidCommand()
	end
end


function EkCTRA_RaidStatus_Print(text)
	-- ----------
	-- Print
	-- ----------
	EkCTRA_RaidStatus_Print2("<EkCTRA_RaidStatus> " .. text);
end


function EkCTRA_RaidStatus_Print2(msg)
	-- ----------------
	-- Print a message.
	-- ----------------
	DEFAULT_CHAT_FRAME:AddMessage(msg);
	return;
end


function EkCTRA_RaidStatus_Command_Help()
	-- ----------
	-- Help command.
	-- ----------
	local slash = EkCTRA_RaidStatus_Slash1 .. " ";
	EkCTRA_RaidStatus_Print2(" ");
	EkCTRA_RaidStatus_Print2("EkCTRA_RaidStatus " .. EkCTRA_RaidStatus_cVersion .. " by Dargen, Eternal Keggers, Terenas.");
	EkCTRA_RaidStatus_Print2(" ");
	EkCTRA_RaidStatus_Print2(slash .. "[" .. EkCTRA_RaidStatus_TEXT_Command_Help .. "] -- " .. EkCTRA_RaidStatus_TEXT_Help_Help);
	EkCTRA_RaidStatus_Print2(slash .. EkCTRA_RaidStatus_TEXT_Command_Status .. " -- " .. EkCTRA_RaidStatus_TEXT_Help_Status);
	EkCTRA_RaidStatus_Print2(slash .. EkCTRA_RaidStatus_TEXT_Command_Enable .. " -- " .. EkCTRA_RaidStatus_TEXT_Help_Enable);
	EkCTRA_RaidStatus_Print2(slash .. EkCTRA_RaidStatus_TEXT_Command_Disable .. " -- " .. EkCTRA_RaidStatus_TEXT_Help_Disable);
	EkCTRA_RaidStatus_Print2(" ");
	EkCTRA_RaidStatus_Print2(EkCTRA_RaidStatus_TEXT_Help_RightClick);
end


function EkCTRA_RaidStatus_Command_Version()
	-- ----------
	-- Version command.
	-- ----------
	EkCTRA_RaidStatus_Print(EkCTRA_RaidStatus_cVersion);
end


function EkCTRA_RaidStatus_Command_Status()
	-- ----------
	-- Status command.
	-- ----------
	EkCTRA_RaidStatus_isCTRA(1);
	EkCTRA_RaidStatus_ShowStatus();
end


function EkCTRA_RaidStatus_Command_Enable()
	-- ----------
	-- Enable command.
	-- ----------
	EkCTRA_RaidStatus_Status = 1;
	EkCTRA_RaidStatus_ShowStatus();
end


function EkCTRA_RaidStatus_Command_Disable()
	-- ----------
	-- Disable command.
	-- ----------
	EkCTRA_RaidStatus_Status = 0;
	EkCTRA_RaidStatus_ShowStatus();
end


function EkCTRA_RaidStatus_Command_Test()
	-- ----------
	-- Test command.
	-- ----------
	if (EkCTRA_RaidStatus_Test) then
		EkCTRA_RaidStatus_Test = nil;
		EkCTRA_RaidStatus_Print("Test mode disabled.");
	else
		EkCTRA_RaidStatus_Test = 1;
		EkCTRA_RaidStatus_Print("Test mode enabled.");
	end
end


function EkCTRA_RaidStatus_InvalidCommand()
	-- --------------
	-- Invalid command message.
	-- --------------
	EkCTRA_RaidStatus_Print(EkCTRA_RaidStatus_TEXT_InvalidCommand .. " " .. EkCTRA_RaidStatus_Slash1 .. " " .. EkCTRA_RaidStatus_TEXT_Command_Help);
end


-- ------------------------------------------------------------
-- Status functions.
-- ------------------------------------------------------------


function EkCTRA_RaidStatus_ShowStatus()
	-- ----------
	-- Show status.
	-- ----------
	if (EkCTRA_RaidStatus_Status == 0) then
		EkCTRA_RaidStatus_Print(EkCTRA_RaidStatus_TEXT_IsDisabled);
	else
		EkCTRA_RaidStatus_Print(EkCTRA_RaidStatus_TEXT_IsEnabled);
	end
end


-- ------------------------------------------------------------
-- Initialization functions.
-- ------------------------------------------------------------


function EkCTRA_RaidStatus_isCTRA(showErr)
	-- ----------
	-- Test if CT_RaidAssist is present and compatible.
	-- ----------
	if (CT_RAMetersFrame 
		and CT_RAMetersFrameText 
		and CT_RAMetersFrameDropDown 
		and CT_RAMeters_UpdateWindow 
		and CT_RAMeters_InitDropDown
		) then

		return true;
	end
	if (showErr) then
	        -- "CT_RaidAssist not detected/incompatible."
	        EkCTRA_RaidStatus_Print(EkCTRA_RaidStatus_TEXT_CTRaid_Fail);
	end
        return false;
end


function EkCTRA_RaidStatus_OnLoad()
	-- ----------
	-- Loading addon.
	-- ----------
	SLASH_ekctrars1 = EkCTRA_RaidStatus_Slash1;
	SLASH_ekctrars2 = EkCTRA_RaidStatus_Slash2;
	SLASH_ekctrars3 = EkCTRA_RaidStatus_Slash3;
	SlashCmdList["ekctrars"] = function( msg )
		EkCTRA_RaidStatus_Command(msg);
	end

	EkCTRA_RaidStatus_Frame:RegisterEvent("PLAYER_LOGIN");
end


function EkCTRA_RaidStatus_OnEvent(event)
	-- ----------
	-- Handle events.
	-- ----------
	if (event == "PLAYER_LOGIN") then
		if (not EkCTRA_RaidStatus_InWorld) then
			EkCTRA_RaidStatus_InWorld = 1;

			-- Raid status window enhancements.
			if (EkCTRA_RaidStatus_isCTRA()) then
				EkCTRA_RaidStatus_Init();
			end

			if (EkCheck_RegisterAddon) then
				EkCheck_RegisterAddon(EkCTRA_RaidStatus_EkCheck_Config);
			end
		end
	end
end


function EkCTRA_RaidStatus_Init()
	-- ----------
	-- Hook some CT_RaidAssist functions.
	-- ----------
	EkCTRA_RaidStatus_CT_RAMeters_UpdateWindow = CT_RAMeters_UpdateWindow;
	CT_RAMeters_UpdateWindow = EkCTRA_RaidStatus_UpdateWindow;

	EkCTRA_RaidStatus_CT_RAMeters_InitDropDown = CT_RAMeters_InitDropDown;
	CT_RAMeters_InitDropDown = EkCTRA_RaidStatus_InitDropDown;

	-- Initialize raid status drop down menu.
	EkCTRA_RaidStatus_InitMenu();
end


-- --------
-- EkCheck interface routines
-- --------

function EkCTRA_RaidStatus_EkCheck_CreateTooltipText(index, total, data)
	-- ----------
	-- User moved pointer over a line in the list.
	--
	-- index -- position of the item in the list
	-- total -- number of items in the list
	-- data -- Array of data
	--
	-- 	data[]
	-- 	---------------
	-- 	[1] == EkCheck: Player name
	-- 	[2] == EkCheck: Uppercase english class string (ie. non-localized) (eg. "PRIEST")
	-- 	[3] == EkCheck: 0==Addon not loaded, 1==Addon loaded.
	-- 	[4] == EkCheck: 0==Player has not responded to the check, 1==Player has responded to the check.
	-- 	[5] == EkCheck: Player class (localized)
	-- 	[6] to [10] == EkCheck: Reserved
	--
	-- 	[11] == EkCTRA_RaidStatus: Version string
	--
	-- Returns:
	--	a) nil -- if no tooltip should be generated.
	--	b) String containing text to appear in the tooltip.
	-- ----------
--	local text;
--	local white = "|c00FFFFFF";
--	return text;

	return nil;
end

function EkCTRA_RaidStatus_EkCheck_CreateResponse(data)
	-- ----------------
	-- Create addon specific portion of response string.
	--
	-- data -- Array of data provided by EkCheck.
	--
	-- 	data[]
	-- 	--------
	-- 	[1] == Name of the player that initiated the check.
	-- 	[2] == Name of the addon being checked for.
	--
	-- Returns:
	-- 	a) nil or "" == No addon specific response string.
	--	b) Addon specific response string.
	-- ----------------
	local resp;

	-- Version
	resp = "v" .. EkCTRA_RaidStatus_cVersion;

	-- Return the response string.
	return resp;
end

function EkCTRA_RaidStatus_EkCheck_ParseResponse(text, data)
	-- ----------------
	-- Parse response text.
	--
	-- text -- The addon specific portion of the response.
	-- data -- Array of data provided by EkCheck.
	--
	-- 	data[]
	-- 	---------------
	-- 	[1] == Player name
	-- 	[2] == Uppercase english class string (ie. non-localized) (eg. "PRIEST")
	-- 	[3] == 0==Addon not loaded, 1==Addon loaded.
	-- 	[4] == 0==Player has not responded to the check, 1==Player has responded to the check.
	-- 	[5] == Player class (localized)
	--
	-- Returns:
	--	a) nil -- Invalid response
	--      b) Array containing addon specific data (to be used for the check window, tooltip, etc).
	-- ----------------
	local msg;
	local version;

	version = "?";

	msg = strlower(text);

	for k, v in string.gmatch(msg, "(%a)(%S+)") do
		if (k == "v") then
			version = v;
		end
	end

	return { version };
end

-- ------------------------------------------------------------
-- Operating functions.
-- ------------------------------------------------------------


function EkCTRA_RaidStatus_InitMenu()
	-- ----------
	-- Used to intialize the raid status window drop down menu.
	-- ----------

	if (CT_RAMetersFrameDropDown and CT_RAMeters_InitDropDown) then
		-- Initialize raid status window drop down menu.
		UIDropDownMenu_Initialize(CT_RAMetersFrameDropDown, CT_RAMeters_InitDropDown, "MENU");
	end

	if (CT_RAMeters_UpdateWindow) then
		CT_RAMeters_UpdateWindow();
	end
end

function EkCTRA_RaidStatus_InitDropDown()
	-- ----------
	-- Used to intialize the buttons on the raid status window drop down menu.
	--
	-- This function calls the original function, and then adds
	-- new menu items.
	-- ----------

	-- Call original function to do the initial intialization.
	EkCTRA_RaidStatus_CT_RAMeters_InitDropDown();

	-- Make sure we can/want to add the menu items.
	if ( UIDROPDOWNMENU_MENU_LEVEL ~= 1 ) then
		return;
	end
	if (EkCTRA_RaidStatus_Status == 0) then
		return;
	end
	if (not CT_RAMetersFrameDropDown) then
		return;
	end

	-- Now add our own menu items to the end of the menu.
	local dropdown, info;
--	if ( UIDROPDOWNMENU_OPEN_MENU ) then
--		dropdown = getglobal(UIDROPDOWNMENU_OPEN_MENU);
--	else
		dropdown = getglobal("CT_RAMetersFrameDropDown");
--	end

--[[
	-- Add blank separator item
	info = {};
	info.disabled = 1;
	UIDropDownMenu_AddButton(info);
]]

	-- Add the pvp count menu item.
	info = { };
	info.text = EkCTRA_RaidStatus_TEXT_PVP_MENU_ITEM;  -- "PVP Count"
	info.value = EkCTRA_RaidStatus_Meters_PVP;
	info.checked = EkCTRA_RaidStatus_Meters[info.value];
	info.keepShownOnClick = 1;
	info.func = EkCTRA_RaidStatus_DropDown_OnClick;
	UIDropDownMenu_AddButton(info);

	-- Add the total count menu item.
	info = { };
	info.text = EkCTRA_RaidStatus_TEXT_TOTAL_MENU_ITEM;  -- "Total Count"
	info.value = EkCTRA_RaidStatus_Meters_Total;
	info.checked = EkCTRA_RaidStatus_Meters[info.value];
	info.keepShownOnClick = 1;
	info.func = EkCTRA_RaidStatus_DropDown_OnClick;
	UIDropDownMenu_AddButton(info);
end

function EkCTRA_RaidStatus_DropDown_OnClick()
	-- ----------
	-- Custom version of CT_RAMeters_DropDown_OnClick() from
	-- CT_RAMeters.lua.
	--
	-- The menu items added by CT_RaidAssist continue to use 
	-- the CT_RAMeters_DropDown_OnClick() function.
	--
	-- This function handles the user clicking on the new menu items.
	-- ----------
	if (this.value == EkCTRA_RaidStatus_Meters_PVP) then
		if (not EkCTRA_RaidStatus_Meters) then
			EkCTRA_RaidStatus_Meters = {};
		end
		if (EkCTRA_RaidStatus_Meters[this.value]) then
			EkCTRA_RaidStatus_Meters[this.value] = nil;
		else
			EkCTRA_RaidStatus_Meters[this.value] = 1;
		end
		if (CT_RAMeters_UpdateWindow) then
			CT_RAMeters_UpdateWindow();
		end
	elseif (this.value == EkCTRA_RaidStatus_Meters_Total) then
		if (not EkCTRA_RaidStatus_Meters) then
			EkCTRA_RaidStatus_Meters = {};
		end
		if (EkCTRA_RaidStatus_Meters[this.value]) then
			EkCTRA_RaidStatus_Meters[this.value] = nil;
		else
			EkCTRA_RaidStatus_Meters[this.value] = 1;
		end
		if (CT_RAMeters_UpdateWindow) then
			CT_RAMeters_UpdateWindow();
		end
	end
end

function EkCTRA_RaidStatus_UpdateWindow()
	-- ----------
	-- Hooked version of CT_RAMeters_UpdateWindow() from CT_RAMeters.lua.
	--
	-- This adds a pvp count, and a total count.
	-- ----------

	-- call original function.
	EkCTRA_RaidStatus_CT_RAMeters_UpdateWindow();

	if (EkCTRA_RaidStatus_Status == 0) then
		return;
	end

	if (not EkCTRA_RaidStatus_Meters) then
		return;
	end

	if (not EkCTRA_RaidStatus_Test) then
		if (GetNumRaidMembers() == 0) then
			return;
		end
	end

	-- Get all the stats
	local stats = {
		["pvpCount"] = { "", 1 },  -- [1]=string to display in menu, [2]=Number of lines required for string.
		["totCount"] = { "", 1 },  -- [1]=string to display in menu, [2]=Number of lines required for string.
	};

	local isPVP = 0;
	for i = 1, GetNumRaidMembers(), 1 do
		local id = "raid" .. i;
		if ( UnitIsConnected(id) ) then
			if (UnitIsPVP(id) or UnitIsPVPFreeForAll(id)) then
				isPVP = isPVP + 1;
			end
		end
	end

	local count = 0;
	if (EkCTRA_RaidStatus_Meters[EkCTRA_RaidStatus_Meters_PVP]) then
		stats["pvpCount"][1] = EkCTRA_RaidStatus_TEXT_PVP_STATUS .. ": " .. isPVP;   -- "PVP Count: 99"
		count = count + 1;
	end
	if (EkCTRA_RaidStatus_Meters[EkCTRA_RaidStatus_Meters_Total]) then
		stats["totCount"][1] = EkCTRA_RaidStatus_TEXT_TOTAL_STATUS .. ": " .. GetNumRaidMembers();   -- "Total Count: 99"
		count = count + 1;
	end

	local out = CT_RAMetersFrameText:GetText();
	local numLines = 0;

	-- Count the number of lines currently in the window.
	out, numLines = string.gsub(out, "\n", "\n");

	numLines = numLines + 1;  -- Last line has no \n after it.

	-- The string tested for here comes from CT_RaidAssist. It is not a localized string.
	if (out == "No stats to track") then
		out = "";
		numLines = 0;
	end

	if (count > 0) then
		-- Add together all the stats
		local order = {
			{ "pvpCount", "|c00EEEEEE", "|r" },
			{ "totCount", "|c00DDDDDD", "|r" },
		};

		-- Build/add to the text string for the window.
		for i = 1, getn(order), 1 do
			local val = stats[order[i][1]];
			if ( strlen(val[1]) > 0 ) then
				if ( strlen(out) > 0 ) then
					out = out .. "\n";
				end
				out = out .. order[i][2] .. val[1] .. order[i][3];
				numLines = numLines + val[2];
			end
		end
	end
	if ( out == "" ) then
		numLines = 1;
		-- "No stats to track"
		CT_RAMetersFrameText:SetText(EkCTRA_RaidStatus_TEXT_NO_STATS);
	else
		CT_RAMetersFrameText:SetText(out);
	end
	local width = CT_RAMetersFrameText:GetStringWidth();
	if ( width < 109 ) then
		width = 109;
	end
	CT_RAMetersFrame:SetWidth(width+16);
	CT_RAMetersFrame:SetHeight(25+(numLines*16));
end

