-- v3.0 Modified by Tekaru <Becomes Enraged> The Venture Co US
-- Adds the Unlock button to the trade window. You must click this button, then the locked box to unlock it.
-- I found this easier than adding the unlock button to your toolbar or looking through your spellbook for Pick Lock.

-- v2.0 Modified by Zek <Blood Cult> Bloodhoof-EU

-- Orignal EasyUnlock add on created by Athaeus (J. de Gram)


function EasyUnlock_OnLoad()
    local _, class = UnitClass("player")
    if(class == "ROGUE" and EasyUnlock_GetLockpickingLevel() and not EasyUnlock:IsShown()) then
        -- Unhide frame
        EasyUnlock:Show()

        -- Squeeze the 'trade' and 'cancel' buttons in TradeFrame so we can fit in our own button
        TradeFrameTradeButton:SetWidth(56)
        TradeFrameCancelButton:SetWidth(56)

        -- Fix the 'trade' button position
        TradeFrameTradeButton:SetPoint("BOTTOMRIGHT","TradeFrame","BOTTOMRIGHT",-141,55)

        -- Change the anchor of the cancel button so it's positioned relative to our 'unlock' button
        TradeFrameCancelButton:SetPoint("TOPLEFT","EasyUnlockUnlockButton","TOPRIGHT",-3,0)
    end
end

function EasyUnlock_GetLockpickingLevel()
    local numskills = GetNumSkillLines();
    for i=1,numskills do
        local skillname, _, _, skillrank = GetSkillLineInfo(i);
        if(skillname == EU_SKILLTAB_LOCKPICKING) then
            return skillrank;
        end
    end
    -- Return 0 if no lockpicking level has been found
    return 0
end