--[[
Name: EasyDND - Titan Waterfall Dewdrop core
Version: 2.4.2.$Revision: 71325 $
$Date: 2008-04-24 16:23:05 -0400 (Thu, 24 Apr 2008) $
Author(s): Mera_LaCroisadeEcarlate (ad@heapoverflow.com)
Playing: Mera,Merae,Merah & FathisUles on EU FR-La Croisade Ecarlate ;)
Website: http://www.wowace.com/wiki/EasyDND
Documentation: http://www.wowace.com/wiki/EasyDND
SVN: http://svn.wowace.com/wowace/trunk/EasyDND
Description: Automatically activate DND or AFK modes when you are in Battlegrounds/Arenas, Instances, AuctionHouses, Banks, Mailbox and Fighting trashs or trolls ;p FuBar/Titan compatibility included, ability to hide Blizzard's DND/AFK system notices and more.
License: LGPL 2.1
]]

local L = AceLibrary("AceLocale-2.2"):new("EasyDND")
local Waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0") or nil
EasyDNDTitan = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0")
local Dewdrop = AceLibrary("Dewdrop-2.0")
local EasyDND = EasyDND

local MINOR_VERSION = tonumber(("$Revision: 71325 $"):match("%d+"))
EasyDNDTitan.MINOR_VERSION = MINOR_VERSION

TITAN_EASYDND_ID = "EasyDND"
TITAN_EASYDND_MENU_TEXT = "EasyDND"
TITAN_EASYDND_TOOLTIP = "EasyDND"
TITAN_EASYDND_ICON_ON = "Interface\\AddOns\\EasyDND\\Icons\\dndon"
TITAN_EASYDND_ICON_OFF = "Interface\\AddOns\\EasyDND\\Icons\\dndoff"
TITAN_EASYDND_TOOLTIP_CONTENTS = L["\n|cffeda55fLeft-Click|r to open the Waterfall configuration window.\n|cffeda55fRight-Click|r to open the Dewdrop configuration panel.\n|cffeda55fShift-Click|r to instantly switch your status to a simple %s mode or remove the current mode.\n|cffeda55fCtrl-Alt-Click|r to enable/disable the addon."]

function EasyDNDTitan:OnEnable()
	if not IsAddOnLoaded("Titan") then return false end
	self:RegisterDB("EasyDNDTiDB", "EasyDNDTiDBPC")
	TitanPanelEasyDNDButton_OnLoad()
	local parentframe = CreateFrame("Frame", "TitanPanelEasyDNDButtonParent", UIParent)
	local button = CreateFrame("Button", "TitanPanelEasyDNDButton", parentframe, "TitanPanelComboTemplate")
	button:SetFrameStrata("FULLSCREEN")
	button:SetToplevel(1)
	button:Hide()
	local tempThis = this
	this = button
	TitanPanelButton_OnLoad()
	this = tempThis
	button:SetScript("OnClick", TitanPanelEasyDNDButton_OnClick)
	self.OnMenuRequest = EasyDND.opts
	Dewdrop:Register(button,'children', function() Dewdrop:FeedAceOptionsTable(self.OnMenuRequest) end)
	self:RegisterEvent("PLUGIN_CORE_CHANGED", "TitanState")
	self:RegisterEvent("PLAYER_FLAGS_CHANGED")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	self:PLAYER_FLAGS_CHANGED()
end

function EasyDNDTitan:OnDisable()
	self:UnregisterAllEvents()
end

function EasyDNDTitan:PLAYER_FLAGS_CHANGED()
	if UnitIsDND("player") then
		flag = "[" .. L["DND"] .. "]"
	elseif UnitIsAFK("player") then
		flag = "[" .. L["AFK"] .. "]"
	else
		flag = "[---]"
	end
	self:TitanState()
end

function EasyDNDTitan:ZONE_CHANGED_NEW_AREA()
	self:PLAYER_FLAGS_CHANGED()
end

function TitanPanelEasyDNDButton_OnLoad()
	if EasyDND:IsActive() then
		local icon_ = TITAN_EASYDND_ICON_ON
	else
		local icon_ = TITAN_EASYDND_ICON_OFF
	end
	iconw = 16
	if EasyDND.db.profile.hideico then
		icon_ = ""
		iconw = 0.001
	end
	this.registry = {
		id = TITAN_EASYDND_ID,
		category = "General",
		version = TITAN_VERSION,
		menuText = TITAN_EASYDND_MENU_TEXT,
		tooltipTitle = TITAN_EASYDND_TOOLTIP,
		tooltipTextFunction = "TitanPanelEasyDNDButton_GetTooltipText",
		buttonTextFunction = "TitanPanelEasyDNDButton_GetButtonText",
		icon = icon_,
		iconWidth = iconw,
		savedVariables = {
			ShowIcon = 1,
			ShowFavourites = 1,
			ShowColoredText = 1,
			ShowLabelText = 1
		}
	}
	TitanPanelButton_OnLoad()
end

function EasyDNDTitan:TitanState()
	TitanPanelButton_UpdateButton(TITAN_EASYDND_ID)
	TitanPanelButton_UpdateTooltip()
	TitanPanelEasyDNDButton_SetIcon()
end

function TitanPanelEasyDNDButton_OnClick()
	if arg1 == "RightButton" then
		Dewdrop:Open(this)
	elseif arg1 == "LeftButton" and IsControlKeyDown() and IsAltKeyDown() then
		if EasyDND:IsActive() then
			EasyDND:ToggleActive(false)
		else
			EasyDND:ToggleActive(true)
		end
	elseif arg1 == "LeftButton" and IsShiftKeyDown() then
		if UnitIsDND("player") or (EasyDND.db.profile.modednd and not UnitIsAFK("player")) then
			SendChatMessage("", "DND")
		else
			SendChatMessage("", "AFK")
		end
	elseif not (arg1 == "RightButton") and Waterfall then
		if Waterfall:IsOpen("EasyDND") then
			Waterfall:Close("EasyDND")
		else
			Waterfall:Open("EasyDND")
		end
	end
	TitanPanelButton_OnClick(arg1, 1)
end

function TitanPanelEasyDNDButton_SetIcon()
	local icon = TitanPanelEasyDNDButtonIcon
	if EasyDND.db.profile.hideico then
		TITAN_EASYDND_ICON_ON = ""
		TITAN_EASYDND_ICON_OFF = ""
		icon:SetWidth(0.001);
	else
		TITAN_EASYDND_ICON_ON = "Interface\\AddOns\\EasyDND\\Icons\\dndon"
		TITAN_EASYDND_ICON_OFF = "Interface\\AddOns\\EasyDND\\Icons\\dndoff"
		icon:SetWidth(16);
	end
	if EasyDND:IsActive() then
		icon:SetTexture(TITAN_EASYDND_ICON_ON)
	else
		icon:SetTexture(TITAN_EASYDND_ICON_OFF)
	end
end

function TitanPanelEasyDNDButton_GetButtonText(id)
	if EasyDND:IsActive() then
		status = "[ON]"
	else
		status = "[OFF]"
	end
	if EasyDND.db.profile.hidestat then
		flag = ""
	end
	if EasyDND.db.profile.hideonoff then
		status = ""
	end
	if EasyDND.db.profile.hidename then
		name = ""
	else
		name = "EasyDND:"
	end
	return (("%s%s%s"):format(name, status, flag))
end

function TitanPanelEasyDNDButton_GetTooltipText()
	EasyDND:CheckMode()
	return TITAN_EASYDND_TOOLTIP_CONTENTS:format(EasyDND.mode)
end
