--[[
Name: EasyDND - FuBar Waterfall Dewdrop Fubarplugin core
Version: 2.4.2.$Revision: 71325 $
$Date: 2008-04-24 16:23:05 -0400 (Thu, 24 Apr 2008) $
Author(s): Mera_LaCroisadeEcarlate (ad@heapoverflow.com)
Playing: Mera,Merae,Merah & FathisUles on EU FR-La Croisade Ecarlate ;)
Website: http://www.wowace.com/wiki/EasyDND
Documentation: http://www.wowace.com/wiki/EasyDND
SVN: http://svn.wowace.com/wowace/trunk/EasyDND
Description: Automatically activate DND or AFK modes when you are in Battlegrounds/Arenas, Instances, AuctionHouses, Banks, Mailbox and Fighting trashs or trolls ;p FuBar/Titan compatibility included, ability to hide Blizzard's DND/AFK system notices and more.
License: LGPL 2.1
]]

local L = AceLibrary("AceLocale-2.2"):new("EasyDND")
local Waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0") or nil
EasyDNDFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
local Fu = AceLibrary("FuBarPlugin-2.0")
local Tablet = AceLibrary("Tablet-2.0")
local EasyDND = EasyDND

local MINOR_VERSION = tonumber(("$Revision: 71325 $"):match("%d+"))
EasyDNDFu.MINOR_VERSION = MINOR_VERSION

function EasyDNDFu:CheckBar()
	if IsAddOnLoaded("FuBar") then
		return "FuBar"
	elseif IsAddOnLoaded("Titan") then
		return "Titan"
	end
	return "none"
end

function EasyDNDFu:OnInitialize()
	self:RegisterDB("EasyDNDFuDB", "EasyDNDFuDBPC")
	self.OnMenuRequest = EasyDND.opts
	local args = Fu:GetAceOptionsDataTable(EasyDNDFu)
	if not EasyDNDFu.OnMenuRequest.args["FuBar"] then
		EasyDNDFu.OnMenuRequest.args["FuBar"] = {
			type = "group",
			name = "FuBar",
			desc = "FuBar options.",
			args = args,
			order = 300,
		}
	end
	if Waterfall then
		Waterfall:Register(
			"EasyDND",
			"aceOptions", EasyDND.opts,
			"treeType","SECTIONS",
			"colorR", .6, "colorG", .5, "colorB", .8
		)
	end
	self.hasIcon = "Interface\\AddOns\\EasyDND\\Icons\\dndon"
	self.hasNoColor = true
	self.defaultPosition = "MINIMAP"
	self.defaultMinimapPosition = 260
	self.independentProfile = true
	self.cannotDetachTooltip = false
	EasyDND.hideMenuTitle = true
	if self:CheckBar() == "Titan" or self:CheckBar() == "FuBar" then
		self.hideWithoutStandby = true
	else
		self.hideWithoutStandby = false
	end
	self:PLAYER_FLAGS_CHANGED()
end

function EasyDNDFu:OnEnable()
	self:RegisterEvent("PLUGIN_CORE_CHANGED", "FubarState")
	self:RegisterEvent("PLAYER_FLAGS_CHANGED")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
end

function EasyDNDFu:OnDisable()
	self:UnregisterAllEvents()
end

function EasyDNDFu:FubarState()
	self:Update()
end

function EasyDNDFu:PLAYER_FLAGS_CHANGED()
	if UnitIsDND("player") then
		flag = "[" .. L["DND"] .. "]"
	elseif UnitIsAFK("player") then
		flag = "[" .. L["AFK"] .. "]"
	else
		flag = "[---]"
	end
	self:Update()
end

function EasyDNDFu:ZONE_CHANGED_NEW_AREA()
	self:PLAYER_FLAGS_CHANGED()
end

function EasyDNDFu:OnTextUpdate()
	EasyDND:CheckMode()
	if not EasyDND.db.profile.hideico and not EasyDNDFu:IsIconShown() then
		self:ToggleIconShown()
	end
	if EasyDND:IsActive() then
		status = "[ON]"
		SETICON = "Interface\\AddOns\\EasyDND\\Icons\\dndon"
	else
		status = "[OFF]"
		SETICON = "Interface\\AddOns\\EasyDND\\Icons\\dndoff"
	end
	if EasyDND.db.profile.hideonoff then
		status = ""
	end
	if EasyDND.db.profile.hidestat then
		flag = ""
	end
	if EasyDND.db.profile.hidename then
		name = ""
	else
		name = "EasyDND:"
	end
	self:SetText(("%s%s%s"):format(name, status, flag))
	self:SetIcon(SETICON)
end

function EasyDNDFu:OnClick()
	if IsControlKeyDown() then
		if IsAltKeyDown() then
			if EasyDND:IsActive() then
				EasyDND:ToggleActive(false)
			else
				EasyDND:ToggleActive(true)
			end
		end
	elseif IsShiftKeyDown() then
		if UnitIsDND("player") or (EasyDND.db.profile.modednd and not UnitIsAFK("player")) then
			SendChatMessage("", "DND")
		else
			SendChatMessage("", "AFK")
		end
	elseif Waterfall then
		if Waterfall:IsOpen("EasyDND") then
			Waterfall:Close("EasyDND")
		else
			Waterfall:Open("EasyDND")
		end
	end
	self:Update()
end

function EasyDNDFu:OnTooltipUpdate()
	EasyDND:CheckMode()
	self:OnTextUpdate()
	Tablet:SetTitle(("%s%s%s"):format(name, status, flag))
	Tablet:SetHint((L["\n|cffeda55fLeft-Click|r to open the Waterfall configuration window.\n|cffeda55fRight-Click|r to open the Dewdrop configuration panel.\n|cffeda55fShift-Click|r to instantly switch your status to a simple %s mode or remove the current mode.\n|cffeda55fCtrl-Alt-Click|r to enable/disable the addon."]:format(EasyDND.mode)))
end
