--[[
Name: EasyDND - Addon core
Version: 2.4.2.$Revision: 71325 $
$Date: 2008-04-24 16:23:05 -0400 (Thu, 24 Apr 2008) $
Author(s): Mera_LaCroisadeEcarlate (ad@heapoverflow.com)
Playing: Mera,Merae,Merah & FathisUles on EU FR-La Croisade Ecarlate ;)
Website: http://www.wowace.com/wiki/EasyDND
Documentation: http://www.wowace.com/wiki/EasyDND
SVN: http://svn.wowace.com/wowace/trunk/EasyDND
Description: Automatically activate DND or AFK modes when you are in Battlegrounds/Arenas, Instances, AuctionHouses, Banks, Mailbox and Fighting trashs or trolls ;p FuBar/Titan compatibility included, ability to hide Blizzard's DND/AFK system notices and more.
License: LGPL 2.1
]]

local L = AceLibrary("AceLocale-2.2"):new("EasyDND")
EasyDND = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
local checkbg, checkinst, checkah, checkbank, checkmail, checkcbt = 0

local MINOR_VERSION = tonumber(("$Revision: 71325 $"):match("%d+"))
EasyDND.MINOR_VERSION = MINOR_VERSION

function EasyDND:OnInitialize()
	self:RegisterDB("EasyDNDDB", "EasyDNDDBPC")
	self:RegisterDefaults("profile", {
	sig = "[EasyDND] ",	--Don't touch please.
	messagebg = L["Sorry I am currently busy in a battleground or arena. Please try again later."],
	messageinst = L["Sorry I am currently busy in an instance. Please try again later."],
	messageah = L["Sorry I am currently busy browsing the auction house. Please try again later."],
	messagebank = L["Sorry I am currently busy browsing my bank. Please try again later."],
	messagemail = L["Sorry I am currently busy browsing my mailbox. Please try again later."],
	messagecbt = L["Sorry I am currently busy farming trashs or naabs. Please try again in a few seconds."],
	hidesys = true,
	hideadd = false,
	hidestat = false,
	hideonoff = false,
	hidename = false,
	hideico = false,
	modednd = true,
	modebg = true,
	modeinst = true,
	modeah = true,
	modebank = true,
	modemail = true,
	modecbt = false,
	} )
	self.AntiAFKInBG = false
	self:CheckMode()
	if EasyDND.MINOR_VERSION < EasyDNDFu.MINOR_VERSION then EasyDND.MINOR_VERSION = EasyDNDFu.MINOR_VERSION end
	if EasyDND.MINOR_VERSION < EasyDNDTitan.MINOR_VERSION then EasyDND.MINOR_VERSION = EasyDNDTitan.MINOR_VERSION end
	if EasyDND.MINOR_VERSION < EasyDNDenUS.MINOR_VERSION then EasyDND.MINOR_VERSION = EasyDNDenUS.MINOR_VERSION end
	if EasyDND.MINOR_VERSION < EasyDNDfrFR.MINOR_VERSION then EasyDND.MINOR_VERSION = EasyDNDfrFR.MINOR_VERSION end
	local opts = {
		type="group",
		args = {
			cat1 = {
				type = "group",
				name = L["Hide/Show"],
				desc = L["Setup various hide/show configurations."],
				order = 4,
				args = {
					hidesys = {
						type = "toggle",
						name = L["Hide/Show system"],
						desc = L["If checked, hides the blizzard's yellow system messages generated by using DND/AFK modes."],
						get = "IsHideSys",
						set = "ToggleHideSys",
						order = 10,
					},
					hideadd = {
						type = "toggle",
						name = L["Hide/Show addon"],
						desc = L["If checked, hides the addon's yellow messages auto-generated by using DND/AFK modes."],
						get = "IsHideAdd",
						set = "ToggleHideAdd",
						order = 20,
					},
					hidestat = {
						type = "toggle",
						name = L["Hide/Show mode"],
						desc = L["If checked, hides your current DND/AFK or normal modes in the FuBar/Titan text and Tablet tooltip."],
						get = "IsHideStat",
						set = "ToggleHideStat",
						order = 30,
					},
					hideonoff = {
						type = "toggle",
						name = L["Hide/Show ON/OFF"],
						desc = L["If checked, hides the ON/OFF status text in the FuBar/Titan text and Tablet tooltip."],
						get = "IsHideOnOff",
						set = "ToggleHideOnOff",
						order = 35,
					},
					hidename = {
						type = "toggle",
						name = L["Hide/Show name"],
						desc = L["If checked, hides the addon's name in the FuBar/Titan text and Tablet tooltip."],
						get = "IsHideName",
						set = "ToggleHideName",
						order = 36,
					},
					hideico = {
						type = "toggle",
						name = L["Hide/Show icon"],
						desc = L["If checked, hides the addon's icon in the FuBar/Titan text."],
						get = "IsHideIco",
						set = "ToggleHideIco",
						order = 37,
					},
				},
			},
			cat2 = {
				type = "group",
				name = L["Messages"],
				desc = L["Setup various messages for each special events available."],
				order = 5,
				args = {
					msgbg = {
						type = "text",
						name = L["PVP message"],
						desc = L["Message to be displayed when you are in a battleground or an arena."],
						usage = L["<Your message>"],
						get = "GetMessageBG",
						set = "SetMessageBG",
						order = 40,
					},
					msginst = {
						type = "text",
						name = L["Instance message"],
						desc = L["Message to be displayed when you are in an instance."],
						usage = L["<Your message>"],
						get = "GetMessageInst",
						set = "SetMessageInst",
						order = 50,
					},
					msgah = {
						type = "text",
						name = L["Auction house message"],
						desc = L["Message to be displayed when you are in an auction house."],
						usage = L["<Your message>"],
						get = "GetMessageAH",
						set = "SetMessageAH",
						order = 60,
					},
					msgbank = {
						type = "text",
						name = L["Bank message"],
						desc = L["Message to be displayed when you are in a bank."],
						usage = L["<Your message>"],
						get = "GetMessageBank",
						set = "SetMessageBank",
						order = 70,
					},
					msgmail = {
						type = "text",
						name = L["Mailbox message"],
						desc = L["Message to be displayed when you are at your mailbox."],
						usage = L["<Your message>"],
						get = "GetMessageMail",
						set = "SetMessageMail",
						order = 80,
					},
					msgcbt = {
						type = "text",
						name = L["Combat message"],
						desc = L["Message to be displayed when you enter in a combat."],
						usage = L["<Your message>"],
						get = "GetMessageCbt",
						set = "SetMessageCbt",
						order = 90,
					},
				},
			},
			cat3 = {
				type = "group",
				name = L["Modes"],
				desc = L["Setup which events EasyDND will react on."],
				order = 6,
				args = {
					modednd = {
						type = "toggle",
						name = L["DND or AFK mode"],
						desc = L["Setup the addon to use the DND mode if activated or the AFK mode if deactivated. (A protection has been made to not accidentally switch to AFK mode in PVP areas, the addon only uses the DND mode in battlegrounds or arenas)"],
						get = "IsModeDND",
						set = "ToggleModeDND",
						order = 100,
					},
					modebg = {
						type = "toggle",
						name = L["PVP mode"],
						desc = L["Activate EasyDND when you are in a battleground or an arena."],
						get = "IsModeBG",
						set = "ToggleModeBG",
						order = 110,
					},
					modeinst = {
						type = "toggle",
						name = L["Instance mode"],
						desc = L["Activate EasyDND when you are in an instance."],
						get = "IsModeInstance",
						set = "ToggleModeInstance",
						order = 120,
					},
					modeah = {
						type = "toggle",
						name = L["Auction house mode"],
						desc = L["Activate EasyDND when you are in an auction house."],
						get = "IsModeAH",
						set = "ToggleModeAH",
						order = 130,
					},
					modebank = {
						type = "toggle",
						name = L["Bank mode"],
						desc = L["Activate EasyDND when you are in a bank."],
						get = "IsModeBank",
						set = "ToggleModeBank",
						order = 140,
					},
					modemail = {
						type = "toggle",
						name = L["Mailbox mode"],
						desc = L["Activate EasyDND when you are at your mailbox."],
						get = "IsModeMail",
						set = "ToggleModeMail",
						order = 150,
					},
					modecbt = {
						type = "toggle",
						name = L["Combat mode"],
						desc = L["Activate EasyDND when you enter in a combat."],
						get = "IsModeCbt",
						set = "ToggleModeCbt",
						order = 160,
					}
				}
			},
			header = {
				type = "header",
				name = ("EasyDND r|cff7fff7f%s|r by |cffffffffMera|r"):format(EasyDND.MINOR_VERSION), --Don't touch please.
				order = 1,
			},
			header2 = {
				type = "header",
				name = "==La Croisade Ecarlate==", --Don't touch please.
				order = 2,
			},
			spacer = {
				type = "header",
				name = " ",
				order = 3,
			}
		}
	}
	EasyDND.opts = opts
	self:RegisterChatCommand("/easydnd", "/ezdnd", opts)
end

function EasyDND:CheckBar()
	if IsAddOnLoaded("FuBar") then
		return "FuBar"
	elseif IsAddOnLoaded("Titan") then
		return "Titan"
	else
		return "none"
	end
end

function EasyDND:OnEnable()
	ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", OnFilter)
	self:RegisterEvent("CHAT_MSG_SYSTEM")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("AUCTION_HOUSE_SHOW")
	self:RegisterEvent("AUCTION_HOUSE_CLOSED")
	self:RegisterEvent("BANKFRAME_OPENED")
	self:RegisterEvent("BANKFRAME_CLOSED")
	self:RegisterEvent("MAIL_SHOW")
	self:RegisterEvent("MAIL_CLOSED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:TriggerEvent("PLUGIN_CORE_CHANGED")
	self.AntiAFKInBG = false
	if self:CheckBar() == "none" then
		self.FuPresent = (L[" (FuBar/Titan not present, using minimap icon)"])
	else
		self.FuPresent = ""
	end
	self:Print((L["activated.%s"]:format(self.FuPresent)))
end

function EasyDND:OnDisable()
	self.AntiAFKInBG = false
	self:TriggerEvent("PLUGIN_CORE_CHANGED")
	self:UnregisterAllEvents()
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", OnFilter)
	self:Print(L["deactivated."])
end

function EasyDND:CHAT_MSG_SYSTEM()
	if self.db.profile.hidesys then
		ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", OnFilter)
	end
end

function OnFilter(msg)
	if EasyDND.db.profile.hidesys then
		if strfind(msg, string.sub(MARKED_DND, 1, strlen(MARKED_DND) - 3)) then
			return true
		elseif strfind(msg, CLEARED_DND) then
			return true
		elseif strfind(msg, MARKED_AFK) then
			return true
		elseif strfind(msg, string.sub(MARKED_AFK_MESSAGE, 1, strlen(MARKED_AFK_MESSAGE) - 2)) then
			return true
		elseif strfind(msg, CLEARED_AFK) then
			return true
		end
	end
	return false
end

function EasyDND:PLAYER_ENTERING_WORLD()
	SetMapToCurrentZone()
	if select(2, IsInInstance()) == "pvp" or select(2, IsInInstance()) == "arena" then
		if self.db.profile.modebg then
			self.AntiAFKInBG = true -- We must be sure to never switch ABS in PVP areas you know why ;p
			if not self.db.profile.hideadd then
				self:CheckMode()
				UIErrorsFrame:AddMessage((L["PVP_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
			end
			self:AutoSwitchOn(self.db.profile.messagebg)
		end
	elseif select(2, IsInInstance()) == "none" and checkbg == 1 then
		if self.db.profile.modebg and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkbg == 1) then
			if not self.db.profile.hideadd then
				self:CheckMode()
				UIErrorsFrame:AddMessage((L["PVP_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
			end
			self:AutoSwitchOff()
		end
	elseif select(2, IsInInstance()) == "raid" or select(2, IsInInstance()) == "party" then
		if self.db.profile.modeinst then
			if not self.db.profile.hideadd then
				self:CheckMode()
				UIErrorsFrame:AddMessage((L["Instance_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
			end
			self:AutoSwitchOn(self.db.profile.messageinst)
		end
	elseif select(2, IsInInstance()) == "none" and checkinst == 1 then
		if self.db.profile.modeinst and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkinst == 1) then
			if not self.db.profile.hideadd then
				self:CheckMode()
				UIErrorsFrame:AddMessage((L["Instance_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
			end
			self:AutoSwitchOff()
		end
	end
end

function EasyDND:AUCTION_HOUSE_SHOW()
	if self.db.profile.modeah and not (UnitIsDND("player") or UnitIsAFK("player")) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["AH_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOn(self.db.profile.messageah)
	end
end

function EasyDND:AUCTION_HOUSE_CLOSED()
	if self.db.profile.modeah and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkah == 1) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["AH_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOff()
	end
end

function EasyDND:BANKFRAME_OPENED()
	if self.db.profile.modebank and not (UnitIsDND("player") or UnitIsAFK("player")) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Bank_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOn(self.db.profile.messagebank)
	end
end

function EasyDND:BANKFRAME_CLOSED()
	if self.db.profile.modebank and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkbank == 1) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Bank_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOff()
	end
end

function EasyDND:MAIL_SHOW()
	if self.db.profile.modemail and not (UnitIsDND("player") or UnitIsAFK("player")) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Mailbox_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOn(self.db.profile.messagemail)
	end
end

function EasyDND:MAIL_CLOSED()
	if self.db.profile.modemail and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkmail == 1) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Mailbox_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOff()
	end
end

function EasyDND:PLAYER_REGEN_DISABLED()
	if self.db.profile.modecbt and not (UnitIsDND("player") or UnitIsAFK("player")) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Combat_mode_on"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOn(self.db.profile.messagecbt)
	end
end

function EasyDND:PLAYER_REGEN_ENABLED()
	if self.db.profile.modecbt and (((UnitIsDND("player") and self.db.profile.modednd) or (UnitIsAFK("player") and not self.db.profile.modednd)) and checkcbt == 1) then
		if not self.db.profile.hideadd then
			self:CheckMode()
			UIErrorsFrame:AddMessage((L["Combat_mode_off"]:format(EasyDND.mode)), 1.0, 1.0, 0.0, 5.0)
		end
		self:AutoSwitchOff()
	end
end

function EasyDND:CheckMode()
	if self.db.profile.modednd or self.AntiAFKInBG == true then
		EasyDND.mode = L["DND"]
	else
		EasyDND.mode = L["AFK"]
	end
end

function EasyDND:AutoSwitchOn(msg)
	if msg == self.db.profile.messagebg then
		checkbg = 1
	elseif msg == self.db.profile.messageinst then
		checkinst = 1
	elseif msg == self.db.profile.messageah then
		checkah = 1
	elseif msg == self.db.profile.messagebank then
		checkbank = 1
	elseif msg == self.db.profile.messagemail then
		checkmail = 1
	elseif msg == self.db.profile.messagecbt then
		checkcbt = 1
	end
	if self.db.profile.modednd or self.AntiAFKInBG == true then -- We must be sure to never switch ABS in PVP areas you know why ;p
		SendChatMessage(self.db.profile.sig .. msg, "DND")	--Don't touch please.
	else
		SendChatMessage(self.db.profile.sig .. msg, "AFK")	--Don't touch please.
	end
end

function EasyDND:AutoSwitchOff()
	checkbg = 0
	checkinst = 0
	checkah = 0
	checkbank = 0
	checkmail = 0
	checkcbt = 0
	if self.db.profile.modednd then
		SendChatMessage("", "DND")
	else
		SendChatMessage("", "AFK")
	end
end

function EasyDND:GetMessageBG()
	return self.db.profile.messagebg
end

function EasyDND:GetMessageInst()
	return self.db.profile.messageinst
end

function EasyDND:GetMessageAH()
	return self.db.profile.messageah
end

function EasyDND:GetMessageBank()
	return self.db.profile.messagebank
end

function EasyDND:GetMessageMail()
	return self.db.profile.messagemail
end

function EasyDND:GetMessageCbt()
	return self.db.profile.messagecbt
end

function EasyDND:SetMessageBG(newValueBG)
	self.db.profile.messagebg = newValueBG
end

function EasyDND:SetMessageInst(newValueInst)
	self.db.profile.messageinst = newValueInst
end

function EasyDND:SetMessageAH(newValueAH)
	self.db.profile.messageah = newValueAH
end

function EasyDND:SetMessageBank(newValueBank)
	self.db.profile.messagebank = newValueBank
end

function EasyDND:SetMessageMail(newValueMail)
	self.db.profile.messagemail = newValueMail
end

function EasyDND:SetMessageCbt(newValueCbt)
	self.db.profile.messagecbt = newValueCbt
end

function EasyDND:IsHideSys()
	return self.db.profile.hidesys
end

function EasyDND:IsHideAdd()
	return self.db.profile.hideadd
end

function EasyDND:IsHideStat()
	return self.db.profile.hidestat
end

function EasyDND:IsHideOnOff()
	return self.db.profile.hideonoff
end

function EasyDND:IsHideName()
	return self.db.profile.hidename
end

function EasyDND:IsHideIco()
	return self.db.profile.hideico
end

function EasyDND:IsModeDND()
	return self.db.profile.modednd
end

function EasyDND:IsModeBG()
	return self.db.profile.modebg
end

function EasyDND:IsModeInstance()
	return self.db.profile.modeinst
end

function EasyDND:IsModeAH()
	return self.db.profile.modeah
end

function EasyDND:IsModeBank()
	return self.db.profile.modebank
end

function EasyDND:IsModeMail()
	return self.db.profile.modemail
end

function EasyDND:IsModeCbt()
	return self.db.profile.modecbt
end

function EasyDND:ToggleHideSys()
	self.db.profile.hidesys = not self.db.profile.hidesys
end

function EasyDND:ToggleHideAdd()
	self.db.profile.hideadd = not self.db.profile.hideadd
end

function EasyDND:ToggleHideStat()
	self.db.profile.hidestat = not self.db.profile.hidestat
	if self.db.profile.hidestat then
		flag = ""
	else
		if UnitIsDND("player") then
			flag = "[" .. L["DND"] .. "]"
		elseif UnitIsAFK("player") then
			flag = "[" .. L["AFK"] .. "]"
		else
			flag = "[---]"
		end
	end
	self:TriggerEvent("PLUGIN_CORE_CHANGED")
end

function EasyDND:ToggleHideOnOff()
	self.db.profile.hideonoff = not self.db.profile.hideonoff
	if self.db.profile.hideonoff then
		status = ""
	else
		if EasyDND:IsActive() then
			status = "[ON]"
		else
			status = "[OFF]"
		end
	end
	self:TriggerEvent("PLUGIN_CORE_CHANGED")
end

function EasyDND:ToggleHideIco()
	self.db.profile.hideico = not self.db.profile.hideico
	EasyDNDFu:ToggleIconShown()
	self:TriggerEvent("PLUGIN_CORE_CHANGED")
end

function EasyDND:ToggleHideName()
	self.db.profile.hidename = not self.db.profile.hidename
	if self.db.profile.hidename then
		name = ""
	else
		name = "EasyDND:"
	end
	EasyDND:TriggerEvent("PLUGIN_CORE_CHANGED")
end

function EasyDND:ToggleModeDND()
	self.db.profile.modednd = not self.db.profile.modednd
end

function EasyDND:ToggleModeBG()
	self.db.profile.modebg = not self.db.profile.modebg
end

function EasyDND:ToggleModeInstance()
	self.db.profile.modeinst = not self.db.profile.modeinst
end

function EasyDND:ToggleModeAH()
	self.db.profile.modeah = not self.db.profile.modeah
end

function EasyDND:ToggleModeBank()
	self.db.profile.modebank = not self.db.profile.modebank
end

function EasyDND:ToggleModeMail()
	self.db.profile.modemail = not self.db.profile.modemail
end

function EasyDND:ToggleModeCbt()
	self.db.profile.modecbt = not self.db.profile.modecbt
end
