-- #############################################################################
-- variables

-- saved variables, and their defaults
es_font_size = 30;
es_window_size = 40;
es_window_autotoggle = true;
es_window_show = false;
es_window_moved = false;
es_click_to_cast = false;

-- constants
local es_max_duration = 600; -- milliseconds
local es_max_charges = 6;
local es_spell_ids = { 974, 32593, 32594 }; -- the different ranks of ES
-- the id of the proc itself, seems constant across different ranks of ES
local es_spell_proc_ids = { 379 }; 
local player_name = UnitName("player");
local es_font = "Interface\\AddOns\\ESTrack\\Bazooka.ttf";
local es_font_style = "THICKOUTLINE";
local es_icon_clipping = 0.07; -- 1 = total, 0 = none

-- temp variables
local es_active = false;
local es_charges = 0; 
local es_target = "";
local es_wait_buffer = 1;
local es_wait_casted_time = 0;

-- #############################################################################
-- core 


function combat_event_handler(timestamp, event, srcGUID, srcName, srcFlags, 
                              dstGUID, dstName, dstFlags, prefix, suffix, 
                              sufPar1, sufPar2, sufPar3, sufPar4, sufPar5, 
                              sufPar6, sufPar7, sufPar8)
    
    -- only concern ourselves with events that either we 
    -- initiate, or result in changes to our ES target
    --if (srcName ~= player_name and dstName ~= es_target) then return; end
    
    -- cases
    -- 1. someone casts ES on target (possibly player self)
    -- 2. player casts ES on a target different from target
    -- 3. target's ES fades
    -- 4. target's ES procs
    
    -- 1.
    if (event == "SPELL_CAST_SUCCESS" and 
        dstName == es_target and 
        listContains(es_spell_ids, prefix)) then
        
        es_charges = es_max_charges;
        es_active = true;
        es_wait_casted_time = timestamp;

        CooldownFrame_SetTimer(ui_cooldown, GetTime(), es_max_duration, 1);
        hidesubframes(estrack_ui_frame);
        ui_counter:SetText(es_charges);

        --Print("1. someone casts ES on target (possibly player self)");

    
    -- 2. 
    elseif (event == "SPELL_CAST_SUCCESS" and 
            dstName ~= es_target and 
            srcName == player_name and 
            listContains(es_spell_ids, prefix)) then
            
        es_charges = es_max_charges;
        es_target = dstName;
        es_active = true;
        es_wait_casted_time = timestamp;        

        --Print("Setting ES target to \"" .. es_target .. "\"");
        estrack_ui_frame:SetAttribute("unit", es_target);
        CooldownFrame_SetTimer(ui_cooldown, GetTime(), es_max_duration, 1);
        hidesubframes(estrack_ui_frame);
        ui_counter:SetText(es_charges);
        
        --Print("2. player casts ES on a target different from target");
        
    -- 3. 
    elseif (event == "SPELL_AURA_REMOVED" and 
            dstName == es_target and 
            -- es_wait_buffer time must have passed, 
            -- before we consider it "gone".
            es_wait_casted_time+es_wait_buffer < timestamp and
            listContains(es_spell_ids, prefix)) then
            
        es_charges = 0;
        es_active = false;        

        CooldownFrame_SetTimer(ui_cooldown, 1, 1, 1);
        hidesubframes(ui_cooldown);
        ui_counter:SetText("");        
        
        --Print("3. target's ES fades");
        
    -- 4. 
    elseif (event == "SPELL_HEAL" and 
            srcName == es_target and 
            -- should ensure that SPELL_HEAL events that follow AFTER a 
            -- SPELL_AURA_REMOVED does not go in here.
            es_charges > 0 and 
            listContains(es_spell_proc_ids, prefix)) then
            
        es_charges = es_charges-1;
        ui_counter:SetText(es_charges);
        --Print("4. target's ES procs");
        assert(es_charges >= 0, "es_charges can never be less then zero.");
        
    end

    -- when someone casts ES
    -- event = SPELL_CAST_SUCCESS
    -- srcName = caster (with GUID)
    -- dstName = target (with GUID)
    -- prefix = 974 (spell id)
    -- suffix = "Earth Shield"
    
    -- when someone gains ES
    -- event = SPELL_AURA_APPLIED
    -- srcName = undefined (and GUID likewise)
    -- dstName = target (with GUID)
    -- prefix = 974 (spell id)
    -- suffix = "Earth Shield"

    -- when ES fades from someone
    -- event = SPELL_AURA_REMOVED
    -- srcName = undefined (and GUID likewise)
    -- dstName = target (with GUID)
    -- prefix = 974 (spell id)
    -- suffix = "Earth Shield"
    
    -- when ES procs
    -- event = SPELL_HEAL
    -- srcName = player with ES (with GUID)
    -- dstName = player with ES (with GUID)
    -- prefix = 379 (spell id for the ES proc itself)
    -- suffix = Earth Shield
    -- sufPar1 = 8 (unknown what this is)
    -- sufPar2 = 987 (unknown what this is, presumably heal)
     
end

function event_onevent(event_type, arg1, arg2, arg3, arg4)
    if (event_type == "RAID_ROSTER_UPDATE" or 
        event_type == "PARTY_MEMBERS_CHANGED" or 
        event_type == "PLAYER_ENTERING_WORLD") then
        
        --Print("ESTrack : Event " .. event_type .. 
        --               " auto: " .. BooleanToString(es_window_autotoggle) .. 
        --                     "," .. BooleanToString(not es_window_show));
        if (es_window_autotoggle) then
            local grouped = (GetNumPartyMembers() + GetNumRaidMembers()) > 0
            --Print("ESTrack : Event grouped " .. BooleanToString(grouped));
            if (grouped) then
                estrack_ui_frame:Show();
            else
                estrack_ui_frame:Hide();
            end
        end
    
    elseif (event_type == "VARIABLES_LOADED" and 
            UnitClass("player") == "Shaman") then
        makeUI();
        SLASH_ESTRACK1 = "/estrack";
        SlashCmdList["ESTRACK"] = estrack_slashcommand;
        Print("ESTrack : Loaded");
    else 
        -- unhook main frame, should stop everything.
        estrack_core_frame:SetScript("OnLoad", nil);
        estrack_core_frame:SetScript("OnEvent", nil);
    end
end

-- #############################################################################
-- misc

function BooleanToString(bool)
    if (not not bool) then
        return "true";
    end
    return "false";
end

function SetCounterFont()
    ui_counter:SetFont(es_font, es_font_size, es_font_style);
end

function SetWindowSize()
    estrack_ui_frame:SetHeight(es_window_size);
    estrack_ui_frame:SetWidth(es_window_size);
end

function listContains(table, value)
	for _, v in pairs(table) do
		if v == value then 
		    return true;
		end
	end
	return false;
end

function Print(str) 
    DEFAULT_CHAT_FRAME:AddMessage(str);
end

function hidesubframes(frm) 
    -- This function hides the cooldown frame added by OmniCC.
    -- OmniCC adds a NAMELESS frame as a child to the parent of ui_cooldown
    -- so we iterate over the children, and hide all the children but 
    -- the one we added.
    local child_frames = { frm:GetChildren() };
    for _, child in ipairs(child_frames) do
        if (child:GetName() ~= "ui_cooldown") then
            child:Hide();
        end
    end
end

-- #############################################################################
-- ui event handlers

function event_onmousedown(self) 
    if(not this.isLocked) then
        this:StartMoving();
    elseif (es_click_to_cast) then
        -- hmm
    end
    
end

function event_onmouseevent(self)
    -- save coords
    --es_window_left = floor(estrack_ui_frame:GetLeft()+0.5);
    --es_window_top = floor(estrack_ui_frame:GetTop());
    --local point, relTo, relPoint, xOfs, yOfs = estrack_ui_frame:GetPoint();
    --es_window_relative = relPoint;
    
    es_window_moved = true;
    estrack_ui_frame:SetUserPlaced(true);
    this:StopMovingOrSizing();
end

function event_onmouseup(self) 
    return event_onmouseevent(self);
end

function event_ondragstop(self) 
    return event_onmouseevent(self);
end

-- #############################################################################
-- ui construction

local estrack_ui_frame;
local ui_icon;
local ui_cooldown;
local ui_counter;

function makeUI() 
    estrack_ui_frame = CreateFrame("Button","estrack_ui_frame", UIParent, 
                                   "SecureActionButtonTemplate");

    -- sets attributes for secure frame
    estrack_ui_frame:SetAttribute("unit", "none"); -- 'none' is a valid id
    estrack_ui_frame:SetAttribute("type", "spell");
    estrack_ui_frame:SetAttribute("spell", "Earth Shield");
        
    -- set properties that are always true on load
    estrack_ui_frame:SetMovable(1);
    estrack_ui_frame.isLocked = true; -- we always start up locked.
    estrack_ui_frame:SetFrameStrata("BACKGROUND");
    
    SetWindowSize();
    
    -- positioning
    if (not es_window_moved) then
        estrack_ui_frame:SetPoint("CENTER");
    end

    -- event hookup
    estrack_ui_frame:SetScript("OnMouseDown", event_onmousedown);
    estrack_ui_frame:SetScript("OnMouseUp", event_onmouseup);
    estrack_ui_frame:SetScript("OnDragStop", event_ondragstop);
    
    -- show/hide, depending on saved vars
    if (es_window_show and not es_window_autotoggle) then
        estrack_ui_frame:Show();
    else
        estrack_ui_frame:Hide();
    end
    
    -- clicktocast enabled, or not?
    if (es_click_to_cast) then
        estrack_ui_frame:EnableMouse(1);
    else
        estrack_ui_frame:EnableMouse(0);
        
    end

    -- icon creation
    ui_icon = estrack_ui_frame:CreateTexture(nil, "BACKGROUND");
    ui_icon:SetAllPoints();
    -- clips a bit of the edge of the icon
    ui_icon:SetTexCoord(es_icon_clipping, 1-es_icon_clipping, 
                        es_icon_clipping, 1-es_icon_clipping); 
    ui_icon:SetTexture("Interface\\Icons\\Spell_Nature_SkinofEarth");
    
    -- cooldown frame creation
    ui_cooldown = CreateFrame("Cooldown", "ui_cooldown", estrack_ui_frame, 
                              "CooldownFrameTemplate");
    ui_cooldown:SetFrameStrata("BACKGROUND");
    ui_cooldown:SetAllPoints(ui_icon);
    ui_cooldown:SetPoint("CENTER");

    -- font counter    
    ui_counter = ui_cooldown:CreateFontString("ui_counter", "OVERLAY", 
                                              "GameFontNormal");
    ui_counter:SetPoint("CENTER", 2, -2);
    ui_counter:SetTextColor(1,1,1,1);
    SetCounterFont();
end



-- #############################################################################
-- sets up the slash commands

function estrack_slashcommand(msg) 
    if (msg == "lock") then
        estrack_ui_frame.isLocked = true;
        estrack_ui_frame:EnableMouse(0);
        Print("ESTrack : Locked");
    elseif (msg == "unlock") then
        es_click_to_cast = false; -- disabled while dragging
        estrack_ui_frame.isLocked = false;
        estrack_ui_frame:EnableMouse(1);
        Print("ESTrack : Unlocked");
    elseif (msg == "clicktocast") then
        es_click_to_cast = not es_click_to_cast;
        if (es_click_to_cast) then
            estrack_ui_frame:EnableMouse(1);
            estrack_ui_frame.isLocked = true;
        else
            estrack_ui_frame:EnableMouse(0);
        end
        Print("ESTrack : ClickToCast is now " .. BooleanToString(es_click_to_cast));
    elseif (msg == "autotoggle") then
        es_window_autotoggle = not es_window_autotoggle;
        event_onevent("PARTY_MEMBERS_CHANGED",0,0,0,0);
        Print("ESTrack : Auto Toggle is now " .. BooleanToString(es_window_autotoggle));
    elseif (msg == "hide") then
        es_window_show = false;
        if (not es_window_autotoggle) then 
            estrack_ui_frame:Hide();
        end
        Print("ESTrack : Hide");
    elseif (msg == "show") then
        es_window_show = true;
        if (not es_window_autotoggle) then 
            estrack_ui_frame:Show();
        end
        Print("ESTrack : Show");
    elseif (string.find(msg, "font")) then
        local cmdname, fontsize = strsplit(" ", msg);
        es_font_size = tonumber(strtrim(fontsize));
        SetCounterFont();
        Print("ESTrack : Font now set to " .. es_font_size);
    elseif (string.find(msg, "size")) then
        local cmdname, windowsize = strsplit(" ", msg);
        es_window_size = tonumber(strtrim(windowsize));
        SetWindowSize();
        Print("ESTrack : Size now set to " .. es_window_size);
    elseif (msg == "resetwindow") then
        estrack_ui_frame:SetPoint("CENTER");
        es_window_moved = false;
        Print("ESTrack : Window has been reset");
    end    
end
