﻿-- #####################################################################--
-- 	this file is formated in UTF-8. do NOT change it. 
-- 		utf-8 is not compatible to windows editor. do not open and save this file with wordpad or notepad.
-- 		Best texteditor to view this file: notepad++
--
-- 	DynamicPerformance, written by Kaboom@Arthas(EU), Spring 2008
-- 	--> 	INIT.lua
--		this would help to initialize the addon and to define some slashcommands etc.
-- #####################################################################--
local self = DynamicPerformanceAce
local L = DynamicPerformanceAce.Loc	-- localisation


SLASH_DYNAMICPERFORMANCE1 = "/dynamicperformance"
SLASH_DYNAMICPERFORMANCE2 = "/dp"
SlashCmdList["DYNAMICPERFORMANCE"] = function(msg)	
	DynamicPerformanceAce:SlashCommand(msg)
end



function DynamicPerformanceAce:SlashCommand(msg)
	-- self:verbose is found in FUNC.lua
	-- self:toggle is found in CORE.lua
	local command=string.lower(msg)
	--	DIRECT commands to turn on/off the addon
	if command=="on" then
		if DynPerfDB.run==1 then
			self:Verbose(0, L.run_already)
		else
			self:Verbose(0, L.run_text)
			self:Toggle()			
		end
	elseif command=="off" then
		if DynPerfDB.run==1 then
			self:Verbose(0, L.suspend_text)
			self:Toggle()			
		else
			self:Verbose(0, L.suspend_already)
		end
	
	elseif command=="stat" then
		UpdateAddOnMemoryUsage()
		UpdateAddOnCPUUsage()
		self:Verbose(0, "Used Memory: "..self:Round(GetAddOnMemoryUsage("DynamicPerformance"),2).." KiB")
	else 
	-- GENERIC call without any additional parameter..  this should open/hide the mainframe
		if DynamicPerformance:IsVisible() then
			DynamicPerformance:Hide()
			DynPerfDB.hidden = true
		else
			DynamicPerformance:Show()
			DynPerfDB.hidden = false
			self:UpdateFrame(0)			
		end
	end
end



-- =======================================================================================================--


function DynamicPerformanceAce:GetDefaultValues()
	if not DynPerfDB then		-- create defaults
		DynPerfDB = {
			run 			=  1,		-- run on startup
			FPSneeded		= 27,
			hidden		= false
		}
		
		--[[DynPerfDB.timer 		=  3				
		DynPerfDB.Aggro			=  1.5
		DynPerfDB.AggroGap		=  0.1
		DynPerfDB.modifier 		=  0
		DynPerfDB.lastmodifier 	=  0
													-- the actual value				-- min quality	-- max quality
		DynPerfDB.GroundEffectDist 	= { [1]=GetCVar('GroundEffectDist'), 	[2]=25,		[3]=140 	}
		DynPerfDB.FarClip 			= { [1]=GetCVar('FarClip'), 			[2]=220, 	[3]=777 	}
		DynPerfDB.SpellEffectLevel	= { [1]=GetCVar('spellEffectLevel'), 	[2]=5, 		[3]=9 		}
		DynPerfDB.HorizonFarClip	= { [1]=GetCVar('HorizonFarClip'), 		[2]=1305, 	[3]=2112 	}
		DynPerfDB.QualityIndex		= { [1]=5, 								[2]=1, 		[3]=10 		}	
		-- specials:
		DynPerfDB.SmallCull 		= { [1]=GetCVar('SmallCull'), 			[2]=0.1, 	[3]=0.01	}
		DynPerfDB.WeatherDensity 	= { [1]=GetCVar('WeatherDensity'), 		[2]=0, 		[3]=3 		}		]]--	
	end
	self.timer 			=  3				
	self.Aggro			=  1.5
	self.AggroGap		=  0.1
	self.modifier 		=  0
	self.lastmodifier 	=  0
												-- the actual value				-- min quality	-- max quality
	self.GroundEffectDist 	= { [1]=GetCVar('GroundEffectDist'), 	[2]=25,		[3]=140 	}
	self.FarClip 			= { [1]=GetCVar('FarClip'), 			[2]=220, 	[3]=777 	}
	self.SpellEffectLevel	= { [1]=GetCVar('spellEffectLevel'), 	[2]=5, 		[3]=9 		}
	self.HorizonFarClip		= { [1]=GetCVar('HorizonFarClip'), 		[2]=1305, 	[3]=2112 	}
	self.QualityIndex		= { [1]=5, 								[2]=1, 		[3]=10 		}	
	-- specials:
	self.SmallCull 			= { [1]=GetCVar('SmallCull'), 			[2]=0.1, 	[3]=0.01	}
	self.WeatherDensity 	= { [1]=GetCVar('WeatherDensity'), 		[2]=0, 		[3]=3 		}	
end




function DynamicPerformanceAce:VARIABLES_LOADED()		
	local a = self.GroundEffectDist
	self.QualityIndex[1]=(a[1]-a[2]) / (a[3]-a[2]) * (self.QualityIndex[3]-self.QualityIndex[2])
	self:UpdateFrame(0)
	
	-----------------------------------------------
	if DynPerfDB.hidden then
		DynamicPerformance:Hide()
	else
		DynamicPerformance:Show()
	end
	
	if DynPerfDB.run==0 then
		self.Slave:Hide()
	else
		self.Slave:Show()
	end
	----------------------------------------------
		
	-- some special features to bring the GFX-Quality and Performance to maximum (by default)
	SetCVar('UIFaster', 3)
	SetCVar('M2Faster',1)
	ConsoleExec("characterAmbient")
	ConsoleExec("detailDoodadAlpha 100")
	ConsoleExec("SkyCloudLOD 3")
	DynamicPerformance:UnregisterEvent("VARIABLES_LOADED")
	DynamicPerformanceOptionFrameFPS:SetValue(40-DynPerfDB.FPSneeded)
	self:Verbose(0,L.loaded)	
end




-- =======================================================================================================--
--	this function is only called ONCE, on load of the mainframe

function DynamicPerformanceAce:OnLoad()
	this:RegisterEvent("VARIABLES_LOADED")
	this:SetScript("OnEvent", function(this, event, ...)
	    DynamicPerformanceAce[event](DynamicPerformanceAce, ...)
	end)	
	self:InitializeFrames()	
	self:GetDefaultValues()		
end

