﻿-- #####################################################################--
-- 	this file is formated in UTF-8. do NOT change it. 
-- 		utf-8 is not compatible to windows editor. do not open and save this file with wordpad or notepad.
-- 		Best texteditor to view this file: notepad++
--
-- 	DynamicPerformance, written by Kaboom@Arthas(EU), Spring 2008
-- 	--> 	GUI.lua
--		Contains some functions specialy written to manage the GUI and the Configframe of DP
-- #####################################################################--
local self = DynamicPerformanceAce


-- =======================================================================================================--
-- 	InitializeFrames
--	This funktion would set up some frames. its a small replacement for the oversized XML-file
function DynamicPerformanceAce:InitializeFrames()
	-- the slaveframe is runing the timer to update the GFX-config --
	self.Slave = CreateFrame("Frame", "DynamicPerformanceSlave", UIParent)
	self.Slave:SetScript("OnUpdate", function()	self:OnUpdate()	end)	
	
	--[[
	local frame = CreateFrame("Frame", "DynamicTest", UIParent)
	frame:ClearAllPoints()
	frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	frame:RegisterForDrag("LeftButton")
	frame:SetWidth(200)
	frame:SetHeight(170)
	frame:SetClampedToScreen( true )	
	
	frame:SetBackdrop( {
		bgFile = "Interface\DialogFrame\UI-DialogBox-Background",
		edgeFile="Interface\DialogFrame\UI-DialogBox-Border",
		tile=true,	tileSize=32,	edgeSize=32,		
		insets = { left=11, right=12, top=12, bottom=11 }
	})
	frame:SetBackdropBorderColor(1, 1, 1,1)			
	frame:SetBackdropColor(0, 0, 0.2, 1) 	
	frame:Show()
	
	local texture = frame:CreateTexture(frame:GetName().."Header", "ARTWORK")
	texture:SetAllPoints(frame)
	frame.texture=texture;
	self.Mainframe = frame--]]
end



-- =======================================================================================================--
-- 	This function is called by "OnLoad" of the mainframe (DynamicPerformance)
-- 	it would insert some localized strings to the labels
function DynamicPerformanceAce:InsertLocalisation()
	local L = DynamicPerformanceAce.Loc	-- shortcut to localisation
	DynamicPerformanceModifierLbl:SetText(L.Modifier)
	DynamicPerformanceFarClipLbl:SetText(L.FarClip)
	DynamicPerformanceHorizonLbl:SetText(L.HorizonFarClip)
	DynamicPerformanceGroundEffectDistLbL:SetText(L.GroundEffectDist)
	DynamicPerformanceSpellEffectLbl:SetText(L.SpellEffect)
	DynamicPerformanceLbL:SetText(L.AddonName)
	self:SetStartStopButtonText()
	DynamicPerformanceHideBtn:SetText(L.Hide)
end


function DynamicPerformanceAce:SetStartStopButtonText()
	local frame = DynamicPerformanceStateBtn;
	local L = DynamicPerformanceAce.Loc	-- localisation
	if frame then
		if DynPerfDB.run==1 then
			frame:SetText(L.Start)
		else
			frame:SetText(L.Stop)
		end
	end	
end

-- =======================================================================================================--
--	This function is called on update of slaveframe and on toggle.
--	it would insert some values to the display (only if the frame is visible)
function DynamicPerformanceAce:UpdateFrame(modifier)
	if DynPerfDB.hidden then return end
	
	DynamicPerformanceFPS:SetText( 		self:Round(self.FPS,1))		--	self:Round(GetFramerate()
	DynamicPerformanceModifier:SetText( self:Round(modifier,3) )
	DynamicPerformanceFarClip:SetText( 	self:Round(self.FarClip[1],0) )
	DynamicPerformanceHorizon:SetText( 	self:Round(self.HorizonFarClip[1],0) )
	DynamicPerformanceGroundEffectDist:SetText( self:Round(self.GroundEffectDist[1],0) )
	DynamicPerformanceSpellEffect:SetText(	self:Round(self.SpellEffectLevel[1],1) )
	DynamicPerformanceIndex:SetValue( 	self:Round(self.QualityIndex[1],1) )
end


-- =======================================================================================================--
-- 	this function would make some frames movable. 
-- 	its called on load of mainframe (DynamicPerformance) and on load of the OptionFrame (with one vertical slider)
function DynamicPerformanceAce:MakeMovable(frame)
	frame:SetMovable(true)
	frame:EnableMouse(true)	
	frame:SetScript("OnMouseDown",function()
		DynamicPerformance:StartMoving()
	end)
	frame:SetScript("OnMouseUp",function()
		DynamicPerformance:StopMovingOrSizing()
	end)	
	frame:SetScript("OnDragStop",function() 
		DynamicPerformance:StopMovingOrSizing() 
	end)	
end



-- =======================================================================================================--
--	this function creates and draws the tooltip
--	its called by the XML, on mouse over some sliders
--	beware: the tooltip does not get anchored. this is already done by XML before calling this function.
--	parameter textfield: its an array of strings, containing the text of this tooltip
function DynamicPerformanceAce:DrawTooltip(textfield)
	if not textfield then return end
	local color = "|cFFFFFFFF"			-- white title, golden text
	for i, text in pairs(textfield) do
		GameTooltip:AddLine(color..text) 
		color=""						-- reset white titlecolor to default gold
	end						
	GameTooltip:Show()					-- draw the tooltip.
end
