﻿-- #####################################################################--
-- 	this file is formated in UTF-8. do NOT change it. 
-- 		utf-8 is not compatible to windows editor. do not open and save this file with wordpad or notepad.
-- 		Best texteditor to view this file: notepad++
--
-- 	DynamicPerformance, written by Kaboom@Arthas(EU), Spring 2008
-- 	--> 	CORE.lua
--		Contains the main functions of the addon. all its needed to modify the GFX-Settings
-- #####################################################################--
local self = DynamicPerformanceAce
local L = DynamicPerformanceAce.Loc	-- localisation


DynamicPerformanceAce.FPS = 0
DynamicPerformanceAce.modifier = 0
DynamicPerformanceAce.FPSDiff = 0
DynamicPerformanceAce.diff=0

-- =======================================================================================================--
--	GetModifier
--	This Function calculates the next modifier, depending on the actual Frames per sec.
function DynamicPerformanceAce:GetModifier()
	self.FPS=GetFramerate()
	if self.FPS<=1 then return 0 end
	
	self.FPSDiff = self.FPS-DynPerfDB.FPSneeded
	self.modifier= self.FPSDiff^3 / 60			-- cubic depencie
	
	if self.FPSDiff<0 then						-- funny thing... so it would reflex much faster
		self.modifier = self.modifier*2			-- on reduce the quality-settings, than
	end											-- releasing it again
	
	if abs(self.modifier) > self.Aggro then
		-- do NOT let the modifier get too big. it will make the GFX-changes too fast.  --> looks ugly
		self.modifier = self.Aggro * self:Sign(self.modifier)
	end
	
	
	if abs(self.lastmodifier)<abs(self.modifier) then
		self.diff = self.modifier-self.lastmodifier
		if abs(self.diff)>self.AggroGap then
			self.modifier = self.lastmodifier + self.AggroGap * self:Sign(self.diff)
		end
	end
	
	self.lastmodifier = self.modifier
	return self.modifier
end



DynamicPerformanceAce.factor=0
-- =======================================================================================================--
-- 	input: "stat" is a pointer to the stats
--	so its a pointer to the saved variable DynPerfDB.substat
--	eg: DynPerfDB.FarClip ... and this field is a list of 3 doubles.
function DynamicPerformanceAce:GetFactor(stat)
	self.factor = stat[1] + self.modifier*( (stat[3]-stat[2])/100 )
	
	--check for limits
	if self.factor < stat[2] then
		self.factor=stat[2]
	elseif self.factor > stat[3] then
		self.factor=stat[3]
	end
	return self.factor
end



DynamicPerformanceAce.nextstep=0
-- =======================================================================================================--
-- 	this is called each time the slave-frame gets drawed
function DynamicPerformanceAce:OnUpdate()
	if not DynPerfDB or DynPerfDB.run ==0 then return end		-- quit, if addon is suspended
	
	if not arg1 then
		return
	else
		self.timer = self.timer - arg1			-- arg1 contains the passed time since last call
	end
	
	if self.timer > 0 then return end
	
	
	-- its time to calculate the new graphic-settings
	self.modifier = self:GetModifier()	
	self.FarClip[1] 				= self:GetFactor(self.FarClip)
	self.HorizonFarClip[1] 			= self:GetFactor(self.HorizonFarClip)
	self.GroundEffectDist[1]		= self:GetFactor(self.GroundEffectDist)
	self.SpellEffectLevel[1]		= self:GetFactor(self.SpellEffectLevel)
	self.QualityIndex[1] 			= self:GetFactor(self.QualityIndex)
	
	-- limit the new values, if the player visits a battleground
	self:CheckForBattlegroundLimits()
	
	--set the new graphic settings
	SetCVar('FarClip', 			self.FarClip[1] )
	SetCVar('HorizonFarClip',  	self.HorizonFarClip[1] )		
	SetCVar('GroundEffectDist', self.GroundEffectDist[1])
	SetCVar('SpellEffectLevel', self.SpellEffectLevel[1])
	
	if self.QualityIndex[1]<2 then
		self.SmallCull[1]=-0.5*(self.QualityIndex[1]-2)^3
	else
		self.SmallCull[1]=self.SmallCull[3]
	end
	SetCVar('SmallCull',  self.SmallCull[1])
	
	-- there's a strange bug on changing WeatherDensity... it gets foggy for some seconds...
	--self.WeatherDensity[1]=math.floor((self.QualityIndex[1]/4)+1)
	--SetCVar('WeatherDensity',  self.WeatherDensity[1])
	
	
	-- maybe the mainframe is still open. so the player want to see the new stats
	self:UpdateFrame(self.modifier)	-- found in GUI.lua
	
	self.nextstep = 1/GetFramerate()+0.025
	if self.nextstep <0.1 then self.nextstep=0.1 end
	self.timer = self.nextstep
	self.nextstep = nil
end


-- =======================================================================================================--
--	activates and/or deactivates the running process.
-- 	if the addon gets suspended, it would restore the high quality setting again
function DynamicPerformanceAce:Toggle()
	self:SetStartStopButtonText()
	
	if DynPerfDB.run==1 then
		self.timer = 0
		DynPerfDB.run = 0	

		self:RestoreMaxQuality()
		self:UpdateFrame(0)
		self.Slave:Hide()		-- hide the slaveframe, so <OnUpdate> wont get triggered
	else
		self.timer = 0.1
		DynPerfDB.run = 1
		arg1=0					-- i have NO idea why this have to be here. if you comment it out, an error pops up...
		self:OnUpdate()			-- here
		self.Slave:Show()		-- show the slaveframe, start the timer
	end
end



function DynamicPerformanceAce:RestoreMaxQuality()
	self.GroundEffectDist[1] 	= self.GroundEffectDist[3]
	self.FarClip[1] 			= self.FarClip[3]
	self.SpellEffectLevel[1] 	= self.SpellEffectLevel[3]
	self.HorizonFarClip[1] 		= self.HorizonFarClip[3]
	self.QualityIndex[1] 		= self.QualityIndex[3]
	
	SetCVar('FarClip', 			self.FarClip[3] )
	SetCVar('GroundEffectDist', self.GroundEffectDist[3] )
	SetCVar('HorizonFarClip',  	self.HorizonFarClip[3] )
	SetCVar('SpellEffectLevel', self.SpellEffectLevel[3] )
	
	SetCVar('SmallCull', 		self.SmallCull[3] )
	--SetCVar('WeatherDensity',	self.WeatherDensity[3] )
end



DynamicPerformanceAce.BGstat = nil
-- =======================================================================================================--
--	on battlegrounds, its not really usefull to reduce the farclip. 		(you may could not see your enemy!!!)
--	so keep it on an usefull size and do not care about the performance. 	(there are still other options to reduce)
function DynamicPerformanceAce:CheckForBattlegroundLimits()
	self.BGstat = GetNumBattlefieldStats()
	if self.BGstat~=nil and self.BGstat~=0 then	-- you ARE in a battleground
		if self.FarClip[1]<450 then 
			self.FarClip[1] = 450
		end
		if self.HorizonFarClip[1]<1600 then
			self.HorizonFarClip[1]=1600
		end
	end
	self.BGstat=nil
end
	