--[[---------------------------------------------------------------------------------
2.2
- 3.0 changes

2.1
- Fixed a bug with Auctioneer support
- Added AHExtend support

2.0
- Initial TBC release
---------------------------------------------------------------------------------]]


------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- globals
------------------------------------------------------------------------------------------------------------------------
tocVersion = select(4, GetBuildInfo())

DAHIVersion = "2.2";
DAHIDebug = false;
DAHIScaninprogress = false;
DAHIAuctioneerOnOffFlag = true;
DAHITBlau = "|cffffff00";
DAHIHBlau = "|caaaaaa00";
DAHIDBlau = "|cffffffaa";
DAHIIgnorelist = {};
DAHIIgnorelistAll = {};
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- TRANSLATIONS

--------------------------------------------------------------------------------------------------------------------
-- english translation
--------------------------------------------------------------------------------------------------------------------
	DAHIHeader = DAHIDBlau.."-------- DAHI --------";
	DAHILoad = "Duugus action house ignore list loaded "..DAHIVersion;
	DAHICList = "Character list:";
	DAHIGList = "Global list:";
	DAHIAddList = " added to character auction house ignore list.";
	DAHIRemoveList = " removed from character auction house ignore list.";
	DAHIOnList = " is ignored via character list.";
	DAHIAddListAll = " added to global auction house ignore list.";
	DAHIRemoveListAll = " removed from global auction house ignore list.";
	DAHIOnListAll = " is ignored via global character list.";
	DAHIHelp = {DAHITBlau.."DAHI slash commands:", 
			DAHIHBlau.."/dahi help - shows this help", 
			DAHIHBlau.."/dahi list - show your auctions house ignore list", 
			DAHIHBlau.."/dahi PlayerName - adds player \"playername\" to your character auction house ignore list. ", 
			DAHIHBlau.."  Another /dahi PlayerName removes the player from the character list.", 
			DAHIHBlau.."/dahi del - clears the complete auction house ignore list",
			DAHIHBlau.."/dahi auctioneer - turns Actioneer scanning for auctions from ignored players",
			DAHIHBlau.."  on/off (default=on - Actioneer scans auctions from ignored players",
			DAHIHBlau.."To add/remove players via the auction house ui just right click a auction"}; 

	DAHIDel = "Auction house ignore list cleared";
	DAHIAuctionneerOn = "Auctioneer flag set to ON - Auctioneer scans auctions started by ignored playerss";
	DAHIAuctionneerOff = "Auctioneer set to OFF - Auctioneer don't scans auctions started by ignored players";
	DAHIIgnoPlayer = DAHITBlau.."Ignored players:";

	DAHINoAuctionneer = "Auctioneer not installed or not loaded (open auction house first)";
--------------------------------------------------------------------------------------------------------------------
-- german translation
--------------------------------------------------------------------------------------------------------------------
if GetLocale() == "deDE" then
	DAHIHeader = DAHIDBlau.."-------- DAHI --------";
	DAHILoad = "Duugus AH-Ignoreliste geladen "..DAHIVersion;
	DAHICList = "Characterliste:";
	DAHIGList = "Globale List:";
DAHIAddList = " in Char-AH-Ignoreliste eingetragen.";
DAHIRemoveList = " aus Char-Char-AH-Ignoreliste entfernt.";
DAHIAddListAll = " in Gesamt-AH-Ignoreliste eingetragen.";
DAHIRemoveListAll = " aus Gessamt-AH-Ignoreliste entfernt.";
DAHIOnList = " steht auf der Char-AH-Ignoreliste.";
DAHIOnListAll = " steht auf der Gesamt-AH-Ignoreliste.";
	DAHIHelp = {DAHITBlau.."Slashbefehle:", 
			DAHIHBlau.."/dahi hilfe - Zeigt diese Hilfe an.", 
			DAHIHBlau.."/dahi list - zeigt die AH-Ignoreliste an", 
			DAHIHBlau.."/dahi spielername - traegt den Spieler in die Liste ein.", 
			DAHIHBlau.."  mit einem weiteren /dahi Spielername wird der Spieler", 
			DAHIHBlau.."  wieder aus der Liste entfernt.", 
			DAHIHBlau.."/dahi del - loescht alle Eintrag auf der AH-Ignoreliste",
			DAHIHBlau.."/dahi auctioneer - schaltet das Scannen von Auktionen ignorierter Spieler",
			DAHIHBlau.."  durch Actioneer an/aus (Standard=an - Actioneer scannt Auktionen von",
			DAHIHBlau.."  ignorierten Spielern",
			DAHIHBlau.."Alternativ kann ein Spieler mit einem Rechtsklick auf ein", 
			DAHIHBlau.."  Angebot im Auktionshaus in die Liste ein- und ausgetragen", 
			DAHIHBlau.."  werden"};
	DAHIDel = "AH-Ignoreliste geleert";
	DAHIAuctionneerOn = "Auctioneer-Option ist AN - Auctioneer scannt Auktionen von ignorierten Spielern";
	DAHIAuctionneerOff = "Auctioneer-Option ist AUS - Auctioneer scannt keine Auktionen von ignorierten Spielern";
	DAHIIgnoPlayer = DAHITBlau.."Ignorierte Spieler:";
	DAHINoAuctionneer = "Auctioneer ist nicht installiert oder nicht geladen (erst Auktionshaus oeffnen)";
end

--------------------------------------------------------------------------------------------------------------------
-- french translation ... TO DO!!!!
--------------------------------------------------------------------------------------------------------------------
if GetLocale() == "frFR" then
	DAHIHeader = DAHIDBlau.."-------- DAHI --------";
	DAHILoad = "Duugus action house ignore list loaded "..DAHIVersion;
	DAHICList = "Character list:";
	DAHIGList = "Global list:";
	DAHIAddList = " added to character auction house ignore list.";
	DAHIRemoveList = " removed from character auction house ignore list.";
	DAHIOnList = " is ignored via character list.";
	DAHIAddListAll = " added to global auction house ignore list.";
	DAHIRemoveListAll = " removed from global auction house ignore list.";
	DAHIOnListAll = " is ignored via global character list.";
	DAHIHelp = {DAHITBlau.."DAHI slash commands:", 
			DAHIHBlau.."/dahi help - shows this help", 
			DAHIHBlau.."/dahi list - show your auctions house ignore list", 
			DAHIHBlau.."/dahi PlayerName - adds player \"playername\" to your character auction house ignore list. ", 
			DAHIHBlau.."  Another /dahi PlayerName removes the player from the character list.", 
			DAHIHBlau.."/dahi del - clears the complete auction house ignore list",
			DAHIHBlau.."/dahi auctioneer - turns Actioneer scanning for auctions from ignored players",
			DAHIHBlau.."  on/off (default=on - Actioneer scans auctions from ignored players",
			DAHIHBlau.."To add/remove players via the auction house ui just right click a auction"}; 

	DAHIDel = "Auction house ignore list cleared";
	DAHIAuctionneerOn = "Auctioneer flag set to ON - Auctioneer scans auctions started by ignored playerss";
	DAHIAuctionneerOff = "Auctioneer set to OFF - Auctioneer don't scans auctions started by ignored players";
	DAHIIgnoPlayer = DAHITBlau.."Ignored players:";

	DAHINoAuctionneer = "Auctioneer not installed or not loaded (open auction house first)";
end

--------------------------------------------------------------------------------------------------------------------
-- Chinese translation zhCN&zhTW Locale by 急云@CWDG 2008-10-13
--------------------------------------------------------------------------------------------------------------------
if GetLocale() == "zhCN" then
	DAHIHeader = DAHIDBlau.."-------- DAHI --------";
	DAHILoad = "Duugus 拍卖行黑名单已加载: "..DAHIVersion;
	DAHICList = "角色清单:";
	DAHIGList = "全局清单:";
	DAHIAddList = " 添加到角色拍卖行黑名单.";
	DAHIRemoveList = " 从角色拍卖行黑名单移除.";
	DAHIOnList = " 处于黑名单中.";
	DAHIAddListAll = " 添加到拍卖行全局黑名单.";
	DAHIRemoveListAll = " 从拍卖行全局黑名单移除.";
	DAHIOnListAll = " 该角色处于全局黑名单中.";
	DAHIHelp = {DAHITBlau.."DAHI 命令行:",
			DAHIHBlau.."/dahi help - 显示帮助",
			DAHIHBlau.."/dahi list - 显示拍卖行黑名单",
			DAHIHBlau.."/dahi PlayerName - 添加 \"playername\" 名称的玩家到角色拍卖行黑名单",
			DAHIHBlau.."  再次输入 /dahi PlayerName 则可以将这个玩家拍卖行黑名单内移除",
			DAHIHBlau.."/dahi del - 清空拍卖行黑名单",
			DAHIHBlau.."/dahi auctioneer - 拍卖助手扫描中过滤掉拍卖行黑名单的玩家拍卖项",
			DAHIHBlau.."  on/off (默认:on - 使用 拍卖助手 扫描时 过滤拍卖行黑名单的玩家拍卖项",
			DAHIHBlau.."在拍卖行界面右击拍卖项 添加/移除 拍卖行黑名单"};

	DAHIDel = "拍卖行黑名单已清除";
	DAHIAuctionneerOn = "**打开**拍卖行标记 - 使 Auctioneer 扫描中使用拍卖行黑名单";
	DAHIAuctionneerOff = "**关闭**拍卖行标记 - 使 Auctioneer 扫描中忽略拍卖行黑名单";
	DAHIIgnoPlayer = DAHITBlau.."黑名单玩家:";

	DAHINoAuctionneer = "拍卖助手 Auctioneer 未安装或未加载 (请先打开拍卖行界面)";

elseif GetLocale() == "zhTW" then
	DAHIHeader = DAHIDBlau.."-------- DAHI --------";
	DAHILoad = "Duugus 拍賣行黑名單已載入: "..DAHIVersion;
	DAHICList = "角色清單:";
	DAHIGList = "全域清單:";
	DAHIAddList = " 添加到角色拍賣行黑名單.";
	DAHIRemoveList = " 從角色拍賣行黑名單移除.";
	DAHIOnList = " 處於黑名單中.";
	DAHIAddListAll = " 添加到拍賣行全域黑名單.";
	DAHIRemoveListAll = " 從拍賣行全域黑名單移除.";
	DAHIOnListAll = " 該角色處於全域黑名單中.";
	DAHIHelp = {DAHITBlau.."DAHI 命令列:",
			DAHIHBlau.."/dahi help - 顯示説明",
			DAHIHBlau.."/dahi list - 顯示拍賣行黑名單",
			DAHIHBlau.."/dahi PlayerName - 添加 \"playername\" 名稱的玩家到角色拍賣行黑名單",
			DAHIHBlau.."  再次輸入 /dahi PlayerName 則可以將這個玩家拍賣行黑名單內移除",
			DAHIHBlau.."/dahi del - 清空拍賣行黑名單",
			DAHIHBlau.."/dahi auctioneer - 拍賣助手掃描中過濾掉拍賣行黑名單的玩家拍賣項",
			DAHIHBlau.."  on/off (默認:on - 使用 拍賣助手 掃描時 過濾拍賣行黑名單的玩家拍賣項",
			DAHIHBlau.."在拍賣行介面右擊拍賣項 添加/移除 拍賣行黑名單"};

	DAHIDel = "拍賣行黑名單已清除";
	DAHIAuctionneerOn = "**打開**拍賣行標記 - 使 Auctioneer 掃描中使用拍賣行黑名單";
	DAHIAuctionneerOff = "**關閉**拍賣行標記 - 使 Auctioneer 掃描中忽略拍賣行黑名單";
	DAHIIgnoPlayer = DAHITBlau.."黑名單玩家:";

	DAHINoAuctionneer = "拍賣助手 Auctioneer 未安裝或未載入 (請先打開拍賣行介面)";
end


------------------------------------------------------------------------------------------------------------------------
-- guess what :)
------------------------------------------------------------------------------------------------------------------------
function DuuguAuctionFrame_OnLoad()
	DEFAULT_CHAT_FRAME:AddMessage(DAHILoad);
	SLASH_DAHI1 = "/ahi";
	SLASH_DAHI2 = "/dahi";
	SlashCmdList["DAHI"] = DAHISlash;
end
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- Hook for BrowseButton_OnClick() - prevents selection of actions from ignored sellers an handles right click to
-- add/remove sellers to the ignore list
------------------------------------------------------------------------------------------------------------------------
function DuuguBrowseButton_OnClick(button)
	button = this;
	if button then
		if string.find(button:GetName(), "Item") then
			button = getglobal(string.sub(button:GetName(), 1, 13));
		end
	end

	-- right button ... add/remove seller 
	if arg1 == "RightButton" then
		if button then
			if string.find(button:GetName(), "Item") then
				button = getglobal(string.sub(button:GetName(), 1, 13));
			end
		end

		obj = getglobal("BrowseButton"..button:GetID().."HighBidder");
		cmd = obj:GetText();
		if DAHIIgnorelist[cmd] == Nil and DAHIIgnorelistAll[cmd] == Nil then
			table.insert(DAHIIgnorelist, cmd);
			DAHIIgnorelist[cmd] = cmd;
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[cmd]..DAHIAddList);
			if BrowseBidButton then
				BrowseBidButton:Disable();
				BrowseBuyoutButton:Disable();
			end
		elseif DAHIIgnorelist[cmd] == cmd then
				local deltmp = Nil;
				for x = 1, getn(DAHIIgnorelist), 1 do
					if DAHIIgnorelist[DAHIIgnorelist[x]] == cmd then
						deltmp = x;	
					end
				end
				if deltmp ~= Nil then
					DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[DAHIIgnorelist[deltmp]]..DAHIRemoveList);
					DAHIIgnorelist[DAHIIgnorelist[deltmp]] = Nil;
					table.remove(DAHIIgnorelist, deltmp );
				end

				table.insert(DAHIIgnorelistAll, cmd);
				DAHIIgnorelistAll[cmd] = cmd;
				DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelistAll[cmd]..DAHIAddListAll);
				if BrowseBidButton then
					BrowseBidButton:Disable();
					BrowseBuyoutButton:Disable();
				end
		elseif DAHIIgnorelistAll[cmd] == cmd then
				local deltmp = Nil;
				for x = 1, getn(DAHIIgnorelistAll), 1 do
					if DAHIIgnorelistAll[DAHIIgnorelistAll[x]] == cmd then
						deltmp = x;	
					end
				end
				if deltmp ~= Nil then
					DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelistAll[DAHIIgnorelistAll[deltmp]]..DAHIRemoveListAll);
					DAHIIgnorelistAll[DAHIIgnorelistAll[deltmp]] = Nil;
					table.remove(DAHIIgnorelistAll, deltmp );
				end
		end
	end

	-- get seller name and test if seller is ignored
	if button then
		if string.find(button:GetName(), "Item") then
			button = getglobal(string.sub(button:GetName(), 1, 13));
		end
	end

	obj = getglobal("BrowseButton"..button:GetID().."HighBidder");

	local ign = false;
	local ignAll = false;
	for x = 1, getn(DAHIIgnorelist), 1 do
		if string.upper(obj:GetText()) == string.upper(DAHIIgnorelist[x]) then
			ign = true;
		end
	end
	for x = 1, getn(DAHIIgnorelistAll), 1 do
		if string.upper(obj:GetText()) == string.upper(DAHIIgnorelistAll[x]) then
			ignAll = true;
		end
	end

	if ign == false and ignAll == false then
		-- original BrowseButton_OnClick code ... just select the auction
		SetSelectedAuctionItem("list", button:GetID() + FauxScrollFrame_GetOffset(BrowseScrollFrame));
		AuctionFrameBrowse_Update();
	else
		-- seller is ignored ... don't select and disable bid/buy buttons
		AuctionFrameBrowse_Update();
		BrowseBidButton:Disable();
		BrowseBuyoutButton:Disable();
		if ign == true then
			DEFAULT_CHAT_FRAME:AddMessage(obj:GetText()..DAHIOnList);
		end
		if ignAll == true then
			DEFAULT_CHAT_FRAME:AddMessage(obj:GetText()..DAHIOnListAll);
		end
	end
end
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- handle slash commands
------------------------------------------------------------------------------------------------------------------------
function DAHISlash(cmd)
	local Text = "";
	local Pars = {};
	local cmdo = cmd;

	if cmd == "hilfe" or cmd == "?" or cmd == "help" or cmd == Nil or cmd == "" then
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
		for x = 1, getn(DAHIHelp), 1 do
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHelp[x]);
		end
		return;
	elseif cmd == "list" then
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
		DEFAULT_CHAT_FRAME:AddMessage(DAHIIgnoPlayer);
	

		DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHICList); 
		for x = 1, getn(DAHIIgnorelist), 1 do
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[x]);
		end
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIGList); 
		for x = 1, getn(DAHIIgnorelist), 1 do
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[x]);
		end
		if DAHIAuctioneerOnOffFlag == true and Auctioneer then
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIAuctionneerOn);
		elseif DAHIAuctioneerOnOffFlag == false and Auctioneer then
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIAuctionneerOff);
		end
	elseif cmd == "del" then
		DAHIIgnorelist = {};
		DAHIIgnorelistAll = {};
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIDel);
	elseif cmd == "auctioneer" or cmd == "Auctioneer" then
		if Auctioneer then
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
			if DAHIAuctioneerOnOffFlag == true then
				DAHIAuctioneerOnOffFlag = false;
				DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIAuctionneerOff);
			elseif DAHIAuctioneerOnOffFlag == false then
				DAHIAuctioneerOnOffFlag = true;
				DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIAuctionneerOn);
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHINoAuctionneer);
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage(DAHIHeader);
		if DAHIIgnorelist[cmd] == Nil then
			table.insert(DAHIIgnorelist, cmd);
			DAHIIgnorelist[cmd] = cmd;
			DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[cmd]..DAHIAddList);
			if BrowseBidButton then
				BrowseBidButton:Disable();
				BrowseBuyoutButton:Disable();
			end
		else
			for x = 1, getn(DAHIIgnorelist), 1 do
				if DAHIIgnorelist[cmd] == cmd then
					DEFAULT_CHAT_FRAME:AddMessage(DAHIHBlau..DAHIIgnorelist[cmd]..DAHIRemoveList);
					DAHIIgnorelist[cmd] = Nil;
					table.remove(DAHIIgnorelist, x);
				end
			end
		end
	end
end
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- Hook for AuctionFrameBrowse_Update() to display ignored sellers in red
------------------------------------------------------------------------------------------------------------------------
function DAHIAuctionFrameBrowse_Update()

	if DAHIDebug == true then
		DEFAULT_CHAT_FRAME:AddMessage("dahi update");
	end

	-- call original AuctionFrameBrowse_Update() just in case ...
	DAHIOldAuctionFrameBrowse_Update();

----------------------------------------------------------------
-- start of original code from blizz ui
----------------------------------------------------------------
	if tocVersion >= 30000 then
		local numBatchAuctions, totalAuctions = GetNumAuctionItems("list");
		local button, buttonName, iconTexture, itemName, color, itemCount, moneyFrame, buyoutFrame, buyoutMoney, buttonHighlight;
		local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);
		local index;
		local isLastSlotEmpty;
		local name, texture, count, quality, canUse, minBid, minIncrement, buyoutPrice, duration, bidAmount, highBidder, owner;
		local displayedPrice, requiredBid;
		BrowseBidButton:Disable();
		BrowseBuyoutButton:Disable();
		-- Update sort arrows
		AuctionFrameBrowse_UpdateArrows();
	
		-- Show the no results text if no items found
		if ( numBatchAuctions == 0 ) then
			BrowseNoResultsText:Show();
		else
			BrowseNoResultsText:Hide();
		end
	
		for i=1, NUM_BROWSE_TO_DISPLAY do
			index = offset + i + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page);
			button = getglobal("BrowseButton"..i);
			-- Show or hide auction buttons
			if ( index > (numBatchAuctions + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page)) ) then
				button:Hide();
				-- If the last button is empty then set isLastSlotEmpty var
				if ( i == NUM_BROWSE_TO_DISPLAY ) then
					isLastSlotEmpty = 1;
				end
			else
				button:Show();
	
				buttonName = "BrowseButton"..i;
				name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner =  GetAuctionItemInfo("list", offset + i);
				if ( not name ) then	--Bug  145328
					button:Hide();
					-- If the last button is empty then set isLastSlotEmpty var
					if ( i == NUM_BROWSE_TO_DISPLAY ) then
						isLastSlotEmpty = 1;
					end
				end
				duration = GetAuctionItemTimeLeft("list", offset + i);
	
				-- Resize button if there isn't a scrollbar
				buttonHighlight = getglobal("BrowseButton"..i.."Highlight");
				if ( numBatchAuctions < NUM_BROWSE_TO_DISPLAY ) then
					button:SetWidth(625);
					buttonHighlight:SetWidth(589);
					BrowseCurrentBidSort:SetWidth(207);
				elseif ( numBatchAuctions == NUM_BROWSE_TO_DISPLAY and totalAuctions <= NUM_BROWSE_TO_DISPLAY ) then
					button:SetWidth(625);
					buttonHighlight:SetWidth(589);
					BrowseCurrentBidSort:SetWidth(207);
				else
					button:SetWidth(600);
					buttonHighlight:SetWidth(562);
					BrowseCurrentBidSort:SetWidth(184);
				end
				-- Set name and quality color
				color = ITEM_QUALITY_COLORS[quality];
				itemName = getglobal(buttonName.."Name");
				itemName:SetText(name);
				itemName:SetVertexColor(color.r, color.g, color.b);
				-- Set level
				if ( level > UnitLevel("player") ) then
					getglobal(buttonName.."Level"):SetText(RED_FONT_COLOR_CODE..level..FONT_COLOR_CODE_CLOSE);
				else
					getglobal(buttonName.."Level"):SetText(level);
				end
				-- Set closing time
				getglobal(buttonName.."ClosingTimeText"):SetText(AuctionFrame_GetTimeLeftText(duration));
				getglobal(buttonName.."ClosingTime").tooltip = AuctionFrame_GetTimeLeftTooltipText(duration);
				-- Set item texture, count, and usability
				iconTexture = getglobal(buttonName.."ItemIconTexture");
				iconTexture:SetTexture(texture);
				if ( not canUse ) then
					iconTexture:SetVertexColor(1.0, 0.1, 0.1);
				else
					iconTexture:SetVertexColor(1.0, 1.0, 1.0);
				end
				itemCount = getglobal(buttonName.."ItemCount");
				if ( count > 1 ) then
					itemCount:SetText(count);
					itemCount:Show();
				else
					itemCount:Hide();
				end
				-- Set high bid
				moneyFrame = getglobal(buttonName.."MoneyFrame");
				-- If not bidAmount set the bid amount to the min bid
				if ( bidAmount == 0 ) then
					displayedPrice = minBid;
					requiredBid = minBid;
				else
					displayedPrice = bidAmount;
					requiredBid = bidAmount + minIncrement ;
				end
				MoneyFrame_Update(moneyFrame:GetName(), displayedPrice);
	
				yourBidText = getglobal(buttonName.."YourBidText");
				if ( highBidder ) then
					yourBidText:Show();
				else
					yourBidText:Hide();
				end
				
				if ( requiredBid >= MAXIMUM_BID_PRICE ) then
					-- Lie about our buyout price
					buyoutPrice = requiredBid;
				end
				buyoutFrame = getglobal(buttonName.."BuyoutFrame");
				if ( buyoutPrice > 0 ) then
					moneyFrame:SetPoint("RIGHT", button, "RIGHT", 10, 10);
					buyoutMoney = getglobal(buyoutFrame:GetName().."Money");
					MoneyFrame_Update(buyoutMoney, buyoutPrice);
					buyoutFrame:Show();
				else
					moneyFrame:SetPoint("RIGHT", button, "RIGHT", 10, 3);
					buyoutFrame:Hide();
				end
				-- Set high bidder
				--if ( not highBidder ) then
				--	highBidder = RED_FONT_COLOR_CODE..NO_BIDS..FONT_COLOR_CODE_CLOSE;
				--end
				getglobal(buttonName.."HighBidder"):SetText(owner);
	
				button.bidAmount = displayedPrice;
				button.buyoutPrice = buyoutPrice;
				button.itemCount = count;
	
	
	
	
	
				------------------------------------------------------------------------------
				-- added this part to set text color for seller name to red if seller is ignored
	
				local ign = false;
				for x = 1, getn(DAHIIgnorelist), 1 do
					if owner then
						if string.upper(owner) == string.upper(DAHIIgnorelist[x]) then
							ign = true;
						end
					end
				end
				if ign == true then
					getglobal(buttonName.."HighBidder"):SetTextColor(255, 0, 0);
				end
	
				local ignAll = false;
				for x = 1, getn(DAHIIgnorelistAll), 1 do
					if owner then
						if string.upper(owner) == string.upper(DAHIIgnorelistAll[x]) then
							ignAll = true;
						end
					end
				end
				if ignAll == true then
					getglobal(buttonName.."HighBidder"):SetTextColor(0, 0, 255);
				end
	
				if ign == false and ignAll == false then
					getglobal(buttonName.."HighBidder"):SetTextColor(255, 255, 255);
				end
				------------------------------------------------------------------------------
	
	
	
	
				-- Set highlight
				if ( GetSelectedAuctionItem("list") and (offset + i) == GetSelectedAuctionItem("list") ) then
					button:LockHighlight();
					
					if ( buyoutPrice > 0 and buyoutPrice >= minBid ) then
						local canBuyout = 1;
						if ( GetMoney() < buyoutPrice ) then
							if ( not highBidder or GetMoney()+bidAmount < buyoutPrice ) then
								canBuyout = nil;
							end
						end
						if ( canBuyout ) then
							BrowseBuyoutButton:Enable();
							AuctionFrame.buyoutPrice = buyoutPrice;
						end
					else
						AuctionFrame.buyoutPrice = nil;
					end
					-- Set bid
					MoneyInputFrame_SetCopper(BrowseBidPrice, requiredBid);
	
					if ( not highBidder and owner ~= UnitName("player") and GetMoney() >= MoneyInputFrame_GetCopper(BrowseBidPrice) and MoneyInputFrame_GetCopper(BrowseBidPrice) <= MAXIMUM_BID_PRICE ) then
						BrowseBidButton:Enable();
					end
				else
					button:UnlockHighlight();
				end
			end
		end
	
		-- Update scrollFrame
		-- If more than one page of auctions show the next and prev arrows when the scrollframe is scrolled all the way down
		if ( totalAuctions > NUM_AUCTION_ITEMS_PER_PAGE ) then
			if ( isLastSlotEmpty ) then
				BrowsePrevPageButton:Show();
				BrowseNextPageButton:Show();
				BrowseSearchCountText:Show();
				local itemsMin = AuctionFrameBrowse.page * NUM_AUCTION_ITEMS_PER_PAGE + 1;
				local itemsMax = itemsMin + numBatchAuctions - 1;
				BrowseSearchCountText:SetFormattedText(NUMBER_OF_RESULTS_TEMPLATE, itemsMin, itemsMax, totalAuctions);
				if ( AuctionFrameBrowse.page == 0 ) then
					BrowsePrevPageButton.isEnabled = nil;
				else
					BrowsePrevPageButton.isEnabled = 1;
				end
				if ( AuctionFrameBrowse.page == (ceil(totalAuctions/NUM_AUCTION_ITEMS_PER_PAGE) - 1) ) then
					BrowseNextPageButton.isEnabled = nil;
				else
					BrowseNextPageButton.isEnabled = 1;
				end
			else
				BrowsePrevPageButton:Hide();
				BrowseNextPageButton:Hide();
				BrowseSearchCountText:Hide();
			end
			
			-- Artifically inflate the number of results so the scrollbar scrolls one extra row
			numBatchAuctions = numBatchAuctions + 1;
		else
			BrowsePrevPageButton:Hide();
			BrowseNextPageButton:Hide();
			BrowseSearchCountText:Hide();
		end
		FauxScrollFrame_Update(BrowseScrollFrame, numBatchAuctions, NUM_BROWSE_TO_DISPLAY, AUCTIONS_BUTTON_HEIGHT);
	else
		local numBatchAuctions, totalAuctions = GetNumAuctionItems("list");
		local button, buttonName, iconTexture, itemName, color, itemCount, moneyFrame, buyoutMoneyFrame, buyoutText, buttonHighlight;
		local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);
		local index;
		local isLastSlotEmpty;
		local name, texture, count, quality, canUse, minBid, minIncrement, buyoutPrice, duration, bidAmount, highBidder, owner;
		BrowseBidButton:Disable();
		BrowseBuyoutButton:Disable();
		-- Update sort arrows
		SortButton_UpdateArrow(BrowseQualitySort, "list", "quality");
		SortButton_UpdateArrow(BrowseLevelSort, "list", "level");
		SortButton_UpdateArrow(BrowseDurationSort, "list", "duration");
		SortButton_UpdateArrow(BrowseHighBidderSort, "list", "status");
		SortButton_UpdateArrow(BrowseCurrentBidSort, "list", "bid");
	
		-- Show the no results text if no items found
		if ( numBatchAuctions == 0 ) then
			BrowseNoResultsText:Show();
		else
			BrowseNoResultsText:Hide();
		end
	
		for i=1, NUM_BROWSE_TO_DISPLAY do
			index = offset + i + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page);
			button = getglobal("BrowseButton"..i);
			-- Show or hide auction buttons
			if ( index > (numBatchAuctions + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page)) ) then
				button:Hide();
				-- If the last button is empty then set isLastSlotEmpty var
				if ( i == NUM_BROWSE_TO_DISPLAY ) then
					isLastSlotEmpty = 1;
				end
			else
				button:Show();
	
				buttonName = "BrowseButton"..i;
				name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner =  GetAuctionItemInfo("list", offset + i);
	
	
				duration = GetAuctionItemTimeLeft("list", offset + i);
				-- Resize button if there isn't a scrollbar
				buttonHighlight = getglobal("BrowseButton"..i.."Highlight");
				if ( numBatchAuctions < NUM_BROWSE_TO_DISPLAY ) then
					button:SetWidth(557);
					buttonHighlight:SetWidth(523);
					BrowseCurrentBidSort:SetWidth(173);
				else
					button:SetWidth(532);
					buttonHighlight:SetWidth(502);
					BrowseCurrentBidSort:SetWidth(157);
				end
				-- Set name and quality color
				color = ITEM_QUALITY_COLORS[quality];
				itemName = getglobal(buttonName.."Name");
				itemName:SetText(name);
				itemName:SetVertexColor(color.r, color.g, color.b);
				-- Set level
				if ( level > UnitLevel("player") ) then
					getglobal(buttonName.."Level"):SetText(RED_FONT_COLOR_CODE..level..FONT_COLOR_CODE_CLOSE);
				else
					getglobal(buttonName.."Level"):SetText(level);
				end
				-- Set closing time
				getglobal(buttonName.."ClosingTimeText"):SetText(AuctionFrame_GetTimeLeftText(duration));
				getglobal(buttonName.."ClosingTime").tooltip = AuctionFrame_GetTimeLeftTooltipText(duration);
				-- Set item texture, count, and usability
				iconTexture = getglobal(buttonName.."ItemIconTexture");
				iconTexture:SetTexture(texture);
				if ( not canUse ) then
					iconTexture:SetVertexColor(1.0, 0.1, 0.1);
				else
					iconTexture:SetVertexColor(1.0, 1.0, 1.0);
				end
				itemCount = getglobal(buttonName.."ItemCount");
				if ( count > 1 ) then
					itemCount:SetText(count);
					itemCount:Show();
				else
					itemCount:Hide();
				end
				-- Set high bid
				moneyFrame = getglobal(buttonName.."MoneyFrame");
				yourBidText = getglobal(buttonName.."YourBidText");
				buyoutMoneyFrame = getglobal(buttonName.."BuyoutMoneyFrame");
				buyoutText = getglobal(buttonName.."BuyoutText");
				-- If not bidAmount set the bid amount to the min bid
				if ( bidAmount == 0 ) then
					MoneyFrame_Update(moneyFrame:GetName(), minBid);
				else
					MoneyFrame_Update(moneyFrame:GetName(), bidAmount);
				end
	
				if ( highBidder ) then
					yourBidText:Show();
				else
					yourBidText:Hide();
				end
	
				if ( buyoutPrice > 0 ) then
					moneyFrame:SetPoint("RIGHT", buttonName, "RIGHT", 60, 10);
					MoneyFrame_Update(buyoutMoneyFrame:GetName(), buyoutPrice);
					buyoutMoneyFrame:Show();
					buyoutText:Show();
				else
					moneyFrame:SetPoint("RIGHT", buttonName, "RIGHT", 60, 3);
					buyoutMoneyFrame:Hide();
					buyoutText:Hide();
				end
				-- Set high bidder
				--if ( not highBidder ) then
				--	highBidder = RED_FONT_COLOR_CODE..NO_BIDS..FONT_COLOR_CODE_CLOSE;
				--end
	
	
				getglobal(buttonName.."HighBidder"):SetText(owner);
	
	
	
	
				------------------------------------------------------------------------------
				-- added this part to set text color for seller name to red if seller is ignored
	
				local ign = false;
				for x = 1, getn(DAHIIgnorelist), 1 do
					if owner then
						if string.upper(owner) == string.upper(DAHIIgnorelist[x]) then
							ign = true;
						end
					end
				end
				if ign == true then
					getglobal(buttonName.."HighBidder"):SetTextColor(255, 0, 0);
				end
	
				local ignAll = false;
				for x = 1, getn(DAHIIgnorelistAll), 1 do
					if owner then
						if string.upper(owner) == string.upper(DAHIIgnorelistAll[x]) then
							ignAll = true;
						end
					end
				end
				if ignAll == true then
					getglobal(buttonName.."HighBidder"):SetTextColor(0, 0, 255);
				end
	
				if ign == false and ignAll == false then
					getglobal(buttonName.."HighBidder"):SetTextColor(255, 255, 255);
				end
				------------------------------------------------------------------------------
	
	
	
	
				-- Set highlight
				if ( GetSelectedAuctionItem("list") and (offset + i) == GetSelectedAuctionItem("list") ) then
					button:LockHighlight();
					
					if ( buyoutPrice > 0 and buyoutPrice >= minBid and GetMoney() >= buyoutPrice ) then
						BrowseBuyoutButton:Enable();
						AuctionFrame.buyoutPrice = buyoutPrice;
					else
						AuctionFrame.buyoutPrice = nil;
					end
					-- Set bid
					if ( bidAmount > 0 ) then
						bidAmount = bidAmount + minIncrement ;
						MoneyInputFrame_SetCopper(BrowseBidPrice, bidAmount);
					else
						MoneyInputFrame_SetCopper(BrowseBidPrice, minBid);
					end
	
					if ( not highBidder and GetMoney() >= MoneyInputFrame_GetCopper(BrowseBidPrice) ) then
						BrowseBidButton:Enable();
					end
				else
					button:UnlockHighlight();
				end
			end
		end
	
		-- Update scrollFrame
		-- If more than one page of auctions show the next and prev arrows when the scrollframe is scrolled all the way down
		if ( totalAuctions > NUM_AUCTION_ITEMS_PER_PAGE ) then
			if ( isLastSlotEmpty ) then
				BrowsePrevPageButton:Show();
				BrowseNextPageButton:Show();
				BrowseSearchCountText:Show();
				local itemsMin = AuctionFrameBrowse.page * NUM_AUCTION_ITEMS_PER_PAGE + 1;
				local itemsMax = itemsMin + numBatchAuctions - 1;
				BrowseSearchCountText:SetText(format(NUMBER_OF_RESULTS_TEMPLATE, itemsMin, itemsMax, totalAuctions ));
				if ( AuctionFrameBrowse.page == 0 ) then
					BrowsePrevPageButton.isEnabled = nil;
				else
					BrowsePrevPageButton.isEnabled = 1;
				end
				if ( AuctionFrameBrowse.page == (ceil(totalAuctions/NUM_AUCTION_ITEMS_PER_PAGE) - 1) ) then
					BrowseNextPageButton.isEnabled = nil;
				else
					BrowseNextPageButton.isEnabled = 1;
				end
			else
				BrowsePrevPageButton:Hide();
				BrowseNextPageButton:Hide();
				BrowseSearchCountText:Hide();
			end
			
			-- Artifically inflate the number of results so the scrollbar scrolls one extra row
			numBatchAuctions = numBatchAuctions + 1;
		else
			BrowsePrevPageButton:Hide();
			BrowseNextPageButton:Hide();
			BrowseSearchCountText:Hide();
		end
		FauxScrollFrame_Update(BrowseScrollFrame, numBatchAuctions, NUM_BROWSE_TO_DISPLAY, AUCTIONS_BUTTON_HEIGHT);	
	end
----------------------------------------------------------------
-- end of original code
----------------------------------------------------------------
end
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
-- hook for GetAuctionItemInfo() to return Nil instead itemname if seller is ignored and actioneer is scanning 
-- prevents actioneer from scanning auctions from ignored sellers
------------------------------------------------------------------------------------------------------------------------
function DAHIGetAuctionItemInfo(type, offset)
	name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner =  DAHIOldGetAuctionItemInfo(type, offset);
	local ign = false;
	for x = 1, getn(DAHIIgnorelist), 1 do
		if owner then
			if string.upper(owner) == string.upper(DAHIIgnorelist[x]) then
				ign = true;
			end
		end
	end
	if ign == false then
		return name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner;
	else

	
		if Auctioneer then
			if Auctioneer.ScanManager then
				if (Auctioneer.ScanManager.IsScanning()) then
					DAHIScaninprogress = true;
				else
					DAHIScaninprogress = false;
				end
			end
		end			
	
	
		if DAHIScaninprogress == false then
			if DAHIDebug == true then
				DEFAULT_CHAT_FRAME:AddMessage("GetAction no scan "..name.." "..owner);
			end
			return name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner;
		else
			if DAHIAuctioneerOnOffFlag == false then
				if DAHIDebug == true then
					DEFAULT_CHAT_FRAME:AddMessage("GetAction scan return Nil "..name.." "..owner);
				end
				return Nil, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner;
			else
				if DAHIDebug == true then
					DEFAULT_CHAT_FRAME:AddMessage("GetAction scan return name "..name.." "..owner);
				end
				return name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner;
			end
		end
	end
end