local DIS = CreateFrame("frame")
DIS:RegisterEvent("ADDON_LOADED")
DIS:RegisterEvent("UPDATE_SHAPESHIFT_FORM")
DIS:SetScript("OnEvent", function(self, event, ...) self[event](self,...) end)

local options = {
    ["innervate"] = {
        desc = function(self) return format("Set a weapon to swap for innervate %s",(DIS_Saved[29166][16] ~= "" and "[currently: "..DIS_Saved[29166][16].."]") or "") end,
        func = function(self)
            StaticPopup_Show("DIS_INNERVATESELECTING")
            OpenAllBags(true)
            if (not PaperDollFrame:IsVisible()) then
                ToggleCharacter("PaperDollFrame")
            end
            self.Selecting = true
        end, 
    },
    ["innervateoff"] = {
        desc = function(self) return "Clear your innervate swap" end,
        func = function(self)
            DIS_Saved[29166][16] = ""
            self:Msg("Your innervate swap has successfully been cleared.")
        end, 
    },
    ["flightswap"] = {
        desc = function(self) return format("Toggle flight swap [%s]",(DIS_Saved[40120] and "|cFF33FF33on|r") or "|cFFFF0000off|r") end,
        func = function(self)
            if (DIS_Saved[40120]) then
                DIS_Saved[40120] = nil
                self:Msg("Flight swapping disabled.")
            else
                DIS_Saved[40120] = { [13] = GetItemInfo(32481) }
                self:Msg("Flight swapping enabled.")
            end    
        end, 
    },
}
StaticPopupDialogs["DIS_INNERVATESELECTING"] = {
	text = "Please click the item you wish to swap for innervate.",
	button1 = CANCEL,
    timeout = 0,
    OnAccept = function() 
        DIS.Selecting = nil
        HideUIPanel(CharacterFrame)
        CloseAllBags()
    end
}
local wotlk = select(4,GetBuildInfo()) >= 30000

function DIS:SlashHandler(msg)
    local cmd = string.lower(msg)
    if (options[cmd]) then
        (options[cmd]).func(self)
        return
    end
    DEFAULT_CHAT_FRAME:AddMessage("DruidItemSwap Options (/dis [option])")
    for i in pairs(options) do
        DEFAULT_CHAT_FRAME:AddMessage(format("  |cFFFFFF33%s|r : %s",i,(options[i]).desc(self)))
    end
end

function DIS:COMBAT_LOG_EVENT_UNFILTERED(...)
    local _,event,_,_,_,_,destName,_,spellID = ...
    if (destName == UnitName("player")) then
        if (event == "SPELL_AURA_APPLIED") then
            if (DIS_Saved[spellID]) then
                if (not DIS_Saved.Originals[spellID]) then
                    DIS_Saved.Originals[spellID] = { }
                end
                for i in pairs(DIS_Saved[spellID]) do
                    if (not DIS_Saved.Originals[spellID] or DIS_Saved.Originals[spellID][i] ~= DIS_Saved[spellID][i]) then
                        DIS_Saved.Originals[spellID][i] = GetItemInfo(GetInventoryItemLink("player",i) or "")
                    end
                    self:EquipItemByName(DIS_Saved[spellID][i],i)
                end
            end
        elseif (event == "SPELL_AURA_REMOVED") then
            if (DIS_Saved.Originals[spellID] and not UnitCastingInfo("player")) then
                self:RestoreOriginals(spellID)
            end
        elseif (event == "SPELL_CAST_SUCCESS") then
            self:CheckOriginals()
        end
    end
end

function DIS:ADDON_LOADED(addon)
    if (addon == "DruidItemSwap") then
        if (select(2,UnitClass("player")) == "DRUID") then
            -- Default saved variables
            if (not DIS_Saved) then
                DIS_Saved = { [29166] = { [16] = "", [17] = "" }, [40120] = { [13] = GetItemInfo(32481) }, Originals = { } }
            end
            
            -- Register events
            self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
     
            -- Slash command
            SlashCmdList["DRUIDITEMSWAP"] = function(msg) DIS:SlashHandler(msg) end
            SLASH_DRUIDITEMSWAP1 = "/dis"
            SLASH_DRUIDITEMSWAP2 = "/druiditemswap"
            
            -- Hook for use of selecting innervate weapon
            hooksecurefunc("PickupContainerItem",function(bag,slot)
                local item = GetContainerItemLink(bag,slot)
                if (DIS.Selecting and item) then
                    DIS:CheckInnervateItem(item)
                end 
            end)
            hooksecurefunc("PickupInventoryItem",function(slot)
                local item = GetInventoryItemLink("player",slot)
                if (DIS.Selecting and item) then
                    DIS:CheckInnervateItem(item)
                end            
            end)
        end        
        self:UnregisterEvent("ADDON_LOADED")
    end
end

function DIS:UPDATE_SHAPESHIFT_FORM()
    self:CheckOriginals()
end

function DIS:CheckInnervateItem(link)
    ClearCursor()
    local equiploc = select(9,GetItemInfo(link))
    if (equiploc == "INVTYPE_2HWEAPON" or equiploc == "INVTYPE_WEAPONMAINHAND" or equiploc == "INVTYPE_WEAPON") then
        DIS_Saved[29166][16] = GetItemInfo(link)
        self:Msg("Innervate weapon successfully set to %s",link)
        self.Selecting = nil
        HideUIPanel(CharacterFrame)
        CloseAllBags()
        StaticPopup_Hide("DIS_INNERVATESELECTING")
    else
        self:Msg("Must be a weapon!")
    end
end

function DIS:CheckOriginals(name)
    for i in pairs(DIS_Saved.Originals) do
        if (wotlk) then
            if (UnitBuff("player", GetSpellInfo(i))) then
                return
            end
        else
            if (GetPlayerBuffName(GetSpellInfo(i))) then
                return
            end
        end
        self:RestoreOriginals(i)
    end
end

function DIS:RestoreOriginals(spellID)
    for i in pairs(DIS_Saved.Originals[spellID]) do
        if (GetItemInfo(GetInventoryItemLink("player",i) or "") ~= DIS_Saved.Originals[spellID][i]) then
            self:EquipItemByName(DIS_Saved.Originals[spellID][i],i)
        else
            DIS_Saved.Originals[spellID][i] = nil
            if (self:TCount(DIS_Saved.Originals[spellID]) == 0) then
                DIS_Saved.Originals[spellID] = nil
            end
        end
    end
end

function DIS:EquipItemByName(item, slot)
    local sfx = GetCVar("Sound_EnableSFX")
    SetCVar("Sound_EnableSFX", "0")
    EquipItemByName(item,slot)
    SetCVar("Sound_EnableSFX", sfx)
end

function DIS:TCount(tab)
    local n=0
    for k,v in pairs(tab) do
        if (v) then
            n=n+1
        end
    end
    return n
end

function DIS:Msg(msg, ...)
    DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF33[DIS]|r "..format(msg, ...))
end