﻿--[[
DressUp Stats Main LUA
Copyright 2008 Neer (Horde) of US-Cenarion Circle
Last Modified: 4/4/2008 11:24:57 AM
]]

DressUpStats = {};
DUS = {
	pClass = "",
	pLvl = 0,
	slotMain = false,
	slotOff = false,
	slotOne = 0,
	slotRing = 0,
	slotTrink = 0,
	Curr = {
		sta = 0,
		str = 0,
		agi = 0,
		int = 0,
		spi = 0,
		health = 0,
		mana = 0,
		armor = 0,
		defrat = 0,
		dodper = 0,
		dodrat = 0,
		parper = 0,
		parrat = 0,
		blkper = 0,
		blkrat = 0,
		blkval = 0,
		resrat = 0,
		manareg = 0,
		spcrit = 0,
		minspcrit = 0,
		spholycrit = 0,
		spfirecrit = 0,
		spnaturecrit = 0,
		spfrostcrit = 0,
		spshadowcrit = 0,
		sparcanecrit = 0,
		minspdmg = 0,
		spholydmg = 0,
		spfiredmg = 0,
		spnaturedmg = 0,
		spfrostdmg = 0,
		spshadowdmg = 0,
		sparcanedmg = 0,
		sphit = 0,
		sppen = 0,
		spheal = 0,
		sphaste = 0,
		MHld = 0,
		MHhd = 0,
		MHspeed = nil,
		OHld = 0,
		OHhd = 0,
		OHspeed = nil,
		Rhd = 0,
		Rld = 0,
		Rspeed = nil,
		mdmg = 0,
		mhaste = 0,
		ap = 0,
		mhit = 0,
		mcrit = 0,
		mcritBase = 0,
		mexpr = 0,
		apen = 0
	},
	Modi = {
		str = 0,
		agi = 0,
		sta = 0,
		int = 0,
		spi = 0,
		armor = 0,
		health = 0,
		mana = 0,
		defrat = 0,
		defper = 0,
		dodrat = 0,
		parrat = 0,
		blkrat = 0,
		blkval = 0,
		resrat = 0,
		manareg = 0,
		spcrit = 0,
		spholycrit = 0,
		spfirecrit = 0,
		spnaturecrit = 0,
		spfrostcrit = 0,
		spshadowcrit = 0,
		sparcanecrit = 0,
		spdmg = 0,
		spholydmg = 0,
		spfiredmg = 0,
		spnaturedmg = 0,
		spfrostdmg = 0,
		spshadowdmg = 0,
		sparcanedmg = 0,
		sppen = 0,
		spheal = 0,
		sphit = 0,
		sphaste = 0,
		MHhd = 0,
		MHspeed = nil,
		OHld = 0,
		OHhd = 0,
		OHspeed = nil,
		Rhd = 0,
		Rld = 0,
		Rspeed = nil,
		mdmg = 0,
		mhaste = 0,
		ap = 0,
		mhit = 0,
		mcrit = 0,
		mexpr = 0,
		apen = 0
	},
	Est = {
		str = 0,
		agi = 0,
		sta = 0,
		int = 0,
		spi = 0,
		armor = 0,
		defrat = 0,
		dodrat = 0,
		parrat = 0,
		blkrat = 0,
		blkval = 0,
		resrat = 0,
		manareg = 0,
		spcrit = 0,
		sppen = 0,
		spheal = 0,
		spdmg = 0,
		spholydmg = 0,
		spfiredmg = 0,
		spnaturedmg = 0,
		spfrostdmg = 0,
		spshadowdmg = 0,
		sparcanedmg = 0,
		sphit = 0,
		sphaste = 0,
		mdmg = 0,
		mhaste = 0,
		ap = 0,
		mhit = 0,
		mcrit = 0,
		mexpr = 0,
		apen = 0
	},
	Last = {
		Str = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Agi = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Sta = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },				
		Int = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Spi = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Armor = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Def = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },		
		Dod = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		Par = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		Blk = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		BlkVal = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		Res = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		ManaReg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpCrit = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpPen = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpHeal = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpHit = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpHaste = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpHolyDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpFireDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpNatureDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpFrostDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpShadowDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		SpArcaneDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		MDmg = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		MHaste = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		AP = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		MCrit = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		MHit = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		MExpr = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 },
		APen = { hand = 0,head = 0,neck = 0,shoulder = 0,back = 0,chest = 0,wrist = 0,finger0 = 0,finger1 = 0,waist = 0,legs = 0,feet = 0,mainh = 0,offh = 0,ranged = 0,trink0 = 0,trink1 = 0 }
	};
};

setglobal("DUSDDMS","PLAYERSTAT_BASE_STATS");
--local linkcount,ringCount,trinkCount = 0,0,0;

--On Load
function DressUpStats.OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
  this:RegisterEvent("UNIT_INVENTORY_CHANGED");
  this:RegisterEvent("AUCTION_HOUSE_SHOW");
  this:RegisterEvent("AUCTION_HOUSE_CLOSED");
  DressUpFrameResetButton:Hide();
  --Enable seterrorhandler for detailed errors.
  --seterrorhandler(ErrorWithStack);
end

--Used for detailed errors with a stack trace.  Called by seterrorhandler.
function ErrorWithStack(msg)
   msg = msg.."\n"..debugstack()
   _ERRORMESSAGE(msg)
   DressUpStats.PrntMsg(msg);
end

function DressUpStats.EquipFrameOnLoad()
	DUSEquipment1Label:SetText(DUS_SLOT_HEAD);
	DUSEquipment2Label:SetText(DUS_SLOT_NECK);
	DUSEquipment3Label:SetText(DUS_SLOT_SHOULDER);
	DUSEquipment4Label:SetText(DUS_SLOT_BACK);
	DUSEquipment5Label:SetText(DUS_SLOT_CHEST);
	DUSEquipment6Label:SetText(DUS_SLOT_WRIST);
	DUSEquipment7Label:SetText(DUS_SLOT_HANDS);
	DUSEquipment8Label:SetText(DUS_SLOT_FINGER0);
	DUSEquipment9Label:SetText(DUS_SLOT_FINGER1);
	DUSEquipment10Label:SetText(DUS_SLOT_WAIST);
	DUSEquipment11Label:SetText(DUS_SLOT_LEGS);
	DUSEquipment12Label:SetText(DUS_SLOT_FEET);
	DUSEquipment13Label:SetText(DUS_SLOT_MAINH);
	DUSEquipment14Label:SetText(DUS_SLOT_OFFH);
	DUSEquipment15Label:SetText(DUS_SLOT_RANGED);
	DUSEquipment16Label:SetText(DUS_SLOT_TRINKET0);
	DUSEquipment17Label:SetText(DUS_SLOT_TRINKET1);
end
--End On Load

--On Event
function DressUpStats.OnEvent()
    if(event == "VARIABLES_LOADED") then
        DressUp_StatsForm:SetBackdropColor(0,0,0,1);
        local loaded, reason = LoadAddOn("Blizzard_AuctionUI");
        if not loaded then
        	DressUpStats.PrntMsg("WARNING! - You may not be able to use the AH Integration!");
        	DressUpStats.PrntMsg(reason);
        else
        	DUS_AHForm:SetBackdropColor(0,0,0,1);
        	DUS_AHForm:ClearAllPoints();
    			DUS_AHButtons:ClearAllPoints();
    			DUS_AHForm:SetPoint("TOPLEFT", "AuctionFrame", "BOTTOMRIGHT", -175, 13);
    			DUS_AHButtons:SetPoint("LEFT", "AuctionFrame", "BOTTOMRIGHT", 0, 0);
        end
        local playerClass, englishClass = UnitClass("player");
        DressUpStats.MoveLabels("DR");
        DressUpStats.ResetCalc();
        hooksecurefunc("DressUpItemLink", DressUpStats.HookFunc); 
        DUS.pClass = englishClass;
        DressUpStats.PrntMsg(DUSVersion.." Loaded!");
    elseif(event == "UNIT_INVENTORY_CHANGED") then
        if( DressUpFrame:IsShown() )then
    			DressUpModel:Dress();
    			DressUpStats.ResetCalc();
    		elseif( AuctionDressUpFrame:IsShown() )then
    			AuctionDressUpModel:Dress();
    			DressUpStats.ResetCalc();
    		end
    elseif(event == "AUCTION_HOUSE_SHOW") then
    		DressUpStats.MoveLabels("AH");
    		DUS_AHButtons:Show();
    		DressUpStats.ResetCalc();
    		AuctionDressUpFrameResetButton:Hide();
    		--DEBUG: frame references.
    		--point, rt, rp, xOfs, yOfs = DUSCurrentStatFrame:GetPoint()
				--DEFAULT_CHAT_FRAME:AddMessage(point)
				--DEFAULT_CHAT_FRAME:AddMessage(rt:GetName())
				--DEFAULT_CHAT_FRAME:AddMessage(rp)
				--DEFAULT_CHAT_FRAME:AddMessage(xOfs)
				--DEFAULT_CHAT_FRAME:AddMessage(yOfs)
    elseif(event == "AUCTION_HOUSE_CLOSED") then
    		DUS_AHForm:Hide();
    		DUS_AHHide:Hide();
    		DUS_AHShow:Show();
    		DUS_AHButtons:Hide();
    		DressUpStats.MoveLabels("DR");
    		DressUpStats.ResetCalc();
    end
end
--End On Event

--Move Labels
function DressUpStats.MoveLabels(dest)
	local level,estLevel = 0,0;
	if(dest == "AH") then
		--Current Stats Frame
		DUSCurrentStatFrame:ClearAllPoints();
 		DUSCurrentStatFrame:SetParent("DUS_AHForm");
 		DUSCurrentStatFrame:SetPoint("TOPLEFT","DUS_AHFormCurrLbl", "BOTTOMLEFT", 9, 0);
 		level = DUSCurrentStatFrame:GetFrameLevel();
 		--Estimated Stats Frame
 		DUSEstimatedStatFrame:ClearAllPoints();
    DUSEstimatedStatFrame:SetParent("DUS_AHForm");
    DUSEstimatedStatFrame:SetPoint("TOPRIGHT","DUS_AHFormEstLbl", "BOTTOMRIGHT", -9, 0);
    estLevel = DUSEstimatedStatFrame:GetFrameLevel();
	else
		--Current Stats Frame
		DUSCurrentStatFrame:ClearAllPoints();
 		DUSCurrentStatFrame:SetParent("DressUp_StatsForm");
 		DUSCurrentStatFrame:SetPoint("TOPLEFT","DressUp_StatsFormCurrLbl", "BOTTOMLEFT", 9, 0);
 		level = DUSCurrentStatFrame:GetFrameLevel();
 		--Estimated Stats Frame
 		DUSEstimatedStatFrame:ClearAllPoints();
    DUSEstimatedStatFrame:SetParent("DressUp_StatsForm");
    DUSEstimatedStatFrame:SetPoint("TOPRIGHT","DressUp_StatsFormEstLbl", "BOTTOMRIGHT", -9, 0);
    estLevel = DUSEstimatedStatFrame:GetFrameLevel();
	end
	--Current Stats Labels
	DUSPlayerStatCurrHealth:SetFrameLevel(level + 1);
	DUSPlayerStatCurrHealthStat:SetFrameLevel(level + 1);
 	DUSPlayerStatCurrMana:SetFrameLevel(level + 1);
 	DUSPlayerStatCurrManaStat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft1:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft1Stat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft2:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft2Stat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft3:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft3Stat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft4:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft4Stat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft5:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft5Stat:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft6:SetFrameLevel(level + 1);
 	DUSPlayerStatFrameLeft6Stat:SetFrameLevel(level + 1);
 	--Estimated Stats Labels
 	DUSPlayerStatEstHealth:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatEstHealthStat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatEstMana:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatEstManaStat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight1:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight1Stat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight2:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight2Stat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight3:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight3Stat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight4:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight4Stat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight5:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight5Stat:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight6:SetFrameLevel(estLevel + 1);
 	DUSPlayerStatFrameRight6Stat:SetFrameLevel(estLevel + 1);
end
--End Move Labels


--Init Objects on Show Stats Button Click on the Main Dressing Room
function DressUpStats.DUSShowClick()
    UIDropDownMenu_SetSelectedValue(DUSPlayerStatFrameDropDown, getglobal("DUSDDMS"));
end

--Init Objects on Show Stats Button Click on the AH Dressing Room
function DressUpStats.DUSAHShowClick()
    UIDropDownMenu_SetSelectedValue(DUSAHPlayerStatFrameDropDown, getglobal("DUSDDMS"));
end
--End check

--Generic Function to Print Chat Message
function DressUpStats.PrntMsg(text)
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd200"..DUSName..":|r "..text);
end
--End Chat Message Function

--Calculate vars and setup ui
function DressUpStats.Calculate()
	DressUpStats.GetCurrHealth();
  DressUpStats.GetCurrMana();
  DressUpStats.GetEstHealth();
  DressUpStats.GetEstMana();   
end
--End Calculate

--Get Stat
function DressUpStats.GetStat(statFrame, statIndex)
  local label = getglobal(statFrame:GetName().."Label");
	local text = getglobal(statFrame:GetName().."StatText");
	local stat;
	local effectiveStat;
	local posBuff;
	local negBuff;
	stat, effectiveStat, posBuff, negBuff = UnitStat("player", statIndex);
	local statName = getglobal("SPELL_STAT"..statIndex.."_NAME");
    label:SetText(statName..":");
	-- Set the tooltip text
	local tooltipText = HIGHLIGHT_FONT_COLOR_CODE..statName.." ";

	if ( ( posBuff == 0 ) and ( negBuff == 0 ) ) then
		text:SetText(effectiveStat);
		statFrame.tooltip = tooltipText..effectiveStat..FONT_COLOR_CODE_CLOSE;
	else 
		tooltipText = tooltipText..effectiveStat;
		if ( posBuff > 0 or negBuff < 0 ) then
			tooltipText = tooltipText.." ("..(stat - posBuff - negBuff)..FONT_COLOR_CODE_CLOSE;
		end
		if ( posBuff > 0 ) then
			tooltipText = tooltipText..FONT_COLOR_CODE_CLOSE..GREEN_FONT_COLOR_CODE.."+"..posBuff..FONT_COLOR_CODE_CLOSE;
		end
		if ( negBuff < 0 ) then
			tooltipText = tooltipText..RED_FONT_COLOR_CODE.." "..negBuff..FONT_COLOR_CODE_CLOSE;
		end
		if ( posBuff > 0 or negBuff < 0 ) then
			tooltipText = tooltipText..HIGHLIGHT_FONT_COLOR_CODE..")"..FONT_COLOR_CODE_CLOSE;
		end
		statFrame.tooltip = tooltipText;

		-- If there are any negative buffs then show the main number in red even if there are
		-- positive buffs. Otherwise show in green.
		if ( negBuff < 0 ) then
			text:SetText(RED_FONT_COLOR_CODE..effectiveStat..FONT_COLOR_CODE_CLOSE);
		else
			text:SetText(GREEN_FONT_COLOR_CODE..effectiveStat..FONT_COLOR_CODE_CLOSE);
		end
	end
	statFrame.tooltip2 = getglobal("DEFAULT_STAT"..statIndex.."_TOOLTIP");
	local _, unitClass = UnitClass("player");
	unitClass = strupper(unitClass);
	
	if ( statIndex == 1 ) then
    DUS.Curr.str = effectiveStat;
		local attackPower = GetAttackPowerForStat(statIndex,effectiveStat);
		statFrame.tooltip2 = format(statFrame.tooltip2, attackPower);
		if ( unitClass == "WARRIOR" or unitClass == "SHAMAN" or unitClass == "PALADIN" ) then
			statFrame.tooltip2 = statFrame.tooltip2 .. "\n" .. format( STAT_BLOCK_TOOLTIP, effectiveStat*BLOCK_PER_STRENGTH );
		end
	elseif ( statIndex == 3 ) then
    DUS.Curr.sta = effectiveStat;
		local baseStam = min(20, effectiveStat);
		local moreStam = effectiveStat - baseStam;
		statFrame.tooltip2 = format(statFrame.tooltip2, baseStam + (moreStam*HEALTH_PER_STAMINA));
		local petStam = ComputePetBonus("PET_BONUS_STAM", effectiveStat );
		if( petStam > 0 ) then
			statFrame.tooltip2 = statFrame.tooltip2 .. "\n" .. format(PET_BONUS_TOOLTIP_STAMINA,petStam);
		end
	elseif ( statIndex == 2 ) then
    DUS.Curr.agi = effectiveStat;
		local attackPower = GetAttackPowerForStat(statIndex,effectiveStat);
		if ( attackPower > 0 ) then
			statFrame.tooltip2 = format(STAT_ATTACK_POWER, attackPower) .. format(statFrame.tooltip2, GetCritChanceFromAgility("player"), effectiveStat*ARMOR_PER_AGILITY);
		else
			statFrame.tooltip2 = format(statFrame.tooltip2, GetCritChanceFromAgility("player"), effectiveStat*ARMOR_PER_AGILITY);
		end
	elseif ( statIndex == 4 ) then
    DUS.Curr.int = effectiveStat;
		local baseInt = min(20, effectiveStat);
		local moreInt = effectiveStat - baseInt
		if ( UnitHasMana("player") ) then
			statFrame.tooltip2 = format(statFrame.tooltip2, baseInt + moreInt*MANA_PER_INTELLECT, GetSpellCritChanceFromIntellect("player"));
		else
			statFrame.tooltip2 = nil;
		end
		local petInt = ComputePetBonus("PET_BONUS_INT", effectiveStat );
		if( petInt > 0 ) then
			if ( not statFrame.tooltip2 ) then
				statFrame.tooltip2 = "";
			end
			statFrame.tooltip2 = statFrame.tooltip2 .. "\n" .. format(PET_BONUS_TOOLTIP_INTELLECT,petInt);
		end
	elseif ( statIndex == 5 ) then
    DUS.Curr.spi = effectiveStat;
		-- All mana regen stats are displayed as mana/5 sec.
		statFrame.tooltip2 = format(statFrame.tooltip2, GetUnitHealthRegenRateFromSpirit("player"));
		if ( UnitHasMana("player") ) then
			local regen = GetUnitManaRegenRateFromSpirit("player");
			regen = floor( regen * 5.0 );
			statFrame.tooltip2 = statFrame.tooltip2.."\n"..format(MANA_REGEN_FROM_SPIRIT, regen);
		end
	end
end
--End Get Stat

--Hook original DressUp function and AH DressUp function.
function DressUpStats.HookFunc(link)
  	DressUpStats.Calculate();
   	DressUpStats.DUSPaperDollFrame_UpdateStats();
   	DressUpStats.GetItemBonus(link);
    --DEFAULT_CHAT_FRAME:AddMessage("Function Hooked!");
end
--End Hook

--Get slot information for item
function DressUpStats.GetSlotType(loc)
	--DressUpStats.PrntMsg(loc);
--[["INVTYPE_AMMO"  Ammo  0  
"INVTYPE_HEAD"  Head  1  
"INVTYPE_NECK"  Neck  2  
"INVTYPE_SHOULDER"  Shoulder  3  
"INVTYPE_BODY"  Shirt  4  
"INVTYPE_CHEST"  Chest  5  
"INVTYPE_ROBE"  Chest  5  
"INVTYPE_WAIST"  Waist  6  
"INVTYPE_LEGS"  Legs  7  
"INVTYPE_FEET"  Feet  8  
"INVTYPE_WRIST"  Wrist  9  
"INVTYPE_HAND"  Hands  10  
"INVTYPE_FINGER"  Fingers  11,12  
"INVTYPE_TRINKET"  Trinkets  13,14  
"INVTYPE_CLOAK"  Cloaks  15  
"INVTYPE_WEAPON"  One-Hand  16,17  
"INVTYPE_SHIELD"  Shield  17  
"INVTYPE_2HWEAPON"  Two-Handed  16  
"INVTYPE_WEAPONMAINHAND"  Main-Hand Weapon  16  
"INVTYPE_WEAPONOFFHAND"  Off-Hand Weapon  17  
"INVTYPE_HOLDABLE"  Held In Off-Hand  17  
"INVTYPE_RANGED"  Bows or Crossbows  18  
"INVTYPE_THROWN"  Ranged  18  
"INVTYPE_RANGEDRIGHT"  Wands or Guns  18  
"INVTYPE_RELIC"  Relics  18  
"INVTYPE_TABARD"  Tabard  19  
"INVTYPE_BAG"  Containers  20,21,22,23  
"INVTYPE_QUIVER"  Quivers  20,21,22,23]]
	if(loc == "INVTYPE_WEAPONMAINHAND")then
		DUS.slotMain = true;
		return DUS_SLOTN_MAINH;
	elseif(loc == "INVTYPE_WEAPONOFFHAND")then
		DUS.slotOff = true;
		DUS.slotOne = 0;
		return DUS_SLOTN_OFFH;
	elseif(loc == "INVTYPE_WEAPON")then
		if(DUS.slotOne ==  0 and DUS.slotMain == false and DUS.slotOff == false)then
			DUS.slotMain = true;
			DUS.slotOne = 1;
			return DUS_SLOTN_MAINH;
		elseif(DUS.slotOne == 0 and DUS.slotMain == true and DUS.slotOff == false)then
			DUS.slotOff = true;
			DUS.slotOne = 0;
			return DUS_SLOTN_OFFH;
		else
			if(DUS.slotOne == 0 and DUS.slotMain == false and DUS.slotOff == true)then
				DUS.slotMain = true;
				DUS.slotOne = 1;
				return DUS_SLOTN_MAINH;
			elseif(DUS.slotOne == 0 and DUS.slotMain == true and DUS.slotOff == true)then
				DUS.slotMain = true;
				DUS.slotOff = false;
				DUS.slotOne = 1;
				return DUS_SLOTN_MAINH;
			else
				DUS.slotOff = true;
				DUS.slotMain = false;
				DUS.slotOne = 0;
				return DUS_SLOTN_OFFH;
			end
		end
	elseif(loc == "INVTYPE_2HWEAPON")then
		DUS.slotMain = true;
		DUS.slotOff = false;
		DUS.slotOne = 1;
		return DUS_SLOTN_MAINH;
	elseif(loc == "INVTYPE_SHIELD")then
		return DUS_SLOTN_OFFH;
	elseif(loc == "INVTYPE_HOLDABLE")then
		return DUS_SLOTN_OFFH;
	elseif(loc == "INVTYPE_RANGED")then
		return DUS_SLOT_RANGED;
	elseif(loc == "INVTYPE_THROWN")then
		return DUS_SLOT_RANGED;
	elseif(loc == "INVTYPE_RANGEDRIGHT")then
		return DUS_SLOT_RANGED;
	elseif(loc == "INVTYPE_RELIC")then
		return DUS_SLOT_RANGED;
	elseif(loc == "INVTYPE_HEAD")then
		return DUS_SLOT_HEAD;
	elseif(loc == "INVTYPE_NECK")then
		return DUS_SLOT_NECK;
	elseif(loc == "INVTYPE_SHOULDER")then
		return DUS_SLOT_SHOULDER;
	elseif(loc == "INVTYPE_CHEST")then
		return DUS_SLOT_CHEST;
	elseif(loc == "INVTYPE_ROBE")then
		return DUS_SLOT_CHEST;
	elseif(loc == "INVTYPE_WAIST")then
		return DUS_SLOT_WAIST;
	elseif(loc == "INVTYPE_LEGS")then
		return DUS_SLOT_LEGS;
	elseif(loc == "INVTYPE_FEET")then
		return DUS_SLOT_FEET;
	elseif(loc == "INVTYPE_WRIST")then
		return DUS_SLOT_WRIST;
	elseif(loc == "INVTYPE_HAND")then
		return DUS_SLOT_HANDS;
	elseif(loc == "INVTYPE_FINGER")then
		if(DUS.slotRing == 0)then
			DUS.slotRing = 1;
			return DUS_SLOT_FINGER0;
		elseif(DUS.slotRing == 1)then
			DUS.slotRing = 0;
			return DUS_SLOT_FINGER1;
		end
	elseif(loc == "INVTYPE_TRINKET")then
		if(DUS.slotTrink == 0)then
			DUS.slotTrink = 1;
			return DUS_SLOT_TRINKET0;
		elseif(DUS.slotTrink == 1)then
			DUS.slotTrink = 0;
			return DUS_SLOT_TRINKET1;
		end
	elseif(loc == "INVTYPE_CLOAK")then
		return DUS_SLOT_BACK;
	else
		return "";
	end  
end
--end Get slot information

--Get Item Bonuses
function DressUpStats.GetItemBonus(link)
        local Iname, Ilink, Irarity, Ilevel, IMinLevel, IType, ISubType, IStackCount, IEquipLoc, ITexture = GetItemInfo(link);
        local slot = DressUpStats.GetSlotType(IEquipLoc);
        --DressUpStats.PrntMsg(Iname.." "..Ilink.." "..IEquipLoc);
        --DressUpStats.PrntMsg(slot);
        local bonuses = BonusScanner:ScanItem(link);
        --local other = Sea.wow.tooltip.scan(BonusScannerTooltip);
        local other = BonusScannerTooltip;
        
	    if(not bonuses) then
		    DressUpStats.PrntMsg("Error scanning item (probably not cached). Please click the item link again.");
	    else
	        local amt, bonus, name;
	        for bonus, name in pairs(BONUSSCANNER_NAMES) do
                if (bonuses[bonus]) then
                    amt = bonuses[bonus];
                    --DressUpStats.PrntMsg(GREEN_FONT_COLOR_CODE .. name .. ": " .. HIGHLIGHT_FONT_COLOR_CODE .. bonuses[bonus]);
                else
                    amt = 0;
                end
                --DressUpStats.PrntMsg(name);
                DressUpStats.CalcModStat(amt,name,slot);
            end
            --DressUpStats.PrntMsg(slot);
            --DressUpStats.PrntMsg(link);
            if(slot == DUS_SLOT_CHEST)then
            	DUSEquipment5StatText:SetText(link);
            	DUSEquipment5.tooltip = link;
        		elseif(slot == DUS_SLOT_FEET)then
        			DUSEquipment12StatText:SetText(link);
        			DUSEquipment12.tooltip = link;
  		      elseif(slot == DUS_SLOT_WRIST)then
  		      	DUSEquipment6StatText:SetText(link);
  		      	DUSEquipment6.tooltip = link;
        		elseif(slot == DUS_SLOT_HANDS)then
        			DUSEquipment7StatText:SetText(link);
        			DUSEquipment7.tooltip = link;
        		elseif(slot == DUS_SLOT_WAIST)then
        			DUSEquipment10StatText:SetText(link);
        			DUSEquipment10.tooltip = link;
		        elseif(slot == DUS_SLOT_LEGS)then
		        	DUSEquipment11StatText:SetText(link);
		        	DUSEquipment11.tooltip = link;
      		  elseif(slot == DUS_SLOT_BACK)then
      		  	DUSEquipment4StatText:SetText(link);
      		  	DUSEquipment4.tooltip = link;
		        elseif(slot == DUS_SLOT_SHOULDER)then
		        	DUSEquipment3StatText:SetText(link);
		        	DUSEquipment3.tooltip = link;
      		  elseif(slot == DUS_SLOT_NECK)then
      		  	DUSEquipment2StatText:SetText(link);
      		  	DUSEquipment2.tooltip = link;
		        elseif(slot == DUS_SLOT_HEAD)then
		        	DUSEquipment1StatText:SetText(link);
		        	DUSEquipment1.tooltip = link;
      		  elseif(slot == DUS_SLOTN_MAINH)then
      		  	DUSEquipment13StatText:SetText(link);
      		  	DUSEquipment13.tooltip = link;
      		  	DressUpStats.parseTT(other,"mainh");
        		elseif(slot == DUS_SLOTN_OFFH)then
        			DUSEquipment14StatText:SetText(link);
        			DUSEquipment14.tooltip = link;
        			DressUpStats.parseTT(other,"offh");
		        elseif(slot == DUS_SLOT_FINGER0)then
		        	DUSEquipment8StatText:SetText(link);
		        	DUSEquipment8.tooltip = link;
      		  elseif(slot == DUS_SLOT_FINGER1)then
      		  	DUSEquipment9StatText:SetText(link);
      		  	DUSEquipment9.tooltip = link;
      		  elseif(slot == DUS_SLOT_RANGED)then
      		  	DUSEquipment15StatText:SetText(link);
      		  	DUSEquipment15.tooltip = link;
      		  	DressUpStats.parseTT(other,"ranged");
      		  elseif(slot == DUS_SLOT_TRINKET0)then
		        	DUSEquipment16StatText:SetText(link);
		        	DUSEquipment16.tooltip = link;
      		  elseif(slot == DUS_SLOT_TRINKET1)then
      		  	DUSEquipment17StatText:SetText(link);
      		  	DUSEquipment17.tooltip = link;
        		end
        		DressUpStats.DUSPaperDollFrame_UpdateStats();
        end
end
--End Get Item Bonuses

--Parse Tooltip for Speeds and Damages
function DressUpStats.parseTT(t,slot)
	local tmpTxt, tmpTxt2;
	local lines = BonusScannerTooltip:NumLines();
	for i=2, lines, 1 do
		tmpText = getglobal("BonusScannerTooltipTextLeft"..i);
		tmpText2 = getglobal("BonusScannerTooltipTextRight"..i);
		if(string.match(tmpText:GetText(),DAMAGE.."$"))then
    		srmv = string.len(DAMAGE);
    		send = string.len(tmpText:GetText()) - srmv;
    		d = string.sub(tmpText:GetText(),0,send);
    		hd = d:gsub("%s*","");
    		ld = hd
    		ld = string.sub(ld,0,string.find(ld,"-") - 1);
    		hd = string.sub(hd,string.find(hd,"-") + 1, string.len(hd));
    		--DressUpStats.PrntMsg(d.." "..hd.." "..ld);
    		if(slot == "mainh")then
    			DUS.Modi.MHld = ld;
    			DUS.Modi.MHhd = hd;
    		elseif(slot == "offh")then
    			DUS.Modi.OHld = ld;
    			DUS.Modi.OHhd = hd;
    		elseif(slot == "ranged")then
    			DUS.Modi.Rld = ld;
    			DUS.Modi.Rhd = hd;
    		end
    	end
    	if (tmpText2:GetText()) then
	    	if(string.match(tmpText2:GetText(),"^Speed"))then
	    		s = string.gsub(tmpText2:GetText(),"^Speed%s*","");
	      	--DressUpStats.PrntMsg(s);
	      	if(slot == "mainh")then
	      		DUS.Modi.MHspeed = s;
	      	elseif(slot == "offh")then
	    			DUS.Modi.OHspeed = s;
	    		elseif(slot == "ranged")then
	    			DUS.Modi.Rspeed = s;
	      	end
	      end
    	end
	end
end
--end parse

--Equipment tooltip
function DressUpStats.DUSEquipmentTooltip(unit)
	if ( not this.tooltip ) then
		return;
	end
	if ( not unit ) then
		unit = "player";
	end
	GameTooltip:SetOwner(this, "ANCHOR_LEFT");
	GameTooltip:SetHyperlink(this.tooltip);
	if ( this.tooltip2 ) then
		GameTooltip:AddLine(this.tooltip2, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, 1);
	end
	GameTooltip:Show();
end
--End Equipment tooltip

--Call Calculations
function DressUpStats.CalcModStat(value,attrib,slot)
    --DressUpStats.PrntMsg(attrib.." "..value.." "..slot);
    if(attrib == DUSTxt_Str)then
        DressUpStats.DUSmodStr(value,attrib,slot);
        DUS.Modi.str = DUS.Curr.str + DUS.Est.str;
    elseif(attrib == DUSTxt_Agi)then
        DressUpStats.DUSmodAgi(value,attrib,slot);
        DUS.Modi.agi = DUS.Curr.agi + DUS.Est.agi;
    elseif(attrib == DUSTxt_Sta)then
        DressUpStats.DUSmodSta(value,attrib,slot);
        DUS.Modi.sta = DUS.Curr.sta + DUS.Est.sta;
        DressUpStats.GetEstHealth();
    elseif(attrib == DUSTxt_Int)then
				DressUpStats.DUSmodInt(value,attrib,slot);
        DUS.Modi.int = DUS.Curr.int + DUS.Est.int;
        DressUpStats.GetEstMana();
    elseif(attrib == DUSTxt_Spi)then
				DressUpStats.DUSmodSpi(value,attrib,slot);
        DUS.Modi.spi = DUS.Curr.spi + DUS.Est.spi;
    elseif(attrib == DUSTxt_Armor)then
				DressUpStats.DUSmodArmor(value,attrib,slot);
        DUS.Modi.armor = DUS.Curr.armor + DUS.Est.armor;
    elseif(attrib == DUSTxt_DefRat)then
    		DressUpStats.DUSmodDefRat(value,attrib,slot);
    		DUS.Modi.defrat = DUS.Curr.defrat + DUS.Est.defrat;
    		--DressUpStats.PrntMsg(DUS.Curr.defrat.." + "..DUS.Est.defrat.." = "..DUS.Modi.defrat);
    elseif(attrib == DUSTxt_DodRat)then
    		DressUpStats.DUSmodDodRat(value,attrib,slot);
    		DUS.Modi.dodrat = DUS.Curr.dodrat + DUS.Est.dodrat;
    elseif(attrib == DUSTxt_ParRat)then
    		DressUpStats.DUSmodParRat(value,attrib,slot);
    		DUS.Modi.parrat = DUS.Curr.parrat + DUS.Est.parrat;
    elseif(attrib == DUSTxt_BlkRat)then
    		DressUpStats.DUSmodBlkRat(value,attrib,slot);
    		DUS.Modi.blkrat = DUS.Curr.blkrat + DUS.Est.blkrat;
    elseif(attrib == DUSTxt_BlkVal)then
    		DressUpStats.DUSmodBlkVal(value,attrib,slot);
    		DUS.Modi.blkval = DUS.Est.blkval;
    elseif(attrib == DUSTxt_Resil)then
    		DressUpStats.DUSmodResRat(value,attrib,slot);
    		DUS.Modi.resrat = DUS.Curr.resrat + DUS.Est.resrat;
    elseif(attrib == DUSTxt_ManaReg)then
    		--DressUpStats.PrntMsg("Found Mana Regen!!");
    		DressUpStats.DUSmodManaReg(value,attrib,slot);
    		DUS.Modi.manareg = DUS.Curr.manareg + DUS.Est.manareg;
    		--DressUpStats.PrntMsg(DUS.Curr.manareg.." + "..DUS.Est.manareg.." = "..DUS.Modi.manareg);
    elseif(attrib == DUSTxt_SpCrit)then
    		DressUpStats.DUSmodSpCrit(value,attrib,slot);
    		DUS.Modi.spcrit = DUS.Curr.spcrit + DUS.Est.spcrit;
    elseif(attrib == DUSTxt_SpPen)then
    		DressUpStats.DUSmodSpPen(value,attrib,slot);
    		DUS.Modi.sppen = DUS.Curr.sppen + DUS.Est.sppen;
    elseif(attrib == DUSTxt_SpHeal)then
    		DressUpStats.DUSmodSpHeal(value,attrib,slot);
    		DUS.Modi.spheal = DUS.Curr.spheal + DUS.Est.spheal;
    elseif(attrib == DUSTxt_SpHit)then
    		DressUpStats.DUSmodSpHit(value,attrib,slot);
    		DUS.Modi.sphit = DUS.Curr.sphit + DUS.Est.sphit;
    elseif(attrib == DUSTxt_SpHaste)then
    		DressUpStats.DUSmodSpHaste(value,attrib,slot);
    		DUS.Modi.sphaste = DUS.Curr.sphaste + DUS.Est.sphaste;
    elseif(attrib == DUSTxt_SpDmg)then
    			--DressUpStats.PrntMsg(attrib.." "..value.." "..slot);
    			DressUpStats.DUSmodSpDmg(value,attrib,slot);
    			DUS.Modi.spdmg = DUS.Curr.minspdmg + DUS.Est.spdmg;
		elseif(attrib == DUSTxt_SpHolyDmg or attrib == DUSTxt_SpFireDmg or attrib == DUSTxt_SpNatureDmg or attrib == DUSTxt_SpFrostDmg or attrib == DUSTxt_SpShadowDmg or attrib == DUSTxt_SpArcaneDmg)then   
				--DressUpStats.PrntMsg(attrib.." "..value.." "..slot);
				DressUpStats.DUSmodSpSchDmg(value,attrib,slot);
				DUS.Modi.spholydmg = DUS.Curr.spholydmg + DUS.Est.spholydmg;
				DUS.Modi.spfiredmg = DUS.Curr.spfiredmg + DUS.Est.spfiredmg;
				DUS.Modi.spnaturedmg = DUS.Curr.spnaturedmg + DUS.Est.spnaturedmg;
				DUS.Modi.spfrostdmg = DUS.Curr.spfrostdmg + DUS.Est.spfrostdmg;
				DUS.Modi.spshadowdmg = DUS.Curr.spshadowdmg + DUS.Est.spshadowdmg;
				DUS.Modi.sparcanedmg = DUS.Curr.sparcanedmg + DUS.Est.sparcanedmg;
		elseif(attrib == DUSTxt_MeleeDmg)then
			DressUpStats.DUSmodMDmg(value,attrib,slot);
			DUS.Modi.mdmg = DUS.Curr.mdmg + DUS.Est.mdmg;
		elseif(attrib == DUSTxt_Haste)then
			--DressUpStats.PrntMsg(attrib.." "..value.." "..slot);
			DressUpStats.DUSmodMHaste(value,attrib,slot);
			DUS.Modi.mhaste = DUS.Curr.mhaste + DUS.Est.mhaste;
			--DressUpStats.PrntMsg(DUS.Modi.mhaste);
		elseif(attrib == DUSTxt_AP)then
			--DressUpStats.PrntMsg(attrib.." "..value.." "..slot);
			DressUpStats.DUSmodAP(value,attrib,slot);
			DUS.Modi.ap = DUS.Curr.ap + DUS.Est.ap;
			--DressUpStats.PrntMsg(DUS.Curr.ap.." + "..DUS.Est.ap.." = "..DUS.Modi.ap);
		elseif(attrib == DUSTxt_MHit)then
			DressUpStats.DUSmodMHit(value,attrib,slot);
			DUS.Modi.mhit = DUS.Curr.mhit + DUS.Est.mhit;
		elseif(attrib == DUSTxt_MCrit)then
			DressUpStats.DUSmodMCrit(value,attrib,slot);
			DUS.Modi.mcrit = DUS.Curr.mcrit + DUS.Est.mcrit;
		elseif(attrib == DUSTxt_MExpr)then
			DressUpStats.DUSmodMExpr(value,attrib,slot);
			DUS.Modi.mexpr = DUS.Curr.mexpr + DUS.Est.mexpr;
		elseif(attrib == DUSTxt_APen)then
			DressUpStats.DUSmodMApen(value,attrib,slot);
			DUS.Modi.apen = DUS.Curr.apen + DUS.Est.apen;
    end
    DressUpStats.UpdateRightStats("DUSPlayerStatFrameRight", getglobal("DUSDDMS"));
end
--end Calculations Call

--Update Estimated Stats Frame
function DressUpStats.UpdateRightStats(prefix, index)
	--DressUpStats.PrntMsg(index);
    local stat1 = getglobal(DUSPlayerStatFrameRight1:GetName());
    local stat2 = getglobal(DUSPlayerStatFrameRight2:GetName());
    local stat3 = getglobal(DUSPlayerStatFrameRight3:GetName());
    local stat4 = getglobal(DUSPlayerStatFrameRight4:GetName());
    local stat5 = getglobal(DUSPlayerStatFrameRight5:GetName());
    local stat6 = getglobal(DUSPlayerStatFrameRight6:GetName());
    local stat1Lbl = getglobal(prefix.."1Label");
    local stat1Stat = getglobal(prefix.."1StatText");
		local stat2Lbl = getglobal(prefix.."2Label");
    local stat2Stat = getglobal(prefix.."2StatText");
		local stat3Lbl = getglobal(prefix.."3Label");
    local stat3Stat = getglobal(prefix.."3StatText");
    local stat4Lbl = getglobal(prefix.."4Label");
    local stat4Stat = getglobal(prefix.."4StatText");
    local stat5Lbl = getglobal(prefix.."5Label");
    local stat5Stat = getglobal(prefix.."5StatText");
    local stat6Lbl = getglobal(prefix.."6Label");
    local stat6Stat = getglobal(prefix.."6StatText");
    
    -- reset any OnEnter scripts that may have been changed
    -- reset any OnEnter scripts that may have been changed
		stat1:SetScript("OnEnter", PaperDollStatTooltip);
		stat2:SetScript("OnEnter", PaperDollStatTooltip);
		stat3:SetScript("OnEnter", PaperDollStatTooltip);
		stat4:SetScript("OnEnter", PaperDollStatTooltip);
		stat5:SetScript("OnEnter", PaperDollStatTooltip);
		stat6:SetScript("OnEnter", PaperDollStatTooltip);
    
    if ( index == "PLAYERSTAT_BASE_STATS" ) then
				stat1Lbl:SetText(DUSTxt_Str..":");
        stat2Lbl:SetText(DUSTxt_Agi..":");
        stat3Lbl:SetText(DUSTxt_Sta..":");
        stat4Lbl:SetText(DUSTxt_Int..":");
        stat5Lbl:SetText(DUSTxt_Spi..":");
        stat6Lbl:SetText(DUSTxt_Armor..":");
        if(DUS.Modi.str > DUS.Curr.str)then
            stat1Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.str..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.str < DUS.Curr.str)then
            stat1Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.str..FONT_COLOR_CODE_CLOSE);
        else
            stat1Stat:SetText(DUS.Modi.str);
        end
        if(DUS.Modi.agi > DUS.Curr.agi)then
            stat2Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.agi..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.agi < DUS.Curr.agi)then
            stat2Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.agi..FONT_COLOR_CODE_CLOSE);
        else
            stat2Stat:SetText(DUS.Modi.agi);
        end
        if(DUS.Modi.sta > DUS.Curr.sta)then
            stat3Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.sta..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.sta < DUS.Curr.sta)then
            stat3Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.sta..FONT_COLOR_CODE_CLOSE);
        else
            stat3Stat:SetText(DUS.Modi.sta);
        end
        if(DUS.Modi.int > DUS.Curr.int)then
            stat4Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.int..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.int < DUS.Curr.int)then
            stat4Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.int..FONT_COLOR_CODE_CLOSE);
        else
            stat4Stat:SetText(DUS.Modi.int);
        end
        if(DUS.Modi.spi > DUS.Curr.spi)then
            stat5Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.spi..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.spi < DUS.Curr.spi)then
            stat5Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.spi..FONT_COLOR_CODE_CLOSE);
        else
            stat5Stat:SetText(DUS.Modi.spi);
        end
        if(DUS.Modi.armor > DUS.Curr.armor)then
            stat6Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.armor..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.armor < DUS.Curr.armor)then
            stat6Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.armor..FONT_COLOR_CODE_CLOSE);
        else
            stat6Stat:SetText(DUS.Modi.armor);
        end
        DressUpStats.RightTooltipBase(stat1,DUSTxt_Str,DUS.Modi.str,DUS.Curr.str,1);
        DressUpStats.RightTooltipBase(stat2,DUSTxt_Agi,DUS.Modi.agi,DUS.Curr.agi,2);
        DressUpStats.RightTooltipBase(stat3,DUSTxt_Sta,DUS.Modi.sta,DUS.Curr.sta,3);
        DressUpStats.RightTooltipBase(stat4,DUSTxt_Int,DUS.Modi.int,DUS.Curr.int,4);
        DressUpStats.RightTooltipBase(stat5,DUSTxt_Spi,DUS.Modi.spi,DUS.Curr.spi,5);
        DressUpFrame.SetArmorRight(stat6,"player",DUSTxt_Armor,DUS.Modi.armor,DUS.Curr.armor);
	elseif ( index == "PLAYERSTAT_MELEE_COMBAT" ) then
        DUSPlayerStatFrameRight1Label:SetText(DAMAGE_COLON);
        DressUpStats.SetEstDamage(stat1, stat1Stat);
        DUSPlayerStatFrameRight2Label:SetText(WEAPON_SPEED..":");
        DressUpStats.SetEstAttackSpeed(stat2, stat2Stat);
        DUSPlayerStatFrameRight3Label:SetText(ATTACK_POWER_COLON);
        DressUpStats.SetEstAttackPower(stat3, stat3Stat)
        DUSPlayerStatFrameRight4Label:SetText(COMBAT_RATING_NAME6..":");
        DressUpStats.SetEstMeleeHit(stat4, stat4Stat);
        DUSPlayerStatFrameRight5Label:SetText(MELEE_CRIT_CHANCE..":");
        DressUpStats.SetEstMeleeCritChance(stat5, stat5Stat)
        DUSPlayerStatFrameRight6Label:SetText(COMBAT_RATING_NAME24..":");
        DressUpStats.SetEstExpertise(stat6, stat6Stat)
        --DUSPlayerStatFrameRight6StatText:SetText("Not Avail.");
        --DUSPlayerStatFrameRight6.tooltip = nil;
	elseif ( index == "PLAYERSTAT_RANGED_COMBAT" ) then
        DUSPlayerStatFrameRight1Label:SetText(DAMAGE_COLON);
        DUSPlayerStatFrameRight1StatText:SetText("Not Avail.");
        DUSPlayerStatFrameRight1.tooltip = nil;
        DUSPlayerStatFrameRight2Label:SetText(WEAPON_SPEED..":");
        DUSPlayerStatFrameRight2StatText:SetText("Not Avail.");
        DUSPlayerStatFrameRight2.tooltip = nil;
        DUSPlayerStatFrameRight3Label:SetText(ATTACK_POWER_COLON);
        DUSPlayerStatFrameRight3StatText:SetText("Not Avail.");
        DUSPlayerStatFrameRight3.tooltip = nil;
        DUSPlayerStatFrameRight4Label:SetText(COMBAT_RATING_NAME6..":");
        DUSPlayerStatFrameRight4StatText:SetText("Not Avail.");
        DUSPlayerStatFrameRight4.tooltip = nil;
        DUSPlayerStatFrameRight5Label:SetText(RANGED_CRIT_CHANCE..":");
        DUSPlayerStatFrameRight5StatText:SetText("Not Avail.");
        DUSPlayerStatFrameRight5.tooltip = nil;
        DUSPlayerStatFrameRight6Label:SetText("");
        DUSPlayerStatFrameRight6StatText:SetText("");
        DUSPlayerStatFrameRight6.tooltip = nil;
	elseif ( index == "PLAYERSTAT_SPELL_COMBAT" ) then
				DUSPlayerStatFrameRight1Label:SetText(BONUS_DAMAGE);
				DressUpStats.SetEstSpellBonusDamage(stat1,stat1Stat);
        DUSPlayerStatFrameRight2Label:SetText(BONUS_HEALING);
        DressUpStats.SetEstSpellBonusHealing(stat2,stat2Stat);
        DUSPlayerStatFrameRight3Label:SetText(COMBAT_RATING_NAME8);
        DressUpStats.SetEstSpellHit(stat3,stat3Stat);
        DUSPlayerStatFrameRight4Label:SetText(SPELL_CRIT_CHANCE);
        DressUpStats.SetEstSpellCritChance(stat4,stat4Stat);
        DUSPlayerStatFrameRight5Label:SetText(SPELL_HASTE);
        DressUpStats.SetEstSpellHaste(stat5,stat5Stat)
        DUSPlayerStatFrameRight6Label:SetText(MANA_REGEN);
        DressUpStats.SetEstManaRegen(stat6,stat6Stat);
	elseif ( index == "PLAYERSTAT_DEFENSES" ) then
				stat1Lbl:SetText(DUSTxt_Armor..":");
				if(DUS.Modi.armor > DUS.Curr.armor)then
            stat1Stat:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.armor..FONT_COLOR_CODE_CLOSE);
        elseif(DUS.Modi.armor < DUS.Curr.armor)then
            stat1Stat:SetText(RED_FONT_COLOR_CODE..DUS.Modi.armor..FONT_COLOR_CODE_CLOSE);
        else
            stat1Stat:SetText(DUS.Modi.armor);
        end
        DressUpFrame.SetArmorRight(stat1,"player",DUSTxt_Armor,DUS.Modi.armor,DUS.Curr.armor);
        stat2Lbl:SetText(DEFENSE..":");
        DressUpStats.SetEstDefense(stat2,stat2Stat);
        stat3Lbl:SetText(STAT_DODGE..":");
				DressUpStats.SetEstDodge(stat3,stat3Stat);
				stat4Lbl:SetText(STAT_PARRY..":");
				DressUpStats.SetEstParry(stat4,stat4Stat);
				stat5Lbl:SetText(STAT_BLOCK..":");
				DressUpStats.SetEstBlock(stat5,stat5Stat);
				stat6Lbl:SetText(STAT_RESILIENCE..":");
				DressUpStats.SetEstResilience(stat6,stat6Stat);
	end
end
--End Update Estimated Stats Frame

--Right Side Tooltip
function DressUpStats.RightTooltipBase(frame,stat,Mod,Curr,statIndex)
    --DressUpStats.PrntMsg(stat.." "..statshrt);
    local statName = stat;
    local effectiveStat = 0;
    -- Set the tooltip text
	local tooltipText = HIGHLIGHT_FONT_COLOR_CODE..statName.." ";
    --DressUpStats.PrntMsg(Mod.." "..Curr);
	if (Mod == 0 or Mod == Curr) then
		tooltipText = tooltipText..Curr..FONT_COLOR_CODE_CLOSE;
        effectiveStat = Curr;
    elseif (Mod > Curr) then
        tooltipText = tooltipText..FONT_COLOR_CODE_CLOSE..GREEN_FONT_COLOR_CODE..Mod..FONT_COLOR_CODE_CLOSE;
        effectiveStat = Mod;
    elseif (Mod < Curr) then
        tooltipText = tooltipText..RED_FONT_COLOR_CODE..Mod..FONT_COLOR_CODE_CLOSE;
        effectiveStat = Mod;
	end
    --DressUpStats.PrntMsg(Curr);
    frame.tooltip = tooltipText;
	frame.tooltip2 = getglobal("DEFAULT_STAT"..statIndex.."_TOOLTIP");
    
    local _, unitClass = UnitClass("player");
	unitClass = strupper(unitClass);
	
	if ( statIndex == 1 ) then
		local attackPower = GetAttackPowerForStat(statIndex,effectiveStat);
		frame.tooltip2 = format(frame.tooltip2, attackPower);
		if ( unitClass == "WARRIOR" or unitClass == "SHAMAN" or unitClass == "PALADIN" ) then
			frame.tooltip2 = frame.tooltip2 .. "\n" .. format( STAT_BLOCK_TOOLTIP, effectiveStat*BLOCK_PER_STRENGTH );
		end
	elseif ( statIndex == 3 ) then
		local baseStam = min(20, effectiveStat);
		local moreStam = effectiveStat - baseStam;
		frame.tooltip2 = format(frame.tooltip2, baseStam + (moreStam*HEALTH_PER_STAMINA));
		local petStam = ComputePetBonus("PET_BONUS_STAM", effectiveStat );
		if( petStam > 0 ) then
			frame.tooltip2 = frame.tooltip2 .. "\n" .. format(PET_BONUS_TOOLTIP_STAMINA,petStam);
		end
	elseif ( statIndex == 2 ) then
		--local cr = GetCombatRatingBonus(CR_HIT_MELEE);
		local cpa = (GetCritChanceFromAgility("player") / 100) / DUS.Curr.agi;
		local newCritAgi = (DUS.Modi.agi * cpa) * 100;
		--DressUpStats.PrntMsg(cpa.." "..newCritAgi);
		local attackPower = GetAttackPowerForStat(statIndex,effectiveStat);
		if ( attackPower > 0 ) then
			frame.tooltip2 = format(STAT_ATTACK_POWER, attackPower) .. format(frame.tooltip2, newCritAgi, effectiveStat*ARMOR_PER_AGILITY);
		else
			frame.tooltip2 = format(frame.tooltip2, newCritAgi, effectiveStat*ARMOR_PER_AGILITY);
		end
	elseif ( statIndex == 4 ) then
		local CPI = ( GetSpellCritChanceFromIntellect("player") / 100 ) / DUS.Curr.int;
		local newCPI = (DUS.Modi.int * CPI) * 100;
		--DressUpStats.PrntMsg(CPI.." "..newCPI);
		local baseInt = min(20, effectiveStat);
		local moreInt = effectiveStat - baseInt
		if ( UnitHasMana("player") ) then
			frame.tooltip2 = format(frame.tooltip2, baseInt + moreInt*MANA_PER_INTELLECT, newCPI);
		else
			frame.tooltip2 = nil;
		end
		local petInt = ComputePetBonus("PET_BONUS_INT", effectiveStat );
		if( petInt > 0 ) then
			if ( not frame.tooltip2 ) then
				frame.tooltip2 = "";
			end
			frame.tooltip2 = frame.tooltip2 .. "\n" .. format(PET_BONUS_TOOLTIP_INTELLECT,petInt);
		end
	elseif ( statIndex == 5 ) then
		local HRPS = GetUnitHealthRegenRateFromSpirit("player") / DUS.Curr.spi;
		local newHRPS = (DUS.Modi.spi * HRPS);
		--DressUpStats.PrntMsg(HRPS.." "..newHRPS);
		-- All mana regen stats are displayed as mana/5 sec.
		frame.tooltip2 = format(frame.tooltip2, newHRPS);
		if ( UnitHasMana("player") ) then
			local MRPS = GetUnitManaRegenRateFromSpirit("player") / DUS.Curr.spi;
			local regen = DUS.Modi.spi * MRPS;
			regen = floor( regen * 5.0 );
			frame.tooltip2 = frame.tooltip2.."\n"..format(MANA_REGEN_FROM_SPIRIT, regen);
		end
  end
end
--End Right Side Tooltip

--Update Current Stats Frame
function DressUpStats.DUSUpdatePaperdollStats(prefix, index)
	local stat1 = getglobal(prefix..1);
	local stat2 = getglobal(prefix..2);
	local stat3 = getglobal(prefix..3);
	local stat4 = getglobal(prefix..4);
	local stat5 = getglobal(prefix..5);
	local stat6 = getglobal(prefix..6);
	local stat6Lbl = getglobal(prefix.."6Label");
  local stat6Stat = getglobal(prefix.."6StatText");

	-- reset any OnEnter scripts that may have been changed
	stat1:SetScript("OnEnter", PaperDollStatTooltip);
	stat2:SetScript("OnEnter", PaperDollStatTooltip);
	stat3:SetScript("OnEnter", PaperDollStatTooltip);
	stat4:SetScript("OnEnter", PaperDollStatTooltip);
	stat5:SetScript("OnEnter", PaperDollStatTooltip);
	stat6:SetScript("OnEnter", PaperDollStatTooltip);

	if ( index == "PLAYERSTAT_BASE_STATS" ) then
		DressUpStats.GetStat(stat1, 1);
		DressUpStats.GetStat(stat2, 2);
		DressUpStats.GetStat(stat3, 3);
		DressUpStats.GetStat(stat4, 4);
		DressUpStats.GetStat(stat5, 5);
		DressUpFrame.SetArmor(stat6);
	elseif ( index == "PLAYERSTAT_MELEE_COMBAT" ) then
    DressUpStats.SetCurrDamage(stat1);
    stat1:SetScript("OnEnter", DressUpStats.CurrCharacterDamageFrame_OnEnter);
    DressUpStats.SetCurrAttackSpeed(stat2);
    DressUpStats.SetCurrAttackPower(stat3);
    DressUpStats.SetCurrRating(stat4, CR_HIT_MELEE);
    DressUpStats.SetCurrMeleeCritChance(stat5);
    DressUpStats.SetCurrExpertise(stat6);
	elseif ( index == "PLAYERSTAT_RANGED_COMBAT" ) then
		DressUpStats.SetCurrRangedDamage(stat1);
		stat1:SetScript("OnEnter", DressUpStats.CharacterRangedDamageFrame_OnEnter);
		DressUpStats.SetCurrRangedAttackSpeed(stat2);
		DressUpStats.SetCurrRangedAttackPower(stat3);
		DressUpStats.SetCurrRating(stat4, CR_HIT_RANGED);
		DressUpStats.SetCurrRangedCritChance(stat5);
		stat6Lbl:SetText("");
		stat6Stat:SetText("");
		stat6.tooltip = nil;
	elseif ( index == "PLAYERSTAT_SPELL_COMBAT" ) then
		DressUpStats.SetCurrSpellBonusDamage(stat1);
		stat1:SetScript("OnEnter", DressUpStats.CurrCharacterSpellBonusDamage_OnEnter);
		DressUpStats.SetCurrSpellBonusHealing(stat2);
		DressUpStats.SetCurrRating(stat3, CR_HIT_SPELL);
		DressUpStats.SetCurrSpellCritChance(stat4);
		stat4:SetScript("OnEnter", DressUpStats.CurrCharacterSpellCritChance_OnEnter);
		DressUpStats.SetCurrSpellHaste(stat5)
		DressUpStats.SetCurrManaRegen(stat6);
	elseif ( index == "PLAYERSTAT_DEFENSES" ) then
		DressUpFrame.SetArmor(stat1);
		DressUpStats.SetCurrDefense(stat2);
		DressUpStats.SetCurrDodge(stat3);
		DressUpStats.SetCurrParry(stat4);
		DressUpStats.SetCurrBlock(stat5);
		DressUpStats.SetCurrResilience(stat6);
	end
end
--End Update Current Stats Frame

--Generic Update function.  Calls required functions to update all frames and tooltips
function DressUpStats.DUSPaperDollFrame_UpdateStats()
		--DressUpStats.PrntMsg(getglobal("DUSDDMS"));
		DressUpStats.DUSUpdatePaperdollStats("DUSPlayerStatFrameLeft", getglobal("DUSDDMS"));	
		DressUpStats.UpdateRightStats("DUSPlayerStatFrameRight", getglobal("DUSDDMS"));
end
--End Generic Update