--[[
DressUp Stats Estimated Stats LUA
Copyright 2008 Neer (Horde) of US-Cenarion Circle
Last Changed: 4/4/2008 10:27:43 AM
]]
--Player Estimated Health
function DressUpStats.GetEstHealth()
    if(DUS.Modi.health == 0)then
        DUS.Modi.health = DUS.Curr.health;
    else
    		DUS.Modi.health = (DUS.Est.sta * HEALTH_PER_STAMINA) + DUS.Curr.health;
    end
    DUSPlayerStatEstHealthLabel:SetText("Health:");
    if(DUS.Modi.health > DUS.Curr.health)then
        DUSPlayerStatEstHealthStatText:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.health..FONT_COLOR_CODE_CLOSE);
    elseif(DUS.Modi.health < DUS.Curr.health)then
        DUSPlayerStatEstHealthStatText:SetText(RED_FONT_COLOR_CODE..DUS.Modi.health..FONT_COLOR_CODE_CLOSE);
    else
        DUSPlayerStatEstHealthStatText:SetText(DUS.Modi.health);
    end
end
--End Player Estimated Health
--Player Estimated Mana
function DressUpStats.GetEstMana()
    local _, unitClass = UnitClass("player");
	unitClass = strupper(unitClass);
    if ( unitClass == "WARRIOR" or unitClass == "ROGUE" ) then
        return;
    else
    		if(DUS.Modi.mana == 0)then
        	DUS.Modi.mana = DUS.Curr.mana;
		    else
    			DUS.Modi.mana = (DUS.Est.int * MANA_PER_INTELLECT) + DUS.Curr.mana;
    		end
    		DUSPlayerStatEstManaLabel:SetText("Mana:");
    		if(DUS.Modi.mana > DUS.Curr.mana)then
        	DUSPlayerStatEstManaStatText:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.mana..FONT_COLOR_CODE_CLOSE);
    		elseif(DUS.Modi.mana < DUS.Curr.mana)then
        	DUSPlayerStatEstManaStatText:SetText(RED_FONT_COLOR_CODE..DUS.Modi.mana..FONT_COLOR_CODE_CLOSE);
    		else
        	DUSPlayerStatEstManaStatText:SetText(DUS.Modi.mana);
    		end
    end
end
--End Player Estimated Mana
--Estimated Armor
function DressUpFrame.SetArmorRight(statFrame,unit,stat,Mod,Curr)
	if ( not unit ) then
		unit = "player";
	end
	
	local statName = stat;
  local effectiveStat = 0;
    -- Set the tooltip text
	local tooltipText = HIGHLIGHT_FONT_COLOR_CODE..statName.." ";
    --DressUpStats.PrntMsg(Mod.." "..Curr);
	if (Mod == 0 or Mod == Curr) then
		tooltipText = tooltipText..Curr..FONT_COLOR_CODE_CLOSE;
    effectiveStat = Curr;
  elseif (Mod > Curr) then
    tooltipText = tooltipText..FONT_COLOR_CODE_CLOSE..GREEN_FONT_COLOR_CODE..Mod..FONT_COLOR_CODE_CLOSE;
    effectiveStat = Mod;
  elseif (Mod < Curr) then
    tooltipText = tooltipText..RED_FONT_COLOR_CODE..Mod..FONT_COLOR_CODE_CLOSE;
    effectiveStat = Mod;
	end
	
	statFrame.tooltip = tooltipText;
	local armorReduction = PaperDollFrame_GetArmorReduction(effectiveStat, UnitLevel(unit));
	statFrame.tooltip2 = format(DEFAULT_STATARMOR_TOOLTIP, armorReduction);

	--DressUpStats.PrntMsg(armorReduction.." "..effectiveStat);
	
	if ( unit == "player" ) then
		local petBonus = ComputePetBonus("PET_BONUS_ARMOR", effectiveStat );
		if( petBonus > 0 ) then
			statFrame.tooltip2 = statFrame.tooltip2 .. "\n" .. format(PET_BONUS_TOOLTIP_ARMOR, petBonus);
		end
	end
	
	statFrame:Show();
end
--End Estimated Armor
--Estimated Defense Calcs
function DressUpStats.SetEstDefense(statFrame, statlbl, unit)
	local DRBase = 1.5;
	local DefRatRatio,ModD = 0,0;
	local statTxt = nil;
	if ( not unit ) then
		unit = "player";
	end
	local base, modifier = UnitDefense(unit);
	local level = UnitLevel("player");
	if(modifier == 0)then
		if level >= 60 then
			DefRatRatio = DRBase *((-3/82)*level+(131/41));
		elseif level >= 10 then
			DefRatRatio = DRBase/((1/52)*level-(8/52));
		else
			DefRatRatio = DRBase/((1/52)*10-(8/52));
		end
	else
		DefRatRatio = DUS.Curr.defrat / modifier;
	end
	ModD = DUS.Modi.defrat / DefRatRatio;	
	--DressUpStats.PrntMsg(base.." "..modifier.." "..GetCombatRating(CR_DEFENSE_SKILL));
	--DressUpStats.PrntMsg(DUS.Curr.defrat.." "..DUS.Est.defrat.." "..DUS.Modi.defrat.." "..DefRatRatio.." "..ModD);
	ModD = floor(ModD);
	if(DUS.Modi.defrat > DUS.Curr.defrat)then
      statTxt = GREEN_FONT_COLOR_CODE..(base + ModD)..FONT_COLOR_CODE_CLOSE;
  elseif(DUS.Modi.defrat < DUS.Curr.defrat)then
      statTxt = RED_FONT_COLOR_CODE..(base + ModD)..FONT_COLOR_CODE_CLOSE;
  else
      statTxt = base + ModD;
  end
  statlbl:SetText(statTxt);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..DEFENSE.." "..statTxt..FONT_COLOR_CODE_CLOSE;
	local defensePercent = DressUpStats.GetDodgeBlockParryChanceFromDefense(base,ModD);
	DUS.Modi.defper = defensePercent;
	--DressUpStats.PrntMsg(defensePercent);
	statFrame.tooltip2 = format(DEFAULT_STATDEFENSE_TOOLTIP, DUS.Modi.defrat, ModD, defensePercent, defensePercent);
	statFrame:Show();
end

function DressUpStats.GetDodgeBlockParryChanceFromDefense(base,modifier)
	local defensePercent = DODGE_PARRY_BLOCK_PERCENT_PER_DEFENSE * ((base + modifier) - (UnitLevel("player")*5));
	defensePercent = max(defensePercent, 0);
	return defensePercent;
end

function DressUpStats.SetEstDodge(statFrame,statlbl)
	local DodRBase,DodRatRatio = 12,0;
	local level = UnitLevel("player");
	local chance = GetDodgeChance();
	local statTxt = nil;
	chance = chance + DUS.Modi.defper;
	
	if level >= 60 then
		DodRatRatio = DodRBase *((-3/82)*level+(131/41));
	elseif level >= 10 then
		DodRatRatio = DodRBase/((1/52)*level-(8/52));
	else
		DodRatRatio = DodRBase/((1/52)*10-(8/52));
	end

	local ModD = DUS.Modi.dodrat / DodRatRatio;
	
	chance = chance + ModD;
	
	if(chance > DUS.Curr.dodper)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  elseif(chance < DUS.Curr.dodper)then
      statlbl:SetText(RED_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(format("%.2f%%", chance));
  end
  
  if(DUS.Modi.dodrat > DUS.Curr.dodrat)then
  		statTxt = GREEN_FONT_COLOR_CODE..DUS.Modi.dodrat..FONT_COLOR_CODE_CLOSE;
  elseif(DUS.Modi.dodrat < DUS.Curr.dodrat)then
      statTxt = RED_FONT_COLOR_CODE..DUS.Modi.dodrat..FONT_COLOR_CODE_CLOSE;
  else
      statTxt = DUS.Modi.dodrat;
  end
  --DressUpStats.PrntMsg(DUS.Curr.dodrat.." "..DodRatRatio.." "..DUS.Modi.dodrat.." "..DUS.Est.dodrat);
  --DressUpStats.PrntMsg(DodRatRatio.." "..ModD);
	--PaperDollFrame_SetLabelAndText(statFrame, STAT_DODGE, chance, 1);
	crDodge = BonusScanner:GetRatingBonus('DODGE', DUS.Modi.dodrat, UnitLevel("player"));
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..getglobal("COMBAT_RATING_NAME"..CR_DODGE).." "..statTxt..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(CR_DODGE_TOOLTIP, ModD, crDodge);
	statFrame:Show();
end

function DressUpStats.SetEstParry(statFrame,statlbl)
	local ParRBase,ParRatRatio = 15,0;
	local level = UnitLevel("player");
	local chance = GetParryChance();
	local statTxt = nil;
	
	chance = chance + DUS.Modi.defper;
	
	if level >= 60 then
		ParRatRatio = ParRBase *((-3/82)*level+(131/41));
	elseif level >= 10 then
		ParRatRatio = ParRBase/((1/52)*level-(8/52));
	else
		ParRatRatio = ParRBase/((1/52)*10-(8/52));
	end

	local ModP = DUS.Modi.parrat / ParRatRatio;
	
	chance = chance + ModP;
	
	if(chance > DUS.Curr.parper)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  elseif(chance < DUS.Curr.parper)then
      statlbl:SetText(RED_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(format("%.2f%%", chance));
  end
  
  if(DUS.Modi.parrat > DUS.Curr.parrat)then
  		statTxt = GREEN_FONT_COLOR_CODE..DUS.Modi.parrat..FONT_COLOR_CODE_CLOSE;
  elseif(DUS.Modi.parrat < DUS.Curr.parrat)then
      statTxt = RED_FONT_COLOR_CODE..DUS.Modi.parrat..FONT_COLOR_CODE_CLOSE;
  else
      statTxt = DUS.Modi.parrat;
  end
  
	crParry = BonusScanner:GetRatingBonus('PARRY', DUS.Modi.parrat, UnitLevel("player"));
	--DressUpStats.PrntMsg(DUS.Curr.parrat.." "..ParRatRatio.." "..DUS.Modi.parrat.." "..DUS.Est.parrat);
  --DressUpStats.PrntMsg(ParRatRatio.." "..ModP);
	--PaperDollFrame_SetLabelAndText(statFrame, STAT_PARRY, chance, 1);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..getglobal("COMBAT_RATING_NAME"..CR_PARRY).." "..statTxt..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(CR_PARRY_TOOLTIP, ModP, crParry);
	statFrame:Show();
end

function DressUpStats.SetEstBlock(statFrame,statlbl)
	local chance = GetBlockChance();
	local BlkRBase,BlkRatRatio = 5,0;
	local level = UnitLevel("player");
	local statTxt = nil;
	local bv = DUS.Modi.blkval + ((DUS.Modi.str / 20) - 1);
	
	chance = chance + DUS.Modi.defper;
	
	if level >= 60 then
		BlkRatRatio = BlkRBase *((-3/82)*level+(131/41));
	elseif level >= 10 then
		BlkRatRatio = BlkRBase/((1/52)*level-(8/52));
	else
		BlkRatRatio = BlkRBase/((1/52)*10-(8/52));
	end

	local ModD = DUS.Modi.blkrat / BlkRatRatio;
	
	chance = chance + ModD;
	
	if(chance > DUS.Curr.blkper)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  elseif(chance < DUS.Curr.blkper)then
      statlbl:SetText(RED_FONT_COLOR_CODE..format("%.2f%%", chance)..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(format("%.2f%%", chance));
  end
	
	if(DUS.Modi.blkrat > DUS.Curr.blkrat)then
  		statTxt = GREEN_FONT_COLOR_CODE..DUS.Modi.blkrat..FONT_COLOR_CODE_CLOSE;
  elseif(DUS.Modi.blkrat < DUS.Curr.blkrat)then
      statTxt = RED_FONT_COLOR_CODE..DUS.Modi.blkrat..FONT_COLOR_CODE_CLOSE;
  else
      statTxt = DUS.Modi.blkrat;
  end
	
	crBlock = BonusScanner:GetRatingBonus('BLOCK', DUS.Modi.blkrat, UnitLevel("player"));
	--PaperDollFrame_SetLabelAndText(statFrame, STAT_BLOCK, chance, 1);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..getglobal("COMBAT_RATING_NAME"..CR_BLOCK).." "..statTxt..FONT_COLOR_CODE_CLOSE;
	--statFrame.tooltip2 = format(CR_BLOCK_TOOLTIP, ModD, GetShieldBlock());
	statFrame.tooltip2 = format(CR_BLOCK_TOOLTIP, ModD, crBlock, bv);
	statFrame:Show();
end

function DressUpStats.SetEstResilience(statFrame,statlbl)
	local MRBase,RRBase,SRBase = 10,10,8;
	local melee,ranged,spell = 0,0,0;
	--local mbonus,rbonus,sbonus = 0,0,0;
	local level = UnitLevel("player");
	local statTxt = nil;
	
	if level >= 60 then
		melee = MRBase *((-3/82)*level+(131/41));
		ranged = RRBase *((-3/82)*level+(131/41));
		spell = SRBase *((-3/82)*level+(131/41));
	elseif level >= 10 then
		melee = MRBase *((-3/82)*level+(131/41));
		ranged = RRBase *((-3/82)*level+(131/41));
		spell = SRBase *((-3/82)*level+(131/41));
	else
		melee = MRBase *((-3/82)*level+(131/41));
		ranged = RRBase *((-3/82)*level+(131/41));
		spell = SRBase *((-3/82)*level+(131/41));
	end

	local minResilience = min(melee, ranged);
	minResilience = min(minResilience, spell);
	
	local ModD = DUS.Modi.resrat / minResilience;
	local minBonus = ModD / 39.4;
	
	if(DUS.Modi.resrat > DUS.Curr.resrat)then
  		statTxt = GREEN_FONT_COLOR_CODE..DUS.Modi.resrat..FONT_COLOR_CODE_CLOSE;
  elseif(DUS.Modi.resrat < DUS.Curr.resrat)then
      statTxt = RED_FONT_COLOR_CODE..DUS.Modi.resrat..FONT_COLOR_CODE_CLOSE;
  else
      statTxt = DUS.Modi.resrat;
  end

	statlbl:SetText(statTxt);
	--PaperDollFrame_SetLabelAndText(statFrame, STAT_RESILIENCE, minResilience);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..STAT_RESILIENCE.." "..statTxt..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(RESILIENCE_TOOLTIP, minBonus, min(minBonus * 2, 25.00), minBonus);
	--statFrame.tooltip2 = format(RESILIENCE_TOOLTIP, minBonus, minBonus * 2, 25.00, minBonus);
	
	statFrame:Show();
end
--End Estimated Defense Calcs
--Begin Estimated Spell Calcs
function DressUpStats.SetEstManaRegen(statFrame,statlbl)
	local base,casting,regen,regenOld = 0,0,0,0;
	
	if ( not UnitHasMana("player") ) then
		text:SetText(NOT_APPLICABLE);
		statFrame.tooltip = nil;
		return;
	end
	
	local MRPS = GetUnitManaRegenRateFromSpirit("player") / DUS.Curr.spi;
	regenOld = DUS.Curr.spi * MRPS;
	regen = DUS.Modi.spi * MRPS;
	regen = floor(regen * 5.0);
	regenOld = floor(regenOld * 5.0);
	
	--DressUpStats.PrntMsg(DUS.pClass.." "..DUS.Modi.spi.." "..DUS.Modi.manareg.." "..DUS.Curr.manareg.." "..regen.." "..regenOld);
	if(DUS.Modi.manareg == 0)then
		DUS.Modi.manareg = DUS.Curr.manareg;
		base = floor(DUS.Modi.manareg);
	elseif(DUS.Modi.manareg < 0)then
		base = DUS.Curr.manareg + DUS.Modi.manareg;		
	else
		base = floor(DUS.Modi.manareg + (regen - regenOld));
	end
	casting = floor(base * 0.1);
	
	if(base > DUS.Curr.manareg)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..base..FONT_COLOR_CODE_CLOSE);
  elseif(base < DUS.Curr.manareg)then
      statlbl:SetText(RED_FONT_COLOR_CODE..base..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(base);
  end
	
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE .. MANA_REGEN .. FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(MANA_REGEN_TOOLTIP, base, casting);
	statFrame:Show();
end

function DressUpStats.SetEstSpellCritChance(statFrame,statlbl)
	--local crchance = DUS.Modi.spcrit / 22.1;
	local crBaseChance = DUS.Curr.spcrit / 22.1;
	local minCrit = 0;
	local CFI = GetSpellCritChanceFromIntellect("player") / DUS.Curr.int;
	local baseChance = DUS.Curr.int * CFI;
	local chance = DUS.Modi.int * CFI;
	local perDiff = chance - baseChance;
	local spDiff = DUS.Curr.spcrit + DUS.Est.spcrit;
	
	--DressUpStats.PrntMsg(DUS.Curr.spcrit.." "..DUS.Est.spcrit.." "..DUS.Modi.spcrit.." "..chance.." "..baseChance.." "..perDiff.." "..spDiff);
	statFrame:SetScript("OnEnter", DressUpStats.EstCharacterSpellCritChance_OnEnter);
	crchance = (spDiff / 22.1) + perDiff;
	
	DUS.Modi.spholycrit = DUS.Curr.spholycrit + crchance - crBaseChance;
	DUS.Modi.spfirecrit = DUS.Curr.spfirecrit + crchance - crBaseChance;
	DUS.Modi.spnaturecrit = DUS.Curr.spnaturecrit + crchance - crBaseChance;
	DUS.Modi.spfrostcrit = DUS.Curr.spfrostcrit + crchance - crBaseChance;
	DUS.Modi.spshadowcrit = DUS.Curr.spshadowcrit + crchance - crBaseChance;
	DUS.Modi.sparcanecrit = DUS.Curr.sparcanecrit + crchance - crBaseChance;
	--DressUpStats.PrntMsg(DUS.Modi.spholycrit.." "..DUS.Curr.spholycrit.." "..crchance);
	minCrit = DUS.Modi.spholycrit;
	minCrit = min(minCrit,DUS.Modi.spfirecrit);
	minCrit = min(minCrit,DUS.Modi.spnaturecrit);
	minCrit = min(minCrit,DUS.Modi.spfrostcrit);
	minCrit = min(minCrit,DUS.Modi.spshadowcrit);
	minCrit = min(minCrit,DUS.Modi.sparcanecrit);
	if(minCrit > DUS.Curr.minspcrit)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..format("%.2f%%", minCrit)..FONT_COLOR_CODE_CLOSE);
  elseif(minCrit < DUS.Curr.minspcrit)then
      statlbl:SetText(RED_FONT_COLOR_CODE..format("%.2f%%", minCrit)..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(format("%.2f%%", minCrit));
  end
	statFrame.minCrit = minCrit;
	statFrame:Show();
end

function DressUpStats.EstCharacterSpellCritChance_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	local cr = DUS.Modi.spcrit;
	if(DUS.Est.spcrit == 0)then
		cr = DUS.Curr.spcrit;
	elseif(DUS.Est.spcrit < 0)then
		cr = 0;
	else
		cr = DUS.Curr.spcrit + DUS.Est.spcrit;
	end
	GameTooltip:SetText(HIGHLIGHT_FONT_COLOR_CODE..COMBAT_RATING_NAME11.." "..cr..FONT_COLOR_CODE_CLOSE);
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL2"), format("%.2f", DUS.Modi.spholycrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon2");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL3"), format("%.2f", DUS.Modi.spfirecrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon3");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL4"), format("%.2f", DUS.Modi.spnaturecrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon4");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL5"), format("%.2f", DUS.Modi.spfrostcrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon5");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL6"), format("%.2f", DUS.Modi.spshadowcrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon6");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL7"), format("%.2f", DUS.Modi.sparcanecrit).."%", NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon7");
	GameTooltip:Show();
end

function DressUpStats.SetEstSpellPenetration(statFrame,statlbl)
	if(DUS.Modi.sppen > DUS.Curr.sppen)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.sppen..FONT_COLOR_CODE_CLOSE);
  elseif(DUS.Modi.sppen < DUS.Curr.sppen)then
      statlbl:SetText(RED_FONT_COLOR_CODE..DUS.Modi.sppen..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(DUS.Modi.sppen);
  end
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE .. SPELL_PENETRATION .. FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = SPELL_PENETRATION_TOOLTIP;
	statFrame:Show();
end

function DressUpStats.SetEstSpellHaste(statFrame,statlbl)
	if(DUS.Modi.sphaste > DUS.Curr.sphaste)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.sphaste..FONT_COLOR_CODE_CLOSE);
  elseif(DUS.Modi.sphaste < DUS.Curr.sphaste)then
      statlbl:SetText(RED_FONT_COLOR_CODE..DUS.Modi.sphaste..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(DUS.Modi.sphaste);
  end
  crSpHaste = BonusScanner:GetRatingBonus('SPELLH', DUS.Modi.sphaste, UnitLevel("player"));
	--getglobal(statFrame:GetName().."Label"):SetText(SPELL_HASTE..":");
	--local text = getglobal(statFrame:GetName().."StatText");
	--DUS.Curr.sphaste = GetCombatRating(CR_HASTE_SPELL);
	--text:SetText(DUS.Curr.sphaste);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE .. SPELL_HASTE .. FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(SPELL_HASTE_TOOLTIP, crSpHaste);
	statFrame:Show();
end

function DressUpStats.SetEstSpellBonusHealing(statFrame,statlbl)
	local hTot = DUS.Curr.spheal + DUS.Est.spheal;
	--DressUpStats.PrntMsg(DUS.Curr.spheal.." "..DUS.Est.spheal.." "..DUS.Modi.spheal);
	if(hTot > DUS.Curr.spheal)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..hTot..FONT_COLOR_CODE_CLOSE);
  elseif(hTot < DUS.Curr.spheal)then
      statlbl:SetText(RED_FONT_COLOR_CODE..hTot..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(hTot);
  end
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE .. BONUS_HEALING .. FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 =format(BONUS_HEALING_TOOLTIP, hTot);
	statFrame:Show();
end

function DressUpStats.SetEstSpellHit(statFrame,statlbl)
	local sphit = DUS.Curr.sphit + DUS.Est.sphit;
	local pLvl = UnitLevel("player");
	local spHBase60,spHBase70,spBonus,modSHR = 8,12.62,0,0;
	if(sphit < 0)then
		sphit = 0;
	end
	
	if pLvl >= 60 then
		modSHR = sphit / spHBase70;
	else
		modSHR = sphit / spHBase60;
	end
	
	--DressUpStats.PrntMsg(DUS.Curr.sphit.." "..DUS.Est.sphit.." "..DUS.Modi.sphit.." "..modSHR);
	if(sphit > DUS.Curr.sphit)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..sphit..FONT_COLOR_CODE_CLOSE);
  elseif(sphit < DUS.Curr.sphit)then
      statlbl:SetText(RED_FONT_COLOR_CODE..sphit..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(sphit);
  end

	--crSpHit = BonusScanner:GetRatingBonus('PARRY', DUS.Modi.parrat, UnitLevel("player"));
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..COMBAT_RATING_NAME8.." "..sphit..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(CR_HIT_SPELL_TOOLTIP, pLvl, modSHR, DUS.Modi.sppen, DUS.Modi.sppen);
	--statFrame.tooltip2 = format(CR_HIT_SPELL_TOOLTIP, UnitLevel("player"), ratingBonus, GetSpellPenetration(), GetSpellPenetration());
	statFrame:Show();
end

function DressUpStats.SetEstSpellBonusDamage(statFrame,statlbl)
	local dmgDiff = 0;
	statFrame:SetScript("OnEnter", DressUpStats.EstCharacterSpellBonusDamage_OnEnter);
	--DressUpStats.PrntMsg(DUS.Modi.spdmg.." "..DUS.Est.spdmg);
	DUS.Modi.spholydmg = DUS.Curr.spholydmg + DUS.Est.spdmg + DUS.Est.spholydmg;
	DUS.Modi.spfiredmg = DUS.Curr.spfiredmg + DUS.Est.spdmg + DUS.Est.spfiredmg;
	DUS.Modi.spnaturedmg = DUS.Curr.spnaturedmg + DUS.Est.spdmg + DUS.Est.spnaturedmg;
	DUS.Modi.spfrostdmg = DUS.Curr.spfrostdmg + DUS.Est.spdmg + DUS.Est.spfrostdmg;
	DUS.Modi.spshadowdmg = DUS.Curr.spshadowdmg + DUS.Est.spdmg + DUS.Est.spshadowdmg;
	DUS.Modi.sparcanedmg = DUS.Curr.sparcanedmg + DUS.Est.spdmg + DUS.Est.sparcanedmg;
	
	local minModifier = DUS.Modi.spholydmg;
	minModifier = min(minModifier,DUS.Modi.spfiredmg);
	minModifier = min(minModifier,DUS.Modi.spnaturedmg);
	minModifier = min(minModifier,DUS.Modi.spfrostdmg);
	minModifier = min(minModifier,DUS.Modi.spshadowdmg);
	minModifier = min(minModifier,DUS.Modi.sparcanedmg);
	if(minModifier > DUS.Curr.minspdmg)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..minModifier..FONT_COLOR_CODE_CLOSE);
  elseif(minModifier < DUS.Curr.minspdmg)then
      statlbl:SetText(RED_FONT_COLOR_CODE..minModifier..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(minModifier);
  end
	DUS.Modi.spdmg = minModifier;
	statFrame.minModifier = minModifier;
	statFrame:Show();
end

function DressUpStats.EstCharacterSpellBonusDamage_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetText(HIGHLIGHT_FONT_COLOR_CODE..BONUS_DAMAGE.." "..DUS.Modi.spdmg..FONT_COLOR_CODE_CLOSE);
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL2"), DUS.Modi.spholydmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon2");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL3"), DUS.Modi.spfiredmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon3");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL4"), DUS.Modi.spnaturedmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon4");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL5"), DUS.Modi.spfrostdmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon5");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL6"), DUS.Modi.spshadowdmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon6");
	GameTooltip:AddDoubleLine(getglobal("DAMAGE_SCHOOL7"), DUS.Modi.sparcanedmg, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddTexture("Interface\\PaperDollInfoFrame\\SpellSchoolIcon7");
	GameTooltip:Show();
end
--End Estimated Spell Calcs

--Begin Estimated Melee Calcs
function DressUpStats.SetEstDamage(statFrame, statlbl)
	statFrame:SetScript("OnEnter", DressUpStats.EstCharacterDamageFrame_OnEnter);
	--if ( not unit ) then
	unit = "player";
	--end
	--getglobal(statFrame:GetName().."Label"):SetText(DAMAGE_COLON);
	--local text = getglobal(statFrame:GetName().."StatText");
	--local speed, offhandSpeed = UnitAttackSpeed(unit);
	if(DUS.Modi.MHspeed == nil)then
		DUS.Modi.MHspeed = DUS.Curr.MHspeed;
		DUS.Modi.MHld, DUS.Modi.MHhd = DUS.Curr.MHld,DUS.Curr.MHhd;
	end
	local speed, offhandSpeed = DUS.Modi.MHspeed, DUS.Modi.OHspeed;
	
	local minDamage;
	local maxDamage; 
	local minOffHandDamage;
	local maxOffHandDamage; 
	local physicalBonusPos;
	local physicalBonusNeg;
	local percent;
	minDamage, maxDamage, minOffHandDamage, maxOffHandDamage, physicalBonusPos, physicalBonusNeg, percent = UnitDamage(unit);
	--minDamage, maxDamage, minOffHandDamage, maxOffHandDamage = DUS.MHld, DUS.MHhd, DUS.OHld, DUS.OHhd;
	physicalBonusPos = DUS.Modi.mdmg;
	if(DUS.Modi.MHld == DUS.Curr.MHld)then
		minDamage = DUS.Curr.MHld;
		maxDamage = DUS.Curr.MHhd;
	else
		minDamage = (((DUS.Modi.MHld / DUS.Modi.MHspeed) + (1102 / 12.4)) * (DUS.Modi.MHspeed)) + physicalBonusPos + physicalBonusNeg;
		maxDamage = (((DUS.Modi.MHhd / DUS.Modi.MHspeed) + (1102 / 12.05)) * (DUS.Modi.MHspeed)) + physicalBonusPos + physicalBonusNeg;
	end
	
	--minOffHandDamage = (((DUS.Modi.OHld / DUS.Modi.OHspeed) + (1102 / 14)) * (DUS.Modi.OHspeed)) * 0.5;
	--maxOffHandDamage = (((DUS.Modi.OHhd / DUS.Modi.OHspeed) + (1102 / 14)) * (DUS.Modi.OHspeed)) * 0.5;
	local displayMin = max(floor(minDamage),1);
	local displayMax = max(ceil(maxDamage),1);

	minDamage = (minDamage / percent) - physicalBonusPos - physicalBonusNeg;
	maxDamage = (maxDamage / percent) - physicalBonusPos - physicalBonusNeg;

	local baseDamage = (minDamage + maxDamage) * 0.5;
	local fullDamage = (baseDamage + physicalBonusPos + physicalBonusNeg) * percent;
	local totalBonus = (fullDamage - baseDamage);
	local damagePerSecond = (max(fullDamage,1) / speed);
	local damageTooltip = max(floor(minDamage),1).." - "..max(ceil(maxDamage),1);
	
	local colorPos = "|cff20ff20";
	local colorNeg = "|cffff2020";

	-- epsilon check
	if ( totalBonus < 0.1 ) then
		totalBonus = 0.0;
	end

	if ( totalBonus == 0 ) then
		if ( ( displayMin < 100 ) and ( displayMax < 100 ) ) then 
			statlbl:SetText(displayMin.." - "..displayMax);	
		else
			statlbl:SetText(displayMin.."-"..displayMax);
		end
	else
		
		local color;
		if ( totalBonus > 0 ) then
			color = colorPos;
		else
			color = colorNeg;
		end
		if ( ( displayMin < 100 ) and ( displayMax < 100 ) ) then 
			statlbl:SetText(color..displayMin.." - "..displayMax.."|r");	
		else
			statlbl:SetText(color..displayMin.."-"..displayMax.."|r");
		end
		if ( physicalBonusPos > 0 ) then
			damageTooltip = damageTooltip..colorPos.." +"..physicalBonusPos.."|r";
		end
		if ( physicalBonusNeg < 0 ) then
			damageTooltip = damageTooltip..colorNeg.." "..physicalBonusNeg.."|r";
		end
		if ( percent > 1 ) then
			damageTooltip = damageTooltip..colorPos.." x"..floor(percent*100+0.5).."%|r";
		elseif ( percent < 1 ) then
			damageTooltip = damageTooltip..colorNeg.." x"..floor(percent*100+0.5).."%|r";
		end
		
	end
	statFrame.damage = damageTooltip;
	statFrame.attackSpeed = speed;
	statFrame.dps = damagePerSecond;
	
	-- If there's an offhand speed then add the offhand info to the tooltip
	if ( offhandSpeed ) then
		minOffHandDamage = (minOffHandDamage / percent) - physicalBonusPos - physicalBonusNeg;
		maxOffHandDamage = (maxOffHandDamage / percent) - physicalBonusPos - physicalBonusNeg;

		local offhandBaseDamage = (minOffHandDamage + maxOffHandDamage) * 0.5;
		local offhandFullDamage = (offhandBaseDamage + physicalBonusPos + physicalBonusNeg) * percent;
		local offhandDamagePerSecond = (max(offhandFullDamage,1) / offhandSpeed);
		local offhandDamageTooltip = max(floor(minOffHandDamage),1).." - "..max(ceil(maxOffHandDamage),1);
		if ( physicalBonusPos > 0 ) then
			offhandDamageTooltip = offhandDamageTooltip..colorPos.." +"..physicalBonusPos.."|r";
		end
		if ( physicalBonusNeg < 0 ) then
			offhandDamageTooltip = offhandDamageTooltip..colorNeg.." "..physicalBonusNeg.."|r";
		end
		if ( percent > 1 ) then
			offhandDamageTooltip = offhandDamageTooltip..colorPos.." x"..floor(percent*100+0.5).."%|r";
		elseif ( percent < 1 ) then
			offhandDamageTooltip = offhandDamageTooltip..colorNeg.." x"..floor(percent*100+0.5).."%|r";
		end
		statFrame.offhandDamage = offhandDamageTooltip;
		statFrame.offhandAttackSpeed = offhandSpeed;
		statFrame.offhandDps = offhandDamagePerSecond;
	else
		statFrame.offhandAttackSpeed = nil;
	end
	statFrame:Show();
end
function DressUpStats.EstCharacterDamageFrame_OnEnter()
	-- Main hand weapon
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetText(INVTYPE_WEAPONMAINHAND, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
	GameTooltip:AddDoubleLine(ATTACK_SPEED_COLON, format("%.2f", this.attackSpeed), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddDoubleLine(DAMAGE_COLON, this.damage, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	GameTooltip:AddDoubleLine(DAMAGE_PER_SECOND, format("%.1f", this.dps), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	-- Check for offhand weapon
	if ( this.offhandAttackSpeed ) then
		GameTooltip:AddLine("\n");
		GameTooltip:AddLine(INVTYPE_WEAPONOFFHAND, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddDoubleLine(ATTACK_SPEED_COLON, format("%.2f", this.offhandAttackSpeed), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
		GameTooltip:AddDoubleLine(DAMAGE_COLON, this.offhandDamage, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
		GameTooltip:AddDoubleLine(DAMAGE_PER_SECOND, format("%.1f", this.offhandDps), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	end
	GameTooltip:Show();
end

function DressUpStats.SetEstAttackSpeed(statFrame, statlbl)
	local speed, offhandSpeed, haste = DUS.Modi.MHspeed, DUS.Modi.OHspeed, 0;
	haste = BonusScanner:GetRatingBonus('HASTE', DUS.Modi.mhaste, UnitLevel("player"));
	local speedBonus = (1 + (haste / 100));
	speed = speed / speedBonus;
	speed = format("%.2f", speed);
	
	if ( offhandSpeed ) then
		offhandSpeed = format("%.2f", offhandSpeed);
	end
	local text;	
	if ( offhandSpeed ) then
		text = speed.." / "..offhandSpeed;
	else
		text = speed;
	end
	--PaperDollFrame_SetLabelAndText(statFrame, WEAPON_SPEED, text);
	statlbl:SetText(text);

	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..ATTACK_SPEED.." "..text..FONT_COLOR_CODE_CLOSE;
	--statFrame.tooltip2 = format(CR_HASTE_RATING_TOOLTIP, GetCombatRating(CR_HASTE_MELEE), GetCombatRatingBonus(CR_HASTE_MELEE));
	statFrame.tooltip2 = format(CR_HASTE_RATING_TOOLTIP, DUS.Modi.mhaste, haste);
	
	statFrame:Show();
end

function DressUpStats.SetEstAttackPower(statFrame, statlbl)
	--if ( not unit ) then
		unit = "player";
	--end	
	local localizedClass, englishClass = UnitClass(unit);
	--getglobal(statFrame:GetName().."Label"):SetText(ATTACK_POWER_COLON);
	local text = getglobal(statFrame:GetName().."StatText");
	--local base, posBuff, negBuff = UnitAttackPower(unit);
	local base,posBuff,negBuff = 0,DUS.Modi.ap,0;
	--DUS.Curr.ap = base+posBuff+negBuff;
	if(englishClass == "WARRIOR" or englishClass == "PALADIN")then
		base = ((DUS.Modi.str * 2) + (UnitLevel(unit) * 3) - 20);
	end
	
	
	
	
	PaperDollFormatStat(MELEE_ATTACK_POWER, base, posBuff, negBuff, statFrame, text);
	--statlbl:SetText(text);
	statFrame.tooltip2 = format(MELEE_ATTACK_POWER_TOOLTIP, max((base+posBuff+negBuff), 0)/ATTACK_POWER_MAGIC_NUMBER);
	statFrame:Show();
end

function DressUpStats.SetEstMeleeHit(statFrame,statlbl)
	if(DUS.Modi.mhit > DUS.Curr.mhit)then
      statlbl:SetText(GREEN_FONT_COLOR_CODE..DUS.Modi.mhit..FONT_COLOR_CODE_CLOSE);
  elseif(DUS.Modi.mhit < DUS.Curr.mhit)then
      statlbl:SetText(RED_FONT_COLOR_CODE..DUS.Modi.mhit..FONT_COLOR_CODE_CLOSE);
  else
      statlbl:SetText(DUS.Modi.mhit);
  end
  
  crMHit = BonusScanner:GetRatingBonus('TOHIT', DUS.Modi.mhit, UnitLevel("player"));
  statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..COMBAT_RATING_NAME6.." "..DUS.Modi.mhit..FONT_COLOR_CODE_CLOSE;
  statFrame.tooltip2 = format(CR_HIT_MELEE_TOOLTIP, UnitLevel("player"), crMHit, DUS.Modi.apen);
  statFrame:Show();
end

function DressUpStats.SetEstMeleeCritChance(statFrame, statlbl)
	local crMCrit = BonusScanner:GetRatingBonus('CRIT', DUS.Modi.mcrit, UnitLevel("player"));
	local curCrit = DUS.Curr.mcritBase + BonusScanner:GetRatingBonus('CRIT', DUS.Curr.mcrit, UnitLevel("player"));
	local modCrit = DUS.Curr.mcritBase + crMCrit;
	if(modCrit > curCrit)then
			modCrit = format("%.2f%%", modCrit);
      statlbl:SetText(GREEN_FONT_COLOR_CODE..modCrit..FONT_COLOR_CODE_CLOSE);
  elseif(modCrit < curCrit)then
  		modCrit = format("%.2f%%", modCrit);
      statlbl:SetText(RED_FONT_COLOR_CODE..modCrit..FONT_COLOR_CODE_CLOSE);
  else
  		modCrit = format("%.2f%%", modCrit);
      statlbl:SetText(modCrit);
  end
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..MELEE_CRIT_CHANCE.." "..modCrit..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(CR_CRIT_MELEE_TOOLTIP, DUS.Modi.mcrit, crMCrit);
	statFrame:Show();
end

function DressUpStats.SetEstExpertise(statFrame, statlbl)
	local CurrBonus = BonusScanner:GetRatingBonus('EXPERTISE', DUS.Curr.mexpr, UnitLevel("player"));
	local Baseexpertise = GetExpertise() - CurrBonus;
	local exprBonus = BonusScanner:GetRatingBonus('EXPERTISE', DUS.Modi.mexpr, UnitLevel("player"));
	local expertise = floor(Baseexpertise + exprBonus);
	local expPer = expertise * 0.25;
	expPer = format("%.2f", expPer);
	PaperDollFrame_SetLabelAndText(statFrame, STAT_EXPERTISE, expertise);
	statFrame.tooltip = HIGHLIGHT_FONT_COLOR_CODE..getglobal("COMBAT_RATING_NAME"..CR_EXPERTISE).." "..expertise..FONT_COLOR_CODE_CLOSE;
	statFrame.tooltip2 = format(CR_EXPERTISE_TOOLTIP, expPer, expertise, exprBonus);
	statFrame:Show();
end
--End Estimated Melee Calcs