local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	editbox = { --controls a table
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this.self:Set(this.setting,string.lower(text),nil)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Removed from list: ",text)
				this:SetText("")
			end
		end,
		OnEnterPressed = function()
			local text = this:GetText()
			if not (text == "") then
				this.self:Set(this.setting,string.lower(text),1)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Added to list: ",text)
				this:SetText("")
			end
		end,
		OnEnter = function()
			if this.tooltipText then
				local text = this.tooltipText
				for index,value in pairs(this.self:Get(this.setting)) do
					text = text.."\n"..index
				end
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
				GameTooltip:SetText(text, nil, nil, nil, nil, 1);
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
}

local barmsgcodes = {
	["%s"] = "spell name",
	["%r"] = "spell rank",
	["%d"] = "time remaining",
	["%c"] = "spell count (number of applications)",
	["%t"] = "spell's target",
	["%l"] = "target's level",
}

local sortingtable = {}
local function sorttable(pretable)
	for index,value in pairs(sortingtable) do sortingtable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sortingtable,index) end
	table.sort(sortingtable)
	return sortingtable
end

local types = {
	["Harmful"] = "debuff",
	["Helpful"] = "buff",
	["No Target"] = "notarget",
}

local orderedtypes = {
	"Harmful",
	"Helpful",
	"No Target",
}

local category

local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 4 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = Prominence:Get("colors",category,subcat,value,"r") or 1
			info.g = Prominence:Get("colors",category,subcat,value,"g") or 1
			info.b = Prominence:Get("colors",category,subcat,value,"b") or 1
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				Prominence:Set("colors",category,subcat,value,"r",r)
				Prominence:Set("colors",category,subcat,value,"g",g)
				Prominence:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not Prominence:Get("colors",category,subcat,v) then
						Prominence:Set("colors",category,subcat,v,"r",r)
						Prominence:Set("colors",category,subcat,v,"g",g)
						Prominence:Set("colors",category,subcat,v,"b",b)
					end
				end
				Prominence:UpdateSettings()
			end
			DropDownLib:AddButton(info,4)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 3 then
		if category == "timer" then
			local entries = Prominence:AcquireTable()
			local tab = DROPDOWNLIB_MENU_VALUE
			for i = 1,GetNumSpellTabs() do
				local name,_,offset,numspells = GetSpellTabInfo(i)
				if name == tab then
					for id = offset + 1,offset + numspells do
						local spell = GetSpellName(id,BOOKTYPE_SPELL)
						entries[spell] = 1
					end
					break
				end
			end
			entries = sorttable(entries)
			for index,value in ipairs(entries) do
				info = DropDownLib:GetTable()
				info.text = value
				local checked
				if Prominence:Get("colors","timer",value) then checked = 1 end
				info.checked = checked
				info.value = value
				info.hasArrow = 1
				info.func = function() 
					if checked then 
						Prominence:Set("colors","timer",value,nil) 
						Prominence:UpdateSettings()
					end 
				end
				DropDownLib:AddButton(info,3)
			end
		elseif category == "type" then
			local subcat = DROPDOWNLIB_MENU_VALUE
			for index,value in ipairs({"begin","half","final"}) do
				info = DropDownLib:GetTable()
				info.text = value
				info.notCheckable = 1
				info.hasColorSwatch = 1
				info.r = Prominence:Get("colors",category,subcat,value,"r") or Prominence:GetTimerData()[subcat].colors[value]["r"]
				info.g = Prominence:Get("colors",category,subcat,value,"g") or Prominence:GetTimerData()[subcat].colors[value]["g"]
				info.b = Prominence:Get("colors",category,subcat,value,"b") or Prominence:GetTimerData()[subcat].colors[value]["b"]
				info.swatchFunc = function()
					local r,g,b = DropDownLibColorPicker:GetColorRGB()
					Prominence:Set("colors",category,subcat,value,"r",r)
					Prominence:Set("colors",category,subcat,value,"g",g)
					Prominence:Set("colors",category,subcat,value,"b",b)
					for i,v in ipairs({"begin","half","final"}) do
						if not Prominence:Get("colors",category,subcat,v) then
							Prominence:Set("colors",category,subcat,v,"r",Prominence:GetTimerData()[subcat].colors[v]["r"])
							Prominence:Set("colors",category,subcat,v,"g",Prominence:GetTimerData()[subcat].colors[v]["g"])
							Prominence:Set("colors",category,subcat,v,"b",Prominence:GetTimerData()[subcat].colors[v]["b"])
						end
					end
					Prominence:UpdateSettings()
				end
				DropDownLib:AddButton(info,3)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		category = DROPDOWNLIB_MENU_VALUE
		if category == "timer" then
			for i = 1,GetNumSpellTabs() do
				local name = GetSpellTabInfo(i)
				info = DropDownLib:GetTable()
				info.text = name
				info.value = name
				info.hasArrow = 1
				info.notCheckable = 1
				DropDownLib:AddButton(info,2)
			end
		elseif category == "type" then
			for index,value in ipairs(orderedtypes) do
				info = DropDownLib:GetTable()
				info.text = value
				local timertype = types[value]
				local checked
				if Prominence:Get("colors","type",timertype) then checked = 1 end
				info.checked = checked
				info.value = timertype
				info.hasArrow = 1
				info.func = function() 
					if checked then 
						Prominence:Set("colors","type",timertype,nil) 
						Prominence:UpdateSettings()
					end 
				end
				DropDownLib:AddButton(info,2)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		info = DropDownLib:GetTable()
		info.text = "Specific Timer"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "timer"
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "Timer Type"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "type"
		DropDownLib:AddButton(info,1)
	end
end

local guitable = {
	title = "Prominence Timer Settings",
	name = "ProminenceMenuFrame",
	{ --column 1
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Turns the addon on or off, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "status",
			},
		},
		{
			title = "Tooltips",
			type = "checkbutton",
			tooltiptext = "Determines if tooltips will be shown when you mouse over timers, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "tooltips",
			},
		},
		{
			title = "Tracked Timers",
			type = "editbox",
			tooltiptext = "Sets which timers from DoTimer are shown in Prominence.  Press ENTER after typing in a name to add it to the list, or ESCAPE to remove it.  \n\nCurrent List:",
			scripts = scripts.editbox,
			data = {
				setting = "tracked",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() Prominence:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of specific timers and timer types.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
	},
	{ --column 2
		{
			title = "Reset",
			type = "button",
			tooltiptext = "Resets all settings to their default value.",
			buffer = 10,
			scripts = {
				OnClick = function() 
					this.self:ClearSettings() 
					ProminenceMenuFrame:Hide()
					ProminenceMenuFrame:Show()
				end,
			},
		},
		{
			title = "Author Info",
			type = "button",
			tooltiptext = "Prints in the chat frame information about the current version and about the author.",
			buffer = 10,
			scripts = {
				OnClick = function() Prominence:AddAuthorInfo() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		"BREAK",
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() this.self:ShowTimerGUI(barmsgcodes,nil,nil,"Hidden Timers","Hide All","Hidden Types","Max Targets") end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function Prominence:ShowGUI()
	if not ProminenceMenuFrame then
		Prominence:CreateGUI(guitable)
	end
	ProminenceMenuFrame:Show()
end