Prominence = AsheylaLib:NewModule("Prominence","TimerLib","SpellLib","GUILib","KBLib","TimerLibGUI")

local defaultsettings

function Prominence:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
end

function Prominence:OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then self:Startup() -- when you first log in
	elseif self:HasRegisteredSettings() and self:Get("status") then
		
	end
end

function Prominence:Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	ProfileLib:RegisterForProfiles(self)
	self:MakeSlashCmd("/prominence","/prom")
	self:CreateTimerInstance()
	self:SetScript("OnDragClick",function(arg1) 
		Prominence:ProcessClick("Drag Icon",arg1)
	end)
	self:SetClickAction("Drag Icon","Addon Info",function()
		Prominence:Print("This is the |cff00ffffProminence|r anchor.  Access |cff00ffffProminence|r's menu by typing '|cff00ff00/prom|r'.  Hide me by checking the '|cff00ff00Locked|r' checkbutton in the menu.")
	end)
	self:SetClickAction("Drag Icon","Remove All Timers",function()
		Prominence:RemoveAllTimers()
	end)
	self:SetScript("OnTargetClick",function(i,module,arg1) 
		DoTimer:ProcessClick("Target",arg1,i,module)
	end)
	self:SetScript("OnTimerClick",function(i,id,module,arg1)
		DoTimer:ProcessClick("Timer",arg1,i,id,module)
	end)
	self:SetScript("OnTimerEnter",function(i,id,module,this) 
		DoTimer:CreateTimerTooltip(module:GetTimer(i,id),this) 
	end)
	Prominence:Hook(DoTimer,"AddTimer","pre",function(self,t,d,suppress,module)
		if self:Get("status") and t and type(t) == "number" and d and Prominence:Get("tracked",string.lower(d.spell)) then
			local targetlayout = self:Get("targetlayout")
			local movetarget = self:Get("movetargetname")
			local timer = Prominence:AcquireTable(1)
			Prominence:PasteTable(timer,d)
			timer.stack = 0
			timer.realtimer = d
			local tar = DoTimer:GetTarget(t)
			local i = Prominence:ReturnTargetTable(tar.target,tar.sex,tar.level)
			if not i then
				local target = Prominence:AcquireTable(1)
				target.target = tar.target
				target.sex = tar.sex
				target.level = tar.level
				target.icon = tar.icon
				target.text = (self:Get("levels") and "["..tar.level.."] " or "")..((movetarget and (targetlayout == "up" or targetlayout == "down")) and tar.target or string.gsub(tar.target," ","\n"))
				i = Prominence:AddTarget(target)
			end
			Prominence:AddTimer(i,timer)
		end
	end)
	Prominence:Hook(Prominence,"UpdateTimers","pre",function(self)
		local removed,refresh
		for i = self:GetNumTargets(),1,-1 do
			local target = self:GetTarget(i)
			for id = self:GetNumTimers(i),1,-1 do
				local timer = self:GetTimer(i,id)
				if timer.realtimer then
					if not timer.realtimer.exists then self:RemoveTimer(i,id,"noexists",1) removed = true 
					else
						if not (timer.time == timer.realtimer.time) then
							timer.time = timer.realtimer.time
							timer.displayed = nil
							refresh = true
						end
						if not (timer.duration == timer.realtimer.duration) then
							timer.duration = timer.realtimer.duration
							timer.displayed = nil
							refresh = true
						end
					end
				end
			end
		end
		if removed or refresh then self:CreateInterface(refresh) end
	end)
	this:UnregisterEvent("PLAYER_ENTERING_WORLD")
end

function Prominence:Commands() --governs the /command
	self:ShowGUI()
end

defaultsettings = {
	tracked = {},
	keybindings = {
		["Drag Icon"] = {
			["Addon Info"] = "1",
			["Remove All Timers"] = "2",
		},
	},
	locked = true,
	status = false,
}
