local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	editbox = { --controls a table
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this.self:Set(this.setting,string.lower(text),nil)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Removed from list: ",text)
				this:SetText("")
			end
		end,
		OnEnterPressed = function()
			local text = this:GetText()
			if not (text == "") then
				this.self:Set(this.setting,string.lower(text),1)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Added to list: ",text)
				this:SetText("")
			end
		end,
		OnEnter = function()
			if this.tooltipText then
				local text = this.tooltipText
				for index,value in pairs(this.self:Get(this.setting)) do
					text = text.."\n"..index
				end
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
				GameTooltip:SetText(text, nil, nil, nil, nil, 1);
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
	dropdown2 = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.self:Get(this.setting))
		end,
	},
}

local barmsgcodes = {
	["%s"] = "spell name",
	["%r"] = "spell rank",
	["%d"] = "time remaining",
	["%c"] = "spell count (number of applications)",
}

local sortingtable = {}
local function sorttable(pretable)
	for index,value in pairs(sortingtable) do sortingtable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sortingtable,index) end
	table.sort(sortingtable)
	return sortingtable
end

local types = {
	["Standard Deuff"] = "debuff",
	["Standard Deuff (No Duration)"] = "debuffnoexp",
	["Dispel Type: None"] = "None",
	["Dispel Type: Magic"] = "Magic",
	["Dispel Type: Curse"] = "Curse",
	["Dispel Type: Disease"] = "Disease",
	["Dispel Type: Poison"] = "Poison",
}

local orderedtypes = {
	"Standard Debuff",
	"Standard Debuff (No Duration)",
	"Dispel Type: None",
	"Dispel Type: Magic",
	"Dispel Type: Curse",
	"Dispel Type: Disease",
	"Dispel Type: Poison",
}

local function dropdown(self,frame,setting,values)
	local info
	for index,value in ipairs(values) do
		info = DropDownLib:GetTable()
		info.text = value
		info.checked = (self:Get(setting) == value) and 1
		info.func = function() 
			self:Set(setting,value) 
			self:UpdateSettings() 
			getglobal(frame:GetName().."Text"):SetText(value)
			DropDownLib:CloseDropDownMenus()
		end
		DropDownLib:AddButton(info,1)
	end
end

local function otherdropdown(self)
	local frame = this:GetParent()
	if frame.setting and frame.values then 
		dropdown(self,frame,frame.setting,frame.values) 
	end
end


local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	local category = "type"
	if DROPDOWNLIB_MENU_LEVEL == 3 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = PlayerDebuffs:Get("colors",category,subcat,value,"r") or 1
			info.g = PlayerDebuffs:Get("colors",category,subcat,value,"g") or 1
			info.b = PlayerDebuffs:Get("colors",category,subcat,value,"b") or 1
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				PlayerDebuffs:Set("colors",category,subcat,value,"r",r)
				PlayerDebuffs:Set("colors",category,subcat,value,"g",g)
				PlayerDebuffs:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not PlayerDebuffs:Get("colors",category,subcat,v) then
						PlayerDebuffs:Set("colors",category,subcat,v,"r",r)
						PlayerDebuffs:Set("colors",category,subcat,v,"g",g)
						PlayerDebuffs:Set("colors",category,subcat,v,"b",b)
					end
				end
				PlayerDebuffs:UpdateSettings()
			end
			DropDownLib:AddButton(info)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = PlayerDebuffs:Get("colors",category,subcat,value,"r") or PlayerDebuffs:GetTimerData()[subcat].colors[value]["r"]
			info.g = PlayerDebuffs:Get("colors",category,subcat,value,"g") or PlayerDebuffs:GetTimerData()[subcat].colors[value]["g"]
			info.b = PlayerDebuffs:Get("colors",category,subcat,value,"b") or PlayerDebuffs:GetTimerData()[subcat].colors[value]["b"]
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				PlayerDebuffs:Set("colors",category,subcat,value,"r",r)
				PlayerDebuffs:Set("colors",category,subcat,value,"g",g)
				PlayerDebuffs:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not PlayerDebuffs:Get("colors",category,subcat,v) then
						PlayerDebuffs:Set("colors",category,subcat,v,"r",PlayerDebuffs:GetTimerData()[subcat].colors[v]["r"])
						PlayerDebuffs:Set("colors",category,subcat,v,"g",PlayerDebuffs:GetTimerData()[subcat].colors[v]["g"])
						PlayerDebuffs:Set("colors",category,subcat,v,"b",PlayerDebuffs:GetTimerData()[subcat].colors[v]["b"])
					end
				end
				PlayerDebuffs:UpdateSettings()
			end
			DropDownLib:AddButton(info)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		for index,value in ipairs(orderedtypes) do
			info = DropDownLib:GetTable()
			info.text = value
			local timertype = types[value]
			local checked
			if PlayerDebuffs:Get("colors","type",timertype) then checked = 1 end
			info.checked = checked
			info.value = timertype
			info.hasArrow = 1
			info.func = function() 
				if checked then 
					PlayerDebuffs:Set("colors","type",timertype,nil) 
					PlayerDebuffs:UpdateSettings()
				end 
			end
			DropDownLib:AddButton(info)
		end
	end
end

local guitable = {
	title = "PlayerDebuffs Timer Settings",
	name = "PlayerDebuffsMenuFrame",
	{ --column 1
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Turns the addon on or off, default state: on.",
			scripts = scripts.checkbutton,
			overridescripts = {
				OnClick = function()
					if this:GetChecked() then
						PlayerDebuffs:Set("status",true)
						PlayerBuffs:Set("status",true)
					else
						PlayerDebuffs:Set("status",false)
						PlayerBuffs:Set("status",false)
					end
					PlayerDebuffs:UpdateSettings()
					PlayerBuffs:UpdateSettings()
				end,
			},
			data = {
				setting = "status",
			},
		},
		{
			title = "Tooltips",
			type = "checkbutton",
			tooltiptext = "Determines if tooltips will be shown when you mouse over timers, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "tooltips",
			},
		},
		{
			title = "Integrated",
			type = "checkbutton",
			tooltiptext = "Determines if the timers are integrated into PlayerBuffs, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "integrated",
			},
		},
		{
			title = "Dispel Types",
			type = "checkbutton",
			tooltiptext = "Determines if debuff timers with a duration will be sorted and colored by their dispel type, or all treated as the same, default state: true.",
			scripts = scripts.checkbutton,
			data = {
				setting = "dispeltypes",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() PlayerDebuffs:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of timer types.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Priority 1",
			type = "dropdown",
			tooltiptext = "Sets the top priority level for timers.  Note that 'none' will make all lower levels ignored.  Sorting is determined by first the timer's priority level, then the sorting method.",
			func = function() otherdropdown(PlayerDebuffs) end,
			scripts = scripts.dropdown2,
			data = {
				setting = "priority1",
				values = {"none","Standard Debuff / Dispel Type","No Duration"},
			},
		},
		{
			title = "Priority 2",
			type = "dropdown",
			tooltiptext = "Sets the bottom priority level for timers.  Note that 'none' will make all lower levels ignored.  Sorting is determined by first the timer's priority level, then the sorting method.",
			func = function() otherdropdown(PlayerDebuffs) end,
			scripts = scripts.dropdown2,
			data = {
				setting = "priority2",
				values = {"none","Standard Debuff / Dispel Type","No Duration"},
			},
		},
		{
			title = "No Duration",
			type = "editbox",
			tooltiptext = "Sets which timers that actually have a duration are instead flagged as having no duration, so that less attention can be paid to them.  Press ENTER after typing in a name to add it to the list, or ESCAPE to remove it.  \n\nCurrent List:",
			scripts = scripts.editbox,
			data = {
				setting = "flagnoexp",
			},
		},
		{
			title = "Chat Msg",
			type = "editbox",
			tooltiptext = [[
				Allows you to customize the chat message sent when left-clicking a timer.

				Valid formatting codes:
				%s: spell name
				%r: spell rank
				%d: time remaining

				Normal: %s,%r,%d
				No Expiration: %s,%r

				Prefix with one of [normal,noexpire] followed by a ":" to set the msg for that type.
				Example: "normal: My %s will expire in %d."
				
				Press ENTER when finished typing.
				
				Current strings:]],
			scripts = scripts.editbox2,
			overridescripts = {
				OnEnterPressed = function() 
					local text = this:GetText()
					if not (text == "") then 
						local _,_,output,msg = string.find(text,"(%a+)%:%s?(.+)")
						if output then 
							output = string.lower(output)
							PlayerDebuffs:Set("chatmsg"..output,msg)
							this:SetText("") 
							PlayerDebuffs:Print("|cff00ffffPlayerDebuffs|r: ",output," chat msg set to: ",msg)
						else
							PlayerDebuffs:Print("|cff00ffffPlayerDebuffs|r: Setting failed being set. (Reason: unable to parse)")
						end
					end
				end,
				OnEnter = function() 
					if this.tooltipText then
						local text = this.tooltipText
						text = text.."\nNormal: "..PlayerDebuffs:Get("chatmsgnormal")
						text = text.."\nNo Expiration: "..PlayerDebuffs:Get("chatmsgnoexpire")
						GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
						GameTooltip:SetText(text, nil, nil, nil, nil, 1);
					end
				end,
			},
		},
	},
	{ --column 2
		{
			title = "Reset",
			type = "button",
			tooltiptext = "Resets all settings to their default value.",
			buffer = 10,
			scripts = {
				OnClick = function() 
					this.self:ClearSettings() 
					PlayerDebuffsMenuFrame:Hide()
					PlayerDebuffsMenuFrame:Show()
				end,
			},
		},
		{
			title = "Author Info",
			type = "button",
			tooltiptext = "Prints in the chat frame information about the current version and about the author.",
			buffer = 10,
			scripts = {
				OnClick = function() PlayerDebuffs:AddAuthorInfo() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		"BREAK",
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() this.self:ShowTimerGUI(barmsgcodes,nil,nil,"Hidden Types","Max Targets","Target Sorting") end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function PlayerDebuffs:ShowGUI()
	if not PlayerDebuffsMenuFrame then
		PlayerDebuffs:CreateGUI(guitable)
	end
	PlayerDebuffsMenuFrame:Show()
end
