PlayerDebuffs = AsheylaLib:NewModule("PlayerDebuffs","TimerLib","SpellLib","GUILib","KBLib","TimerLibGUI")

local defaultsettings

local bufftarget = {
	target = "Debuffs",
	text = "Debuffs",
	sex = 0,
	level = 0,
	icon = 0,
	type = "player",
	priority = 0,
	norepeat = 1,
}

local priorityvalues = {
	["debuff"] = 0,
	["None"] = 0,
	["Magic"] = 1,
	["Curse"] = 2,
	["Disease"] = 3,
	["Poison"] = 4,
}

function PlayerDebuffs:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
end

function PlayerDebuffs:OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then self:Startup() -- when you first log in
	elseif self:HasRegisteredSettings() and self:Get("status") then
		self:ScanDebuffs()
	end
end

function PlayerDebuffs:ToggleBlizzFrames()
	if self:Get("status") then
		BuffFrame:Hide()
		TemporaryEnchantFrame:Hide()
		self:ScanDebuffs()
	else
		BuffFrame:Show()
		TemporaryEnchantFrame:Show()
	end
end

function PlayerDebuffs:CheckModule()
	local oldmodule = (self:Get("integrated") and self or PlayerBuffs)
	local newmodule = (self:Get("integrated") and PlayerBuffs or self)
	if oldmodule then
		local i = oldmodule:ReturnTargetTable("Debuffs",0,0,self)
		if i then
			local targettable = {}
			self:PasteTable(targettable,bufftarget)
			targettable.module = self
			if not (newmodule == self) then targettable.priority = 1 end
			local targetindex = newmodule:AddTarget(targettable,nil,self)
			for id = 1,oldmodule:GetNumTimers(i) do
				local timer = oldmodule:GetTimer(i,id)
				local entry = self:AcquireTable(1)
				entry.spell = timer.spell
				entry.rank = timer.rank
				entry.texture = timer.texture
				entry.duration = timer.duration
				entry.time = timer.time
				entry.type = timer.type
				entry.infotype = timer.infotype
				entry.infoid = timer.infoid
				entry.english = timer.english
				entry.index = timer.index
				entry.timeadded = 0
				newmodule:AddTimer(targetindex,entry,1,self)
			end
			oldmodule:RemoveTarget(i) 
		end
	end
	local i = newmodule:ReturnTargetTable("Debuffs",0,0,self)
	if i then
		for id = 1,newmodule:GetNumTimers(i) do
			local timer = newmodule:GetTimer(i,id)
			if timer.module == self then
				timer.type = ((self:Get("dispeltypes") and GetPlayerBuffDispelType(timer.index)) or ((timer.duration == 0 or self:Get("flagnoexp",string.lower(timer.spell))) and "debuffnoexp") or "debuff")
				timer.priority = self:GetPriority(timer.type)
			end
		end
	end
	newmodule:CreateInterface(1)
end

function PlayerDebuffs:Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	ProfileLib:RegisterForProfiles(self)
	self:AddSettingsUpdateScript(function() PlayerDebuffs:ToggleBlizzFrames() end)
	self:AddSettingsUpdateScript(function() PlayerDebuffs:CheckModule() end)
	self:MakeSlashCmd("/PlayerDebuffs","/pd")
	self:CreateTimerInstance()
	self:SetScript("OnDragClick",function(arg1) 
		PlayerDebuffs:ProcessClick("Drag Icon",arg1)
	end)
	self:SetClickAction("Drag Icon","Addon Info",function()
		PlayerDebuffs:Print("This is the |cff00ffffPlayerDebuffs|r anchor.  Access |cff00ffffPlayerDebuffs|r's menu by typing '|cff00ff00/pd|r'.  Hide me by checking the '|cff00ff00Locked|r' checkbutton in the menu.")
	end)
	self:SetScript("OnTimerClick",function(i,id,module,arg1)
		PlayerDebuffs:ProcessClick("Timer",arg1,i,id,module)
	end)
	self:SetClickAction("Timer","Announce",function(i,id,module)
		PlayerDebuffs:ToChat(module:GetTimer(i,id))
	end)
	self:SetClickAction("Timer","Hide",function(i,id,module)
		local timer = module:GetTimer(i,id)
		local frame = StaticPopup_Show("PlayerDebuffs",timer.spell)
		frame.data = timer
		frame.data2 = module
	end)
	self:SetScript("OnTimerEnter",function(i,id,module,this) 
		self:CreateTimerTooltip(module:GetTimer(i,id),this) 
	end)
	StaticPopupDialogs["PlayerDebuffs"] = {
		text = "Are you sure you want to hide the timer for %s?",
		button1 = "Yes",
		button2 = "No",
		OnAccept = function(timer,module) timer.module:Set("hidden",string.lower(timer.spell),1); module:UpdateSettings() end,
		whileDead = 1,
		hideOnEscape = 1,
		timeout = 0,
	}
	PlayerDebuffs:CreateTimerGroup(
		"debuffnoexp",true,false,false,true,.5,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			final = {
				r = .2,
				g = 1.0,
				b = .2,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"debuff",true,true,true,true,1,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = 1.0,
				g = 1.0,
				b = .2,
			},
			final = {
				r = 1.0,
				g = .2,
				b = .2,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"Magic",true,true,true,true,1,{
			begin = {
				r = .2,
				g = .6,
				b = 1.0,
			},
			half = {
				r = .2,
				g = .6,
				b = 1.0,
			},
			final = {
				r = .2,
				g = .6,
				b = 1.0,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"Curse",true,true,true,true,1,{
			begin = {
				r = .6,
				g = 0.0,
				b = 1.0,
			},
			half = {
				r = .6,
				g = 0.0,
				b = 1.0,
			},
			final = {
				r = .6,
				g = 0.0,
				b = 1.0,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"Disease",true,true,true,true,1,{
			begin = {
				r = .6,
				g = .4,
				b = 0.0,
			},
			half = {
				r = .6,
				g = .4,
				b = 0.0,
			},
			final = {
				r = .6,
				g = .4,
				b = 0.0,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"Poison",true,true,true,true,1,{
			begin = {
				r = 0.0,
				g = .6,
				b = 0.0,
			},
			half = {
				r = 0.0,
				g = .6,
				b = 0.0,
			},
			final = {
				r = 0.0,
				g = .6,
				b = 0.0,
			},
		}
	)
	PlayerDebuffs:CreateTimerGroup(
		"None",true,true,true,true,1,{
			begin = {
				r = .8,
				g = 0.0,
				b = 0.0,
			},
			half = {
				r = .8,
				g = 0.0,
				b = 0.0,
			},
			final = {
				r = .8,
				g = 0.0,
				b = 0.0,
			},
		}
	)
	self:Hook(self,"UpdateTimers","post",function()
		local time = GetTime()
		local refresh
		for i = 1,self:GetNumTargets() do
			for id = 1,self:GetNumTimers(i) do
				local timer = self:GetTimer(i,id)
				if not timer.finished then
					local timeleft = GetPlayerBuffTimeLeft(timer.index)
					if not (math.abs((timer.duration - time + timer.time) - timeleft) <= .1) then
						timer.time = time
						timer.duration = timeleft
						timer.displayed = nil
						refresh = true
					end
				end
			end
		end
		if refresh then self:CreateInterface() end
	end)
	this:UnregisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("PLAYER_AURAS_CHANGED")
end

function PlayerDebuffs:ScanDebuffs()
	local timertable
	local refresh
	local targettable
	local module = self:Get("integrated") and PlayerBuffs or self
	local targetindex = module:ReturnTargetTable("Debuffs",0,0)
	if targetindex then
		for id = 1,module:GetNumTimers(targetindex) do
			local timer = module:GetTimer(targetindex,id)
			if timer.module == self then
				timer.validated = nil
			end
		end
		targettable = module:GetTarget(targetindex)
	end
	local i = 1
	local buff = GetPlayerBuff(i,"HARMFUL")
	while buff > 0 do
		local name,rank = GetPlayerBuffName(buff)
		local timeleft = GetPlayerBuffTimeLeft(buff)
		local count = GetPlayerBuffApplications(buff)
		local adding = true
		local timertype = (timeleft == 0 and "debuffnoexp" or "debuff")
		local dispeltype = GetPlayerBuffDispelType(buff)
		if timertype == "debuff" and self:Get("dispeltypes") then timertype = dispeltype or "None" end
		if targetindex then
			for id = 1,module:GetNumTimers(targetindex) do
				local timer = module:GetTimer(targetindex,id)
				if timer.spell == name and timer.module == self and timer.type == timertype then
					timer.validated = true
					timer.index = buff
					self:ResetTimerFlags(timer)
					adding = false
					if not (math.abs((timer.duration - GetTime() + timer.time) - timeleft) <= .1) then
						timer.time = GetTime()
						timer.duration = timeleft
						timer.displayed = nil
						refresh = true
					end
					if not (count == timer.stack) then
						timer.stack = count
					end
					break
				end
			end
		end
		if adding then
			if not targettable then
				targettable = self:AcquireTable(1)
				self:PasteTable(targettable,bufftarget)
				targettable.module = self
				if not (module == self) then targettable.priority = 1 end
			end
			local spelltable = self:AcquireTable(1)
			spelltable.spell = name
			spelltable.rank = rank
			spelltable.texture = GetPlayerBuffTexture(buff)
			spelltable.duration = timeleft
			spelltable.time = GetTime()
			spelltable.type = timertype
			spelltable.stack = count
			spelltable.validated = true
			spelltable.index = buff
			spelltable.priority = self:GetPriority(timertype)
			if not timertable then timertable = self:AcquireTable() end
			table.insert(timertable,spelltable)
		end
		i = i + 1
		buff = GetPlayerBuff(i,"HARMFUL")
	end
	if targetindex then
		for id = module:GetNumTimers(targetindex),1,-1 do
			local timer = module:GetTimer(targetindex,id)
			if timer then
				if timer.module == self and not timer.validated then
					refresh = true
					module:RemoveTimer(targetindex,id,"broke",1)
				end
			end
		end
		if timertable then
			for i,v in ipairs(timertable) do 
				module:AddTimer(targetindex,v,1,self) 
			end
			local flag = refresh
			refresh = false
			module:CreateInterface(flag)
		end
	elseif targettable then 
		targetindex = module:AddTarget(targettable,nil,self)
		for i,v in ipairs(timertable) do
			module:AddTimer(targetindex,v,1,self) 
		end
		local flag = refresh
		refresh = false
		module:CreateInterface(flag)
	end
	if refresh then module:CreateInterface(1) end
end

function PlayerDebuffs:CreateTimerTooltip(d,frame)
	if self:Get("tooltips") and d.index then
		GameTooltip:SetOwner(frame,"ANCHOR_RIGHT")
		GameTooltip:SetPlayerBuff(d.index)
		GameTooltip:AddLine(" ",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Announce").." to announce.",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Hide").." to hide.",1,1,1,1)
		GameTooltip:Show()
	end
end

local chatsubentries = {}
function PlayerDebuffs:ToChat(d)
	for i,v in pairs(chatsubentries) do chatsubentries[i] = nil end
	local displayed = d.displayed
	local spell = d.spell
	local rank = d.rank
	if (spell and rank) then
		local unsubbedmsg
		if d.type == "debuffnoexp" then
			chatsubentries["%s"] = spell
			chatsubentries["%r"] = rank
			unsubbedmsg = self:Get("chatmsgnoexpire")	
		else
			displayed = self:ReturnFormattedDuration(displayed)
			chatsubentries["%d"] = displayed
			chatsubentries["%s"] = spell
			chatsubentries["%r"] = rank
			unsubbedmsg = self:Get("chatmsgnormal")
		end
		local chat = "SAY"
		if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
		local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return chatsubentries[a] or "" end)
		msg = string.gsub(msg,"%(%)","")
		SendChatMessage(msg,chat)
	end
end

function PlayerDebuffs:GetPriority(type)
	local p1 = self:Get("priority1")
	local p2 = self:Get("priority2")
	if p1 == "none" then return 0 
	elseif p1 == "No Duration" and type == "debuffnoexp" then return 0
	elseif p1 == "Standard Debuff / Dispel Type" and priorityvalues[type] then return priorityvalues[type]
	elseif p2 == "none" then return 5
	elseif p2 == "No Duration" and type == "debuffnoexp" then return 5
	elseif p2 == "Standard Debuff / Dispel Type" and priorityvalues[type] then return (priorityvalues[type] + 1)
	else return 6 --should never hit this.
	end
end

function PlayerDebuffs:Commands() --governs the /command
	self:ShowGUI()
end

defaultsettings = {
	tooltips = true,
	chatmsgnormal = "My %s will fade in %d.",
	chatmsgnoexpire = "I currently have the '%s' debuff.",
	keybindings = {
		["Drag Icon"] = {
			["Addon Info"] = "1",
		},
		["Timer"] = {
			["Announce"] = "1",
			["Hide"] = "s-2",
		},
	},
	integrated = true,
	dispeltypes = true,
	flagnoexp = {},
	priority1 = "none", --valid strings: "none", "Standard Debuff / Dispel Type", or "No Duration"
	priority2 = "none",
	locked = true,
	status = false,
	raidicons = false,
}
