local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	editbox = { --controls a table
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this.self:Set(this.setting,string.lower(text),nil)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Removed from list: ",text)
				this:SetText("")
			end
		end,
		OnEnterPressed = function()
			local text = this:GetText()
			if not (text == "") then
				this.self:Set(this.setting,string.lower(text),1)
				this.self:UpdateSettings()
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Added to list: ",text)
				this:SetText("")
			end
		end,
		OnEnter = function()
			if this.tooltipText then
				local text = this.tooltipText
				for index,value in pairs(this.self:Get(this.setting)) do
					text = text.."\n"..index
				end
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
				GameTooltip:SetText(text, nil, nil, nil, nil, 1);
			end
		end,
	},
	editbox2 = { --left blank, OnEnterPressed and OnEnter will be defined elsewhere
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
	dropdown2 = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.self:Get(this.setting))
		end,
	},
}

local barmsgcodes = {
	["%s"] = "spell name",
	["%r"] = "spell rank",
	["%d"] = "time remaining",
	["%c"] = "spell count (number of applications)",
}

local sortingtable = {}
local function sorttable(pretable)
	for index,value in pairs(sortingtable) do sortingtable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sortingtable,index) end
	table.sort(sortingtable)
	return sortingtable
end

local types = {
	["Weapon Enchant"] = "enchant",
	["Weapon Enchant (No Duration)"] = "enchantnoexp",
	["Standard Buff"] = "buff",
	["Standard Buff (No Duration)"] = "buffnoexp",
}

local orderedtypes = {
	"Standard Buff",
	"Standard Buff (No Duration)",
	"Weapon Enchant",
	"Weapon Enchant (No Duration)",
}

local function dropdown(self,frame,setting,values)
	local info
	for index,value in ipairs(values) do
		info = DropDownLib:GetTable()
		info.text = value
		info.checked = (self:Get(setting) == value) and 1
		info.func = function() 
			self:Set(setting,value) 
			self:UpdateSettings() 
			getglobal(frame:GetName().."Text"):SetText(value)
			DropDownLib:CloseDropDownMenus()
		end
		DropDownLib:AddButton(info,1)
	end
end

local function otherdropdown(self)
	local frame = this:GetParent()
	if frame.setting and frame.values then 
		dropdown(self,frame,frame.setting,frame.values) 
	end 
end

local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	local category = "type"
	if DROPDOWNLIB_MENU_LEVEL == 3 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = PlayerBuffs:Get("colors",category,subcat,value,"r") or 1
			info.g = PlayerBuffs:Get("colors",category,subcat,value,"g") or 1
			info.b = PlayerBuffs:Get("colors",category,subcat,value,"b") or 1
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				PlayerBuffs:Set("colors",category,subcat,value,"r",r)
				PlayerBuffs:Set("colors",category,subcat,value,"g",g)
				PlayerBuffs:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not PlayerBuffs:Get("colors",category,subcat,v) then
						PlayerBuffs:Set("colors",category,subcat,v,"r",r)
						PlayerBuffs:Set("colors",category,subcat,v,"g",g)
						PlayerBuffs:Set("colors",category,subcat,v,"b",b)
					end
				end
				PlayerBuffs:UpdateSettings()
			end
			DropDownLib:AddButton(info)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		if category == "type" then
			local subcat = DROPDOWNLIB_MENU_VALUE
			for index,value in ipairs({"begin","half","final"}) do
				info = DropDownLib:GetTable()
				info.text = value
				info.notCheckable = 1
				info.hasColorSwatch = 1
				info.r = PlayerBuffs:Get("colors",category,subcat,value,"r") or PlayerBuffs:GetTimerData()[subcat].colors[value]["r"]
				info.g = PlayerBuffs:Get("colors",category,subcat,value,"g") or PlayerBuffs:GetTimerData()[subcat].colors[value]["g"]
				info.b = PlayerBuffs:Get("colors",category,subcat,value,"b") or PlayerBuffs:GetTimerData()[subcat].colors[value]["b"]
				info.swatchFunc = function()
					local r,g,b = DropDownLibColorPicker:GetColorRGB()
					PlayerBuffs:Set("colors",category,subcat,value,"r",r)
					PlayerBuffs:Set("colors",category,subcat,value,"g",g)
					PlayerBuffs:Set("colors",category,subcat,value,"b",b)
					for i,v in ipairs({"begin","half","final"}) do
						if not PlayerBuffs:Get("colors",category,subcat,v) then
							PlayerBuffs:Set("colors",category,subcat,v,"r",PlayerBuffs:GetTimerData()[subcat].colors[v]["r"])
							PlayerBuffs:Set("colors",category,subcat,v,"g",PlayerBuffs:GetTimerData()[subcat].colors[v]["g"])
							PlayerBuffs:Set("colors",category,subcat,v,"b",PlayerBuffs:GetTimerData()[subcat].colors[v]["b"])
						end
					end
					PlayerBuffs:UpdateSettings()
				end
				DropDownLib:AddButton(info)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		for index,value in ipairs(orderedtypes) do
			info = DropDownLib:GetTable()
			info.text = value
			local timertype = types[value]
			local checked
			if PlayerBuffs:Get("colors","type",timertype) then checked = 1 end
			info.checked = checked
			info.value = timertype
			info.hasArrow = 1
			info.func = function() 
				if checked then 
					PlayerBuffs:Set("colors","type",timertype,nil) 
					PlayerBuffs:UpdateSettings()
				end 
			end
			DropDownLib:AddButton(info)
		end
	end
end

local guitable = {
	title = "PlayerBuffs Timer Settings",
	name = "PlayerBuffsMenuFrame",
	{ --column 1
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Turns the addon on or off, default state: on.",
			scripts = scripts.checkbutton,
			overridescripts = {
				OnClick = function()
					if this:GetChecked() then
						PlayerBuffs:Set("status",true)
						PlayerDebuffs:Set("status",true)
					else
						PlayerBuffs:Set("status",false)
						PlayerDebuffs:Set("status",false)
					end
					PlayerBuffs:UpdateSettings()
					PlayerDebuffs:UpdateSettings()
				end,
			},
			data = {
				setting = "status",
			},
		},
		{
			title = "Tooltips",
			type = "checkbutton",
			tooltiptext = "Determines if tooltips will be shown when you mouse over timers, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "tooltips",
			},
		},
		{
			title = "Integrated",
			type = "checkbutton",
			tooltiptext = "Determines if the timers are integrated into PlayerDebuffs, default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "integrated",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() PlayerBuffs:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of timer types.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Priority 1",
			type = "dropdown",
			tooltiptext = "Sets the top priority level for timers.  Note that 'none' will make all lower levels ignored.  Sorting is determined by first the timer's priority level, then the sorting method.",
			func = function() otherdropdown(PlayerBuffs) end,
			scripts = scripts.dropdown2,
			data = {
				setting = "priority1",
				values = {"none","Standard Buff","No Duration","Weapon Enchant"},
			},
		},
		{
			title = "Priority 2",
			type = "dropdown",
			tooltiptext = "Sets the middle priority level for timers.  Note that 'none' will make all lower levels ignored.  Sorting is determined by first the timer's priority level, then the sorting method.",
			func = function() otherdropdown(PlayerBuffs) end,
			scripts = scripts.dropdown2,
			data = {
				setting = "priority2",
				values = {"none","Standard Buff","No Duration","Weapon Enchant"},
			},
		},
		{
			title = "Priority 3",
			type = "dropdown",
			tooltiptext = "Sets the bottom priority level for timers.  Note that 'none' will make all lower levels ignored.  Sorting is determined by first the timer's priority level, then the sorting method.",
			func = function() otherdropdown(PlayerBuffs) end,
			scripts = scripts.dropdown2,
			data = {
				setting = "priority3",
				values = {"none","Standard Buff","No Duration","Weapon Enchant"},
			},
		},
		{
			title = "No Duration",
			type = "editbox",
			tooltiptext = "Sets which timers that actually have a duration are instead flagged as having no duration, so that less attention can be paid to them.  Press ENTER after typing in a name to add it to the list, or ESCAPE to remove it.  \n\nCurrent List:",
			scripts = scripts.editbox,
			data = {
				setting = "flagnoexp",
			},
		},
		{
			title = "Chat Msg",
			type = "editbox",
			tooltiptext = [[
				Allows you to customize the chat message sent when left-clicking a timer.

				Valid formatting codes:
				%s: spell name
				%r: spell rank
				%d: time remaining

				Normal: %s,%r,%d
				No Expiration: %s,%r
				Weapon Enchant: %s,%r,%d

				Prefix with one of [normal,noexpire,wep] followed by a ":" to set the msg for that type.
				Example: "normal: My %s will expire in %d."
				
				Press ENTER when finished typing.
				
				Current strings:]],
			scripts = scripts.editbox2,
			overridescripts = {
				OnEnterPressed = function() 
					local text = this:GetText()
					if not (text == "") then 
						local _,_,output,msg = string.find(text,"(%a+)%:%s?(.+)")
						if output then 
							output = string.lower(output)
							PlayerBuffs:Set("chatmsg"..output,msg)
							PlayerBuffs:UpdateSettings()
							this:SetText("") 
							PlayerBuffs:Print("|cff00ffffPlayerBuffs|r: ",output," chat msg set to: ",msg)
						else
							PlayerBuffs:Print("|cff00ffffPlayerBuffs|r: Setting failed being set. (Reason: unable to parse)")
						end
					end
				end,
				OnEnter = function() 
					if this.tooltipText then
						local text = this.tooltipText
						text = text.."\nNormal: "..PlayerBuffs:Get("chatmsgnormal")
						text = text.."\nNo Expiration: "..PlayerBuffs:Get("chatmsgnoexpire")
						text = text.."\nWeapon Enchant: "..PlayerBuffs:Get("chatmsgwep")
						GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
						GameTooltip:SetText(text, nil, nil, nil, nil, 1);
					end
				end,
			},
		},
	},
	{ --column 2
		{
			title = "Reset",
			type = "button",
			tooltiptext = "Resets all settings to their default value.",
			buffer = 10,
			scripts = {
				OnClick = function() 
					this.self:ClearSettings() 
					PlayerBuffsMenuFrame:Hide()
					PlayerBuffsMenuFrame:Show()
				end,
			},
		},
		{
			title = "Author Info",
			type = "button",
			tooltiptext = "Prints in the chat frame information about the current version and about the author.",
			buffer = 10,
			scripts = {
				OnClick = function() PlayerBuffs:AddAuthorInfo() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		"BREAK",
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() this.self:ShowTimerGUI(barmsgcodes,nil,nil,"Hidden Types","Max Targets","Target Sorting") end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function PlayerBuffs:ShowGUI()
	if not PlayerBuffsMenuFrame then
		PlayerBuffs:CreateGUI(guitable)
	end
	PlayerBuffsMenuFrame:Show()
end
